/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.component.layout;

import java.io.Serializable;
import java.util.ArrayList;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIComponentBase;
import javax.faces.component.UIForm;
import javax.faces.component.html.HtmlPanelGroup;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ComponentSystemEvent;
import javax.faces.event.ListenerFor;
import javax.faces.event.PreRenderComponentEvent;
import org.primefaces.component.outputpanel.OutputPanel;
import org.primefaces.extensions.component.layout.Layout;
import org.primefaces.extensions.model.layout.LayoutOptions;

@ListenerFor(systemEventClass=PreRenderComponentEvent.class)
public class LayoutPane
extends UIComponentBase {
    public static final String COMPONENT_TYPE = "org.primefaces.extensions.component.LayoutPane";
    public static final String COMPONENT_FAMILY = "org.primefaces.extensions.component";
    private static final String DEFAULT_RENDERER = "org.primefaces.extensions.component.LayoutPaneRenderer";
    private static final String OPTIMIZED_PACKAGE = "org.primefaces.extensions.component.";
    private LayoutOptions options;

    public LayoutPane() {
        this.setRendererType(DEFAULT_RENDERER);
    }

    public String getFamily() {
        return COMPONENT_FAMILY;
    }

    public String getStyleHeader() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.styleHeader), null);
    }

    public void setStyleHeader(String styleHeader) {
        this.setAttribute(PropertyKeys.styleHeader, styleHeader);
    }

    public String getStyleClassHeader() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.styleClassHeader), null);
    }

    public void setStyleClassHeader(String styleClassHeader) {
        this.setAttribute(PropertyKeys.styleClassHeader, styleClassHeader);
    }

    public String getStyleContent() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.styleContent), null);
    }

    public void setStyleContent(String styleContent) {
        this.setAttribute(PropertyKeys.styleContent, styleContent);
    }

    public String getStyleClassContent() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.styleClassContent), null);
    }

    public void setStyleClassContent(String styleClassContent) {
        this.setAttribute(PropertyKeys.styleClassContent, styleClassContent);
    }

    public String getPosition() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.position), (Object)"center");
    }

    public void setPosition(String position) {
        this.setAttribute(PropertyKeys.position, position);
    }

    public String getCombinedPosition() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.combinedPosition), (Object)"center");
    }

    public void setCombinedPosition(String combinedPosition) {
        this.setAttribute(PropertyKeys.combinedPosition, combinedPosition);
    }

    public boolean isResizable() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.resizable), (Object)true);
    }

    public void setResizable(boolean resizable) {
        this.setAttribute(PropertyKeys.resizable, resizable);
    }

    public boolean isClosable() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.closable), (Object)true);
    }

    public void setClosable(boolean closable) {
        this.setAttribute(PropertyKeys.closable, closable);
    }

    public String getSize() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.size), null);
    }

    public void setSize(String size) {
        this.setAttribute(PropertyKeys.size, size);
    }

    public String getMinSize() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.minSize), null);
    }

    public void setMinSize(String minSize) {
        this.setAttribute(PropertyKeys.minSize, minSize);
    }

    public String getMaxSize() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.maxSize), null);
    }

    public void setMaxSize(String maxSize) {
        this.setAttribute(PropertyKeys.maxSize, maxSize);
    }

    public String getMinWidth() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.minWidth), null);
    }

    public void setMinWidth(String minWidth) {
        this.setAttribute(PropertyKeys.minWidth, minWidth);
    }

    public String getMaxWidth() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.maxWidth), null);
    }

    public void setMaxWidth(String maxWidth) {
        this.setAttribute(PropertyKeys.maxWidth, maxWidth);
    }

    public String getMinHeight() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.minHeight), null);
    }

    public void setMinHeight(String minHeight) {
        this.setAttribute(PropertyKeys.minHeight, minHeight);
    }

    public String getMaxHeight() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.maxHeight), null);
    }

    public void setMaxHeight(String maxHeight) {
        this.setAttribute(PropertyKeys.maxHeight, maxHeight);
    }

    public int getSpacing() {
        return (Integer)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.spacing), (Object)6);
    }

    public void setSpacing(int spacing) {
        this.setAttribute(PropertyKeys.spacing, spacing);
    }

    public boolean isInitClosed() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.initClosed), (Object)false);
    }

    public void setInitClosed(boolean initClosed) {
        this.setAttribute(PropertyKeys.initClosed, initClosed);
    }

    public boolean isInitHidden() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.initHidden), (Object)false);
    }

    public void setInitHidden(boolean initHidden) {
        this.setAttribute(PropertyKeys.initHidden, initHidden);
    }

    public boolean isResizeWhileDragging() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.resizeWhileDragging), (Object)false);
    }

    public void setResizeWhileDragging(boolean resizeWhileDragging) {
        this.setAttribute(PropertyKeys.resizeWhileDragging, resizeWhileDragging);
    }

    public void processEvent(ComponentSystemEvent event) throws AbortProcessingException {
        super.processEvent(event);
        if (!(event instanceof PreRenderComponentEvent) || !this.getLayout().isBuildOptions()) {
            return;
        }
        this.setOptions(this.getParent());
    }

    public LayoutOptions getOptions() {
        String maxHeight;
        String minHeight;
        String maxWidth;
        String minWidth;
        String maxSize;
        String minSize;
        if (this.options != null) {
            return this.options;
        }
        this.options = new LayoutOptions();
        this.options.addOption(PropertyKeys.resizable.toString(), this.isResizable());
        this.options.addOption(PropertyKeys.closable.toString(), this.isClosable());
        this.options.addOption(PropertyKeys.spacing.toString(), this.getSpacing());
        this.options.addOption(PropertyKeys.initClosed.toString(), this.isInitClosed());
        this.options.addOption(PropertyKeys.initHidden.toString(), this.isInitHidden());
        this.options.addOption(PropertyKeys.resizeWhileDragging.toString(), this.isResizeWhileDragging());
        String size = this.getSize();
        if (size != null) {
            this.options.addOption(PropertyKeys.size.toString(), size);
        }
        if ((minSize = this.getMinSize()) != null) {
            this.options.addOption(PropertyKeys.minSize.toString(), minSize);
        }
        if ((maxSize = this.getMaxSize()) != null) {
            this.options.addOption(PropertyKeys.maxSize.toString(), maxSize);
        }
        if ((minWidth = this.getMinWidth()) != null) {
            this.options.addOption(PropertyKeys.minWidth.toString(), minWidth);
        }
        if ((maxWidth = this.getMaxWidth()) != null) {
            this.options.addOption(PropertyKeys.maxWidth.toString(), maxWidth);
        }
        if ((minHeight = this.getMinHeight()) != null) {
            this.options.addOption(PropertyKeys.minHeight.toString(), minHeight);
        }
        if ((maxHeight = this.getMaxHeight()) != null) {
            this.options.addOption(PropertyKeys.maxHeight.toString(), maxHeight);
        }
        return this.options;
    }

    private void setOptions(UIComponent parent) {
        LayoutOptions options;
        String position = this.getPosition();
        LayoutOptions thisLayoutOptions = this.getOptions();
        if (parent instanceof LayoutPane) {
            LayoutOptions parentLayoutOptions = ((LayoutPane)parent).getOptions();
            options = parentLayoutOptions.getChildOptions();
            if (options == null) {
                options = new LayoutOptions();
                parentLayoutOptions.setChildOptions(options);
            }
        } else if (parent instanceof Layout) {
            options = (LayoutOptions)((Layout)parent).getOptions();
            if (options == null) {
                String togglerTipClosed;
                String togglerTipOpen;
                Layout layout = (Layout)parent;
                options = new LayoutOptions();
                layout.setOptions(options);
                LayoutOptions panes = null;
                String resizerTip = layout.getResizerTip();
                if (resizerTip != null) {
                    panes = new LayoutOptions();
                    panes.addOption(Layout.PropertyKeys.resizerTip.toString(), resizerTip);
                }
                if ((togglerTipOpen = layout.getTogglerTipOpen()) != null) {
                    if (panes == null) {
                        panes = new LayoutOptions();
                    }
                    panes.addOption(Layout.PropertyKeys.togglerTip_open.toString(), togglerTipOpen);
                }
                if ((togglerTipClosed = layout.getTogglerTipClosed()) != null) {
                    if (panes == null) {
                        panes = new LayoutOptions();
                    }
                    panes.addOption(Layout.PropertyKeys.togglerTip_closed.toString(), togglerTipClosed);
                }
                if (panes != null) {
                    options.setPanesOptions(panes);
                }
            }
        } else {
            if (parent instanceof UIForm) {
                this.setOptions(parent.getParent());
                return;
            }
            if (parent instanceof HtmlPanelGroup && "ui-layout-content".equals(((HtmlPanelGroup)parent).getStyleClass()) && "block".equals(((HtmlPanelGroup)parent).getLayout())) {
                this.setOptions(parent.getParent());
                return;
            }
            if (parent instanceof OutputPanel && "ui-layout-content".equals(((OutputPanel)parent).getStyleClass()) && "block".equals(((OutputPanel)parent).getLayout())) {
                this.setOptions(parent.getParent());
                return;
            }
            if (parent != null && parent.toString().contains("ui-layout-content")) {
                this.setOptions(parent.getParent());
                return;
            }
            throw new FacesException("LayoutPane can be only placed within another LayoutPane, Layout, UIForm or DIV with class 'ui-layout-content'");
        }
        if ("center".equals(position)) {
            options.setCenterOptions(thisLayoutOptions);
        } else if ("north".equals(position)) {
            options.setNorthOptions(thisLayoutOptions);
        } else if ("south".equals(position)) {
            options.setSouthOptions(thisLayoutOptions);
        } else if ("west".equals(position)) {
            options.setWestOptions(thisLayoutOptions);
        } else if ("east".equals(position)) {
            options.setEastOptions(thisLayoutOptions);
        } else {
            throw new FacesException("Pane position " + position + " is invalid. Valid positions are 'center', 'north' 'south', 'west', 'east'");
        }
    }

    private Layout getLayout() {
        UIComponent parent = this.getParent();
        while (!(parent instanceof Layout)) {
            parent = parent.getParent();
        }
        return (Layout)parent;
    }

    public void setAttribute(PropertyKeys property, Object value) {
        String cname;
        this.getStateHelper().put((Serializable)((Object)property), value);
        ArrayList<String> setAttributes = (ArrayList<String>)this.getAttributes().get("javax.faces.component.UIComponentBase.attributesThatAreSet");
        if (setAttributes == null && (cname = ((Object)((Object)this)).getClass().getName()) != null && cname.startsWith(OPTIMIZED_PACKAGE)) {
            setAttributes = new ArrayList<String>(6);
            this.getAttributes().put("javax.faces.component.UIComponentBase.attributesThatAreSet", setAttributes);
        }
        if (setAttributes != null && value == null) {
            String attributeName = property.toString();
            ValueExpression ve = this.getValueExpression(attributeName);
            if (ve == null) {
                setAttributes.remove(attributeName);
            } else if (!setAttributes.contains(attributeName)) {
                setAttributes.add(attributeName);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum PropertyKeys {
        position,
        combinedPosition,
        styleHeader,
        styleClassHeader,
        styleContent,
        styleClassContent,
        resizable,
        closable,
        size,
        minSize,
        maxSize,
        minWidth,
        maxWidth,
        minHeight,
        maxHeight,
        spacing,
        initClosed,
        initHidden,
        resizeWhileDragging;

        private String toString;

        private PropertyKeys(String toString) {
            this.toString = toString;
        }

        private PropertyKeys() {
        }

        public String toString() {
            return this.toString != null ? this.toString : super.toString();
        }
    }
}

