/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.config;

import javax.faces.context.FacesContext;
import org.primefaces.extensions.config.ConfigContainer;

public class ConfigProvider {
    private static final String KEY = ConfigContainer.class.getName();
    private static final ThreadLocal<ConfigContainer> CACHE = new ThreadLocal();

    public static ConfigContainer getConfig(FacesContext context) {
        return ConfigProvider.getConfig(context, true);
    }

    public static ConfigContainer getConfig(FacesContext context, boolean cacheInThreadLocal) {
        ConfigContainer container = null;
        if (cacheInThreadLocal) {
            container = CACHE.get();
            if (container == null) {
                container = ConfigProvider.getConfigFromApplicationMap(context);
                CACHE.set(container);
            }
        } else {
            container = ConfigProvider.getConfigFromApplicationMap(context);
        }
        return container;
    }

    private static ConfigContainer getConfigFromApplicationMap(FacesContext context) {
        ConfigContainer container = (ConfigContainer)context.getExternalContext().getApplicationMap().get(KEY);
        if (container == null) {
            container = new ConfigContainer(context);
            context.getExternalContext().getApplicationMap().put(KEY, container);
        }
        return container;
    }

    public static void cleanCache() {
        CACHE.remove();
    }
}

