/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.renderkit.widget;

import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.api.Widget;
import org.primefaces.extensions.renderkit.widget.AdvancedOptionContainer;
import org.primefaces.extensions.renderkit.widget.Option;
import org.primefaces.extensions.renderkit.widget.OptionContainer;
import org.primefaces.extensions.util.ComponentUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WidgetRenderer {
    private static final Map<String, AdvancedOptionContainer[]> PROPERTY_KEYS_CACHE = new ConcurrentHashMap<String, AdvancedOptionContainer[]>();

    public static void renderWidgetScript(FacesContext context, String clientId, ResponseWriter writer, Widget widget, boolean hasStyleSheet) throws IOException {
        WidgetRenderer.renderWidgetScript(context, clientId, writer, widget, hasStyleSheet, null);
    }

    public static void renderWidgetScript(FacesContext context, String clientId, ResponseWriter writer, Widget widget, boolean hasStyleSheet, Map<OptionContainer, Object> additionalOptions) throws IOException {
        Class<?> widgetClass = widget.getClass();
        String widgetName = widgetClass.getSimpleName();
        String widgetVar = widget.resolveWidgetVar();
        writer.write("$(function() {");
        writer.write("PrimeFacesExt.cw('" + widgetName + "', '" + widgetVar + "', {");
        WidgetRenderer.renderOptions(clientId, writer, widget);
        if (additionalOptions != null) {
            for (Map.Entry<OptionContainer, Object> entry : additionalOptions.entrySet()) {
                WidgetRenderer.renderOption(writer, entry.getKey(), entry.getValue());
            }
        }
        writer.write("}, " + hasStyleSheet + ");});");
    }

    public static final void renderOptions(String clientId, ResponseWriter writer, Widget widget) throws IOException {
        Class<?> widgetClass = widget.getClass();
        writer.write("id:'" + clientId + "'");
        AdvancedOptionContainer[] optionContainers = WidgetRenderer.getOptionsFromPropertyKeys(widgetClass);
        for (int i = 0; i < optionContainers.length; ++i) {
            AdvancedOptionContainer optionContainer = optionContainers[i];
            Object propertyValue = WidgetRenderer.getPropertValue(optionContainer, widget);
            WidgetRenderer.renderOption(writer, optionContainer, propertyValue);
        }
    }

    public static void renderOption(ResponseWriter writer, OptionContainer optionContainer, Object value) throws IOException {
        if (value != null) {
            if (String.class.isAssignableFrom(value.getClass()) || Character.class.isAssignableFrom(value.getClass())) {
                String stringValue = ((String)value).trim();
                if (optionContainer.isEscapeText()) {
                    stringValue = ComponentUtils.escapeText(stringValue);
                }
                if (stringValue.charAt(0) == '{' || stringValue.charAt(0) == '[') {
                    if (optionContainer.isEscapeHTML()) {
                        writer.writeText((Object)("," + optionContainer.getName() + ":" + stringValue), null);
                    } else {
                        writer.write("," + optionContainer.getName() + ":" + stringValue);
                    }
                } else if (optionContainer.isUseDoubleQuotes()) {
                    if (optionContainer.isEscapeHTML()) {
                        writer.writeText((Object)("," + optionContainer.getName() + ":\"" + stringValue + "\""), null);
                    } else {
                        writer.write("," + optionContainer.getName() + ":\"" + stringValue + "\"");
                    }
                } else if (optionContainer.isEscapeHTML()) {
                    writer.writeText((Object)("," + optionContainer.getName() + ":'" + stringValue + "'"), null);
                } else {
                    writer.write("," + optionContainer.getName() + ":'" + stringValue + "'");
                }
            } else if (optionContainer.isEscapeHTML()) {
                writer.writeText((Object)("," + optionContainer.getName() + ":" + value), null);
            } else {
                writer.write("," + optionContainer.getName() + ":" + value);
            }
        }
    }

    private static Object getPropertValue(AdvancedOptionContainer optionContainer, Widget widget) {
        try {
            return optionContainer.getReadMethod().invoke((Object)widget, new Object[0]);
        }
        catch (Exception e) {
            throw new FacesException("Can not get value for property '" + optionContainer.getPropertyName() + "' and widget '" + widget.getClass().getName() + "'", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static AdvancedOptionContainer[] getOptionsFromPropertyKeys(Class<?> widgetClass) {
        AdvancedOptionContainer[] options;
        if (PROPERTY_KEYS_CACHE.containsKey(widgetClass.getName())) {
            options = PROPERTY_KEYS_CACHE.get(widgetClass.getName());
        } else {
            Map<String, AdvancedOptionContainer[]> map = PROPERTY_KEYS_CACHE;
            synchronized (map) {
                if (PROPERTY_KEYS_CACHE.containsKey(widgetClass.getName())) {
                    options = PROPERTY_KEYS_CACHE.get(widgetClass.getName());
                } else {
                    Class<?> propertyKeysClass = null;
                    Class<?>[] childClasses = widgetClass.getDeclaredClasses();
                    for (int i = 0; i < childClasses.length; ++i) {
                        Class<?> childClass = childClasses[i];
                        if (!childClass.getSimpleName().equals("PropertyKeys")) continue;
                        propertyKeysClass = childClass;
                    }
                    if (propertyKeysClass == null) {
                        throw new FacesException("Widget '" + widgetClass.getName() + "' does not has PropertyKeys class.");
                    }
                    Enum[] propertyKeys = (Enum[])propertyKeysClass.getEnumConstants();
                    ArrayList<AdvancedOptionContainer> optionContainerList = new ArrayList<AdvancedOptionContainer>();
                    for (int i = 0; i < propertyKeys.length; ++i) {
                        Enum propertyKey = propertyKeys[i];
                        try {
                            Field propertyKeyField = propertyKeysClass.getDeclaredField(propertyKey.name());
                            if (!propertyKeyField.isAnnotationPresent(Option.class)) continue;
                            AdvancedOptionContainer optionContainer = new AdvancedOptionContainer();
                            Option option = propertyKeyField.getAnnotation(Option.class);
                            String propertyKeyAsString = propertyKey.toString();
                            String name = option.name().equals("") ? propertyKeyAsString : option.name();
                            optionContainer.setEscapeHTML(option.escapeHTML());
                            optionContainer.setEscapeText(option.escapeText());
                            optionContainer.setName(name);
                            optionContainer.setUseDoubleQuotes(option.useDoubleQuotes());
                            optionContainer.setPropertyName(propertyKeyAsString);
                            optionContainer.setReadMethod(new PropertyDescriptor(propertyKeyAsString, widgetClass).getReadMethod());
                            optionContainerList.add(optionContainer);
                            continue;
                        }
                        catch (Exception e) {
                            throw new FacesException("Can not get property '" + propertyKey.name() + "' in '" + widgetClass.getName() + "'", (Throwable)e);
                        }
                    }
                    PROPERTY_KEYS_CACHE.put(widgetClass.getName(), optionContainerList.toArray(new AdvancedOptionContainer[0]));
                    options = PROPERTY_KEYS_CACHE.get(widgetClass.getName());
                }
            }
        }
        return options;
    }
}

