/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.dashboard;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.dashboard.Dashboard;
import org.primefaces.component.panel.Panel;
import org.primefaces.model.DashboardColumn;
import org.primefaces.model.DashboardModel;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.WidgetBuilder;

public class DashboardRenderer
extends CoreRenderer {
    public void decode(FacesContext context, UIComponent component) {
        this.decodeBehaviors(context, component);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        Dashboard dashboard = (Dashboard)component;
        this.encodeMarkup(context, dashboard);
        this.encodeScript(context, dashboard);
    }

    protected void encodeMarkup(FacesContext contextr, Dashboard dashboard) throws IOException {
        DashboardModel model;
        ResponseWriter writer = contextr.getResponseWriter();
        String clientId = dashboard.getClientId(contextr);
        writer.startElement("div", (UIComponent)dashboard);
        writer.writeAttribute("id", (Object)clientId, "id");
        String styleClass = dashboard.getStyleClass() != null ? "ui-dashboard " + dashboard.getStyleClass() : "ui-dashboard";
        writer.writeAttribute("class", (Object)styleClass, "styleClass");
        if (dashboard.getStyle() != null) {
            writer.writeAttribute("style", (Object)dashboard.getStyle(), "style");
        }
        if ((model = dashboard.getModel()) != null) {
            for (DashboardColumn column : model.getColumns()) {
                writer.startElement("div", null);
                writer.writeAttribute("class", (Object)"ui-dashboard-column", null);
                for (String widgetId : column.getWidgets()) {
                    Panel widget = this.findWidget(widgetId, dashboard);
                    if (widget == null) continue;
                    this.renderChild(contextr, (UIComponent)widget);
                }
                writer.endElement("div");
            }
        }
        writer.endElement("div");
    }

    protected void encodeScript(FacesContext context, Dashboard dashboard) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = dashboard.getClientId(context);
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.widget("Dashboard", dashboard.resolveWidgetVar(), clientId, false).attr("disabled", dashboard.isDisabled(), false);
        this.encodeClientBehaviors(context, dashboard, wb);
        this.startScript(writer, clientId);
        writer.write(wb.build());
        this.endScript(writer);
    }

    protected Panel findWidget(String id, Dashboard dashboard) {
        for (UIComponent child : dashboard.getChildren()) {
            Panel panel = (Panel)child;
            if (!panel.getId().equals(id)) continue;
            return panel;
        }
        return null;
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }
}

