/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.dnd;

import java.io.IOException;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.dnd.Droppable;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.WidgetBuilder;

public class DroppableRenderer
extends CoreRenderer {
    public void decode(FacesContext context, UIComponent component) {
        this.decodeBehaviors(context, component);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        Droppable droppable = (Droppable)component;
        String target = this.findTarget(context, droppable).getClientId(context);
        String clientId = droppable.getClientId(context);
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.widget("Droppable", droppable.resolveWidgetVar(), clientId, true).attr("target", target).attr("disabled", droppable.isDisabled(), false).attr("hoverClass", droppable.getHoverStyleClass(), null).attr("activeClass", droppable.getActiveStyleClass(), null).attr("accept", droppable.getAccept(), null).attr("scope", droppable.getScope(), null).attr("tolerance", droppable.getTolerance(), null);
        if (droppable.getOnDrop() != null) {
            wb.append(",onDrop:").append(droppable.getOnDrop());
        }
        this.encodeClientBehaviors(context, droppable, wb);
        this.startScript(writer, clientId);
        writer.write(wb.build());
        this.endScript(writer);
    }

    protected UIComponent findTarget(FacesContext facesContext, Droppable droppable) {
        String _for = droppable.getFor();
        if (_for != null) {
            UIComponent component = droppable.findComponent(_for);
            if (component == null) {
                throw new FacesException("Cannot find component \"" + _for + "\" in view.");
            }
            return component;
        }
        return droppable.getParent();
    }
}

