/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.focus;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.focus.Focus;
import org.primefaces.renderkit.CoreRenderer;

public class FocusRenderer
extends CoreRenderer {
    private static final Map<String, Integer> severityOrdinals = new HashMap<String, Integer>();

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        Focus focus = (Focus)component;
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("span", (UIComponent)focus);
        writer.writeAttribute("id", (Object)focus.getClientId(context), "id");
        writer.endElement("span");
        writer.startElement("script", (UIComponent)focus);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        if (focus.getFor() != null) {
            this.encodeExplicitFocus(context, focus);
        } else {
            this.encodeImplicitFocus(context, focus);
        }
        writer.endElement("script");
    }

    protected void encodeExplicitFocus(FacesContext context, Focus focus) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        UIComponent forComponent = focus.findComponent(focus.getFor());
        if (forComponent == null) {
            throw new FacesException("Cannot find component '" + focus.getFor() + "' in view.");
        }
        String clientId = forComponent.getClientId(context);
        writer.write("$(function(){");
        writer.write("PrimeFaces.focus('" + clientId + "');");
        writer.write("});");
    }

    protected void encodeImplicitFocus(FacesContext context, Focus focus) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String invalidClientId = this.findFirstInvalidComponentClientId(context, focus);
        writer.write("$(function(){");
        if (invalidClientId != null) {
            writer.write("PrimeFaces.focus('" + invalidClientId + "');");
        } else if (focus.getContext() != null) {
            UIComponent focusContext = focus.findComponent(focus.getContext());
            if (context == null) {
                throw new FacesException("Cannot find component " + focus.getContext() + " in view");
            }
            writer.write("PrimeFaces.focus(null, '" + focusContext.getClientId(context) + "');");
        } else {
            writer.write("PrimeFaces.focus();");
        }
        writer.write("});");
    }

    protected String findFirstInvalidComponentClientId(FacesContext context, Focus focus) {
        int minSeverityOrdinal = severityOrdinals.get(focus.getMinSeverity());
        Iterator iterator = context.getClientIdsWithMessages();
        while (iterator.hasNext()) {
            String clientId = (String)iterator.next();
            Iterator messageIter = context.getMessages(clientId);
            while (messageIter.hasNext()) {
                FacesMessage message = (FacesMessage)messageIter.next();
                if (message.getSeverity().getOrdinal() > minSeverityOrdinal) continue;
                return clientId;
            }
        }
        return null;
    }

    static {
        severityOrdinals.put("info", FacesMessage.SEVERITY_INFO.getOrdinal());
        severityOrdinals.put("warn", FacesMessage.SEVERITY_WARN.getOrdinal());
        severityOrdinals.put("error", FacesMessage.SEVERITY_ERROR.getOrdinal());
        severityOrdinals.put("fatal", FacesMessage.SEVERITY_FATAL.getOrdinal());
    }
}

