/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.menubutton;

import java.io.IOException;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.menu.AbstractMenu;
import org.primefaces.component.menu.BaseMenuRenderer;
import org.primefaces.component.menubutton.MenuButton;
import org.primefaces.component.menuitem.MenuItem;
import org.primefaces.component.separator.Separator;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.WidgetBuilder;

public class MenuButtonRenderer
extends BaseMenuRenderer {
    protected void encodeMarkup(FacesContext context, AbstractMenu abstractMenu) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        MenuButton button = (MenuButton)abstractMenu;
        String clientId = button.getClientId(context);
        String styleClass = button.getStyleClass();
        styleClass = styleClass == null ? "ui-menubutton" : "ui-menubutton " + styleClass;
        boolean disabled = button.isDisabled();
        writer.startElement("span", (UIComponent)button);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("class", (Object)styleClass, "class");
        if (button.getStyle() != null) {
            writer.writeAttribute("style", (Object)button.getStyle(), "style");
        }
        this.encodeButton(context, button, clientId + "_button", disabled);
        if (!disabled) {
            this.encodeMenu(context, button, clientId + "_menu");
        }
        writer.endElement("span");
    }

    protected void encodeButton(FacesContext context, MenuButton button, String buttonId, boolean disabled) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String value = button.getValue();
        String buttonClass = disabled ? "ui-button ui-widget ui-state-default ui-corner-all ui-button-text-icon-left ui-state-disabled" : "ui-button ui-widget ui-state-default ui-corner-all ui-button-text-icon-left";
        writer.startElement("button", null);
        writer.writeAttribute("id", (Object)buttonId, null);
        writer.writeAttribute("name", (Object)buttonId, null);
        writer.writeAttribute("type", (Object)"button", null);
        writer.writeAttribute("class", (Object)buttonClass, buttonId);
        if (button.isDisabled()) {
            writer.writeAttribute("disabled", (Object)"disabled", null);
        }
        String iconClass = "ui-button-icon-left ui-icon ui-c ui-icon-triangle-1-s";
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)iconClass, null);
        writer.endElement("span");
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)"ui-button-text ui-c", null);
        if (value == null) {
            writer.write("ui-button");
        } else {
            writer.writeText((Object)value, "value");
        }
        writer.endElement("span");
        writer.endElement("button");
    }

    protected void encodeMenu(FacesContext context, MenuButton button, String menuId) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)menuId, null);
        writer.writeAttribute("class", (Object)"ui-menu ui-menu-dynamic ui-widget ui-widget-content ui-corner-all ui-helper-clearfix ui-shadow", "styleClass");
        writer.writeAttribute("role", (Object)"menu", null);
        writer.startElement("ul", null);
        writer.writeAttribute("class", (Object)"ui-menu-list ui-helper-reset", "styleClass");
        for (UIComponent child : button.getChildren()) {
            if (!child.isRendered()) continue;
            if (child instanceof MenuItem) {
                MenuItem item = (MenuItem)child;
                writer.startElement("li", (UIComponent)item);
                writer.writeAttribute("class", (Object)"ui-menuitem ui-widget ui-corner-all", null);
                writer.writeAttribute("role", (Object)"menuitem", null);
                this.encodeMenuItem(context, item);
                writer.endElement("li");
                continue;
            }
            if (!(child instanceof Separator)) continue;
            this.encodeSeparator(context, (Separator)child);
        }
        writer.endElement("ul");
        writer.endElement("div");
    }

    protected void encodeScript(FacesContext context, AbstractMenu abstractMenu) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        MenuButton button = (MenuButton)abstractMenu;
        String clientId = button.getClientId(context);
        UIComponent form = ComponentUtils.findParentForm(context, (UIComponent)button);
        if (form == null) {
            throw new FacesException("MenuButton : \"" + clientId + "\" must be inside a form element");
        }
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.widget("MenuButton", button.resolveWidgetVar(), clientId, true);
        this.startScript(writer, clientId);
        writer.write(wb.build());
        this.endScript(writer);
    }
}

