/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.password;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.password.Password;
import org.primefaces.renderkit.InputRenderer;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.HTML;
import org.primefaces.util.WidgetBuilder;

public class PasswordRenderer
extends InputRenderer {
    public void decode(FacesContext context, UIComponent component) {
        Password password = (Password)component;
        if (password.isDisabled() || password.isReadonly()) {
            return;
        }
        this.decodeBehaviors(context, (UIComponent)password);
        String submittedValue = (String)context.getExternalContext().getRequestParameterMap().get(password.getClientId(context));
        if (submittedValue != null) {
            password.setSubmittedValue(submittedValue);
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        Password password = (Password)component;
        this.encodeMarkup(context, password);
        this.encodeScript(context, password);
    }

    protected void encodeScript(FacesContext context, Password password) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = password.getClientId(context);
        boolean feedback = password.isFeedback();
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.widget("Password", password.resolveWidgetVar(), clientId, true);
        if (feedback) {
            wb.attr("feedback", true).attr("inline", password.isInline()).attr("promptLabel", password.getPromptLabel(), null).attr("weakLabel", password.getWeakLabel(), null).attr("goodLabel", password.getGoodLabel(), null).attr("strongLabel", password.getStrongLabel(), null);
        }
        this.encodeClientBehaviors(context, (ClientBehaviorHolder)password, wb);
        this.startScript(writer, clientId);
        writer.write(wb.build());
        this.endScript(writer);
    }

    protected void encodeMarkup(FacesContext context, Password password) throws IOException {
        String valueToRender;
        ResponseWriter writer = context.getResponseWriter();
        String clientId = password.getClientId(context);
        boolean disabled = password.isDisabled();
        String inputClass = "ui-inputfield ui-password ui-widget ui-state-default ui-corner-all";
        inputClass = password.isValid() ? inputClass : inputClass + " ui-state-error";
        inputClass = !disabled ? inputClass : inputClass + " ui-state-disabled";
        String styleClass = password.getStyleClass() == null ? inputClass : inputClass + " " + password.getStyleClass();
        writer.startElement("input", (UIComponent)password);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("name", (Object)clientId, null);
        writer.writeAttribute("type", (Object)"password", null);
        writer.writeAttribute("class", (Object)styleClass, null);
        if (password.getStyle() != null) {
            writer.writeAttribute("style", (Object)password.getStyle(), null);
        }
        if (!this.isValueEmpty(valueToRender = ComponentUtils.getValueToRender(context, (UIComponent)password)) && password.isRedisplay()) {
            writer.writeAttribute("value", (Object)valueToRender, null);
        }
        this.renderPassThruAttributes(context, (UIComponent)password, HTML.INPUT_TEXT_ATTRS);
        if (disabled) {
            writer.writeAttribute("disabled", (Object)"disabled", null);
        }
        if (password.isReadonly()) {
            writer.writeAttribute("readonly", (Object)"readonly", null);
        }
        writer.endElement("input");
    }
}

