/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.push;

import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.atmosphere.cpr.AsyncSupportListenerAdapter;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResponse;
import org.atmosphere.cpr.Broadcaster;
import org.atmosphere.cpr.BroadcasterListener;
import org.atmosphere.cpr.MetaBroadcaster;
import org.primefaces.json.JSONException;
import org.primefaces.json.JSONObject;
import org.primefaces.push.PushContext;
import org.primefaces.push.PushContextListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PushContextImpl
extends AsyncSupportListenerAdapter
implements PushContext {
    private final ConcurrentLinkedQueue<PushContextListener> listeners = new ConcurrentLinkedQueue();
    private final MetaBroadcaster broadcaster = MetaBroadcaster.getDefault();

    @Override
    public <T> Future<T> push(String channel, T t) {
        String data = this.toJSON(t);
        PushContextMetaListener l = new PushContextMetaListener(this.listeners, channel, t);
        Future f = this.broadcaster.addBroadcasterListener(l).broadcastTo(channel, (Object)data);
        this.finalizePush(f, l);
        return new WrappedFuture(f, t);
    }

    @Override
    public <T> Future<T> schedule(String channel, T t, int time, TimeUnit unit) {
        Object data = t;
        if (!(t instanceof Callable) && !(t instanceof Runnable)) {
            data = this.toJSON(t);
        }
        PushContextMetaListener l = new PushContextMetaListener(this.listeners, channel, t);
        Future f = this.broadcaster.addBroadcasterListener(l).scheduleTo(channel, data, time, unit);
        this.finalizePush(f, l);
        return new WrappedFuture(f, t);
    }

    @Override
    public <T> Future<T> delay(String channel, T t, int time, TimeUnit unit) {
        String data = this.toJSON(t);
        PushContextMetaListener l = new PushContextMetaListener(this.listeners, channel, t);
        Future f = this.broadcaster.addBroadcasterListener(l).delayTo(channel, (Object)data, time, unit);
        this.finalizePush(f, l);
        return new WrappedFuture(f, t);
    }

    private void finalizePush(Future<?> f, BroadcasterListener l) {
        if (f.isDone()) {
            this.broadcaster.removeBroadcasterListener(l);
        }
    }

    @Override
    public PushContext addListener(PushContextListener p) {
        this.listeners.add(p);
        return this;
    }

    @Override
    public PushContext removeListener(PushContextListener p) {
        this.listeners.remove(p);
        return this;
    }

    private String toJSON(Object data) {
        try {
            StringBuilder jsonBuilder = new StringBuilder();
            jsonBuilder.append("{");
            if (this.isBean(data)) {
                jsonBuilder.append("\"").append("data").append("\":").append(new JSONObject(data).toString());
            } else {
                String json = new JSONObject().put("data", data).toString();
                jsonBuilder.append(json.substring(1, json.length() - 1));
            }
            jsonBuilder.append("}");
            return jsonBuilder.toString();
        }
        catch (JSONException e) {
            System.out.println(e.getMessage());
            throw new RuntimeException(e);
        }
    }

    private boolean isBean(Object value) {
        if (value == null) {
            return false;
        }
        return !(value instanceof Boolean) && !(value instanceof String) && !(value instanceof Number);
    }

    public void onTimeout(AtmosphereRequest request, AtmosphereResponse response) {
        for (PushContextListener l : this.listeners) {
            l.onDisconnect(request);
        }
    }

    public void onClose(AtmosphereRequest request, AtmosphereResponse response) {
        for (PushContextListener l : this.listeners) {
            l.onDisconnect(request);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class PushContextMetaListener<T>
    implements BroadcasterListener {
        private final ConcurrentLinkedQueue<PushContextListener> listeners;
        private final String channel;
        private final T t;

        private PushContextMetaListener(ConcurrentLinkedQueue<PushContextListener> listeners, String channel, T t) {
            this.listeners = listeners;
            this.channel = channel;
            this.t = t;
        }

        public void onPostCreate(Broadcaster broadcaster) {
        }

        public void onComplete(Broadcaster b) {
            for (PushContextListener p : this.listeners) {
                p.onComplete(this.channel, this.t);
            }
            b.removeBroadcasterListener((BroadcasterListener)this);
        }

        public void onPreDestroy(Broadcaster broadcaster) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class WrappedFuture<T>
    implements Future {
        private final Future<?> f;
        private final T t;

        private WrappedFuture(Future<?> f, T t) {
            this.f = f;
            this.t = t;
        }

        @Override
        public boolean cancel(boolean b) {
            return this.f.cancel(b);
        }

        @Override
        public boolean isCancelled() {
            return this.f.isCancelled();
        }

        @Override
        public boolean isDone() {
            return this.f.isDone();
        }

        public T get() throws InterruptedException, ExecutionException {
            this.f.get();
            return this.t;
        }

        public T get(long l, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
            this.f.get(l, timeUnit);
            return this.t;
        }
    }
}

