/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.renderkit;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.faces.application.ConfigurableNavigationHandler;
import javax.faces.application.NavigationCase;
import javax.faces.component.UIComponent;
import javax.faces.component.UIParameter;
import javax.faces.context.FacesContext;
import org.primefaces.component.api.UIOutcomeTarget;
import org.primefaces.renderkit.CoreRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutcomeTargetRenderer
extends CoreRenderer {
    protected NavigationCase findNavigationCase(FacesContext context, UIOutcomeTarget outcomeTarget) {
        ConfigurableNavigationHandler navHandler = (ConfigurableNavigationHandler)context.getApplication().getNavigationHandler();
        String outcome = outcomeTarget.getOutcome();
        if (outcome == null) {
            outcome = context.getViewRoot().getViewId();
        }
        return navHandler.getNavigationCase(context, null, outcome);
    }

    protected Map<String, List<String>> getParams(NavigationCase navCase, UIOutcomeTarget outcomeTarget) {
        LinkedHashMap<String, List<String>> params = new LinkedHashMap<String, List<String>>();
        for (UIComponent child : outcomeTarget.getChildren()) {
            UIParameter uiParam;
            if (!child.isRendered() || !(child instanceof UIParameter) || (uiParam = (UIParameter)child).isDisable()) continue;
            ArrayList<String> paramValues = (ArrayList<String>)params.get(uiParam.getName());
            if (paramValues == null) {
                paramValues = new ArrayList<String>();
                params.put(uiParam.getName(), paramValues);
            }
            paramValues.add(String.valueOf(uiParam.getValue()));
        }
        Map navCaseParams = navCase.getParameters();
        if (navCaseParams != null && !navCaseParams.isEmpty()) {
            for (Map.Entry entry : navCaseParams.entrySet()) {
                String key = (String)entry.getKey();
                if (params.containsKey(key)) continue;
                params.put(key, (List<String>)entry.getValue());
            }
        }
        return params;
    }

    protected boolean isIncludeViewParams(UIOutcomeTarget outcomeTarget, NavigationCase navCase) {
        return outcomeTarget.isIncludeViewParams() || navCase.isIncludeViewParams();
    }

    protected String getTargetURL(FacesContext context, UIOutcomeTarget outcomeTarget) {
        String url;
        String href = outcomeTarget.getHref();
        if (href != null) {
            url = this.getResourceURL(context, href);
        } else {
            NavigationCase navCase = this.findNavigationCase(context, outcomeTarget);
            String toViewId = navCase.getToViewId(context);
            boolean isIncludeViewParams = this.isIncludeViewParams(outcomeTarget, navCase);
            Map<String, List<String>> params = this.getParams(navCase, outcomeTarget);
            url = context.getApplication().getViewHandler().getBookmarkableURL(context, toViewId, params, isIncludeViewParams);
            if (outcomeTarget.getFragment() != null) {
                url = url + "#" + outcomeTarget.getFragment();
            }
        }
        return url;
    }
}

