﻿<%
''' EYCMS 系统核心函数
''' ==================================================================

dim eycms,sysdata,get_cate_option
dim get_content_page
set eycms=new eycms_function
	eycms.init
class eycms_function
	private reg,match,matches
	private fso,stm,scriptCtrl
	public db,temp,page,sysdb,classdb
	
	private sub class_initialize
		set reg=new regexp
			reg.ignorecase=true
			reg.global=true
		set fso=createobject("scripting.filesystemobject") 
		set stm=server.createobject("adodb.stream")
		set sysdb=server.createobject("scripting.dictionary")
		set classdb=server.createobject("scripting.dictionary")

		Set scriptCtrl = Server.CreateObject("MSScriptControl.ScriptControl")  
		scriptCtrl.Language = "JScript"  
        scriptCtrl.AddCode "Array.prototype.get = function(x) { return this[x]; }; var result = null;"  
	end sub
	
	private sub class_terminate
		set reg=nothing
		set fso=nothing
		set stm=nothing
		set sysdb=nothing
		set classdb=nothing
		set page=nothing
		set db=nothing
		Set scriptCtrl=Nothing 
	end sub
    
    private function parseJSON(str) 
        scriptCtrl.ExecuteStatement "result = " & str & ";"  
        Set parseJSON = scriptCtrl.CodeObject.result 
    end function  

	public sub init()
		set db=new eycms_dbbase
		set page=new eycms_pagelist
		set temp=new eycms_template
	end sub
	
	public sub show(byval t0,byval t1)
		dim temproot:temproot=getsplitname(t0)
		temp.isgzip=isgzip
		temp.iscache=tempcache
		temp.isencry=tempencry
		temp.cname=t1
		temp.cachepath=webroot&"cache/theme/"&theme_root&temproot(0)
		temp.templatepath=webroot&"theme/"&theme_root&temproot(0)
		temp.templatename=temproot(1)
		temp.templateext=temproot(2)
		temp.load()
		temp.display()
	end sub
	
	public sub sitedb()
		dim i,t0
		t0=eycmsdata
		for i=0 to ubound(t0,2)
			if sysdb.exists(lcase(t0(0,i))) then
				sysdb.item(lcase(t0(0,i)))=t0(1,i)
			else
				sysdb.add lcase(t0(0,i)),t0(1,i)
			end if
		next
	end sub
	
	public sub catedb()
		dim i,t0,t1
		t0=categorydata
		if isarray(t0) then
			for i=0 to ubound(t0,2)
			t1=array(t0(0,i),t0(1,i),t0(2,i),t0(3,i),t0(4,i),t0(5,i),t0(6,i),t0(7,i),t0(8,i),t0(9,i),t0(10,i),t0(11,i),t0(12,i),t0(13,i),t0(14,i),t0(15,i),t0(16,i),t0(17,i),t0(18,i),t0(19,i),t0(20,i),t0(21,i),t0(22,i),t0(23,i),t0(24,i),t0(25,i),t0(26,i),t0(27,i),t0(28,i),t0(29,i),t0(30,i),t0(31,i),t0(32,i))
				if classdb.exists(t0(0,i)) then
					classdb.item(t0(0,i))=t1
				else
					classdb.add t0(0,i),t1
				end if
			next
		end if
	end sub

	'系统更新
	public sub sys_update()   
		err.clear
		on error resume next
		if not isfile(webroot&"update.lock") then
			eycms.db.exedb("update ey_admin_menu set title='点赞管理' where id=36")
			eycms.db.exedb("update ey_admin_menu set title='生成分站',url='ey_html.asp?act=region' where id=46")
			eycms.db.conn.execute("CREATE TABLE [ey_plug_set_class]([classid] int IDENTITY(1,1) PRIMARY KEY NOT NULL,[classname] nvarchar(50) NULL,[zt] int NULL,[ordnum] int NULL)")
			eycms.db.conn.execute("ALTER TABLE ey_plug_set ADD COLUMN [cid] int NULL;")
			If eycms.db.dbcount("ey_plug_set_class","classid>0")<=0 then
				eycms.db.exedb("insert into ey_plug_set_class (classname,ordnum,zt) values ('扩展设置',0,1)")
				eycms.db.exedb("update ey_plug_set set cid=1")
			End if
			eycms.db.conn.execute("ALTER TABLE ey_model_field ADD COLUMN [fmemo] nvarchar(255) NULL;")
			eycms.db.conn.execute("ALTER TABLE ey_plug_set ADD COLUMN [fmemo] nvarchar(255) NULL;")
			eycms.db.conn.execute("DROP TABLE ey_plug_seocity;")
			
			eycms.db.conn.execute("ALTER TABLE ey_content ADD COLUMN [editmodel] int NULL;")
			eycms.db.exedb("update ey_content set editmodel=0 where editmodel is null")
			
			eycms.db.conn.execute("ALTER TABLE ey_model_page ADD COLUMN [editmodel] int NULL;")
			eycms.db.exedb("update ey_model_page set editmodel=0 where editmodel is null")
			if eycms.strlen(eycms.getsys("eycms.plug.region"))>0 then
				eycms.db.conn.execute("ALTER TABLE ey_plug_regionset ADD COLUMN [replacetxt] ntext NULL;")
				eycms.db.conn.execute("ALTER TABLE ey_plug_regionset ADD COLUMN [replaceto] ntext NULL;")
				eycms.db.conn.execute("ALTER TABLE ey_plug_regionkey ADD COLUMN [replacetxt] ntext NULL;")
				eycms.db.conn.execute("ALTER TABLE ey_plug_regionkey ADD COLUMN [replaceto] ntext NULL;")
			end if
			newfile webroot,"update.lock",now(),"utf-8"
		end if
	end sub

	public sub auto_update()
		sys_update
		if not(checkcache("auto_update",0)) Then
			dim tdata:tdata=array(array("timing",0,1,0),array("islock",1,1,0))
			if datatype=True then
				db.dbupdate "ey_content","timing=1 and DATEDIFF('n',createdate,Now())>=0",tdata
			else
				db.dbupdate "ey_content","timing=1 and DATEDIFF(n,createdate,getdate())>=0",tdata
			end if
			dim user_islock:user_islock=eycms.db.dbloadone("islock","ey_admin_menu","title='会员'")
			dim shop_islock:shop_islock=eycms.db.dbloadone("islock","ey_admin_menu","title='订单'")
			if user_islock=1 and shop_islock=1 then
			dim data:data=db.dbload("","o.id,p.createdate","ey_user_order o left join ey_user_order_post p on o.orderid=p.orderid","o.ispay=1 and o.isover=0 and o.postway>0","o.id desc")
			if ubound(data)>=0 then
				dim i
				for i=0 to ubound(data,2)
					if now()-data(1,i)>=10 then
						db.dbupdate "ey_user_order","id="&data(0,i)&"",array(array("isover",1,0,0),array("overtype",3,0,0),array("overdate",sqltime,0,0))
					end if
				next
			end if
			data=db.dbload("","id,begindate,overdate,isover,islock","ey_order_limited","","")
			if ubound(data)>=0 then
				for i=0 to ubound(data,2)
					if data(4,i)=1 then
						if data(3,i)=0 then
							if cdate(data(1,i))<=now() and cdate(data(2,i))>now() then
								dim pdata,j
								pdata=eycms.db.dbload("","cid","ey_model_pro","aid="&data(0,i)&"","")
								if ubound(pdata)>=0 then
									for j=0 to ubound(pdata,2)
										dim cdata:cdata=array(array("isact",1,10,0))
										db.dbupdate "ey_content","id="&pdata(0,j)&"",cdata
									next
								end if
								cdata=array(array("isover",1,10,0))
								db.dbupdate "ey_order_limited","id="&data(0,i)&"",cdata
							end if
							if cdate(data(1,i))<now() and cdate(data(2,i))<now() then
								pdata=eycms.db.dbload("","cid","ey_model_pro","aid="&data(0,i)&"","")
								if ubound(pdata)>=0 then
									for j=0 to ubound(pdata,2)
										cdata=array(array("isact",0,10,0))
										db.dbupdate "ey_content","id="&pdata(0,j)&"",cdata
									next
								end if							
								cdata=array(array("isover",2,10,0))
								db.dbupdate "ey_order_limited","id="&data(0,i)&"",cdata
							end if
						end if
						if data(3,i)=1 then
							pdata=eycms.db.dbload("","cid","ey_model_pro n left join ey_content p on n.cid=p.id","aid="&data(0,i)&" and isact=0","")
							if ubound(pdata)>=0 then
								for j=0 to ubound(pdata,2)
									cdata=array(array("isact",1,10,0))
									db.dbupdate "ey_content","id="&pdata(0,j)&"",cdata
								next
							end if
							if cdate(data(1,i))<now() and cdate(data(2,i))<now() then
								pdata=eycms.db.dbload("","cid","ey_model_pro","aid="&data(0,i)&"","")
								if ubound(pdata)>=0 then
									for j=0 to ubound(pdata,2)
										cdata=array(array("isact",0,10,0))
										db.dbupdate "ey_content","id="&pdata(0,j)&"",cdata
									next
								end if
								cdata=array(array("isover",2,10,0))
								db.dbupdate "ey_order_limited","id="&data(0,i)&"",cdata
							end if
						end if
						if data(3,i)=2 then
							pdata=eycms.db.dbload("","cid","ey_model_pro n left join ey_content p on n.cid=p.id","aid="&data(0,i)&" and isact=1","")
							if ubound(pdata)>=0 then
								for j=0 to ubound(pdata,2)
									cdata=array(array("isact",0,10,0))
									db.dbupdate "ey_content","id="&pdata(0,j)&"",cdata
								next
							end if
						end if
					else
						pdata=eycms.db.dbload("","cid","ey_model_pro n left join ey_content p on n.cid=p.id","aid="&data(0,i)&" and isact=1","")
						if ubound(pdata)>=0 then
							for j=0 to ubound(pdata,2)
								cdata=array(array("isact",0,10,0))
								db.dbupdate "ey_content","id="&pdata(0,j)&"",cdata
							next
						end if
					end if
				next
			end If
			end if
			setcache "auto_update","auto_update",0
		end if
	end sub
	
	public sub order_auto(byval t0,byval t1)
		exit sub
	end sub
	
	public function getsys(byval t0)
		getsys=sysdb.item(lcase(t0))
		getsys=replace(getsys,"{webroot}",webroot)
	end function
	
	public function getclassdb(byval t0)
		getclassdb=classdb.item(cdbl(t0))
	end function
	
	public function runtime()
		runtime=formatnumber(timer()-startime,4,true,false,true)
	end function
	
	public sub echo(byval t0)
		response.write t0
	end sub
	
	public sub die()
		eycms.db.dbclose
		response.end()
	end sub

	sub ajaxjson(byval t0,byval t1)
		dim t2:t2=iif(t1=1,"y","n")
		echo "{""info"":"""&t0&""",""status"":"""&t2&"""}"
	end sub
	
	public sub trans(t0)
		err.clear
		on error resume next
		server.transfer t0
		if err then
			echo "文件没有生成，无法访问"
			err.clear
		end if
	end sub
	
	public sub go(byval t0)
		response.redirect t0
	end sub
	
	function strlen(byval t0)
		if isnull(t0) then strlen=0:exit function
		strlen=len(t0)
	end function
	
	function is_null(byval t0)
		if isnull(t0) or isempty(t0) or t0="" then
			is_null=true
		else
			is_null=false
		end if
	end function
	
	public sub back(byval t0)
		echo "<script>alert("""&t0&""");location.href=""javascript:history.go(-1)""</script>"
	end sub
	
	public sub backurl(byval t0,byval t1)
		echo "<script>alert("""&t0&""");location.href="""&t1&"""</script>"
	end sub
	
	public sub script(byval t0)
		echo "<script>"&t0&"</script>"
	end sub
	
	public function iif(byval t0,byval t1,byval t2)
		if t0 then iif=t1 else iif=t2
	end function
	
	public function iiif(byval t0,byval t1,byval t2,byval t3,byval t4)
		if t0 then
			iiif=t2
		elseif t1 then
			iiif=t3
		else
			iiif=t4
		end if
	end function
	
	public function sqlstr(byval t0)
		sqlstr="'"&replace(t0,"'","''")&"'"
		sqlstr=replace(sqlstr,"%27","")
	end function
	
	public function fget(byval t0,byval t1)
		fget=request.querystring(t0)
		if t1=0 then fget=trim(fget)
	end function
	
	public function fpost(byval t0,byval t1)
		fpost=request.form(t0)
		if t1=0 then fpost=trim(fpost)
		if t1=2 then fpost=rtrim(fpost)
		fpost=replace(fpost,"&quot;","'")
	end function
	
	public function ffpost(byval t0,byval t1)
		ffpost=request.form(t0)
		if t1=0 then ffpost=trim(ffpost)
		if t1=2 then ffpost=rtrim(ffpost)
		reg.pattern ="<script.+?/script>"
		ffpost=reg.replace(ffpost,"")
		ffpost=replace(ffpost,"&quot;","'")
		'reg.pattern ="<iframe.+?/iframe>"
		'ffpost=reg.replace(ffpost,"")
	end function

	public function fquery(byval t0,byval t1)
		fquery=request(t0)
		if t1=0 then fquery=trim(fquery)
	end function
	
	public function isnum(byval t0)
		isnum=true
		if not isnumeric(t0) then isnum=false
	end function
	
	public function ismoney(byval t0)
		ismoney=true
		if not isnumeric(t0) then ismoney=false:exit function
		if t0<0 then ismoney=false
	end function
	
	public function isSame(byval t0,byval t1)
		isSame=false
		if isnumeric(t0) and isnumeric(t1) then
			if CInt(t0)=CInt(t1) then isSame=true
		else
			if Cstr(t0)=Cstr(t1) then isSame=true
		end if
	end Function

	public function isinstall(byval t0)
		err.clear
		on error resume next
		isinstall=false
		dim obj
		set obj=server.createobject(t0)
			if err.number=0 then isinstall=true
		set obj=nothing
		err.clear()
	end function
	
	public function get_ismobile()
		if not(getsys("sys_mobile")) then exit function
		dim t1:t1=request.servervariables("http_user_agent")
		if eycms.strlen(t1)=0 then get_ismobile=false:exit function
		dim arr
		arr=array("android","phone","ipod","mqqbrowser","blackberry","nokia","windowsce","symbian","lg","ucweb","skyfire","webos","incognito","blackberry","mobile","bada")
		dim i
		for i=0 to ubound(arr)
			if instr(lcase(t1),arr(i))>0 then
				dim t0:t0=true
				exit for
			end if
		next
		if t0 then
			if webmode=3 then webmode=1
		end if
		get_ismobile=t0
	end Function

	public function chk_ismobile()
		dim t1:t1=request.servervariables("http_user_agent")
		if eycms.strlen(t1)=0 then chk_ismobile=false:exit function
		dim arr
		arr=array("android","phone","ipod","mqqbrowser","blackberry","nokia","windowsce","symbian","lg","ucweb","skyfire","webos","incognito","blackberry","mobile","bada")
		dim i
		for i=0 to ubound(arr)
			if instr(lcase(t1),arr(i))>0 then
				dim t0:t0=true
				exit for
			end if
		next
		'if instr(lcase(t1),"ipad")>0 then t0=false
		chk_ismobile=t0
	end Function
	
	public function getrnd(byval t0)
		randomize
		dim n1,n2,n3
		t0=getint(t0,10)
		do while len(getrnd)<t0  
			n1=cstr(chrw((57-48)*rnd+48))
			n2=cstr(chrw((90-65)*rnd+65))
			n3=cstr(chrw((122-97)*rnd+97))
			getrnd=getrnd&n1&n2&n3 
		loop
	end function
	
	public function getrndfilename()
		dim t0,t1
		randomize
		t0=int(900*rnd)+100
		t1=now()
		getrndfilename=year(t1)&month(t1)&day(t1)&hour(t1)&minute(t1)&second(t1)&t0
	end function
	
	public function get_second(byval t0)
		dim a:a=t0
		dim b:b="1970-1-1 23:59:59"
		dim c:c=datediff("s",b,a)
		get_second=c
	end function
	
	public function get_pinyin(byval t0)
		t0=replace(t0," ","-")
		t0=replace(t0,"　","-")
		if pyquery=0 then
			call eycms.include(webroot&"lib/class/eycms.pinyin.asp")
			pyquery=pyquery+1
		end if
		dim py
		set py=new eycms_pinyin
			get_pinyin=py.pinyin(t0)
		set py=nothing
		get_pinyin=left(get_pinyin,50)
	end function

	public function get_english(byval t0)
		on error resume Next
		dim url:url="http://fanyi.youdao.com/openapi.do?keyfrom=sdcms2015&key=1680379450&type=data&doctype=json&version=1.1&q="&server.urlencode(t0)&"&only=translate"
		dim html:html=gethttp(url,"")
		if html<>"ERR" then
			dim json,str
			set json=toobject(html)
				if json.errorCode="0" then
					str=json.translation
				end if
			set json=nothing
			str=replace(str," ","-")
			get_english=str
		else
			get_english=""
		end if
		if err then
			errlog "函数：get_english<br>详情："&err.description,1
			err.clear
		end if
	end function

	public function get_english_baidu(byval t0)
		on error resume Next
		Dim query,appid,appkey,salt,sign
		query=t0
		appid="20160201000010190"
		appkey="RgF7uzudNDOneNG4BA9w"
		salt=year(Date())&right("000000"&cstr(clng(timer()*1000)+1),6)
		sign=md5_32(appid & query & salt & appkey)
		dim url
		url="http://api.fanyi.baidu.com/api/trans/vip/translate?q="&server.urlencode(t0)&"&from=zh&to=en&appid="&appid&"&salt="&salt&"&sign="&sign
		dim html
		html=gethttp(url,"")
		html=left(html,len(html)-4)
		html=split(html,"""dst"":""")
		dim str:str=html(1)
		str=lcase(replace(str," ","-"))
		if err then err.clear:str=""
		get_english_baidu=str
	end function

	public function get_express(byval t0)
		if checkcache("express",0) then
			get_express=loadcache("express",0)
		else
			dim url,comCode,json,obj,i,str
			url="http://www.kuaidi100.com/autonumber/autoComNum?text="&t0
			comCode=gethttp(url,"post")
			if eycms.strlen(comCode)>0 then
				Set obj = parseJSON(comCode)  
				comCode=obj.auto.get(0).comCode
				if strlen(comCode)>0 then
					url="http://www.kuaidi100.com/query?type="&comCode&"&postid="&t0
					json=gethttp(url,"post")
					Set obj = parseJSON(json) 
					if isobject(obj) then
						for i=0 to obj.data.length-1
							str = str & "<li><span>" & obj.data.get(i).time &"　</span>" & obj.data.get(i).context &"</li>"
						next
					else
						str="<li>单号不存在或者已经过期</li>"
					end if
				else
					str="<li>单号不存在或者已经过期</li>"
				end if
				set obj = nothing
			end if
			str="<ul>"&str&"</ul>"
			setcache "express",str,0
			get_express=str
		end if
	end function
	
	public function get_frist_pic(byval t0)
		get_frist_pic=""
		if strlen(t0)=0 then exit function
		reg.pattern="<img[^>]+src=""([^"">]+)""[^>]*>"
		set matches=reg.execute(t0)
		if reg.test(t0) then
		   get_frist_pic=matches(0).submatches(0)
		end if
	end function

	public function replacetext(byval t0,byval t1,byval t2)
		reg.pattern=t1
		reg.ignorecase=true
		reg.global=true
		replacetext=reg.replace(""&t0&"",""&t2&"")
	end Function

	public function getRquestParam(byval t0,byval t1)
		reg.pattern=t1
		set matches=reg.execute(t0)
		if reg.test(t0) then
		   getRquestParam=matches(0).submatches(0)
		end if
	end Function
	
	public function getkey()
		getkey=getrnd(5)
	end function

	public function get_thisfolder
		dim a,b,c
		a=request.servervariables("script_name")
		b=split(a,"/")
		c=ubound(b)
		if c<=1 then
			get_thisfolder=""
		else
			get_thisfolder=b(c-2)
		end if
	end function
	
	public function is_weixin()
		dim a:a=lcase(request.servervariables("http_user_agent"))
		if instr(a,"micromessenger")>0 then
			is_weixin=true
		else
			is_weixin=false
		end if
	end function
	
	public function getsplitname(byval t0)
		dim str:str=t0
		if t0="" then
			echo "模板文件不能为空":die
		end if
		if instr(t0,".")<=0 then
			echo "模板路径错误("&t0&")":die
		end if
		dim str_arr:str_arr=split(str,"/")
		dim file_full_name:file_full_name=str_arr(ubound(str_arr))
		dim file_dir:file_dir=replace(t0,file_full_name,"")
		dim file_fix:file_fix=mid(file_full_name,instrrev(file_full_name,".")+1)
		dim filename:filename=left(file_full_name,instrrev(file_full_name,".")-1)
		if len(file_dir)=0 then file_dir="/" else file_dir="/"&file_dir
		getsplitname=array(file_dir,filename,file_fix)
	end function
	
	public function getint(byval t0,byval t1)
		on error resume next
		if isnum(t0) then getint=cdbl(t0) else getint=t1
		if err then
			errlog "getint："&t0&","&t1&"<br>详情："&err.description,1
			err.clear
		end if
	end function
	
	public function getprice(byval t0,byval t1)
		if isnum(t0) then getprice=t0 else getprice=t1
	end function
	
	public function get_int(byval t0,byval t1)
		get_int=iif(checkstr(t0,"int"),t0,t1)
	end function
	
	public function getdate(byval t0,byval t1,byval t2)
		getdate=""
		if t2=1 then getdate=getdate&year(t0)&t1
		getdate=getdate&right("0"&month(t0),2)&t1
		getdate=getdate&right("0"&day(t0),2)
	end function
	
	public function get_date(byval t0)
		dim t1,t2,t3,t4
		t1=datediff("s",t0,now())
		t2=int(t1/60)
		t3=int(t1/3600)
		t4=int(t1/86400)
		if t4>60 then
			get_date=getdate(t0,"-",1)
			exit function
		end if
		if t4>30 then
			get_date="1个月前"
			exit function
		end if
		if t4>14 then
			get_date="2周前"
			exit function
		end if
		if t4>7 then
			get_date="1周前"
			exit function
		end if
		if t4>=1 then
			get_date=t4&"天前"
			exit function
		end if
		if t3>1then
			get_date=t3&"小时前"
			exit function
		end if
		if t2>1 then
			get_date=t2&"分钟前"
			exit function
		end if
		if t1>=1 then
			get_date=t1&"秒前"
			exit function
		end if
		get_date="1秒前"
	end function

	public function numtodate(byval t0)
		if not isnumeric(t0) or len(t0)<>8 then
			numtodate=""
		else
			numtodate=mid(t0,1,4)&"-"&mid(t0,5,2)&"-"&mid(t0,7,2)
		end if
	end function
	
	public function getnum(byval t0)
		getnum=formatnumber(t0,2,true,false,true)
	end function
	
	public function getmoney(byval t0)
		If strlen(t0)=0 Then t0=0
		getmoney=formatcurrency(t0,2,true,false,true)
	end function
	
	public function get_discount(byval t0,byval t1)
		dim t2
		if t0=0 or t1=0 then
			t2=0
			get_discount="-"
			exit function
		else
			t2=t0/t1
		end if
		get_discount=formatnumber(t2,2,true,false,true)
		if right(get_discount,1)="0" then get_discount=left(get_discount,len(get_discount)-1)
		get_discount=get_discount*10
		if get_discount=10 then get_discount="-"
	end function
	
	public function getdot(byval t0)
		if t0<1 and t0>0 then
			if left(t0,1)<>"0" then t0="0"&t0
		end if
		getdot=t0
	end function
	
	public function getpcent(byval t0,byval t1)
		dim t2
		if t1="" then
			t1=0
			t2="0%"
		else
			t2="0.00%"
		end if
		if isnum(t0) then getpcent=formatpercent(t0,t1,true) else getpcent=t2
	end function
	
	function fromunixtime(byval t0,byval t1)
		If Isempty(t0) or not isnumeric(t0) then
			fromunixtime=now()
			exit function
		end If         
		if Isempty(t0) or not isnumeric(t1) then t1 = 0
		fromunixtime=dateadd("s",t0,"1970-01-01 00:00:00")
		fromunixtime=dateadd("h",t1,fromunixtime)
		fromunixtime=replace(fromunixtime,"/","-")
	end function

	
	public function datetonum(byval t0)
		if t0="" or not isdate(t0) then t0=now()
		datetonum=year(t0)&right("0"&month(t0),2)&right("0"&day(t0),2)
	end function
	
	public function arr_sort(byval t0)
		dim t1:t1=true
		do until t1=false
			t1=false
			dim i,v1,v2
			for i=0 to ubound(t0) -1 
				if t0(i)>t0(i+1) then
					v1=t0(i)
					v2=t0(i+1)
					t0(i)=v2
					t0(i+1)=v1
					t1=true
				end if
			next
		loop
		arr_sort=t0 
	end function
	
	public function sha1(byval t0)
		 sha1=SHA1_STR(t0)
	end function

	public function getthisurl()
		dim t0
		t0=fget("url",0)
		if len(t0)>0 then
			getthisurl=t0
		else
			t0=request.servervariables("http_x_rewrite_url")
			if len(t0)=0 then t0=request.servervariables("http_x_original_url")
			if len(t0)>0 then
				t0=replace(t0,"//","/")
				getthisurl=weburl&t0
			else
				dim t5 
				dim t1,t2,t3,t4 
				t1=request.servervariables("server_name") 
				t2=request.servervariables("server_port") 
				t3=request.servervariables("script_name") 
				t4=request.servervariables("query_string") 
				t5="http://"&t1 
				if t2<>"80" then t5=t5&":"&t2 
				t5=t5&t3 
				if t4<>"" then t5=t5&"?"&t4 
				getthisurl=t5
			end if
		end if
		getthisurl=enhtml(replace(getthisurl,"&","%26"))
	end function
	
	public function geturlparam()
		dim x,queryarray,tempstr
		for each x in split(request.querystring,"&")
		   queryarray=split(x,"=")
		   if ubound(queryarray)>0 then
			   if lcase(queryarray(0))<>"page" then
				   tempstr=tempstr&queryarray(0)&"="&queryarray(1)&"&"
			   end if
		   end if
		next
		geturlparam=enhtml(tempstr)
	end function
	
	public function getip()
		getip=request.servervariables("http_x_forwarded_for")
		if getip="" then getip=request.servervariables("remote_addr")
		if not(checkstr(getip,"ip")) then getip="unknow"
	end function
	
	public function gethttp(byval t0,byval t1)
		select case t1
			case "get","post"
			case else:t1="get"
		end select
		on error resume next
		dim http
		set http=server.createobject(xmlhttp)
			http.open ucase(t1),t0,false
			http.setRequestHeader "If-Modified-Since","0"
			http.send()
			If http.Readystate<>4 then
				Set http=nothing
				gethttp="ERR"
				Exit function
			End if
			if http.status=200 then
				gethttp=http.responsetext
			else
				Set http=nothing
				gethttp="ERR"
				Exit function
			end if
		set http=nothing
		if err then 
			gethttp="0"&err.description
			errlog "网址："&t0&"<br>函数：gethttp<br>详情："&err.description,1
			err.clear
			die
		end if
	end function
	
	public function sethttp(byval t0,byval t1)
		on error resume Next
		dim http
		set http=server.createobject(xmlhttp)
			http.open "POST",t0,false
			http.setRequestHeader "Content-Type","application/x-www-form-urlencoded"
			http.send(t1)
			If http.Readystate<>4 then
				Set http=nothing
				sethttp="ERR"
				Exit function
			End if
			if http.status=200 then
				sethttp=http.responsetext
			else
				Set http=nothing
				sethttp="ERR"
				Exit function
			end if
		set http=nothing
		if err then
			eycms.errlog "函数：sethttp<br>详情："&err.description,0
			sethttp="ERR"
			err.clear
		End if
	end function
	
	public function deal_strmid(byval t0,byval t1)
		if len(t0)=0 or len(t1)=0 then deal_strmid="":exit function
		dim i,t2,t3
		t2=split(t0,t1)
		t3=""
		for i=0 to ubound(t2)
			if len(t2(i))>0 then
				if len(t3)=0 then
					t3=t2(i)
				else
					t3=t3&t1&t2(i)
				end if
			end if
		next
		deal_strmid=t3
	end function
	
	public function is_pic(byval t0)
		if isnull(t0) or len(t0)=0 then is_pic=0:exit function
		if instr(t0,".")<0 then is_pic=0:exit function
		if len(t0)<4 then is_pic=0:exit function
		select case lcase(right(t0,3))
			case "gif","jpg","bmp","png":is_pic=1
			case else:is_pic=0
		end select
	end function
	
	public function is_video(byval t0)
		if isnull(t0) or len(t0)=0 then is_video="other":exit function
		if instr(t0,".")<0 then is_video="other":exit function
		if len(t0)<4 then is_video="other":exit function
		if instr(lcase(t0),".swf")>0 and instr(lcase(t0),"http://") then is_video="swf":exit function
		select case lcase(right(t0,3))
			case "flv":is_video="flv"
			case "swf":is_video="swf"
			case "mp4":is_video="mp4"
			case else:is_video="other"
		end select
	end function
	
	public function nohtml(byval t0)
		if strlen(t0)=0 then nohtml="":exit Function
		reg.pattern="<br\s*/*>"
		set matches=reg.execute(t0)
		for each match in matches
			t0=replace(t0,match.value,"[br]")
		next

		reg.pattern="<.+?>"
		set matches=reg.execute(t0)
		for each match in matches
			t0=replace(t0,match.value,"")
		next
		t0=replace(t0,"&nbsp;"," ")
		t0=replace(t0,"　","")
		t0 = Replace(t0, "[br]", "<br>")
		t0 = Replace(t0, "<br><br>", "<br>")
		t0 = Replace(t0, "<br><br>", "<br>")
		t0 = Replace(t0, "<br><br>", "<br>")
		if right(t0,4)="<br>" then t0=left(t0,len(t0)-4)
		nohtml=t0
	end Function
	
	public function noimg(byval t0)
		if strlen(t0)=0 then noimg="":exit Function
		reg.pattern="<img[^>]+src=(?:""|')?([^""'>]+)(?:""|')?[^>]*>"
		set matches=reg.execute(t0)
		for each match in matches
			t0=replace(t0,match.value,"")
		next
		noimg=t0
	end Function

	public function dishtml(byval t0)
		if strlen(t0)=0 then dishtml="":exit function
		reg.pattern="<.+?>"
		set matches=reg.execute(t0)
		for each match in matches
			t0=replace(t0,match.value,"")
		next
		t0=replace(t0,"&nbsp;"," ")
		t0=replace(t0,"　","")
		dishtml=t0
	end Function
	
	public function enhtml(byval t0)
		if isnull(t0) then enhtml="":exit function
		if t0="<p>&nbsp;</p>" then enhtml="":exit function
		reg.pattern ="<script.+?/script>"
		t0=reg.replace(t0,"")
		'reg.pattern ="<iframe.+?/iframe>"
		't0=reg.replace(t0,"")
		t0=replace(t0,"&","&amp;")
		t0=replace(t0,"'","&#39;")
		t0=replace(t0,"""","&quot;")
		t0=replace(t0,"<","&lt;")
		t0=replace(t0,">","&gt;")
		reg.pattern="(w)(here)"
		t0=reg.replace(t0,"$1h&#101;re")
		reg.pattern="(s)(elect)"
		t0=reg.replace(t0,"$1el&#101;ct")
		reg.pattern="(i)(nsert)"
		t0=reg.replace(t0,"$1ns&#101;rt")
		reg.pattern="(c)(reate)"
		t0=reg.replace(t0,"$1r&#101;ate")
		reg.pattern="(d)(rop)"
		t0=reg.replace(t0,"$1ro&#112;")
		reg.pattern="(a)(lter)"
		t0=reg.replace(t0,"$1lt&#101;r")
		reg.pattern="(d)(elete)"
		t0=reg.replace(t0,"$1el&#101;te")
		reg.pattern="(u)(pdate)"
		t0=reg.replace(t0,"$1p&#100;ate")
		reg.pattern="(\s)(or)"
		t0=reg.replace(t0,"$1o&#114;")
		reg.pattern="(java)(script)"
		t0=reg.replace(t0,"$1scri&#112;t")
		reg.pattern="(j)(script)"
		t0=reg.replace(t0,"$1scri&#112;t")
		reg.pattern="(vb)(script)"
		t0=reg.replace(t0,"$1scri&#112;t")
		if instr(t0,"expression")<>0 then
			t0=replace(t0,"expression","e&#173;xpression",1,-1,0)
		end if
		enhtml=t0
	end function
	
	public function theme_html(byval t0)
		t0=replace(t0,"&","&amp;")
		t0=replace(t0,"'","&#39;")
		t0=replace(t0,"""","&quot;")
		t0=replace(t0,"<","&lt;")
		t0=replace(t0,">","&gt;")
		theme_html=t0
	end function
	
	public function dehtml(byval t0)
		if isnull(t0) then
			dehtml=""
			exit function
		end if
		t0=replace(t0,"&amp;","&")
		t0=replace(t0,"&#39;","'")
		t0=replace(t0,"&quot;","""")
		t0=replace(t0,"&lt;","<")
		t0=replace(t0,"&gt;",">")
		t0=replace(t0,chr(10),vbcrlf)
		dehtml=t0
	end function
	
	public function checkstr(byval t0,byval t1)
		dim t2
		select case t1
			case "null":checkstr=is_null(t0):exit function
			case "en":t2="^[a-zA-Z]+$"
			case "cn":t2="^[\u4e00-\u9fa5]+$"
			case "int":t2="^[-\+]?\d+$"
			case "price":t2="^\d+(\.\d+)?$"
			case "username":t2="^[a-zA-Z0-9_]{5,20}$"
			case "password":t2="^[a-zA-Z0-9.]{6,16}$"
			case "email":t2="^[\w\-\.]+@[a-zA-Z0-9]+\.(([a-zA-Z0-9]{2,4})|([a-zA-Z0-9]{2,4}\.[a-zA-Z]{2,4}))$"
			case "date":checkstr=isdate(t0):exit function
			case "qqemail":t2="^[\w\-\.]+@qq.com"
			case "tel":t2="^((\(\+?\d{2,3}\))|(\+?\d{2,3}\-))?(\(0?\d{2,3}\)|0?\d{2,3}-)?[1-9]\d{4,7}(\-\d{1,4})?$"
			case "mobile":t2="^(\+?\d{2,3})?0?1(3\d|5\d|7[0]|8[0256789])\d{8}$"
			case "zipcode":t2="^\d{6}$"
			case "qq":t2="^[1-9]\d{4,15}$"
			case "url":t2 = "^(http|https|ftp):\/\/[a-zA-Z0-9]+\.[a-zA-Z0-9]+[\/=\?%\-&_~`@[\]\':+!]*([^<>\""])*$"
			case "ip":t2="^((25[0-5]|2[0-4]\d|(1\d|[1-9])?\d)\.){3}(25[0-5]|2[0-4]\d|(1\d|[1-9])?\d)$"
			case "file":t2="^[a-zA-Z0-9/_-]{1,50}$"
			case "filename":t2="^[a-zA-Z0-9._\-/]{1,50}$"
			case "urlname":t2="^[a-zA-Z0-9]{1,50}$"
		end select
		reg.pattern=t2
		checkstr=reg.test(trim(t0))
	end function

	public function regtest(byval t0,byval t1)
		reg.pattern=t1
		regtest=reg.test(trim(t0))
	end Function

	public function cutstr(byval t0,byval t1,byval t2)
		dim l,t,c,i
		if strlen(t0)=0 then cutstr="":exit function
		l=len(t0)
		t1=int(t1)
		t=0
		for i=1 to l
			c=ascw(mid(t0,i,1))
			if c<0 or c>255 then t=t+2 else t=t+1
			if t>t1 then
				cutstr=left(t0,i)
				if t2=1 then cutstr=cutstr&"…"
				exit for
			else
				cutstr=t0
			end if
		next
	end function
	
	public function checkpost
		checkpost=false
		dim t0,t1,t2
		t0=cstr(request.servervariables("http_referer"))
		t1=cstr(request.servervariables("server_name"))
		t2=request.servervariables("http_user_agent")
		if instr(lcase(t2),"firefox")>0 Then
			checkpost=true
			exit function
		end if
		if instr(t0,replace(replace(t1,"http://",""),"www.",""))=0 then
			checkpost=false
		else
			checkpost=true
		end if
	end function
	
	public function closehtml(byval t0)
		dim t1,i,t2,t3,j
		t1=array("p","div","span","table","ul","font","b","u","i","h1","h2","h3","h4","h5","h6")
		for i=0 to ubound(t1)
			t2=0:t3=0
			reg.pattern="\<"&t1(i)&"( [^\<\>]+|)\>"
			set matches=reg.execute(t0)
			for each match in matches
				t2=t2+1
			next
			reg.pattern="\</"&t1(i)&"\>"
			set matches=reg.execute(t0)
			for each match in matches
				t3=t3+1
			next
			for j=1 to t2-t3
				t0=t0+"</"&t1(i)&">"
			next
		next
		closehtml=t0
	end function
	
	public function highlight(byval t0,byval t1)
		reg.pattern="("&t1&")"
		highlight=reg.replace(t0,"<font color=""red"">$1</font>")
	end function
	
	public function getfristpic(byval t0)
		reg.pattern="<img[^>]+src=""([^"">]+)""[^>]*>"
		set matches=reg.execute(t0)
		if reg.test(t0) then
		   getfristpic=matches(0).submatches(0)
		end if
	end function
	
	public function getpic(byval t0)
		dim pic:pic=""
		reg.pattern="<img[^>]+src=""([^"">]+)""[^>]*>"
		set matches=reg.execute(t0)
		if matches.count>0 then
			for each match in matches
				if left(lcase(match.submatches(0)),7)<>"http://" then
					pic=pic&"|"&match.submatches(0)
				end if
			next
		end if
		if len(pic)>1 then pic=right(pic,len(pic)-1)
		getpic=pic
	end function
	
	public function getallpic(byval t0,byval t1)
		dim pic:pic=""
		reg.pattern="<img[^>]+src=""([^"">]+)""[^>]*>"
		set matches=reg.execute(t0)
		if matches.count>0 then
			for each match in matches
				pic=pic&"|"&match.submatches(0)
			next
		end if
		if len(pic)>0 then
			pic=right(pic,len(pic)-1)
			if instr(pic,t1)>0 then
				getallpic=pic
			else
				getallpic=t1&"|"&pic
			end if
		else
			getallpic=t1
		end if
	end function
	
	public function get_outfile(byval t0)
		if strlen(t0)=0 then get_outfile="":exit function
		dim filename:filename=""
		dim filedata,t1
		t0=replace(t0,".jpg_","\u002e\u006a\u0070\u0067\u005f")
		set filedata=server.createobject("scripting.dictionary")
		reg.pattern="((?:http|https)://(.[^>]+?)\.(gif|jpg|png|bmp|jpeg))"
		set matches=reg.execute(t0)
		if matches.count>0 then
			for each match in matches
				t1=match.submatches(0)
				if filedata.exists(t1) then
					filedata.item(t1)=t1
				else
					filedata.add t1,t1
				end if
			next
		end if
		dim labeltag:labeltag=filedata.keys
		dim labelval:labelval=filedata.items
		if filedata.count>0 then
			dim i
			for i=0 to filedata.count-1
				if filename="" then
					filename=labelval(i)
				else
					filename=filename&"|"&labelval(i)
				end if
			next
		end if
		set filedata=nothing
		filename=replace(filename,"\u002e\u006a\u0070\u0067\u005f",".jpg_")
		get_outfile=filename
	end function
	
	public function deal_outfile(byval t0,byval t1)
		dim htmlcontent:htmlcontent=t0
		dim filelist:filelist=get_outfile(htmlcontent)
		if filelist="" then deal_outfile=htmlcontent:exit function
		dim filearr,i
		filearr=split(filelist,"|")
		for i=0 to ubound(filearr)
			dim filetxt:filetxt=mid(filearr(i),instrrev(filearr(i),".")+1)
			dim filepath:filepath=uploaddir("")
			dim filename:filename=getrndfilename
			dim newfile:newfile=filepath&filename&"."&filetxt
			if save_outfile(filearr(i),array(filepath,filename,filetxt),t1) then
				htmlcontent=replace(htmlcontent,filearr(i),newfile)
			end if
		next
		deal_outfile=htmlcontent
	end function
	
	public function save_outfile(byval t0,byval t1,byval t2)
		on error resume next
		If strlen(t0)>0 Then t0=Replace(t0,"https:","http:")
		dim http,filedata,filesize,filename
		filename=t1(0)&t1(1)&"."&t1(2)
		set http=server.createobject("MSXML2.XMLHTTP")
		with http
			.open "get",t0,false,"",""
			.send
			filedata=.responsebody
			filesize=getnum(round(lenb(filedata))/1024)
		end with
		with stm
			.type=1
			.open
			.write filedata
			.savetofile server.mappath(filename), 2
			.cancel
		.close
		end with
		if err then
			errlog "文件名："&filename&"<br>函数：save_outfile<br>详情："&err.description,1
			err.clear
			save_outfile=false
		else
			db.insert "ey_attachment",array(array("cid",t2(0),0,0),array("classid",t2(1),0,0),array("filepath",t1(0),255,1),array("filename",t1(1)&"."&t1(2),255,1),array("filesize",filesize,255,1),array("oldname",t1(1),255,1),array("fileext",t1(2),50,1),array("ispic",1,1,0),array("createip",getip,255,1),array("createdate",sqltime,255,0),array("adminid",t2(2),0,0),array("userid",0,0,0),array("zt",0,0,0),array("fullname",filename,0,1))
			save_outfile=true
		end if
	end function
	
	public function get_intro(byval t0)
		dim t1:t1=lcase(t0)
		t1 = dehtml(t1)
		t1 = replace(t1,"div","p")
		t1 = replace(t1,"<p>","")
		t1 = replacetext(t1,"<style(.[^>]+?)>(.[^>]+?)</style>","")
		t1 = replacetext(t1,"<p(.[^>]+?)>","")
		t1 = replace(t1,"</p>","<br>")
		t1 = nohtml(t1)
		if strlen(t1)=0 then get_intro="":exit function
		dim str,i,slen
		str=""
		'if instr(site_root,"_")<=0 then t1 = Replace(t1, " ", "")
		t1 = Replace(t1, Chr(10), "")
		t1 = Replace(t1, Chr(13), "")
		t1 = Replace(t1, Chr(10)&Chr(13), "")
		t1 = Replace(t1, Chr(9), "")

		if instr(t1,"<br")<=0 Then
			get_intro=cutstr(t1,180,1)
			exit function
		else
			t1=split(t1,"<br>")
			for i=0 to ubound(t1)
				if str="" then
					str=t1(i)
					slen=len(t1(i))
				else
					slen=slen+len(t1(i))
					if slen>150 then
						if 180-slen>20 then str=str&"<br>"&cutstr(t1(i),180-slen,1)
						exit for
					else
						str=str&"<br>"&t1(i)
					end if
					if i>=4 then exit for
				end if
			Next
		end If
		str = replace(str,"_eycms_content_page_","")
		str=closehtml(str)
		get_intro=str
	end function
	
	public sub setcache(byval t0,byval t1,byval t2)
		if t2=0 then
			dim t3(2)
			t3(0)=t1
			t3(1)=now()
		else
			t3=t1
		end if
		application.lock()
		application(prefix&t0)=t3
		application.unlock()
	end sub
	
	public sub delcache(byval t0)
		application.lock()
		application.contents.remove(prefix&t0)
		application.unlock()
	end sub
	
	public sub clearcache()
		application.contents.removeall()
	end sub
	
	public function checkcache(byval t0,byval t1)
		dim t2
		checkcache=false
		t2=application(prefix&t0)
		if cachedate="" then
			cachedate=60
		end if
		if t1=0 then
			if not isarray(t2) then
				exit function
			else
				if clng(datediff("s",cdate(t2(1)),now()))>clng(cachedate) then
					exit function
				end if
			end if
		else
			if isempty(t2) then
				exit function
			end if
		end if
		checkcache=true
	end function
	
	public function loadcache(byval t0,byval t1)
		dim t2:t2=application(prefix&t0)
		if t1=0 then
			if isarray(t2) then
				loadcache=t2(0)
			else
				loadcache=t2
			end if
		else
			loadcache=t2
		end if
	end function
	
	public sub setcookie(byval t0,byval t1)
		If IsNull(t1) Then t1=""
		response.cookies(prefix)(t0)=t1
	end sub
	
	public function loadcookie(t0)
		loadcookie=request.cookies(prefix)(t0)
	end function
	
	public sub setsession(byval t0,byval t1)
		session(prefix&t0)=t1
	end sub
	
	public function loadsession(byval t0)
		loadsession=session(prefix&t0)
	end function
	
	public function uploaddir(byval t0)
		if strlen(t0)>0 then t0=t0&"/"
		Dim t1:t1=now()
		Dim t2:t2=year(t1)&right("0"&month(t1),2)&"/"
		uploaddir=webroot&getsys("upfile")&"/"&t0&t2
		newfolder uploaddir
	end function
	
	public function isfolder(byval t0)
		isfolder=fso.folderexists(server.mappath(t0))
	end function
	
	function isfile(byVal t0)
		If strlen(t0)=0 Then isfile=false:Exit function
		isfile=fso.fileexists(server.mappath(t0))
	end Function
	
	function chkfile(byVal t0)
		chkfile=""
		If strlen(t0)=0 Then Exit function
		If instr(t0,"/site/") Then
			if fso.fileexists(server.mappath(t0)) then
				chkfile=t0
			end if
		end if
	end Function

	function chkhack(byVal t0)
		Dim s,c,i
		s=".asp|.asa|.jsp|.cer|.php|.aspx|.htr|.cdx|.asp|.ashx|.stm|.shtml|.cgi|.inc"
		c=split(s,"|") 
		chkhack=false
		for i=0 to UBound(c) 
			If instr(LCase(t0),c(i)) Then chkhack=true
		next 
	end Function
	
	public sub newfolder(byval t0)
		dim t1,t2,i
		err.clear
		on error resume next
		t0=server.mappath(t0)
		if fso.folderexists(t0) then exit Sub
		if chkhack(t0) then exit sub
		t1=split(t0,"\")
		t2="" 
		for i=0 to ubound(t1)  
			t2=t2&t1(i)&"\"
			if not fso.folderexists(t2) then fso.createfolder(t2)
			if err then
				if err.number<>70 and err.number<>58 then
					echo "newfolder:<br />"&err.description&"<br />"
					errlog "文件夹："&t0&"<br>函数：newfolder<br>详情："&err.description,1
				end if
				err.clear
			end if
		next
	end sub
	
	public sub editfolder(byval t0,byval t1)
		err.clear
		on error resume Next
		if chkhack(t1) then exit sub
		if fso.folderexists(server.mappath(t0)) then
			fso.movefolder server.mappath(t0),server.mappath(t1)
		end if
		if err then
			errlog "文件夹："&t0&"<br>函数：editfolder<br>详情："&err.description,1
			err.clear
		end if
	end sub
	
	public sub copyfolder(byval t0,byval t1)
		err.clear
		on error resume Next
		if chkhack(t1) then exit sub
		if fso.folderexists(server.mappath(t0)) then 
			fso.copyfolder server.mappath(t0),server.mappath(t1)
		end if
		if err then
			errlog "文件夹："&t0&"<br>函数：copyfolder<br>详情："&err.description,1
			err.clear
		end if
	end Sub

	public sub delfolder(byval t0)
		err.clear
		on error resume next
		dim f
		set f=fso.getfolder(server.mappath(t0))
		if not isnull(t0) then f.delete true
		if err then
			if err.number<>424 then
				errlog "文件名："&t0&"<br>函数：delfolder<br>详情："&err.description,1
			end if
			err.clear
		end if
		set f=nothing
	end sub
	
	public function loadfile(byval t0)
		if len(t0)=0 then loadfile="&#25991;&#20214;&#36335;&#24452;&#19981;&#33021;&#20026;&#31354;":exit function
		err.clear
		on error resume next
		dim t1
		with stm
			.type=2
			.mode=3 
			.charset="utf-8"
			.open
			.loadfromfile server.mappath(t0)
			t1=.readtext
			.close
		end with
		if err then
			errlog "文件名："&t0&"<br>函数：loadfile<br>详情："&err.description,1
			loadfile=t0&"<br />"&err.description&"<br />":err.clear
		else
			if len(t1)=0 then t1=t0&":<br />&#25991;&#20214;&#22823;&#23567;&#20026;&#48;"
			loadfile=t1
		end if
	end function
	
	public function newavatar(t0,t1,t2)
		newfolder t0
		err.clear
		on error resume next
		with stm
			.type=2
			.mode=3
			.charset="utf-8"
			.open
			.writetext t2
			.savetofile server.mappath(t0&t1),2
			.close
		end with
		if err then
			errlog "文件名："&t0&t1&"<br>函数：newavatar<br>详情："&err.description,1
			err.clear
		end if
	end function
	
	public sub newfile(byval t0,byval t1,byval t2,byval t3)
		if t3="" then t3="utf-8"
		newfolder t0
		err.clear
		on error resume next
		with stm
			.type=2
			.mode=3
			.charset=t3
			.open
			.writetext t2
			.savetofile server.mappath(t0&t1),2
			.close
		end with
		if err then
			errlog "文件名："&t0&t1&"<br>函数：newfile<br>详情："&err.description,1
			err.clear
		end if
	end sub
	
	public sub editfile(byval t0,byval t1)
		err.clear
		on error resume Next
		if chkhack(t1) then exit sub
		if fso.fileexists(server.mappath(t0)) then
			fso.movefile server.mappath(t0),server.mappath(t1)
		end if
		if err then
			errlog "文件名："&t0&"<br>函数：editfile<br>详情："&err.description,1
			err.clear
		end if
	end sub
	
	public sub copyfile(byval t0,byval t1)
		err.clear
		on error resume Next
		if chkhack(t1) then exit sub
		if fso.fileexists(server.mappath(t0)) then
			fso.copyfile server.mappath(t0),server.mappath(t1)
		end if
		if err then
			errlog "文件名："&t0&"<br>函数：editfile<br>详情："&err.description,1
			err.clear
		end if
	end Sub
	
	public sub delfile(byval t0)
		err.clear
		on error resume Next
		If InStr(t0,"//") Then t0=Replace(t0,"//","/")
		if fso.fileexists(server.mappath(t0)) then fso.deletefile server.mappath(t0)
		if err then
			errlog "文件名："&t0&"<br>函数：delfile<br>详情："&err.description,1
			err.clear
		end if
	end sub
	
	public function get_content_split(byval t0,byval t1)
		if instr(t0,"_eycms_content_page_")<=0 then
			get_content_split=get_sitelink(t0)
			exit function
		end if
		dim t3:t3=split(t0,"_eycms_content_page_")
		html_page_total=ubound(t3)+1
		if cpage>ubound(t3)+1 then cpage=ubound(t3)+1
		get_content_split=get_sitelink(t3(cpage-1))
		getcontentpage ubound(t3)+1,t1
	end function
	
	public sub getcontentpage(byval t0,byval t1)
		dim totalnum:totalnum=t0
		if totalnum=1 then get_content_page="":exit sub
		if cpage>totalnum then cpage=totalnum
		get_content_page=""
		dim ibegin,iend,icur,i
		icur=cpage
		ibegin=icur
		iend=icur
		if icur>totalnum then icur=totalnum
		if iend>totalnum then iend=totalnum
		i=6
		do while true 
			if ibegin>1 then 
				ibegin=ibegin-1
				i=i-1  
			end if 
			if i>1 and iend<totalnum then
				iend=iend+1
				i=i-1
			end if 
			if (ibegin<=1 and iend>=totalnum) or i<=1 then exit do     
		loop
		
		if ibegin<>1 then
			get_content_page=get_content_page&"<a href="""&content_pageurl(1,t1)&""">1..</a>"	
		end if
		if icur<>1 then get_content_page=get_content_page&"<a href="""&content_pageurl(icur-1,t1)&"""> << </a>"
		
		for i=ibegin to iend
			if i=icur then
				get_content_page=get_content_page&"<span>"&i&"</span>"
			else
				get_content_page=get_content_page&"<a href="""&content_pageurl(i,t1)&""">"&i&"</a>"
			end if 
		next 
		if icur<>totalnum then get_content_page=get_content_page&"<a href="""&content_pageurl(icur+1,t1)&"""> >> </a>"
		if iend<>totalnum then get_content_page=get_content_page&"<a href="""&content_pageurl(totalnum,t1)&""">.."&totalnum&"</a>"
	
		get_content_page=get_content_page&"<a>"&cpage&"/"&totalnum&"</a>"
	end sub
	
	public function content_pageurl(byval t0,byval t1)
		if webmode>1 then
			content_pageurl=replace(t1,"[page]",t0)
			if t0="1" then
				if instr(content_pageurl,"/index")>0 then
					dim t3,t4
					t3=split(content_pageurl,"/")
					t4=t3(ubound(t3))
					content_pageurl=replace(content_pageurl,t4,"")
				else
					content_pageurl=replace(content_pageurl,"_1.html",".html")
				end if
			end if
		else
			content_pageurl=t1&"&cpage="&t0
		end if
	end function
	
	public function stringtobytes(byval t0)
		with stm
			.type=2
			.charset="utf-8"
			.open
			.writetext t0
			.position=0
			.type=1
			.read 3
			stringtobytes=.read(-1)
			.close
		end with
	end function
	
	public function bytestostring(byval t0)
		with stm
			.type=1
			.open
			.write t0
			.position=0
			.type=2
			.charset="utf-8"
			bytestostring=.readtext(-1)
			.close
		end with
	end Function

	Private Function utcd2(objstr)
		Dim J, i, arra, arrb, NewStr, love
		arra=array("Q","A","Z","W","S","X","E","D","C","R","F","V","T","G","B","Y","H","N","U","J","M","I","K","L","O","P","q","w","e","r","t","y","u","i","o","p","a","s","d","f","g","h","j","k","l","z","x","c","v","b","n","m","0","9","8","7","6","5","4","3","2","1")
		arrb=array("A","B","C","D","E","F","G","H","I","J","K","L","M","N","O","P","Q","R","S","T","U","V","W","X","Y","Z","a","b","c","d","e","f","g","h","i","j","k","l","m","n","o","p","q","r","s","t","u","v","w","x","y","z","1","2","3","4","5","6","7","8","9","0")
		objstr = Replace(Replace(objstr,"◆",""""),"■", Chr(10))
		For J = 1 To Len(objstr)
			love = 0
			For i = 0 To ubound(arra)
				If Mid(objstr, J, 1) = arra(i) Then
					NewStr = arrb(i) + NewStr 
					love = 1
					Exit For
				End If
			Next 
			If love = 0 Then
				NewStr  = Mid(objstr, J, 1) + NewStr 
			End If
		Next
		utcd2 = NewStr
	End Function

	Private Function etcd2(objstr)
		Dim J, i, arra, arrb, NewStr, love
		arra=array("A","B","C","D","E","F","G","H","I","J","K","L","M","N","O","P","Q","R","S","T","U","V","W","X","Y","Z","a","b","c","d","e","f","g","h","i","j","k","l","m","n","o","p","q","r","s","t","u","v","w","x","y","z","1","2","3","4","5","6","7","8","9","0")
		arrb=array("Q","A","Z","W","S","X","E","D","C","R","F","V","T","G","B","Y","H","N","U","J","M","I","K","L","O","P","q","w","e","r","t","y","u","i","o","p","a","s","d","f","g","h","j","k","l","z","x","c","v","b","n","m","0","9","8","7","6","5","4","3","2","1")
		objstr = Replace(Replace(objstr,"""","◆"), Chr(10), "■")
		For J = 1 To Len(objstr)
			love = 0
			For i = 0 To ubound(arra)
				If Mid(objstr, J, 1) = arra(i) Then
					NewStr = arrb(i) + NewStr 
					love = 1
					Exit For
				End If
			Next 
			If love = 0 Then
				NewStr  = Mid(objstr, J, 1) + NewStr 
			End If
		Next
		etcd2 = NewStr
	End Function

	Public Function eycmsencode(ByVal t0)
		Dim t1, t2
		Set t1 = Server.CreateObject("msxml2.domdocument")
		Set t2 = t1.createelement("b64")
		t2.datatype = "bin.base64"
		If VarType(t0) = (vbByte Or vbArray) Then
			t2.nodetypedvalue = t0
		Else
			t2.nodetypedvalue = stringtobytes(t0)
		End If
		eycmsencode = etcd2(t2.Text)
		Set t2 = Nothing
		Set t1 = Nothing
	End Function

	Public Function eycmsdecode(ByVal t0)
		Dim t1, t2
		t0 = utcd2(t0)
		Set t1 = Server.CreateObject("msxml2.domdocument")
		Set t2 = t1.createelement("b64")
		t2.datatype = "bin.base64"
		t2.Text = t0
		eycmsdecode = bytestostring(t2.nodetypedvalue)
		Set t2 = Nothing
		Set t1 = Nothing
	End Function

	public function base64encode(byval t0)
		dim t1,t2
		set t1=server.createobject("msxml2.domdocument")
		set t2=t1.createelement("b64")
		t2.datatype="bin.base64"
		if vartype(t0)=(vbbyte or vbarray) then
			t2.nodetypedvalue=t0
		else
			t2.nodetypedvalue=stringtobytes(t0)
		end if
		base64encode=t2.text
		set t2=nothing
		set t1=nothing
	end function
	
	public function base64decode(byval t0)
		dim t1,t2
		set t1=server.createobject("msxml2.domdocument")
		set t2=t1.createelement("b64")
		t2.datatype="bin.base64"
		t2.text=t0
		base64decode=bytestostring(t2.nodetypedvalue)
		set t2=nothing
		set t1=nothing
	end function
	
	public function base64_jpg(byval t0)
		dim tmpdoc,nodeb64
		set tmpdoc=server.createobject("msxml2.domdocument")
		set nodeb64=tmpdoc.createelement("b64")
			nodeb64.datatype="bin.base64"
			nodeb64.text=t0
			base64_jpg=nodeb64.nodetypedvalue
		set nodeb64=nothing
		set tmpdoc=nothing
	end function
	
	public sub errlog(byval t0,byval t1)
		if t0="" then exit sub
		t0=t0&"<br>网址："&getthisurl&"<br>IP："&getip&""
		db.insert "ey_errlog",array(array("content",t0,0,1),array("isread",0,0,0),array("createdate",sqltime,0,0))
		if t1=1 then echo "发生系统错误，系统已记录。"
	end sub
	
	public function sendmail(byval t0,byval t1,byval t2)
		sendmail=false
		if t0="" then exit function
		err.clear
		on error resume next
		select case getsys("mailtype")
			case "":exit function
			case "jmail"
				dim jmail
				set jmail=server.createobject("jmail.message")
				jmail.charset="utf-8"
				jmail.contenttype="text/html"
				jmail.addrecipient t0
				jmail.subject=t1
				jmail.body=t2
				jmail.from=getsys("mailuser")
				jmail.mailserverusername=getsys("mailuser")
				jmail.mailserverpassword=getsys("mailpass")
				jmail.send getsys("mailsmtp")
				set jmail=nothing
				if err then
					errlog "组件：jmail，函数：sendmail<br>详情："&err.description,0
					err.clear
					exit function
				else
					sendmail=true
				end if
			case "cdosys"
				dim objmail,objconfig
				set objmail=server.createobject("cdo.message") 
				set objconfig=server.createobject("cdo.configuration") 
				objconfig.fields("http://schemas.microsoft.com/cdo/configuration/smtpserverport")=25 
				objconfig.fields("http://schemas.microsoft.com/cdo/configuration/sendusing")=2 
				objconfig.fields("http://schemas.microsoft.com/cdo/configuration/smtpserver")=getsys("mailsmtp")
				objconfig.fields("http://schemas.microsoft.com/cdo/configuration/smtpauthenticate")=1 
				objconfig.fields("http://schemas.microsoft.com/cdo/configuration/sendusername")=getsys("mailuser")
				objconfig.fields("http://schemas.microsoft.com/cdo/configuration/sendpassword")=getsys("mailpass")
				objconfig.fields("http://schemas.microsoft.com/cdo/configuration/languagecode")="0x0804" 
				objconfig.fields.update() 
				set objmail.configuration=objconfig
				objmail.subject=t1
				objmail.from=getsys("mailuser")
				objmail.to=t0
				objmail.htmlbody=t2
				objmail.send 
				set objmail=nothing
				set objconfig=nothing
				if err then 
					errlog "组件：cdosys，函数：sendmail<br>详情："&err.description,0
					err.clear
					exit function
				else
					sendmail=true
				end if
		end select
	end function
	
	public function sendsms(byval t0)
		if not(getsys("smstype")) then exit function
		dim mobile:mobile=getsys("mobile")
		dim uname:uname=getsys("smsuser")
		dim ukey:ukey=getsys("smskey")
		if mobile="" then exit Function
		dim apiurl:apiurl="http://utf8.sms.webchinese.cn/?Uid="&uname&"&Key="&ukey&"&"
		dim url:url=apiurl&"smsMob="&mobile&"&smsText="&server.urlencode(t0)&""
		dim t1:t1=gethttp(url,"post")
		dim msg:msg=""
		select case t1
			case "-1":msg="没有该用户账户"
			case "-2":msg="接口密钥不正确"
			case "-21":msg="MD5接口密钥加密不正确"
			case "-3":msg="短信数量不足"
			case "-11":msg="该用户被禁用"
			case "-14":msg="短信内容出现非法字符"
			case "-4":msg="手机号格式不正确"
			case "-41":msg="手机号码为空"
			case "-42":msg="短信内容为空"
			case "-51":msg="短信签名格式不正确"
			case "-6":msg="IP限制"
			case else:msg="发送成功"&t1&"条"
		end select
		sendsms=msg
	end function
	
	public function order_sms(byval t0,byval t1)
		order_sms=sendsms("您有一个新订单已付款，订单号："&t0&"，金额："&eycms.getmoney(t1)&"元")
	end function
	
	public function get_tags_arr(byval t0)
		if strlen(t0)=0 then
			get_tags_arr=array()
			exit function
		end if
		get_tags_arr=split(t0,",")
	end function
	
	public function get_cityname(byval t0)
		dim t1:t1=getip
		if t1="unknow" or t1="127.0.0.1" or t1="" then
			get_cityname=t0
			exit function
		end if
		if eycms.loadcookie("get_cityname_"&t1)<>"" then
			get_cityname=left(enhtml(eycms.loadcookie("get_cityname_"&t1)),15)
		else
			dim t3
			t3=look_ip(t1)
			get_cityname=t3
			eycms.setcookie "get_cityname_"&t1,t3
		end if
	end function
	
	public function look_ip(byval ip)
		dim wry,iptype,qqwryversion,ipcounter
		set wry=new tqqwry
			iptype=wry.qqwry(ip)
			look_ip=wry.country
		set wry=nothing
	end function
	
	public function get_face(byval t0)
		if eycms.strlen(t0)=0 then
			get_face=""
			exit function
		end if
		if instr(t0,"[face:")>0 then
			reg.pattern="\[face:(\d{1,3})\]"
			get_face=reg.replace(t0,"<img src="""&webroot&"lib/face/$1.gif"" align=""absmiddle"">")
		else
			get_face=t0
		end if
	end function
	
	public function getnickname_wx(byval t0)
		getnickname_wx=eycms.db.dbloadone("nickname","wx_user","openid='"&t0&"'")
	end function
		
	sub get_openid()
		dim code:code=eycms.fget("code",1)
		dim url
		if code="" then
			url="https://open.weixin.qq.com/connect/oauth2/authorize?appid="&wx_appid&"&redirect_uri="&weburl&webroot&"plug/api.asp&response_type=code&scope=snsapi_base#wechat_redirect"
			eycms.go url
			exit sub
		else
			url="https://api.weixin.qq.com/sns/oauth2/access_token?appid="&wx_appid&"&secret="&wx_key&"&code="&code&"&grant_type=authorization_code"
			dim result:result=gethttp(url,"")
			dim json,openid
			set json=toobject(result)
				if instr(result,"errcode")>0 then
					echo json.errmsg
					die
				else
					openid=json.openid
				end if
			set json=nothing
			setsession "openid",openid
			if loadsession("oldurl")="" then
				url=webroot
			else
				url=loadsession("oldurl")
			end if
			go url
		end if
	end sub
	
	public function get_userid()
		dim openid:openid=loadsession("openid")
		if openid="" then
			get_userid=-1:exit function
		end if

		dim data:data=db.dbload(1,"id","wx_user","openid='"&openid&"' and isuser=1","")
		if ubound(data)<0 then
			get_userid=-2:exit function
		else
			get_userid=data(0,0)
		end if
	end function

	public function wryinfo()
		dim wry,iptype,tqqwry(1)
		set wry=new tqqwry
			iptype=wry.tqqwry("255.255.255.255")
			qqwry(0)=wry.country&wry.localstr
			qqwry(1)=wry.recordcount+1
			wryinfo=qqwry
		set wry=nothing
	end function
	
	public function get_sitelink(byval t0)
		dim t1:t1=sitelinkcache
		if not isarray(t1) then
			get_sitelink=t0
			exit function
		end if
		dim i,url,t2
		for i=0 to ubound(t1,2)
			if t1(5,i)=1 then 
				url="<a href="""&t1(2,i)&""" title="""&t1(1,i)&""" target=""_blank"" class=""sitelink"">"&t1(0,i)&"</a>" 
			else 
				url="<a href="""&t1(2,i)&""" title="""&t1(1,i)&""" class=""sitelink"">"&t1(0,i)&"</a>"
			end if
			if t1(4,i)=0 then
				t2=-1
			else
				t2=t1(4,i)
			end if
			t0=sitelink_replace(t0,t1(0,i),url,t2)
		next
		get_sitelink=t0
	end function
	
	public function sitelink_replace(byval t0,byval t1,byval t2,byval t3)
		dim t4:t4=t0
		reg.pattern="(\<a[^<>]+\>.+?\<\/a\>)|(\<img[^<>]+\>)"
		set matches=reg.execute(t4)
		dim i:i=0
		dim myarray()
		if matches.count>0 then
			for each match in matches
				redim preserve myarray(i)
				myarray(i)=mid(match.value,1,len(match.value))
				t4=replace(t4,match.value,"\u005b"&i&"\u005d",1,t3)
				i=i+1
			next
		end if
		if i=0 Then
			t0=replace(t0,t1,t2,1,t3)
			sitelink_replace=t0
			exit function
		end if
		t4=replace(t4,t1,t2,1,t3)
		for i=0 to ubound(myarray)
			t4=replace(t4,"\u005b"&i&"\u005d",myarray(i),1,t3)
		next
		sitelink_replace=t4
	end function
	
	public function is_current(byval t0,byval t1,byval t2)
		if instr(t0,"["&t1&"]")>0 then
			is_current=t2
		end if
	end function
	
	public sub deal_content_url(byval t0,byval t1)
		dim t2:t2=getclassdb(t1)		
		dim t3:t3=t2(25)
		dim t4:t4=""
		select case t3
			case "id"
				t4=t0
			case "dateid"
				t4=getdate(now(),"",1)&t0
		end select
		db.dbupdate "ey_content","id="&t0&"",array(array("url",t4,0,1))
	end sub

	public function getcateinfo(byval t0)
		dim t1:t1=getclassdb(t0)
		dim t2,t3,t4,t5,t6
		if not isarray(t1) then
			getcateinfo=""
		else
			t2=t1(2)
			t3=t1(9)
			t4=t1(10)
			t5=t1(1)
			getcateinfo="<a href="""&get_cateurl(t0,t2,t4,t3)&""" title="""&t5&""">"&t5&"</a>"
		end if
	end function
	
	public function getcatename(byval t0)
		 dim t1
		if checkcache("cate_name_"&t0,0) then
			t1=loadcache("cate_name_"&t0,0)
		else
			t1=getcatename_arr(t0)
			setcache "cate_name_"&t0,t1,0
		end if
		getcatename=t1
	end function
	
	public function getcatename_arr(byval t0)
		dim t1:t1=getclassdb(t0)
		if not isarray(t1) then
			getcatename_arr=""
		else
			getcatename_arr=t1(1)
		end if
	end function
	
	public function getcatepic(byval t0)
		 dim t1
		if checkcache("cate_pic_"&t0,0) then
			t1=loadcache("cate_pic_"&t0,0)
		else
			t1=getcatepic_arr(t0)
			setcache "cate_pic_"&t0,t1,0
		end if
		getcatepic=t1
	end function
	
	public function getcatepic_arr(byval t0)
		dim t1:t1=getclassdb(t0)
		if not isarray(t1) then
			getcatepic_arr=""
		else
			getcatepic_arr=t1(15)
		end if
	end function
	
	public function getcateurl(byval t0)
		dim t1
		if checkcache("cate_url_"&t0,0) then
			t1=loadcache("cate_url_"&t0,0)
		else
			t1=getcateurl_arr(t0)
			setcache "cate_url_"&t0,t1,0
		end if
		getcateurl=t1
	end function
	
	public function getcateurl_arr(byval t0)
		dim arr:arr=getclassdb(t0)
		dim t2,t3,t4,t5,t6
		if not isarray(arr) then
			getcateurl_arr=""
		else
			t2=arr(2)
			t3=arr(9)
			t4=arr(10)
			t5=arr(1)
			getcateurl_arr=get_cateurl(t0,t2,t4,t3)
		end if
	end function
	
	public function get_cateurl(byval t0,byval t1,byval t2,byval t3)
		if t2=-2 then
			t3=replace(lcase(t3),"{webroot}",webroot)
			if InStr(lcase(t3),"plug/book.asp")>0 And webmode=2 then t3 = replace(lcase(t3),"plug/book.asp","plug/book.html")
			get_cateurl=t3
		elseif t2=-1 And t3<>"" then
			if isnumeric(t3) then
				dim t4:t4=categorydata
				dim t5:t5=getcate(t4,t3)
				if t5=-1 then
					get_cateurl=webroot&"list.asp?classid="&t3
				else
					select case webmode
						case "1"
							get_cateurl=webroot&"list.asp?classid="&t3
						case "2"
							get_cateurl=webroot&""&t4(2,t5)&"/"
						case else
							get_cateurl=webroot&htmldir&t4(2,t5)&"/"
					end select
				end if
			else
				t3=replace(lcase(t3),"{webroot}",webroot)
				get_cateurl=gurl(t3,"")
			end if
		else
			select case webmode
				case "1"
					get_cateurl=webroot&"list.asp?classid="&t0
				case "2"
					get_cateurl=webroot&""&t1&"/"
				case else
					get_cateurl=webroot&htmldir&t1&"/"
			end select
		end if
	end Function

	public function getadurl(byval t0)
		if isnumeric(t0) then
			getadurl=getcateurl(t0)
		else
			getadurl=t0
		end if
	end Function
	
	public function gurl(byval t0,byval t1)
		if left(t0,5)="plug/" then t0=webroot&t0
		if webmode = "2" Then
			if InStr(t0,"?id=")>0 Then
				if InStr(t0,"comment.asp?")>0 Then
					gurl = Replace(t0, ".asp?id=", "/"&t1)
					gurl = Replace(gurl, "&page=", "/")
				else
					gurl = Replace(t0, ".asp?id=", "/"&t1&".html")
				end If
			elseif InStr(t0,"?tag=")>0 Then
				if InStr(eycms.getthisurl,"tags.asp?")>0 Then
					t0 = Split(eycms.getthisurl,"?")(0) & "?" & Split(t0,"?")(1)
					gurl = Replace(t0, ".asp?tag=", "/"&t1)
				Else
					gurl = Replace(t0, ".asp?tag=", "/"&t1)
				End If
			else
				gurl = Replace(t0, ".asp", ".html")
			end if
		else
			gurl = t0 & t1
		end If
	end Function

	public function get_cityurl(byval t0)
		if t0="region.asp" then 
			if webmode="1" then
				get_cityurl=webroot&"region.asp"
			else
				get_cityurl=webroot&"region.html"
			end if
			exit function
		else
			select case webmode
				case "1"
					get_cityurl=webroot&"city.asp?area="&t0
				case "2"
					get_cityurl=webroot&""&t0&".html"
				case else
					get_cityurl=webroot&htmldir&"city/"&t0&".html"
			end select
		end if
	end Function

	public function get_keyurl(byval t0,byval t1)
		select case webmode
			case "1"
				get_keyurl=webroot&"city.asp?area="&t0&"&key="&t1
			case "2"
				get_keyurl=webroot&""&t1&"/"&t0&".htm"
			case else
				get_keyurl=webroot&htmldir&""&t1&"/"&t0&".html"
		end select
	end Function

	public function geturl(byval t0,byval t1,byval t2,byval t3)
		if t2=1 then
			geturl=t3
		else
			dim t4:t4=""
			if webmode>1 then
				t4=getcateurl(t1)
			end if
			geturl=get_contenturl(t0,t3,t4,0)
		end if
	end function
	
	public function getcontenturl(byval t0)
		dim data
		data=db.dbload(1,"id,isurl,url,catedir","ey_content left join ey_category on ey_content.classid=ey_category.cateid","islock=1 and id="&t0&"","")
		if ubound(data)<0 then
			getcontenturl=""
		else
			getcontenturl=get_contenturl(data(0,0),data(2,0),data(3,0),data(1,0))
		end if
	end function
	
	public function get_contenturl(byval t0,byval t1,byval t2,byval t3)
		if t3=1 then
			get_contenturl=t1
		else
			select case webmode
				case "1"
					get_contenturl=webroot&"show.asp?id="&t0
				case "2"
					get_contenturl=t2&t1&".html"
				case else
					get_contenturl=t2&t1&".html"
			end select
		end if
	end function
	
	public function getpostion(byval t0,byval t1)
		getpostion=""
		Dim pstr:pstr=t0
		If InStr(pstr,"[")>0 Then
			pstr=Replace(pstr,"][",",")
			pstr=Replace(pstr,"]","")
			pstr=Replace(pstr,"[","")
		End if
		dim arr:arr=split(pstr,",")
		dim i
		for i=ubound(arr) to 0 step -1
			If get_modeid(arr(i))=-1 Then 
				getpostion=t1&getcatename(arr(i))&getpostion
			else
				getpostion=t1&getcateinfo(arr(i))&getpostion
			End if
		next
	end function
	
	public sub userlogin_auto(byval t0)
		dim userid:userid=t0
		dim shopid:shopid=enhtml(loadcookie("shopid"))
		dim shopnum:shopnum=enhtml(loadcookie("shopnum"))
		dim specid:specid=enhtml(loadcookie("specid"))
		if shopid<>"" and shopnum<>"" then
			dim data:data=db.dbload(1,"shopid,shopnum,specid","ey_user_cart","userid="&userid&"","")
			if ubound(data)<0 then
				db.insert "ey_user_cart",array(array("shopid",shopid,0,1),array("shopnum",shopnum,0,1),array("specid",specid,0,1),array("userid",userid,0,0))
			else
				dim n_shopid:n_shopid=data(0,0)
				dim n_shopnum:n_shopnum=data(1,0)
				dim n_specid:n_specid=data(2,0)
				dim arr_id:arr_id=split(shopid,",")
				dim arr_num:arr_num=split(shopnum,",")
				dim arr_spec:arr_spec=split(specid,",")
				dim i
				for i=0 to ubound(arr_id)
					if instr(","&n_shopid&",",","&arr_id(i)&",")<0 and arr_num(i)>0 then
						n_shopid=n_shopid&","&arr_id(i)
						n_shopnum=n_shopnum&","&arr_num(i)
						n_specid=n_specid&","&arr_spec(i)
					end if
				next
				if n_shopid<>data(0,0) then
				db.dbupdate "ey_user_cart","userid="&userid&"",array(array("shopid",n_shopid,0,1),array("shopnum",n_shopnum,0,1),array("specid",n_specid,0,1))
				end if
			end if
			eycms.setcookie "shopid",empty
			eycms.setcookie "shopnum",empty
			eycms.setcookie "specid",empty
		end if
	end sub
	
	public sub userreg_auto(byval t0)
		dim userid:userid=t0
		dim shopid:shopid=enhtml(loadcookie("shopid"))
		dim shopnum:shopnum=enhtml(loadcookie("shopnum"))
		dim specid:specid=enhtml(loadcookie("specid"))
		dim arr_id:arr_id=split(shopid,",")
		dim arr_num:arr_num=split(shopnum,",")
		dim arr_specid:arr_specid=split(specid,",")
		dim i,n_shopid,n_shopnum,n_specid
		for i=0 to ubound(arr_id)
			if arr_num(i)>0 then
				n_shopid=n_shopid&","&arr_id(i)
				n_shopnum=n_shopnum&","&arr_num(i)
				n_specid=n_specid&","&arr_specid(i)
			end if
		next
		if left(n_shopid,1)="," then n_shopid=right(n_shopid,len(n_shopid)-1)
		if left(n_shopnum,1)="," then n_shopnum=right(n_shopnum,len(n_shopnum)-1)
		if left(n_specid,1)="," then n_specid=right(n_specid,len(n_specid)-1)
		if n_shopid<>"" and n_shopnum<>"" then
			db.insert "ey_user_cart",array(array("shopid",n_shopid,0,1),array("shopnum",n_shopnum,0,1),array("specid",n_specid,0,1),array("userid",userid,0,0))
			eycms.setcookie "shopid",empty
			eycms.setcookie "shopnum",empty
			eycms.setcookie "specid",empty
		end if

	end sub
	
	public sub upsoldnum(byval t0)
		dim data:data=db.dbload("","contentid,cartnum","ey_user_order_item","orderid='"&t0&"'","")
		if ubound(data)<0 then
			exit sub
		end if
		dim i
		for i=0 to ubound(data,2)
			dim soldnum:soldnum=db.dbloadone("soldnum","ey_model_pro","cid="&data(0,i)&"")
			db.dbupdate "ey_model_pro","cid="&data(0,i)&"",array(array("soldnum",soldnum+data(1,i),10,0))
		next
	end sub
	
	public sub upstocknum(byval t0)
		dim data:data=db.dbload("","contentid,stocknum,cartnum,specid","ey_user_order_item n left join ey_model_pro p on n.contentid=p.cid","orderid='"&t0&"'","")
		if ubound(data)<0 then
			exit sub
		end if
		dim i,stocknum
		for i=0 to ubound(data,2)
			if data(3,i)>0 then
				stocknum=db.dbloadone("stocknum","ey_pro_spec","sid="&data(3,i)&"")
				if stocknum>0 then db.dbupdate "ey_pro_spec","cid="&data(0,i)&"",array(array("stocknum",stocknum-data(2,i),0,0))
			end if
			db.dbupdate "ey_model_pro","cid="&data(0,i)&"",array(array("stocknum",data(1,i)-data(2,i),0,0))
		next
	end sub

	public sub giftpoint(byval t0,byval t1)
		dim t2:t2=clng(getsys("str_gift"))
		if t2<=0 then exit sub
		dim point:point=db.dbloadone("point","ey_user","id="&t0&"")
		dim t3:t3=t1*t2+point
		db.dbupdate "ey_user","id="&t0&"",array(array("point",t3,10,0))
		createuserpoint array(array("point",t1*t2,0,0),array("userid",t0,0,0),array("type",1,0,0),array("content","消费："&t1&"元，获得："&t1*t2&"积分</a>",0,1),array("createdate",sqltime,0,0))
	end sub
	
	public function getcart()
		dim t0:t0=""
		dim t1:t1=""
		dim t2:t2=""
		if is_login then
			dim userdata:userdata=eycms.userinfo
			dim userid:userid=userdata(0)
			dim data:data=db.dbload(1,"shopid,shopnum,specid","ey_user_cart","userid="&userid&"","")
			if ubound(data)>=0 then
				t0=data(0,0)
				t1=data(1,0)
				t2=data(2,0)
			end if
		else
			t0=loadcookie("shopid")
			t1=loadcookie("shopnum")
			t2=loadcookie("specid")
		end if
		getcart=array(t0,t1,t2)
	end function
		
	public function get_usercartnum()
		dim t0,t1,t2,t3
		t3=getcart
		t0=t3(1)
		if t0="" then
			t1=0
		else
			t1=eval(replace(t0,",","+"))
		end if
		get_usercartnum=t1
	end function
	
	public function is_login()
		is_login=false
		dim t0
		t0=loadcookie("userinfo")
		if strlen(t0)=0 then exit function
		t0=eval(t0)
		if not isarray(t0) then exit function
		if ubound(t0)=-1 then exit function
		if db.dbcount("ey_user","username='"&t0(1)&"' and password='"&t0(2)&"'")<=0 then
			setcookie "userinfo","":exit function
		end if
		if t0(5)<>1 then exit function
		is_login=true
	end function
	
	public function user_publish_num()
		user_publish_num=9999
		if is_vip then
			exit function
		end if
		dim userdata,gid
		userdata=userinfo
		gid=userdata(4)
		if strlen(gid)=0 then
			user_publish_num=0
			exit function
		end if
		dim gdata:gdata=db.dbload(1,"allowpost,allowpostnum","ey_user_group","id="&gid&"","")
		if ubound(gdata)<0 then
			user_publish_num=0
			exit function
		else
			if gdata(0,0)=0 then
				user_publish_num=-1
				exit function
			else
				if gdata(1,0)=0 then
					exit function
				else
					user_publish_num=gdata(1,0)
				end if
			end if
		end if
		dim hnum:hnum=db.dbcount("ey_content","userid="&userdata(0)&" and createdate>="&iif(datatype,"date()","getdate()")&"")
		user_publish_num=user_publish_num-hnum
	end function
	
	public function user_publish_upload()
		user_publish_upload=true
		if is_vip then
			exit function
		end if
		dim userdata,gid
		userdata=userinfo
		gid=userdata(4)
		if strlen(gid)=0 then
			user_publish_upload=false
			exit function
		end if
		dim gdata:gdata=db.dbload(1,"allowattachment","ey_user_group","id="&gid&"","")
		if ubound(gdata)<0 then
			user_publish_upload=false
			exit function
		else
			if gdata(0,0)=0 then
				user_publish_upload=false
				exit function
			end if
		end if
	end function
	
	public function is_buy(byval t0)
		dim userdata:userdata=userinfo
		dim userid:userid=userdata(0)
		is_buy=db.dbcount("ey_user_buy","contentid="&t0&" and userid="&userid&"")
	end function
	
	public function is_vip()
		if not(is_login) then
			is_vip=false
			exit function
		end if
		dim userdata:userdata=userinfo
		if userdata(8)=1 then
			if userdata(9)=0 then
				is_vip=false
			else
				is_vip=true
			end if
		else
			is_vip=false
		end if
	end function
	
	public function checkuserlogin()
		if not(is_login) then
			go webroot&"user/login.asp?msg="&server.urlencode("请先登录或注册")&"&url="&thisurl
			die
		end if
	end function
	
	public sub userupgrade(byval t0,byval t1,byval t2)
		if t1=0 then exit sub
		dim data:data=db.dbload(1,"point,allowupgrade","ey_user_group","id="&t1&"","")
		if ubound(data)<0 then exit sub
		if data(1,0)=0 then exit sub
		dim tpoint:tpoint=data(0,0)
		data=db.dbload(1,"id,groupname,point","ey_user_group","point>"&tpoint&" and point<="&t0&"","point")
		if ubound(data)<0 then
			exit sub
		else
			if cdbl(t0)<cdbl(data(2,0)) then
				exit sub
			else
				db.dbupdate "ey_user","id="&t2&"",array(array("groupid",data(0,0),0,0))
				createusermessage array(array("title","您已升级到"&data(1,0)&"",255,1),array("fromid",-3,0,0),array("userid",t2,0,0),array("content","恭喜，您已升级到"&data(1,0)&"",0,1),array("createdate",sqltime,0,0),array("isread",0,0,0))
			end if
		end if
	end sub
	
	public sub deal_user_attachment(byval t0,byval t1)
		db.dbupdate "ey_attachment","userid="&t0&" and cid<=0 and classid=1",array(array("cid",t1,0,0))
	end sub
	
	public sub deal_user_publish_point(byval t0,byval t1)
		dim str_publish:str_publish=getsys("str_publish")
		if str_publish<=0 then
			exit sub
		end if
		if t1="" then
			dim userid:userid=db.dbloadone("userid","ey_content","id="&t0&"")
			if userid=0 then
				exit sub
			end if
		else
			userid=t1
		end if
		dim userdata
		userdata=eycms.db.dbload(1,"point,groupid,(select allowupgrade from ey_user_group where id=ey_user.groupid)","ey_user","id="&userid&"","")
		if ubound(userdata)<0 then
			exit sub
		end if
		dim point,groupid,allowupgrade,npoint
		point=userdata(0,0)
		groupid=userdata(1,0)
		allowupgrade=userdata(2,0)
		npoint=point+str_publish
		eycms.db.dbupdate "ey_user","id="&userid&"",array(array("point",npoint,10,0))
		eycms.db.insert "ey_user_point",array(array("point",str_publish,0,0),array("userid",userid,0,0),array("type",1,0,0),array("content","投稿通过审核，获得积分："&str_publish&"",0,1),array("createdate",sqltime,0,0))
		if allowupgrade=1 then eycms.userupgrade npoint,groupid,userid
	end sub
	
	public function resetuserinfo(byval t0)
		resetuserinfo=false
		if strlen(t0)<=0 then
			exit function
		end if
		dim t1
		t1=db.dbload(1,"u.id,u.username,u.password,u.email,u.groupid,u.islock,u.logintimes,u.[percent],u.isvip,u.overdate,g.groupname,g.rate,u.avatar,nickname","ey_user u left join ey_user_group g on u.groupid=g.id",t0,"")
		if ubound(t1)<0 then
			exit function
		end if
		dim u0,u1,u2,u3,u4,u5,u6,u7,u8,u9,u10,u11,u12,u13
		u0=t1(0,0)
		u1=t1(1,0)
		u2=t1(2,0)
		u3=t1(3,0)
		u4=t1(4,0)
		u5=t1(5,0)
		u6=t1(6,0)
		u7=t1(7,0)
		u8=t1(8,0)
		u9=t1(9,0)
		u10=t1(10,0)
		u11=t1(11,0)
		u12=t1(12,0)
		u13=t1(13,0)
		dim arr,thisdate,isover
		thisdate=year(now())&right("0"&month(now()),2)&right("0"&day(now()),2)
		isover=0
		if u8=1 then
			if clng(u9)>=clng(thisdate) then
				isover=1
			end if
		end if
		if strlen(u11)=0 then u11=100
		arr="array("&u0&","""&u1&""","""&u2&""","""&u3&""","&u4&","&u5&","&u6&","&u7&","&u8&","&isover&","""&u10&""","&u11/100&","&u12&","""&u13&""")"
		setcookie "userinfo",arr
		resetuserinfo=true
	end function
	
	public function userinfo()
		userinfo=array()
		dim t0
		t0=loadcookie("userinfo")
		t0=eval(t0)
		if not isarray(t0) then exit function
		if ubound(t0)=-1 then exit function
		userinfo=t0
	end function
	
	public function getuservip(byval t0)
		getuservip=""
		if strlen(t0)<=0 then
			exit function
		end If
		If Not IsNumeric(t0) Then
			exit function
		End if
		getuservip=db.dbloadone("isvip","ey_user","id="&t0&"")
	end Function

	public function gettruename(byval t0)
		gettruename=""
		if strlen(t0)<=0 then
			exit function
		end If
		gettruename=db.dbloadone("truename","ey_user_data","userid="&t0&"")
	end Function

	public function getnickname(byval t0)
		getnickname=""
		if strlen(t0)<=0 then
			exit function
		end If
		If Not IsNumeric(t0) Then
			getnickname=t0
			exit function
		End if
		getnickname=db.dbloadone("truename","ey_user_data","userid="&t0&"")
		if strlen(getnickname)<=0 Then
			getnickname=db.dbloadone("username","ey_user","id="&t0&"")
		End if
	end Function
	
	public sub createusermoney(byval t0)
		db.insert "ey_user_money",t0
	end sub
	
	public sub createuserpoint(byval t0)
		db.insert "ey_user_point",t0
	end sub
	
	public sub createusermessage(byval t0)
		db.insert "ey_user_message",t0
	end sub
	
	public sub stra_point(byval t0,byval t1,byval t2,byval t3)
		dim t4,t5
		select case t2
			case "1":t4=getsys("str_reg"):t5="新用户注册成功"
			case "2":t4=getsys("str_login"):t5="每日登录"
			case "3":t4=getsys("str_publish"):t5="投稿成功，标题："&t3&""
			case "4":t4=getsys("str_active"):t5="账户通过邮箱激活"
			case "5":t4=getsys("str_invite"):t5="邀请用户成功，用户名："&t3&""
			case else:exit sub
		end select
		if t4>0 then
			db.dbupdate "ey_user","id="&t0&"",array(array("point",t1+t4,0,0))
			createuserpoint array(array("content",t5,255,1),array("userid",t0,0,0),array("point",t4,0,0),array("type",1,0,0),array("createdate",sqltime,0,0))
		end if
	end sub
	
	public function get_sonid(byval t0)
		dim arr:arr=split(t0,",")
		dim i,str
		for i=0 to ubound(arr)
			if isnumeric(arr(i)) then
				if i>0 then str=str&","
				str=str&get_sonid_one(arr(i))
			end if
		next
		get_sonid=str
	end function
	
	public function get_sonid_one(byval t0)
		dim t1:t1=getclassdb(t0)
		if not isarray(t1) then
			get_sonid_one=0
		else
			get_sonid_one=t1(5)
		end if
	end function
	
	public function get_parentid(byval t0)
		dim t1:t1=getclassdb(t0)
		if not isarray(t1) then
			get_parentid=0
		else
			get_parentid=t1(6)
		end if
	end function
	
	public function is_channel_url(byval t0)
		is_channel_url=false
		dim t1:t1=getclassdb(t0)
		if not isarray(t1) then
			is_channel_url=true
			exit function
		else
			if t1(10)=-2 then
				is_channel_url=true
			end if
			if strlen(t1(2))=0 then
				is_channel_url=true
			end if
		end if
	end function
	
	public function get_cateoption(byval t0,byval t1)
		dim data:data=categorydata
		getcateoption 0,t0,data,t1
		get_cateoption=get_cate_option
	end function
	
	public sub getcateoption(byval t0,byval t1,byval t2,byval t3)
		dim data:data=t2
		dim i
		if not(isarray(data)) then
			exit sub
		end if
		for i=0 to ubound(data,2)
			if t0=data(3,i) then
				get_cate_option=get_cate_option&"<option value="""&data(0,i)&""" "&iif(t1=data(0,i),"selected","")&""
				if t3=2 then
					if data(10,i)="-2" or data(10,i)="-1" then
						get_cate_option=get_cate_option&" disabled=""disabled"""
					end if
				elseif t3=1 then
					if data(10,i)="-2" then
						get_cate_option=get_cate_option&" disabled=""disabled"""
					end if
				end if
				get_cate_option=get_cate_option&">"&string(data(4,i)-1,"　")&iif(data(3,i)>0,"├ ","")&""&data(1,i)&"</option>"
				getcateoption data(0,i),t1,data,t3
			end if
		next
	end sub
	
	public function eycmsdata()
		db.dbopen
		if checkcache("eycmsdata",1) then
			eycmsdata=loadcache("eycmsdata",1)
		else
			dim data
			data=db.dbload("","setkey,setvalue","ey_config","","setname")
			setcache "eycmsdata",data,1
			eycmsdata=data
		end if
	end function
	
	public function sitelinkcache()
		if checkcache("sitelink",1) then
			sitelinkcache=loadcache("sitelink",1)
		else
			dim data
			data=db.dbload("","title,intro,siteurl,ordnum,replacenum,linktype","ey_expand_sitelink","islock=1","ordnum desc,id desc")
			if ubound(data)<0 then
				setcache "sitelink","",1
				sitelinkcache=""
			else
				setcache "sitelink",data,1
				sitelinkcache=data
			end if
		end if
	end function
	
	public function get_model_field(byval t0)
		if checkcache("model_field"&t0,1) then
			get_model_field=loadcache("model_field"&t0,1)
		else
			dim data
			data=db.dbload("","fname,falias,fclass,fmode,fdatatype,flength,fdefault,foptions,fismust,frules,fistrim,fupload,relation,relateto,multi,fmemo","ey_model_field","islock=1 and modelid="&t0&"","ordnum,id")
			if ubound(data)<0 then
				setcache "model_field"&t0,"",1
				get_model_field=""
			else
				setcache "model_field"&t0,data,1
				get_model_field=data
			end if
		end if
	end Function
	
	public function get_form_field(byval t0)
		if checkcache("form_field"&t0,1) then
			get_form_field=loadcache("form_field"&t0,1)
		else
			dim data
			data=db.dbload("","fname,falias,fclass,fmode,fdatatype,flength,fdefault,foptions,fismust,frules,fistrim","ey_form_field","islock=1 and formid="&t0&"","ordnum,id")
			if ubound(data)<0 then
				setcache "form_field"&t0,"",1
				get_form_field=""
			else
				setcache "form_field"&t0,data,1
				get_form_field=data
			end if
		end if
	end function

	public function get_form_fieldset(byval t0,byval t1)
		dim form_data,i
		form_data=eycms.get_form_field(t0)
		if isarray(form_data) then
			for i=0 to ubound(form_data,2)
				if form_data(0,i)=t1 then
					get_form_fieldset=get_self_field(form_data(0,i),form_data(1,i),form_data(2,i),form_data(3,i),form_data(5,i),form_data(7,i),form_data(8,i),form_data(9,i),form_data(6,i),"ip","ips")
				end if
			next
		end if 
	end function

	public function get_self_field(byval t0,byval t1,byval t2,byval t3,byval t4,byval t5,byval t6,byval t7,byval t8,byval t9,byval t10)
		dim str:str=""
		if t8<>"" Then
			dim reg,matches,match
			set reg=new regexp
			reg.ignorecase=true
			reg.global=true
			reg.pattern="\{session\s+(.+?)\}"
			set matches=reg.execute(t8)
			if matches.count>0 then
				for each match in matches
					t8=replace(t8,match.value,eycms.loadsession(match.submatches(0)))
				next
			end if

			reg.pattern="\{var\s+(.+?)\}"
			set matches=reg.execute(t8)
			if matches.count>0 then
				for each match in matches
					t8=replace(t8,match.value,eval(match.submatches(0)))
				next
			end If

			reg.pattern="\{get\s+(.+?)\}"
			set matches=reg.execute(t8)
			if matches.count>0 then
				for each match in matches
					t8=replace(t8,match.value,eycms.fget(match.submatches(0),0))
				next
			end If
			Set reg=nothing
		end if
		if t6=1 then
			dim rule
			rule="data-rule="""&t1&":required;"
			select case t7
				case "2":rule=rule&"digits;"
				case "3":rule=rule&"dot;"
				case "4":rule=rule&"tel;"
				case "5":rule=rule&"mobile;"
				case "6":rule=rule&"email;"
				case "7":rule=rule&"date;"
				case "8":rule=rule&"postcode;"
				case "9":rule=rule&"qq;"
				case "10":rule=rule&"url;"
			end select
			rule=rule&""""
		end if
		dim i,arr,m
		arr=split(t5,vbcrlf)
		select case t2
		case "1"
			select case t3
				case "2":t4=10
				case "3":t4=50
				case "4":t4=255
				case "5":t4=10
			end select
			str=str&"<input type=""text"" name="""&t0&""" placeholder="""&t1&""" id="""&t0&""" value="""&t8&""" class=""txt "&t9&""" maxlength="""&t4&""" "&rule&" />"
		case "3"
			str=str&"<select name="""&t0&""" id="""&t0&""" class=""select ip"" "&rule&">"&vbcrlf
			str=str&"<option value="""">请选择"&t1&"</option>"&vbcrlf
			for i=0 to ubound(arr)
				if len(arr(i))>0 then
					if instr(arr(i),"|")>0 then
						m=split(arr(i),"|")
						str=str&"<option value="""&m(1)&""" "
						if m(1)=t8 then
							str=str&" selected"
						end if
						str=str&">"&m(0)&"</option>"&vbcrlf
					end if
				end if
			next
			str=str&"</select>"
		case "4","5"
			dim types:types=eycms.iif(t2=4,"radio","checkbox")
			dim ltype:ltype=eycms.iif(t2=4,"radios","checkbox")
			rule=replace(rule,"required;","checked")
			dim j:j=0
			for i=0 to ubound(arr)
				if len(arr(i))>0 then
					if instr(arr(i),"|")>0 then
						m=split(arr(i),"|")
						str=str&"<label class='bui-"&ltype&"-label bui-"&ltype&"-anim'><input type="""&types&""" name="""&t0&""" id="""&t0&"_"&i&""" value="""&m(1)&""" "
						if j=0 then
							str=str&" "&rule&" "
						end if
						if t2=4 then
							if m(1)=t8 then
								str=str&" checked"
							end if
						else
							if instr(", "&t8&", ",", "&m(1)&", ")>0 then
								str=str&" checked"
							end if
						end if
						str=str&"><i class='bui-"&ltype&"'>"&m(0)&"</label>&nbsp;"&vbcrlf
						j=j+1
					end if
				end if
			next
		case "2"
			str=str&"<textarea name="""&t0&""" placeholder="""&t1&""" id="""&t0&""" class=""text "&t10&""" "&rule&">"&t8&"</textarea>"
		end select
		get_self_field=str
	end function
	
	public function categorydata()
		if checkcache("category",1) then
			categorydata=loadcache("category",1)
		else
			dim data,sql
			sql="cateid,catename,catedir,followid,depth,sonid"				'0~5
			sql=sql&",parentid,ordnum,ismenu,cateurl,modeid"				'6~10
			sql=sql&",modelname,tablename,islock,adminurl,catepic"			'11~15
			sql=sql&",seotitle,catekey,catedesc,pagenum,cate_list"			'16~20
			sql=sql&",cate_show,default_temp,list_temp,show_temp,urlrule"   '21~25
			sql=sql&",admin_add_temp,admin_edit_temp,admin_publish_temp,pre_publish_temp,pre_publish_url,allowpost,domain"  '26~32
			sql=sql&",model_allowpost,islocked,iscut,cutsize"   '33~36
			data=db.dbload("",sql,"view_category","","ordnum,cateid")
			if ubound(data)<0 then
				setcache "category","",1
				categorydata=""
			else
				setcache "category",data,1
				categorydata=data
			end if
		end if
	end function
	
	public function getcateid(byval t0)
		dim data
		data=categorydata
		getcateid=-1
		if not(isarray(data)) then
			exit function
		end if
		dim i
		for i=0 to ubound(data,2)
			if lcase(t0)=lcase(data(2,i)) then
				getcateid=data(0,i)
				exit function
			end if
		next
	end function

	'***************************************************************
	'以下为增加的函数
	'***************************************************************

	public sub stophack()
		if request.querystring<>"" then call stophacker(request.querystring,"'|(and|or)\b.+?(>|<|=|in|like)|/\*.+?\*/|<\s*script\b|\bEXEC\b|UNION.+?SELECT|UPDATE.+?SET|INSERT\s+INTO.+?VALUES|execute\(|(SELECT|DELETE).+?FROM|(CREATE|ALTER|DROP|TRUNCATE)\s+(TABLE|DATABASE)")
		if request.Form<>"" then call stophacker(request.Form,"\b(and|or)\b.{1,6}?(\bin\b|\blike\b)|/\*.+?\*/|<\s*script\b|\bEXEC\b|UNION.+?SELECT|UPDATE.+?SET|INSERT\s+INTO.+?VALUES|execute\(|(SELECT|DELETE).+?FROM|(CREATE|ALTER|DROP|TRUNCATE)\s+(TABLE|DATABASE)")
		if request.Cookies<>"" then call stophacker(request.Cookies,"\b(and|or)\b.{1,6}?(=|>|<|\bin\b|\blike\b)|/\*.+?\*/|<\s*script\b|\bEXEC\b|UNION.+?SELECT|UPDATE.+?SET|INSERT\s+INTO.+?VALUES|execute\(|(SELECT|DELETE).+?FROM|(CREATE|ALTER|DROP|TRUNCATE)\s+(TABLE|DATABASE)") 
	end sub

	public function stophacker(values,re)
		dim item, item2, ichild
		for each item in values
			for each item2 in values
				ichild = values(item2)
				reg.pattern = re
				if reg.test(ichild) then
					errlog "警告:请不要使用敏感字符",0
					echo "<script>alert('警告:\n请不要使用敏感字符');location.href='"&webroot&"';</script>"
					die
				end if
			next
		next
	end function 
	
	'获取指定栏目下子栏目的option
	public function get_cateoption_byid(byval t0)
		dim data:data=categorydata
		get_cate_option=""
		getcateoption t0,0,data,0
		get_cateoption_byid=get_cate_option
	end Function
	
	public function get_cateoption_byid_sel(byval t0,byval t1)
		dim data:data=categorydata
		get_cate_option=""
		getcateoption t0,t1,data,0
		get_cateoption_byid_sel=get_cate_option
	end Function

	public function get_followid(byval t0)
		dim t1:t1=categorydata
		dim t2:t2=getcate(t1,t0)
		if t2=-1 then
			get_followid=0
		else
			get_followid=t1(3,t2)
		end if
	end Function

	public function get_catedir(byval t0)
		dim t1:t1=categorydata
		dim t2:t2=getcate(t1,t0)
		if t2=-1 then
			get_catedir=""
		else
			get_catedir=t1(2,t2)
		end if
		get_catedir=Replace(get_catedir,"-"," ")
	end Function

	public function get_catepic(byval t0)
		dim t1:t1=categorydata
		dim t2:t2=getcate(t1,t0)
		if t2=-1 then
			get_catepic=""
		else
			get_catepic=t1(15,t2)
		end if
	end Function

	public function get_catedesc(byval t0)
		dim t1:t1=categorydata
		dim t2:t2=getcate(t1,t0)
		if t2=-1 then
			get_catedesc=""
		else
			get_catedesc=t1(18,t2)
		end if
	end Function

	public function get_catedim(byval t0,byval t1)
		On Error Resume next
		dim data:data=eycms.db.dbload("",t0,"ey_category","cateid="&t1,"")
		if ubound(data)>=0 then
			get_catedim=data(0,0)
		end if
	end Function

	'获取指定栏目所属模型ID
	public function get_modeid(byval t0)
		dim t1:t1=categorydata
		dim t2:t2=getcate(t1,t0)
		if t2=-1 then
			get_modeid=0
		else
			get_modeid=t1(10,t2)
		end if
	end Function
	
	'获取指定栏目iscut属性
	public function get_iscut(byval t0)
		dim t1:t1=categorydata
		dim t2:t2=getcate(t1,t0)
		if t2=-1 then
			get_iscut=0
		else
			get_iscut=t1(35,t2)
		end if
	end Function
	
	'获取指定栏目cutsize属性
	public function get_cutsize(byval t0)
		dim t1:t1=categorydata
		dim t2:t2=getcate(t1,t0)
		if t2=-1 then
			get_cutsize=0
		else
			get_cutsize=t1(36,t2)
		end if
	end Function
	
	'自定义标签函数
	public function getmysys(byval t0) 
		On Error Resume next
		dim data:data=eycms.db.dbload("","title,content","ey_plug_lable","title='{my:"&enhtml(t0)&"}'","id")
		if ubound(data)>=0 then
			getmysys=data(1,0)
		end if
	end Function

	public function encrypt(byval t0,byval t1)
		dim ikeychar,istringchar,icryptchar,strencrypted,i,gkey
		gkey=mid(t1,1,len(t0))
		for i=1 to len(t0)
			ikeychar=ascw(mid(gkey,i,1))
			istringchar=ascw(mid(t0,i,1))
			icryptchar=ikeychar xor istringchar
			strencrypted=strencrypted&chrw(icryptchar)
		next
		encrypt=strencrypted
	end function
	
	public function decrypt(byval t0,byval t1) 
		dim ikeychar,istringchar,idecryptchar,strdecrypted,i,gkey
		gkey=mid(t1,1,len(t0))
		for i=1 to len(t0)
			ikeychar=ascw(mid(gkey,i,1))
			istringchar=ascw(mid(t0,i,1))
			idecryptchar=ikeychar xor istringchar
			strdecrypted=strdecrypted&chrw(idecryptchar)
		next
		decrypt=strdecrypted
	end function

	public function loadcookie_prefix(t0,t1)
		loadcookie_prefix=request.cookies(t0)(t1)
	end Function

	public function diffuudate(byval t0)
		if datediff("n",t0,now())=0 Then
			diffuudate = "刚刚"
		elseif datediff("n",t0,now())<60 then
			diffuudate = datediff("n",t0,now())&"分钟前"
		elseif datediff("h",t0,now())<24 then
			diffuudate = datediff("h",t0,now())&"小时前"
		elseif datediff("d",t0,now())<31 then
			diffuudate = datediff("d",t0,now())&"天前"
		elseif datediff("m",t0,now())<12 then
			if datediff("m",t0,now())=6 then
				diffuudate = "半年前"
			else
				diffuudate = datediff("m",t0,now())&"月前"
			end if
		elseif datediff("yyyy",t0,now())>0 then
			diffuudate = datediff("yyyy",t0,now())&"年前"
		end if
	end Function

	'根据内容获取上传文件名
	Public Function getfilelist(byval t0)
		If IsNull(t0) Then Exit Function
		Dim FileName,FileExt
		FileExt="gif|jpg|png|doc|docx|xls|xlsx|rar|zip|pdf|txt|flv|swf|wma|mp3|mp4|rm|rmvb|wmv|3gp|avi|mpeg"
		reg.Pattern = "(\/upfile\/)[^(\/upfile\/)]?(.*?)[.]{1}(" & FileExt & ")"
		Set matches = reg.Execute(t0)
		if matches.count>0 then
			for each match in matches
				If Instr(FileName, match)=0 Then
					if FileName = "" then
						FileName = webroot & "site/" & site_root & match.value
					Else
						FileName = FileName & "," & webroot & "site/" & site_root & match.value
					End If
				End If
			Next
		end if
		getfilelist = FileName
	End Function

	public function getcate(byval t0,byval t1)
		dim data
		data=t0
		getcate=-1
		if not(isarray(data)) then
			exit function
		end if
		dim i
		for i=0 to ubound(data,2)
			if clng(t1)=data(0,i) then
				getcate=i
				exit function
			end if
		next
	end function
	
	public function rootcatedir(byval t0)
		dim data:data=categorydata
		dim gcate:gcate=getcate(data,t0)
		dim rootid:rootid=split(data(6,gcate),"]")(0)
		rootid=replace(rootid,"[","")
		rootid=CInt(rootid)
		gcate=getcate(data,rootid)
		rootcatedir=data(2,gcate)
	end Function

	public function ischild(byval t0,byval t1)
		if strlen(t0)=0 Or strlen(t1)=0 then ischild=false:exit function
		Dim cid:cid = "[" & t1 & "]"
		If InStr(t0,cid)>0 Then
			ischild=True
		Else
			ischild=False
		End if
	end Function

	public function set_theme_config()
		dim xml,i,item,settag,seturl
		set xml=server.createobject("microsoft.xmldom")
		xml.async=false
		xml.load(server.mappath(webroot&"theme/"&theme_root&"/base.xml"))
		set item=xml.getElementsByTagName("item")
		for i=0 to (item.length-1)
			set settag=item.item(i).getElementsByTagName("settag")
			set seturl=item.item(i).getElementsByTagName("seturl")
			eycms.sysdb.add lcase(settag.item(0).Text),seturl.item(0).Text
		next
	end Function

	public function getoptionsval(byval t0,byval t1,byval t2)
		getoptionsval=""
		If t1="" Or t0="" Then Exit function
		dim fdata,m,i
		fdata=db.dbload(1,"foptions","ey_model_field","modelid="&CLng(t1)&" and fname='"&enhtml(t0)&"'","")
		if ubound(fdata)>=0 Then
			m=split(fdata(0,0),vbcrlf)
			for i=0 to ubound(m)
				If isSame(split(m(i),"|")(1),t2) Then getoptionsval=split(m(i),"|")(0)
			next
		end If
	end Function
	
	public function getdimfield(byval t0,byval t1)
		If t1="" Or t0="" Then Exit function
		dim fdata,i,t2
		fdata=db.dbload("","fname,foptions","ey_model_field","modelid="&CLng(t1),"")
		if ubound(fdata)>=0 Then
			for i=0 to ubound(fdata,2)
				If fdata(0,i)=t0 Then 
					t2=replace(fdata(1,i),chr(10),vbcrlf)
					getdimfield=split(t2,vbcrlf)
				End if
			Next
		end If
	end Function

	public function getOptionName(byval t0,byval t1,byval t2)
		If t1="" Or t0="" Then Exit function
		dim fdata,i,t3,oArr
		fdata=db.dbload("","fname,foptions","ey_model_field","modelid="&CLng(t1),"")
		if ubound(fdata)>=0 Then
			for i=0 to ubound(fdata,2)
				If fdata(0,i)=t0 Then 
					t3=replace(fdata(1,i),chr(10),vbcrlf)
					oArr=split(t3,vbcrlf)
				End if
			Next
		end If
		for i=0 to ubound(oArr)
			if isSame(t2,split(oArr(i),"|")(1)) then getOptionName=split(oArr(i),"|")(0)
		Next
	end Function
	
	public function getdimval(byval t0,byval t1,byval t2)
		On Error Resume next
		If t1="" Or t0="" Or t2="" Then Exit function
		getdimval=db.dbloadone(t0, "ey_model_"&t1, "cid="&CLng(t2))
		If getdimval<>"" then
			getdimval=replace(getdimval,chr(10),"<BR>")
			getdimval=replace(getdimval,vbcrlf,"<BR>")
			getdimval=replace(getdimval,"<BR><BR>","<BR>")
		End if
	end Function

	'获取首张大图         参数：t0=内容ID     t1=模型ID
	public function getbigimg(byval t0,byval t1)
		On Error Resume next
		dim piclist,picarr
		If t0="" Or t1="" Then Exit function
		select case CLng(t1)
		case 1
			piclist=db.dbloadone("content", "ey_model_news","cid="&CLng(t0))
			If piclist<>"" then
				getbigimg=get_frist_pic(piclist)
			End if
		case 2
			piclist=db.dbloadone("piclist", "ey_model_photo","cid="&CLng(t0))
			If piclist<>"" then
				picarr=eval(piclist)
				getbigimg=picarr(0)
			End if
		case 5
			piclist=db.dbloadone("piclist", "ey_model_pro","cid="&CLng(t0))
			If piclist<>"" then
				picarr=eval(piclist)
				getbigimg=picarr(0)
			End if
		end select
	end Function
	
	public function dbconfig(byval t0,byval t1,byval t2,byval t3,byval t4)
		on error resume Next
		dim tonn,tonnstr
		dim site_data,datatype,datapath,datadbname,datahost,datauser,datapass,datasqlname
		site_data=split(t0,"{eycms}")
		if site_data(0)="true" Then datatype=True Else datatype=false
		if datatype=True then
			datapath=site_data(1)
			datadbname=site_data(2)
		else
			If ubound(site_data)>=4 Then
				datahost=site_data(1)
				datauser=site_data(2)
				datapass=site_data(3)
				datasqlname=site_data(4)
			else
				dbconfig="Error"
				Exit function
			end if
		end If
		if datatype then
			tonnstr="Provider=Microsoft.Jet.OLEDB.4.0;Data Source="& server.mappath(webroot & datapath & "/" & datadbname)
		else
			tonnstr="Provider=Sqloledb;User ID=" & datauser & ";Password=" & datapass & ";Initial CataLog=" & datasqlname & ";Data Source=" & datahost & ";"
		end If
		set tonn=server.createobject("adodb.connection")
		tonn.open tonnstr
		If strlen(t2)>0 then
			tonn.execute("update ey_config set setvalue='"& t2 &"' where setname='eycms.site' and setkey='webname'")
		End if
		tonn.execute("update ey_config set setvalue='site/"& t1 &"/upfile' where setname='eycms.upload' and setkey='upfile'")
		dim adminid:adminid=tonn.execute("select top 1 adminid from ey_admin where groupid>0")(0)
		If strlen(t3)>0 then
			If strlen(t4)>0 then
				tonn.execute("update ey_admin set adminname='"& t3 &"',adminpass='"& md5(t4) &"' where adminid="&adminid)
			Else
				tonn.execute("update ey_admin set adminname='"& t3 &"' where adminid="&adminid)
			End If
		End If
		tonn.close
		Set tonn=nothing
		if err then
			errlog "文件：eycms.fun.asp<br>函数：dbconfig<br>详情："&err.description,0
			err.clear
		end if
	end Function
	
	public function sendhttp(byval t0,byval t1)
		on error resume next
		dim http
		set http=server.createobject(xmlhttp)
			http.open "post",t0,False
			http.setrequestheader "Referer",t0
			http.setrequestheader "User-Agent", "Mozilla/4.0"
			http.setrequestheader "Connection", "Keep-Alive"
			http.setrequestheader "Content-Length",len(t1)
			http.setRequestHeader "Content-Type", "application/x-www-form-urlencoded"			
			http.send(t1)
			sendhttp=http.responsetext
		set http=nothing
		if err then 
			sendhttp="0"&err.description
			errlog "网址："&t0&"<br>函数：sendhttp<br>详情："&err.description,1
			err.clear
			die
		end if
	end Function

	public function getWhere(cid)
		If cid>0 Then
			dim parentid,pids,i
			parentid=get_parentid(cid)
			parentid=Replace(parentid,"][",",")
			parentid=Replace(parentid,"[","")
			parentid=Replace(parentid,"]","")
			If instr(parentid,",")>0 Then
				getWhere = "("
				pids=Split(parentid,",")
				for i=0 To UBound(pids)
					getWhere = getWhere & "classid="&pids(i)
					If i<UBound(pids) Then getWhere = getWhere & " or "
				Next
				getWhere = getWhere & ")"
			Else
				getWhere = "classid="&parentid
			End if
		End if
	End Function

	public function getbrandid(t0)
		dim data
		data=db.dbload(1,"id","ey_content","tags='"&enhtml(t0)&"'","")
		if ubound(data)<0 Then
			getbrandid=0
		else
			getbrandid=data(0,0)
		end if
	End Function

	public function getbrandurl(bid,cid)
		If bid>0 Then
			dim tag:tag=db.dbloadone("tags", "ey_content", "id="&CLng(bid))
			Dim tstr
			If classid>0 Then tstr="&cid="&cid
			select case webmode
				case "1"
					getbrandurl=webroot&"brand.asp?bid="&bid&tstr
				case "2"
					If strlen(tag)>0 Then 
						getbrandurl=webroot&"brand/"&tag&"/"
						If cid>0 Then getbrandurl=getbrandurl & "cid_"&cid&"/"
					Else
						getbrandurl=webroot&"brand.asp?bid="&bid&tstr
					End if
				case else
					'getbrandurl=webroot&htmldir&tag&"/"
					getbrandurl=webroot&"brand.asp?bid="&bid&tstr
			end Select
		End if
	End Function

	public function paramto(p)
		if strlen(p)=0 then exit function
		if instr(p,"attr") then
			dim t
			t=right(p,1)
			paramto="p"&chr(96+cint(t))
		end if
	End Function

	public function paramback(p)
		if strlen(p)=0 then exit function
		p=right(p,1)
		paramback="attr" & cstr(asc(p)-96)
	End Function

	public function pfollowid(byval t0)
		dim followid
		followid=get_followid(t0)
		if followid=0 then
			pfollowid=t0
		else
			pfollowid=followid
		end if
	end Function
	
	public function isSameParam(byval t0,byval t1)
		isSameParam=false
		dim t2:t2 = param.item(cstr(t0))
		if isnumeric(t2) and isnumeric(t1) then
			if CInt(t2)=CInt(t1) then isSameParam=true
		else
			if Cstr(t2)=Cstr(t1) then isSameParam=true
		end if
	end Function

	public function getparamurl(cid,bid,order,attr,aval)
		If webmode=2 And urlmode=1 Then
			getparamurl=webroot&"goods/cid"&cid
		else
			getparamurl=webroot&"goods.asp?p=cid"&cid
		End if
		If bid>0 Then getparamurl=getparamurl&"-bid"&bid
		If order>0 Then getparamurl=getparamurl&"-ord"&order
		Dim sql,rs,tstr,myparam
		sql = "select fname from ey_attr_set where islock=1 and " & eycms.getWhere(cid) & " order by ordnum,id"
		set rs = db.conn.execute(sql)
		do while not rs.eof
			tstr = param.item(cstr(rs("fname")))
			if tstr="0" then tstr=""
			If rs("fname")<>attr Then
				if strlen(tstr)>0 then myparam=myparam&paramto(rs("fname"))&tstr&"-"
			Else
				if aval>0 then myparam=myparam&paramto(rs("fname"))&aval&"-"
			End if
			rs.movenext
		Loop
		rs.close
		set rs = Nothing
		if right(myparam,1)="-" then myparam=left(myparam,len(myparam)-1)
		if strlen(myparam)>0 then getparamurl=getparamurl&"-"&myparam
		If webmode=2 And urlmode=1 Then getparamurl=getparamurl&".html"
		If bid=0 And strlen(myparam)=0 And order=0 Then getparamurl=getcateurl(cid)
	End Function

	public function isthisattr(t0,t1)
		Dim t2
		isthisattr=false
		t2 = fget(t0,0)
		If Not IsNumeric(t2) Then t2=0
		If Not IsNumeric(t1) Then t1=-1
		If CInt(t2)=CInt(t1) Then isthisattr=true
	End Function
	
	public function getContentTit(byval t0)
		If t0="" Then Exit function
		getContentTit=db.dbloadone("title", "ey_content", "id="&CLng(t0))
	End Function

	public function getContentPic(byval t0)
		If t0="" Then Exit function
		getContentPic=db.dbloadone("pic", "ey_content", "id="&CLng(t0))
	End Function

	public function get_brand_nav(byval t0,byval t1,byval t2)
		On Error Resume next
		If strlen(t0)<=0 Or t0=0 Then get_brand_nav="":Exit function
		dim myarray(10,10)
		dim i:i=0
		dim j:j=1
		Dim sql,rs,tstr,pid,sid
		pid=0
		sid=0
		sql = "select view_content.parentid from view_content INNER JOIN "&t1&" ON view_content.id = "&t1&".cid WHERE "&t1&"."&t2&"=" & CLng(t0) & " GROUP BY view_content.parentid order by view_content.parentid"
		set rs = db.conn.execute(sql)
		do while not rs.eof
			tstr=rs(0)
			tstr=Replace(tstr,"][",",")
			tstr=Replace(tstr,"[","")
			tstr=Replace(tstr,"]","")
			tstr=tstr&",,"
			If Split(tstr,",")(1)<>pid Then pid=Split(tstr,",")(1):i=i+1:j=0
			If Split(tstr,",")(2)<>sid Then sid=Split(tstr,",")(2):j=j+1
			myarray(i,0)=Split(tstr,",")(1)
			myarray(i,j)=Split(tstr,",")(2)
			If pid=0 Then pid=Split(tstr,",")(1)
			rs.movenext
		Loop
		rs.close
		set rs = Nothing
		get_brand_nav=myarray
	end Function

	public function get_model_site(byval t0)
		if checkcache("model_site"&t0,1) then
			get_model_site=loadcache("model_site"&t0,1)
		else
			dim data,whereStr
			if t0=0 then 
				whereStr="id<>0"
			else
				whereStr="cid="&t0
			end if
			data=db.dbload("","setName,setTitle,setType,setmode,fdatatype,flength,setValue,foptions,IsMust,frules,isshow,id,fmemo","ey_plug_set",whereStr,"ordnum,id")
			if ubound(data)<0 then
				setcache "model_site"&t0,"",1
				get_model_site=""
			else
				setcache "model_site"&t0,data,1
				get_model_site=data
			end If
		End if
	end Function

	public function get_attr_set(byval t0)
		if checkcache("attr_set"&t0,1) then
			get_attr_set=loadcache("attr_set"&t0,1)
		else
			dim data
			data=db.dbload("","fname,falias,fclass,fmode,fdatatype,flength,fdefault,foptions,fismust,frules,fistrim,fupload","ey_attr_set","islock=1 and "&getWhere(t0)&"","ordnum,id")
			if ubound(data)<0 then
				setcache "attr_set"&t0,"",1
				get_attr_set=""
			else
				setcache "attr_set"&t0,data,1
				get_attr_set=data
			end If
		End if
	end Function

	public function getViewUrl(byval t0)
		If t0="" Then Exit function
		if instr(t0,"mobi.") Then
			getViewUrl="http://wap.eycms.cn/?view=" & replace(replace(t0, "http://", ""), "/", "")
		else
			getViewUrl="http://temp.eycms.cn/?view=" & replace(replace(t0, "http://", ""), "/", "")
		end If
	End Function

	public function publicLinks()
		if isfile(webroot&"plug/"&site_root&".html") then
			publicLinks = loadfile(webroot&"plug/"&site_root&".html")
		end if
	End Function

	public function chk_prize()
		chk_prize=false
		if eycms.strlen(eycms.getsys("eycms.plug.luck"))>0 then
	        if eycms.db.dbcount("ey_plug_luck_set","openzt=1") then chk_prize=true
	    end if
	end function

	public function getusergroup(t0)
		dim groupid:groupid=db.dbloadone("groupid","ey_user","id="&t0&"")
		getusergroup=db.dbloadone("groupname","ey_user_group","id="&groupid&"")
	end function

	public function getuserpush(t0)
		getuserpush=eycms.db.dbcount("ey_content","islock=1 and userid="&t0&"")
	end function
	
	public function getusername(t0)
		if t0=0 then 
			getusername="admin"
			exit function
		end if
		If Not IsNumeric(t0) Then
			getusername=t0
			exit function
		End if
		dim username:username=eycms.db.dbloadone("username","ey_user","id="&t0&"")
		dim usernick:usernick=eycms.db.dbloadone("nickname","ey_user","id="&t0&"")
		dim truename:truename=eycms.db.dbloadone("truename","ey_user_data","userid="&t0&"")
		if eycms.strlen(truename)>0 then
			getusername=truename
		elseif eycms.strlen(usernick)>0 then
			getusername=usernick
		else
			getusername=username
		end if
	end function

	public function setseotitle(t0,t1)
		dim i,arr
		if instr(t0,",") then
			arr=split(t0,",")
	    else
	    	redim arr(1)
	    	arr(0)=t0
	    end if
		for i=0 to ubound(arr)
			if strlen(trim(arr(i)))>0 then
				setseotitle = t1 & trim(arr(i)) & "," & setseotitle
			end if
		next
		if right(setseotitle,1)="," then setseotitle=left(setseotitle,len(setseotitle)-1)
	end function

	public function filterdate(byval t0)
		t0=replace(t0,"上午 ","")
		t0=replace(t0,"下午 ","")
		filterdate=t0
	end function

	public function get_spec_set(byval t0,byval t1)
		dim data,i,shtml,sel
		data=db.dbload("","sid,spec,mprice,uprice,aprice,stocknum","ey_pro_spec","cid="&t0&"","ordnum")
		if ubound(data)<0 then
			get_spec_set=""
		else
			shtml="<div class=""shop-product-para"">"&vbcrlf
			shtml=shtml&"<div class=""row"">"&vbcrlf
			shtml=shtml&"<input type=""hidden"" id=""specid"" name=""specid"" value=""0"">"&vbcrlf
			shtml=shtml&"<label class='form-control-label'>"&t1&"：</label>"&vbcrlf
			shtml=shtml&"<div class=""selectpara-list"">"&vbcrlf
			for i=0 to ubound(data,2)
				if i=0 then sel=" btn-danger" else sel=""
				shtml=shtml&"<a href=""javascript:;"" title="""&data(1,i)&""" data-id="""&data(0,i)&""" data-json='{""spec_id"":"""&data(0,i)&""",""mprice"":"""&data(2,i)&""",""uprice"":"""&data(3,i)&""",""aprice"":"""&data(4,i)&""",""stock"":"""&data(5,i)&"""}' class=""selectpara btn-squared"&sel&""">"&data(1,i)&"</a>"&vbcrlf
			next
			shtml=shtml&"</div>"&vbcrlf
			shtml=shtml&"</div>"&vbcrlf
			shtml=shtml&"</div>"&vbcrlf
			get_spec_set=shtml
		end If
	end Function

	public function get_price(byval t0,byval t1,byval t2,byval t3,byval t4)
		if t0=1 then
			get_price = t1 & "积分"
		end if
		if t2=1 then
			if t0=1 and t4>0 then get_price = get_price & " + "
			if t4>0 then get_price = get_price & getmoney(t4)
		else
			if t0=1 and t3>0 then get_price = get_price & " + "
			if t3>0 then get_price = get_price & getmoney(t3)
		end if 
	end Function

	public function getrecommend(byval t0)
		dim rscomid
		rscomid=eycms.db.dbloadone("rscomid","ey_expand_recommend","rid="&t0&"")
		if eycms.strlen(rscomid)=0 then
			getrecommend="0"
		else
			getrecommend=rscomid
		end If
	end function

	public sub include(byval filePath)
		on error resume next
		ExecuteGlobal includeCode(loadfile(filePath),0)
		if err.number<>0 then
			eycms.errlog "文件：eycms.fun.asp<br>函数：include<br>路径：" & filePath & "<br>详情："&err.description,0
			err.clear
		end if
	end sub

	public function includeHTMLFile(byval filePath)
		on error resume next
		ExecuteGlobal includeCode(loadfile(filePath),1)
		includeHTMLFile = EY_S_HTML
		if err.number<>0 then
			eycms.errlog "文件：eycms.fun.asp<br>函数：includeHTMLFile<br>路径：" & filePath & "<br>详情："&err.description,0
			err.clear
		end if
	end function

	public function includeCode(byval text, byval isHtml)
		dim s,c,c1,c2,st,l
		c1 = ""
		if isHtml=1 then
			c2 = "EY_S_HTML = EY_S_HTML & "
		else
			c2 = "response.write "
		end if
		st  = 1
		l = instr(text,"<"&"%") + 2
		while l > st + 1
			s = mid(text,st,l-st-2)
			st = instr(l,text,"%"&">") + 2
			if s<>"" then
				s = replace(s,"""","""""")
				s = replace(s,vbCrLf,"""&vbCrLf&""")
				c1 = c1 & c2 & """" & s & """" & vbCrLf
			end if
			s = mid(text,l,st-l-2)
			c = replacetext(s,"^\s*=\s*",c2) & vbCrLf
			if isHtml = 1 then
				c = replacetext(c,"response\.write([\( ])", c2 & "$1") & vbCrLf
				c = replacetext(c,"response\.write([\( ])", c2 & "$2") & vbCrLf
			end if
			c1 = c1 & c
			l = instr(st,text,"<"&"%") + 2
		wend
		s = mid(text,st)
		if not(isNull(s)) then
			s = replace(s,"""","""""")
			s = replace(s,vbcrlf,"""&vbCrLf&""")
			c1 = c1 & c2 & """" & s & """" & vbCrLf
		end if
		if isHtml = 1 then c1 = "EY_S_HTML = """" " & vbCrLf & c1 
		includeCode = replacetext(c1,"(\n\s*\r)+",vbCrLf)
	end function
	
	public function getlanguage() 
       dim mysite:mysite=site_root
       if instr(mysite,"_") then mysite=split(mysite,"_")(0)
	   if eycms.isfile(webroot&"lang/"&mysite&".xml") then
		   dim mode1,mode2,mode3,mode4,mycolor
	       dim xml,items,i,url,ntype,fontcolor,myset
	       set xml=server.createobject("microsoft.xmldom")
	       xml.async=false
	       xml.load(server.mappath(webroot&"lang/"&mysite&".xml"))
		   myset=xml.getElementsByTagName("set").item(0).text
	       set items = xml.documentElement.selectSingleNode("list")
	       for i=0 To (items.childNodes.length - 1)
	       	   mycolor=""
			   ntype=clng(items.childNodes.item(i).childNodes.item(0).text)
			   url=items.childNodes.item(i).childNodes.item(1).text
			   fontcolor=items.childNodes.item(i).childNodes.item(2).text
			   if fontcolor<>"" then mycolor=" style='color:"&fontcolor&"'"
			   url=replace(url,"{webroot}",webroot)
			   mode1=mode1&"<li><a href='"&url&"'"&mycolor&"><i>"&getlangico(ntype)&"</i> "&getlangname(ntype)&"</a></li>"
			   mode2=mode2&"<li><a href='"&url&"'"&mycolor&">"&getlangname(ntype)&"</a> | </li>"
			   mode3=mode3&"<option value='"&url&"'>"&getlangname(ntype)&"</option>"
			   mode4=mode4&"<li><a href='"&url&"'"&mycolor&"><i>"&getlangico(ntype)&"</i></a></li>"
	       next
	       set items=nothing
	       set xml=nothing
	       select case myset
	       case 0
			 getlanguage="<div class=""language""><div class=""languageStyle1""><ul>"&mode1&"</ul></div><div class=""clear""></div></div>"
	       case 1
			 getlanguage="<div class=""language""><div class=""languageStyle1 languageStyleColor1""><ul>"&mode1&"</ul></div><div class=""clear""></div></div>"
	       case 2
			 getlanguage="<div class=""language""><div class=""languageStyle1 languageStyleColor2""><ul>"&mode1&"</ul></div><div class=""clear""></div></div>"	
	       case 3
			 getlanguage="<div class=""language""><div class=""languageStyle1 languageStyleColor3""><ul>"&mode1&"</ul></div><div class=""clear""></div></div>"	
	       case 4
			 getlanguage="<div class=""language""><div class=""languageStyle1 languageStyleColor4""><ul>"&mode1&"</ul></div><div class=""clear""></div></div>"
	       case 5
			 getlanguage="<div class=""language""><div class=""languageStyle1 languageStyleColor5""><ul>"&mode1&"</ul></div><div class=""clear""></div></div>"
	       case 6
			 getlanguage="<div class=""language""><div class=""languageStyle1""><ul>"&mode2&"</ul></div><div class=""clear""></div></div>"
	       case 7
			 getlanguage="<div class=""language""><div class=""languageStyle2""><select>"&mode3&"</select></div></div>"
	       case 8
			 getlanguage="<div class=""language""><div class=""languageStyle1""><ul>"&mode4&"</ul></div><div class=""clear""></div></div>"
	       end select
	   end if
	end function

	private function getlangico(t0)
		select case t0
		case 0:getlangico="CN"
		case 1:getlangico="EN"
		case 2:getlangico="JP"
		case 3:getlangico="KO"
		case 4:getlangico="FR"
		case 5:getlangico="TW"
		end select
	end function

	private function getlangname(t0)
		dim dlang
		dlang=site_root
		if instr(dlang,"_")>0 then 
			dlang=split(dlang,"_")(1)
		else
			dlang="cn"
		end if
		if dlang="cn" then
			select case t0
			case 0:getlangname="中文版"
			case 1:getlangname="英文版"
			case 2:getlangname="日文版"
			case 3:getlangname="韩文版"
			case 4:getlangname="法语版"
			case 5:getlangname="繁体版"
			end select
		elseif dlang="en" then
			select case t0
			case 0:getlangname="Chinese"
			case 1:getlangname="English"
			case 2:getlangname="Japanese"
			case 3:getlangname="Korean"
			case 4:getlangname="French"
			case 5:getlangname="Traditional"
			end select
		elseif dlang="jp" then
			select case t0
			case 0:getlangname="中国語"
			case 1:getlangname="英文版"
			case 2:getlangname="日本語"
			case 3:getlangname="韓国語"
			case 4:getlangname="フランス語"
			case 5:getlangname="繁体版"
			end select
		elseif dlang="ko" then
			select case t0
			case 0:getlangname="중국어"
			case 1:getlangname="영어"
			case 2:getlangname="일본어"
			case 3:getlangname="한국어"
			case 4:getlangname="프랑스어"
			case 5:getlangname="번체"
			end select
		elseif dlang="fr" then
			select case t0
			case 0:getlangname="Chinois"
			case 1:getlangname="Anglais"
			case 2:getlangname="Japonais"
			case 3:getlangname="Coréen"
			case 4:getlangname="Français"
			case 5:getlangname="Traditionnel"
			end select
		end if
	end function

	public function translate(t0,t1)
		dim dlang
		dlang=t1
		if instr(dlang,"_")>0 then 
			dlang=split(dlang,"_")(1)
		else
			If cachedate="62" Then dlang="en"
			If cachedate="63" Then dlang="jp"
			If cachedate="64" Then dlang="ko"
			If cachedate="65" Then dlang="fr"
		end if
		if len(dlang)<>2 then 
			translate=t0
			exit function
		end if

		If InStr("en|jp|ko|fr",dlang) then
			dim s,t,c,d,i 
			s ="上一页|下一页|还可以输入|个字符|发表评论|匿名发表|网友|登录发表|请登录后发表评论|管理员回复：|系统未开启评论|没有评论|您查看的内容不存在|本文禁止评论|禁止外部提交数据|参数错误|内容不能为空|至少输入5个字符|昵称不能为空|请勿重复提交|提交成功，审核后显示！|提交成功！"
			select case dlang
			case "en"
				t ="Prev|Next|Also enter| chars|Submit|Anonymous|Worms|Comment on login|Comment after login|Reply:|System did not open the comments|No comment|Your view does not exist|This article prohibits comments|External data is not allowed|Parameter error|Content can not be empty|Enter at least 5 characters|Nickname cannot be empty|Please do not repeat|Submitted successfully, after the audit display!|Submit successfully!"
			case "jp"
				t ="前編|後編|入力も可能|文字|発表|匿名発表|ユーザー|登録発表|登録後評論|司書：|未開いコメント|コメントはありません|内容は存在しない|本文はコメントを禁止する|外部提出の禁止を禁止する|パラメータエラー|内容は暇にならない|少なくとも5文字入力|ニックネームを入力して下さい|繰り返し提出しないでください|成功を提出し、審査後に表示されます！|成功を提出する！"
			case "ko"
				t ="페이지|다음|괜찮다 입력|글자|발표|익명발표|네티즌|로그인 발표|로그인후평론|답장:|시스템아직켜기평론|없다-설명|내용존재하지않는다|이글은금지평론|외부데이터전송금지|매개변수오류|내용못비어|적어도다섯개의문자입력|별명못비어|하지마반복전송|제출성공,심사후디스플레이!|제출 성공!"
			case "fr"
				t ="Avant|Après|Peuvent être entrées| caractères|Publié|Anonyme|Utilisateurs|Login Publié|Après l'atterrissage, publié|La réponse:|Commentaire non activé|Pas de commentaires|Il n'y a pas de contenu|Interdiction de commentaires|L'interdiction de l'extérieur soumettre|Paramètre d'erreur|Le contenu ne peut pas être vide|Au moins une entrée 5 caractères|Surnom ne doit pas être vide|Pas de répétition de présentation|Transmis avec succès, Après vérification de l'affichage.|Transmis avec succès！"
			end select
			c=split(s,"|") 
			d=split(t,"|") 
			for i=0 to ubound(c) 
				t0=replace(t0,c(i),d(i)) 
			next 
		end if
		translate=t0
	end function
	
	public function getcitysite(byval t0)
		if eycms.strlen(eycms.getsys("eycms.plug.region"))=0 then exit function
		dim isopen:isopen=eycms.db.dbloadone("isopen","ey_plug_regionset","")
		if isopen=0 then exit function
		if eycms.checkcache("indexcitylist",0) then
			getcitysite=eycms.loadcache("indexcitylist",0)
		else
			dim mode:mode=eycms.db.dbloadone("mode","ey_plug_regionset","")
			dim shownum:shownum=eycms.db.dbloadone("shownum","ey_plug_regionset","")
			if shownum=0 then shownum=20
			dim data,mdata,shtml,i,target,surl
			data=db.dbload(shownum,"city,ename","ey_plug_region","zt=1","rnd")
			if ubound(data)>=0 Then
				if mode=0 Then shtml="主营区域：" else shtml="合作链接："
				if t0=1 then target=" target=_blank"
				for i=0 to ubound(data,2)
				  if mode=0 Then
				    surl=get_cityurl(data(1,i))
				    shtml=shtml&"<a href='" & surl & "'" & target & ">"& data(0,i) &"</a>"
				    shtml=shtml&"　"
				  else
				    mdata=eycms.db.dbload(1,"seokey,seodir","ey_plug_regionkey","kzt=1","rnd")
				    if ubound(mdata)>=0 Then
				      surl=get_keyurl(data(1,i),mdata(1,0))
				      shtml=shtml&"<a href='" & surl & "'" & target & ">"& data(0,i) & mdata(0,0) &"</a>"
				      shtml=shtml&"　"
				    end if
				  end if
				next
			end If
			eycms.setcache "indexcitylist",shtml,0
			getcitysite=shtml
		end if
	end function

	public function urlredirect()
		dim this_url:this_url=eycms.getthisurl
		if eycms.getsys("webmode")=2 then
			dim root:root=eycms.enhtml(eycms.fget("root",0))
			dim page:page=eycms.getint(eycms.fget("page",0),1)
			if InStr(this_url,"show.asp") then
				dim mdir:mdir=eycms.enhtml(eycms.fget("mdir",0))
				this_url=weburl&webroot&mdir&"/"
				if page>1 then
					this_url=this_url&root&"_"&page&".html"
				else
					this_url=this_url&root&".html"
				end if
			elseif InStr(this_url,"list.asp") then
				this_url=weburl&webroot&root&"/"
				if page>1 then
					this_url=this_url&page&"/"
				end if
			end if
		end if
		if eycms.strlen(eycms.getsys("eycms.plug.redirect"))>0 then
			if InStr(this_url,"admin")<=0 And InStr(this_url,"plug")<=0 then
				dim data,i,fromurl,tourl
				data=eycms.db.dbload("","tourl","ey_plug_redirect","lx=0 and zt=1 and fromurl='"&this_url&"'","")
				if ubound(data)>=0 then
					tourl=data(0,0)
					if left(tourl,4)<>"http" then tourl=http_head & tourl
					eycms.db.dbclose
					Response.Status="301 Moved Permanently"
					Response.AddHeader "Location",tourl
					eycms.die
				end if
			end if
		end if
	end function
end class
%>
