﻿<%
''' EYCMS 微信操作
''' ==================================================================

class eycms_weixin

	private apiUrl_
	private ToUserName,FromUserName,CreateTime,MsgType,MsgId
	private Content_
	private PicUrl_,MediaId_
	private Format_,Recognition_
	private ThumbMediaId_
	private Location_X_,Location_Y_,Scale_,Label_
	private Title_,Descriptions_,Url_
	private Events_,Latitude_,Longitude_,Precision_
	private EventKey_,Ticket_
	private newid_

	private sub class_initialize()
		apiUrl_="https://api.weixin.qq.com/cgi-bin/"
	end sub
	
	public sub check()
		On Error Resume next
		dim t0,t1,t2,t3
		t0=eycms.enhtml(eycms.fget("signature",0))
		t1=eycms.enhtml(eycms.fget("timestamp",0))
		t2=eycms.enhtml(eycms.fget("nonce",0))
		t3=eycms.enhtml(eycms.fget("echostr",0))
		if eycms.strlen(t0)=0 and eycms.strlen(t1)=0 and eycms.strlen(t2)=0 then eycms.die
		dim arr:arr=eycms.arr_sort(array(wx_token,t1,t2))
		arr=lcase(eycms.sha1(join(arr,"")))
		if arr=t0 then
			eycms.echo t3
			'eycms.errlog "函数：check<br>详情："&t3,0
		else
			eycms.die
		end if
	end sub
	
	public sub deal_xml()
		dim tk:tk=get_token
		on error resume next
		dim xml
		set xml=server.createObject("msxml2.DOMDocument")
		xml.async=false
		if(xml.load(request)) then
			ToUserName=xml.getelementsbytagname("ToUserName").item(0).text
			FromUserName=xml.getelementsbytagname("FromUserName").item(0).text
			CreateTime=xml.getelementsbytagname("CreateTime").item(0).text
			MsgType=xml.getelementsbytagname("MsgType").item(0).text
			MsgId=xml.getelementsbytagname("MsgId").item(0).text
			select case lcase(MsgType)
				case "text"
					Content_=xml.getelementsbytagname("Content").item(0).text
					newid_=msgdb(",array(""Content"",Content_,0,1)")
					auto_reply
				case "image"
					PicUrl_=xml.getelementsbytagname("PicUrl").item(0).text
					MediaId_=xml.getelementsbytagname("MediaId").item(0).text
					newid_=msgdb(",array(""PicUrl"",PicUrl_,0,1),array(""MediaId"",MediaId_,0,1)")
				case "voice"
					MediaId_=xml.getelementsbytagname("MediaId").item(0).text
					Format_=xml.getelementsbytagname("Format").item(0).text
					Recognition_=xml.getelementsbytagname("Recognition").item(0).text
					newid_=msgdb(",array(""MediaId"",MediaId_,0,1),array(""Format"",Format_,0,1),array(""Recognition"",Recognition_,0,1)")
				case "video"
					MediaId_=xml.getelementsbytagname("MediaId").item(0).text
					ThumbMediaId_=xml.getelementsbytagname("ThumbMediaId").item(0).text
					newid_=msgdb(",array(""MediaId"",MediaId_,0,1),array(""ThumbMediaId"",ThumbMediaId_,0,1)")
				case "location"
					Location_X_=xml.getelementsbytagname("Location_X").item(0).text
					Location_Y_=xml.getelementsbytagname("Location_Y").item(0).text
					Scale_=xml.getelementsbytagname("Scale").item(0).text
					Label_=xml.getelementsbytagname("Label").item(0).text
					newid_=msgdb(",array(""Location_X"",Location_X_,0,1),array(""Location_Y"",Location_Y_,0,1),array(""Scale"",Scale_,0,1),array(""Label"",Label_,0,1)")
				case "link"
					Title_=xml.getelementsbytagname("Title").item(0).text
					Descriptions_=xml.getelementsbytagname("Description").item(0).text
					Url_=xml.getelementsbytagname("Url").item(0).text
					newid_=msgdb(",array(""Title"",Title_,0,1),array(""Descriptions"",Descriptions_,0,1),array(""Url"",Url_,0,1)")
				case "event"
					Events_=xml.getelementsbytagname("Event").item(0).text
					select case Events_
						case "LOCATION"
							Latitude_=xml.getelementsbytagname("Latitude").item(0).text
							Longitude_=xml.getelementsbytagname("Longitude").item(0).text
							Precision_=xml.getelementsbytagname("Precision").item(0).text
							newid_=msgdb(",array(""Events"",Events_,0,1),array(""Latitude"",Latitude_,0,1),array(""Longitude"",Longitude_,0,1),array(""Precision"",Precision_,0,1)")
						case "subscribe","unsubscribe"
							EventKey_=xml.getelementsbytagname("EventKey").item(0).text
							Ticket_=xml.getelementsbytagname("Ticket").item(0).text
							if Events_="subscribe" then
								get_user_db()
								subscribe_reply()
							else
								eycms.db.dbupdate "wx_user","openid='"&FromUserName&"'",array(array("isuser",0,10,0))
							end if
							newid_=msgdb(",array(""Events"",Events_,0,1),array(""EventKey"",EventKey_,0,1),array(""Ticket"",Ticket_,0,1)")
						case "CLICK","VIEW"
							EventKey_=xml.getelementsbytagname("EventKey").item(0).text
							newid_=msgdb(",array(""Events"",Events_,0,1),array(""EventKey"",EventKey_,0,1)")
							if Events_="CLICK" then
								if instr(EventKey_,"master:")>0 then
									master_reply replace(EventKey_,"master:","")
								end if
								if instr(EventKey_,"text:")>0 then
									active_reply get_menu_text(replace(EventKey_,"text:",""))
								end if
							end if
						case "MASSSENDJOBFINISH"
							dim Status_,TotalCount_,FilterCount_,SentCount_,ErrorCount_
							Status_=xml.getelementsbytagname("Status").item(0).text
							TotalCount_=xml.getelementsbytagname("TotalCount").item(0).text
							FilterCount_=xml.getelementsbytagname("FilterCount").item(0).text
							SentCount_=xml.getelementsbytagname("SentCount").item(0).text
							ErrorCount_=xml.getelementsbytagname("ErrorCount").item(0).text
							MsgId=xml.getelementsbytagname("MsgID").item(0).text
							dim isok
							if Status_="send success" then
								isok=1
							else
								isok=2
							end if
							eycms.db.dbupdate "wx_mass","msg_id='"&MsgId&"'",array(array("isok",isok,10,0),array("totalnum",TotalCount_,10,0),array("oknum",SentCount_,10,0),array("nonum",ErrorCount_,10,0))
					end select
			end select
		end if
		if err then
			err.clear
		end if
		set xml=nothing
	end sub
	
	public sub set_cache(byval t0,byval t1)
		application.lock()
		application(prefix&t0)=t1
		application.unlock()
	end sub
	
	public function load_cache(byval t0)
	  load_cache=application(prefix&t0)
	end function
	
	public function get_token()
		if load_cache("get_token")="" then
			get_token=token_data
		else
			If datediff("s",load_cache("token_date"),now())>load_cache("expires_in") then
				get_token=token_data
			else
				get_token=load_cache("get_token")
			end if
		end if
	end function
	
	public function token_data()
		dim url:url=apiUrl_&"token?grant_type=client_credential&appid="&wx_appid&"&secret="&wx_key&""
		dim a:a=gethttp(url,"")
		If a<>"ERR" Then
			dim json,b,c
			set json=toobject(a)
			if instr(a,"access_token")<=0 then
				eycms.errlog json.errmsg,1
				eycms.die
			Else
				b=json.access_token
				c=json.expires_in
				set_cache "get_token",b
				set_cache "expires_in",c
				set_cache "token_date",now()
				token_data=b
			end if
			set json=Nothing
		Else
			eycms.errlog "函数：token_data<br>请求网址："&url&"<BR>详情："&a,0
		End if
	end function
	
	public function get_jsapi_ticket()
		if load_cache("jsapi_ticket")="" then
			get_jsapi_ticket=jsapi_ticket
		else
			If datediff("s",load_cache("jsapi_ticket_date"),now())>7200 then
				get_jsapi_ticket=jsapi_ticket
			else
				get_jsapi_ticket=load_cache("jsapi_ticket")
			end if
		end if
	end function
	
	public function jsapi_ticket()
		dim url:url="https://api.weixin.qq.com/cgi-bin/ticket/getticket?access_token="&get_token&"&type=jsapi"
			dim a:a=gethttp(url,"")
			dim json,ticket
			set json=toobject(a)
			if json.errcode="0" then
				ticket=json.ticket
				set_cache "jsapi_ticket",ticket
				set_cache "jsapi_ticket_date",now()
				jsapi_ticket=ticket
			else
				jsapi_ticket=""
			end if
			set json=nothing
	end function
	
	public function get_sign(byval t0,byval t1)
		dim timestamp:timestamp=t0
		dim noncestr:noncestr=timestamp
		dim url:url=t1
		dim jsapi_ticket:jsapi_ticket=get_jsapi_ticket
		dim arr:arr=eycms.arr_sort(array("timestamp="&timestamp,"noncestr="&noncestr,"url="&url,"jsapi_ticket="&jsapi_ticket))
		arr=lcase(eycms.sha1(join(arr,"&")))
		get_sign=arr
	end function
	
	function get_user_nickname()
		dim data:data=eycms.db.dbload(1,"nickname","wx_user","openid='"&FromUserName&"'","")
		if ubound(data)<0 then
			get_user_nickname=""
		else
			get_user_nickname=data(0,0)
		end if
	end function
	
	sub get_user_db()
		eycms.db.dbnew "wx_user",array(array("openid",FromUserName,255),array("isget",0,10)),"openid='"&FromUserName&"'"
		get_user_base(FromUserName)
	end sub
	
	private function msgdb(byval t0)
		dim fstr:fstr="array("
		fstr=fstr&"array(""ToUserName"",ToUserName,255,1)"
		fstr=fstr&",array(""FromUserName"",FromUserName,255,1)"
		fstr=fstr&",array(""CreateTime"",CreateTime,255,1)"
		fstr=fstr&",array(""MsgType"",MsgType,255,1)"
		fstr=fstr&",array(""MsgId"",MsgId,255,1)"
		fstr=fstr&t0
		fstr=fstr&",array(""isreply"",0,1,0))"
		if lcase(MsgType)="text" then
			Content_=deal_face(Content_)
		end if
		eycms.db.insert "wx_msg",eval(fstr)
		msgdb=eycms.db.insertid("id","wx_msg")
	end function

	public sub subscribe_reply()
		select case eycms.getsys("reply_type")
			case "text"
				active_reply eycms.getsys("reply_content")
			case "master"
				master_reply eycms.getsys("reply_id")
		end select
	end sub
	
	public sub auto_reply()
		if eycms.getsys("auto_type")<>"close" then
			dim data
			data=eycms.db.dbload(1,"types,reply,replyid","wx_key","matchtype=2 and keyword='"&Content_&"'","ordnum desc,id desc")
			if ubound(data)>=0 then
				if data(0,0)=1 then
					active_reply data(1,0)
				else
					master_reply data(2,0)
				end if
				exit sub
			end if
			
			dim sqlstr
			if datatype then
				sqlstr="instr('"&Content_&"',keyword)>0"
			else
				sqlstr="charindex(keyword,'"&Content_&"')>0"
			end if
			
			data=eycms.db.dbload(1,"types,reply,replyid","wx_key","matchtype=1 and "&sqlstr&"","ordnum desc,id desc")
			if ubound(data)>=0 then
				if data(0,0)=1 then
					active_reply data(1,0)
				else
					master_reply data(2,0)
				end if
				exit sub
			end if		
		end if
		select case eycms.getsys("auto_type")
			case "text"
				active_reply eycms.getsys("auto_content")
			case "master"
				master_reply eycms.getsys("auto_id")
			case "robot"
				robot_reply
		end select
	end sub
	
	public sub robot_reply()
		dim url:url="http://www.tuling123.com/openapi/api?key="&eycms.getsys("auto_key")&"&info="&server.urlencode(Content_)&"&userid="&FromUserName&""
		dim robotname:robotname=eycms.getsys("auto_name")
		dim str:str=gethttp(url,"")
		dim json
		set json=toobject(str)
			str=json.text
		set json=nothing
		str=replace(str,"[cqname]",robotname)
		if instr(str,"[name]")>0 then
			str=replace(str,"[name]",eycms.getnickname_wx(FromUserName))
		end if
		active_reply str
	end sub
	
	public sub active_reply(byval t0)
		if instr(t0,"{nickname}")>0 then
			t0=replace(t0,"{nickname}",get_user_nickname)
		end if
		dim str
		str=str&"<xml>"
		str=str&"<ToUserName><![CDATA["&FromUserName&"]]></ToUserName>"
		str=str&"<FromUserName><![CDATA["&ToUserName&"]]></FromUserName>"
		str=str&"<CreateTime>"&eycms.datetonum("")&"</CreateTime>"
		str=str&"<MsgType><![CDATA[text]]></MsgType>"
		str=str&"<Content><![CDATA["&t0&"]]></Content>"
		str=str&"</xml>"
		eycms.echo str
		if newid_<>"" then eycms.db.dbupdate "wx_msg","id="&newid_&"",array(array("reply",t0,0,1),array("isreply",1,10,0))
	end sub
	
	public function msg_reply(byval t0,byval t1)
		dim url:url=apiUrl_&"message/custom/send?access_token="&get_token
		dim str:str=""
			str=str&"{"
			str=str&"	""touser"":"""&t0&""","
			str=str&"	""msgtype"":""text"","
			str=str&"	""text"":"
			str=str&"	{"
			str=str&"		 ""content"":"""&t1&""""
			str=str&"	}"
			str=str&"}"
		msg_reply=sethttp(url,str)
	end function
	
	public sub master_reply(byval t0)
		dim html:html=""
		html=html&"<xml>"
		html=html&"<ToUserName><![CDATA["&FromUserName&"]]></ToUserName>"
		html=html&"<FromUserName><![CDATA["&ToUserName&"]]></FromUserName>"
		html=html&"<CreateTime>"&eycms.datetonum("")&"</CreateTime>"
		html=html&"<MsgType><![CDATA[news]]></MsgType>"
		html=html&"<ArticleCount>$total</ArticleCount>"
		html=html&"<Articles>"
		html=html&"$body"
		html=html&"</Articles>"
		html=html&"</xml>"
		
		dim data:data=eycms.db.dbload(8,"id,title,pic,content","wx_master","classid="&t0&" and islock=1","ordnum,id")
		if ubound(data)<0 then
			exit sub
		end if
		dim i,str
		for i=0 to ubound(data,2)
			str=str&""
			str=str&"<item>"
			str=str&"<Title><![CDATA["&data(1,i)&"]]></Title>"
			str=str&"<Description><![CDATA["&eycms.cutstr(eycms.dishtml(data(3,i)),80,0)&"]]></Description>"
			str=str&"<PicUrl><![CDATA["&weburl&data(2,i)&"]]></PicUrl>"
			str=str&"<Url><![CDATA["&weburl&webroot&"/weixin/show.asp?id="&data(0,i)&"]]></Url>"
			str=str&"</item>"
		next
		html=replace(html,"$total",i)
		html=replace(html,"$body",str)
		eycms.echo html
		if newid_<>"" then
			eycms.db.dbupdate "wx_msg","id="&newid_&"",array(array("reply","图文消息，ID："&t0,0,1),array("isreply",1,10,0))
		end if
	end sub
	
	public function create_menu(byval t0)
		dim url:url=apiUrl_&"menu/create?access_token="&get_token&""
		create_menu=sethttp(url,t0)
	end function
	
	public function del_menu()
		dim url:url=apiUrl_&"menu/delete?access_token="&get_token
		del_menu=gethttp(url,"")
	end function
	
	public function get_menu()
		dim url:url=apiUrl_&"menu/get?access_token="&get_token
		get_menu=gethttp(url,"")
	end function
	
	public function get_menu_text(byval t0)
		dim data:data=eycms.db.dbload(1,"reply","wx_menu","id="&t0&"","")
		if ubound(data)<0 then
			get_menu_text="参数错误"
		else
			get_menu_text=eycms.dehtml(data(0,0))
		end if	
	end function
	
	public function create_diy_menu(byval t0)
		dim url:url=apiUrl_&"menu/addconditional?access_token="&get_token&""
		create_diy_menu=sethttp(url,t0)
	end function
	
	public function delete_diy_menu(byval t0)
		dim url:url=apiUrl_&"menu/delconditional?access_token="&get_token&""
		dim str:str="{""menuid"":"""&t0&"""}"
		delete_diy_menu=sethttp(url,str)
	end function
	
	public function get_user_list(byval t0)
		dim url:url=apiUrl_&"user/get?access_token="&get_token&"&next_openid="&t0
		get_user_list=gethttp(url,"")
	end function
	
	public function get_user_data(byval t0)
		dim url:url=apiUrl_&"user/info?access_token="&get_token&"&openid="&t0&"&lang=zh_CN"
		get_user_data=gethttp(url,"")
	end function
	
	function get_user_base(byval openid)
		dim userdata,json,data
		userdata=get_user_data(openid)
		set json=toobject(userdata)
			if instr(userdata,"errcode") then
				get_user_base=json.errmsg
			else
				if json.subscribe=1 then
					dim t0,t1,t2,t3,t4,t5,t6,t7,t8,t9,t10,t11
					t0=json.nickname
					t0=filter_nick(t0)
					t1=json.sex
					t2=json.city
					t3=json.province
					t4=json.country
					t5=json.headimgurl
					if t5<>"" then t5=replace(t5,"/132","/46")
					t6=json.subscribe_time
					t7=json.remark
					t8=json.groupid
					t9=1
					t10=""
					t11=json.tagid_list
					if instr(userdata,"unionid")>0 then
						t10=json.unionid
					end if
					data=array(array("nickname",t0,50,1),array("sex",t1,10,0),array("city",t2,50,1),array("province",t3,50,1),array("country",t4,50,1),array("headimgurl",t5,255,1),array("subscribe_time",t6,50,1),array("remark",t7,50,1),array("groupid",t8,10,0),array("unionid",t10,255,1),array("taglist",t11,255,1),array("isget",t9,10,0),array("isuser",1,10,0))
					eycms.db.dbupdate "wx_user","openid='"&openid&"'",data
				else
					eycms.db.dbupdate "wx_user","openid='"&openid&"'",array(array("isuser",0,10,0))
				end if
				get_user_base="true"
			end if
		set json=nothing
	end function

	public function set_user_remark(byval t0,byval t1)
		dim url:url=apiUrl_&"user/info/updateremark?access_token="&get_token&""
		dim str:str="{""openid"":""$openid"",""remark"":""$remark""}"
		str=replace(str,"$openid",t0)
		str=replace(str,"$remark",t1)
		set_user_remark=sethttp(url,str)
	end function

	public function get_user_group_list()
		dim url:url=apiUrl_&"groups/get?access_token="&get_token&""
		get_user_group_list=gethttp(url,"")
	end function
	
	public function create_user_group(byval t0)
		dim url:url=apiUrl_&"groups/create?access_token="&get_token&""
		dim str:str="{""group"":{""name"":"""&t0&"""}}"
		create_user_group=sethttp(url,str)
	end function
	
	public function update_user_group(byval t0,byval t1)
		dim url:url=apiUrl_&"groups/update?access_token="&get_token&""
		dim str:str="{""group"":{""id"":"&t0&",""name"":"""&t1&"""}}"
		update_user_group=sethttp(url,str)
	end function
	
	public function delete_user_group(byval t0)
		dim url:url=apiUrl_&"groups/delete?access_token="&get_token&""
		dim str:str="{""group"":{""id"":"&t0&"}}"
		delete_user_group=sethttp(url,str)
	end function
	
	public function batch_user_group(byval t0,byval t1)
		dim url:url=apiUrl_&"groups/members/batchupdate?access_token="&get_token&""
		dim str
		str="{""openid_list"":["&t0&"],""to_groupid"":"&t1&"}"
		batch_user_group=sethttp(url,str)
	end function
	
	public function get_user_tags_list()
		dim url:url=apiUrl_&"tags/get?access_token="&get_token&""
		get_user_tags_list=gethttp(url,"")
	end function
	
	public function create_user_tags(byval t0)
		dim url:url=apiUrl_&"tags/create?access_token="&get_token&""
		dim str:str="{""tag"":{""name"":"""&t0&"""}}"
		create_user_tags=sethttp(url,str)
	end function
	
	public function update_user_tags(byval t0,byval t1)
		dim url:url=apiUrl_&"tags/update?access_token="&get_token&""
		dim str:str="{""tag"":{""id"":"&t0&",""name"":"""&t1&"""}}"
		update_user_tags=sethttp(url,str)
	end function
	
	public function delete_user_tags(byval t0)
		dim url:url=apiUrl_&"tags/delete?access_token="&get_token&""
		dim str:str="{""tag"":{""id"":"&t0&"}}"
		delete_user_tags=sethttp(url,str)
	end function
	
	public function set_user_add_tags(byval t0,byval t1)
		dim url:url=apiUrl_&"tags/members/batchtagging?access_token="&get_token&""
		dim str:str="{""openid_list"":["""&t0&"""],""tagid"":"&t1&"}"
		set_user_add_tags=sethttp(url,str)
	end function
	
	public function set_user_del_tags(byval t0,byval t1)
		dim url:url=apiUrl_&"tags/members/batchuntagging?access_token="&get_token&""
		dim str:str="{""openid_list"":["""&t0&"""],""tagid"":"&t1&"}"
		set_user_del_tags=sethttp(url,str)
	end function
	
	public function upload_image(byval t0)
		dim t1,t2,xml,result
		t1=apiUrl_&"media/uploadimg?access_token="&get_token&""
		t2=server.mappath(t0)
		set xml=new XMLUploadImpl
			xml.charset="utf-8"
			xml.addfile "media",t2,"image/jpg",getfilebinary(t2)
			result=xml.upload(t1)
		set xml=nothing
		upload_image=result
	end function
	
	public function upload_media_image(byval t0)
		dim t1,t2,xml,result
		t1="http://file.api.weixin.qq.com/cgi-bin/media/upload?access_token="&get_token&"&type=image"
		t2=server.mappath(t0)
		set xml=new XMLUploadImpl
			xml.charset="utf-8"
			xml.addfile "media",t2,"image/jpg",getfilebinary(t2)
			result=xml.upload(t1)
		set xml=nothing
		upload_media_image=result
	end function
	
	public function upload_master(byval t0)
		dim url:url="https://api.weixin.qq.com/cgi-bin/media/uploadnews?access_token="&get_token&""
		upload_master=sethttp(url,t0)
	end function
	
	public function mass_message(byval t0,byval t1,byval t2)
		dim url:url=apiUrl_&"message/mass/sendall?access_token="&get_token&""
		dim t3:t3=eycms.iif(t0<0,"true","false")
		dim t4:t4=""
		if t0>0 then
			t4=",""tag_id"":"""&t0&""""
		end if
		dim str
		if t1=1 then
			str="{""filter"":{""is_to_all"":"&t3&t4&"},""text"":{""content"":"""&t2&"""},""msgtype"":""text""}"
		else		
			str="{""filter"":{""is_to_all"":"&t3&t4&"},""mpnews"":{""media_id"":"""&t2&"""},""msgtype"":""mpnews""}"
		end if
		mass_message=sethttp(url,str)
	end function
	
	public function deal_face(byval t0)
		dim arr:arr=array("/::)","/::~","/::B","/::|","/:8-)","/::<","/::$","/::X","/::Z","/::'(","/::-|","/::@","/::P","/::D","/::O","/::(","/::+","/:–b","/::Q","/::T","/:,@P","/:,@-D","/::d","/:,@o","/::g","/:|-)","/::!","/::L","/::>","/::,@","/:,@f","/::-S","/:?","/:,@x","/:,@@","/::8","/:,@!","/:!!!","/:xx","/:bye","/:wipe","/:dig","/:handclap","/:&-(","/:B-)","/:<@","/:@>","/::-O","/:>-|","/:P-(","/::'|","/:X-)","/::*","/:@x","/:8*","/:pd","/:<W>","/:beer","/:basketb","/:oo","/:coffee","/:eat","/:pig","/:rose","/:fade","/:showlove","/:heart","/:break","/:cake","/:li","/:bome","/:kn","/:footb","/:ladybug","/:shit","/:moon","/:sun","/:gift","/:hug","/:strong","/:weak","/:share","/:v","/:@)","/:jj","/:@@","/:bad","/:lvu","/:no","/:ok","/:love","/:<L>","/:jump","/:shake","/:<O>","/:circle","/:kotow","/:turn","/:skip","[挥手]","/:#-0","[街舞]","/:kiss","/:<&")
		dim i
		for i=0 to ubound(arr)
			t0=replace(t0,arr(i),"[face:"&i&"]")
		next
		deal_face=t0
	end function
	
	public function filter_nick(byval t0)
		if not(datatype) then
			t0=replace(t0," ","")
			t0=replace(t0,"　","")
			t0=replace(t0,"","")
			t0=replace(t0," ","")
			t0=replace(t0,"✨","")
		end if
		filter_nick=t0
	end Function
	
	public function gethttp(byval t0,byval t1)
		on error resume next
		dim http
		set http=server.createobject("MSXML2.ServerXMLHTTP")
			http.SetTimeOuts 20000, 20000, 30000, 30000
			http.open "GET",t0,False
			http.setrequestheader "Connection", "Keep-Alive"
			http.setRequestHeader "Content-Type", "application/x-www-form-urlencoded"			
			http.send()
			If http.Readystate<>4 then
				Set http=nothing
				gethttp="ERR"
				Exit function
			End if
			if http.status=200 then
				gethttp=http.responsetext
			else
				gethttp="ERR"
				Set http=nothing
				Exit function
			end if
		set http=nothing
		if err then 
			gethttp="ERR"
			eycms.errlog "网址："&t0&"<br>函数：gethttp<br>详情："&err.description,0
			err.clear
		end if
	end Function

	public function sethttp(byval t0,byval t1)
		on error resume next
		dim http
		set http=server.createobject("MSXML2.ServerXMLHTTP")
			http.SetTimeOuts 20000, 20000, 30000, 30000
			http.open "POST",t0,False
			http.setrequestheader "Referer",t0
			http.setrequestheader "User-Agent", "Mozilla/4.0"
			http.setrequestheader "Connection", "Keep-Alive"
			http.setrequestheader "Content-Length",len(t1)
			http.setRequestHeader "Content-Type", "application/x-www-form-urlencoded"			
			http.send(t1)
			If http.Readystate<>4 then
				Set http=nothing
				sethttp="ERR"
				Exit function
			End if
			if http.status=200 then
				sethttp=http.responsetext
			else
				sethttp="ERR"
				Set http=nothing
				Exit function
			end if
		set http=nothing
		if err then 
			sethttp="ERR"
			eycms.errlog "网址："&t0&"<br>函数：sendhttp<br>详情："&err.description,0
			err.clear
		end if
	end Function
end class
%>