﻿<%
class InstallRegion_Class
	dim Pinyin
	Private Sub Class_Initialize()
		set Pinyin = new EasyAsp_Pinyin
	End Sub

	Private Sub Class_Terminate()
		set Pinyin = nothing
	End Sub	

	public function addRegion(regionId, parentId, name, eName, isson)
		dim data,depth,enName
		depth=len(regionId)/2
		if eycms.strlen(eName)=0 then 
			if len(name)<=3 then 
				enName=Pinyin.GetPy(name)
			else
				enName=eycms.get_pinyin(name)
			end if
		else
			enName=eName
		end if

		'if eycms.strlen(enName)>0 then 
		'  if eycms.db.dbcount("ey_plug_region","ename='"&enName&"'")>0 then
		'	 eycms.errlog "函数：addRegion，ID："&regionid&"，地区："&name&"，拼音："&enName,0
		'  end if
		'end if

		if eycms.db.dbcount("ey_plug_region","regionid="&regionid)>0 then
			eycms.db.dbupdate "ey_plug_region","regionid="&regionid,array(array("parentid",parentId,0,0),array("city",name,255,1),array("ename",enName,255,1),array("depth",depth,1,0),array("isson",isson,1,0))
		else
			data=array(array("regionid",regionid,0,0),array("parentid",parentId,0,0),array("city",name,255,1),array("ename",enName,255,1),array("depth",depth,1,0),array("isson",isson,1,0),array("ordnum",0,0,0),array("zt",0,0,0))
			eycms.db.insert "ey_plug_region",data
		end if
	end function
	
	public function init()
		call adding()
	end function
	
	public function adding()
		call addRegion(10,0,"北京","beijing",1)
		call addRegion(1001,10,"东城","dongcheng",0)
		call addRegion(1003,10,"西城","xicheng",0)
		call addRegion(1004,10,"崇文","chongwen",0)
		call addRegion(1005,10,"宣武","xuanwu",0)
		call addRegion(1006,10,"朝阳","chaoyang",0)
		call addRegion(1007,10,"丰台","fentai",0)
		call addRegion(1008,10,"石景山","shijingshan",0)
		call addRegion(1009,10,"海淀","haidian",0)
		call addRegion(1010,10,"门头沟","mentougou",0)
		call addRegion(1011,10,"房山","fangshan",0)
		call addRegion(1012,10,"通州","tongzhou",0)
		call addRegion(1013,10,"顺义","shunyi",0)
		call addRegion(1014,10,"昌平","changping",0)
		call addRegion(1015,10,"大兴","daxing",0)
		call addRegion(1016,10,"怀柔","huairou",0)
		call addRegion(1017,10,"平谷","pinggu",0)
		call addRegion(1018,10,"密云","miyun",0)
		call addRegion(1019,10,"延庆","yanqing",0)

		call addRegion(11,0,"上海","shanghai",1)
		call addRegion(1101,11,"黄浦","huangpu",0)
		call addRegion(1102,11,"卢湾","luwan",0)
		call addRegion(1103,11,"徐汇","xuhui",0)
		call addRegion(1104,11,"长宁","changning",0)
		call addRegion(1105,11,"静安","jingan",0)
		call addRegion(1106,11,"普陀","putuo",0)
		call addRegion(1107,11,"闸北","zhabei",0)
		call addRegion(1108,11,"虹口","hongkou",0)
		call addRegion(1109,11,"杨浦","yangpu",0)
		call addRegion(1110,11,"闵行","minhang",0)
		call addRegion(1111,11,"宝山","shbaoshan",0)
		call addRegion(1112,11,"嘉定","jiading",0)
		call addRegion(1113,11,"浦东","pudong",0)
		call addRegion(1114,11,"金山","jinshan",0)
		call addRegion(1115,11,"松江","songjiang",0)
		call addRegion(1116,11,"青浦","qingpu",0)
		call addRegion(1117,11,"南汇","nanhui",0)
		call addRegion(1118,11,"奉贤","fengxian",0)
		call addRegion(1119,11,"崇明","chongming",0)

		call addRegion(12,0,"天津","tianjing",1)
		call addRegion(1201,12,"和平","heping",0)
		call addRegion(1202,12,"河东","hedong",0)
		call addRegion(1203,12,"河西","hexi",0)
		call addRegion(1204,12,"南开","nankai",0)
		call addRegion(1205,12,"河北","hebeiqu",0)
		call addRegion(1206,12,"红桥","hongqiao",0)
		call addRegion(1207,12,"塘沽","tanggu",0)
		call addRegion(1208,12,"汉沽","hangu",0)
		call addRegion(1209,12,"大港","dagang",0)
		call addRegion(1210,12,"东丽","dongli",0)
		call addRegion(1211,12,"西青","xiqing",0)
		call addRegion(1212,12,"津南","jingnan",0)
		call addRegion(1213,12,"北辰","beichen",0)
		call addRegion(1214,12,"武清","wuqing",0)
		call addRegion(1215,12,"宝坻","baodi",0)
		call addRegion(1216,12,"宁河","ninghe",0)
		call addRegion(1217,12,"静海","jinghai",0)
		call addRegion(1218,12,"蓟州","jizhou",0)

		call addRegion(13,0,"重庆","chongqin",1)
		call addRegion(1301,13,"万州","wanzhou",0)
		call addRegion(1302,13,"涪陵","fuling",0)
		call addRegion(1303,13,"渝中","yuzh",0)
		call addRegion(1304,13,"大渡口","dadukou",0)
		call addRegion(1305,13,"江北","jb",0)
		call addRegion(1306,13,"沙坪坝","shapingba",0)
		call addRegion(1307,13,"九龙坡","jiulongpo",0)
		call addRegion(1308,13,"南岸","nananqu",0)
		call addRegion(1309,13,"北碚","beibei",0)
		call addRegion(1310,13,"万盛","wansheng",0)
		call addRegion(1311,13,"双桥","shuangqiao",0)
		call addRegion(1312,13,"渝北","yubei",0)
		call addRegion(1313,13,"巴南","banan",0)
		call addRegion(1314,13,"黔江","qianjiang",0)
		call addRegion(1315,13,"长寿","changshouqu",0)
		call addRegion(1316,13,"綦江","qijiang",0)
		call addRegion(1317,13,"潼南","tongnan",0)
		call addRegion(1318,13,"铜梁","tongliang",0)
		call addRegion(1319,13,"大足","dazu",0)
		call addRegion(1320,13,"荣昌","rongchang",0)
		call addRegion(1321,13,"璧山","bishan",0)
		call addRegion(1322,13,"梁平","liangping",0)
		call addRegion(1323,13,"城口","chengkou",0)
		call addRegion(1324,13,"丰都","fengdu",0)
		call addRegion(1325,13,"垫江","dianjiang",0)
		call addRegion(1326,13,"武隆","wulong",0)
		call addRegion(1327,13,"忠县","zhongxian",0)
		call addRegion(1328,13,"开州","kaizhou",0)
		call addRegion(1329,13,"云阳","yunyang",0)
		call addRegion(1330,13,"奉节","fengjie",0)
		call addRegion(1331,13,"巫山","wushan",0)
		call addRegion(1332,13,"巫溪","wuxi",0)
		call addRegion(1333,13,"石柱","shizhu",0)
		call addRegion(1334,13,"秀山","xiushan",0)
		call addRegion(1335,13,"酉阳","youyang",0)
		call addRegion(1336,13,"彭水","pengshui",0)
		call addRegion(1337,13,"江津","jiangjin",0)
		call addRegion(1338,13,"合川","hechuan",0)
		call addRegion(1339,13,"永川","yongchuan",0)
		call addRegion(1340,13,"南川","nanchuan",0)

		call addRegion(14,0,"安徽","anhui",1)
		call addRegion(1401,14,"合肥","gefei",1)
		call addRegion(140101,1401,"瑶海","yaohai",0)
		call addRegion(140102,1401,"庐阳","luyang",0)
		call addRegion(140103,1401,"蜀山","shushan",0)
		call addRegion(140104,1401,"包河","baohe",0)
		call addRegion(140105,1401,"长丰","changfeng",0)
		call addRegion(140106,1401,"肥东","feidong",0)
		call addRegion(140107,1401,"肥西","feixi",0)
		call addRegion(1402,14,"安庆","anqing",1)
		call addRegion(140201,1402,"迎江","yingjiang",0)
		call addRegion(140202,1402,"大观","daguan",0)
		call addRegion(140203,1402,"郊区","aqjq",0)
		call addRegion(140204,1402,"怀宁","huaining",0)
		call addRegion(140205,1402,"枞阳","congyang",0)
		call addRegion(140206,1402,"潜山","qianshan",0)
		call addRegion(140207,1402,"太湖","taihu",0)
		call addRegion(140208,1402,"宿松","qisong",0)
		call addRegion(140209,1402,"望江","wangjiang",0)
		call addRegion(140210,1402,"岳西","yuexi",0)
		call addRegion(140211,1402,"桐城","tongcheng",0)
		call addRegion(1403,14,"蚌埠","bangbu",1)
		call addRegion(140301,1403,"龙子湖","longzihu",0)
		call addRegion(140302,1403,"蚌山","bangshan",0)
		call addRegion(140303,1403,"禹会","yuhui",0)
		call addRegion(140304,1403,"淮上","huaishang",0)
		call addRegion(140305,1403,"怀远","huaiyuan",0)
		call addRegion(140306,1403,"五河","wuhe",0)
		call addRegion(140307,1403,"固镇","guzhen",0)
		call addRegion(1404,14,"亳州","bozhou",1)
		call addRegion(140401,1404,"谯城","qiaocheng",0)
		call addRegion(140402,1404,"涡阳","guoyang",0)
		call addRegion(140403,1404,"蒙城","mengcheng",0)
		call addRegion(140404,1404,"利辛","lixin",0)
		call addRegion(1405,14,"巢湖","chaohu",1)
		call addRegion(140501,1405,"居巢","jichao",0)
		call addRegion(140502,1405,"庐江","lujiang",0)
		call addRegion(140503,1405,"无为","mowei",0)
		call addRegion(140504,1405,"含山","hanshan",0)
		call addRegion(140505,1405,"和县","hexian",0)
		call addRegion(1406,14,"池州","chezhou",1)
		call addRegion(140601,1406,"贵池","guiche",0)
		call addRegion(140602,1406,"东至","dongdie",0)
		call addRegion(140603,1406,"石台","shitai",0)
		call addRegion(140604,1406,"青阳","qingyang",0)
		call addRegion(1407,14,"滁州","chuzhou",1)
		call addRegion(140701,1407,"琅琊","langya",0)
		call addRegion(140702,1407,"南谯","nanqiao",0)
		call addRegion(140703,1407,"来安","laian",0)
		call addRegion(140704,1407,"全椒","quanjiao",0)
		call addRegion(140705,1407,"定远","dingyuan",0)
		call addRegion(140706,1407,"凤阳","fengyang",0)
		call addRegion(140707,1407,"天长","tianchang",0)
		call addRegion(140708,1407,"明光","mengguang",0)
		call addRegion(1408,14,"阜阳","fuyang",1)
		call addRegion(140801,1408,"颍州","yingzhou",0)
		call addRegion(140802,1408,"颍东","yingdong",0)
		call addRegion(140803,1408,"颍泉","yingquan",0)
		call addRegion(140804,1408,"临泉","linquan",0)
		call addRegion(140805,1408,"太和","taihe",0)
		call addRegion(140806,1408,"阜南","funan",0)
		call addRegion(140807,1408,"颍上","yingshang",0)
		call addRegion(140808,1408,"界首","jieshou",0)
		call addRegion(1409,14,"淮北","huaibei",1)
		call addRegion(140901,1409,"杜集","duji",0)
		call addRegion(140902,1409,"相山","xiangshan",0)
		call addRegion(140903,1409,"烈山","lieshan",0)
		call addRegion(140904,1409,"濉溪","suixi",0)
		call addRegion(1410,14,"淮南","huainan",1)
		call addRegion(141001,1410,"大通","hndatong",0)
		call addRegion(141002,1410,"田家庵","tianjiaan",0)
		call addRegion(141003,1410,"谢家集","xiejiaji",0)
		call addRegion(141004,1410,"八公山","bagongshan",0)
		call addRegion(141005,1410,"潘集","boji",0)
		call addRegion(141006,1410,"凤台","fengtai",0)
		call addRegion(1411,14,"黄山","huangshan",1)
		call addRegion(141101,1411,"屯溪","tunxi",0)
		call addRegion(141102,1411,"黄山","huangs",0)
		call addRegion(141103,1411,"徽州","huizhou",0)
		call addRegion(141104,1411,"歙县","shexian",0)
		call addRegion(141105,1411,"休宁","xiuning",0)
		call addRegion(141106,1411,"黟县","yixian",0)
		call addRegion(141107,1411,"祁门","qimen",0)
		call addRegion(1412,14,"六安","liuan",1)
		call addRegion(141201,1412,"金安","jinanx",0)
		call addRegion(141202,1412,"裕安","yuan",0)
		call addRegion(141203,1412,"寿县","shouxian",0)
		call addRegion(141204,1412,"霍邱","heqiu",0)
		call addRegion(141205,1412,"舒城","shucheng",0)
		call addRegion(141206,1412,"金寨","jinqian",0)
		call addRegion(141207,1412,"霍山","heshan",0)
		call addRegion(1413,14,"马鞍山","maanshan",1)
		call addRegion(141301,1413,"金家庄","jinjiapeng",0)
		call addRegion(141302,1413,"花山","huashan",0)
		call addRegion(141303,1413,"雨山","yushan",0)
		call addRegion(141304,1413,"当涂","dangchu",0)
		call addRegion(1414,14,"宿州","qizhou",1)
		call addRegion(141401,1414,"墉桥","yongqiao",0)
		call addRegion(141402,1414,"砀山","dangshan",0)
		call addRegion(141403,1414,"萧县","xiaoxian",0)
		call addRegion(141404,1414,"灵璧","lingbi",0)
		call addRegion(141405,1414,"泗县","sixian",0)
		call addRegion(1415,14,"铜陵","tongling",1)
		call addRegion(141501,1415,"铜官山","tongguanshan",0)
		call addRegion(141502,1415,"狮子山","shizishan",0)
		call addRegion(141503,1415,"郊区","tljq",0)
		call addRegion(141504,1415,"铜陵","tongl",0)
		call addRegion(1416,14,"芜湖","wuhu",1)
		call addRegion(141601,1416,"镜湖","jinghu",0)
		call addRegion(141602,1416,"马塘","matang",0)
		call addRegion(141603,1416,"新芜","xinwu",0)
		call addRegion(141604,1416,"鸠江","jiujiangx",0)
		call addRegion(141605,1416,"繁昌","fanchang",0)
		call addRegion(141606,1416,"南陵","nanling",0)
		call addRegion(1417,14,"宣城","xuancheng",1)
		call addRegion(141701,1417,"宣州","xuanzhou",0)
		call addRegion(141702,1417,"郎溪","langxi",0)
		call addRegion(141703,1417,"广德","guangde",0)
		call addRegion(141704,1417,"泾县","jingxian",0)
		call addRegion(141705,1417,"绩溪","jixi",0)
		call addRegion(141706,1417,"旌德","jingde",0)
		call addRegion(141707,1417,"宁国","ningguo",0)

		call addRegion(15,0,"福建","fujian",1)
		call addRegion(1501,15,"福州","fuzhoushi",1)
		call addRegion(150101,1501,"鼓楼","gulouqu",0)
		call addRegion(150102,1501,"台江","taijiang",0)
		call addRegion(150103,1501,"仓山","cangshan",0)
		call addRegion(150104,1501,"马尾","mawei",0)
		call addRegion(150105,1501,"晋安","jina",0)
		call addRegion(150106,1501,"闽侯","minhou",0)
		call addRegion(150107,1501,"连江","lianjiang",0)
		call addRegion(150108,1501,"罗源","luoyuan",0)
		call addRegion(150109,1501,"闽清","minqing",0)
		call addRegion(150110,1501,"永泰","yongtai",0)
		call addRegion(150111,1501,"平潭","pingtan",0)
		call addRegion(150112,1501,"福清","fuqing",0)
		call addRegion(150113,1501,"长乐","changle",0)
		call addRegion(1502,15,"龙岩","longyan",1)
		call addRegion(150201,1502,"新罗","xinluo",0)
		call addRegion(150202,1502,"长汀","changding",0)
		call addRegion(150203,1502,"永定","yongding",0)
		call addRegion(150204,1502,"上杭","shanghang",0)
		call addRegion(150205,1502,"武平","wuping",0)
		call addRegion(150206,1502,"连城","liancheng",0)
		call addRegion(150207,1502,"漳平","zhangping",0)
		call addRegion(1503,15,"南平","nanping",1)
		call addRegion(150301,1503,"延平","yanping",0)
		call addRegion(150302,1503,"顺昌","shunchang",0)
		call addRegion(150303,1503,"浦城","pucheng",0)
		call addRegion(150304,1503,"光泽","guangze",0)
		call addRegion(150305,1503,"松溪","songxi",0)
		call addRegion(150306,1503,"政和","zhenghe",0)
		call addRegion(150307,1503,"邵武","shaowu",0)
		call addRegion(150308,1503,"武夷山","wuyishan",0)
		call addRegion(150309,1503,"建瓯","jianou",0)
		call addRegion(150310,1503,"建阳","jianyang",0)
		call addRegion(1504,15,"宁德","ningde",1)
		call addRegion(150401,1504,"蕉城","jiaocheng",0)
		call addRegion(150402,1504,"霞浦","xiapu",0)
		call addRegion(150403,1504,"古田","gut",0)
		call addRegion(150404,1504,"屏南","pingnan",0)
		call addRegion(150405,1504,"寿宁","shouning",0)
		call addRegion(150406,1504,"周宁","zhouning",0)
		call addRegion(150407,1504,"柘荣","zherong",0)
		call addRegion(150408,1504,"福安","fuan",0)
		call addRegion(150409,1504,"福鼎","fuding",0)
		call addRegion(1505,15,"莆田","futian",1)
		call addRegion(150501,1505,"城厢","chengxiang",0)
		call addRegion(150502,1505,"涵江","hanjiang",0)
		call addRegion(150503,1505,"荔城","licheng",0)
		call addRegion(150504,1505,"秀屿","xiuyu",0)
		call addRegion(150505,1505,"仙游","xianliu",0)
		call addRegion(1506,15,"泉州","quanzhou",1)
		call addRegion(150601,1506,"鲤城","lic",0)
		call addRegion(150602,1506,"丰泽","fengze",0)
		call addRegion(150603,1506,"洛江","luojiang",0)
		call addRegion(150604,1506,"泉港","quangang",0)
		call addRegion(150605,1506,"惠安","huian",0)
		call addRegion(150606,1506,"安溪","anxi",0)
		call addRegion(150607,1506,"永春","yongchun",0)
		call addRegion(150608,1506,"德化","dehua",0)
		call addRegion(150609,1506,"金门","jinmen",0)
		call addRegion(150610,1506,"石狮","shishi",0)
		call addRegion(150611,1506,"晋江","jinjiang",0)
		call addRegion(150612,1506,"南安","nanan",0)
		call addRegion(1507,15,"三明","sanmeng",1)
		call addRegion(150701,1507,"梅列","meili",0)
		call addRegion(150702,1507,"三元","sanyuan",0)
		call addRegion(150703,1507,"明溪","mengxi",0)
		call addRegion(150704,1507,"清流","qingliu",0)
		call addRegion(150705,1507,"宁化","ninghua",0)
		call addRegion(150706,1507,"大田","datian",0)
		call addRegion(150707,1507,"尤溪","youxi",0)
		call addRegion(150708,1507,"沙县","shaxian",0)
		call addRegion(150709,1507,"将乐","jiangle",0)
		call addRegion(150710,1507,"泰宁","taining",0)
		call addRegion(150711,1507,"建宁","jianning",0)
		call addRegion(150712,1507,"永安","yongan",0)
		call addRegion(1508,15,"厦门","shamen",1)
		call addRegion(150801,1508,"思明","saimeng",0)
		call addRegion(150802,1508,"海沧","haicang",0)
		call addRegion(150803,1508,"湖里","huli",0)
		call addRegion(150804,1508,"集美","jimei",0)
		call addRegion(150805,1508,"同安","tongan",0)
		call addRegion(150806,1508,"翔安","xiangan",0)
		call addRegion(1509,15,"漳州","zhangzhou",1)
		call addRegion(150901,1509,"芗城","xiangcheng",0)
		call addRegion(150902,1509,"龙文","longwen",0)
		call addRegion(150903,1509,"云霄","yunxiao",0)
		call addRegion(150904,1509,"漳浦","zhangpu",0)
		call addRegion(150905,1509,"诏安","zhaoan",0)
		call addRegion(150906,1509,"长泰","changtai",0)
		call addRegion(150907,1509,"东山","dongshan",0)
		call addRegion(150908,1509,"南靖","nanjingx",0)
		call addRegion(150909,1509,"平和","pinghe",0)
		call addRegion(150910,1509,"华安","huaan",0)
		call addRegion(150911,1509,"龙海","longhai",0)

		call addRegion(16,0,"甘肃","gansu",1)
		call addRegion(1601,16,"兰州","lanzhou",1)
		call addRegion(160101,1601,"城关","chengguan",0)
		call addRegion(160102,1601,"七里河","qilihe",0)
		call addRegion(160103,1601,"西固","xigu",0)
		call addRegion(160104,1601,"安宁","anning",0)
		call addRegion(160105,1601,"红古","honggu",0)
		call addRegion(160106,1601,"永登","yongde",0)
		call addRegion(160107,1601,"皋兰","gaolan",0)
		call addRegion(160108,1601,"榆中","yuzhong",0)
		call addRegion(1602,16,"白银","baiyin",1)
		call addRegion(160201,1602,"平川","pingchuan",0)
		call addRegion(160202,1602,"靖远","jingyuan",0)
		call addRegion(160203,1602,"会宁","huining",0)
		call addRegion(160204,1602,"景泰","jingtai",0)
		call addRegion(1603,16,"定西","dingxi",1)
		call addRegion(160301,1603,"安定","anding",0)
		call addRegion(160302,1603,"通渭","tongwei",0)
		call addRegion(160303,1603,"陇西","longxi",0)
		call addRegion(160304,1603,"渭源","weiyuan",0)
		call addRegion(160305,1603,"临洮","lindao",0)
		call addRegion(160306,1603,"漳县","zhangxian",0)
		call addRegion(160307,1603,"岷县","minxian",0)
		call addRegion(1604,16,"甘南","gannan",1)
		call addRegion(160401,1604,"合作","gezuo",0)
		call addRegion(160402,1604,"临潭","lintan",0)
		call addRegion(160403,1604,"卓尼","zhuoni",0)
		call addRegion(160404,1604,"舟曲","zhouqu",0)
		call addRegion(160405,1604,"迭部","dabu",0)
		call addRegion(160406,1604,"玛曲","maqu",0)
		call addRegion(160407,1604,"碌曲","liuqu",0)
		call addRegion(160408,1604,"夏河","xiahe",0)
		call addRegion(1605,16,"嘉峪关","jiayuguan",0)
		call addRegion(1606,16,"金昌","jinchang",1)
		call addRegion(160601,1606,"金川","jinchuan",0)
		call addRegion(160602,1606,"永昌","yongchang",0)
		call addRegion(1607,16,"酒泉","jiuquan",1)
		call addRegion(160701,1607,"肃州","suzhoux",0)
		call addRegion(160702,1607,"金塔","jinta",0)
		call addRegion(160703,1607,"安西","anxix",0)
		call addRegion(160704,1607,"肃北","subei",0)
		call addRegion(160705,1607,"阿克塞","akesai",0)
		call addRegion(160706,1607,"玉门","yumen",0)
		call addRegion(160707,1607,"敦煌","duihuang",0)
		call addRegion(1608,16,"临夏","linxia",1)
		call addRegion(160801,1608,"临夏市","linxiashi",0)
		call addRegion(160802,1608,"临夏县","linxiaxian",0)
		call addRegion(160803,1608,"康乐","kangle",0)
		call addRegion(160804,1608,"永靖","yongjing",0)
		call addRegion(160805,1608,"广河","guanghe",0)
		call addRegion(160806,1608,"和政","hezheng",0)
		call addRegion(160807,1608,"东乡","dongxiang",0)
		call addRegion(160808,1608,"积石山","jishishan",0)
		call addRegion(1609,16,"陇南","longnan",1)
		call addRegion(160901,1609,"武都","wudou",0)
		call addRegion(160902,1609,"成县","chengxian",0)
		call addRegion(160903,1609,"文县","wenxian",0)
		call addRegion(160904,1609,"宕昌","dangchang",0)
		call addRegion(160905,1609,"康县","kangxian",0)
		call addRegion(160906,1609,"西和","xihe",0)
		call addRegion(160907,1609,"礼县","lixian",0)
		call addRegion(160908,1609,"徽县","huixian",0)
		call addRegion(160909,1609,"两当","liangdang",0)
		call addRegion(1610,16,"平凉","pingliang",1)
		call addRegion(161001,1610,"崆峒","kongdong",0)
		call addRegion(161002,1610,"泾川","jingchuan",0)
		call addRegion(161003,1610,"灵台","lingtai",0)
		call addRegion(161004,1610,"崇信","chongxin",0)
		call addRegion(161005,1610,"华亭","huating",0)
		call addRegion(161006,1610,"庄浪","penglang",0)
		call addRegion(161007,1610,"静宁","jingning",0)
		call addRegion(1611,16,"庆阳","qiangyang",1)
		call addRegion(161101,1611,"西峰","xifeng",0)
		call addRegion(161102,1611,"庆城","qiangcheng",0)
		call addRegion(161103,1611,"环县","huanxian",0)
		call addRegion(161104,1611,"华池","huache",0)
		call addRegion(161105,1611,"合水","geshui",0)
		call addRegion(161106,1611,"正宁","zhengning",0)
		call addRegion(161107,1611,"宁县","ningxian",0)
		call addRegion(161108,1611,"镇原","zhenyuan",0)
		call addRegion(1612,16,"天水","tianshui",1)
		call addRegion(161201,1612,"秦城","qincheng",0)
		call addRegion(161202,1612,"北道","beidao",0)
		call addRegion(161203,1612,"清水","qingshui",0)
		call addRegion(161204,1612,"秦安","qinan",0)
		call addRegion(161205,1612,"甘谷","gangu",0)
		call addRegion(161206,1612,"武山","wus",0)
		call addRegion(161207,1612,"张家川","zhangjiachuan",0)
		call addRegion(1613,16,"武威","wuwei",1)
		call addRegion(161301,1613,"凉州","liangzhou",0)
		call addRegion(161302,1613,"民勤","minqi",0)
		call addRegion(161303,1613,"古浪","gulang",0)
		call addRegion(161304,1613,"天祝","tianchu",0)
		call addRegion(1614,16,"张掖","zhangye",1)
		call addRegion(161401,1614,"甘州","ganzhouqu",0)
		call addRegion(161402,1614,"肃南","sunan",0)
		call addRegion(161403,1614,"民乐","minle",0)
		call addRegion(161404,1614,"临泽","linze",0)
		call addRegion(161405,1614,"高台","gaotai",0)
		call addRegion(161406,1614,"山丹","shandan",0)

		call addRegion(17,0,"广东","guangdong",1)
		call addRegion(1701,17,"广州","guangzhou",1)
		call addRegion(170101,1701,"东山","gzdongshan",0)
		call addRegion(170102,1701,"荔湾","liwan",0)
		call addRegion(170103,1701,"越秀","huoxiu",0)
		call addRegion(170104,1701,"海珠","haizhu",0)
		call addRegion(170105,1701,"天河","tianhe",0)
		call addRegion(170106,1701,"芳村","fangcun",0)
		call addRegion(170107,1701,"白云","baiyun",0)
		call addRegion(170108,1701,"黄埔","huangbu",0)
		call addRegion(170109,1701,"番禺","boyu",0)
		call addRegion(170110,1701,"花都","huadou",0)
		call addRegion(170111,1701,"增城","cengcheng",0)
		call addRegion(170112,1701,"从化","conghua",0)
		call addRegion(1702,17,"潮州","chaozhou",1)
		call addRegion(170201,1702,"湘桥","xiangqiao",0)
		call addRegion(170202,1702,"潮安","chaoan",0)
		call addRegion(170203,1702,"饶平","raoping",0)
		call addRegion(1703,17,"东莞","dongguan",0)
		call addRegion(1704,17,"佛山","foshan",1)
		call addRegion(170401,1704,"禅城","chancheng",0)
		call addRegion(170402,1704,"南海","nanhai",0)
		call addRegion(170403,1704,"顺德","shunde",0)
		call addRegion(170404,1704,"三水","sanshui",0)
		call addRegion(170405,1704,"高明","gaomeng",0)
		call addRegion(1705,17,"河源","heyuan",1)
		call addRegion(170501,1705,"源城","yuancheng",0)
		call addRegion(170502,1705,"紫金","zijin",0)
		call addRegion(170503,1705,"龙川","longchuan",0)
		call addRegion(170504,1705,"连平","lianping",0)
		call addRegion(170505,1705,"和平","hepingx",0)
		call addRegion(170506,1705,"东源","dongyuan",0)
		call addRegion(1706,17,"惠州","huiz",1)
		call addRegion(170601,1706,"惠城","huicheng",0)
		call addRegion(170602,1706,"惠阳","huiyang",0)
		call addRegion(170603,1706,"博罗","boluo",0)
		call addRegion(170604,1706,"惠东","huidong",0)
		call addRegion(170605,1706,"龙门","longmen",0)
		call addRegion(1707,17,"江门","jiangmen",1)
		call addRegion(170701,1707,"蓬江","pengjiang",0)
		call addRegion(170702,1707,"江海","jianghai",0)
		call addRegion(170703,1707,"新会","xinhui",0)
		call addRegion(170704,1707,"台山","taishan",0)
		call addRegion(170705,1707,"开平","kaiping",0)
		call addRegion(170706,1707,"鹤山","hes",0)
		call addRegion(170707,1707,"恩平","enping",0)
		call addRegion(1708,17,"揭阳","heyang",1)
		call addRegion(170801,1708,"榕城","rongcheng",0)
		call addRegion(170802,1708,"揭东","jiedong",0)
		call addRegion(170803,1708,"揭西","jiexi",0)
		call addRegion(170804,1708,"惠来","huilai",0)
		call addRegion(170805,1708,"普宁","puning",0)
		call addRegion(1709,17,"茂名","maoming",1)
		call addRegion(170901,1709,"茂南","maonan",0)
		call addRegion(170902,1709,"茂港","maogang",0)
		call addRegion(170903,1709,"电白","dianbai",0)
		call addRegion(170904,1709,"高州","gaozhou",0)
		call addRegion(170905,1709,"化州","huazhou",0)
		call addRegion(170906,1709,"信宜","xinyi",0)
		call addRegion(1710,17,"梅江","meijiang",0)
		call addRegion(1711,17,"梅州","meizhou",1)
		call addRegion(171101,1711,"梅县","meixian",0)
		call addRegion(171102,1711,"大埔","dab",0)
		call addRegion(171103,1711,"丰顺","fengshun",0)
		call addRegion(171104,1711,"五华","wuhua",0)
		call addRegion(171105,1711,"平远","pingyuan",0)
		call addRegion(171106,1711,"蕉岭","jiaoling",0)
		call addRegion(171107,1711,"兴宁","xinning",0)
		call addRegion(1712,17,"清远","qingyuan",1)
		call addRegion(171201,1712,"清城","qingcheng",0)
		call addRegion(171202,1712,"佛冈","bigang",0)
		call addRegion(171203,1712,"阳山","yangshan",0)
		call addRegion(171204,1712,"连山","lianshan",0)
		call addRegion(171205,1712,"连南","liannan",0)
		call addRegion(171206,1712,"清新","qingxin",0)
		call addRegion(171207,1712,"英德","yingde",0)
		call addRegion(171208,1712,"连州","lianzhou",0)
		call addRegion(1713,17,"汕头","shantou",1)
		call addRegion(171301,1713,"龙湖","longhu",0)
		call addRegion(171302,1713,"金平","jinping",0)
		call addRegion(171303,1713,"濠江","haojiang",0)
		call addRegion(171304,1713,"潮阳","chaoy",0)
		call addRegion(171305,1713,"潮南","chaonan",0)
		call addRegion(171306,1713,"澄海","chenghai",0)
		call addRegion(171307,1713,"南澳","nanao",0)
		call addRegion(1714,17,"汕尾","shanwei",1)
		call addRegion(171401,1714,"城区","chengqu",0)
		call addRegion(171402,1714,"海丰","haifeng",0)
		call addRegion(171403,1714,"陆河","liuhe",0)
		call addRegion(171404,1714,"陆丰","liufeng",0)
		call addRegion(1715,17,"韶关","shaoguan",1)
		call addRegion(171501,1715,"武江","wujiangx",0)
		call addRegion(171502,1715,"浈江","chengjiang",0)
		call addRegion(171503,1715,"曲江","qujiang",0)
		call addRegion(171504,1715,"始兴","shixin",0)
		call addRegion(171505,1715,"仁化","renhua",0)
		call addRegion(171506,1715,"翁源","wengyuan",0)
		call addRegion(171507,1715,"乳源","ruyuan",0)
		call addRegion(171508,1715,"新丰","xinfeng",0)
		call addRegion(171509,1715,"乐昌","lechang",0)
		call addRegion(171510,1715,"南雄","nanxiong",0)
		call addRegion(1716,17,"深圳","shenchou",1)
		call addRegion(171601,1716,"罗湖","luohu",0)
		call addRegion(171602,1716,"福田","fut",0)
		call addRegion(171603,1716,"南山","nanshan",0)
		call addRegion(171604,1716,"宝安","baoan",0)
		call addRegion(171605,1716,"龙岗","longgang",0)
		call addRegion(171606,1716,"盐田","yantian",0)
		call addRegion(1717,17,"阳江","yangjiang",1)
		call addRegion(171701,1717,"江城","jiangcheng",0)
		call addRegion(171702,1717,"阳西","yangxi",0)
		call addRegion(171703,1717,"阳东","yangdong",0)
		call addRegion(171704,1717,"阳春","yangchun",0)
		call addRegion(1718,17,"云浮","yunfu",1)
		call addRegion(171801,1718,"云城","yunchengx",0)
		call addRegion(171802,1718,"新兴","xinxin",0)
		call addRegion(171803,1718,"郁南","yunan",0)
		call addRegion(171804,1718,"云安","yunanx",0)
		call addRegion(171805,1718,"罗定","luoding",0)
		call addRegion(1719,17,"湛江","chenjiang",1)
		call addRegion(171901,1719,"赤坎","chikan",0)
		call addRegion(171902,1719,"霞山","xiashan",0)
		call addRegion(171903,1719,"坡头","potou",0)
		call addRegion(171904,1719,"麻章","mazhang",0)
		call addRegion(171905,1719,"遂溪","suix",0)
		call addRegion(171906,1719,"徐闻","xuwen",0)
		call addRegion(171907,1719,"廉江","lianj",0)
		call addRegion(171908,1719,"雷州","leizhou",0)
		call addRegion(171909,1719,"吴川","wuchuan",0)
		call addRegion(1720,17,"肇庆","zhaoqiang",1)
		call addRegion(172001,1720,"端州","duanzhou",0)
		call addRegion(172002,1720,"鼎湖","dinghu",0)
		call addRegion(172003,1720,"广宁","guangning",0)
		call addRegion(172004,1720,"怀集","huaiji",0)
		call addRegion(172005,1720,"封开","fengkai",0)
		call addRegion(172006,1720,"德庆","deqiang",0)
		call addRegion(172007,1720,"高要","gaoyao",0)
		call addRegion(172008,1720,"四会","sihui",0)
		call addRegion(1721,17,"中山","zhongshan",0)
		call addRegion(1722,17,"珠海","zhuhai",1)
		call addRegion(172201,1722,"香洲","xiangzhou",0)
		call addRegion(172202,1722,"斗门","doumen",0)
		call addRegion(172203,1722,"金湾","jinwan",0)

		call addRegion(18,0,"广西","guangxi",1)
		call addRegion(1801,18,"南宁","nanning",1)
		call addRegion(180101,1801,"兴宁","xinn",0)
		call addRegion(180102,1801,"青秀","qingxiu",0)
		call addRegion(180103,1801,"江南","jiangnan",0)
		call addRegion(180104,1801,"西乡塘","xixiangtang",0)
		call addRegion(180105,1801,"良庆","liangqiang",0)
		call addRegion(180106,1801,"邕宁","yongning",0)
		call addRegion(180107,1801,"武鸣","wuming",0)
		call addRegion(180108,1801,"隆安","longan",0)
		call addRegion(180109,1801,"马山","mashan",0)
		call addRegion(180110,1801,"上林","shanglin",0)
		call addRegion(180111,1801,"宾阳","binyang",0)
		call addRegion(180112,1801,"横县","hengxian",0)
		call addRegion(1802,18,"百色","baise",1)
		call addRegion(180201,1802,"右江","youjiang",0)
		call addRegion(180202,1802,"田阳","tianyang",0)
		call addRegion(180203,1802,"田东","tiandong",0)
		call addRegion(180204,1802,"平果","pingguan",0)
		call addRegion(180205,1802,"德保","debao",0)
		call addRegion(180206,1802,"靖西","jingxi",0)
		call addRegion(180207,1802,"那坡","napo",0)
		call addRegion(180208,1802,"凌云","lingyun",0)
		call addRegion(180209,1802,"乐业","leye",0)
		call addRegion(180210,1802,"田林","tianlin",0)
		call addRegion(180211,1802,"西林","xilin",0)
		call addRegion(180212,1802,"隆林","longlin",0)
		call addRegion(1803,18,"北海","beihai",1)
		call addRegion(180301,1803,"海城","haicheng",0)
		call addRegion(180302,1803,"银海","yinhai",0)
		call addRegion(180303,1803,"铁山港","tieshangang",0)
		call addRegion(180304,1803,"合浦","gepu",0)
		call addRegion(1804,18,"崇左","chongzuo",1)
		call addRegion(180401,1804,"江洲","jiangzhou",0)
		call addRegion(180402,1804,"扶绥","furui",0)
		call addRegion(180403,1804,"宁明","ningmeng",0)
		call addRegion(180404,1804,"龙州","longzhou",0)
		call addRegion(180405,1804,"大新","daxin",0)
		call addRegion(180406,1804,"天等","tiandeng",0)
		call addRegion(180407,1804,"凭祥","pingxiangqu",0)
		call addRegion(1805,18,"防城港","fangchenggang",1)
		call addRegion(180501,1805,"港口","gangkou",0)
		call addRegion(180502,1805,"防城","fangcheng",0)
		call addRegion(180503,1805,"上思","shangsai",0)
		call addRegion(180504,1805,"东兴","dongxin",0)
		call addRegion(1806,18,"贵港","guigang",1)
		call addRegion(180601,1806,"港北","gangbei",0)
		call addRegion(180602,1806,"港南","gangnan",0)
		call addRegion(180603,1806,"覃塘","qintang",0)
		call addRegion(180604,1806,"平南","pingnanx",0)
		call addRegion(180605,1806,"桂平","guiping",0)
		call addRegion(1807,18,"桂林","guilin",1)
		call addRegion(180701,1807,"秀峰","xiufeng",0)
		call addRegion(180702,1807,"叠彩","diecai",0)
		call addRegion(180703,1807,"象山","xiangs",0)
		call addRegion(180704,1807,"七星","qixing",0)
		call addRegion(180705,1807,"雁山","yanshan",0)
		call addRegion(180706,1807,"阳朔","yangshuo",0)
		call addRegion(180707,1807,"临桂","lingui",0)
		call addRegion(180708,1807,"灵川","lingchuan",0)
		call addRegion(180709,1807,"全州","quanz",0)
		call addRegion(180710,1807,"兴安","xinan",0)
		call addRegion(180711,1807,"永福","yongfu",0)
		call addRegion(180712,1807,"灌阳","guanyang",0)
		call addRegion(180713,1807,"龙胜","longsheng",0)
		call addRegion(180714,1807,"资源","ziyuan",0)
		call addRegion(180715,1807,"平乐","pingle",0)
		call addRegion(180716,1807,"荔蒲","libo",0)
		call addRegion(180717,1807,"恭城","gongcheng",0)
		call addRegion(1808,18,"河池","heche",1)
		call addRegion(180801,1808,"金城江","jinchengjiang",0)
		call addRegion(180802,1808,"南丹","nandan",0)
		call addRegion(180803,1808,"天峨","tiane",0)
		call addRegion(180804,1808,"凤山","fengshan",0)
		call addRegion(180805,1808,"东兰","donglan",0)
		call addRegion(180806,1808,"罗城","luocheng",0)
		call addRegion(180807,1808,"环江","huanjiang",0)
		call addRegion(180808,1808,"巴马","bama",0)
		call addRegion(180809,1808,"都安","douan",0)
		call addRegion(180810,1808,"大化","dahua",0)
		call addRegion(180811,1808,"宜州","yizhou",0)
		call addRegion(1809,18,"贺州","hezhou",1)
		call addRegion(180901,1809,"八步","babu",0)
		call addRegion(180902,1809,"昭平","zhaoping",0)
		call addRegion(180903,1809,"钟山","zhongs",0)
		call addRegion(180904,1809,"富川","fuchuan",0)
		call addRegion(1810,18,"来宾","laibin",1)
		call addRegion(181001,1810,"兴宾","xinbin",0)
		call addRegion(181002,1810,"忻城","xincheng",0)
		call addRegion(181003,1810,"象州","xiangz",0)
		call addRegion(181004,1810,"武宣","wuxuan",0)
		call addRegion(181005,1810,"金秀","jinxiu",0)
		call addRegion(181006,1810,"合山","geshan",0)
		call addRegion(1811,18,"柳州","liuzhou",1)
		call addRegion(181101,1811,"城中","chengzhong",0)
		call addRegion(181102,1811,"鱼峰","yufeng",0)
		call addRegion(181103,1811,"柳南","liunan",0)
		call addRegion(181104,1811,"柳北","liubei",0)
		call addRegion(181105,1811,"柳江","liujiang",0)
		call addRegion(181106,1811,"柳城","liucheng",0)
		call addRegion(181107,1811,"鹿寨","luqian",0)
		call addRegion(181108,1811,"融安","rongan",0)
		call addRegion(181109,1811,"融水","rongshui",0)
		call addRegion(181110,1811,"三江","sanjiang",0)
		call addRegion(1812,18,"钦州","qinzhou",1)
		call addRegion(181201,1812,"钦南","qinnan",0)
		call addRegion(181202,1812,"钦北","qinbei",0)
		call addRegion(181203,1812,"灵山","lingshan",0)
		call addRegion(181204,1812,"浦北","pubei",0)
		call addRegion(1813,18,"梧州","wuzhou",1)
		call addRegion(181301,1813,"万秀","moxiu",0)
		call addRegion(181302,1813,"蝶山","dieshan",0)
		call addRegion(181303,1813,"长洲","changz",0)
		call addRegion(181304,1813,"苍梧","cangwu",0)
		call addRegion(181305,1813,"藤县","tengxian",0)
		call addRegion(181306,1813,"蒙山","mengshan",0)
		call addRegion(181307,1813,"岑溪","cenxi",0)
		call addRegion(1814,18,"玉林","yulins",1)
		call addRegion(181401,1814,"玉州","yuzhou",0)
		call addRegion(181402,1814,"容县","rongxian",0)
		call addRegion(181403,1814,"陆川","liuchuan",0)
		call addRegion(181404,1814,"博白","bobai",0)
		call addRegion(181405,1814,"兴业","xinye",0)
		call addRegion(181406,1814,"北流","beiliu",0)

		call addRegion(19,0,"贵州","guizhou",1)
		call addRegion(1901,19,"贵阳","guiyang",1)
		call addRegion(190101,1901,"南明","nanmeng",0)
		call addRegion(190102,1901,"云岩","yunyan",0)
		call addRegion(190103,1901,"花溪","huaxi",0)
		call addRegion(190104,1901,"乌当","wudang",0)
		call addRegion(190105,1901,"白云","baiy",0)
		call addRegion(190106,1901,"小河","xiaohe",0)
		call addRegion(190107,1901,"开阳","kaiyang",0)
		call addRegion(190108,1901,"息烽","xif",0)
		call addRegion(190109,1901,"修文","xiuwen",0)
		call addRegion(190110,1901,"清镇","qingzhen",0)
		call addRegion(1902,19,"安顺","anshun",1)
		call addRegion(190201,1902,"西秀","xixiu",0)
		call addRegion(190202,1902,"平坝","pingba",0)
		call addRegion(190203,1902,"普定","puding",0)
		call addRegion(190204,1902,"镇宁","zhenning",0)
		call addRegion(190205,1902,"关岭","guanling",0)
		call addRegion(190206,1902,"紫云","ziyun",0)
		call addRegion(1903,19,"毕节","bijie",1)
		call addRegion(190301,1903,"大方","dafang",0)
		call addRegion(190302,1903,"黔西","qianxi",0)
		call addRegion(190303,1903,"金沙","jinsha",0)
		call addRegion(190304,1903,"织金","zhijin",0)
		call addRegion(190305,1903,"纳雍","nayong",0)
		call addRegion(190306,1903,"威宁","weining",0)
		call addRegion(190307,1903,"赫章","hezhang",0)
		call addRegion(1904,19,"六盘水","liupanshui",1)
		call addRegion(190401,1904,"钟山","lpszs",0)
		call addRegion(190402,1904,"六枝","liuzhi",0)
		call addRegion(190403,1904,"水城","shuicheng",0)
		call addRegion(190404,1904,"盘县","panxian",0)
		call addRegion(1905,19,"黔东南","qiandongnan",1)
		call addRegion(190501,1905,"凯里","kaili",0)
		call addRegion(190502,1905,"黄平","huangping",0)
		call addRegion(190503,1905,"施秉","shibing",0)
		call addRegion(190504,1905,"三穗","sansui",0)
		call addRegion(190505,1905,"镇远","zhenyuanx",0)
		call addRegion(190506,1905,"岑巩","cengong",0)
		call addRegion(190507,1905,"天柱","tianzhu",0)
		call addRegion(190508,1905,"锦屏","jinpingx",0)
		call addRegion(190509,1905,"剑河","jianhe",0)
		call addRegion(190510,1905,"台江","taijiangx",0)
		call addRegion(190511,1905,"黎平","liping",0)
		call addRegion(190512,1905,"榕江","rongjiang",0)
		call addRegion(190513,1905,"从江","congjiang",0)
		call addRegion(190514,1905,"雷山","leishan",0)
		call addRegion(190515,1905,"麻江","majiang",0)
		call addRegion(190516,1905,"丹寨","danqian",0)
		call addRegion(1906,19,"黔南","qiannan",1)
		call addRegion(190601,1906,"都匀","doujun",0)
		call addRegion(190602,1906,"福泉","fuquan",0)
		call addRegion(190603,1906,"荔波","libei",0)
		call addRegion(190604,1906,"贵定","guiding",0)
		call addRegion(190605,1906,"瓮安","wengan",0)
		call addRegion(190606,1906,"独山","dushan",0)
		call addRegion(190607,1906,"平塘","pingtang",0)
		call addRegion(190608,1906,"罗甸","luodian",0)
		call addRegion(190609,1906,"长顺","changshun",0)
		call addRegion(190610,1906,"龙里","longli",0)
		call addRegion(190611,1906,"惠水","huishui",0)
		call addRegion(190612,1906,"三都","sandou",0)
		call addRegion(1907,19,"黔西南","qianxinan",1)
		call addRegion(190701,1907,"兴义","xinyiq",0)
		call addRegion(190702,1907,"兴仁","xinren",0)
		call addRegion(190703,1907,"普安","puan",0)
		call addRegion(190704,1907,"晴隆","qinglong",0)
		call addRegion(190705,1907,"贞丰","zhenfeng",0)
		call addRegion(190706,1907,"望谟","wangmo",0)
		call addRegion(190707,1907,"册亨","ceheng",0)
		call addRegion(190708,1907,"安龙","anlong",0)
		call addRegion(1908,19,"铜仁","tongren",1)
		call addRegion(190801,1908,"江口","jiangkou",0)
		call addRegion(190802,1908,"玉屏","yuping",0)
		call addRegion(190803,1908,"石阡","shiqian",0)
		call addRegion(190804,1908,"思南","sainan",0)
		call addRegion(190805,1908,"印江","yijiang",0)
		call addRegion(190806,1908,"德江","dejiang",0)
		call addRegion(190807,1908,"沿河","yanhe",0)
		call addRegion(190808,1908,"松桃","songtao",0)
		call addRegion(190809,1908,"万山","moshan",0)
		call addRegion(1909,19,"遵义","zunyi",1)
		call addRegion(190901,1909,"红花岗","honghuagang",0)
		call addRegion(190902,1909,"汇川","huichuan",0)
		call addRegion(190903,1909,"桐梓","tongzi",0)
		call addRegion(190904,1909,"绥阳","ruiyang",0)
		call addRegion(190905,1909,"正安","zhengan",0)
		call addRegion(190906,1909,"道真","daozhen",0)
		call addRegion(190907,1909,"务川","wuchuanx",0)
		call addRegion(190908,1909,"凤冈","fenggang",0)
		call addRegion(190909,1909,"湄潭","meitan",0)
		call addRegion(190910,1909,"余庆","tuqiang",0)
		call addRegion(190911,1909,"习水","xishui",0)
		call addRegion(190912,1909,"赤水","chishui",0)
		call addRegion(190913,1909,"仁怀","renhuai",0)

		call addRegion(20,0,"海南","hainan",1)
		call addRegion(2001,20,"海口","haikou",1)
		call addRegion(200101,2001,"秀英","xiuying",0)
		call addRegion(200102,2001,"龙华","longhua",0)
		call addRegion(200103,2001,"琼山","qiongshan",0)
		call addRegion(200104,2001,"美兰","meilan",0)
		call addRegion(2002,20,"白沙","baisha",0)
		call addRegion(2003,20,"保亭","baoting",0)
		call addRegion(2004,20,"昌江","changjiang",0)
		call addRegion(2005,20,"澄迈","chengmai",0)
		call addRegion(2006,20,"儋州","danzhou",0)
		call addRegion(2007,20,"定安","dingan",0)
		call addRegion(2008,20,"东方","dongfang",0)
		call addRegion(2009,20,"乐东","ledong",0)
		call addRegion(2010,20,"临高","lingao",0)
		call addRegion(2011,20,"陵水","lingshui",0)
		call addRegion(2012,20,"琼海","qionghai",0)
		call addRegion(2013,20,"琼中","qiongzhong",0)
		call addRegion(2014,20,"三亚","sane",0)
		call addRegion(2015,20,"屯昌","tunchang",0)
		call addRegion(2016,20,"万宁","moning",0)
		call addRegion(2017,20,"文昌","wenchang",0)
		call addRegion(2018,20,"五指山","wuzhishan",0)

		call addRegion(21,0,"河北","hebei",1)
		call addRegion(2101,21,"石家庄","shijiapeng",1)
		call addRegion(210101,2101,"长安","changan",0)
		call addRegion(210102,2101,"桥东","qiaodong",0)
		call addRegion(210103,2101,"桥西","qiaoxi",0)
		call addRegion(210104,2101,"新华","xinhuaqu",0)
		call addRegion(210105,2101,"井陉矿","jingjingkuang",0)
		call addRegion(210106,2101,"裕华","yuhua",0)
		call addRegion(210107,2101,"井陉","jingjing",0)
		call addRegion(210108,2101,"正定","zhengding",0)
		call addRegion(210109,2101,"栾城","luancheng",0)
		call addRegion(210110,2101,"行唐","hangtang",0)
		call addRegion(210111,2101,"灵寿","lingshou",0)
		call addRegion(210112,2101,"高邑","gaoyi",0)
		call addRegion(210113,2101,"深泽","shenze",0)
		call addRegion(210114,2101,"赞皇","zanhuang",0)
		call addRegion(210115,2101,"无极","moji",0)
		call addRegion(210116,2101,"平山","pingshan",0)
		call addRegion(210117,2101,"元氏","yuanjing",0)
		call addRegion(210118,2101,"赵县","diaoxian",0)
		call addRegion(210119,2101,"辛集","xinji",0)
		call addRegion(210120,2101,"藁城","gaocheng",0)
		call addRegion(210121,2101,"晋州","jinzhou",0)
		call addRegion(210122,2101,"新乐","xinle",0)
		call addRegion(210123,2101,"鹿泉","luquan",0)
		call addRegion(2102,21,"保定","baoding",1)
		call addRegion(210201,2102,"新市","xinshi",0)
		call addRegion(210202,2102,"北市","beishi",0)
		call addRegion(210203,2102,"南市","nanshi",0)
		call addRegion(210204,2102,"满城","mancheng",0)
		call addRegion(210205,2102,"清苑","qingyu",0)
		call addRegion(210206,2102,"涞水","laishui",0)
		call addRegion(210207,2102,"阜平","fuping",0)
		call addRegion(210208,2102,"徐水","xushui",0)
		call addRegion(210209,2102,"定兴","dingxin",0)
		call addRegion(210210,2102,"唐县","tangxian",0)
		call addRegion(210211,2102,"高阳","gaoyang",0)
		call addRegion(210212,2102,"容城","rongc",0)
		call addRegion(210213,2102,"涞源","laiyuan",0)
		call addRegion(210214,2102,"望都","wangdou",0)
		call addRegion(210215,2102,"安新","anxin",0)
		call addRegion(210216,2102,"易县","yix",0)
		call addRegion(210217,2102,"曲阳","quyang",0)
		call addRegion(210218,2102,"蠡县","lix",0)
		call addRegion(210219,2102,"顺平","shunping",0)
		call addRegion(210220,2102,"博野","boshu",0)
		call addRegion(210221,2102,"雄县","xiongxian",0)
		call addRegion(210222,2102,"涿州","zhuozhou",0)
		call addRegion(210223,2102,"定州","dingzhou",0)
		call addRegion(210224,2102,"安国","anguo",0)
		call addRegion(210225,2102,"高碑店","gaobeidian",0)
		call addRegion(2103,21,"沧州","cangzhou",1)
		call addRegion(210301,2103,"新华","xinh",0)
		call addRegion(210302,2103,"运河","yunhe",0)
		call addRegion(210303,2103,"沧县","cangxian",0)
		call addRegion(210304,2103,"青县","qingxian",0)
		call addRegion(210305,2103,"东光","dongguang",0)
		call addRegion(210306,2103,"海兴","haixin",0)
		call addRegion(210307,2103,"盐山","yans",0)
		call addRegion(210308,2103,"肃宁","suning",0)
		call addRegion(210309,2103,"南皮","nanpi",0)
		call addRegion(210310,2103,"吴桥","wuqiao",0)
		call addRegion(210311,2103,"献县","xianxian",0)
		call addRegion(210312,2103,"孟村","mengcun",0)
		call addRegion(210313,2103,"泊头","botou",0)
		call addRegion(210314,2103,"任丘","renqiu",0)
		call addRegion(210315,2103,"黄骅","huanghua",0)
		call addRegion(210316,2103,"河间","hejian",0)
		call addRegion(2104,21,"承德","chengde",1)
		call addRegion(210401,2104,"双桥","shuangq",0)
		call addRegion(210402,2104,"双滦","shuangluan",0)
		call addRegion(210403,2104,"鹰手营子矿","ysyzk",0)
		call addRegion(210404,2104,"兴隆","xinlong",0)
		call addRegion(210405,2104,"平泉","pingquan",0)
		call addRegion(210406,2104,"滦平","luanping",0)
		call addRegion(210407,2104,"隆化","longh",0)
		call addRegion(210408,2104,"丰宁","fengning",0)
		call addRegion(210409,2104,"宽城","kuancheng",0)
		call addRegion(210410,2104,"围场","weichang",0)
		call addRegion(2105,21,"邯郸","handan",1)
		call addRegion(210501,2105,"邯山","hans",0)
		call addRegion(210502,2105,"丛台","congtai",0)
		call addRegion(210503,2105,"复兴","bixin",0)
		call addRegion(210504,2105,"峰峰矿","fengfengkuang",0)
		call addRegion(210505,2105,"临漳","linzhang",0)
		call addRegion(210506,2105,"成安","chengan",0)
		call addRegion(210507,2105,"大名","daming",0)
		call addRegion(210508,2105,"涉县","diexian",0)
		call addRegion(210509,2105,"磁县","cixian",0)
		call addRegion(210510,2105,"肥乡","feixiang",0)
		call addRegion(210511,2105,"永年","yongnian",0)
		call addRegion(210512,2105,"邱县","qiuxian",0)
		call addRegion(210513,2105,"鸡泽","jize",0)
		call addRegion(210514,2105,"广平","guangping",0)
		call addRegion(210515,2105,"馆陶","guandao",0)
		call addRegion(210516,2105,"魏县","weixian",0)
		call addRegion(210517,2105,"曲周","quzhoux",0)
		call addRegion(210518,2105,"武安","wuan",0)
		call addRegion(2106,21,"衡水","hengshui",1)
		call addRegion(210601,2106,"桃城","taocheng",0)
		call addRegion(210602,2106,"枣强","zaoqiang",0)
		call addRegion(210603,2106,"武邑","wuyi",0)
		call addRegion(210604,2106,"武强","wuqiang",0)
		call addRegion(210605,2106,"饶阳","raoyang",0)
		call addRegion(210606,2106,"安平","anping",0)
		call addRegion(210607,2106,"故城","gucheng",0)
		call addRegion(210608,2106,"景县","jingx",0)
		call addRegion(210609,2106,"阜城","fucheng",0)
		call addRegion(210610,2106,"冀州","jiz",0)
		call addRegion(210611,2106,"深州","shenzhou",0)
		call addRegion(2107,21,"廊坊","langfang",1)
		call addRegion(210701,2107,"安次","anci",0)
		call addRegion(210702,2107,"广阳","guangyang",0)
		call addRegion(210703,2107,"固安","guan",0)
		call addRegion(210704,2107,"永清","yongqing",0)
		call addRegion(210705,2107,"香河","xianghe",0)
		call addRegion(210706,2107,"大城","dacheng",0)
		call addRegion(210707,2107,"文安","wenan",0)
		call addRegion(210708,2107,"大厂","dachang",0)
		call addRegion(210709,2107,"霸州","bazhou",0)
		call addRegion(210710,2107,"三河","sanhe",0)
		call addRegion(2108,21,"秦皇岛","qinhuangdao",1)
		call addRegion(210801,2108,"海港","haigang",0)
		call addRegion(210802,2108,"山海关","shanhaiguan",0)
		call addRegion(210803,2108,"北戴河","beidaihe",0)
		call addRegion(210804,2108,"青龙","qinglongx",0)
		call addRegion(210805,2108,"昌黎","changli",0)
		call addRegion(210806,2108,"抚宁","fun",0)
		call addRegion(210807,2108,"卢龙","leilong",0)
		call addRegion(2109,21,"唐山","tangshan",1)
		call addRegion(210901,2109,"路南","lunan",0)
		call addRegion(210902,2109,"路北","lubei",0)
		call addRegion(210903,2109,"古冶","guye",0)
		call addRegion(210904,2109,"开平","kaipingx",0)
		call addRegion(210905,2109,"丰南","fengnan",0)
		call addRegion(210906,2109,"丰润","fengrun",0)
		call addRegion(210907,2109,"滦县","luanxian",0)
		call addRegion(210908,2109,"滦南","luannan",0)
		call addRegion(210909,2109,"乐亭","leting",0)
		call addRegion(210910,2109,"迁西","qianx",0)
		call addRegion(210911,2109,"玉田","yutian",0)
		call addRegion(210912,2109,"唐海","tanghai",0)
		call addRegion(210913,2109,"遵化","zunhua",0)
		call addRegion(210914,2109,"迁安","qianan",0)
		call addRegion(2110,21,"邢台","xingtai",1)
		call addRegion(211001,2110,"桥东","qiaodongx",0)
		call addRegion(211002,2110,"桥西","qiaoxix",0)
		call addRegion(211003,2110,"临城","lincheng",0)
		call addRegion(211004,2110,"内丘","neiqiu",0)
		call addRegion(211005,2110,"柏乡","baixiang",0)
		call addRegion(211006,2110,"隆尧","longyao",0)
		call addRegion(211007,2110,"任县","renxian",0)
		call addRegion(211008,2110,"南和","nanhe",0)
		call addRegion(211009,2110,"宁晋","ningjin",0)
		call addRegion(211010,2110,"巨鹿","julu",0)
		call addRegion(211011,2110,"新河","xinhe",0)
		call addRegion(211012,2110,"广宗","guangzong",0)
		call addRegion(211013,2110,"平乡","pingxiangx",0)
		call addRegion(211014,2110,"威县","weix",0)
		call addRegion(211015,2110,"清河","qinghe",0)
		call addRegion(211016,2110,"临西","linxi",0)
		call addRegion(211017,2110,"南宫","nangong",0)
		call addRegion(211018,2110,"沙河","shahe",0)
		call addRegion(2111,21,"张家口","zhangjiakou",1)
		call addRegion(211101,2111,"桥东","qdong",0)
		call addRegion(211102,2111,"桥西","qiaox",0)
		call addRegion(211103,2111,"宣化","xuanhua",0)
		call addRegion(211104,2111,"下花园","xiahuawan",0)
		call addRegion(211105,2111,"宣化","xuanh",0)
		call addRegion(211106,2111,"张北","zhangbei",0)
		call addRegion(211107,2111,"康保","kangbao",0)
		call addRegion(211108,2111,"沽源","guyuanx",0)
		call addRegion(211109,2111,"尚义","changyi",0)
		call addRegion(211110,2111,"蔚县","wxian",0)
		call addRegion(211111,2111,"阳原","yangyuan",0)
		call addRegion(211112,2111,"怀安","huaianx",0)
		call addRegion(211113,2111,"万全","moquan",0)
		call addRegion(211114,2111,"怀来","huailai",0)
		call addRegion(211115,2111,"涿鹿","zhuolu",0)
		call addRegion(211116,2111,"赤城","chicheng",0)
		call addRegion(211117,2111,"崇礼","chongli",0)

		call addRegion(22,0,"河南","henan",1)
		call addRegion(2201,22,"郑州","zhengzhou",1)
		call addRegion(220101,2201,"中原","zhongyuan",0)
		call addRegion(220102,2201,"二七","erqi",0)
		call addRegion(220103,2201,"管城","guancheng",0)
		call addRegion(220104,2201,"金水","jinshui",0)
		call addRegion(220105,2201,"上街","shangjie",0)
		call addRegion(220106,2201,"邙山","mangshan",0)
		call addRegion(220107,2201,"中牟","zhongmao",0)
		call addRegion(220108,2201,"巩义","gongyi",0)
		call addRegion(220109,2201,"荥阳","xingyang",0)
		call addRegion(220110,2201,"新密","xinmi",0)
		call addRegion(220111,2201,"新郑","xinzheng",0)
		call addRegion(220112,2201,"登封","defeng",0)
		call addRegion(2202,22,"安阳","ayang",1)
		call addRegion(220201,2202,"文峰","wenfeng",0)
		call addRegion(220202,2202,"北关","beiguan",0)
		call addRegion(220203,2202,"殷都","yandou",0)
		call addRegion(220204,2202,"龙安","longa",0)
		call addRegion(220205,2202,"汤阴","tangyin",0)
		call addRegion(220206,2202,"滑县","guxian",0)
		call addRegion(220207,2202,"内黄","neihuang",0)
		call addRegion(220208,2202,"林州","linzhou",0)
		call addRegion(2203,22,"鹤壁","hebi",1)
		call addRegion(220301,2203,"鹤山","hshan",0)
		call addRegion(220302,2203,"山城","shancheng",0)
		call addRegion(220303,2203,"淇滨","qibin",0)
		call addRegion(220304,2203,"浚县","cunxian",0)
		call addRegion(220305,2203,"淇县","qixian",0)
		call addRegion(2204,22,"济源","jiyuan",0)
		call addRegion(2205,22,"焦作","jiaozuo",1)
		call addRegion(220501,2205,"解放","jiefang",0)
		call addRegion(220502,2205,"中站","zhongzhan",0)
		call addRegion(220503,2205,"马村","macun",0)
		call addRegion(220504,2205,"山阳","shanyang",0)
		call addRegion(220505,2205,"修武","xiuwu",0)
		call addRegion(220506,2205,"博爱","boai",0)
		call addRegion(220507,2205,"武陟","wude",0)
		call addRegion(220508,2205,"温县","jzwenxian",0)
		call addRegion(220509,2205,"济源","jyuan",0)
		call addRegion(220510,2205,"沁阳市","qinyangshi",0)
		call addRegion(220511,2205,"孟州","mengzhou",0)
		call addRegion(2206,22,"开封","kaifeng",1)
		call addRegion(220601,2206,"龙亭","longting",0)
		call addRegion(220602,2206,"顺河","shunhe",0)
		call addRegion(220603,2206,"鼓楼","glou",0)
		call addRegion(220604,2206,"南关","nanguan",0)
		call addRegion(220605,2206,"郊区","jiaoqu",0)
		call addRegion(220606,2206,"杞县","qxian",0)
		call addRegion(220607,2206,"通许","tongxu",0)
		call addRegion(220608,2206,"尉氏","weijing",0)
		call addRegion(220609,2206,"兰考","lankao",0)
		call addRegion(2207,22,"洛阳","luoyang",1)
		call addRegion(220701,2207,"老城","laocheng",0)
		call addRegion(220702,2207,"西工","xigong",0)
		call addRegion(220703,2207,"廛河","chanhe",0)
		call addRegion(220704,2207,"涧西","jianxi",0)
		call addRegion(220705,2207,"吉利","jili",0)
		call addRegion(220706,2207,"洛龙","luolong",0)
		call addRegion(220707,2207,"孟津","mengjin",0)
		call addRegion(220708,2207,"新安","xina",0)
		call addRegion(220709,2207,"栾川","luanchuan",0)
		call addRegion(220710,2207,"嵩县","songxian",0)
		call addRegion(220711,2207,"汝阳","ruyang",0)
		call addRegion(220712,2207,"宜阳","yiyang",0)
		call addRegion(220713,2207,"洛宁","luoning",0)
		call addRegion(220714,2207,"伊川","yichuan",0)
		call addRegion(220715,2207,"偃师","yanshi",0)
		call addRegion(2208,22,"漯河","leihe",1)
		call addRegion(220801,2208,"源汇","yuanhui",0)
		call addRegion(220802,2208,"郾城","yanchengqu",0)
		call addRegion(220803,2208,"召陵","shaoling",0)
		call addRegion(220804,2208,"舞阳","wuyang",0)
		call addRegion(220805,2208,"临颍","linying",0)
		call addRegion(2209,22,"南阳","nanyang",1)
		call addRegion(220901,2209,"宛城","wancheng",0)
		call addRegion(220902,2209,"卧龙","wolong",0)
		call addRegion(220903,2209,"南召","nanshao",0)
		call addRegion(220904,2209,"方城","fcheng",0)
		call addRegion(220905,2209,"西峡","xixia",0)
		call addRegion(220906,2209,"镇平","zhenping",0)
		call addRegion(220907,2209,"内乡","neixiang",0)
		call addRegion(220908,2209,"淅川","xichuan",0)
		call addRegion(220909,2209,"社旗","sheqi",0)
		call addRegion(220910,2209,"唐河","tanghe",0)
		call addRegion(220911,2209,"新野","xinshu",0)
		call addRegion(220912,2209,"桐柏","tongbai",0)
		call addRegion(220913,2209,"邓州","dengzhou",0)
		call addRegion(2210,22,"平顶山","pingdingshan",0)
		call addRegion(221001,2210,"新华","xhua",0)
		call addRegion(221002,2210,"卫东","weidong",0)
		call addRegion(221003,2210,"石龙","shilong",0)
		call addRegion(221004,2210,"湛河","chenhe",0)
		call addRegion(221005,2210,"宝丰","baofeng",0)
		call addRegion(221006,2210,"叶县","xiexian",0)
		call addRegion(221007,2210,"鲁山","lushan",0)
		call addRegion(221008,2210,"郏县","jiaxian",0)
		call addRegion(221009,2210,"舞钢","wugang",0)
		call addRegion(221010,2210,"汝州","ruzhou",0)
		call addRegion(2211,22,"濮阳","puyang",1)
		call addRegion(221101,2211,"华龙","hualong",0)
		call addRegion(221102,2211,"清丰","qingfeng",0)
		call addRegion(221103,2211,"南乐","nanle",0)
		call addRegion(221104,2211,"范县","fanxian",0)
		call addRegion(221105,2211,"台前","taijian",0)
		call addRegion(221106,2211,"濮阳","pyang",0)
		call addRegion(2212,22,"三门峡","sanmenxia",1)
		call addRegion(221201,2212,"湖滨","hubin",0)
		call addRegion(221202,2212,"渑池","mianche",0)
		call addRegion(221203,2212,"陕县","shanxian",0)
		call addRegion(221204,2212,"卢氏","leijing",0)
		call addRegion(221205,2212,"义马","yima",0)
		call addRegion(221206,2212,"灵宝","lingbao",0)
		call addRegion(2213,22,"商丘","shangqiu",1)
		call addRegion(221301,2213,"梁园","liangwan",0)
		call addRegion(221302,2213,"睢阳","suiyang",0)
		call addRegion(221303,2213,"民权","minquan",0)
		call addRegion(221304,2213,"睢县","suixian",0)
		call addRegion(221305,2213,"宁陵","ningling",0)
		call addRegion(221306,2213,"柘城","zhecheng",0)
		call addRegion(221307,2213,"虞城","yucheng",0)
		call addRegion(221308,2213,"夏邑","xiayi",0)
		call addRegion(221309,2213,"永城","yongcheng",0)
		call addRegion(2214,22,"新乡","xinxiang",1)
		call addRegion(221401,2214,"红旗","hongqi",0)
		call addRegion(221402,2214,"卫滨","weibin",0)
		call addRegion(221403,2214,"凤泉","fengquan",0)
		call addRegion(221404,2214,"牧野","mushu",0)
		call addRegion(221405,2214,"获嘉","huojia",0)
		call addRegion(221406,2214,"原阳","yuanyang",0)
		call addRegion(221407,2214,"延津","yanjin",0)
		call addRegion(221408,2214,"封丘","fengqiu",0)
		call addRegion(221409,2214,"长垣","changyuan",0)
		call addRegion(221410,2214,"卫辉","weihui",0)
		call addRegion(221411,2214,"辉县","huix",0)
		call addRegion(2215,22,"信阳","xinyang",1)
		call addRegion(221501,2215,"师河","shihe",0)
		call addRegion(221502,2215,"平桥","pingqiao",0)
		call addRegion(221503,2215,"罗山","luoshan",0)
		call addRegion(221504,2215,"光山","guangshan",0)
		call addRegion(221505,2215,"新县","xinxian",0)
		call addRegion(221506,2215,"商城","shangcheng",0)
		call addRegion(221507,2215,"固始","gushi",0)
		call addRegion(221508,2215,"潢川","guangchuan",0)
		call addRegion(221509,2215,"淮滨","huaibin",0)
		call addRegion(221510,2215,"息县","xixian",0)
		call addRegion(2216,22,"许昌","xuchang",1)
		call addRegion(221601,2216,"魏都","weidou",0)
		call addRegion(221602,2216,"鄢陵","yanling",0)
		call addRegion(221603,2216,"襄城","xcxiangcheng",0)
		call addRegion(221604,2216,"禹州","yzhou",0)
		call addRegion(221605,2216,"长葛","changge",0)
		call addRegion(2217,22,"周口","zhoukou",1)
		call addRegion(221701,2217,"川汇","chuanhui",0)
		call addRegion(221702,2217,"扶沟","fugou",0)
		call addRegion(221703,2217,"西华","xihua",0)
		call addRegion(221704,2217,"商水","shangshui",0)
		call addRegion(221705,2217,"沈丘","chenqiu",0)
		call addRegion(221706,2217,"郸城","dancheng",0)
		call addRegion(221707,2217,"淮阳","huaiyang",0)
		call addRegion(221708,2217,"太康","taikang",0)
		call addRegion(221709,2217,"鹿邑","luyi",0)
		call addRegion(221710,2217,"项城","xiangc",0)
		call addRegion(2218,22,"驻马店","zhumadian",1)
		call addRegion(221801,2218,"驿城","yicheng",0)
		call addRegion(221802,2218,"西平","xiping",0)
		call addRegion(221803,2218,"上蔡","shangca",0)
		call addRegion(221804,2218,"平舆","pingyu",0)
		call addRegion(221805,2218,"正阳","zhengyang",0)
		call addRegion(221806,2218,"确山","queshan",0)
		call addRegion(221807,2218,"泌阳","biyang",0)
		call addRegion(221808,2218,"汝南","runan",0)
		call addRegion(221809,2218,"遂平","suiping",0)
		call addRegion(221810,2218,"新蔡","xinca",0)

		call addRegion(23,0,"黑龙江","heilongjiang",1)
		call addRegion(2301,23,"哈尔滨","haerbin",1)
		call addRegion(230101,2301,"道里","daoli",0)
		call addRegion(230102,2301,"南岗","nangang",0)
		call addRegion(230103,2301,"道外","daowai",0)
		call addRegion(230104,2301,"香坊","xiangfang",0)
		call addRegion(230105,2301,"动力","dongl",0)
		call addRegion(230106,2301,"平房","pingfang",0)
		call addRegion(230107,2301,"松北","songbei",0)
		call addRegion(230108,2301,"呼兰","helan",0)
		call addRegion(230109,2301,"依兰","yilan",0)
		call addRegion(230110,2301,"方正","fangzheng",0)
		call addRegion(230111,2301,"宾县","binxian",0)
		call addRegion(230112,2301,"巴彦","bapan",0)
		call addRegion(230113,2301,"木兰","mulan",0)
		call addRegion(230114,2301,"通河","tonghe",0)
		call addRegion(230115,2301,"延寿","yanshou",0)
		call addRegion(230116,2301,"阿城","acheng",0)
		call addRegion(230117,2301,"双城","shuangcheng",0)
		call addRegion(230118,2301,"尚志","changzhi",0)
		call addRegion(230119,2301,"五常","wuchang",0)
		call addRegion(2302,23,"大庆","daqiang",1)
		call addRegion(230201,2302,"萨尔图","saertu",0)
		call addRegion(230202,2302,"龙凤","longfeng",0)
		call addRegion(230203,2302,"让胡路","ranghulu",0)
		call addRegion(230204,2302,"红岗","honggang",0)
		call addRegion(230205,2302,"大同","dtong",0)
		call addRegion(230206,2302,"肇州","zhaozhou",0)
		call addRegion(230207,2302,"肇源","zhaoyuan",0)
		call addRegion(230208,2302,"林甸","lindian",0)
		call addRegion(230209,2302,"杜尔伯特","debt",0)
		call addRegion(2303,23,"大兴安岭","dxal",1)
		call addRegion(230301,2303,"呼玛","hema",0)
		call addRegion(230302,2303,"塔河","tahe",0)
		call addRegion(230303,2303,"漠河","mohe",0)
		call addRegion(2304,23,"鹤岗","hegang",1)
		call addRegion(230401,2304,"向阳","xiangyang",0)
		call addRegion(230402,2304,"工农","gongnong",0)
		call addRegion(230403,2304,"南山","nanshanx",0)
		call addRegion(230404,2304,"兴安","xan",0)
		call addRegion(230405,2304,"东山","dongs",0)
		call addRegion(230406,2304,"兴山","xinshan",0)
		call addRegion(230407,2304,"萝北","luobei",0)
		call addRegion(230408,2304,"绥滨","ruibin",0)
		call addRegion(2305,23,"黑河","heihe",1)
		call addRegion(230501,2305,"爱辉","aihui",0)
		call addRegion(230502,2305,"嫩江","nenjiang",0)
		call addRegion(230503,2305,"逊克","xunke",0)
		call addRegion(230504,2305,"孙吴","sunwu",0)
		call addRegion(230505,2305,"北安","beian",0)
		call addRegion(230506,2305,"五大连池","wdlc",0)
		call addRegion(2306,24,"鸡西","jix",1)
		call addRegion(230601,2306,"鸡冠","jiguan",0)
		call addRegion(230602,2306,"恒山","hengshan",0)
		call addRegion(230603,2306,"滴道","didao",0)
		call addRegion(230604,2306,"梨树","lishu",0)
		call addRegion(230605,2306,"城子河","chengzihe",0)
		call addRegion(230606,2306,"麻山","mshan",0)
		call addRegion(230607,2306,"鸡东","jidong",0)
		call addRegion(230608,2306,"虎林","hulin",0)
		call addRegion(230609,2306,"密山","mishan",0)
		call addRegion(2307,23,"佳木斯","jiamushi",1)
		call addRegion(230701,2307,"永红","yonghong",0)
		call addRegion(230702,2307,"向阳","xyang",0)
		call addRegion(230703,2307,"前进","jianjin",0)
		call addRegion(230704,2307,"东风","dongfeng",0)
		call addRegion(230705,2307,"郊区","jmsjq",0)
		call addRegion(230706,2307,"桦南","huanan",0)
		call addRegion(230707,2307,"桦川","huachuan",0)
		call addRegion(230708,2307,"汤原","tangyuan",0)
		call addRegion(230709,2307,"抚远","fyuan",0)
		call addRegion(230710,2307,"同江","tongjiang",0)
		call addRegion(230711,2307,"富锦","fujin",0)
		call addRegion(2308,23,"牡丹江","mudanjiang",1)
		call addRegion(230801,2308,"东安","dongan",0)
		call addRegion(230802,2308,"阳明","yangmeng",0)
		call addRegion(230803,2308,"爱民","aimin",0)
		call addRegion(230804,2308,"西安","mdjxa",0)
		call addRegion(230805,2308,"东宁","dongning",0)
		call addRegion(230806,2308,"林口","linkou",0)
		call addRegion(230807,2308,"绥芬河","ruifenhe",0)
		call addRegion(230808,2308,"海林","hailin",0)
		call addRegion(230809,2308,"宁安","ningan",0)
		call addRegion(230810,2308,"穆棱","muling",0)
		call addRegion(2309,23,"七台河","qitaihe",1)
		call addRegion(230901,2309,"新兴","xxin",0)
		call addRegion(230902,2309,"桃山","taoshan",0)
		call addRegion(230903,2309,"茄子河","jiazihe",0)
		call addRegion(230904,2309,"勃利","boli",0)
		call addRegion(2310,23,"齐齐哈尔","qqhe",1)
		call addRegion(231001,2310,"龙沙","longsha",0)
		call addRegion(231002,2310,"建华","jianhua",0)
		call addRegion(231003,2310,"铁锋","tiefeng",0)
		call addRegion(231004,2310,"昂昂溪","angangxi",0)
		call addRegion(231005,2310,"富拉尔基","flej",0)
		call addRegion(231006,2310,"碾子山","nianzishan",0)
		call addRegion(231007,2310,"梅里斯达斡尔族","mlsdwez",0)
		call addRegion(231008,2310,"龙江","longjiang",0)
		call addRegion(231009,2310,"依安","yian",0)
		call addRegion(231010,2310,"泰来","tailai",0)
		call addRegion(231011,2310,"甘南","gannanx",0)
		call addRegion(231012,2310,"富裕","fuyu",0)
		call addRegion(231013,2310,"克山","keshan",0)
		call addRegion(231014,2310,"克东","kedong",0)
		call addRegion(231015,2310,"拜泉","baiquan",0)
		call addRegion(231016,2310,"讷河","nehe",0)
		call addRegion(2311,23,"双鸭山","shuangyashan",1)
		call addRegion(231101,2311,"尖山","jianshan",0)
		call addRegion(231102,2311,"岭东","lingdong",0)
		call addRegion(231103,2311,"四方台","sifangtai",0)
		call addRegion(231104,2311,"宝山","bshan",0)
		call addRegion(231105,2311,"集贤","jixian",0)
		call addRegion(231106,2311,"友谊","youyi",0)
		call addRegion(231107,2311,"宝清","baoqing",0)
		call addRegion(231108,2311,"饶河","raohe",0)
		call addRegion(2312,23,"绥化","ruihua",1)
		call addRegion(231201,2312,"北林","beilin",0)
		call addRegion(231202,2312,"望奎","wangkui",0)
		call addRegion(231203,2312,"兰西","lanxi",0)
		call addRegion(231204,2312,"青冈","qinggang",0)
		call addRegion(231205,2312,"庆安","qiangan",0)
		call addRegion(231206,2312,"明水","mengshui",0)
		call addRegion(231207,2312,"绥棱","ruiling",0)
		call addRegion(231208,2312,"安达","anda",0)
		call addRegion(231209,2312,"肇东","zhaodong",0)
		call addRegion(231210,2312,"海伦","hailun",0)
		call addRegion(2313,23,"伊春","yichunshi",1)
		call addRegion(231301,2313,"南岔","nancha",0)
		call addRegion(231302,2313,"友好","youhao",0)
		call addRegion(231303,2313,"西林","xlin",0)
		call addRegion(231304,2313,"翠峦","cuiluan",0)
		call addRegion(231305,2313,"新青","xinqing",0)
		call addRegion(231306,2313,"美溪","meixi",0)
		call addRegion(231307,2313,"金山屯","jinshantun",0)
		call addRegion(231308,2313,"五营","wuying",0)
		call addRegion(231309,2313,"乌马河","wumahe",0)
		call addRegion(231310,2313,"汤旺河","tangwanghe",0)
		call addRegion(231311,2313,"带岭","dailing",0)
		call addRegion(231312,2313,"乌伊岭","wuyiling",0)
		call addRegion(231313,2313,"红星","hongxing",0)
		call addRegion(231314,2313,"上甘岭","shangganling",0)
		call addRegion(231315,2313,"嘉荫","jiayin",0)
		call addRegion(231316,2313,"铁力","tieli",0)

		call addRegion(24,0,"湖北","hubei",1)
		call addRegion(2401,24,"武汉","wuhan",1)
		call addRegion(240101,2401,"江岸","jiangan",0)
		call addRegion(240102,2401,"江汉","jianghan",0)
		call addRegion(240103,2401,"乔口","jiaokou",0)
		call addRegion(240104,2401,"汉阳","hanyang",0)
		call addRegion(240105,2401,"武昌","wuc",0)
		call addRegion(240106,2401,"青山","qingshan",0)
		call addRegion(240107,2401,"洪山","hongshan",0)
		call addRegion(240108,2401,"东西湖","dongxihu",0)
		call addRegion(240109,2401,"汉南","hannan",0)
		call addRegion(240110,2401,"蔡甸","cadian",0)
		call addRegion(240111,2401,"江夏","jiangxia",0)
		call addRegion(240112,2401,"黄陂","huangbei",0)
		call addRegion(240113,2401,"新洲","xinzhoux",0)
		call addRegion(2402,24,"鄂州","ezhou",1)
		call addRegion(240201,2402,"梁子湖","liangzihu",0)
		call addRegion(240202,2402,"华容","huarong",0)
		call addRegion(240203,2402,"鄂城","echeng",0)
		call addRegion(2403,24,"恩施","enshi",1)
		call addRegion(240301,2403,"利川","lichuan",0)
		call addRegion(240302,2403,"建始","jianshi",0)
		call addRegion(240303,2403,"巴东","badong",0)
		call addRegion(240304,2403,"宣恩","xuanen",0)
		call addRegion(240305,2403,"咸丰","xianfeng",0)
		call addRegion(240306,2403,"来凤","laifeng",0)
		call addRegion(240307,2403,"鹤峰","hefeng",0)
		call addRegion(2404,24,"黄冈","huanggang",1)
		call addRegion(240401,2404,"黄州","huangzhou",0)
		call addRegion(240402,2404,"团风","qiufeng",0)
		call addRegion(240403,2404,"红安","hongan",0)
		call addRegion(240404,2404,"罗田","luotian",0)
		call addRegion(240405,2404,"英山","yingshan",0)
		call addRegion(240406,2404,"浠水","xshui",0)
		call addRegion(240407,2404,"蕲春","jichun",0)
		call addRegion(240408,2404,"黄梅","huangmei",0)
		call addRegion(240409,2404,"麻城","macheng",0)
		call addRegion(240410,2404,"武穴","wujue",0)
		call addRegion(2405,24,"黄石","huangshi",1)
		call addRegion(240501,2405,"黄石港","huangshigang",0)
		call addRegion(240502,2405,"西塞","xisai",0)
		call addRegion(240503,2405,"下陆","xialiu",0)
		call addRegion(240504,2405,"铁山","tieshan",0)
		call addRegion(240505,2405,"阳新","yangxin",0)
		call addRegion(240506,2405,"大冶","daye",0)
		call addRegion(2406,24,"荆门","jingmen",1)
		call addRegion(240601,2406,"东宝","dongbao",0)
		call addRegion(240602,2406,"掇刀","duodao",0)
		call addRegion(240603,2406,"京山","jings",0)
		call addRegion(240604,2406,"沙洋","shaxiang",0)
		call addRegion(240605,2406,"钟祥","zhongxiang",0)
		call addRegion(2407,24,"荆州","jingzhou",1)
		call addRegion(240701,2407,"沙市","shashi",0)
		call addRegion(240702,2407,"荆州","jingz",0)
		call addRegion(240703,2407,"公安","gonga",0)
		call addRegion(240704,2407,"监利","jianli",0)
		call addRegion(240705,2407,"江陵","jiangling",0)
		call addRegion(240706,2407,"石首","shishou",0)
		call addRegion(240707,2407,"洪湖","honghu",0)
		call addRegion(240708,2407,"松滋","songci",0)
		call addRegion(2408,24,"潜江","qianj",0)
		call addRegion(2409,24,"神农架林","snjl",0)
		call addRegion(2410,24,"十堰","shiyan",1)
		call addRegion(241001,2410,"茅箭","maojian",0)
		call addRegion(241002,2410,"张湾","zhangwan",0)
		call addRegion(241003,2410,"郧县","yunxian",0)
		call addRegion(241004,2410,"郧西","yunxi",0)
		call addRegion(241005,2410,"竹山","zhushan",0)
		call addRegion(241006,2410,"竹溪","zhuxi",0)
		call addRegion(241007,2410,"房县","fangxian",0)
		call addRegion(241008,2410,"丹江口","danjiangkou",0)
		call addRegion(2411,24,"随州","suizhou",1)
		call addRegion(241101,2411,"曾都","cengdou",0)
		call addRegion(241102,2411,"广水","guangshui",0)
		call addRegion(2412,24,"天门","tianmen",0)
		call addRegion(2413,24,"仙桃","xiantao",0)
		call addRegion(2414,24,"咸宁","xianning",1)
		call addRegion(241401,2414,"咸安","xianan",0)
		call addRegion(241402,2414,"嘉鱼","jiayu",0)
		call addRegion(241403,2414,"通城","tongchengx",0)
		call addRegion(241404,2414,"崇阳","chongyang",0)
		call addRegion(241405,2414,"通山","tongshan",0)
		call addRegion(241406,2414,"赤壁","chibi",0)
		call addRegion(2415,24,"襄樊","xiangfan",1)
		call addRegion(241501,2415,"襄城","xfxc",0)
		call addRegion(241502,2415,"樊城","fancheng",0)
		call addRegion(241503,2415,"襄阳","xiangy",0)
		call addRegion(241504,2415,"南漳","nanzhang",0)
		call addRegion(241505,2415,"谷城","gcheng",0)
		call addRegion(241506,2415,"保康","baokang",0)
		call addRegion(241507,2415,"老河口","laohekou",0)
		call addRegion(241508,2415,"枣阳","zaoyang",0)
		call addRegion(241509,2415,"宜城","ycheng",0)
		call addRegion(2416,24,"孝感","xiaogan",1)
		call addRegion(241601,2416,"孝南","xiaonan",0)
		call addRegion(241602,2416,"孝昌","xiaochang",0)
		call addRegion(241603,2416,"大悟","dawu",0)
		call addRegion(241604,2416,"云梦","yunmeng",0)
		call addRegion(241605,2416,"应城","yingcheng",0)
		call addRegion(241606,2416,"安陆","anliu",0)
		call addRegion(241607,2416,"汉川","hanchuan",0)
		call addRegion(2417,24,"宜昌","yichang",1)
		call addRegion(241701,2417,"西陵","xiling",0)
		call addRegion(241702,2417,"伍家岗","wujiagang",0)
		call addRegion(241703,2417,"点军","dianjun",0)
		call addRegion(241704,2417,"猇亭","xiaoting",0)
		call addRegion(241705,2417,"夷陵","yiling",0)
		call addRegion(241706,2417,"远安","yuanan",0)
		call addRegion(241707,2417,"兴山","xins",0)
		call addRegion(241708,2417,"秭归","zigui",0)
		call addRegion(241709,2417,"长阳","changyang",0)
		call addRegion(241710,2417,"五峰","wufeng",0)
		call addRegion(241711,2417,"宜都","yidou",0)
		call addRegion(241712,2417,"当阳","dangyang",0)
		call addRegion(241713,2417,"枝江","zhijiang",0)

		call addRegion(25,0,"湖南","hunan",1)
		call addRegion(2501,25,"长沙","changsha",1)
		call addRegion(250101,2501,"芙蓉","furong",0)
		call addRegion(250102,2501,"天心","tianxin",0)
		call addRegion(250103,2501,"岳麓","yuelu",0)
		call addRegion(250104,2501,"开福","kaifu",0)
		call addRegion(250105,2501,"雨花","yhua",0)
		call addRegion(250106,2501,"望城","wangcheng",0)
		call addRegion(250107,2501,"宁乡","ningxiang",0)
		call addRegion(250108,2501,"浏阳","liuyang",0)
		call addRegion(2502,25,"常德","changde",1)
		call addRegion(250201,2502,"武陵区","wulingqu",0)
		call addRegion(250202,2502,"鼎城区","dingchengqu",0)
		call addRegion(250203,2502,"安乡县","anxiangxian",0)
		call addRegion(250204,2502,"汉寿县","hanshouxian",0)
		call addRegion(250205,2502,"澧县","lxian",0)
		call addRegion(250206,2502,"临澧县","linlixian",0)
		call addRegion(250207,2502,"桃源县","taoyuanxian",0)
		call addRegion(250208,2502,"石门县","shimenxian",0)
		call addRegion(250209,2502,"津市市","jinshishi",0)
		call addRegion(2503,25,"郴州","chenzhou",1)
		call addRegion(250301,2503,"北湖","beihu",0)
		call addRegion(250302,2503,"苏仙","suxian",0)
		call addRegion(250303,2503,"桂阳","guiy",0)
		call addRegion(250304,2503,"宜章","yizhang",0)
		call addRegion(250305,2503,"永兴","yongxin",0)
		call addRegion(250306,2503,"嘉禾","jiah",0)
		call addRegion(250307,2503,"临武","linwu",0)
		call addRegion(250308,2503,"汝城","rucheng",0)
		call addRegion(250309,2503,"桂东","guidong",0)
		call addRegion(250310,2503,"安仁","anren",0)
		call addRegion(250311,2503,"资兴","zixin",0)
		call addRegion(2504,25,"衡阳","hengyang",1)
		call addRegion(250401,2504,"珠晖","zhuhui",0)
		call addRegion(250402,2504,"雁峰","yanfeng",0)
		call addRegion(250403,2504,"石鼓","shigu",0)
		call addRegion(250404,2504,"蒸湘","zhengxiang",0)
		call addRegion(250405,2504,"南岳","nanyue",0)
		call addRegion(250406,2504,"衡阳","hengy",0)
		call addRegion(250407,2504,"衡南","hengnan",0)
		call addRegion(250408,2504,"衡山","hengs",0)
		call addRegion(250409,2504,"衡东","hengdong",0)
		call addRegion(250410,2504,"祁东","qidongx",0)
		call addRegion(250411,2504,"耒阳","leiyang",0)
		call addRegion(250412,2504,"常宁","changn",0)
		call addRegion(2505,25,"怀化","huaihua",1)
		call addRegion(250501,2505,"鹤城","hecheng",0)
		call addRegion(250502,2505,"中方","zhongfang",0)
		call addRegion(250503,2505,"沅陵","yuanling",0)
		call addRegion(250504,2505,"辰溪","chenxi",0)
		call addRegion(250505,2505,"溆浦","xupu",0)
		call addRegion(250506,2505,"会同","huitong",0)
		call addRegion(250507,2505,"麻阳","mayang",0)
		call addRegion(250508,2505,"新晃","xinhuang",0)
		call addRegion(250509,2505,"芷江","zhijiangx",0)
		call addRegion(250510,2505,"靖州","jzhou",0)
		call addRegion(250511,2505,"通道","tongdao",0)
		call addRegion(250512,2505,"洪江","hongjiang",0)
		call addRegion(2506,25,"娄底","loude",1)
		call addRegion(250601,2506,"娄星","louxing",0)
		call addRegion(250602,2506,"双峰","shuangfeng",0)
		call addRegion(250603,2506,"新化","xinhuax",0)
		call addRegion(250604,2506,"冷水江","lingshuijiang",0)
		call addRegion(250605,2506,"涟源","lanyuan",0)
		call addRegion(2507,25,"邵阳","shaoyang",1)
		call addRegion(250701,2507,"双清","shuangqing",0)
		call addRegion(250702,2507,"大祥","daxiang",0)
		call addRegion(250703,2507,"北塔","beita",0)
		call addRegion(250704,2507,"邵东","shaodong",0)
		call addRegion(250705,2507,"新邵","xinshao",0)
		call addRegion(250706,2507,"邵阳","shaoy",0)
		call addRegion(250707,2507,"隆回","longhui",0)
		call addRegion(250708,2507,"洞口","dongkou",0)
		call addRegion(250709,2507,"绥宁","ruining",0)
		call addRegion(250710,2507,"新宁","xinningx",0)
		call addRegion(250711,2507,"城步","chengbu",0)
		call addRegion(250712,2507,"武冈","wgang",0)
		call addRegion(2508,25,"湘潭","xiangtan",1)
		call addRegion(250801,2508,"雨湖","yuhu",0)
		call addRegion(250802,2508,"岳塘","yuetang",0)
		call addRegion(250803,2508,"湘乡","xiangxiang",0)
		call addRegion(250804,2508,"韶山","shaoshan",0)
		call addRegion(2509,25,"湘西","xiangxi",1)
		call addRegion(250901,2509,"吉首","jishou",0)
		call addRegion(250902,2509,"泸溪","luxi",0)
		call addRegion(250903,2509,"凤凰","fenghuang",0)
		call addRegion(250904,2509,"花垣","huayuan",0)
		call addRegion(250905,2509,"保靖","baojing",0)
		call addRegion(250906,2509,"古丈","guzhang",0)
		call addRegion(250907,2509,"永顺","yongshun",0)
		call addRegion(250908,2509,"龙山","longshan",0)
		call addRegion(2510,25,"益阳","yiyangshi",1)
		call addRegion(251001,2510,"资阳","yyzy",0)
		call addRegion(251002,2510,"赫山","heshanx",0)
		call addRegion(251003,2510,"南县","nanxian",0)
		call addRegion(251004,2510,"桃江","taojiang",0)
		call addRegion(251005,2510,"安化","anhua",0)
		call addRegion(251006,2510,"沅江","yuanjiang",0)
		call addRegion(2511,25,"永州","yongzhou",1)
		call addRegion(251101,2511,"芝山","zhishan",0)
		call addRegion(251102,2511,"冷水滩","lingshuihan",0)
		call addRegion(251103,2511,"祁阳","qiyang",0)
		call addRegion(251104,2511,"东安","donganx",0)
		call addRegion(251105,2511,"双牌","shuangpai",0)
		call addRegion(251106,2511,"道县","daoxian",0)
		call addRegion(251107,2511,"江永","jiangyong",0)
		call addRegion(251108,2511,"宁远","ningyuan",0)
		call addRegion(251109,2511,"蓝山","lashan",0)
		call addRegion(251110,2511,"新田","xintian",0)
		call addRegion(251111,2511,"江华","jianghua",0)
		call addRegion(2512,25,"岳阳","yueyang",1)
		call addRegion(251201,2512,"岳阳楼","yueyanglou",0)
		call addRegion(251202,2512,"云溪","yunxix",0)
		call addRegion(251203,2512,"君山","junshan",0)
		call addRegion(251205,2512,"华容","hrong",0)
		call addRegion(251206,2512,"湘阴","xiangyin",0)
		call addRegion(251207,2512,"平江","pingjiang",0)
		call addRegion(251208,2512,"汨罗","miluo",0)
		call addRegion(251209,2512,"临湘","linxiang",0)
		call addRegion(2513,25,"张家界","zhangjiajie",1)
		call addRegion(251301,2513,"永定","yding",0)
		call addRegion(251302,2513,"武陵源","wulingyuan",0)
		call addRegion(251303,2513,"慈利","cili",0)
		call addRegion(251304,2513,"桑植","sangzhi",0)
		call addRegion(2514,25,"株洲","zhuzhou",1)
		call addRegion(251401,2514,"荷塘","hetang",0)
		call addRegion(251402,2514,"芦淞","husong",0)
		call addRegion(251403,2514,"石峰","shifeng",0)
		call addRegion(251404,2514,"天元","tiany",0)
		call addRegion(251405,2514,"株洲","zzhou",0)
		call addRegion(251406,2514,"攸县","youxian",0)
		call addRegion(251407,2514,"茶陵","chaling",0)
		call addRegion(251408,2514,"炎陵","tanling",0)
		call addRegion(251409,2514,"醴陵","liling",0)

		call addRegion(26,0,"吉林","jilin",1)
		call addRegion(2601,26,"长春","changchun",1)
		call addRegion(260101,2601,"南关","nanguans",0)
		call addRegion(260102,2601,"宽城","kcheng",0)
		call addRegion(260103,2601,"朝阳","chaoyangx",0)
		call addRegion(260104,2601,"二道","erdao",0)
		call addRegion(260105,2601,"绿园","luwanx",0)
		call addRegion(260106,2601,"双阳","shuangyang",0)
		call addRegion(260107,2601,"农安","nongan",0)
		call addRegion(260108,2601,"九台","jiutai",0)
		call addRegion(260109,2601,"榆树","yushux",0)
		call addRegion(260110,2601,"德惠","dehui",0)
		call addRegion(2602,26,"白城","baicheng",1)
		call addRegion(260201,2602,"洮北","daobei",0)
		call addRegion(260202,2602,"镇赉","zhenlai",0)
		call addRegion(260203,2602,"通榆","tongyu",0)
		call addRegion(260204,2602,"洮南","daonan",0)
		call addRegion(260205,2602,"大安","bcdaan",0)
		call addRegion(2603,26,"白山","baishan",1)
		call addRegion(260301,2603,"八道江","badaojiang",0)
		call addRegion(260302,2603,"抚松","fusong",0)
		call addRegion(260303,2603,"靖宇","jingyu",0)
		call addRegion(260304,2603,"长白","changbai",0)
		call addRegion(260305,2603,"江源","jiangyuan",0)
		call addRegion(260306,2603,"临江","linjiang",0)
		call addRegion(2604,26,"吉林市","jilinshi",1)
		call addRegion(260401,2604,"昌邑","changyiq",0)
		call addRegion(260402,2604,"龙潭","longtan",0)
		call addRegion(260403,2604,"船营","chuanying",0)
		call addRegion(260404,2604,"丰满","fengman",0)
		call addRegion(260405,2604,"永吉","yongji",0)
		call addRegion(260406,2604,"蛟河","jiaohe",0)
		call addRegion(260407,2604,"桦甸","huadian",0)
		call addRegion(260408,2604,"舒兰","shulan",0)
		call addRegion(260409,2604,"磐石","panshi",0)
		call addRegion(2605,26,"辽源","liaoyuan",1)
		call addRegion(260501,2605,"龙山","longshanqu",0)
		call addRegion(260502,2605,"西安","lyxa",0)
		call addRegion(260503,2605,"东丰","dongfengx",0)
		call addRegion(260504,2605,"东辽","dongliao",0)
		call addRegion(2606,26,"四平","siping",1)
		call addRegion(260601,2606,"铁西","tiexi",0)
		call addRegion(260602,2606,"铁东","tiedong",0)
		call addRegion(260603,2606,"梨树","lishuqu",0)
		call addRegion(260604,2606,"伊通","yitong",0)
		call addRegion(260605,2606,"公主岭","gongzhuling",0)
		call addRegion(260606,2606,"双辽","shuangliao",0)
		call addRegion(2607,26,"松原","songyuan",1)
		call addRegion(260701,2607,"宁江","ningjiang",0)
		call addRegion(260702,2607,"前郭尔罗斯","qgels",0)
		call addRegion(260703,2607,"长岭","changling",0)
		call addRegion(260704,2607,"乾安","qiananx",0)
		call addRegion(260705,2607,"扶余","futu",0)
		call addRegion(2608,26,"通化","tonghua",1)
		call addRegion(260801,2608,"东昌","dongchang",0)
		call addRegion(260802,2608,"二道江","erdaojiang",0)
		call addRegion(260803,2608,"辉南","huinan",0)
		call addRegion(260804,2608,"柳河","liuheq",0)
		call addRegion(260805,2608,"梅河口","meihekou",0)
		call addRegion(260806,2608,"集安","jian",0)
		call addRegion(2609,26,"延边","yanbian",1)
		call addRegion(260901,2609,"延吉","yanji",0)
		call addRegion(260902,2609,"图们","tumen",0)
		call addRegion(260903,2609,"敦化","duihua",0)
		call addRegion(260904,2609,"珲春","huichun",0)
		call addRegion(260905,2609,"龙井","longjing",0)
		call addRegion(260906,2609,"和龙","helong",0)
		call addRegion(260907,2609,"汪清","hongqing",0)
		call addRegion(260908,2609,"安图","antu",0)

		call addRegion(27,0,"江苏","jiangsu",1)
		call addRegion(2701,27,"南京","nanjing",1)
		call addRegion(270101,2701,"玄武","xuanwuqu",0)
		call addRegion(270102,2701,"白下","baixia",0)
		call addRegion(270103,2701,"秦淮","qinhuai",0)
		call addRegion(270104,2701,"建邺","jianqiu",0)
		call addRegion(270105,2701,"鼓楼","gulou",0)
		call addRegion(270106,2701,"下关","xiaguan",0)
		call addRegion(270107,2701,"浦口","pukou",0)
		call addRegion(270108,2701,"栖霞","qixia",0)
		call addRegion(270109,2701,"雨花台","yuhuatai",0)
		call addRegion(270110,2701,"江宁","jiangning",0)
		call addRegion(270111,2701,"六合","liuge",0)
		call addRegion(270112,2701,"溧水","lishui",0)
		call addRegion(270113,2701,"高淳","gaochun",0)
		call addRegion(2702,27,"常州","changzhou",1)
		call addRegion(270201,2702,"天宁","tning",0)
		call addRegion(270202,2702,"钟楼","zhonglou",0)
		call addRegion(270203,2702,"戚墅堰","cushuyan",0)
		call addRegion(270204,2702,"新北","xinbei",0)
		call addRegion(270205,2702,"武进","wujin",0)
		call addRegion(270206,2702,"溧阳","liyang",0)
		call addRegion(270207,2702,"金坛","jindan",0)
		call addRegion(2703,27,"淮安","huaian",1)
		call addRegion(270301,2703,"清河","qingh",0)
		call addRegion(270302,2703,"楚州","czhou",0)
		call addRegion(270303,2703,"淮阴","huaiyin",0)
		call addRegion(270304,2703,"清浦","qingpux",0)
		call addRegion(270305,2703,"涟水","lanshui",0)
		call addRegion(270306,2703,"洪泽","hongze",0)
		call addRegion(270307,2703,"盱眙","xuchi",0)
		call addRegion(270308,2703,"金湖","jinhu",0)
		call addRegion(2704,27,"连云港","lianyungang",1)
		call addRegion(270401,2704,"连云","lianyun",0)
		call addRegion(270402,2704,"新浦","xinpu",0)
		call addRegion(270403,2704,"海州","haizhou",0)
		call addRegion(270404,2704,"赣榆","ganyu",0)
		call addRegion(270405,2704,"东海","donghai",0)
		call addRegion(270406,2704,"灌云","guanyun",0)
		call addRegion(270406,2704,"灌南","guannan",0)
		call addRegion(2705,27,"南通","nantong",1)
		call addRegion(270501,2705,"崇川","chongchuan",0)
		call addRegion(270502,2705,"港闸","gangge",0)
		call addRegion(270503,2705,"海安","haian",0)
		call addRegion(270504,2705,"如东","rudong",0)
		call addRegion(270505,2705,"启东","qidong",0)
		call addRegion(270506,2705,"如皋","rugao",0)
		call addRegion(270507,2705,"通州","tongzhous",0)
		call addRegion(270508,2705,"海门","haimen",0)
		call addRegion(2706,27,"苏州","suzhou",1)
		call addRegion(270601,2706,"沧浪","canglang",0)
		call addRegion(270602,2706,"平江","pingjiangqu",0)
		call addRegion(270603,2706,"金阊","jinchangqu",0)
		call addRegion(270604,2706,"虎丘","huqiu",0)
		call addRegion(270605,2706,"吴中","wuzhong",0)
		call addRegion(270606,2706,"相城","xiangchengqu",0)
		call addRegion(270607,2706,"常熟","changshou",0)
		call addRegion(270608,2706,"张家港","zhangjiagang",0)
		call addRegion(270609,2706,"昆山","kunshan",0)
		call addRegion(270610,2706,"吴江","wujiang",0)
		call addRegion(270611,2706,"太仓","taicang",0)
		call addRegion(2707,27,"宿迁","qiqian",1)
		call addRegion(270701,2707,"宿城","qicheng",0)
		call addRegion(270702,2707,"宿豫","qishu",0)
		call addRegion(270703,2707,"沭阳","shuyang",0)
		call addRegion(270704,2707,"泗阳","siyang",0)
		call addRegion(270705,2707,"泗洪","sihong",0)
		call addRegion(2708,27,"泰州","taizhou",1)
		call addRegion(270801,2708,"海陵","hailing",0)
		call addRegion(270802,2708,"高港","gaogang",0)
		call addRegion(270803,2708,"兴化","xinhua",0)
		call addRegion(270804,2708,"靖江","jingjiang",0)
		call addRegion(270805,2708,"泰兴","taixin",0)
		call addRegion(270806,2708,"姜堰","jiangyan",0)
		call addRegion(2709,27,"无锡","moti",1)
		call addRegion(270901,2709,"崇安","chongan",0)
		call addRegion(270902,2709,"南长","nanc",0)
		call addRegion(270903,2709,"北塘","beitang",0)
		call addRegion(270904,2709,"锡山","tishan",0)
		call addRegion(270905,2709,"惠山","huishan",0)
		call addRegion(270906,2709,"滨湖","binhu",0)
		call addRegion(270907,2709,"江阴","jiangyin",0)
		call addRegion(270908,2709,"宜兴","yixin",0)
		call addRegion(2710,27,"徐州","xuzhou",1)
		call addRegion(271001,2710,"鼓楼","gulo",0)
		call addRegion(271002,2710,"云龙","yunlong",0)
		call addRegion(271003,2710,"九里","jiuli",0)
		call addRegion(271004,2710,"贾汪","guhong",0)
		call addRegion(271005,2710,"泉山","quanshan",0)
		call addRegion(271006,2710,"丰县","fxian",0)
		call addRegion(271007,2710,"沛县","peixian",0)
		call addRegion(271008,2710,"铜山","tshan",0)
		call addRegion(271009,2710,"睢宁","sning",0)
		call addRegion(271010,2710,"新沂","xinyix",0)
		call addRegion(271011,2710,"邳州","pizhou",0)
		call addRegion(2711,27,"盐城","yancheng",1)
		call addRegion(271101,2711,"亭湖","tinghu",0)
		call addRegion(271102,2711,"盐都","yandouqu",0)
		call addRegion(271103,2711,"响水","xiangshui",0)
		call addRegion(271104,2711,"滨海","binhai",0)
		call addRegion(271105,2711,"阜宁","funingqu",0)
		call addRegion(271106,2711,"射阳","sheyang",0)
		call addRegion(271107,2711,"建湖","jianhu",0)
		call addRegion(271108,2711,"东台","dongtai",0)
		call addRegion(271109,2711,"大丰","dafeng",0)
		call addRegion(2712,27,"扬州","yangzhou",1)
		call addRegion(271201,2712,"广陵","guangling",0)
		call addRegion(271202,2712,"邗江","hanjiangqu",0)
		call addRegion(271203,2712,"宝应","baoying",0)
		call addRegion(271204,2712,"仪征","yizheng",0)
		call addRegion(271205,2712,"高邮","gaoyou",0)
		call addRegion(271206,2712,"江都","jiangdou",0)
		call addRegion(2713,27,"镇江","zhenjiang",1)
		call addRegion(271301,2713,"京口","jingkou",0)
		call addRegion(271302,2713,"润州","runzhou",0)
		call addRegion(271303,2713,"丹徒","dantu",0)
		call addRegion(271304,2713,"丹阳","danyang",0)
		call addRegion(271305,2713,"扬中","yangzhong",0)
		call addRegion(271306,2713,"句容","gourong",0)

		call addRegion(28,0,"江西","jiangxi",1)
		call addRegion(2801,28,"南昌","nachang",1)
		call addRegion(280101,2801,"东湖","donghu",0)
		call addRegion(280102,2801,"西湖","xihu",0)
		call addRegion(280103,2801,"青云谱","qingyunpu",0)
		call addRegion(280104,2801,"湾里","wanli",0)
		call addRegion(280105,2801,"青山湖","qingshanhu",0)
		call addRegion(280106,2801,"新建","xinjian",0)
		call addRegion(280107,2801,"安义","anyix",0)
		call addRegion(280108,2801,"进贤","jinxian",0)
		call addRegion(2802,28,"抚州","fuzhou",1)
		call addRegion(280201,2802,"临川","linchuan",0)
		call addRegion(280202,2802,"南城","nancheng",0)
		call addRegion(280203,2802,"黎川","lichuanx",0)
		call addRegion(280204,2802,"南丰","nanfeng",0)
		call addRegion(280205,2802,"崇仁","chongren",0)
		call addRegion(280206,2802,"乐安","lean",0)
		call addRegion(280207,2802,"宜黄","yihuang",0)
		call addRegion(280208,2802,"金溪","jinxi",0)
		call addRegion(280209,2802,"资溪","zixi",0)
		call addRegion(280210,2802,"东乡","dongxiangx",0)
		call addRegion(280211,2802,"广昌","guangchang",0)
		call addRegion(2803,28,"赣州","ganzhou",1)
		call addRegion(280301,2803,"章贡","zhanggong",0)
		call addRegion(280302,2803,"赣县","ganxian",0)
		call addRegion(280303,2803,"信丰","xinfengx",0)
		call addRegion(280304,2803,"大余","datu",0)
		call addRegion(280305,2803,"上犹","shangyou",0)
		call addRegion(280306,2803,"崇义","chongyi",0)
		call addRegion(280307,2803,"安远","anyuan",0)
		call addRegion(280308,2803,"龙南","longnaqu",0)
		call addRegion(280309,2803,"定南","dingnan",0)
		call addRegion(280310,2803,"全南","quannan",0)
		call addRegion(280311,2803,"宁都","ningdou",0)
		call addRegion(280312,2803,"于都","xudou",0)
		call addRegion(280313,2803,"兴国","xinguo",0)
		call addRegion(280314,2803,"会昌","huichang",0)
		call addRegion(280315,2803,"寻乌","xinwuqu",0)
		call addRegion(280316,2803,"石城","shicheng",0)
		call addRegion(280317,2803,"瑞金","ruijin",0)
		call addRegion(280318,2803,"南康","nankang",0)
		call addRegion(2804,28,"吉安","jians",1)
		call addRegion(280401,2804,"吉州","jizhoux",0)
		call addRegion(280402,2804,"青原","qingyuanx",0)
		call addRegion(280404,2804,"吉水","jishui",0)
		call addRegion(280405,2804,"峡江","xiajiang",0)
		call addRegion(280406,2804,"新干","xingan",0)
		call addRegion(280407,2804,"永丰","yongfeng",0)
		call addRegion(280408,2804,"泰和","taihex",0)
		call addRegion(280409,2804,"遂川","suichuan",0)
		call addRegion(280410,2804,"万安","moan",0)
		call addRegion(280411,2804,"安福","anfu",0)
		call addRegion(280412,2804,"永新","yongxinx",0)
		call addRegion(280413,2804,"井冈山","jinggangshan",0)
		call addRegion(2805,28,"景德镇","jingdezhen",1)
		call addRegion(280501,2805,"昌江","changj",0)
		call addRegion(280502,2805,"珠山","zhushanx",0)
		call addRegion(280503,2805,"浮梁","fuliang",0)
		call addRegion(280504,2805,"乐平","leping",0)
		call addRegion(2806,28,"九江","jiujiang",1)
		call addRegion(280601,2806,"庐山","lushanx",0)
		call addRegion(280602,2806,"浔阳","xunyang",0)
		call addRegion(280603,2806,"武宁","wuning",0)
		call addRegion(280604,2806,"修水","xiushui",0)
		call addRegion(280605,2806,"永修","yongxiu",0)
		call addRegion(280606,2806,"德安","dean",0)
		call addRegion(280607,2806,"星子","xingzi",0)
		call addRegion(280608,2806,"都昌","douchang",0)
		call addRegion(280609,2806,"湖口","hukou",0)
		call addRegion(280610,2806,"彭泽","pengze",0)
		call addRegion(280611,2806,"瑞昌","ruichang",0)
		call addRegion(2807,28,"萍乡","pingxiang",1)
		call addRegion(280701,2807,"安源","anyuanx",0)
		call addRegion(280702,2807,"湘东","xiangdong",0)
		call addRegion(280703,2807,"莲花","lianhua",0)
		call addRegion(280704,2807,"上栗","shangli",0)
		call addRegion(280705,2807,"芦溪","huxi",0)
		call addRegion(2808,28,"上饶","shangrao",1)
		call addRegion(280801,2808,"信州","xinzhouq",0)
		call addRegion(280802,2808,"广丰","guangfeng",0)
		call addRegion(280803,2808,"玉山","yushanx",0)
		call addRegion(280804,2808,"铅山","qians",0)
		call addRegion(280805,2808,"横峰","hengfeng",0)
		call addRegion(280806,2808,"弋阳","yiyangs",0)
		call addRegion(280807,2808,"余干","tugan",0)
		call addRegion(280808,2808,"鄱阳","panyang",0)
		call addRegion(280809,2808,"万年","monian",0)
		call addRegion(280810,2808,"婺源","mouyuan",0)
		call addRegion(280811,2808,"德兴","dexin",0)
		call addRegion(2809,28,"新余","xintu",1)
		call addRegion(280901,2809,"渝水","yushui",0)
		call addRegion(280902,2809,"分宜","banyi",0)
		call addRegion(2810,28,"宜春","yichun",1)
		call addRegion(281001,2810,"袁州","yuanzhou",0)
		call addRegion(281002,2810,"奉新","fengxin",0)
		call addRegion(281003,2810,"万载","mozai",0)
		call addRegion(281004,2810,"上高","shanggao",0)
		call addRegion(281005,2810,"宜丰","yifeng",0)
		call addRegion(281006,2810,"靖安","jinganx",0)
		call addRegion(281007,2810,"铜鼓","tonggu",0)
		call addRegion(281008,2810,"丰城","fengcheng",0)
		call addRegion(281009,2810,"樟树","zhangshu",0)
		call addRegion(281010,2810,"高安","gaoan",0)
		call addRegion(2811,28,"鹰潭","yingtan",1)
		call addRegion(281101,2811,"月湖","ruhu",0)
		call addRegion(281102,2811,"余江","tujiang",0)
		call addRegion(281103,2811,"贵溪","guixi",0)

		call addRegion(29,0,"辽宁","liaoning",1)
		call addRegion(2901,29,"沈阳","chenyang",1)
		call addRegion(290101,2901,"和平","hebengx",0)
		call addRegion(290102,2901,"沈河","chenhex",0)
		call addRegion(290103,2901,"大东","dadong",0)
		call addRegion(290104,2901,"皇姑","huanggu",0)
		call addRegion(290105,2901,"铁西","tiexix",0)
		call addRegion(290106,2901,"苏家屯","sujiatun",0)
		call addRegion(290107,2901,"东陵","dongling",0)
		call addRegion(290108,2901,"新城子","xinchengzi",0)
		call addRegion(290109,2901,"于洪","xuhong",0)
		call addRegion(290110,2901,"辽中","liaozhong",0)
		call addRegion(290111,2901,"康平","kangping",0)
		call addRegion(290112,2901,"法库","faku",0)
		call addRegion(290113,2901,"新民","xinmin",0)
		call addRegion(2902,29,"鞍山","anshan",1)
		call addRegion(290201,2902,"铁东","tied",0)
		call addRegion(290202,2902,"铁西","tiex",0)
		call addRegion(290203,2902,"立山","lishan",0)
		call addRegion(290204,2902,"千山","qianshanx",0)
		call addRegion(290205,2902,"台安","taianx",0)
		call addRegion(290206,2902,"岫岩","xiuyan",0)
		call addRegion(290207,2902,"海城","haichengx",0)
		call addRegion(2903,29,"本溪","benxi",1)
		call addRegion(290301,2903,"平山","bxpingshan",0)
		call addRegion(290302,2903,"溪湖","xihux",0)
		call addRegion(290303,2903,"明山","mengshanx",0)
		call addRegion(290304,2903,"南芬","nanfen",0)
		call addRegion(290305,2903,"桓仁","huanren",0)
		call addRegion(2904,29,"朝阳","chaoyangs",1)
		call addRegion(290401,2904,"双塔","shuangta",0)
		call addRegion(290402,2904,"龙城","longcheng",0)
		call addRegion(290404,2904,"建平","jianping",0)
		call addRegion(290405,2904,"喀左","kazuo",0)
		call addRegion(290406,2904,"北票","beipiao",0)
		call addRegion(290407,2904,"凌源","lingyuan",0)
		call addRegion(2905,29,"大连","dalian",1)
		call addRegion(290501,2905,"中山","dlzhongshan",0)
		call addRegion(290502,2905,"西岗","xigang",0)
		call addRegion(290503,2905,"沙河口","shahekou",0)
		call addRegion(290504,2905,"甘井子","ganjingzi",0)
		call addRegion(290505,2905,"旅顺口","lvshunkou",0)
		call addRegion(290506,2905,"金州","jinzhoux",0)
		call addRegion(290507,2905,"长海","changhai",0)
		call addRegion(290508,2905,"瓦房店","wafangdian",0)
		call addRegion(290509,2905,"普兰店","pulandian",0)
		call addRegion(290510,2905,"庄河","penghe",0)
		call addRegion(2906,29,"丹东","dandong",1)
		call addRegion(290601,2906,"元宝","yuanbao",0)
		call addRegion(290602,2906,"振兴","zhenxin",0)
		call addRegion(290603,2906,"振安","zhenan",0)
		call addRegion(290604,2906,"宽甸","kuandian",0)
		call addRegion(290605,2906,"东港","donggang",0)
		call addRegion(290606,2906,"凤城","fengchengx",0)
		call addRegion(2907,29,"抚顺","fushun",1)
		call addRegion(290701,2907,"新抚","xinfuqu",0)
		call addRegion(290702,2907,"东洲","dongzhou",0)
		call addRegion(290703,2907,"望花","wanghua",0)
		call addRegion(290704,2907,"顺城","shuncheng",0)
		call addRegion(290705,2907,"新宾","xinbinx",0)
		call addRegion(290706,2907,"清原","qingy",0)
		call addRegion(2908,29,"阜新","fuxin",1)
		call addRegion(290801,2908,"海州","haizhoux",0)
		call addRegion(290802,2908,"新邱","xinqiu",0)
		call addRegion(290803,2908,"太平","taiping",0)
		call addRegion(290804,2908,"清河门","qinghemen",0)
		call addRegion(290805,2908,"细河","xihex",0)
		call addRegion(290806,2908,"彰武","zhangwu",0)
		call addRegion(2909,29,"葫芦岛","huhudao",1)
		call addRegion(290901,2909,"连山","lianshanx",0)
		call addRegion(290902,2909,"龙港","longgangx",0)
		call addRegion(290903,2909,"南票","nanpiao",0)
		call addRegion(290904,2909,"绥中","ruizhong",0)
		call addRegion(290905,2909,"建昌","jianchang",0)
		call addRegion(290906,2909,"兴城","xinchengx",0)
		call addRegion(2910,29,"锦州","jinzhous",1)
		call addRegion(291001,2910,"古塔","guta",0)
		call addRegion(291002,2910,"凌河","linghe",0)
		call addRegion(291003,2910,"太和","taihequ",0)
		call addRegion(291004,2910,"黑山","heishan",0)
		call addRegion(291005,2910,"义县","yxian",0)
		call addRegion(291006,2910,"凌海","linghai",0)
		call addRegion(291007,2910,"北宁","beining",0)
		call addRegion(2911,29,"辽阳","liaoyang",1)
		call addRegion(291101,2911,"白塔","baita",0)
		call addRegion(291102,2911,"文圣","wenku",0)
		call addRegion(291103,2911,"宏伟","hongwei",0)
		call addRegion(291104,2911,"弓长岭","gongchangling",0)
		call addRegion(291105,2911,"太子河","taizihe",0)
		call addRegion(291106,2911,"辽阳","liaoyangqu",0)
		call addRegion(291107,2911,"灯塔","dengta",0)
		call addRegion(2912,29,"盘锦","panjin",1)
		call addRegion(291201,2912,"双台子","shuangtaizi",0)
		call addRegion(291202,2912,"兴隆台","xinlongtai",0)
		call addRegion(291203,2912,"大洼","dagui",0)
		call addRegion(291204,2912,"盘山","panshan",0)
		call addRegion(2913,29,"铁岭","tieling",1)
		call addRegion(291301,2913,"银州","yinzhou",0)
		call addRegion(291302,2913,"清河","qinghequ",0)
		call addRegion(291303,2913,"铁岭","tielings",0)
		call addRegion(291304,2913,"西丰","xifengs",0)
		call addRegion(291305,2913,"昌图","changtu",0)
		call addRegion(291306,2913,"调兵山","diaobingshan",0)
		call addRegion(291307,2913,"开原","kaiyuan",0)
		call addRegion(2914,29,"营口","yingkou",1)
		call addRegion(291401,2914,"站前","zhanjian",0)
		call addRegion(291402,2914,"西市","xishi",0)
		call addRegion(291403,2914,"鲅鱼圈","bayujuan",0)
		call addRegion(291404,2914,"老边","laobian",0)
		call addRegion(291405,2914,"盖州","gaizhou",0)
		call addRegion(291406,2914,"大石桥","dashiqiao",0)

		call addRegion(30,0,"内蒙古","neimenggu",1)
		call addRegion(3001,30,"呼和浩特","hhht",1)
		call addRegion(300101,3001,"新城","xincx",0)
		call addRegion(300102,3001,"回民","huimin",0)
		call addRegion(300103,3001,"玉泉","yuquan",0)
		call addRegion(300104,3001,"赛罕","saihan",0)
		call addRegion(300105,3001,"土默特左旗","tmtzq",0)
		call addRegion(300106,3001,"托克托","tuoketuo",0)
		call addRegion(300107,3001,"和林格尔","hlge",0)
		call addRegion(300108,3001,"清水河","qingshuihe",0)
		call addRegion(300109,3001,"武川","wuchuanq",0)
		call addRegion(3002,30,"阿拉善盟","alsm",1)
		call addRegion(300201,3002,"阿拉善左旗","alszq",0)
		call addRegion(300202,3002,"阿拉善右旗","alsyq",0)
		call addRegion(300203,3002,"额济纳旗","ejnq",0)
		call addRegion(3003,30,"巴彦淖尔","byne",1)
		call addRegion(300301,3003,"临河","linhe",0)
		call addRegion(300302,3003,"五原","wuyuan",0)
		call addRegion(300303,3003,"磴口","dengkou",0)
		call addRegion(300304,3003,"乌拉特前旗","wltqq",0)
		call addRegion(300305,3003,"乌拉特中旗","wltzq",0)
		call addRegion(300306,3003,"乌拉特后旗","wlthq",0)
		call addRegion(300307,3003,"杭锦后旗","hjhq",0)
		call addRegion(3004,30,"包头","baotou",1)
		call addRegion(300401,3004,"东河","donghe",0)
		call addRegion(300402,3004,"昆都仑","hundoulun",0)
		call addRegion(300403,3004,"青山","qingshanx",0)
		call addRegion(300404,3004,"石拐","shiguai",0)
		call addRegion(300405,3004,"白云矿","baiyunkuang",0)
		call addRegion(300406,3004,"九原","jiuyuan",0)
		call addRegion(300407,3004,"土默特右旗","tmtyq",0)
		call addRegion(300408,3004,"固阳","guyang",0)
		call addRegion(300409,3004,"达尔罕茂明安联合旗","dehmmalhq",0)
		call addRegion(3005,30,"赤峰","chifeng",1)
		call addRegion(300501,3005,"红山","hongshanx",0)
		call addRegion(300502,3005,"元宝山","yuanbaoshan",0)
		call addRegion(300503,3005,"松山","songshan",0)
		call addRegion(300504,3005,"阿鲁科尔沁旗","alkeqq",0)
		call addRegion(300505,3005,"巴林左旗","blzq",0)
		call addRegion(300506,3005,"巴林右旗","blyq",0)
		call addRegion(300507,3005,"林西","linxix",0)
		call addRegion(300508,3005,"克什克腾旗","ksktq",0)
		call addRegion(300509,3005,"翁牛特旗","wntq",0)
		call addRegion(300510,3005,"喀喇沁旗","klqq",0)
		call addRegion(300511,3005,"宁城","ningcheng",0)
		call addRegion(300512,3005,"敖汉旗","aohanqi",0)
		call addRegion(3006,30,"鄂尔多斯","eeds",1)
		call addRegion(300601,3006,"东胜","dongsheng",0)
		call addRegion(300602,3006,"达拉特旗","dltq",0)
		call addRegion(300603,3006,"准格尔旗","zgeq",0)
		call addRegion(300604,3006,"鄂托克前旗","etkqq",0)
		call addRegion(300605,3006,"鄂托克旗","etkq",0)
		call addRegion(300606,3006,"杭锦旗","hangjinqi",0)
		call addRegion(300607,3006,"乌审旗","wupanqi",0)
		call addRegion(300608,3006,"伊金霍洛旗","yjhlq",0)
		call addRegion(3007,30,"呼伦贝尔","hlbe",1)
		call addRegion(300701,3007,"海拉尔","hailaer",0)
		call addRegion(300702,3007,"阿荣旗","arongqi",0)
		call addRegion(300703,3007,"莫力达瓦达斡尔族自治旗","mldwdwezzzq",0)
		call addRegion(300704,3007,"鄂伦春自治旗","elczzq",0)
		call addRegion(300705,3007,"鄂温克族自治旗","ewkzzzq",0)
		call addRegion(300706,3007,"陈巴尔虎旗","cbehq",0)
		call addRegion(300707,3007,"新巴尔虎左旗","xbehzq",0)
		call addRegion(300708,3007,"新巴尔虎右旗","xbehyq",0)
		call addRegion(300709,3007,"满洲里","manzhouli",0)
		call addRegion(300710,3007,"牙克石","yakeshi",0)
		call addRegion(300711,3007,"扎兰屯","zalantun",0)
		call addRegion(300712,3007,"额尔古纳","eegn",0)
		call addRegion(300713,3007,"根河","genhe",0)
		call addRegion(3008,30,"通辽","tongliao",1)
		call addRegion(300801,3008,"科尔沁","keerqin",0)
		call addRegion(300802,3008,"科尔沁左翼中旗","keqzyzq",0)
		call addRegion(300803,3008,"科尔沁左翼后旗","keqzyhq",0)
		call addRegion(300804,3008,"开鲁","kailu",0)
		call addRegion(300805,3008,"库伦旗","kulunqi",0)
		call addRegion(300806,3008,"奈曼旗","naimanqi",0)
		call addRegion(300807,3008,"扎鲁特旗","zltq",0)
		call addRegion(300808,3008,"霍林郭勒","hlgl",0)
		call addRegion(3009,30,"乌海","wuhai",1)
		call addRegion(300901,3009,"海勃湾","haibowan",0)
		call addRegion(300902,3009,"海南区","hainanqu",0)
		call addRegion(300903,3009,"乌达","wuda",0)
		call addRegion(3010,30,"乌兰察布","wlcb",0)
		call addRegion(301001,3010,"集宁","jiningx",0)
		call addRegion(301002,3010,"卓资","zhuozi",0)
		call addRegion(301003,3010,"化德","huade",0)
		call addRegion(301004,3010,"商都","shangdou",0)
		call addRegion(301005,3010,"兴和","xinhex",0)
		call addRegion(301006,3010,"凉城","liangcheng",0)
		call addRegion(301007,3010,"察哈尔右翼前旗","cheyyqq",0)
		call addRegion(301008,3010,"察哈尔右翼中旗","cheyyzq",0)
		call addRegion(301009,3010,"察哈尔右翼后旗","cheyyhq",0)
		call addRegion(301010,3010,"四子王旗","szwq",0)
		call addRegion(301011,3010,"丰镇","fengzhen",0)
		call addRegion(3011,30,"锡林郭勒盟","xlglm",1)
		call addRegion(301101,3011,"二连浩特","elht",0)
		call addRegion(301102,3011,"锡林浩特","xlht",0)
		call addRegion(301103,3011,"阿巴嘎旗","abgq",0)
		call addRegion(301104,3011,"苏尼特左旗","sntzq",0)
		call addRegion(301105,3011,"苏尼特右旗","sntyq",0)
		call addRegion(301106,3011,"东乌珠穆沁旗","dwzmqq",0)
		call addRegion(301107,3011,"西乌珠穆沁旗","xwzmqq",0)
		call addRegion(301108,3011,"太仆寺旗","tpsq",0)
		call addRegion(301109,3011,"镶黄旗","ranghuangqi",0)
		call addRegion(301110,3011,"正镶白旗","zxbq",0)
		call addRegion(301111,3011,"正蓝旗","zhenglaqi",0)
		call addRegion(301112,3011,"多伦","chelun",0)
		call addRegion(3012,30,"兴安盟","xinanmeng",1)
		call addRegion(301201,3012,"乌兰浩特","wlht",0)
		call addRegion(301202,3012,"阿尔山","aershan",0)
		call addRegion(301203,3012,"科尔沁右翼前旗","keqyyqq",0)
		call addRegion(301204,3012,"科尔沁右翼中旗","keqyyzq",0)
		call addRegion(301205,3012,"扎赉特旗","zztq",0)
		call addRegion(301206,3012,"突泉","tuquan",0)

		call addRegion(31,0,"宁夏","ningxia",1)
		call addRegion(3101,31,"银川","yinchuan",1)
		call addRegion(310101,3101,"兴庆","xinqiang",0)
		call addRegion(310102,3101,"西夏","xixiaq",0)
		call addRegion(310103,3101,"金凤","jinfeng",0)
		call addRegion(310104,3101,"永宁","yongningq",0)
		call addRegion(310105,3101,"贺兰","helanq",0)
		call addRegion(310106,3101,"灵武","lingwu",0)
		call addRegion(3102,31,"固原","guyuan",1)
		call addRegion(310201,3102,"原州","yuanzhoux",0)
		call addRegion(310202,3102,"西吉","xiji",0)
		call addRegion(310203,3102,"隆德","longde",0)
		call addRegion(310204,3102,"泾源","jingyuanx",0)
		call addRegion(310205,3102,"彭阳","pengyang",0)
		call addRegion(3103,30,"石嘴山","shizuishan",1)
		call addRegion(310301,3103,"大武口","dawukou",0)
		call addRegion(310302,3103,"惠农","huinong",0)
		call addRegion(310303,3103,"平罗","pingluo",0)
		call addRegion(3104,31,"吴忠","wuzhongs",1)
		call addRegion(310401,3104,"利通","litong",0)
		call addRegion(310402,3104,"盐池","yanche",0)
		call addRegion(310403,3104,"同心","tongxin",0)
		call addRegion(310404,3104,"青铜峡","qingtongxia",0)
		call addRegion(3105,31,"中卫","zhongwei",1)
		call addRegion(310501,3105,"沙坡头","shapotou",0)
		call addRegion(310502,3105,"中宁","zhongning",0)
		call addRegion(310503,3105,"海原","haiyuan",0)

		call addRegion(32,0,"青海","qinghai",1)
		call addRegion(3201,32,"西宁","xining",1)
		call addRegion(320101,3201,"城东","chengdong",0)
		call addRegion(320102,3201,"城中","chengzhongqu",0)
		call addRegion(320103,3201,"城西","chengxi",0)
		call addRegion(320104,3201,"城北","chengbei",0)
		call addRegion(320105,3201,"大通","qhdatong",0)
		call addRegion(320106,3201,"湟中","huangzhong",0)
		call addRegion(320107,3201,"湟源","huangyuan",0)
		call addRegion(3202,32,"果洛","guanluo",1)
		call addRegion(320201,3202,"玛沁","maqin",0)
		call addRegion(320202,3202,"班玛","banma",0)
		call addRegion(320203,3202,"甘德","gande",0)
		call addRegion(320204,3202,"达日","dari",0)
		call addRegion(320205,3202,"久治","jiuchi",0)
		call addRegion(320206,3202,"玛多","mache",0)
		call addRegion(3203,32,"海北","haibei",1)
		call addRegion(320301,3203,"门源","menyuan",0)
		call addRegion(320302,3203,"祁连","qilian",0)
		call addRegion(320303,3203,"海晏","haiyan",0)
		call addRegion(320304,3203,"刚察","gangcha",0)
		call addRegion(3204,32,"海东","haidong",1)
		call addRegion(320401,3204,"平安","pingan",0)
		call addRegion(320402,3204,"民和","minhe",0)
		call addRegion(320403,3204,"乐都","ledou",0)
		call addRegion(320404,3204,"互助","huchu",0)
		call addRegion(320405,3204,"化隆","hualongx",0)
		call addRegion(320406,3204,"循化","xunhua",0)
		call addRegion(3205,32,"海南藏族","hncz",1)
		call addRegion(320501,3205,"共和","gonghe",0)
		call addRegion(320502,3205,"同德","tongde",0)
		call addRegion(320503,3205,"贵德","guide",0)
		call addRegion(320504,3205,"兴海","xinhai",0)
		call addRegion(320505,3205,"贵南","guinan",0)
		call addRegion(3206,32,"海西","haixi",1)
		call addRegion(320601,3206,"格尔木","geermu",0)
		call addRegion(320602,3206,"德令哈","delianha",0)
		call addRegion(320603,3206,"乌兰","wulan",0)
		call addRegion(320604,3206,"都兰","doulan",0)
		call addRegion(320605,3206,"天峻","tianjun",0)
		call addRegion(3207,32,"黄南","huangnan",1)
		call addRegion(320701,3207,"同仁","tongrenx",0)
		call addRegion(320702,3207,"尖扎","jianza",0)
		call addRegion(320703,3207,"泽库","zeku",0)
		call addRegion(320704,3207,"河南蒙古族","hnmgz",0)
		call addRegion(3208,32,"玉树","yushu",1)
		call addRegion(320801,3208,"杂多","duoche",0)
		call addRegion(320802,3208,"称多","chenche",0)
		call addRegion(320803,3208,"治多","chiche",0)
		call addRegion(320804,3208,"囊谦","nangqian",0)
		call addRegion(320805,3208,"曲麻莱","qumalai",0)

		call addRegion(33,0,"山东","shandong",1)
		call addRegion(3301,33,"济南","jinan",1)
		call addRegion(330101,3301,"历下","lixia",0)
		call addRegion(330102,3301,"市中","shizhong",0)
		call addRegion(330103,3301,"槐荫","huaiyinx",0)
		call addRegion(330104,3301,"天桥","tianqiao",0)
		call addRegion(330105,3301,"历城","sdlicheng",0)
		call addRegion(330106,3301,"长清","changqing",0)
		call addRegion(330107,3301,"平阴","pingyin",0)
		call addRegion(330108,3301,"济阳","jiyang",0)
		call addRegion(330109,3301,"商河","shanghe",0)
		call addRegion(330110,3301,"章丘","zhangqiu",0)
		call addRegion(3302,33,"滨州市","binzhoushi",1)
		call addRegion(330201,3302,"滨城","bincheng",0)
		call addRegion(330202,3302,"惠民","huiminx",0)
		call addRegion(330203,3302,"阳信","yangxinx",0)
		call addRegion(330204,3302,"无棣","modai",0)
		call addRegion(330205,3302,"沾化","chanhua",0)
		call addRegion(330206,3302,"博兴","boxin",0)
		call addRegion(330207,3302,"邹平","juping",0)
		call addRegion(3303,33,"德州","dezhou",1)
		call addRegion(330301,3303,"德城","decheng",0)
		call addRegion(330302,3303,"陵县","lingxian",0)
		call addRegion(330303,3303,"宁津","ningjinx",0)
		call addRegion(330304,3303,"庆云","qiangyun",0)
		call addRegion(330305,3303,"临邑","linyix",0)
		call addRegion(330306,3303,"齐河","jihe",0)
		call addRegion(330307,3303,"平原","pingyuanx",0)
		call addRegion(330308,3303,"夏津","xiajin",0)
		call addRegion(330309,3303,"武城","wucheng",0)
		call addRegion(330310,3303,"乐陵","leling",0)
		call addRegion(330311,3303,"禹城","dzyc",0)
		call addRegion(3304,33,"东营","dongying",1)
		call addRegion(330401,3304,"河口","hekou",0)
		call addRegion(330402,3304,"垦利","kenli",0)
		call addRegion(330403,3304,"利津","lijin",0)
		call addRegion(330404,3304,"广饶","guangrao",0)
		call addRegion(3305,33,"菏泽","geze",1)
		call addRegion(330501,3305,"牡丹","mudan",0)
		call addRegion(330502,3305,"曹县","caoxian",0)
		call addRegion(330503,3305,"单县","chanxian",0)
		call addRegion(330504,3305,"成武","chengwu",0)
		call addRegion(330505,3305,"巨野","jushu",0)
		call addRegion(330506,3305,"郓城","hzyc",0)
		call addRegion(330507,3305,"鄄城","juancheng",0)
		call addRegion(330508,3305,"定陶","dingdao",0)
		call addRegion(330509,3305,"东明","dongmeng",0)
		call addRegion(3306,33,"济宁","jining",1)
		call addRegion(330601,3306,"任城","rencheng",0)
		call addRegion(330602,3306,"微山","weishan",0)
		call addRegion(330603,3306,"鱼台","yutai",0)
		call addRegion(330604,3306,"金乡","jinxiang",0)
		call addRegion(330605,3306,"嘉祥","jiaxiang",0)
		call addRegion(330606,3306,"汶上","menshang",0)
		call addRegion(330607,3306,"泗水","sishui",0)
		call addRegion(330608,3306,"梁山","liangshanx",0)
		call addRegion(330609,3306,"曲阜","qufu",0)
		call addRegion(330610,3306,"兖州","yanzhou",0)
		call addRegion(330611,3306,"邹城","jucheng",0)
		call addRegion(3307,33,"莱芜","laiwu",1)
		call addRegion(330701,3307,"莱城","laicheng",0)
		call addRegion(330702,3307,"钢城","gangcheng",0)
		call addRegion(3308,33,"聊城","liaocheng",1)
		call addRegion(330801,3308,"东昌府","dongchangfu",0)
		call addRegion(330802,3308,"阳谷","yanggu",0)
		call addRegion(330803,3308,"莘县","shenxian",0)
		call addRegion(330804,3308,"茌平","chiping",0)
		call addRegion(330805,3308,"东阿","donga",0)
		call addRegion(330806,3308,"冠县","guanxian",0)
		call addRegion(330807,3308,"高唐","gaotang",0)
		call addRegion(330808,3308,"临清","linqing",0)
		call addRegion(3309,33,"临沂","linyi",1)
		call addRegion(330901,3309,"兰山","lanshan",0)
		call addRegion(330902,3309,"罗庄","luopeng",0)
		call addRegion(330903,3309,"河东","hdong",0)
		call addRegion(330904,3309,"沂南","yinan",0)
		call addRegion(330905,3309,"郯城","tancheng",0)
		call addRegion(330906,3309,"沂水","yishui",0)
		call addRegion(330907,3309,"苍山","cangshanx",0)
		call addRegion(330908,3309,"费县","bixian",0)
		call addRegion(330909,3309,"平邑","pingyi",0)
		call addRegion(330910,3309,"莒南","junan",0)
		call addRegion(330911,3309,"蒙阴","mengyin",0)
		call addRegion(330912,3309,"临沭","linshu",0)
		call addRegion(3310,33,"青岛","qingdao",1)
		call addRegion(331001,3310,"市南","shinan",0)
		call addRegion(331002,3310,"市北","shibei",0)
		call addRegion(331003,3310,"四方","sifang",0)
		call addRegion(331004,3310,"黄岛","huangdao",0)
		call addRegion(331005,3310,"崂山","laoshan",0)
		call addRegion(331006,3310,"李沧","licang",0)
		call addRegion(331007,3310,"城阳","chengyang",0)
		call addRegion(331008,3310,"胶州","jiaozhou",0)
		call addRegion(331009,3310,"即墨","jimo",0)
		call addRegion(331010,3310,"平度","pingdu",0)
		call addRegion(331011,3310,"胶南","jiaonan",0)
		call addRegion(331012,3310,"莱西","laixi",0)
		call addRegion(3311,33,"日照","rizhao",1)
		call addRegion(331101,3311,"东港","donggangx",0)
		call addRegion(331102,3311,"岚山","lanshanx",0)
		call addRegion(331103,3311,"五莲","wulian",0)
		call addRegion(331104,3311,"莒县","juxian",0)
		call addRegion(3312,33,"泰安","taian",1)
		call addRegion(331201,3312,"泰山","taishanx",0)
		call addRegion(331202,3312,"岱岳","daiyue",0)
		call addRegion(331203,3312,"宁阳","ningyang",0)
		call addRegion(331204,3312,"东平","dongping",0)
		call addRegion(331205,3312,"新泰","xintai",0)
		call addRegion(331206,3312,"肥城","feicheng",0)
		call addRegion(3313,33,"威海","weihai",1)
		call addRegion(331301,3313,"环翠","huancui",0)
		call addRegion(331302,3313,"文登","wende",0)
		call addRegion(331303,3313,"荣成","rongchengx",0)
		call addRegion(331304,3313,"乳山","rushan",0)
		call addRegion(3314,33,"潍坊","weifang",1)
		call addRegion(331401,3314,"潍城","weicheng",0)
		call addRegion(331402,3314,"寒亭","hanting",0)
		call addRegion(331403,3314,"坊子","fangzi",0)
		call addRegion(331404,3314,"奎文","kuiwen",0)
		call addRegion(331405,3314,"临朐","linchun",0)
		call addRegion(331406,3314,"昌乐","changlex",0)
		call addRegion(331407,3314,"青州","qingzhoux",0)
		call addRegion(331408,3314,"诸城","chucheng",0)
		call addRegion(331409,3314,"寿光","shouguang",0)
		call addRegion(331410,3314,"安丘","anqiu",0)
		call addRegion(331411,3314,"高密","gaomi",0)
		call addRegion(331412,3314,"昌邑","changyix",0)
		call addRegion(3315,33,"烟台","yantai",1)
		call addRegion(331501,3315,"芝罘","zhifu",0)
		call addRegion(331502,3315,"福山","fushan",0)
		call addRegion(331503,3315,"牟平","maoping",0)
		call addRegion(331504,3315,"莱山","laishan",0)
		call addRegion(331505,3315,"长岛","changdao",0)
		call addRegion(331506,3315,"龙口","longkou",0)
		call addRegion(331507,3315,"莱阳","laiyang",0)
		call addRegion(331508,3315,"莱州","laizhou",0)
		call addRegion(331509,3315,"蓬莱","penglai",0)
		call addRegion(331510,3315,"招远","qiaoyuan",0)
		call addRegion(331511,3315,"栖霞","qixias",0)
		call addRegion(331512,3315,"海阳","haiyang",0)
		call addRegion(3316,33,"枣庄","zaopeng",1)
		call addRegion(331601,3316,"市中","shizong",0)
		call addRegion(331602,3316,"薛城","xuecheng",0)
		call addRegion(331603,3316,"峄城","zzyicheng",0)
		call addRegion(331604,3316,"台儿庄","taierpeng",0)
		call addRegion(331605,3316,"山亭","shanting",0)
		call addRegion(331606,3316,"滕州","tengzhou",0)
		call addRegion(3317,33,"淄博","zibo",1)
		call addRegion(331701,3317,"淄川","zichuan",0)
		call addRegion(331702,3317,"张店","zhangdian",0)
		call addRegion(331703,3317,"博山","boshan",0)
		call addRegion(331704,3317,"临淄","linzi",0)
		call addRegion(331705,3317,"周村","zhoucun",0)
		call addRegion(331706,3317,"桓台","huantai",0)
		call addRegion(331707,3317,"高青","gaoqing",0)
		call addRegion(331708,3317,"沂源","yiyuan",0)

		call addRegion(34,0,"山西","shanxi",1)
		call addRegion(3401,34,"太原","taiyuan",1)
		call addRegion(340101,3401,"小店","xiaodian",0)
		call addRegion(340102,3401,"迎泽","yingze",0)
		call addRegion(340103,3401,"杏花岭","xinghualing",0)
		call addRegion(340104,3401,"尖草坪","jiancaoping",0)
		call addRegion(340105,3401,"万柏林","mobailin",0)
		call addRegion(340106,3401,"晋源","jinyuan",0)
		call addRegion(340107,3401,"清徐","qingxu",0)
		call addRegion(340108,3401,"阳曲","yangqu",0)
		call addRegion(340109,3401,"娄烦","loufan",0)
		call addRegion(340110,3401,"古交","gujiao",0)
		call addRegion(3402,34,"长治","changchi",1)
		call addRegion(340201,3402,"城区","chengq",0)
		call addRegion(340202,3402,"郊区","czjq",0)
		call addRegion(340203,3402,"襄垣","xiangyuan",0)
		call addRegion(340204,3402,"屯留","tunliu",0)
		call addRegion(340205,3402,"平顺","pingshun",0)
		call addRegion(340206,3402,"黎城","czlicheng",0)
		call addRegion(340207,3402,"壶关","huguan",0)
		call addRegion(340208,3402,"长子","changzi",0)
		call addRegion(340209,3402,"武乡","wuxiang",0)
		call addRegion(340210,3402,"沁县","qinxian",0)
		call addRegion(340211,3402,"沁源","qinyuan",0)
		call addRegion(340212,3402,"潞城","lucheng",0)
		call addRegion(3403,34,"大同","datong",1)
		call addRegion(340301,3403,"城区","cheng",0)
		call addRegion(340302,3403,"矿区","kuang",0)
		call addRegion(340303,3403,"南郊","nanj",0)
		call addRegion(340304,3403,"新荣","xinrong",0)
		call addRegion(340305,3403,"阳高","yanggao",0)
		call addRegion(340306,3403,"天镇","tianzhen",0)
		call addRegion(340307,3403,"广灵","anlingx",0)
		call addRegion(340308,3403,"灵丘","lingqiu",0)
		call addRegion(340309,3403,"浑源","gunyuan",0)
		call addRegion(340310,3403,"左云","zuoyun",0)
		call addRegion(3404,34,"晋城","jincheng",1)
		call addRegion(340401,3404,"城区","jccq",0)
		call addRegion(340402,3404,"沁水","qinshui",0)
		call addRegion(340403,3404,"阳城","yangcheng",0)
		call addRegion(340404,3404,"陵川","lingchuanx",0)
		call addRegion(340405,3404,"泽州","zezhou",0)
		call addRegion(340406,3404,"高平","gaoping",0)
		call addRegion(3405,34,"晋中","jinzhong",1)
		call addRegion(340501,3405,"榆次","yuci",0)
		call addRegion(340502,3405,"榆社","yushe",0)
		call addRegion(340503,3405,"左权","zuoquan",0)
		call addRegion(340504,3405,"和顺","heshun",0)
		call addRegion(340505,3405,"昔阳","cuoyang",0)
		call addRegion(340506,3405,"寿阳","shouyang",0)
		call addRegion(340507,3405,"太谷","taigu",0)
		call addRegion(340508,3405,"祁县","jzqixian",0)
		call addRegion(340509,3405,"平遥","pingyao",0)
		call addRegion(340510,3405,"灵石","lingshi",0)
		call addRegion(340511,3405,"介休","gexiu",0)
		call addRegion(3406,34,"临汾","linfen",1)
		call addRegion(340601,3406,"尧都","yaodou",0)
		call addRegion(340602,3406,"曲沃","quwo",0)
		call addRegion(340603,3406,"翼城","lfyicheng",0)
		call addRegion(340604,3406,"襄汾","xiangfen",0)
		call addRegion(340605,3406,"洪洞","hongdong",0)
		call addRegion(340606,3406,"古县","lfguxian",0)
		call addRegion(340607,3406,"安泽","anze",0)
		call addRegion(340608,3406,"浮山","fushanx",0)
		call addRegion(340609,3406,"吉县","lfjixian",0)
		call addRegion(340610,3406,"乡宁","xiangning",0)
		call addRegion(340611,3406,"大宁","daning",0)
		call addRegion(340612,3406,"隰县","lfxixian",0)
		call addRegion(340613,3406,"永和","yonghe",0)
		call addRegion(340614,3406,"蒲县","boxian",0)
		call addRegion(340615,3406,"汾西","fenxi",0)
		call addRegion(340616,3406,"侯马","houma",0)
		call addRegion(340617,3406,"霍州","lfhezhou",0)
		call addRegion(3407,34,"吕梁","lvliang",1)
		call addRegion(340701,3407,"离石","chishi",0)
		call addRegion(340702,3407,"文水","wenshui",0)
		call addRegion(340703,3407,"交城","jiaochengx",0)
		call addRegion(340704,3407,"兴县","llxinxian",0)
		call addRegion(340705,3407,"临县","lllinxian",0)
		call addRegion(340706,3407,"柳林","liulin",0)
		call addRegion(340707,3407,"石楼","shilou",0)
		call addRegion(340708,3407,"岚县","lanxian",0)
		call addRegion(340709,3407,"方山","fangshanx",0)
		call addRegion(340710,3407,"中阳","zhongyang",0)
		call addRegion(340711,3407,"交口","jiaokoux",0)
		call addRegion(340712,3407,"孝义","xiaoyi",0)
		call addRegion(340713,3407,"汾阳","fenyang",0)
		call addRegion(3408,34,"朔州","shuozhou",1)
		call addRegion(340801,3408,"朔城","shuocheng",0)
		call addRegion(340802,3408,"平鲁","pinglu",0)
		call addRegion(340803,3408,"山阴","shanyin",0)
		call addRegion(340804,3408,"应县","yingxian",0)
		call addRegion(340805,3408,"右玉","youyu",0)
		call addRegion(340806,3408,"怀仁","huairen",0)
		call addRegion(3409,34,"忻州","xinzhou",1)
		call addRegion(340901,3409,"忻府","xinfux",0)
		call addRegion(340902,3409,"定襄","dingxiang",0)
		call addRegion(340903,3409,"五台","wutai",0)
		call addRegion(340904,3409,"代县","daixian",0)
		call addRegion(340905,3409,"繁峙","fanshi",0)
		call addRegion(340906,3409,"宁武","ningwu",0)
		call addRegion(340907,3409,"静乐","jingle",0)
		call addRegion(340908,3409,"神池","shenche",0)
		call addRegion(340909,3409,"五寨","wuqian",0)
		call addRegion(340910,3409,"岢岚","kelan",0)
		call addRegion(340911,3409,"河曲","hequ",0)
		call addRegion(340912,3409,"保德","baode",0)
		call addRegion(340913,3409,"偏关","pianguan",0)
		call addRegion(340914,3409,"原平","yuanping",0)
		call addRegion(3410,34,"阳泉","yangquan",1)
		call addRegion(341001,3410,"城区","cq",0)
		call addRegion(341002,3410,"矿区","kqu",0)
		call addRegion(341003,3410,"郊区","jq",0)
		call addRegion(341004,3410,"平定","pingding",0)
		call addRegion(341005,3410,"盂县","yuxian",0)
		call addRegion(3411,34,"运城","yuncheng",1)
		call addRegion(341101,3411,"盐湖","yanhu",0)
		call addRegion(341102,3411,"临猗","linji",0)
		call addRegion(341103,3411,"万荣","morong",0)
		call addRegion(341104,3411,"闻喜","wenchi",0)
		call addRegion(341105,3411,"稷山","jishan",0)
		call addRegion(341106,3411,"新绛","xinjiangx",0)
		call addRegion(341107,3411,"绛县","jiangxian",0)
		call addRegion(341108,3411,"垣曲","yuanqu",0)
		call addRegion(341109,3411,"夏县","xiaxian",0)
		call addRegion(341110,3411,"平陆","pingliu",0)
		call addRegion(341111,3411,"芮城","ruicheng",0)
		call addRegion(341112,3411,"永济","yongjix",0)
		call addRegion(341113,3411,"河津","hejin",0)

		call addRegion(35,0,"陕西","shanxis",1)
		call addRegion(3501,35,"西安","xian",1)
		call addRegion(350101,3501,"新城","xinc",0)
		call addRegion(350102,3501,"碑林","beilinx",0)
		call addRegion(350103,3501,"莲湖","lianhu",0)
		call addRegion(350104,3501,"灞桥","baqiao",0)
		call addRegion(350105,3501,"未央","weiyang",0)
		call addRegion(350106,3501,"雁塔","yanta",0)
		call addRegion(350107,3501,"阎良","yanliang",0)
		call addRegion(350108,3501,"临潼","linchong",0)
		call addRegion(350109,3501,"长安","changanx",0)
		call addRegion(350110,3501,"蓝田","latian",0)
		call addRegion(350111,3501,"周至","zhoudie",0)
		call addRegion(350112,3501,"户县","huxian",0)
		call addRegion(350113,3501,"高陵","gaoling",0)
		call addRegion(3502,35,"安康","ankang",1)
		call addRegion(350201,3502,"汉滨","hanbin",0)
		call addRegion(350202,3502,"汉阴","hanyin",0)
		call addRegion(350203,3502,"石泉","shiquan",0)
		call addRegion(350204,3502,"宁陕","ningshan",0)
		call addRegion(350205,3502,"紫阳","ziyangx",0)
		call addRegion(350206,3502,"岚皋","langao",0)
		call addRegion(350207,3502,"平利","pingli",0)
		call addRegion(350208,3502,"镇坪","zhenpingx",0)
		call addRegion(350209,3502,"旬阳","junyang",0)
		call addRegion(350210,3502,"白河","baihe",0)
		call addRegion(3503,35,"宝鸡","baoji",1)
		call addRegion(350301,3503,"渭滨","weibinx",0)
		call addRegion(350302,3503,"金台","jintai",0)
		call addRegion(350303,3503,"陈仓","chencang",0)
		call addRegion(350304,3503,"凤翔","fengxiang",0)
		call addRegion(350305,3503,"岐山","qishan",0)
		call addRegion(350306,3503,"扶风","fufeng",0)
		call addRegion(350307,3503,"眉县","bjmeixian",0)
		call addRegion(350308,3503,"陇县","longxian",0)
		call addRegion(350309,3503,"千阳","qianyang",0)
		call addRegion(350310,3503,"麟游","linliu",0)
		call addRegion(350311,3503,"凤县","bjfengxian",0)
		call addRegion(350312,3503,"太白","taibai",0)
		call addRegion(3504,35,"汉中","hanzhong",1)
		call addRegion(350401,3504,"汉台","hantai",0)
		call addRegion(350402,3504,"南郑","nanzheng",0)
		call addRegion(350403,3504,"城固","chenggu",0)
		call addRegion(350404,3504,"洋县","xiangxian",0)
		call addRegion(350405,3504,"西乡","xixiang",0)
		call addRegion(350406,3504,"勉县","mianxian",0)
		call addRegion(350407,3504,"宁强","ningqiang",0)
		call addRegion(350408,3504,"略阳","lueyang",0)
		call addRegion(350409,3504,"镇巴","zhenba",0)
		call addRegion(350410,3504,"留坝","liuba",0)
		call addRegion(350411,3504,"佛坪","biping",0)
		call addRegion(3505,35,"商洛","shangluo",1)
		call addRegion(350501,3505,"商州","shangzhou",0)
		call addRegion(350502,3505,"洛南","luonan",0)
		call addRegion(350503,3505,"丹凤","danfengx",0)
		call addRegion(350504,3505,"商南","shangnan",0)
		call addRegion(350505,3505,"山阳","shanyangx",0)
		call addRegion(350506,3505,"镇安","zhenanx",0)
		call addRegion(350507,3505,"柞水","zeshui",0)
		call addRegion(3506,35,"铜川","tongchuan",1)
		call addRegion(350601,3506,"王益","wangyi",0)
		call addRegion(350602,3506,"印台","yitai",0)
		call addRegion(350603,3506,"耀州","yaozhou",0)
		call addRegion(350604,3506,"宜君","yijun",0)
		call addRegion(3507,35,"渭南","weinan",1)
		call addRegion(350701,3507,"临渭","linwei",0)
		call addRegion(350702,3507,"华县","huaxian",0)
		call addRegion(350703,3507,"潼关","chongguan",0)
		call addRegion(350704,3507,"大荔","dalix",0)
		call addRegion(350705,3507,"合阳","geyang",0)
		call addRegion(350706,3507,"澄城","chengcheng",0)
		call addRegion(350707,3507,"蒲城","bocheng",0)
		call addRegion(350708,3507,"白水","baishui",0)
		call addRegion(350709,3507,"富平","fupingx",0)
		call addRegion(350710,3507,"韩城","hancheng",0)
		call addRegion(350711,3507,"华阴","huayin",0)
		call addRegion(3508,35,"咸阳","xianyang",1)
		call addRegion(350801,3508,"秦都","qindou",0)
		call addRegion(350802,3508,"杨凌","yangling",0)
		call addRegion(350803,3508,"渭城","weichengx",0)
		call addRegion(350804,3508,"三原","sanyuanx",0)
		call addRegion(350805,3508,"泾阳","xyjy",0)
		call addRegion(350806,3508,"乾县","qianxian",0)
		call addRegion(350807,3508,"礼泉","liquan",0)
		call addRegion(350808,3508,"永寿","yongshou",0)
		call addRegion(350809,3508,"彬县","banxian",0)
		call addRegion(350810,3508,"长武","changwu",0)
		call addRegion(350811,3508,"旬邑","junyi",0)
		call addRegion(350812,3508,"淳化","chunhua",0)
		call addRegion(350813,3508,"武功","wugong",0)
		call addRegion(350814,3508,"兴平","xinping",0)
		call addRegion(3509,35,"延安","yanan",1)
		call addRegion(350901,3509,"宝塔","baota",0)
		call addRegion(350902,3509,"延长","yanchang",0)
		call addRegion(350903,3509,"延川","yanchuan",0)
		call addRegion(350904,3509,"子长","zichang",0)
		call addRegion(350905,3509,"安塞","ansai",0)
		call addRegion(350906,3509,"志丹","zhidan",0)
		call addRegion(350907,3509,"吴旗","wuqi",0)
		call addRegion(350908,3509,"甘泉","ganquan",0)
		call addRegion(350909,3509,"富县","fuxian",0)
		call addRegion(350910,3509,"洛川","luochuan",0)
		call addRegion(350911,3509,"宜川","yichuanx",0)
		call addRegion(350912,3509,"黄龙","huanglong",0)
		call addRegion(350913,3509,"黄陵","huangling",0)
		call addRegion(3510,35,"榆林","yulin",1)
		call addRegion(351001,3510,"榆阳","yuyang",0)
		call addRegion(351002,3510,"神木","shenmu",0)
		call addRegion(351003,3510,"府谷","fugu",0)
		call addRegion(351004,3510,"横山","hengshanx",0)
		call addRegion(351005,3510,"靖边","jingbian",0)
		call addRegion(351006,3510,"定边","dingbian",0)
		call addRegion(351007,3510,"绥德","ruide",0)
		call addRegion(351008,3510,"米脂","mizhi",0)
		call addRegion(351009,3510,"佳县","yljx",0)
		call addRegion(351010,3510,"吴堡","wubao",0)
		call addRegion(351011,3510,"清涧","qingjian",0)
		call addRegion(351012,3510,"子洲","zizhou",0)

		call addRegion(36,0,"四川","sichuan",1)
		call addRegion(3601,36,"成都","chengdou",1)
		call addRegion(360101,3601,"锦江","jinjiangx",0)
		call addRegion(360102,3601,"青羊","qingyangx",0)
		call addRegion(360103,3601,"金牛","jinniu",0)
		call addRegion(360104,3601,"武侯","wuhou",0)
		call addRegion(360105,3601,"成华","chenghua",0)
		call addRegion(360106,3601,"龙泉驿","longquanyi",0)
		call addRegion(360107,3601,"青白江","qingbaijiang",0)
		call addRegion(360108,3601,"新都","xindou",0)
		call addRegion(360109,3601,"温江","wenjiang",0)
		call addRegion(360110,3601,"金堂","jintang",0)
		call addRegion(360111,3601,"双流","shuangliu",0)
		call addRegion(360112,3601,"郫县","pixian",0)
		call addRegion(360113,3601,"大邑","dayi",0)
		call addRegion(360114,3601,"蒲江","bojiang",0)
		call addRegion(360115,3601,"新津","xinjin",0)
		call addRegion(360116,3601,"都江堰","doujiangyan",0)
		call addRegion(360117,3601,"彭州","pengzhou",0)
		call addRegion(360118,3601,"邛崃","qionglai",0)
		call addRegion(360119,3601,"崇州","chongzhou",0)
		call addRegion(3602,36,"阿坝","aba",1)
		call addRegion(360201,3602,"汶川","menchuan",0)
		call addRegion(360202,3602,"理县","ablixian",0)
		call addRegion(360203,3602,"茂县","maoxian",0)
		call addRegion(360204,3602,"松潘","songbo",0)
		call addRegion(360205,3602,"九寨沟","jiuqiangou",0)
		call addRegion(360206,3602,"金川","jinchuanx",0)
		call addRegion(360207,3602,"小金","xiaojin",0)
		call addRegion(360208,3602,"黑水","heishui",0)
		call addRegion(360209,3602,"马尔康","maerkang",0)
		call addRegion(360210,3602,"壤塘","rangtang",0)
		call addRegion(360211,3602,"若尔盖","reergai",0)
		call addRegion(360212,3602,"红原","hongyuan",0)
		call addRegion(3603,36,"巴中","bazhong",1)
		call addRegion(360301,3603,"巴州","bazhoux",0)
		call addRegion(360302,3603,"通江","tongjiangx",0)
		call addRegion(360303,3603,"南江","nanjiang",0)
		call addRegion(360304,3603,"平昌","pingchang",0)
		call addRegion(3604,36,"达州","dazhou",1)
		call addRegion(360401,3604,"通川","tongchuanx",0)
		call addRegion(360402,3604,"达县","daxian",0)
		call addRegion(360403,3604,"宣汉","xuanhan",0)
		call addRegion(360404,3604,"开江","kaijiang",0)
		call addRegion(360405,3604,"大竹","dazhu",0)
		call addRegion(360406,3604,"渠县","quxian",0)
		call addRegion(360407,3604,"万源","moyuan",0)
		call addRegion(3605,36,"德阳","deyang",1)
		call addRegion(360501,3605,"旌阳","dyjy",0)
		call addRegion(360502,3605,"中江","zhongjiang",0)
		call addRegion(360503,3605,"罗江","luojiangx",0)
		call addRegion(360504,3605,"广汉","guanghan",0)
		call addRegion(360505,3605,"什邡","shenfang",0)
		call addRegion(360506,3605,"绵竹","mianzhu",0)
		call addRegion(3606,36,"甘孜","ganzi",1)
		call addRegion(360601,3606,"康定","kangding",0)
		call addRegion(360602,3606,"泸定","luding",0)
		call addRegion(360603,3606,"丹巴","danba",0)
		call addRegion(360604,3606,"九龙","jiulong",0)
		call addRegion(360605,3606,"雅江","yajiang",0)
		call addRegion(360606,3606,"道孚","daofu",0)
		call addRegion(360607,3606,"炉霍","luhe",0)
		call addRegion(360608,3606,"甘孜","ganzix",0)
		call addRegion(360609,3606,"新龙","xinlongx",0)
		call addRegion(360610,3606,"德格","dege",0)
		call addRegion(360611,3606,"白玉","baiyu",0)
		call addRegion(360612,3606,"石渠","shiqu",0)
		call addRegion(360613,3606,"色达","seda",0)
		call addRegion(360614,3606,"理塘","litang",0)
		call addRegion(360615,3606,"巴塘","batang",0)
		call addRegion(360616,3606,"乡城","xiangchengx",0)
		call addRegion(360617,3606,"稻城","daocheng",0)
		call addRegion(360618,3606,"得荣","derong",0)
		call addRegion(3607,36,"广安","guangan",1)
		call addRegion(360701,3607,"岳池","yueche",0)
		call addRegion(360702,3607,"武胜","wusheng",0)
		call addRegion(360703,3607,"邻水","linshui",0)
		call addRegion(360704,3607,"华莹","huaying",0)
		call addRegion(3608,36,"广元","guangyuan",1)
		call addRegion(360801,3608,"市中","gysz",0)
		call addRegion(360802,3608,"元坝","yuanba",0)
		call addRegion(360803,3608,"朝天","chaotian",0)
		call addRegion(360804,3608,"旺苍","wangcang",0)
		call addRegion(360805,3608,"青川","qingchuanx",0)
		call addRegion(360806,3608,"剑阁","jiange",0)
		call addRegion(360807,3608,"苍溪","cangxi",0)
		call addRegion(3609,36,"乐山","leshan",1)
		call addRegion(360901,3609,"市中","lssz",0)
		call addRegion(360902,3609,"沙湾","shawan",0)
		call addRegion(360903,3609,"五通桥","wutongqiao",0)
		call addRegion(360904,3609,"金口河","jinkouhe",0)
		call addRegion(360905,3609,"犍为","jianwei",0)
		call addRegion(360906,3609,"井研","jingxing",0)
		call addRegion(360907,3609,"夹江","gajiang",0)
		call addRegion(360908,3609,"沐川","muchuan",0)
		call addRegion(360909,3609,"峨边","ebian",0)
		call addRegion(360910,3609,"马边","mabian",0)
		call addRegion(360911,3609,"峨眉山","emeishan",0)
		call addRegion(3610,36,"凉山","liangshan",1)
		call addRegion(361001,3610,"西昌","xichang",0)
		call addRegion(361002,3610,"木里","muli",0)
		call addRegion(361003,3610,"盐源","yanyuan",0)
		call addRegion(361004,3610,"德昌","dechang",0)
		call addRegion(361005,3610,"会理","huili",0)
		call addRegion(361006,3610,"会东","huidongx",0)
		call addRegion(361007,3610,"宁南","ningnan",0)
		call addRegion(361008,3610,"普格","puge",0)
		call addRegion(361009,3610,"布拖","buchi",0)
		call addRegion(361010,3610,"金阳","jinyang",0)
		call addRegion(361011,3610,"昭觉","zhaojiao",0)
		call addRegion(361012,3610,"喜德","chide",0)
		call addRegion(361013,3610,"冕宁","mianning",0)
		call addRegion(361014,3610,"越西","huoxi",0)
		call addRegion(361015,3610,"甘洛","ganluo",0)
		call addRegion(361016,3610,"美姑","meigu",0)
		call addRegion(361017,3610,"雷波","leibei",0)
		call addRegion(3611,36,"泸州","luzhou",1)
		call addRegion(361101,3611,"江阳","jiangyang",0)
		call addRegion(361102,3611,"纳溪","naxi",0)
		call addRegion(361103,3611,"龙马潭","longmatan",0)
		call addRegion(361104,3611,"泸县","luxian",0)
		call addRegion(361105,3611,"合江","gejiang",0)
		call addRegion(361106,3611,"叙永","xuyong",0)
		call addRegion(361107,3611,"古蔺","gulin",0)
		call addRegion(3612,36,"眉山","meishan",1)
		call addRegion(361201,3612,"东坡","dongpo",0)
		call addRegion(361202,3612,"仁寿","renshou",0)
		call addRegion(361203,3612,"彭山","pengshan",0)
		call addRegion(361204,3612,"洪雅","hongya",0)
		call addRegion(361205,3612,"丹棱","danling",0)
		call addRegion(361206,3612,"青神","qingshen",0)
		call addRegion(3613,36,"绵阳","mianyang",1)
		call addRegion(361301,3613,"涪城","fuchengx",0)
		call addRegion(361302,3613,"游仙","liuxian",0)
		call addRegion(361303,3613,"三台","santai",0)
		call addRegion(361304,3613,"盐亭","yanting",0)
		call addRegion(361305,3613,"安县","anxian",0)
		call addRegion(361306,3613,"梓潼","zichong",0)
		call addRegion(361307,3613,"北川","beichuan",0)
		call addRegion(361308,3613,"平武","pingwu",0)
		call addRegion(361309,3613,"江油","jiangyou",0)
		call addRegion(3614,36,"内江","neijiang",1)
		call addRegion(361401,3614,"市中","szq",0)
		call addRegion(361402,3614,"东兴","dongxinx",0)
		call addRegion(361403,3614,"威远","weiyuanx",0)
		call addRegion(361404,3614,"资中","zizhong",0)
		call addRegion(361405,3614,"隆昌","longchang",0)
		call addRegion(3615,36,"南充","nanchong",1)
		call addRegion(361501,3615,"顺庆","shunqiang",0)
		call addRegion(361502,3615,"高坪","gaopingx",0)
		call addRegion(361503,3615,"嘉陵","jialing",0)
		call addRegion(361504,3615,"南部","nanbu",0)
		call addRegion(361505,3615,"营山","yingshanx",0)
		call addRegion(361506,3615,"蓬安","pengan",0)
		call addRegion(361507,3615,"仪陇","yilong",0)
		call addRegion(361508,3615,"西充","xichong",0)
		call addRegion(361509,3615,"阆中","langzhong",0)
		call addRegion(3616,36,"攀枝花","panzhihua",1)
		call addRegion(361601,3616,"东区","dongqu",0)
		call addRegion(361602,3616,"西区","xiqu",0)
		call addRegion(361603,3616,"仁和","renhe",0)
		call addRegion(361604,3616,"米易","miyi",0)
		call addRegion(361605,3616,"盐边","yanbianx",0)
		call addRegion(3617,36,"遂宁","suining",1)
		call addRegion(361701,3617,"船山","chuanshan",0)
		call addRegion(361702,3617,"安居","anji",0)
		call addRegion(361703,3617,"蓬溪","pengxi",0)
		call addRegion(361704,3617,"射洪","shehong",0)
		call addRegion(361705,3617,"大英","daying",0)
		call addRegion(3618,36,"雅安","yaan",1)
		call addRegion(361801,3618,"雨城","yayc",0)
		call addRegion(361802,3618,"名山","mingshan",0)
		call addRegion(361803,3618,"荥经","xingjing",0)
		call addRegion(361804,3618,"汉源","hanyuan",0)
		call addRegion(361805,3618,"石棉","shimian",0)
		call addRegion(361806,3618,"天全","tianquan",0)
		call addRegion(361807,3618,"芦山","hushan",0)
		call addRegion(361808,3618,"宝兴","baoxin",0)
		call addRegion(3619,36,"宜宾","yibin",1)
		call addRegion(361901,3619,"翠屏","cuiping",0)
		call addRegion(361902,3619,"南溪","naxix",0)
		call addRegion(361903,3619,"江安","jianganx",0)
		call addRegion(361904,3619,"长宁","changningx",0)
		call addRegion(361905,3619,"高县","gaoxian",0)
		call addRegion(361906,3619,"珙县","gongxian",0)
		call addRegion(361907,3619,"筠连","junlian",0)
		call addRegion(361908,3619,"兴文","xinwen",0)
		call addRegion(361909,3619,"屏山","ybpingshan",0)
		call addRegion(3620,36,"资阳","ziyang",1)
		call addRegion(362001,3620,"雁江","yanjiang",0)
		call addRegion(362002,3620,"安岳","anyue",0)
		call addRegion(362003,3620,"乐至","ledie",0)
		call addRegion(362004,3620,"简阳","jianyangx",0)
		call addRegion(3621,36,"自贡","zigong",1)
		call addRegion(362101,3621,"自流井","ziliujing",0)
		call addRegion(362102,3621,"贡井","gongjing",0)
		call addRegion(362103,3621,"大安","zgdaan",0)
		call addRegion(362104,3621,"沿滩","yanhan",0)
		call addRegion(362105,3621,"荣县","zgrongxian",0)
		call addRegion(362106,3621,"富顺","fushunx",0)

		call addRegion(37,0,"西藏","xicang",1)
		call addRegion(3701,37,"拉萨","lasa",1)
		call addRegion(370101,3701,"城关","chengguanx",0)
		call addRegion(370102,3701,"林周","linzhoux",0)
		call addRegion(370103,3701,"当雄","dangxiong",0)
		call addRegion(370104,3701,"尼木","nimu",0)
		call addRegion(370105,3701,"曲水","qushui",0)
		call addRegion(370106,3701,"堆龙德庆","dldq",0)
		call addRegion(370107,3701,"达孜","dazi",0)
		call addRegion(370108,3701,"墨竹工卡","mzgk",0)
		call addRegion(3702,37,"阿里","ali",1)
		call addRegion(370201,3702,"普兰","pulan",0)
		call addRegion(370202,3702,"札达","yada",0)
		call addRegion(370203,3702,"噶尔","gaer",0)
		call addRegion(370204,3702,"日土","richa",0)
		call addRegion(370205,3702,"革吉","geji",0)
		call addRegion(370206,3702,"改则","gaize",0)
		call addRegion(370207,3702,"措勤","ciqi",0)
		call addRegion(3703,37,"昌都","changdou",1)
		call addRegion(370301,3703,"江达","jiangda",0)
		call addRegion(370302,3703,"贡觉","gongjiao",0)
		call addRegion(370303,3703,"类乌齐","leiwuji",0)
		call addRegion(370304,3703,"丁青","dingqing",0)
		call addRegion(370305,3703,"察雅","chaya",0)
		call addRegion(370306,3703,"八宿","baqi",0)
		call addRegion(370307,3703,"左贡","zuogong",0)
		call addRegion(370308,3703,"芒康","huangkang",0)
		call addRegion(370309,3703,"洛隆","luolongx",0)
		call addRegion(370310,3703,"边坝","bianba",0)
		call addRegion(3704,37,"林芝","linzhi",1)
		call addRegion(370401,3704,"工布江达","gbjd",0)
		call addRegion(370402,3704,"米林","milin",0)
		call addRegion(370403,3704,"墨脱","motui",0)
		call addRegion(370404,3704,"波密","beimi",0)
		call addRegion(370405,3704,"察隅","chayu",0)
		call addRegion(370406,3704,"朗县","langxian",0)
		call addRegion(3705,37,"那曲","naqu",1)
		call addRegion(370501,3705,"嘉黎","jiali",0)
		call addRegion(370502,3705,"比如","biru",0)
		call addRegion(370503,3705,"聂荣","nierong",0)
		call addRegion(370504,3705,"安多","anche",0)
		call addRegion(370505,3705,"申扎","shenza",0)
		call addRegion(370506,3705,"索县","suoxian",0)
		call addRegion(370507,3705,"班戈","bange",0)
		call addRegion(370508,3705,"巴青","baqing",0)
		call addRegion(370509,3705,"尼玛","nima",0)
		call addRegion(3706,37,"日喀则","rikaze",1)
		call addRegion(370601,3706,"南木林","nanmulin",0)
		call addRegion(370602,3706,"江孜","jiangzi",0)
		call addRegion(370603,3706,"定日","dingri",0)
		call addRegion(370604,3706,"萨迦","sajia",0)
		call addRegion(370605,3706,"拉孜","lazi",0)
		call addRegion(370606,3706,"昂仁","angren",0)
		call addRegion(370607,3706,"谢通门","xietongmen",0)
		call addRegion(370608,3706,"白朗","bailang",0)
		call addRegion(370609,3706,"仁布","renbu",0)
		call addRegion(370610,3706,"康马","kangma",0)
		call addRegion(370611,3706,"定结","dingji",0)
		call addRegion(370612,3706,"仲巴","zhongba",0)
		call addRegion(370613,3706,"亚东","edong",0)
		call addRegion(370614,3706,"吉隆","jilong",0)
		call addRegion(370615,3706,"聂拉木","nielamu",0)
		call addRegion(370616,3706,"萨嘎","saga",0)
		call addRegion(370617,3706,"岗巴","gangba",0)
		call addRegion(3707,37,"山南","shannan",1)
		call addRegion(370701,3707,"乃东","aidong",0)
		call addRegion(370702,3707,"扎囊","zanang",0)
		call addRegion(370703,3707,"贡嘎","gongga",0)
		call addRegion(370704,3707,"桑日","sangri",0)
		call addRegion(370705,3707,"琼结","qiongji",0)
		call addRegion(370706,3707,"曲松","qusong",0)
		call addRegion(370707,3707,"措美","cimei",0)
		call addRegion(370708,3707,"洛扎","luoza",0)
		call addRegion(370709,3707,"加查","jiacha",0)
		call addRegion(370710,3707,"隆子","longzi",0)
		call addRegion(370711,3707,"错那","cuna",0)
		call addRegion(370712,3707,"浪卡子","langkazi",0)

		call addRegion(38,0,"新疆","xinjiang",1)
		call addRegion(3801,38,"乌鲁木齐","wlmq",1)
		call addRegion(380101,3801,"天山","tianshan",0)
		call addRegion(380102,3801,"沙依巴克","sybk",0)
		call addRegion(380103,3801,"新市","wlmqxs",0)
		call addRegion(380104,3801,"水磨沟","shuimogou",0)
		call addRegion(380105,3801,"头屯河","toutunhe",0)
		call addRegion(380106,3801,"达坂城","dabancheng",0)
		call addRegion(380107,3801,"东山","dongshanq",0)
		call addRegion(3802,38,"阿克苏","akesu",1)
		call addRegion(380201,3802,"温宿","wenqi",0)
		call addRegion(380202,3802,"库车","kuche",0)
		call addRegion(380203,3802,"沙雅","shaya",0)
		call addRegion(380204,3802,"新和","xinhexq",0)
		call addRegion(380205,3802,"拜城","baichengq",0)
		call addRegion(380206,3802,"乌什","wushen",0)
		call addRegion(380207,3802,"阿瓦提","awachi",0)
		call addRegion(380208,3802,"柯坪","keping",0)
		call addRegion(3803,38,"阿拉尔","alaer",0)
		call addRegion(3804,38,"阿勒泰","aletai",1)
		call addRegion(380401,3804,"布尔津","buerjin",0)
		call addRegion(380402,3804,"富蕴","fuwen",0)
		call addRegion(380403,3804,"福海","fuhai",0)
		call addRegion(380404,3804,"哈巴河","habahe",0)
		call addRegion(380405,3804,"青河","qinghex",0)
		call addRegion(380406,3804,"吉木乃","jimuai",0)
		call addRegion(3805,38,"巴音郭楞","bygl",1)
		call addRegion(380501,3805,"库尔勒","kuerle",0)
		call addRegion(380502,3805,"轮台","luntai",0)
		call addRegion(380503,3805,"尉犁","weili",0)
		call addRegion(380504,3805,"若羌","reqiang",0)
		call addRegion(380505,3805,"且末","cumo",0)
		call addRegion(380506,3805,"焉耆","yanqi",0)
		call addRegion(380507,3805,"和静","hejing",0)
		call addRegion(380508,3805,"和硕","heshuo",0)
		call addRegion(380509,3805,"博湖","bohu",0)
		call addRegion(3806,38,"博尔塔拉","betl",1)
		call addRegion(380601,3806,"博乐","bole",0)
		call addRegion(380602,3806,"精河","jinghequ",0)
		call addRegion(380603,3806,"温泉","wenquan",0)
		call addRegion(3807,38,"昌吉","changji",1)
		call addRegion(380701,3807,"阜康","fukang",0)
		call addRegion(380702,3807,"米泉","miquan",0)
		call addRegion(380703,3807,"呼图壁","hetubi",0)
		call addRegion(380704,3807,"玛纳斯","manashi",0)
		call addRegion(380705,3807,"奇台","aitai",0)
		call addRegion(380706,3807,"吉木萨尔","jmse",0)
		call addRegion(380707,3807,"木垒","mulei",0)
		call addRegion(3808,38,"哈密","hami",1)
		call addRegion(380801,3808,"巴里坤","balikun",0)
		call addRegion(380802,3808,"伊吾","yiwu",0)
		call addRegion(3809,38,"和田","hetian",1)
		call addRegion(380901,3809,"墨玉","moyu",0)
		call addRegion(380902,3809,"皮山","pishan",0)
		call addRegion(380903,3809,"洛浦","luopu",0)
		call addRegion(380904,3809,"策勒","cele",0)
		call addRegion(380905,3809,"于田","xutian",0)
		call addRegion(380906,3809,"民丰","minfeng",0)
		call addRegion(3810,38,"喀什","kashen",1)
		call addRegion(381001,3810,"疏附","shubu",0)
		call addRegion(381002,3810,"疏勒","shule",0)
		call addRegion(381003,3810,"英吉沙","yingjisha",0)
		call addRegion(381004,3810,"泽普","zepu",0)
		call addRegion(381005,3810,"莎车","shache",0)
		call addRegion(381006,3810,"叶城","xiecheng",0)
		call addRegion(381007,3810,"麦盖提","maigaichi",0)
		call addRegion(381008,3810,"岳普湖","yuepuhu",0)
		call addRegion(381009,3810,"伽师","gashi",0)
		call addRegion(381010,3810,"巴楚","bachu",0)
		call addRegion(381011,3810,"塔什库尔干塔吉克","tskegtjk",0)
		call addRegion(3811,38,"克拉玛依","klmy",1)
		call addRegion(381101,3811,"独山子","dushanzi",0)
		call addRegion(381102,3811,"白碱滩","baijianhan",0)
		call addRegion(381103,3811,"乌尔禾","wuerhe",0)
		call addRegion(3812,38,"克孜勒苏柯尔克孜","kzlskekz",1)
		call addRegion(381201,3812,"阿图什","atushen",0)
		call addRegion(381202,3812,"阿克陶","akedao",0)
		call addRegion(381203,3812,"阿合奇","ageai",0)
		call addRegion(381204,3812,"乌恰","wuqia",0)
		call addRegion(3813,38,"石河子","shihezi",0)
		call addRegion(3814,38,"塔城","tacheng",1)
		call addRegion(381401,3814,"乌苏","wusu",0)
		call addRegion(381402,3814,"额敏","emin",0)
		call addRegion(381403,3814,"沙湾","shawanq",0)
		call addRegion(381404,3814,"托里","tuoli",0)
		call addRegion(381405,3814,"裕民","yumin",0)
		call addRegion(381406,3814,"和布克赛尔","hbkse",0)
		call addRegion(3815,38,"图木舒克","tmsk",0)
		call addRegion(3816,38,"吐鲁番","tulubo",1)
		call addRegion(381601,3816,"鄯善","shanshan",0)
		call addRegion(381602,3816,"托克逊","tuokexun",0)
		call addRegion(3817,38,"五家渠","wujiaqu",0)
		call addRegion(3818,38,"伊犁","yili",1)
		call addRegion(381801,3818,"伊宁","yining",0)
		call addRegion(381802,3818,"奎屯","kuitun",0)
		call addRegion(381803,3818,"伊宁","yiningq",0)
		call addRegion(381804,3818,"察布查尔锡伯","cbcexb",0)
		call addRegion(381805,3818,"霍城","hechengq",0)
		call addRegion(381806,3818,"巩留","gongliu",0)
		call addRegion(381807,3818,"新源","xinyuan",0)
		call addRegion(381808,3818,"昭苏","zhaosu",0)
		call addRegion(381809,3818,"特克斯","keshi",0)
		call addRegion(381810,3818,"尼勒克","nileke",0)

		call addRegion(39,0,"云南","yunnan",1)
		call addRegion(3901,39,"昆明","hunmeng",1)
		call addRegion(390101,3901,"五华","wuhuaq",0)
		call addRegion(390102,3901,"盘龙","panlong",0)
		call addRegion(390103,3901,"官渡","guandu",0)
		call addRegion(390104,3901,"西山","xishan",0)
		call addRegion(390105,3901,"东川","dongchuan",0)
		call addRegion(390106,3901,"呈贡","chenggong",0)
		call addRegion(390107,3901,"晋宁","jinning",0)
		call addRegion(390108,3901,"富民","fumin",0)
		call addRegion(390109,3901,"宜良","yiliang",0)
		call addRegion(390110,3901,"石林","shilin",0)
		call addRegion(390111,3901,"嵩明","songmeng",0)
		call addRegion(390112,3901,"禄劝","luquanq",0)
		call addRegion(390113,3901,"寻甸","xindian",0)
		call addRegion(390114,3901,"安宁","anningq",0)
		call addRegion(3902,39,"保山","baoshan",1)
		call addRegion(390201,3902,"隆阳","longyang",0)
		call addRegion(390202,3902,"施甸","shidian",0)
		call addRegion(390203,3902,"腾冲","tengchong",0)
		call addRegion(390204,3902,"龙陵","longling",0)
		call addRegion(390205,3902,"昌宁","changningq",0)
		call addRegion(3903,39,"楚雄","chuxiong",1)
		call addRegion(390301,3903,"双柏","shuangbai",0)
		call addRegion(390302,3903,"牟定","maoding",0)
		call addRegion(390303,3903,"南华","nanhua",0)
		call addRegion(390304,3903,"姚安","taoan",0)
		call addRegion(390305,3903,"大姚","datao",0)
		call addRegion(390306,3903,"永仁","yongren",0)
		call addRegion(390307,3903,"元谋","yuanmou",0)
		call addRegion(390308,3903,"武定","wuding",0)
		call addRegion(390309,3903,"禄丰","lufeng",0)
		call addRegion(3904,39,"大理","dali",1)
		call addRegion(390401,3904,"漾濞","yangbi",0)
		call addRegion(390402,3904,"祥云","xiangyun",0)
		call addRegion(390403,3904,"宾川","binchuan",0)
		call addRegion(390404,3904,"弥渡","midu",0)
		call addRegion(390405,3904,"南涧","nanjian",0)
		call addRegion(390406,3904,"巍山","weishanx",0)
		call addRegion(390407,3904,"永平","yongping",0)
		call addRegion(390408,3904,"云龙","yunlongx",0)
		call addRegion(390409,3904,"洱源","eryuan",0)
		call addRegion(390410,3904,"剑川","jianchuan",0)
		call addRegion(390411,3904,"鹤庆","heqiang",0)
		call addRegion(3905,39,"德宏","dehong",1)
		call addRegion(390501,3905,"瑞丽","ruili",0)
		call addRegion(390502,3905,"潞西","luxix",0)
		call addRegion(390503,3905,"梁河","lianghe",0)
		call addRegion(390504,3905,"盈江","yingjiangx",0)
		call addRegion(390505,3905,"陇川","longchuanx",0)
		call addRegion(3906,39,"迪庆","diqiang",1)
		call addRegion(390601,3906,"香格里拉","xgll",0)
		call addRegion(390602,3906,"德钦","deqin",0)
		call addRegion(390603,3906,"维西","weixi",0)
		call addRegion(3907,39,"红河","honghe",1)
		call addRegion(390701,3907,"个旧","ganjiu",0)
		call addRegion(390702,3907,"开远","kaiyuanx",0)
		call addRegion(390703,3907,"蒙自","mengzi",0)
		call addRegion(390704,3907,"屏边","pingbian",0)
		call addRegion(390705,3907,"建水","jianshui",0)
		call addRegion(390706,3907,"石屏","shipingx",0)
		call addRegion(390707,3907,"弥勒","mile",0)
		call addRegion(390708,3907,"泸西","luxixian",0)
		call addRegion(390709,3907,"元阳","yuanyangx",0)
		call addRegion(390710,3907,"金平","hhjinping",0)
		call addRegion(390711,3907,"绿春","luchun",0)
		call addRegion(390712,3907,"河口","hekoux",0)
		call addRegion(3908,39,"丽江","lijiang",1)
		call addRegion(390801,3908,"古城","guchengqu",0)
		call addRegion(390802,3908,"玉龙","yulong",0)
		call addRegion(390803,3908,"永胜","yongqingqu",0)
		call addRegion(390804,3908,"华坪","huaping",0)
		call addRegion(390805,3908,"宁蒗","ninglang",0)
		call addRegion(3909,39,"临沧","lincang",1)
		call addRegion(390901,3909,"临翔","linxiangqu",0)
		call addRegion(390902,3909,"凤庆","fengqiang",0)
		call addRegion(390903,3909,"云县","lcyunxian",0)
		call addRegion(390904,3909,"永德","yongdex",0)
		call addRegion(390905,3909,"镇康","zhenkang",0)
		call addRegion(390906,3909,"双江","shuangjiang",0)
		call addRegion(390907,3909,"耿马","gengma",0)
		call addRegion(390908,3909,"沧源","cangyuan",0)
		call addRegion(3910,39,"怒江","nujiang",1)
		call addRegion(391001,3910,"泸水","lushui",0)
		call addRegion(391002,3910,"福贡","fugong",0)
		call addRegion(391003,3910,"贡山","gongshanx",0)
		call addRegion(391004,3910,"兰坪","lanping",0)
		call addRegion(3911,39,"曲靖","qujing",1)
		call addRegion(391101,3911,"麒麟","qilin",0)
		call addRegion(391102,3911,"马龙","malong",0)
		call addRegion(391103,3911,"陆良","liuliang",0)
		call addRegion(391104,3911,"师宗","shizongx",0)
		call addRegion(391105,3911,"罗平","luoping",0)
		call addRegion(391106,3911,"富源","fuyuanx",0)
		call addRegion(391107,3911,"会泽","huize",0)
		call addRegion(391108,3911,"沾益","chanyi",0)
		call addRegion(391109,3911,"宣威","xuanwei",0)
		call addRegion(3912,39,"思茅","saimao",1)
		call addRegion(391201,3912,"翠云","cuiyun",0)
		call addRegion(391202,3912,"普洱","puer",0)
		call addRegion(391203,3912,"墨江","mojiang",0)
		call addRegion(391204,3912,"景东","jingdong",0)
		call addRegion(391205,3912,"景谷","jinggu",0)
		call addRegion(391206,3912,"镇沅","zhenyuanq",0)
		call addRegion(391207,3912,"江城","jiangchengx",0)
		call addRegion(391208,3912,"孟连","menglian",0)
		call addRegion(391209,3912,"澜沧","lancang",0)
		call addRegion(391210,3912,"西盟","ximeng",0)
		call addRegion(3913,39,"文山","wenshan",1)
		call addRegion(391301,3913,"砚山","yanshanx",0)
		call addRegion(391302,3913,"西畴","xichou",0)
		call addRegion(391303,3913,"麻栗坡","malipo",0)
		call addRegion(391304,3913,"马关","maguan",0)
		call addRegion(391305,3913,"丘北","qiubei",0)
		call addRegion(391306,3913,"广南","guangnan",0)
		call addRegion(391307,3913,"富宁","funingx",0)
		call addRegion(3914,39,"西双版纳","xsbn",1)
		call addRegion(391401,3914,"景洪","jinghong",0)
		call addRegion(391402,3914,"勐海","menghai",0)
		call addRegion(391403,3914,"勐腊","mengla",0)
		call addRegion(3915,39,"玉溪","yuxi",1)
		call addRegion(391501,3915,"红塔","hongta",0)
		call addRegion(391502,3915,"江川","jiangchuan",0)
		call addRegion(391503,3915,"澄江","chengjiangx",0)
		call addRegion(391504,3915,"通海","tonghai",0)
		call addRegion(391505,3915,"华宁","huaning",0)
		call addRegion(391506,3915,"易门","yimen",0)
		call addRegion(391507,3915,"峨山","eshan",0)
		call addRegion(391508,3915,"新平","xinpingx",0)
		call addRegion(391509,3915,"元江","yuanjiangx",0)
		call addRegion(3916,39,"昭通","zhaotong",1)
		call addRegion(391601,3916,"昭阳","zhaoyang",0)
		call addRegion(391602,3916,"鲁甸","ludian",0)
		call addRegion(391603,3916,"巧家","qiaojia",0)
		call addRegion(391604,3916,"盐津","yanjinx",0)
		call addRegion(391605,3916,"大关","daguanx",0)
		call addRegion(391606,3916,"永善","yongshan",0)
		call addRegion(391607,3916,"绥江","ruijiang",0)
		call addRegion(391608,3916,"镇雄","zhenxiong",0)
		call addRegion(391609,3916,"彝良","yiliangx",0)
		call addRegion(391610,3916,"威信","weixin",0)
		call addRegion(391611,3916,"水富","shuifu",0)

		call addRegion(40,0,"浙江","zhejiang",1)
		call addRegion(4001,40,"杭州","hangzhou",1)
		call addRegion(400101,4001,"上城","zjsc",0)
		call addRegion(400102,4001,"下城","xiacheng",0)
		call addRegion(400103,4001,"江干","jianganqu",0)
		call addRegion(400104,4001,"拱墅","gongshu",0)
		call addRegion(400105,4001,"西湖","xihuqu",0)
		call addRegion(400106,4001,"滨江","binjiang",0)
		call addRegion(400107,4001,"萧山","xiaoshan",0)
		call addRegion(400108,4001,"余杭","tuhang",0)
		call addRegion(400109,4001,"桐庐","tonglu",0)
		call addRegion(400110,4001,"淳安","chunan",0)
		call addRegion(400111,4001,"建德","jiande",0)
		call addRegion(400112,4001,"富阳","fuyangqu",0)
		call addRegion(400113,4001,"临安","linan",0)
		call addRegion(4002,40,"湖州","huzhou",1)
		call addRegion(400201,4002,"吴兴","wuxin",0)
		call addRegion(400202,4002,"南浔","nanxun",0)
		call addRegion(400203,4002,"德清","deqing",0)
		call addRegion(400204,4002,"长兴","changxin",0)
		call addRegion(400205,4002,"安吉","anjix",0)
		call addRegion(4003,40,"嘉兴","jiaxin",1)
		call addRegion(400301,4003,"秀城","xiucheng",0)
		call addRegion(400302,4003,"秀洲","xiuzhou",0)
		call addRegion(400303,4003,"嘉善","jiashan",0)
		call addRegion(400304,4003,"海盐","haiyanqu",0)
		call addRegion(400305,4003,"海宁","haining",0)
		call addRegion(400306,4003,"平湖","pinghu",0)
		call addRegion(400307,4003,"桐乡","tongxiang",0)
		call addRegion(4004,40,"金华","jinhua",1)
		call addRegion(400401,4004,"婺城","moucheng",0)
		call addRegion(400402,4004,"金东","jindong",0)
		call addRegion(400403,4004,"武义","wuyix",0)
		call addRegion(400404,4004,"浦江","pujiang",0)
		call addRegion(400405,4004,"磐安","panan",0)
		call addRegion(400406,4004,"兰溪","lanxiz",0)
		call addRegion(400407,4004,"义乌","yiwuz",0)
		call addRegion(400408,4004,"东阳","dongyang",0)
		call addRegion(400409,4004,"永康","yongkang",0)
		call addRegion(4005,40,"丽水","lishuis",1)
		call addRegion(400501,4005,"莲都","liandou",0)
		call addRegion(400502,4005,"青田","qingtian",0)
		call addRegion(400503,4005,"缙云","jinyun",0)
		call addRegion(400504,4005,"遂昌","suichang",0)
		call addRegion(400505,4005,"松阳","songyang",0)
		call addRegion(400506,4005,"云和","yunheq",0)
		call addRegion(400507,4005,"庆元","qiangyuan",0)
		call addRegion(400508,4005,"景宁","jingningq",0)
		call addRegion(400509,4005,"龙泉","longquan",0)
		call addRegion(4006,40,"宁波","ningbei",1)
		call addRegion(400601,4006,"海曙","haishu",0)
		call addRegion(400602,4006,"江东","jiangdong",0)
		call addRegion(400603,4006,"江北","jiangbei",0)
		call addRegion(400604,4006,"北仑","beilun",0)
		call addRegion(400605,4006,"镇海","zhenhai",0)
		call addRegion(400606,4006,"鄞州","yinzhous",0)
		call addRegion(400607,4006,"象山","xiangshanx",0)
		call addRegion(400608,4006,"宁海","ninghai",0)
		call addRegion(400609,4006,"余姚","tutao",0)
		call addRegion(400610,4006,"慈溪","cixi",0)
		call addRegion(400611,4006,"奉化","fenghua",0)
		call addRegion(4007,40,"衢州","quzhou",1)
		call addRegion(400701,4007,"柯城","kecheng",0)
		call addRegion(400702,4007,"衢江","qujiangx",0)
		call addRegion(400703,4007,"常山","changshan",0)
		call addRegion(400704,4007,"开化","kaihua",0)
		call addRegion(400705,4007,"龙游","longliu",0)
		call addRegion(400706,4007,"江山","jiangshan",0)
		call addRegion(4008,40,"绍兴","chaoxin",1)
		call addRegion(400801,4008,"越城","huocheng",0)
		call addRegion(400802,4008,"新昌","xinchang",0)
		call addRegion(400803,4008,"诸暨","chuji",0)
		call addRegion(400804,4008,"上虞","shangyu",0)
		call addRegion(400805,4008,"嵊州","chengzhou",0)
		call addRegion(4009,40,"台州","taizhous",1)
		call addRegion(400901,4009,"椒江","jiaojiang",0)
		call addRegion(400902,4009,"黄岩","huangyan",0)
		call addRegion(400903,4009,"路桥","luqiao",0)
		call addRegion(400904,4009,"玉环","yuhuan",0)
		call addRegion(400905,4009,"三门","sanmen",0)
		call addRegion(400906,4009,"天台","tiantai",0)
		call addRegion(400907,4009,"仙居","xianji",0)
		call addRegion(400908,4009,"温岭","wenling",0)
		call addRegion(400909,4009,"临海","linhai",0)
		call addRegion(4010,40,"温州","wenzhou",1)
		call addRegion(401001,4010,"鹿城","luchengx",0)
		call addRegion(401002,4010,"龙湾","longwan",0)
		call addRegion(401003,4010,"瓯海","ouhai",0)
		call addRegion(401004,4010,"洞头","dongtou",0)
		call addRegion(401005,4010,"永嘉","yongjia",0)
		call addRegion(401006,4010,"平阳","pingyang",0)
		call addRegion(401007,4010,"苍南","cangnan",0)
		call addRegion(401008,4010,"文成","wencheng",0)
		call addRegion(401009,4010,"泰顺","taishun",0)
		call addRegion(401010,4010,"瑞安","ruian",0)
		call addRegion(401011,4010,"乐清","leqing",0)
		call addRegion(4011,40,"舟山","zhoushan",1)
		call addRegion(401101,4011,"定海","dinghai",0)
		call addRegion(401102,4011,"普陀","puduo",0)
		call addRegion(401103,4011,"岱山","daishan",0)
		call addRegion(401104,4011,"嵊泗","chengsi",0)
	end function
end class
%>