/*
    使用方法：
    $(function(){
        scrollbar(content);         
    });

    content:需要添加滚动条的盒子ID

    注意事项：
        1.需在该版块所属区域引入jquery.mousewheel.js,以及jsScroll.js  ，比如该版块属于ea_c,则在 ea_c 开始的地方引入    

        2.content盒子不设置高度，让高度自适应 

        3.样式表中必须加上以下默认样式：

        默认样式：
            .scrollbar-y{width: 1px;background: #ccc;}    
            .scrollbar-bg{background: #c40;width: 12px;}
            .xn_c_jsScroll_1_main{overflow:hidden;height:200px;} 外层默认高度

            .scrollbar-x{height: 12px;background: #ccc;}
            .scrollbar-x-bg{background: #c40;height: 12px;}
       
*/
function scrollbar(content,id){
    var $content = $("#"+content);

    //$content.wrap("<div class='xn_c_jsScroll_1_main' id='xn_c_jsScroll_1_main'></div>");

    var $main = $("#xn_c_jsScroll_1_main_" + id);

    //$main.wrap("<div class='xn_c_jsScroll_1_wrap' id='xn_c_jsScroll_1_wrap'></div>");

    var $out = $("#xn_c_jsScroll_1_wrap_"+ id);

    $out.css("position","relative").css("overflow","hidden");

    if($content.outerHeight(true) > $main.outerHeight(true)){//纵向滚动条：  
        if ($out.find("#scrollbar-y").length<=0) {
            $out.prepend(" <div class='scrollbar-y' id='scrollbar-y'></div><div class='scrollbar-bg'></div>");
        }
        var progress = $main.outerHeight(true) / $content.outerHeight(true);
        $("#scrollbar-y").css("height",$main.outerHeight(true))
                         .css("position","absolute")
                         .css("top","0px");

        $(".scrollbar-bg").css("height",parseInt(progress * $("#scrollbar-y").outerHeight(true)))
                          .css("position","absolute")
                          .css("top", "0px");
        
        if($(".scrollbar-bg").outerWidth(true) >  $("#scrollbar-y").outerWidth(true)){
            $("#scrollbar-y").css("right",($(".scrollbar-bg").outerWidth(true) - $("#scrollbar-y").outerWidth(true) ) / 2 + "px");
            $(".scrollbar-bg").css("right","0px");
            $out.css("padding-right",($(".scrollbar-bg").outerWidth(true) - $("#scrollbar-y").outerWidth(true) ) / 2 + "px");
        }else{
            $("#scrollbar-y").css("right",($("#scrollbar-y").outerWidth(true) - $(".scrollbar-bg").outerWidth(true)) / 2 + "px");
            $(".scrollbar-bg").css("right",$("#scrollbar-y").outerWidth(true)  / 2 + "px");
            $out.css("padding-right",( $("#scrollbar-y").outerWidth(true) - $(".scrollbar-bg").outerWidth(true)) / 2 + "px");
        }
        $main.scrollTop(0);
        var scroll_dis = $content.outerHeight(true) - $main.outerHeight(true); 

        var mouseX,mouseY;
        var dis ;

        //拖动滚动条
        $(".scrollbar-bg").unbind("mousedown").bind("mousedown", function (event) {
            event.preventDefault();
            event.stopPropagation();
            var _this = $(this);
            var mouseDownY = event.pageY;

            var start_dis = $(".scrollbar-bg").css("top");
            var startDistance = start_dis.split("px");
            var _start = parseInt(startDistance[0]);

            $(document).mousemove(function (event) {
                event.stopPropagation();
                dis = $(".scrollbar-bg").css("top");
                var distance = dis.split("px");
                var _top = parseInt(distance[0]);
                mouseY = event.pageY;
                if (mouseDownY < mouseY) { //向下滚动： 
                    if (_top < parseInt($("#scrollbar-y").outerHeight(true) - $(".scrollbar-bg").outerHeight(true))) {
                        $main.scrollTop(parseInt(mouseY - mouseDownY + _start) / progress);
                        $(".scrollbar-bg").css({ "top": parseInt(mouseY - mouseDownY + _start) });
                    } else {
                        $(".scrollbar-bg").css({ "top": parseInt($("#scrollbar-y").outerHeight(true) - $(".scrollbar-bg").outerHeight(true)) });
                        mouseDownY = mouseY - 2;
                        _start = parseInt($("#scrollbar-y").outerHeight(true) - $(".scrollbar-bg").outerHeight(true));
                    }

                } else {
                    //向上滚动： 
                    if (_top > 0) {
                        $(".scrollbar-bg").css({ "top": parseInt(_start - (mouseDownY - mouseY)) });
                        $main.scrollTop(parseInt(mouseY - mouseDownY + _start) / progress);
                    } else {
                        $(".scrollbar-bg").css({ "top": "0px" });
                        mouseDownY = mouseY + 2;
                        _start = 0;
                    }
                }
            });

        });       

        //鼠标松开，解除mousemove绑定
        $(document).bind("mouseup",function(event){
            event.stopPropagation();
            $(document).unbind("mousemove");
        });

        $(".scrollbar-bg").click(function(event){
            event.stopPropagation();
        });

        
        //点击滚动条，跳到相应位置：
        $("#scrollbar-y").click(function(event){
            var _this = $(this);
            var _thisY = _this.offset().top;
            var mouseY = event.pageY;
            var dis = parseInt( mouseY - _thisY );                 
            $main.scrollTop(dis); 
            mouseY - _thisY > $(".scrollbar-bg").outerHeight(true) ? $(".scrollbar-bg").css({"top": parseInt(dis - $(".scrollbar-bg").outerHeight(true))}): $(".scrollbar-bg").css({"top": dis});
        });                

        var interval = 10;
        var bg_top,bg_top_Arr,_top;
        function scrollTop(){ 
            bg_top = $(".scrollbar-bg").css("top")+"";  
            bg_top_Arr = bg_top.split("px");
            _top = parseInt(bg_top_Arr[0]); 
           
            if(_top < parseInt($("#scrollbar-y").outerHeight(true) - $(".scrollbar-bg").outerHeight(true))){
                _top += interval;        
                $(".scrollbar-bg").css("top",parseInt(_top));     
                $main.scrollTop(_top/progress - interval);
            }else{
                $(".scrollbar-bg").css("top", parseInt($("#scrollbar-y").outerHeight(true) - $(".scrollbar-bg").outerHeight(true)))
                $main.scrollTop(_top / progress - interval + 10);
            }
            
       }

        function scrollBottom(){  
            bg_top = $(".scrollbar-bg").css("top")+"";  
            bg_top_Arr = bg_top.split("px");
            _top = parseInt(bg_top_Arr[0]);             
           
            if(_top > 0){
                _top -=interval;
                $(".scrollbar-bg").css("top",parseInt(_top));
                $main.scrollTop(_top/progress + interval);
            }else{
                $(".scrollbar-bg").css("top","0px");
            }                    
        }

        //鼠标滚轮滚动：
        $main.mousewheel(function(event,delta){
            event.preventDefault(); 
            if(delta > 0){
                //滚轮向上：
                 scrollBottom();                
            }else{
                //滚轮向下： 
                 scrollTop();                
            }
        });
    }    

//    if($content.outerWidth(true) > $main.outerWidth(true)){//横向滚动条:  
//        var progress = $main.outerWidth(true) / $content.outerWidth(true);
//        $out.prepend(" <div class='scrollbar-x' id='scrollbar-x'></div><div class='scrollbar-x-bg' id='scrollbar-x-bg'></div>");
//        $("#scrollbar-x").css("position","absolute")
//                         .css("bottom","0px")
//                         .css("left","0px")
//                         .css("width",$main.outerWidth(true));
//        $("#scrollbar-x-bg").css("position","absolute")
//                         .css("bottom","0px")
//                         .css("left","0px")
//                         .css("width",parseInt(progress * $main.outerWidth(true)));

//        var dis;
//        $("#scrollbar-x-bg").bind("mousedown",function(event){
//            event.preventDefault();
//            event.stopPropagation(); 
//            var mouseDownX = event.pageX;
//            var start_dis= $(".scrollbar-x-bg").css("left");  
//            var startDistance = start_dis.split("px");                        
//            var _startLeft = parseInt(startDistance[0]);

//            $(document).bind("mousemove",function(event){
//                var mouseX = event.pageX;
//                dis= $(".scrollbar-x-bg").css("left");   
//                var distance = dis.split("px");     
//                var _left = parseInt(distance[0]);  

//                if(mouseX > mouseDownX){ //向右拖动:                    
//                    if(_left < parseInt($("#scrollbar-x").outerWidth(true) - $(".scrollbar-x-bg").outerWidth(true))){
//                        $main.scrollLeft(parseInt(mouseX - mouseDownX + _startLeft) / progress);
//                        $(".scrollbar-x-bg").css({"left": parseInt(mouseX - mouseDownX +_startLeft)}); 
//                    }else{
//                        $(".scrollbar-x-bg").css({"left":parseInt($("#scrollbar-x").outerWidth(true) - $(".scrollbar-x-bg").outerWidth(true))});
//                    }  

//                }else{ //向左拖动：
//                    if(_left > 0){
//                        $(".scrollbar-x-bg").css({"left": parseInt(_startLeft - (mouseDownX - mouseX ))}); 
//                        $main.scrollLeft(parseInt(mouseX - mouseDownX + _startLeft) / progress);
//                    } 
//                }
//            });
//        });    

//        $(document).bind("mouseup",function(event){
//            event.preventDefault();
//            $(document).unbind("mousemove");
//        });       

//        //点击滚动条，跳到相应位置：
//        $("#scrollbar-x").click(function(event){
//            var _this = $(this);
//            var _thisX = _this.offset().left;
//            var mouseX = event.pageX;
//            var dis = parseInt( mouseX - _thisX );                 
//            $main.scrollLeft(dis); 
//            mouseX - _thisX > $(".scrollbar-x-bg").outerWidth(true) ? $(".scrollbar-x-bg").css({"left": parseInt(dis - $(".scrollbar-x-bg").outerWidth(true))}): $(".scrollbar-x-bg").css({"left": dis});
//        });  

//    }        
}  