﻿<%@ webhandler Language="C#" class="Upload" %>
using System;
using System.Collections;
using System.Web;
using System.IO;
using System.Globalization;
using LitJson;
using System.Drawing;

public class Upload : IHttpHandler
{
	private HttpContext context;

	public void ProcessRequest(HttpContext context)
	{
		//String aspxUrl = context.Request.Path.Substring(0, context.Request.Path.LastIndexOf("/") + 1);
		
		//文件保存目录路径
        String savePath = "/uploads/";

		//文件保存目录URL
		//String saveUrl = aspxUrl + "../attached/";
        String saveUrl = "/uploads/";

		//定义允许上传的文件扩展名
		Hashtable extTable = new Hashtable();
		extTable.Add("image", "gif,jpg,jpeg,png,bmp");
		extTable.Add("flash", "swf,flv");
		extTable.Add("media", "swf,flv,mp3,wav,wma,wmv,mid,avi,mpg,asf,rm,rmvb");
		extTable.Add("file", "doc,docx,xls,xlsx,ppt,htm,html,txt,zip,rar,gz,bz2");

		//最大文件大小
		this.context = context;

        HttpPostedFile imgFile = context.Request.Files["Filedata"];
		if (imgFile == null)
		{
            context.Response.Write("{\"status\": 0, \"msg\": \"请选择文件！\"}");
            context.Response.End();
		}

		String dirPath = context.Server.MapPath(savePath);
		if (!Directory.Exists(dirPath))
		{
            context.Response.Write("{\"status\": 0, \"msg\": \"上传目录不存在！\"}");
            context.Response.End();
		}

		String dirName = context.Request.QueryString["dir"];
		if (String.IsNullOrEmpty(dirName)) {
			dirName = "image";
		}
		if (!extTable.ContainsKey(dirName)) {
            context.Response.Write("{\"status\": 0, \"msg\": \"目录名不正确！\"}");
            context.Response.End();
		}
        int fileSize = imgFile.ContentLength; //获得文件大小，以字节为单位
		String fileName = imgFile.FileName;
		String fileExt = Path.GetExtension(fileName).ToLower();
        int maxSize = 10000000;
        if (dirName == "image")
        {
            if (!int.TryParse(Tmpl.get_configs(29), out maxSize))
            {
                context.Response.Write("{\"status\": 0, \"msg\": \"网站设置-图片大小上限 参数设置不是数字，请重新设置！\"}");
                context.Response.End();
            }
            maxSize *= 1024;
        }
        else
        {
            if (!int.TryParse(Tmpl.get_configs(39), out maxSize))
            {
                context.Response.Write("{\"status\": 0, \"msg\": \"网站设置-附件大小上限 参数设置不是数字，请重新设置！\"}");
                context.Response.End();
            }
            maxSize *= (1024 * 1024);
        }
        
		if (imgFile.InputStream == null || imgFile.InputStream.Length > maxSize)
		{
			
            context.Response.Write("{\"status\": 0, \"msg\": \"文件超过限制的大小！\"}");
            context.Response.End();
		}

		if (String.IsNullOrEmpty(fileExt) || Array.IndexOf(((String)extTable[dirName]).Split(','), fileExt.Substring(1).ToLower()) == -1)
		{
			showError("上传文件扩展名是不允许的扩展名。\n只允许" + ((String)extTable[dirName]) + "格式。");
            context.Response.Write("{\"status\": 0, \"msg\": \"上传文件扩展名是不允许的扩展名。\n只允许\" + ((String)extTable[dirName]) + \"格式。\"}");
            context.Response.End();
		}

		//创建文件夹
		dirPath += dirName + "/";
		saveUrl += dirName + "/";
		if (!Directory.Exists(dirPath)) {
			Directory.CreateDirectory(dirPath);
		}
		String ymd = DateTime.Now.ToString("yyyyMMdd", DateTimeFormatInfo.InvariantInfo);
		dirPath += ymd + "/";
		saveUrl += ymd + "/";
		if (!Directory.Exists(dirPath)) {
			Directory.CreateDirectory(dirPath);
		}

		String newFileName = DateTime.Now.ToString("yyyyMMddHHmmss_ffff", DateTimeFormatInfo.InvariantInfo) + fileExt;
        String thumb_newFileName = "thumb_"+DateTime.Now.ToString("yyyyMMddHHmmss_ffff", DateTimeFormatInfo.InvariantInfo) + fileExt;
		String filePath = dirPath + newFileName;
        imgFile.SaveAs(filePath);
        //做判断，如果是图片则生成缩略图

       // WaterMark.CreateThumbnailImage(saveUrl + newFileName, dirPath + thumb_newFileName, int.Parse(Tmpl.get_configs(51)), int.Parse(Tmpl.get_configs(52)));
        string isshuyin = Tmpl.get_configs(26);
        if (isshuyin != "1")
        {
            WaterMark.GetPicThumbnail(saveUrl + newFileName, dirPath + thumb_newFileName, int.Parse(Tmpl.get_configs(52)), int.Parse(Tmpl.get_configs(51)), int.Parse(Tmpl.get_configs(48)));
        }
        if (isshuyin == "1")
        {            
            //判断图片是否符合条件
            Image imageSaved = Bitmap.FromFile(filePath);
            int minWidth, minHeight;
            if (!int.TryParse(Tmpl.get_configs(41), out minWidth))
            {
                context.Response.Write("{\"status\": 0, \"msg\": \"打水印图片宽度设置不正确,请重新设置!！\"}");
                context.Response.End();
            }
            if(!int.TryParse(Tmpl.get_configs(42), out minHeight))
            {
                context.Response.Write("{\"status\": 0, \"msg\": \"打水印图片高度设置不正确,请重新设置!\"}");
                context.Response.End();
            }
            if (minWidth <= imageSaved.Width && minHeight <= imageSaved.Height)
            {
                //添加水印                
                newFileName = "wt_" + newFileName;  
                string fileNewPath = dirPath + newFileName;
                string waterMarkPath = context.Server.MapPath(Tmpl.get_configs(25));
                int posiation, pellucidity, quality;
                if (!int.TryParse(Tmpl.get_configs(46), out posiation))
                {
                    context.Response.Write("{\"status\": 0, \"msg\": \"水印图片位置设置不正确,请重新设置!\"}");
                    context.Response.End();
                }
                if (!int.TryParse(Tmpl.get_configs(47), out pellucidity))
                {
                    context.Response.Write("{\"status\": 0, \"msg\": \"水印图片透明度设置不正确,请重新设置!\"}");
                    context.Response.End();
                }
                if (!int.TryParse(Tmpl.get_configs(48), out quality))
                {
                    context.Response.Write("{\"status\": 0, \"msg\": \"水印图片质量设置不正确,请重新设置!\"}");
                    context.Response.End();
                }
                WaterMark.AddImageSignPic(filePath, fileNewPath, waterMarkPath, posiation, quality, pellucidity);
                WaterMark.GetPicThumbnail(saveUrl + newFileName, dirPath + thumb_newFileName, int.Parse(Tmpl.get_configs(52)), int.Parse(Tmpl.get_configs(51)), quality);
            }            
        }
        
		String fileUrl = saveUrl + newFileName;

        //Hashtable hash = new Hashtable();
        //hash["error"] = 0;
        //hash["url"] = fileUrl;
        //context.Response.AddHeader("Content-Type", "text/html; charset=UTF-8");
        //context.Response.Write(JsonMapper.ToJson(hash));

        context.Response.Write("{\"status\": 1, \"msg\": \"上传文件成功！\", \"name\": \""
                    + fileName + "\", \"path\": \"" + fileUrl + "\", \"thumb\": \""
                    + saveUrl+thumb_newFileName + "\", \"size\": " + fileSize + ", \"ext\": \"" + fileExt + "\"}");
		context.Response.End();
	}

	private void showError(string message)
	{
		Hashtable hash = new Hashtable();
		hash["error"] = 1;
		hash["message"] = message;
		context.Response.AddHeader("Content-Type", "text/html; charset=UTF-8");
		context.Response.Write(JsonMapper.ToJson(hash));
		context.Response.End();
	}

	public bool IsReusable
	{
		get
		{
			return true;
		}
	}
}
