﻿<%
class ActionXML
	private sub Class_Initialize()
	
	end sub
	public sub index
		Mo.Assign "title","XML操作演示"
		Mo.display "home:top"
		F.echo "<h3>XML操作演示：</h3>"

		'引用XML类库
		Mo.Use "XML"

		'使用一段xml代码初始化XML对象
		set xml = MoLibXML.Load("<xml><select>文本</select><user name=""aien""/><information/></xml>")

		'如果XML对象的root为null，则XML初始化失败
		if not isnull(xml.root) then
			'select方法选取节点，仅选取单节点，参数支持xpath，节点对象以及节点队列索引
			'text方法，如果不传递任何参数，则获取文本，否则，设置文本；
			'attr方法，如果不设置第二个参数，则获取属性值，否则，设置属性值；
			xml.select("select").text("文本123456").attr "id","myid"
			xml.select("user").attr "age","23"

			'append方法，为select的节点附加子节点；如果附加为单节点，则切换select节点为新附加的节点
			xml.select("//").append "testnode","testvalue"
			
			'append方法的第二个参数如果为vbs数组或jscript数组，则为当前select的节点附加一系列节点，节点名为第一个参数，值为数组项的值
			xml.select("//").append "arraylist"
			xml.append "list",F.json("[1,2,3,4]")
			xml.append "list",array(5,6,7,8)

			F.echo "<h4>循环读取arraylist的list元素：</h4>"

			'nodes方法选择多个节点，并返回一个对象，用来循环已选择的节点，参数为xpath
			set chd = xml.nodes("//arraylist/list")
			do while not chd.eof()
				'这里就是直接将一个节点对象作为select的参数，使用next读取下一个节点
				xml.select chd.next()
				'name方法返回节点名称
				F.echo xml.name() & " = " & xml.text(),true
			loop

			'comment方法，为节点附加注释
			'CDATA方法，为节点附加CDATA文本
			xml.select("user").comment("注释").CDATA "CDATA文本"


			'分别构造一个diction对象和json键值对象
			set dict = F.activex("scripting.dictionary")
			dict("dict")="dictionary"
			set json = F.json("{""name"":""anlige"",""age"":23}")

			'append的第三种用法，直接附加一个dictionary对象或json对象
			xml.select("information").append json
			xml.append dict

			'select支持几个伪类（:parent,:children,:first,:last），分别有对应的重载方法
			'select(xxx:伪类)，是对select的重载，等效于:select(xxx).select(:伪类)
			xml.select("information:first").attr "id","firstchild"
			xml.select("information:last").attr "id","lastchild"

			'这里选取子元素，等效于：xml.select("information").select(":children")或xml.select("information").children()
			F.echo "<h4>循环读取information的子元素：</h4>"
			set chd = xml.select("information:children")
			do while not chd.eof()
				xml.select chd.next()
				F.echo xml.name() & " = " & xml.text(),true
			loop

			'select的第三种用法，0代表根元素。每次调用select方法后，都可以通过XML.index()方法获取当前select的节点的索引。
			xml.select(0).last().attr "id","lastchild"
			F.echo "<h4>最终生成的XML：</h4>"

			'XML.DOM对象是原生的DomDocument对象，可以使用其一切方法
			F.echo F.encodeHTML(xml.DOM.xml)
		else
			F.echo "XML加载失败"
		end if
		F.echo "<h4>加载本地XML文件，应用过滤器：</h4>"
		set xml = MoLibXML.Load(F.mappath(MO_APP & "Data/rss_7.xml"))
		if not isnull(xml.root) then
			set chd = xml.select("channel").children("item").filter(":even")
			do while not chd.eof()
				set n = chd.next()
				F.echo "title = " & xml.select("title",n).text(),true
				F.echo "author = " & xml.select("author",n).text(),true
			loop
		else
			F.echo "XML加载失败"
		end if
		Mo.display "foot"
	end sub
	public sub [empty](a)
		F.echo "默认页面：" & a
	end sub
end class
%>