<%
'=========================================================
 'Class: AnUpLoad
 'Author: Anlige
 'Version:AienAspUpload V13.12.09
 'CreationDate: 2008-04-12
 'ModificationDate: 2013-12-09
 'Homepage: http://dev.mo.cn
 'Email: zhanghuiguoanlige@126.com
 'QQ: 1034555083
 'Modified By: ֮
 'ModificationDate: 2021-02-22
'=========================================================
Dim StreamT
Class AnUpLoad
	Private Form, Fils
	Private vCharSet, vMaxSize, vSingleSize, vErr, vVersion, vTotalSize, vExe, vErrExe,vboundary, vLostTime, vMode, vFileCount,StreamOpened
	private vMuti,vServerVersion
	Public Property Let Mode(ByVal value)
		vMode = value
	End Property

	Public Property Let MaxSize(ByVal value)
		vMaxSize = value
	End Property

	Public Property Let SingleSize(ByVal value)
		vSingleSize = value
	End Property

	Public Property Let Exe(ByVal value)
		vExe = Lcase(value)
		vExe = Replace(vExe, "*.", "")
		vExe = Replace(vExe, ";", "|")
	End Property

	Public Property Let CharSet(ByVal value)
		vCharSet = value
	End Property

	Public Property Get ErrorID()
		ErrorID = vErr
	End Property

	Public Property Get FileCount()
		FileCount = Fils.count
	End Property

	Public Property Get Description()
		Description = GetErr(vErr)
	End Property

	Public Property Get Version()
		Version = vVersion
	End Property

	Public Property Get TotalSize()
		TotalSize = vTotalSize
	End Property

	Public Property Get LostTime()
		LostTime = vLostTime
	End Property

	Private Sub Class_Initialize()
		set Form = Server.CreateObject("Scripting.Dictionary")
		set Fils = Server.CreateObject("Scripting.Dictionary")
		Set StreamT = Server.CreateObject("Adodb.stream")
		vVersion = "AienAspUpload V13.12.09"
		vMaxSize = -1
		vSingleSize = -1
		vErr = -1
		vExe = ""
		vTotalSize = 0
		vCharSet = "gb2312"
		vMode = 0
		StreamOpened = False
		vMuti = "_" & Getname() & "_"
		vServerVersion = 6.0
		Dim t_
		t_ = Lcase(Request.ServerVariables("SERVER_SOFTWARE"))
		t_ = Replace(t_, "microsoft-iis/", "")
		IF IsNumeric(t_) Then vServerVersion = cdbl(t_)
	End Sub

	Private Sub Class_Terminate()
		Dim f
		Form.RemoveAll()
		For each f in Fils
			Fils(f).value = Empty
			Set Fils(f) = Nothing
		Next
		Fils.RemoveAll()
		Set Form = Nothing
		Set Fils = Nothing
		IF StreamOpened Then StreamT.close()
		Set StreamT = Nothing
	End Sub

	Public Sub GetData()
		Dim time1
		time1 = timer()
		Dim value, str, bcrlf, fpos, sSplit, slen, istart,ef
		Dim TotalBytes, tempdata, BytesRead, ChunkReadSize, PartSize, DataPart, formend, formhead, startpos, endpos, formname, FileName, fileExe, valueend, NewName, localname, type_1,contentType
		TotalBytes = Request.TotalBytes
		ef = False
		IF checkEntryType = False Then ef = True : vErr = 2
		IF vServerVersion >= 6 Then
			IF Not ef Then
				IF vMaxSize > 0 And TotalBytes > vMaxSize Then ef = True : vErr = 1
			End IF
		End IF
		IF ef Then Exit Sub
		IF vMode = 0 Then
			vTotalSize = 0
			StreamT.Type = 1
			StreamT.Mode = 3
			StreamT.Open
			StreamOpened = True
			BytesRead = 0
			ChunkReadSize = 1024 * 16
			Do While BytesRead < TotalBytes
				PartSize = ChunkReadSize
				IF PartSize + BytesRead > TotalBytes Then PartSize = TotalBytes - BytesRead
				DataPart = Request.BinaryRead(PartSize)
				StreamT.Write DataPart
				BytesRead = BytesRead + PartSize
			Loop
			StreamT.Position = 0
			tempdata = StreamT.Read
		Else
			tempdata = Request.BinaryRead(TotalBytes)
		End IF
		bcrlf = ChrB(13) & ChrB(10)
		fpos = InStrB(1, tempdata, bcrlf)
		sSplit = MidB(tempdata, 1, fpos - 1)
		slen = LenB(sSplit)
		istart = slen + 2
		Do
			formend = InStrB(istart, tempdata, bcrlf & bcrlf)
			IF formend <= 0 Then Exit Do
			formhead = MidB(tempdata, istart, formend - istart)
			str = Bytes2Str(formhead)
			startpos = Instr(str, "name=""") + 6
			IF startpos <= 0 Then Exit Do
			endpos = Instr(startpos, str, """")
			IF endpos <= 0 Then Exit Do
			formname = Lcase(Mid(str, startpos, endpos - startpos))
			valueend = InStrB(formend + 3, tempdata, sSplit)
			IF valueend <= 0 Then Exit Do
			IF Instr(str, "filename=""") > 0 Then
				formname = formname & vMuti & "0"
				startpos = Instr(str, "filename=""") + 10
				endpos = Instr(startpos, str, """")
				type_1 = Instr(endpos, Lcase(str), "content-type")
				contentType = Trim(Mid(str, type_1 + 13))
				FileName = Mid(str, startpos, endpos - startpos)
				IF Trim(FileName) <> "" Then
					FileName = Replace(FileName, "/", "\")
					FileName = Replace(FileName, chr(0), "")
					LocalName = FileName
					FileName = Mid(FileName, InStrRev(FileName, "\") + 1)
					IF Instr(FileName, ".") > 0 Then
						fileExe = Split(FileName, ".")(Ubound(Split(FileName, ".")))
					Else
						fileExe = ""
					End IF
					IF vExe <> "" Then
						IF checkExe(fileExe) = True Then
							vErr = 3
							vErrExe = fileExe
							tempdata = Empty
							Exit Sub
						End IF
					End IF
					NewName = Getname()
					NewName = NewName & "." & fileExe
					vTotalSize = vTotalSize + valueend - formend - 6
					IF vSingleSize > 0 And (valueend - formend - 6) > vSingleSize Then
						vErr = 5
						tempdata = Empty
						Exit Sub
					End IF
					IF vMaxSize > 0 And vTotalSize > vMaxSize Then
						vErr = 1
						tempdata = Empty
						Exit Sub
					End IF
					IF Fils.Exists(formname) Then formname = GetNextFormName(formname)
					Dim fileCls:set fileCls = new UploadFileEx
					fileCls.ContentType = contentType
					fileCls.Size = (valueend - formend - 6)
					fileCls.Position = (formend + 3)
					fileCls.FormName = formname
					fileCls.NewName = NewName
					fileCls.FileName = FileName
					fileCls.LocalName = FileName
					fileCls.extend = Split(NewName, ".")(Ubound(Split(NewName, ".")))
					Fils.Add formname, fileCls
					Set fileCls = Nothing
				End IF
			Else
				value = MidB(tempdata, formend + 4, valueend - formend - 6)
				IF Form.Exists(formname) Then
					Form(formname) = Form(formname) & "," & Bytes2Str(value)
				Else
					Form.Add formname, Bytes2Str(value)
				End IF
			End IF
			istart = valueend + 2 + slen
		Loop Until (istart + 2) >= LenB(tempdata)
		vErr = 0
		tempdata = Empty
		vLostTime = FormatNumber((timer - time1) * 1000, 2)
	End Sub

	Private Function CheckExe(ByVal ex)
		Dim notIn: notIn = True
		IF vExe = "*" Then
			notIn = False
		ElseIF Instr(1, vExe, "|") > 0 Then
			Dim tempExe: tempExe = Split(vExe, "|")
			Dim I: I = 0
			For I = 0 To Ubound(tempExe)
				IF Lcase(ex) = tempExe(I) Then
					notIn = False
					Exit For
				End IF
			Next
		Else
			IF vExe = Lcase(ex) Then
				notIn = False
			End IF
		End IF
		checkExe = notIn
	End Function

	Public Function GetSize(ByVal Size)
		IF Size < 1024 Then
			GetSize = FormatNumber(Size, 2) & "B"
		ElseIF Size >= 1024 And Size < 1048576 Then
			GetSize = FormatNumber(Size / 1024, 2) & "KB"
		ElseIF Size >= 1048576 Then
			GetSize = FormatNumber((Size / 1024) / 1024, 2) & "MB"
		End IF
	End Function

	Private Function Bytes2Str(ByVal byt)
		IF LenB(byt) = 0 Then
			Bytes2Str = ""
			Exit Function
		End IF
		Dim mystream, bstr
		Set mystream =Server.CreateObject("ADODB.Stream")
		mystream.Type = 2
		mystream.Mode = 3
		mystream.Open
		mystream.WriteText byt
		mystream.Position = 0
		mystream.CharSet = vCharSet
		mystream.Position = 2
		bstr = mystream.ReadText()
		mystream.Close
		Set mystream = Nothing
		Bytes2Str = bstr
	End Function

	Private Function GetErr(ByVal Num)
		Select Case Num
			Case 0
				GetErr = "TEST_OK!COMPLETE!"
			Case 1
				GetErr = LingFengNet_MS_language_upload_3 & GetSize(vMaxSize)
			Case 2
				GetErr = "ERROR_INVALID_ENCTYPEOR_METHOD"
			Case 3
				GetErr = LingFengNet_MS_language_upload_2 & "(." & ucase(vErrExe) & ")"
			Case 5
				GetErr = LingFengNet_MS_language_upload_3 & GetSize(vSingleSize)
		End Select
	End Function

	Private Function Getname()
		Dim y, m, d, h, mm, S, r
		Randomize
		y = Year(Now)
		m = right("0" & Month(Now),2)
		d = right("0" & Day(Now),2)
		h = right("0" & Hour(Now),2)
		mm =right("0" & Minute(Now),2)
		S = right("0" & Second(Now),2)
		r = Cint(Rnd() * 10000)
		r = right("0000" & r,4)
		Getname = y & m & d & h & mm & S & r
	End Function

	Private Function checkEntryType()
		Dim ContentType, ctArray, bArray,RequestMethod
		RequestMethod = Trim(Lcase(Request.ServerVariables("REQUEST_METHOD")))
		IF RequestMethod="" or RequestMethod<>"post" Then
			checkEntryType = False
			exit function
		End IF
		ContentType = Lcase(Request.ServerVariables("HTTP_CONTENT_TYPE"))
		ctArray = Split(ContentType, ";")
		IF Ubound(ctarray) >= 0 Then
			IF Trim(ctArray(0)) = "multipart/form-data" Then
				checkEntryType = True
				vboundary = Split(ContentType,"boundary=")(1)
			Else
				checkEntryType = False
			End IF
		Else
			checkEntryType = False
		End IF
	End Function

	Public Function Forms(ByVal formname)
		IF Trim(formname) = "-1" Then
			Set Forms = Form
		Else
			IF Form.Exists(Lcase(formname)) Then
				Forms = Form(Lcase(formname))
			Else
				Forms = ""
			End IF
		End IF
	End Function

	Public Function Files(ByVal formname)
		IF Trim(formname) = "-1" Then
			Set Files = Fils
		Else
			dim vname
			vname = Lcase(formname) & vMuti & "0"
			IF Instr(formname,vMuti) > 0 Then vname = formname
			IF Fils.Exists(vname) Then
				Set Files = Fils(vname)
			Else
				Set Files = New UploadFileEmpty
			End IF
		End IF
	End Function

	Public Function Files_Muti(ByVal formname,byval index)
		IF Trim(formname) = "-1" Then
			Set Files_Muti = Fils
		Else
			IF Fils.Exists(Lcase(formname) & vMuti & index) Then
				Set Files_Muti = Fils(Lcase(formname) & vMuti & index)
			Else
				Set Files_Muti = New UploadFileEmpty
			End IF
		End IF
	End Function


	Public Function QuickSave(ByVal formname,Byval SavePath)
		Dim v, formStart, File, Result, SucceedCount
		SucceedCount = 0
		Dim TempFormName
		TempFormName = formname & vMuti
		For Each v In Fils
			IF Lcase(Left(v, Len(TempFormName))) = Lcase(TempFormName) Then
				Set File = Fils(v)
				Result = File.saveToFile(SavePath, 0, True)
				IF Result Then SucceedCount = SucceedCount + 1
				'Set File=Nothing
			End IF
		Next
		QuickSave = SucceedCount
	End Function


	Private Function GetNextFormName(byval formname)
		Dim formStart,currentIndex
		formStart = Left(formname, Instr(formname,vMuti) + Len(vMuti)-1)
		currentIndex = Mid(formname, Instr(formname,vMuti) + Len(vMuti))
		currentIndex = Cint(currentIndex)
		Do While Fils.Exists(formname)
			currentIndex = currentIndex + 1
			formname = formStart & currentIndex
		Loop
		GetNextFormName = formname
	End Function
End Class
Class UploadFileEmpty
	Public Property Get IsFile()
		IsFile = False
	End Property
End Class
Class UploadFileEx
	Private mvarFormName , mvarNewName , mvarLocalName , mvarFileName , mvarUserSetName , mvarContentType ,mException,mvarPosition
	Private mvarSize , mvarValue , mvarPath , mvarExtend

	Public Property Let Extend(ByVal vData )
		mvarExtend = vData
	End Property
	Public Property Get Extend()
		Extend = mvarExtend
	End Property

	Public Property Get IsFile()
		IsFile = True
	End Property

	Public Property Let Path(ByVal vData )
		mvarPath = vData
	End Property
	Public Property Get Path()
		Path = mvarPath
	End Property

	Public Property Get Exception()
		Exception = mException
	End Property

	Public Property Let Value(ByVal vData )
		mvarValue = vData
	End Property

	Public Property Get Value()
		Value = mvarValue
	End Property

	Public Property Let Size(ByVal vData )
		mvarSize = vData
	End Property
	Public Property Get Size()
		Size = mvarSize
	End Property

	Public Property Let Position(ByVal vData )
		mvarPosition = vData
	End Property
	Public Property Get Position()
		Size = mvarPosition
	End Property

	Public Property Let ContentType(ByVal vData )
		mvarContentType = vData
	End Property
	Public Property Get ContentType()
		ContentType = mvarContentType
	End Property

	Public Property Let UserSetName(ByVal vData )
		mvarUserSetName = vData
	End Property
	Public Property Get UserSetName()
		UserSetName = mvarUserSetName
	End Property

	Public Property Let FileName(ByVal vData )
		mvarFileName = vData
	End Property
	Public Property Get FileName()
		FileName = mvarFileName
	End Property

	Public Property Let LocalName(ByVal vData )
		mvarLocalName = vData
	End Property
	Public Property Get LocalName()
		LocalName = mvarLocalName
	End Property

	Public Property Let NewName(ByVal vData )
		mvarNewName = vData
	End Property
	Public Property Get NewName()
		NewName = mvarNewName
	End Property

	Public Property Let FormName(ByVal vData )
		mvarFormName = vData
	End Property
	Public Property Get FormName()
		FormName = mvarFormName
	End Property

	Private Sub Class_Initialize()
		mvarSize = 0
		mvarFormName = ""
	End Sub

	Public Function SaveToFile(ByVal Path , byval tOption, byval OverWrite)
		On Error Resume Next
		Dim IsP
		IsP = (Instr(Path, ":") = 2)
		IF Not IsP Then Path = Server.MapPath(Path)
		Path = Replace(Path, "/", "\")
		IF Mid(Path, Len(Path) - 1) <> "\" Then Path = Path + "\"
		CreateFolder Path
		mvarPath = Path
		IF tOption = 1 Then
			Path = Path & mvarLocalName: mvarFileName = mvarLocalName
		Else
			IF tOption = -1 And mvarUserSetName <> "" Then
				Path = Path & mvarUserSetName & "." & mvarExtend: mvarFileName = mvarUserSetName & "." & mvarExtend
			Else
				Path = Path & mvarNewName: mvarFileName = mvarNewName
			End IF
		End IF
		IF Not OverWrite Then
			Path = GetFilePath()
		End IF
		Dim tmpStrm
		Set tmpStrm = Server.CreateObject("ADODB.Stream")
		tmpStrm.Mode = 3
		tmpStrm.Type = 1
		tmpStrm.Open
		StreamT.Position = mvarPosition
		StreamT.copyto tmpStrm,mvarSize
		tmpStrm.SaveToFile Path, 2
		tmpStrm.Close
		Set tmpStrm = Nothing
		'Set SaveToFile = new ErrorMessage_
		IF Not Err Then
			SaveToFile = True
		Else
			SaveToFile = False
			mException = Err.Description
		End IF
	End Function
	Public Function GetBytes()
		StreamT.Position = mvarPosition
		GetBytes = StreamT.read(mvarSize)
	End Function
	Private Function CreateFolder(ByVal folderPath )
		Dim oFSO
		Set oFSO = Server.CreateObject("Scripting.FileSystemObject")
		Dim sParent
		sParent = oFSO.GetParentFolderName(folderPath)
		IF sParent = "" Then Exit Function
		IF Not oFSO.FolderExists(sParent) Then CreateFolder (sParent)
		IF Not oFSO.FolderExists(folderPath) Then oFSO.CreateFolder (folderPath)
		Set oFSO = Nothing
	End Function

	Private Function GetFilePath()
		Dim oFSO, Fname , FNameL , i
		i = 0
		Set oFSO = Server.CreateObject("Scripting.FileSystemObject")
		Fname = mvarPath & mvarFileName
		FNameL = Mid(mvarFileName, 1, Instr(mvarFileName, ".") - 1)
		Do While oFSO.FileExists(Fname)
			Fname = mvarPath & FNameL & "(" & i & ")." & mvarExtend
			mvarFileName = FNameL & "(" & i & ")." & mvarExtend
			i = i + 1
		Loop
		Set oFSO = Nothing
		GetFilePath = Fname
	End Function
End Class
%>