$.format = function (source, params) 
{
	if (arguments.length == 1)
	return function () {
	var args = $.makeArray(arguments);
	args.unshift(source);
	return $.format.apply(this, args);
	};
	if (arguments.length > 2 && params.constructor != Array) {
	params = $.makeArray(arguments).slice(1);
	}
	if (params.constructor != Array) {
	params = [params];
	}
	$.each(params, function (i, n) {
	source = source.replace(new RegExp("\\{" + i + "\\}", "g"), n);
	});
	return source;
}; 

function StringToDate(string)
{
	return new Date(Date.parse(string.replace(/-/g, "/")));
}
 
/**
* 计算两日期时间差
* @param {} interval 计算类型：D是按照天、H是按照小时、M是按照分钟、S是按照秒、T是按照毫秒
* @param {} date1 起始日期
* @param {} date2 结束日期
*/
function countTimeLength(interval, date1, date2)
{
	var objInterval = {'D' : 1000 * 60 * 60 * 24, 'H' : 1000 * 60 * 60, 'M' : 1000 * 60, 'S' : 1000, 'T' : 1};
	interval = interval.toUpperCase();
	var dt1 = Date.parse(StringToDate(date1));
	var dt2 = Date.parse(StringToDate(date2));
	try
	{
	//return (((dt2 - dt1) / objInterval[interval]).toFixed(2));
	//保留两位小数点
	return (((dt2 - dt1) / objInterval[interval]).toFixed(0));
	//不保留小数
	}
	catch (e)
	{
	return e.message;
	}
}

//获取当前时间
function nowTime()
{
	var date=new Date();
	var theYear=date.getFullYear();
	var theMonth=date.getMonth()+1;
	var theDay=date.getDate();
	var theHour=date.getHours();
	var theMinutes=date.getMinutes();
	var theSeconds=date.getSeconds();
	return theYear+'-'+add0(theMonth)+'-'+add0(theDay)+' '+add0(theHour)+':'+add0(theMinutes)+':'+add0(theSeconds);
		function add0(num)
		{
			if(num<10)
			{
			return "0"+num;
			}
			else
			{
			return num;
			}
		}
}

/**
 * 时间对象的格式化;
 */
Date.prototype.format = function(format) {
    /*
     * eg:format="YYYY-MM-dd hh:mm:ss";
     */
    var o = {
        "M+" :this.getMonth() + 1, // month
        "d+" :this.getDate(), // day
        "h+" :this.getHours(), // hour
        "m+" :this.getMinutes(), // minute
        "s+" :this.getSeconds(), // second
        "q+" :Math.floor((this.getMonth() + 3) / 3), // quarter
        "S" :this.getMilliseconds()
    // millisecond
    }

    if (/(y+)/.test(format)) {
        format = format.replace(RegExp.$1, (this.getFullYear() + "")
                .substr(4 - RegExp.$1.length));
    }

    for ( var k in o) {
        if (new RegExp("(" + k + ")").test(format)) {
            format = format.replace(RegExp.$1, RegExp.$1.length == 1 ? o[k]
                    : ("00" + o[k]).substr(("" + o[k]).length));
        }
    }
    return format;
}

function getSWF(movieName)
{
	if (navigator.appName.indexOf("Microsoft") != -1)
	{
		return window[movieName];
	}
	else
	{
		return document[movieName];
	}
}

function getDataTimes()
{
	var strDate,strTime;
	strDate = new Date();
	strTime = strDate.getTime();
	return strTime;
}

function getGUID()
{
	var StrRe,StrD,StrPa;
	StrPa = ["1","2","3","4","5","6","7","8","9","a","b","c","d","e","f","g","h","i","j","k","l","m","n","o","p","q","r","s","t","u","v","w","x","y","z","A","B","C","D","E","F","G","H","I","J","K","L","M","N","O","P","Q","R","S","T","U","V","W","X","Y"];
	StrD = new Date();
	StrRe = StrPa[StrD.getDate()]+StrPa[StrD.getHours()]+StrPa[StrD.getMinutes()]+StrPa[StrD.getSeconds()]+StrD.getMilliseconds();
	return StrRe;
}

function GetSendTime()
{
	var d = new Date();
	return (d.getHours()<10?"0"+d.getHours():d.getHours())+":"+(d.getMinutes()<10?"0"+d.getMinutes():d.getMinutes());
}

function vLogin()
{
	$.get("/Handle/ValidLogin.asp",{ac:"Login",UserName:$("#UserName")[0].value,UserPass:$("#UserPass")[0].value,t:GetSendTime()},function()
	{
		$('#LoginDiv').css('display','none');$('#ContentDiv').css('display','block');LoadTopNav();
	},"script");
}

function LoadTopNav()
{
	if(iInfo.IsLogin)
	{
		$("#unick")[0].href="/"+iInfo.RoomID;
		$("#unick").text(iInfo.UserNickName+"（"+iInfo.RoomID+"）");
	}
	else
	{
		$("#unick").bind("click",function(){GoToLogIn()});
		$("#unick").text("登录");
	}
	$(".logo").click(function(){location.href="/";});
}

$(function(){
	LoadTopNav();
})

function GoToLogIn(e)
{
	try{
		if(iInfo.IsLogin){return ;}
	}
	catch(err){}
	location.href="/i/v1/Login.html?"+location.href;
}

function GoLogOut()
{
	location.href="/Handle/LogOut.asp?t=/i/v1/Login.html?"+location.href;
}

function qq_login()
{
	location.href="/QQConnect/";
}

function LoadTNav()
{
	$(".Tnav").find("a").each(function(i,e){
		switch(i)
		{
			case 1:
				$(this).attr("href","/"+iInfo.RoomID);
				break;
			case 2:
				$(this).attr("href","Account.html");
				break
			case 3:
				$(this).attr("href","Show.html?"+iInfo.RoomID);
				break;
			case 4:
				$(this).attr("href","Album.html?"+iInfo.RoomID);
				break;
			case 5:
				$(this).attr("href","ModifyInfo.html");
				break;
			case 6:
				$(this).attr("href","iAttentionGroup.html");
				break;
		}
	});
}

function iUserInfo()
{
	var e = new Object();
	e.IsLogin = false;
	e.UserID = "";
	e.RoomID = "";
	e.BestAccount = "";
	e.UserNickName = "";
	e.FacePic = "";
	e.Live_NG_ID = location.pathname.substr(1);
	e.IsManager = false;
	e.LevelClass = "";
	e.InComeClass = "";
	e.FixIcon = "/images/pixel.gif";
	e.VIPIcon = "";
	e.LevelID = 0;
	e.LoginTime = "";
	e.LoginIP = "";
	e.EnterTime = getDataTimes();
	return e;
}
var iInfo = iUserInfo();
function GetiInfo()
{
	return iInfo;
}
