if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[FK_i_User_Log_i_Sys_Room]') and OBJECTPROPERTY(id, N'IsForeignKey') = 1)
ALTER TABLE [dbo].[i_User_Log] DROP CONSTRAINT FK_i_User_Log_i_Sys_Room

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[FK_i_Sys_Room_i_User_Info]') and OBJECTPROPERTY(id, N'IsForeignKey') = 1)
ALTER TABLE [dbo].[i_Sys_Room] DROP CONSTRAINT FK_i_Sys_Room_i_User_Info

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[FK_i_User_Attention_i_User_Info]') and OBJECTPROPERTY(id, N'IsForeignKey') = 1)
ALTER TABLE [dbo].[i_User_Attention] DROP CONSTRAINT FK_i_User_Attention_i_User_Info

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[FK_i_User_ConsumeRecord_i_User_Info]') and OBJECTPROPERTY(id, N'IsForeignKey') = 1)
ALTER TABLE [dbo].[i_User_ConsumeRecord] DROP CONSTRAINT FK_i_User_ConsumeRecord_i_User_Info

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[FK_i_User_Log_Comment_i_User_Log]') and OBJECTPROPERTY(id, N'IsForeignKey') = 1)
ALTER TABLE [dbo].[i_User_Log_Comment] DROP CONSTRAINT FK_i_User_Log_Comment_i_User_Log

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[i_Sys_App]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
drop table [dbo].[i_Sys_App]

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[i_Sys_Config]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
drop table [dbo].[i_Sys_Config]

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[i_Sys_Notice]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
drop table [dbo].[i_Sys_Notice]

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[i_Sys_PowerKeys]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
drop table [dbo].[i_Sys_PowerKeys]

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[i_Sys_Room]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
drop table [dbo].[i_Sys_Room]

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[i_Sys_RoomUserList]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
drop table [dbo].[i_Sys_RoomUserList]

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[i_Sys_Room_Class]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
drop table [dbo].[i_Sys_Room_Class]

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[i_Sys_Tip]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
drop table [dbo].[i_Sys_Tip]

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[i_User_Attention]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
drop table [dbo].[i_User_Attention]

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[i_User_BlackList]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
drop table [dbo].[i_User_BlackList]

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[i_User_Class]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
drop table [dbo].[i_User_Class]

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[i_User_ConsumeRecord]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
drop table [dbo].[i_User_ConsumeRecord]

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[i_User_Extraction]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
drop table [dbo].[i_User_Extraction]

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[i_User_Friends]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
drop table [dbo].[i_User_Friends]

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[i_User_Gift]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
drop table [dbo].[i_User_Gift]

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[i_User_GiftDiscount]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
drop table [dbo].[i_User_GiftDiscount]

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[i_User_GiftStore]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
drop table [dbo].[i_User_GiftStore]

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[i_User_Gift_SendRecord]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
drop table [dbo].[i_User_Gift_SendRecord]

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[i_User_InComeLevel]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
drop table [dbo].[i_User_InComeLevel]

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[i_User_Info]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
drop table [dbo].[i_User_Info]

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[i_User_Level]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
drop table [dbo].[i_User_Level]

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[i_User_Log]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
drop table [dbo].[i_User_Log]

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[i_User_Log_Comment]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
drop table [dbo].[i_User_Log_Comment]

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[i_User_PaymentLevel]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
drop table [dbo].[i_User_PaymentLevel]

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[i_User_Title]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
drop table [dbo].[i_User_Title]

CREATE TABLE [dbo].[i_Sys_App] (
	[i_Sys_App_ID] [int] IDENTITY (1, 1) NOT NULL ,
	[i_Sys_App_Name] [varchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
	[i_Sys_App_ServerUrl] [varchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
	[i_Sys_App_ServerID] [int] NULL ,
	[i_Sys_App_Key] [varchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
	[i_Sys_App_Enable] [int] NULL 
) ON [PRIMARY]

CREATE TABLE [dbo].[i_Sys_Config] (
	[i_Sys_Config_SysName] [varchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
	[i_Sys_Config_MoneyName] [varchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
	[i_Sys_Config_IndexPageSize] [int] NULL ,
	[i_Sys_Config_FlyMsgMoney] [int] NULL ,
	[i_Sys_Config_SysTipMoney] [int] NULL ,
	[i_Sys_Config_SeatMsgMoney] [int] NULL ,
	[i_Sys_Config_IndexCacheRefreshTime] [datetime] NULL ,
	[i_Sys_Config_IndexCacheRefreshSpace] [int] NULL ,
	[i_Sys_Config_ListPageSize] [int] NULL ,
	[i_Sys_Config_ListCacheRefreshTime] [datetime] NULL ,
	[i_Sys_Config_ListCacheRefreshSpace] [int] NULL ,
	[i_Sys_Config_GiftPercent] [float] NULL ,
	[i_Sys_Config_PayPercent] [int] NULL ,
	[i_Sys_Config_ExtractionPercent] [float] NULL ,
	[i_Sys_Config_ScoreStep] [int] NULL ,
	[i_Sys_Config_OpenReg] [int] NULL ,
	[i_Sys_Config_OpenRoom] [int] NULL ,
	[i_Sys_Config_OpenGuest] [int] NULL ,
	[i_Sys_Config_OpenUpload] [int] NULL ,
	[i_Sys_Config_OpenUCenter] [int] NULL ,
	[i_Sys_Config_UploadFileSize] [int] NULL ,
	[i_Sys_Config_UploadFileTypes] [varchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
	[i_Sys_Config_QQAppID] [varchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
	[i_Sys_Config_QQAppKey] [varchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
	[i_Sys_Config_LoginUrl] [varchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
	[i_Sys_Config_RegDefaultClass] [int] NULL ,
	[i_Sys_Config_RegDefaultMoneyNum] [int] NULL ,
	[i_Sys_Config_RegDefaultScoreNum] [int] NULL ,
	[i_Sys_Config_SendSpaceTime] [int] NULL ,
	[i_Sys_Config_TemplatePath] [varchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
	[i_Sys_Config_ReplaceKeys] [varchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
	[i_Sys_Config_MailServer] [varchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
	[i_Sys_Config_MailAdd] [varchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
	[i_Sys_Config_MailUserName] [varchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
	[i_Sys_Config_MailPass] [varchar] (255) COLLATE Chinese_PRC_CI_AS NULL 
) ON [PRIMARY]

CREATE TABLE [dbo].[i_Sys_Notice] (
	[i_Sys_Notice_ID] [int] IDENTITY (1, 1) NOT NULL ,
	[i_Sys_Notice_Name] [varchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
	[i_Sys_Notice_Href] [varchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
	[i_Sys_Notice_Content] [text] COLLATE Chinese_PRC_CI_AS NULL ,
	[i_Sys_Notice_Time] [datetime] NULL ,
	[i_Sys_Notice_Sort] [int] NULL 
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]

CREATE TABLE [dbo].[i_Sys_PowerKeys] (
	[i_Sys_PowerKeys_ID] [int] IDENTITY (1, 1) NOT NULL ,
	[i_Sys_PowerKeys_Name] [varchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
	[i_Sys_PowerKeys_Keys] [varchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
	[i_Sys_PowerKeys_Sort] [int] NULL 
) ON [PRIMARY]

CREATE TABLE [dbo].[i_Sys_Room] (
	[i_Sys_Room_ID] [int] IDENTITY (5000, 1) NOT NULL ,
	[i_Sys_Room_Name] [varchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
	[i_Sys_Room_ClassID] [int] NULL ,
	[i_Sys_Room_AdminUserID] [int] NULL ,
	[i_Sys_Room_ManagerUsers] [varchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
	[i_Sys_Room_ZBoUsers] [varchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
	[i_Sys_Room_Pass] [varchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
	[i_Sys_Room_OnlineNum] [int] NULL ,
	[i_Sys_Room_MaxNum] [int] NULL ,
	[i_Sys_Room_Record] [varchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
	[i_Sys_Room_Pic] [varchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
	[i_Sys_Room_StyleTop] [int] NULL ,
	[i_Sys_Room_StyleCss] [varchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
	[i_Sys_Room_BackGround] [varchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
	[i_Sys_Room_BackGroundFix] [varchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
	[i_Sys_Room_IDCType] [varchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
	[i_Sys_Room_PubNotice] [text] COLLATE Chinese_PRC_CI_AS NULL ,
	[i_Sys_Room_PubNoticeHref] [text] COLLATE Chinese_PRC_CI_AS NULL ,
	[i_Sys_Room_PriNotice] [text] COLLATE Chinese_PRC_CI_AS NULL ,
	[i_Sys_Room_PriNoticeHref] [text] COLLATE Chinese_PRC_CI_AS NULL ,
	[i_Sys_Room_Pay] [int] NOT NULL ,
	[i_Sys_Room_Enable] [int] NULL ,
	[i_Sys_Room_Tag] [varchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
	[i_Sys_Room_Monitor] [int] NULL ,
	[i_Sys_Room_OpenMsgRecord] [int] NULL ,
	[i_Sys_Room_BlackList] [varchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
	[i_Sys_Room_CreatTime] [datetime] NULL ,
	[i_Sys_Room_Seat1_UID] [int] NULL ,
	[i_Sys_Room_Seat2_UID] [int] NULL ,
	[i_Sys_Room_Seat3_UID] [int] NULL ,
	[i_Sys_Room_Seat4_UID] [int] NULL ,
	[i_Sys_Room_Seat5_UID] [int] NULL ,
	[i_Sys_Room_Mic01_UpForTime] [datetime] NULL ,
	[i_Sys_Room_Mic02_UpForTime] [datetime] NULL ,
	[i_Sys_Room_Mic03_UpForTime] [datetime] NULL ,
	[i_Sys_Room_Mic02_IsHiFi] [int] NULL ,
	[i_Sys_Room_Mic03_IsHiFi] [int] NULL 
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]

CREATE TABLE [dbo].[i_Sys_RoomUserList] (
	[i_Sys_RoomUserList_ID] [int] IDENTITY (1, 1) NOT NULL ,
	[i_Sys_RoomUserList_RoomID] [int] NOT NULL ,
	[i_Sys_RoomUserList_UserID] [int] NULL ,
	[i_Sys_RoomUserList_GuestID] [varchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
	[i_Sys_RoomUserList_LastTime] [datetime] NOT NULL 
) ON [PRIMARY]

CREATE TABLE [dbo].[i_Sys_Room_Class] (
	[i_Sys_Room_Class_ID] [int] IDENTITY (1, 1) NOT NULL ,
	[i_Sys_Room_Class_Name] [varchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
	[i_Sys_Room_CLass_ParentID] [int] NULL ,
	[i_Sys_Room_Class_Sort] [int] NULL 
) ON [PRIMARY]

CREATE TABLE [dbo].[i_Sys_Tip] (
	[i_Sys_Tip_ID] [int] IDENTITY (1, 1) NOT NULL ,
	[i_Sys_Tip_Name] [varchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
	[i_Sys_Tip_UID] [int] NULL ,
	[i_Sys_Tip_Words] [varchar] (250) COLLATE Chinese_PRC_CI_AS NULL ,
	[i_Sys_Tip_Time] [datetime] NULL ,
	[i_Sys_Tip_Href] [varchar] (250) COLLATE Chinese_PRC_CI_AS NULL 
) ON [PRIMARY]

CREATE TABLE [dbo].[i_User_Attention] (
	[i_User_Attention_ID] [int] IDENTITY (1, 1) NOT NULL ,
	[i_User_Attention_UID] [int] NULL ,
	[i_User_Attention_GUID] [int] NULL ,
	[i_User_Attention_Date] [datetime] NULL 
) ON [PRIMARY]

CREATE TABLE [dbo].[i_User_BlackList] (
	[i_User_BlackList_ID] [int] IDENTITY (1, 1) NOT NULL ,
	[i_User_BlackList_UID] [int] NULL ,
	[i_User_BlackList_GUID] [int] NULL ,
	[i_User_BlackList_Date] [datetime] NULL 
) ON [PRIMARY]

CREATE TABLE [dbo].[i_User_Class] (
	[i_User_Class_ID] [int] IDENTITY (1, 1) NOT NULL ,
	[i_User_Class_Name] [varchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
	[i_User_Class_Style] [varchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
	[i_User_Class_SortValue] [int] NULL ,
	[i_User_Class_PayMoney] [int] NULL ,
	[i_User_Class_CouldLive] [int] NULL ,
	[i_User_Class_CouldPubSay] [int] NULL ,
	[i_User_Class_CouldPriSay] [int] NULL ,
	[i_User_Class_ScoreSpeed] [float] NULL ,
	[i_User_Class_Discount] [float] NULL ,
	[i_User_Class_FreeSpeaker] [int] NULL ,
	[i_User_Class_GroupLevel] [int] NULL ,
	[i_User_Class_GroupCount] [int] NULL ,
	[i_User_Class_DisKick] [int] NULL ,
	[i_User_Class_AlwaysEnterRoom] [int] NULL ,
	[i_User_Class_PowerKeys] [varchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
	[i_User_Class_Sort] [int] NULL 
) ON [PRIMARY]

CREATE TABLE [dbo].[i_User_ConsumeRecord] (
	[i_User_ConsumeRecord_ID] [int] IDENTITY (1, 1) NOT NULL ,
	[i_User_ConsumeRecord_UID] [int] NULL ,
	[i_User_ConsumeRecord_Type] [int] NULL ,
	[i_User_ConsumeRecord_PayNum] [int] NULL ,
	[i_User_ConsumeRecord_InComeNum] [int] NULL ,
	[i_User_ConsumeRecord_Time] [datetime] NULL ,
	[i_User_ConsumeRecord_Store] [int] NULL ,
	[i_User_ConsumeRecord_Note] [varchar] (255) COLLATE Chinese_PRC_CI_AS NULL 
) ON [PRIMARY]

CREATE TABLE [dbo].[i_User_Extraction] (
	[i_User_Extraction_ID] [int] IDENTITY (1, 1) NOT NULL ,
	[i_User_Extraction_UID] [int] NULL ,
	[i_User_Extraction_MoneyNum] [int] NULL ,
	[i_User_Extraction_RMB] [int] NULL ,
	[i_User_Extraction_Date] [datetime] NULL ,
	[i_User_Extraction_Status] [int] NULL 
) ON [PRIMARY]

CREATE TABLE [dbo].[i_User_Friends] (
	[i_User_Friends_ID] [int] IDENTITY (1, 1) NOT NULL ,
	[i_User_Friends_UID] [int] NULL ,
	[i_User_Friends_GUID] [int] NULL ,
	[i_User_Friends_Note] [varchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
	[i_User_Friends_Date] [datetime] NULL ,
	[i_User_Friends_Status] [int] NULL 
) ON [PRIMARY]

CREATE TABLE [dbo].[i_User_Gift] (
	[i_User_Gift_ID] [int] IDENTITY (1, 1) NOT NULL ,
	[i_User_Gift_Name] [varchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
	[i_User_Gift_Class] [varchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
	[i_User_Gift_ImgUrl] [varchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
	[i_User_Gift_Price] [int] NULL ,
	[i_User_Gift_ShowType] [int] NULL ,
	[i_User_Gift_PlayTime] [int] NULL ,
	[i_User_Gift_SwfUrl] [varchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
	[i_User_Gift_MinUserClassSort] [int] NULL ,
	[i_User_Gift_MinUserLevelSort] [int] NULL ,
	[i_User_Gift_Enable] [int] NULL ,
	[i_User_Gift_Sort] [int] NULL 
) ON [PRIMARY]

CREATE TABLE [dbo].[i_User_GiftDiscount] (
	[i_User_GiftDiscount_ID] [int] IDENTITY (1, 1) NOT NULL ,
	[i_User_GiftDiscount_UserID] [int] NULL ,
	[i_User_GiftDiscount_GiftID] [int] NULL ,
	[i_User_GiftDiscount_GiftPrice] [int] NULL ,
	[i_User_GiftDiscount_GiftNum] [int] NULL ,
	[i_User_GiftDiscount_GiftTotalPrice] [int] NULL ,
	[i_User_GiftDiscount_Discount] [float] NULL ,
	[i_User_GiftDiscount_Time] [datetime] NULL 
) ON [PRIMARY]

CREATE TABLE [dbo].[i_User_GiftStore] (
	[i_User_GiftStore_ID] [int] IDENTITY (1, 1) NOT NULL ,
	[i_User_GiftStore_UID] [int] NULL ,
	[i_User_GiftStore_GiftID] [int] NULL ,
	[i_User_GiftStore_GiftNum] [int] NULL ,
	[i_User_GiftStore_Date] [datetime] NULL 
) ON [PRIMARY]

CREATE TABLE [dbo].[i_User_Gift_SendRecord] (
	[i_User_Gift_SendRecord_ID] [int] IDENTITY (1, 1) NOT NULL ,
	[i_User_Gift_SendRecord_UID] [int] NULL ,
	[i_User_Gift_SendRecord_GUID] [int] NULL ,
	[i_User_Gift_SendRecord_GiftName] [varchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
	[i_User_Gift_SendRecord_GiftID] [int] NULL ,
	[i_User_Gift_SendRecord_GiftPrice] [int] NULL ,
	[i_User_Gift_SendRecord_GiftNum] [int] NULL ,
	[i_User_Gift_SendRecord_GiftDiscount] [float] NULL ,
	[i_User_Gift_SendRecord_GiftTotalPrice] [int] NULL ,
	[i_User_Gift_SendRecord_Time] [datetime] NULL 
) ON [PRIMARY]

CREATE TABLE [dbo].[i_User_InComeLevel] (
	[i_User_InComeLevel_ID] [int] IDENTITY (1, 1) NOT NULL ,
	[i_User_InComeLevel_Name] [varchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
	[i_User_InComeLevel_Style] [varchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
	[i_User_InComeLevel_MinNum] [int] NOT NULL ,
	[i_User_InComeLevel_MaxNum] [bigint] NOT NULL ,
	[i_User_InComeLevel_Sort] [int] NOT NULL 
) ON [PRIMARY]

CREATE TABLE [dbo].[i_User_Info] (
	[i_User_ID] [int] IDENTITY (1, 1) NOT NULL ,
	[i_User_Name] [varchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
	[i_User_Pass] [varchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
	[i_User_OpenID] [varchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
	[i_User_UCID] [varchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
	[i_User_Class] [int] NULL ,
	[i_User_NickName] [varchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
	[i_User_RealName] [varchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
	[i_User_Mail] [varchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
	[i_User_Sex] [int] NULL ,
	[i_User_QQ] [varchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
	[i_User_Tel] [varchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
	[i_User_Province] [varchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
	[i_User_City] [varchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
	[i_User_Birthday] [varchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
	[i_User_Score] [bigint] NULL ,
	[i_User_Money] [bigint] NULL ,
	[i_User_PayNum] [bigint] NULL ,
	[i_User_IncomeNum] [bigint] NULL ,
	[i_User_ExtractionNum] [bigint] NULL ,
	[i_User_Group] [int] NULL ,
	[i_User_Titles] [varchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
	[i_User_Label] [varchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
	[i_User_About] [varchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
	[i_User_Face] [varchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
	[i_User_Site] [varchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
	[i_User_Height] [varchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
	[i_User_Weight] [varchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
	[i_User_BWH] [varchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
	[i_User_Question] [varchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
	[i_User_Answer] [varchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
	[i_User_FixLiveTime] [varchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
	[i_User_ViewNum] [int] NULL ,
	[i_User_LastLiveTime] [datetime] NULL ,
	[i_User_ForUpdateTime] [datetime] NULL ,
	[i_User_isStop] [int] NULL ,
	[i_User_isHiFi] [varchar] (255) COLLATE Chinese_PRC_CI_AS NOT NULL ,
	[i_User_RegTime] [datetime] NULL ,
	[i_User_SpeakerNum] [int] NULL ,
	[i_User_Online] [int] NULL ,
	[i_User_LastLoginTime] [datetime] NULL ,
	[i_User_LoginIP] [varchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
	[i_User_IsContract] [int] NULL ,
	[i_User_IsLock] [int] NULL ,
	[i_User_Signing] [int] NOT NULL ,
	[i_User_IsRecommend] [int] NULL ,
	[i_User_BankInfo] [text] COLLATE Chinese_PRC_CI_AS NULL 
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]

CREATE TABLE [dbo].[i_User_Level] (
	[i_User_Level_ID] [int] IDENTITY (1, 1) NOT NULL ,
	[i_User_Level_Name] [varchar] (255) COLLATE Chinese_PRC_CI_AS NOT NULL ,
	[i_User_Level_Style] [varchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
	[i_User_Level_MinNum] [int] NOT NULL ,
	[i_User_Level_MaxNum] [int] NOT NULL ,
	[i_User_Level_CreatFamily] [int] NOT NULL ,
	[i_User_Level_Sort] [int] NOT NULL 
) ON [PRIMARY]

CREATE TABLE [dbo].[i_User_Log] (
	[i_User_Log_ID] [int] IDENTITY (1, 1) NOT NULL ,
	[i_User_Log_RID] [int] NULL ,
	[i_User_Log_Title] [varchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
	[i_User_Log_Pic] [varchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
	[i_User_Log_Content] [varchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
	[i_User_Log_Path] [varchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
	[i_User_Log_Date] [datetime] NULL ,
	[i_User_Log_ViewNum] [int] NULL ,
	[i_User_Log_CommentNum] [int] NULL ,
	[i_User_Log_Type] [int] NULL ,
	[i_User_Log_IsShow] [int] NULL 
) ON [PRIMARY]

CREATE TABLE [dbo].[i_User_Log_Comment] (
	[i_User_Log_Comment_ID] [int] IDENTITY (1, 1) NOT NULL ,
	[i_User_Log_Comment_LogID] [int] NULL ,
	[i_User_Log_Comment_UID] [int] NULL ,
	[i_User_Log_Comment_Content] [varchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
	[i_User_Log_Comment_Date] [datetime] NULL 
) ON [PRIMARY]

CREATE TABLE [dbo].[i_User_PaymentLevel] (
	[i_User_PaymentLevel_ID] [int] IDENTITY (1, 1) NOT NULL ,
	[i_User_PaymentLevel_Name] [varchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
	[i_User_PaymentLevel_Style] [varchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
	[i_User_PaymentLevel_MinNum] [int] NOT NULL ,
	[i_User_PaymentLevel_MaxNum] [bigint] NOT NULL ,
	[i_User_PaymentLevel_Sort] [int] NOT NULL 
) ON [PRIMARY]

CREATE TABLE [dbo].[i_User_Title] (
	[i_User_Title_ID] [int] IDENTITY (1, 1) NOT NULL ,
	[i_User_Title_Name] [varchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
	[i_User_Title_Style] [varchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
	[i_User_Title_Sort] [int] NOT NULL 
) ON [PRIMARY]



ALTER TABLE [dbo].[i_Sys_App] WITH NOCHECK ADD 
	CONSTRAINT [DF_i_Sys_App_i_Sys_App_Enable] DEFAULT (1) FOR [i_Sys_App_Enable],
	CONSTRAINT [PK_i_Sys_App] PRIMARY KEY  CLUSTERED 
	(
		[i_Sys_App_ID]
	)  ON [PRIMARY] 

ALTER TABLE [dbo].[i_Sys_Config] WITH NOCHECK ADD 
	CONSTRAINT [DF_i_Sys_Config_i_Sys_Config_MoneyName] DEFAULT ('') FOR [i_Sys_Config_MoneyName],
	CONSTRAINT [DF_i_Config_i_Config_IndexPageSize] DEFAULT (30) FOR [i_Sys_Config_IndexPageSize],
	CONSTRAINT [DF_i_Sys_Config_i_Sys_Config_FlyMsgMoney] DEFAULT (50) FOR [i_Sys_Config_FlyMsgMoney],
	CONSTRAINT [DF_i_Sys_Config_i_Sys_Config_SysTipMoney] DEFAULT (500) FOR [i_Sys_Config_SysTipMoney],
	CONSTRAINT [DF_i_Sys_Config_i_Sys_Config_SeatMsgMoney] DEFAULT (0) FOR [i_Sys_Config_SeatMsgMoney],
	CONSTRAINT [DF_i_Config_i_Config_IndexCacheRefreshSpace] DEFAULT (600) FOR [i_Sys_Config_IndexCacheRefreshSpace],
	CONSTRAINT [DF_i_Config_i_Config_ListPageSize] DEFAULT (30) FOR [i_Sys_Config_ListPageSize],
	CONSTRAINT [DF_i_Config_i_Config_ListCacheRefreshSpace] DEFAULT (180) FOR [i_Sys_Config_ListCacheRefreshSpace],
	CONSTRAINT [DF_i_Config_i_Config_GiftPercent] DEFAULT (0.7) FOR [i_Sys_Config_GiftPercent],
	CONSTRAINT [DF_i_Config_i_Config_PayPercent] DEFAULT (100) FOR [i_Sys_Config_PayPercent],
	CONSTRAINT [DF_i_Sys_Config_i_Sys_Config_ExtractionPercent] DEFAULT (0.5) FOR [i_Sys_Config_ExtractionPercent],
	CONSTRAINT [DF_i_Config_i_Config_ScoreStep] DEFAULT (10) FOR [i_Sys_Config_ScoreStep],
	CONSTRAINT [DF_i_Config_i_Config_OpenReg] DEFAULT (1) FOR [i_Sys_Config_OpenReg],
	CONSTRAINT [DF_i_Config_i_Config_OpenRoom] DEFAULT (1) FOR [i_Sys_Config_OpenRoom],
	CONSTRAINT [DF_i_Config_i_Config_OpenGuest] DEFAULT (1) FOR [i_Sys_Config_OpenGuest],
	CONSTRAINT [DF_i_Config_i_Config_OpenUpload] DEFAULT (1) FOR [i_Sys_Config_OpenUpload],
	CONSTRAINT [DF_i_Sys_Config_i_Sys_Config_OpenUCenter] DEFAULT (1) FOR [i_Sys_Config_OpenUCenter],
	CONSTRAINT [DF_i_Sys_Config_i_Sys_Config_RegDefaultClass] DEFAULT (1) FOR [i_Sys_Config_RegDefaultClass],
	CONSTRAINT [DF_i_Config_i_Config_RegDefaultMoneyNum] DEFAULT (0) FOR [i_Sys_Config_RegDefaultMoneyNum],
	CONSTRAINT [DF_i_Config_i_Config_RegDefaultScoreNum] DEFAULT (0) FOR [i_Sys_Config_RegDefaultScoreNum],
	CONSTRAINT [DF_i_Config_i_Config_SendSpaceTime] DEFAULT (1) FOR [i_Sys_Config_SendSpaceTime],
	CONSTRAINT [DF_i_Sys_Config_i_Sys_Config_TemplatePath] DEFAULT ('v1') FOR [i_Sys_Config_TemplatePath]

ALTER TABLE [dbo].[i_Sys_Notice] WITH NOCHECK ADD 
	CONSTRAINT [DF_i_Sys_Notice_i_Sys_Notice_Href] DEFAULT ('javascript:void(0)') FOR [i_Sys_Notice_Href],
	CONSTRAINT [DF_i_Sys_Notice_i_Sys_Notice_Content] DEFAULT (' ') FOR [i_Sys_Notice_Content],
	CONSTRAINT [DF_i_Sys_Notice_i_Sys_Notice_Time] DEFAULT (getdate()) FOR [i_Sys_Notice_Time],
	CONSTRAINT [DF_i_Sys_Notice_i_Sys_Notice_Sort] DEFAULT (0) FOR [i_Sys_Notice_Sort],
	CONSTRAINT [PK_i_Sys_Notice] PRIMARY KEY  CLUSTERED 
	(
		[i_Sys_Notice_ID]
	)  ON [PRIMARY] 

ALTER TABLE [dbo].[i_Sys_PowerKeys] WITH NOCHECK ADD 
	CONSTRAINT [DF_i_PowerKeys_i_PowerKeys_Sort] DEFAULT (0) FOR [i_Sys_PowerKeys_Sort],
	CONSTRAINT [PK_i_PowerKeys] PRIMARY KEY  CLUSTERED 
	(
		[i_Sys_PowerKeys_ID]
	)  ON [PRIMARY] 

ALTER TABLE [dbo].[i_Sys_Room] WITH NOCHECK ADD 
	CONSTRAINT [DF_i_Sys_Room_i_Sys_Room_ClassID] DEFAULT (1) FOR [i_Sys_Room_ClassID],
	CONSTRAINT [DF_i_Sys_Room_i_Sys_Room_OnlineNum] DEFAULT (0) FOR [i_Sys_Room_OnlineNum],
	CONSTRAINT [DF_i_Sys_Room_i_Sys_Room_MaxNum] DEFAULT (100) FOR [i_Sys_Room_MaxNum],
	CONSTRAINT [DF_i_Sys_Room_i_Sys_Room_StyleTop] DEFAULT (0) FOR [i_Sys_Room_StyleTop],
	CONSTRAINT [DF_i_Sys_Room_i_Sys_Room_BackGroundFix] DEFAULT ('fixed') FOR [i_Sys_Room_BackGroundFix],
	CONSTRAINT [DF_i_Sys_Room_i_Sys_Room_IDCType] DEFAULT ('') FOR [i_Sys_Room_IDCType],
	CONSTRAINT [DF_i_Sys_Room_i_Sys_Room_PubNoticeHref] DEFAULT ('#') FOR [i_Sys_Room_PubNoticeHref],
	CONSTRAINT [DF_i_Sys_Room_i_Sys_Room_PriNoticeHref] DEFAULT ('#') FOR [i_Sys_Room_PriNoticeHref],
	CONSTRAINT [DF_i_Sys_Room_i_Sys_Room_Pay] DEFAULT (0) FOR [i_Sys_Room_Pay],
	CONSTRAINT [DF_i_Sys_Room_i_Sys_Room_Enable] DEFAULT (1) FOR [i_Sys_Room_Enable],
	CONSTRAINT [DF_i_Sys_Room_i_Sys_Room_Monitor] DEFAULT (0) FOR [i_Sys_Room_Monitor],
	CONSTRAINT [DF_i_Sys_Room_i_Sys_Room_OpenMsgRecord] DEFAULT (0) FOR [i_Sys_Room_OpenMsgRecord],
	CONSTRAINT [DF_i_Sys_Room_i_Sys_Room_CreatTime] DEFAULT (getdate()) FOR [i_Sys_Room_CreatTime],
	CONSTRAINT [DF_i_Sys_Room_i_Sys_Room_Seat1_UID] DEFAULT (0) FOR [i_Sys_Room_Seat1_UID],
	CONSTRAINT [DF_i_Sys_Room_i_Sys_Room_Seat2_UID] DEFAULT (0) FOR [i_Sys_Room_Seat2_UID],
	CONSTRAINT [DF_i_Sys_Room_i_Sys_Room_Seat3_UID] DEFAULT (0) FOR [i_Sys_Room_Seat3_UID],
	CONSTRAINT [DF_i_Sys_Room_i_Sys_Room_Seat4_UID] DEFAULT (0) FOR [i_Sys_Room_Seat4_UID],
	CONSTRAINT [DF_i_Sys_Room_i_Sys_Room_Seat5_UID] DEFAULT (0) FOR [i_Sys_Room_Seat5_UID],
	CONSTRAINT [DF_i_Sys_Room_i_Sys_Room_Mic02_IsHiFi] DEFAULT (0) FOR [i_Sys_Room_Mic02_IsHiFi],
	CONSTRAINT [DF_i_Sys_Room_i_Sys_Room_Mic03_IsHiFi] DEFAULT (0) FOR [i_Sys_Room_Mic03_IsHiFi],
	CONSTRAINT [PK_i_Sys_Room] PRIMARY KEY  CLUSTERED 
	(
		[i_Sys_Room_ID]
	)  ON [PRIMARY] 

ALTER TABLE [dbo].[i_Sys_RoomUserList] WITH NOCHECK ADD 
	CONSTRAINT [PK_i_Sys_RoomUserList] PRIMARY KEY  CLUSTERED 
	(
		[i_Sys_RoomUserList_ID]
	)  ON [PRIMARY] 

ALTER TABLE [dbo].[i_Sys_Room_Class] WITH NOCHECK ADD 
	CONSTRAINT [DF_i_Sys_Room_Class_i_Sys_Room_CLass_ParentID] DEFAULT (0) FOR [i_Sys_Room_CLass_ParentID],
	CONSTRAINT [DF_i_Sys_Room_Class_i_Sys_Room_Class_Sort] DEFAULT (0) FOR [i_Sys_Room_Class_Sort],
	CONSTRAINT [PK_i_Sys_Room_Class] PRIMARY KEY  CLUSTERED 
	(
		[i_Sys_Room_Class_ID]
	)  ON [PRIMARY] 

ALTER TABLE [dbo].[i_Sys_Tip] WITH NOCHECK ADD 
	CONSTRAINT [DF_i_Sys_Tip_i_Sys_Tip_Time] DEFAULT (getdate()) FOR [i_Sys_Tip_Time],
	CONSTRAINT [PK_i_Sys_Tip] PRIMARY KEY  CLUSTERED 
	(
		[i_Sys_Tip_ID]
	)  ON [PRIMARY] 

ALTER TABLE [dbo].[i_User_Attention] WITH NOCHECK ADD 
	CONSTRAINT [DF_i_User_Attention_i_User_Attention_Date] DEFAULT (getdate()) FOR [i_User_Attention_Date],
	CONSTRAINT [PK_i_User_Attention] PRIMARY KEY  CLUSTERED 
	(
		[i_User_Attention_ID]
	)  ON [PRIMARY] 

ALTER TABLE [dbo].[i_User_BlackList] WITH NOCHECK ADD 
	CONSTRAINT [DF_i_User_BlackList_i_User_BlackList_Date] DEFAULT (getdate()) FOR [i_User_BlackList_Date],
	CONSTRAINT [PK_i_User_BlackList] PRIMARY KEY  CLUSTERED 
	(
		[i_User_BlackList_ID]
	)  ON [PRIMARY] 

ALTER TABLE [dbo].[i_User_Class] WITH NOCHECK ADD 
	CONSTRAINT [DF_i_User_Class_i_User_Class_SortValue] DEFAULT (0) FOR [i_User_Class_SortValue],
	CONSTRAINT [DF_i_User_Class_i_User_Class_PayMoney] DEFAULT (0) FOR [i_User_Class_PayMoney],
	CONSTRAINT [DF_i_User_Class_i_User_Class_CouldLive] DEFAULT (1) FOR [i_User_Class_CouldLive],
	CONSTRAINT [DF_i_User_Class_i_User_Class_CouldPubSay] DEFAULT (1) FOR [i_User_Class_CouldPubSay],
	CONSTRAINT [DF_i_User_Class_i_User_Class_CouldPriSay] DEFAULT (1) FOR [i_User_Class_CouldPriSay],
	CONSTRAINT [DF_i_User_Class_i_User_Class_ScoreSpeed] DEFAULT (1.0) FOR [i_User_Class_ScoreSpeed],
	CONSTRAINT [DF_i_User_Class_i_User_Class_Discount] DEFAULT (1.0) FOR [i_User_Class_Discount],
	CONSTRAINT [DF_i_User_Class_i_User_Class_FreeSpeaker] DEFAULT (0) FOR [i_User_Class_FreeSpeaker],
	CONSTRAINT [DF_i_User_Class_i_User_Class_GroupLevel] DEFAULT (0) FOR [i_User_Class_GroupLevel],
	CONSTRAINT [DF_i_User_Class_i_User_Class_RoomCount] DEFAULT (0) FOR [i_User_Class_GroupCount],
	CONSTRAINT [DF_i_User_Class_i_User_Class_DisKick] DEFAULT (0) FOR [i_User_Class_DisKick],
	CONSTRAINT [DF_i_User_Class_i_User_Class_AlwaysEnterRoom] DEFAULT (0) FOR [i_User_Class_AlwaysEnterRoom],
	CONSTRAINT [DF_i_User_Class_i_User_Class_Sort] DEFAULT (0) FOR [i_User_Class_Sort],
	CONSTRAINT [PK_i_User_Class] PRIMARY KEY  CLUSTERED 
	(
		[i_User_Class_ID]
	)  ON [PRIMARY] 

ALTER TABLE [dbo].[i_User_ConsumeRecord] WITH NOCHECK ADD 
	CONSTRAINT [DF_i_User_ConsumeRecord_i_User_ConsumeRecord_Type] DEFAULT (0) FOR [i_User_ConsumeRecord_Type],
	CONSTRAINT [DF_i_User_ConsumeRecord_i_User_ConsumeRecord_PayNum] DEFAULT (0) FOR [i_User_ConsumeRecord_PayNum],
	CONSTRAINT [DF_i_User_ConsumeRecord_i_User_ConsumeRecord_InCome] DEFAULT (0) FOR [i_User_ConsumeRecord_InComeNum],
	CONSTRAINT [DF_i_User_ConsumeRecord_i_User_ConsumeRecord_Time] DEFAULT (getdate()) FOR [i_User_ConsumeRecord_Time],
	CONSTRAINT [DF_i_User_ConsumeRecord_i_User_ConsumeRecord_Store] DEFAULT (0) FOR [i_User_ConsumeRecord_Store],
	CONSTRAINT [PK_i_User_ConsumeRecord] PRIMARY KEY  CLUSTERED 
	(
		[i_User_ConsumeRecord_ID]
	)  ON [PRIMARY] 

ALTER TABLE [dbo].[i_User_Extraction] WITH NOCHECK ADD 
	CONSTRAINT [DF_i_User_Extraction_i_User_Extraction_MoneyNum] DEFAULT (0) FOR [i_User_Extraction_MoneyNum],
	CONSTRAINT [DF_i_User_Extraction_i_User_Extraction_RMB] DEFAULT (0) FOR [i_User_Extraction_RMB],
	CONSTRAINT [DF_i_User_Extraction_i_User_Extraction_Date] DEFAULT (getdate()) FOR [i_User_Extraction_Date],
	CONSTRAINT [DF_i_User_Extraction_i_User_Extraction_Status] DEFAULT (0) FOR [i_User_Extraction_Status],
	CONSTRAINT [PK_i_User_Extraction] PRIMARY KEY  CLUSTERED 
	(
		[i_User_Extraction_ID]
	)  ON [PRIMARY] 

ALTER TABLE [dbo].[i_User_Friends] WITH NOCHECK ADD 
	CONSTRAINT [DF_i_User_Friends_i_User_Friends_Date] DEFAULT (getdate()) FOR [i_User_Friends_Date],
	CONSTRAINT [DF_i_User_Friends_i_User_Friends_Status] DEFAULT (0) FOR [i_User_Friends_Status],
	CONSTRAINT [PK_i_User_Friends] PRIMARY KEY  CLUSTERED 
	(
		[i_User_Friends_ID]
	)  ON [PRIMARY] 

ALTER TABLE [dbo].[i_User_Gift] WITH NOCHECK ADD 
	CONSTRAINT [DF_i_User_Gift_i_User_Gift_Price] DEFAULT (0) FOR [i_User_Gift_Price],
	CONSTRAINT [DF_i_User_Gift_i_User_Gift_ShowType] DEFAULT (0) FOR [i_User_Gift_ShowType],
	CONSTRAINT [DF_i_User_Gift_i_User_Gift_PlayTime] DEFAULT (3) FOR [i_User_Gift_PlayTime],
	CONSTRAINT [DF_i_User_Gift_i_User_Gift_MinUserClassSort] DEFAULT (0) FOR [i_User_Gift_MinUserClassSort],
	CONSTRAINT [DF_i_User_Gift_i_User_Gift_MinUserLevelSort] DEFAULT (0) FOR [i_User_Gift_MinUserLevelSort],
	CONSTRAINT [DF_i_User_Gift_i_User_Gift_Enable] DEFAULT (1) FOR [i_User_Gift_Enable],
	CONSTRAINT [DF_i_User_Gift_i_User_Gift_Sort] DEFAULT (0) FOR [i_User_Gift_Sort],
	CONSTRAINT [PK_i_User_Gift] PRIMARY KEY  CLUSTERED 
	(
		[i_User_Gift_ID]
	)  ON [PRIMARY] 

ALTER TABLE [dbo].[i_User_GiftDiscount] WITH NOCHECK ADD 
	CONSTRAINT [DF_i_User_GiftDiscount_i_User_GiftDiscount_Time] DEFAULT (getdate()) FOR [i_User_GiftDiscount_Time],
	CONSTRAINT [PK_i_User_GiftDiscount] PRIMARY KEY  CLUSTERED 
	(
		[i_User_GiftDiscount_ID]
	)  ON [PRIMARY] 

ALTER TABLE [dbo].[i_User_GiftStore] WITH NOCHECK ADD 
	CONSTRAINT [DF_i_User_GiftStore_i_User_GiftStore_UID] DEFAULT (0) FOR [i_User_GiftStore_UID],
	CONSTRAINT [DF_i_User_GiftStore_i_User_GiftStore_Time] DEFAULT (getdate()) FOR [i_User_GiftStore_Date],
	CONSTRAINT [PK_i_User_GiftStore] PRIMARY KEY  CLUSTERED 
	(
		[i_User_GiftStore_ID]
	)  ON [PRIMARY] 

ALTER TABLE [dbo].[i_User_Gift_SendRecord] WITH NOCHECK ADD 
	CONSTRAINT [DF_i_User_Gift_SendRecord_i_User_Gift_SendRecord_GiftNum] DEFAULT (0) FOR [i_User_Gift_SendRecord_GiftNum],
	CONSTRAINT [DF_i_User_Gift_SendRecord_i_User_Gift_SendRecord_GiftDiscount] DEFAULT (1.0) FOR [i_User_Gift_SendRecord_GiftDiscount],
	CONSTRAINT [DF_i_User_Gift_SendRecord_i_User_Gift_SendRecord_GiftTotalPrice] DEFAULT (0) FOR [i_User_Gift_SendRecord_GiftTotalPrice],
	CONSTRAINT [DF_i_User_Gift_SendRecord_i_User_Gift_SendRecord_Time] DEFAULT (getdate()) FOR [i_User_Gift_SendRecord_Time],
	CONSTRAINT [PK_i_User_Gift_SendRecord] PRIMARY KEY  CLUSTERED 
	(
		[i_User_Gift_SendRecord_ID]
	)  ON [PRIMARY] 

ALTER TABLE [dbo].[i_User_InComeLevel] WITH NOCHECK ADD 
	CONSTRAINT [DF_i_User_InComeLevel_i_User_InComeLevel_MinNum] DEFAULT (0) FOR [i_User_InComeLevel_MinNum],
	CONSTRAINT [DF_i_User_InComeLevel_i_User_InComeLevel_MaxNum] DEFAULT (0) FOR [i_User_InComeLevel_MaxNum],
	CONSTRAINT [DF_i_User_InComeLevel_i_User_InComeLevel_Sort] DEFAULT (0) FOR [i_User_InComeLevel_Sort],
	CONSTRAINT [PK_i_User_InComeLevel] PRIMARY KEY  CLUSTERED 
	(
		[i_User_InComeLevel_ID]
	)  ON [PRIMARY] 

ALTER TABLE [dbo].[i_User_Info] WITH NOCHECK ADD 
	CONSTRAINT [DF_i_User_Info_i_User_Sex] DEFAULT (1) FOR [i_User_Sex],
	CONSTRAINT [DF_i_User_Info_i_User_Score] DEFAULT (0) FOR [i_User_Score],
	CONSTRAINT [DF_i_User_Info_i_User_Money] DEFAULT (0) FOR [i_User_Money],
	CONSTRAINT [DF_i_User_Info_i_User_PayNum] DEFAULT (0) FOR [i_User_PayNum],
	CONSTRAINT [DF_i_User_Info_i_User_IncomeNum] DEFAULT (0) FOR [i_User_IncomeNum],
	CONSTRAINT [DF_i_User_Info_i_User_ExtractionNum] DEFAULT (0) FOR [i_User_ExtractionNum],
	CONSTRAINT [DF_i_User_Info_i_User_ViewNum] DEFAULT (0) FOR [i_User_ViewNum],
	CONSTRAINT [DF_i_User_Info_i_User_isLive] DEFAULT (0) FOR [i_User_isStop],
	CONSTRAINT [DF_i_User_Info_i_User_isHiFi] DEFAULT (0) FOR [i_User_isHiFi],
	CONSTRAINT [DF_i_User_Info_i_User_RegTime] DEFAULT (getdate()) FOR [i_User_RegTime],
	CONSTRAINT [DF_i_User_Info_i_User_SpeakerNum] DEFAULT (0) FOR [i_User_SpeakerNum],
	CONSTRAINT [DF_i_User_Info_i_User_Online] DEFAULT (0) FOR [i_User_Online],
	CONSTRAINT [DF_i_User_Info_i_User_IsContract] DEFAULT (0) FOR [i_User_IsContract],
	CONSTRAINT [DF_i_User_Info_i_User_IsLock] DEFAULT (0) FOR [i_User_IsLock],
	CONSTRAINT [DF_i_User_Info_i_User_Signing] DEFAULT (0) FOR [i_User_Signing],
	CONSTRAINT [DF_i_User_Info_i_User_IsRecommend] DEFAULT (0) FOR [i_User_IsRecommend],
	CONSTRAINT [PK_i_User_Info] PRIMARY KEY  CLUSTERED 
	(
		[i_User_ID]
	)  ON [PRIMARY] 

ALTER TABLE [dbo].[i_User_Level] WITH NOCHECK ADD 
	CONSTRAINT [DF_i_User_Level_i_User_Level_MinScore] DEFAULT (0) FOR [i_User_Level_MinNum],
	CONSTRAINT [DF_i_User_Level_i_User_Level_MaxScore] DEFAULT (0) FOR [i_User_Level_MaxNum],
	CONSTRAINT [DF_i_User_Level_i_User_Level_CreatFamily] DEFAULT (0) FOR [i_User_Level_CreatFamily],
	CONSTRAINT [DF_i_User_Level_i_User_Level_Sort] DEFAULT (0) FOR [i_User_Level_Sort],
	CONSTRAINT [PK_i_User_Level] PRIMARY KEY  CLUSTERED 
	(
		[i_User_Level_ID]
	)  ON [PRIMARY] 

ALTER TABLE [dbo].[i_User_Log] WITH NOCHECK ADD 
	CONSTRAINT [DF_i_User_Log_i_User_Log_Date] DEFAULT (getdate()) FOR [i_User_Log_Date],
	CONSTRAINT [DF_i_User_Log_i_User_Log_View] DEFAULT (0) FOR [i_User_Log_ViewNum],
	CONSTRAINT [DF_i_User_Log_i_User_Log_CommentNum] DEFAULT (0) FOR [i_User_Log_CommentNum],
	CONSTRAINT [DF_i_User_Log_i_User_Log_Type] DEFAULT (0) FOR [i_User_Log_Type],
	CONSTRAINT [DF_i_User_Log_i_User_Log_IsShow] DEFAULT (0) FOR [i_User_Log_IsShow],
	CONSTRAINT [PK_i_User_Log] PRIMARY KEY  CLUSTERED 
	(
		[i_User_Log_ID]
	)  ON [PRIMARY] 

ALTER TABLE [dbo].[i_User_Log_Comment] WITH NOCHECK ADD 
	CONSTRAINT [DF_i_User_Log_Comment_i_User_Log_Comment_Date] DEFAULT (getdate()) FOR [i_User_Log_Comment_Date],
	CONSTRAINT [PK_i_User_Log_Comment] PRIMARY KEY  CLUSTERED 
	(
		[i_User_Log_Comment_ID]
	)  ON [PRIMARY] 

ALTER TABLE [dbo].[i_User_PaymentLevel] WITH NOCHECK ADD 
	CONSTRAINT [DF_i_User_PaymentLevel_i_User_PaymentLevel_MinNum] DEFAULT (0) FOR [i_User_PaymentLevel_MinNum],
	CONSTRAINT [DF_i_User_PaymentLevel_i_User_PaymentLevel_MaxNum] DEFAULT (0) FOR [i_User_PaymentLevel_MaxNum],
	CONSTRAINT [DF_i_User_PaymentLevel_i_User_PaymentLevel_Sort] DEFAULT (0) FOR [i_User_PaymentLevel_Sort],
	CONSTRAINT [PK_i_User_PaymentLevel] PRIMARY KEY  CLUSTERED 
	(
		[i_User_PaymentLevel_ID]
	)  ON [PRIMARY] 

ALTER TABLE [dbo].[i_User_Title] WITH NOCHECK ADD 
	CONSTRAINT [DF_i_User_Title_i_User_Title_Sort] DEFAULT (0) FOR [i_User_Title_Sort],
	CONSTRAINT [PK_i_User_Title] PRIMARY KEY  CLUSTERED 
	(
		[i_User_Title_ID]
	)  ON [PRIMARY] 

ALTER TABLE [dbo].[i_Sys_Room] ADD 
	CONSTRAINT [FK_i_Sys_Room_i_User_Info] FOREIGN KEY 
	(
		[i_Sys_Room_AdminUserID]
	) REFERENCES [dbo].[i_User_Info] (
		[i_User_ID]
	) ON DELETE CASCADE  ON UPDATE CASCADE 

ALTER TABLE [dbo].[i_User_Attention] ADD 
	CONSTRAINT [FK_i_User_Attention_i_User_Info] FOREIGN KEY 
	(
		[i_User_Attention_UID]
	) REFERENCES [dbo].[i_User_Info] (
		[i_User_ID]
	) ON DELETE CASCADE  ON UPDATE CASCADE 

ALTER TABLE [dbo].[i_User_ConsumeRecord] ADD 
	CONSTRAINT [FK_i_User_ConsumeRecord_i_User_Info] FOREIGN KEY 
	(
		[i_User_ConsumeRecord_UID]
	) REFERENCES [dbo].[i_User_Info] (
		[i_User_ID]
	) ON DELETE CASCADE  ON UPDATE CASCADE 

ALTER TABLE [dbo].[i_User_Log] ADD 
	CONSTRAINT [FK_i_User_Log_i_Sys_Room] FOREIGN KEY 
	(
		[i_User_Log_RID]
	) REFERENCES [dbo].[i_Sys_Room] (
		[i_Sys_Room_ID]
	) ON DELETE CASCADE  ON UPDATE CASCADE 

ALTER TABLE [dbo].[i_User_Log_Comment] ADD 
	CONSTRAINT [FK_i_User_Log_Comment_i_User_Log] FOREIGN KEY 
	(
		[i_User_Log_Comment_LogID]
	) REFERENCES [dbo].[i_User_Log] (
		[i_User_Log_ID]
	) ON DELETE CASCADE  ON UPDATE CASCADE 


exec sp_addextendedproperty N'MS_Description', N'0ر,1', N'user', N'dbo', N'table', N'i_Sys_App', N'column', N'i_Sys_App_Enable'




exec sp_addextendedproperty N'MS_Description', N'۸', N'user', N'dbo', N'table', N'i_Sys_Config', N'column', N'i_Sys_Config_SeatMsgMoney'
exec sp_addextendedproperty N'MS_Description', N'ˢ»ʱ()', N'user', N'dbo', N'table', N'i_Sys_Config', N'column', N'i_Sys_Config_IndexCacheRefreshSpace'
exec sp_addextendedproperty N'MS_Description', N'ֻ', N'user', N'dbo', N'table', N'i_Sys_Config', N'column', N'i_Sys_Config_GiftPercent'
exec sp_addextendedproperty N'MS_Description', N'ֵ,1RMB=?', N'user', N'dbo', N'table', N'i_Sys_Config', N'column', N'i_Sys_Config_PayPercent'
exec sp_addextendedproperty N'MS_Description', N'', N'user', N'dbo', N'table', N'i_Sys_Config', N'column', N'i_Sys_Config_ExtractionPercent'
exec sp_addextendedproperty N'MS_Description', N',ûÿ10', N'user', N'dbo', N'table', N'i_Sys_Config', N'column', N'i_Sys_Config_ScoreStep'
exec sp_addextendedproperty N'MS_Description', N'ע,0ر,1', N'user', N'dbo', N'table', N'i_Sys_Config', N'column', N'i_Sys_Config_OpenReg'
exec sp_addextendedproperty N'MS_Description', N'Զͨ,0ر,1', N'user', N'dbo', N'table', N'i_Sys_Config', N'column', N'i_Sys_Config_OpenRoom'
exec sp_addextendedproperty N'MS_Description', N'Ƿο͵¼,0ر,1', N'user', N'dbo', N'table', N'i_Sys_Config', N'column', N'i_Sys_Config_OpenGuest'
exec sp_addextendedproperty N'MS_Description', N'ϴ,0ر,1', N'user', N'dbo', N'table', N'i_Sys_Config', N'column', N'i_Sys_Config_OpenUpload'
exec sp_addextendedproperty N'MS_Description', N'ǷUCenter', N'user', N'dbo', N'table', N'i_Sys_Config', N'column', N'i_Sys_Config_OpenUCenter'
exec sp_addextendedproperty N'MS_Description', N'Ϣʱ()', N'user', N'dbo', N'table', N'i_Sys_Config', N'column', N'i_Sys_Config_SendSpaceTime'
exec sp_addextendedproperty N'MS_Description', N'ģ·', N'user', N'dbo', N'table', N'i_Sys_Config', N'column', N'i_Sys_Config_TemplatePath'




exec sp_addextendedproperty N'MS_Description', null, N'user', N'dbo', N'table', N'i_Sys_Room', N'column', N'i_Sys_Room_ManagerUsers'
exec sp_addextendedproperty N'MS_Description', N'ҳͷ', N'user', N'dbo', N'table', N'i_Sys_Room', N'column', N'i_Sys_Room_StyleTop'
exec sp_addextendedproperty N'MS_Description', N'cssļ', N'user', N'dbo', N'table', N'i_Sys_Room', N'column', N'i_Sys_Room_StyleCss'
exec sp_addextendedproperty N'MS_Description', N'䱳ͼƬ', N'user', N'dbo', N'table', N'i_Sys_Room', N'column', N'i_Sys_Room_BackGround'
exec sp_addextendedproperty N'MS_Description', N'Ƿ,0,1', N'user', N'dbo', N'table', N'i_Sys_Room', N'column', N'i_Sys_Room_Enable'
exec sp_addextendedproperty N'MS_Description', N'0Ϊ,1Ϊٱ', N'user', N'dbo', N'table', N'i_Sys_Room', N'column', N'i_Sys_Room_Monitor'
exec sp_addextendedproperty N'MS_Description', N'Ƿ¼Ϣ,0,1', N'user', N'dbo', N'table', N'i_Sys_Room', N'column', N'i_Sys_Room_OpenMsgRecord'
exec sp_addextendedproperty N'MS_Description', N'', N'user', N'dbo', N'table', N'i_Sys_Room', N'column', N'i_Sys_Room_BlackList'
exec sp_addextendedproperty N'MS_Description', N'0 false,1 true', N'user', N'dbo', N'table', N'i_Sys_Room', N'column', N'i_Sys_Room_Mic02_IsHiFi'




exec sp_addextendedproperty N'MS_Description', N'עID', N'user', N'dbo', N'table', N'i_User_Attention', N'column', N'i_User_Attention_UID'
exec sp_addextendedproperty N'MS_Description', N'עID', N'user', N'dbo', N'table', N'i_User_Attention', N'column', N'i_User_Attention_GUID'




exec sp_addextendedproperty N'MS_Description', N'cssʽ', N'user', N'dbo', N'table', N'i_User_Class', N'column', N'i_User_Class_Style'
exec sp_addextendedproperty N'MS_Description', N'û֧ӵõûֵ', N'user', N'dbo', N'table', N'i_User_Class', N'column', N'i_User_Class_SortValue'
exec sp_addextendedproperty N'MS_Description', N'ۼ', N'user', N'dbo', N'table', N'i_User_Class', N'column', N'i_User_Class_PayMoney'
exec sp_addextendedproperty N'MS_Description', N'Ƿֱ', N'user', N'dbo', N'table', N'i_User_Class', N'column', N'i_User_Class_CouldLive'
exec sp_addextendedproperty N'MS_Description', N'ǷԹ', N'user', N'dbo', N'table', N'i_User_Class', N'column', N'i_User_Class_CouldPubSay'
exec sp_addextendedproperty N'MS_Description', N'Ƿ˽', N'user', N'dbo', N'table', N'i_User_Class', N'column', N'i_User_Class_CouldPriSay'
exec sp_addextendedproperty N'MS_Description', N'ȼɳٶ', N'user', N'dbo', N'table', N'i_User_Class', N'column', N'i_User_Class_ScoreSpeed'
exec sp_addextendedproperty N'MS_Description', N'', N'user', N'dbo', N'table', N'i_User_Class', N'column', N'i_User_Class_Discount'
exec sp_addextendedproperty N'MS_Description', N'', N'user', N'dbo', N'table', N'i_User_Class', N'column', N'i_User_Class_FreeSpeaker'
exec sp_addextendedproperty N'MS_Description', N'ļĬϼ', N'user', N'dbo', N'table', N'i_User_Class', N'column', N'i_User_Class_GroupLevel'
exec sp_addextendedproperty N'MS_Description', N'ɽ', N'user', N'dbo', N'table', N'i_User_Class', N'column', N'i_User_Class_GroupCount'
exec sp_addextendedproperty N'MS_Description', N'Ƿ', N'user', N'dbo', N'table', N'i_User_Class', N'column', N'i_User_Class_DisKick'
exec sp_addextendedproperty N'MS_Description', N'ɽԱ', N'user', N'dbo', N'table', N'i_User_Class', N'column', N'i_User_Class_AlwaysEnterRoom'
exec sp_addextendedproperty N'MS_Description', N'', N'user', N'dbo', N'table', N'i_User_Class', N'column', N'i_User_Class_Sort'




exec sp_addextendedproperty N'MS_Description', N'Ѽ¼', N'user', N'dbo', N'table', N'i_User_ConsumeRecord', N'column', N'i_User_ConsumeRecord_ID'
exec sp_addextendedproperty N'MS_Description', N'0 pay,1 income', N'user', N'dbo', N'table', N'i_User_ConsumeRecord', N'column', N'i_User_ConsumeRecord_Type'
exec sp_addextendedproperty N'MS_Description', N'֧', N'user', N'dbo', N'table', N'i_User_ConsumeRecord', N'column', N'i_User_ConsumeRecord_PayNum'
exec sp_addextendedproperty N'MS_Description', N'', N'user', N'dbo', N'table', N'i_User_ConsumeRecord', N'column', N'i_User_ConsumeRecord_Store'




exec sp_addextendedproperty N'MS_Description', N'0,1,2Ѵ', N'user', N'dbo', N'table', N'i_User_Extraction', N'column', N'i_User_Extraction_Status'




exec sp_addextendedproperty N'MS_Description', N'UID', N'user', N'dbo', N'table', N'i_User_Friends', N'column', N'i_User_Friends_UID'
exec sp_addextendedproperty N'MS_Description', N'0 apply,1 access, -1 false', N'user', N'dbo', N'table', N'i_User_Friends', N'column', N'i_User_Friends_Status'




exec sp_addextendedproperty N'MS_Description', N'ӦͼƬ·', N'user', N'dbo', N'table', N'i_User_Gift', N'column', N'i_User_Gift_ImgUrl'
exec sp_addextendedproperty N'MS_Description', N'Ҫû(ûֶ)', N'user', N'dbo', N'table', N'i_User_Gift', N'column', N'i_User_Gift_MinUserClassSort'
exec sp_addextendedproperty N'MS_Description', N'Ҫû(ֶ)', N'user', N'dbo', N'table', N'i_User_Gift', N'column', N'i_User_Gift_MinUserLevelSort'
exec sp_addextendedproperty N'MS_Description', N'Ƿ,0,1', N'user', N'dbo', N'table', N'i_User_Gift', N'column', N'i_User_Gift_Enable'




exec sp_addextendedproperty N'MS_Description', N'', N'user', N'dbo', N'table', N'i_User_GiftDiscount', N'column', N'i_User_GiftDiscount_Discount'




exec sp_addextendedproperty N'MS_Description', N'0 is null or system', N'user', N'dbo', N'table', N'i_User_GiftStore', N'column', N'i_User_GiftStore_UID'




exec sp_addextendedproperty N'MS_Description', N'ۿ', N'user', N'dbo', N'table', N'i_User_Gift_SendRecord', N'column', N'i_User_Gift_SendRecord_GiftDiscount'




exec sp_addextendedproperty N'MS_Description', N'ȼ', N'user', N'dbo', N'table', N'i_User_InComeLevel', N'column', N'i_User_InComeLevel_ID'




exec sp_addextendedproperty N'MS_Description', N'0Ů,1', N'user', N'dbo', N'table', N'i_User_Info', N'column', N'i_User_Sex'
exec sp_addextendedproperty N'MS_Description', N'', N'user', N'dbo', N'table', N'i_User_Info', N'column', N'i_User_PayNum'
exec sp_addextendedproperty N'MS_Description', N'', N'user', N'dbo', N'table', N'i_User_Info', N'column', N'i_User_IncomeNum'
exec sp_addextendedproperty N'MS_Description', N'û/Ⱥ', N'user', N'dbo', N'table', N'i_User_Info', N'column', N'i_User_Group'
exec sp_addextendedproperty N'MS_Description', N'ͷ', N'user', N'dbo', N'table', N'i_User_Info', N'column', N'i_User_Titles'
exec sp_addextendedproperty N'MS_Description', N'ǩ', N'user', N'dbo', N'table', N'i_User_Info', N'column', N'i_User_Label'
exec sp_addextendedproperty N'MS_Description', N'ҽ', N'user', N'dbo', N'table', N'i_User_Info', N'column', N'i_User_About'
exec sp_addextendedproperty N'MS_Description', N'ͷ', N'user', N'dbo', N'table', N'i_User_Info', N'column', N'i_User_Face'
exec sp_addextendedproperty N'MS_Description', N'һ', N'user', N'dbo', N'table', N'i_User_Info', N'column', N'i_User_Question'
exec sp_addextendedproperty N'MS_Description', N'һش', N'user', N'dbo', N'table', N'i_User_Info', N'column', N'i_User_Answer'
exec sp_addextendedproperty N'MS_Description', N'⹫ֱʱ', N'user', N'dbo', N'table', N'i_User_Info', N'column', N'i_User_FixLiveTime'
exec sp_addextendedproperty N'MS_Description', N'', N'user', N'dbo', N'table', N'i_User_Info', N'column', N'i_User_ViewNum'
exec sp_addextendedproperty N'MS_Description', N'һֱʱ', N'user', N'dbo', N'table', N'i_User_Info', N'column', N'i_User_LastLiveTime'
exec sp_addextendedproperty N'MS_Description', N'жǷֱ', N'user', N'dbo', N'table', N'i_User_Info', N'column', N'i_User_ForUpdateTime'
exec sp_addextendedproperty N'MS_Description', null, N'user', N'dbo', N'table', N'i_User_Info', N'column', N'i_User_isStop'
exec sp_addextendedproperty N'MS_Description', N'עʱ', N'user', N'dbo', N'table', N'i_User_Info', N'column', N'i_User_RegTime'
exec sp_addextendedproperty N'MS_Description', N'ʣ', N'user', N'dbo', N'table', N'i_User_Info', N'column', N'i_User_SpeakerNum'
exec sp_addextendedproperty N'MS_Description', N'߷', N'user', N'dbo', N'table', N'i_User_Info', N'column', N'i_User_Online'
exec sp_addextendedproperty N'MS_Description', N'ǷǩԼ', N'user', N'dbo', N'table', N'i_User_Info', N'column', N'i_User_IsContract'
exec sp_addextendedproperty N'MS_Description', N'Ƿ', N'user', N'dbo', N'table', N'i_User_Info', N'column', N'i_User_IsLock'
exec sp_addextendedproperty N'MS_Description', N'ǷǩԼ', N'user', N'dbo', N'table', N'i_User_Info', N'column', N'i_User_Signing'
exec sp_addextendedproperty N'MS_Description', N'ǷƼ,0,1', N'user', N'dbo', N'table', N'i_User_Info', N'column', N'i_User_IsRecommend'




exec sp_addextendedproperty N'MS_Description', N'Ӧcssʽ', N'user', N'dbo', N'table', N'i_User_Level', N'column', N'i_User_Level_Style'
exec sp_addextendedproperty N'MS_Description', N'Ƿ', N'user', N'dbo', N'table', N'i_User_Level', N'column', N'i_User_Level_CreatFamily'
exec sp_addextendedproperty N'MS_Description', N'', N'user', N'dbo', N'table', N'i_User_Level', N'column', N'i_User_Level_Sort'




exec sp_addextendedproperty N'MS_Description', N'û̬', N'user', N'dbo', N'table', N'i_User_Log', N'column', N'i_User_Log_ID'
exec sp_addextendedproperty N'MS_Description', N'RoomID', N'user', N'dbo', N'table', N'i_User_Log', N'column', N'i_User_Log_RID'




exec sp_addextendedproperty N'MS_Description', N'ѵȼID', N'user', N'dbo', N'table', N'i_User_PaymentLevel', N'column', N'i_User_PaymentLevel_ID'





Insert Into [i_Sys_Config] ([i_Sys_Config_SysName],[i_Sys_Config_MoneyName],[i_Sys_Config_IndexPageSize],[i_Sys_Config_FlyMsgMoney],[i_Sys_Config_SysTipMoney],[i_Sys_Config_SeatMsgMoney],[i_Sys_Config_IndexCacheRefreshTime],[i_Sys_Config_IndexCacheRefreshSpace],[i_Sys_Config_ListPageSize],[i_Sys_Config_ListCacheRefreshTime],[i_Sys_Config_ListCacheRefreshSpace],[i_Sys_Config_GiftPercent],[i_Sys_Config_PayPercent],[i_Sys_Config_ExtractionPercent],[i_Sys_Config_ScoreStep],[i_Sys_Config_OpenReg],[i_Sys_Config_OpenRoom],[i_Sys_Config_OpenGuest],[i_Sys_Config_OpenUpload],[i_Sys_Config_OpenUCenter],[i_Sys_Config_UploadFileSize],[i_Sys_Config_UploadFileTypes],[i_Sys_Config_QQAppID],[i_Sys_Config_QQAppKey],[i_Sys_Config_LoginUrl],[i_Sys_Config_RegDefaultClass],[i_Sys_Config_RegDefaultMoneyNum],[i_Sys_Config_RegDefaultScoreNum],[i_Sys_Config_SendSpaceTime],[i_Sys_Config_TemplatePath],[i_Sys_Config_ReplaceKeys],[i_Sys_Config_MailServer],[i_Sys_Config_MailAdd],[i_Sys_Config_MailUserName],[i_Sys_Config_MailPass]) Values('Feelink Ƶֱ','Ԫ','30','50','500','0',null,'600','30',null,'180','0.7','100','0.6','10','1','1','1','1','0',null,null,'100332522','ce35f02e76caa4c4fdda5883ef833027',null,'4','100000','0','1','v2','__Сƽ_______ɧ_','smtp.qq.com','','','')

SET IDENTITY_INSERT [i_Sys_Notice] ON
Insert Into [i_Sys_Notice] ([i_Sys_Notice_ID],[i_Sys_Notice_Name],[i_Sys_Notice_Href],[i_Sys_Notice_Content],[i_Sys_Notice_Time],[i_Sys_Notice_Sort]) Values('6','iShowʽΪFeelink','#',' ','2012-09-10 00:53:10','0')
Insert Into [i_Sys_Notice] ([i_Sys_Notice_ID],[i_Sys_Notice_Name],[i_Sys_Notice_Href],[i_Sys_Notice_Content],[i_Sys_Notice_Time],[i_Sys_Notice_Sort]) Values('15','<b>кʹѯ>></b>','http://wpa.qq.com/msgrd?uin=537060676&site=qq&v=3&menu=yes',' ','2012-09-10 10:00:31','0')
Insert Into [i_Sys_Notice] ([i_Sys_Notice_ID],[i_Sys_Notice_Name],[i_Sys_Notice_Href],[i_Sys_Notice_Content],[i_Sys_Notice_Time],[i_Sys_Notice_Sort]) Values('29','Feelinkѯ','http://wpa.qq.com/msgrd?uin=837560106&site=qq&v=3&menu=yes',' ','2013-01-06 21:49:40','0')
Insert Into [i_Sys_Notice] ([i_Sys_Notice_ID],[i_Sys_Notice_Name],[i_Sys_Notice_Href],[i_Sys_Notice_Content],[i_Sys_Notice_Time],[i_Sys_Notice_Sort]) Values('32','<b>ؿԴð棡</b>','http://www.asp300.com/SoftView/10/SoftView_44854.html',' ','2013-02-23 10:18:45','0')
Insert Into [i_Sys_Notice] ([i_Sys_Notice_ID],[i_Sys_Notice_Name],[i_Sys_Notice_Href],[i_Sys_Notice_Content],[i_Sys_Notice_Time],[i_Sys_Notice_Sort]) Values('33','2.4°淢 ۼ15000Ԫ ','http://wpa.qq.com/msgrd?uin=537060676&site=qq&v=3&menu=yes',' ','2013-02-26 15:56:01','0')
Insert Into [i_Sys_Notice] ([i_Sys_Notice_ID],[i_Sys_Notice_Name],[i_Sys_Notice_Href],[i_Sys_Notice_Content],[i_Sys_Notice_Time],[i_Sys_Notice_Sort]) Values('36','<b>°淢ڼ, ¹: ֧P2P+FMS˫ģʽ!!!</b>','#','<font color="green">°汾12ŷ,°۸2W,°֧p2p+ת ˫ģʽ!</font>','2013-03-08 13:45:59','0')
SET IDENTITY_INSERT [i_Sys_Notice] OFF






SET IDENTITY_INSERT [i_Sys_Room_Class] ON
Insert Into [i_Sys_Room_Class] ([i_Sys_Room_Class_ID],[i_Sys_Room_Class_Name],[i_Sys_Room_CLass_ParentID],[i_Sys_Room_Class_Sort]) Values('1','','17','60')
Insert Into [i_Sys_Room_Class] ([i_Sys_Room_Class_ID],[i_Sys_Room_Class_Name],[i_Sys_Room_CLass_ParentID],[i_Sys_Room_Class_Sort]) Values('2','','17','60')
Insert Into [i_Sys_Room_Class] ([i_Sys_Room_Class_ID],[i_Sys_Room_Class_Name],[i_Sys_Room_CLass_ParentID],[i_Sys_Room_Class_Sort]) Values('3','','17','60')
Insert Into [i_Sys_Room_Class] ([i_Sys_Room_Class_ID],[i_Sys_Room_Class_Name],[i_Sys_Room_CLass_ParentID],[i_Sys_Room_Class_Sort]) Values('4','','17','60')
Insert Into [i_Sys_Room_Class] ([i_Sys_Room_Class_ID],[i_Sys_Room_Class_Name],[i_Sys_Room_CLass_ParentID],[i_Sys_Room_Class_Sort]) Values('5','ݳ','17','60')
Insert Into [i_Sys_Room_Class] ([i_Sys_Room_Class_ID],[i_Sys_Room_Class_Name],[i_Sys_Room_CLass_ParentID],[i_Sys_Room_Class_Sort]) Values('6','ѵ','17','60')
Insert Into [i_Sys_Room_Class] ([i_Sys_Room_Class_ID],[i_Sys_Room_Class_Name],[i_Sys_Room_CLass_ParentID],[i_Sys_Room_Class_Sort]) Values('8','̨','0','50')
Insert Into [i_Sys_Room_Class] ([i_Sys_Room_Class_ID],[i_Sys_Room_Class_Name],[i_Sys_Room_CLass_ParentID],[i_Sys_Room_Class_Sort]) Values('9','MC','8','0')
Insert Into [i_Sys_Room_Class] ([i_Sys_Room_Class_ID],[i_Sys_Room_Class_Name],[i_Sys_Room_CLass_ParentID],[i_Sys_Room_Class_Sort]) Values('10','','8','0')
Insert Into [i_Sys_Room_Class] ([i_Sys_Room_Class_ID],[i_Sys_Room_Class_Name],[i_Sys_Room_CLass_ParentID],[i_Sys_Room_Class_Sort]) Values('11','','8','0')
Insert Into [i_Sys_Room_Class] ([i_Sys_Room_Class_ID],[i_Sys_Room_Class_Name],[i_Sys_Room_CLass_ParentID],[i_Sys_Room_Class_Sort]) Values('12','İ','8','0')
Insert Into [i_Sys_Room_Class] ([i_Sys_Room_Class_ID],[i_Sys_Room_Class_Name],[i_Sys_Room_CLass_ParentID],[i_Sys_Room_Class_Sort]) Values('13','','8','0')
Insert Into [i_Sys_Room_Class] ([i_Sys_Room_Class_ID],[i_Sys_Room_Class_Name],[i_Sys_Room_CLass_ParentID],[i_Sys_Room_Class_Sort]) Values('14','㳪','8','0')
Insert Into [i_Sys_Room_Class] ([i_Sys_Room_Class_ID],[i_Sys_Room_Class_Name],[i_Sys_Room_CLass_ParentID],[i_Sys_Room_Class_Sort]) Values('15','','17','60')
Insert Into [i_Sys_Room_Class] ([i_Sys_Room_Class_ID],[i_Sys_Room_Class_Name],[i_Sys_Room_CLass_ParentID],[i_Sys_Room_Class_Sort]) Values('16','','17','60')
Insert Into [i_Sys_Room_Class] ([i_Sys_Room_Class_ID],[i_Sys_Room_Class_Name],[i_Sys_Room_CLass_ParentID],[i_Sys_Room_Class_Sort]) Values('17','','0','70')
Insert Into [i_Sys_Room_Class] ([i_Sys_Room_Class_ID],[i_Sys_Room_Class_Name],[i_Sys_Room_CLass_ParentID],[i_Sys_Room_Class_Sort]) Values('19','Ϸ','0','-1')
Insert Into [i_Sys_Room_Class] ([i_Sys_Room_Class_ID],[i_Sys_Room_Class_Name],[i_Sys_Room_CLass_ParentID],[i_Sys_Room_Class_Sort]) Values('20','Ϸ','19','-10')
Insert Into [i_Sys_Room_Class] ([i_Sys_Room_Class_ID],[i_Sys_Room_Class_Name],[i_Sys_Room_CLass_ParentID],[i_Sys_Room_Class_Sort]) Values('21','Ϸ','19','-10')
Insert Into [i_Sys_Room_Class] ([i_Sys_Room_Class_ID],[i_Sys_Room_Class_Name],[i_Sys_Room_CLass_ParentID],[i_Sys_Room_Class_Sort]) Values('22','ֻϷ','19','-10')
Insert Into [i_Sys_Room_Class] ([i_Sys_Room_Class_ID],[i_Sys_Room_Class_Name],[i_Sys_Room_CLass_ParentID],[i_Sys_Room_Class_Sort]) Values('23','׿ƽ̨','19','-10')
SET IDENTITY_INSERT [i_Sys_Room_Class] OFF

SET IDENTITY_INSERT [i_User_Class] ON
Insert Into [i_User_Class] ([i_User_Class_ID],[i_User_Class_Name],[i_User_Class_Style],[i_User_Class_SortValue],[i_User_Class_PayMoney],[i_User_Class_CouldLive],[i_User_Class_CouldPubSay],[i_User_Class_CouldPriSay],[i_User_Class_ScoreSpeed],[i_User_Class_Discount],[i_User_Class_FreeSpeaker],[i_User_Class_GroupLevel],[i_User_Class_GroupCount],[i_User_Class_DisKick],[i_User_Class_AlwaysEnterRoom],[i_User_Class_PowerKeys],[i_User_Class_Sort]) Values('2','VIP','vip','10','0','1','1','1','1','1','0','0','0','0','0',null,'10')
Insert Into [i_User_Class] ([i_User_Class_ID],[i_User_Class_Name],[i_User_Class_Style],[i_User_Class_SortValue],[i_User_Class_PayMoney],[i_User_Class_CouldLive],[i_User_Class_CouldPubSay],[i_User_Class_CouldPriSay],[i_User_Class_ScoreSpeed],[i_User_Class_Discount],[i_User_Class_FreeSpeaker],[i_User_Class_GroupLevel],[i_User_Class_GroupCount],[i_User_Class_DisKick],[i_User_Class_AlwaysEnterRoom],[i_User_Class_PowerKeys],[i_User_Class_Sort]) Values('4','ͨû','','0','0','1','1','1','1','1','0','0','0','0','0',null,'1')
Insert Into [i_User_Class] ([i_User_Class_ID],[i_User_Class_Name],[i_User_Class_Style],[i_User_Class_SortValue],[i_User_Class_PayMoney],[i_User_Class_CouldLive],[i_User_Class_CouldPubSay],[i_User_Class_CouldPriSay],[i_User_Class_ScoreSpeed],[i_User_Class_Discount],[i_User_Class_FreeSpeaker],[i_User_Class_GroupLevel],[i_User_Class_GroupCount],[i_User_Class_DisKick],[i_User_Class_AlwaysEnterRoom],[i_User_Class_PowerKeys],[i_User_Class_Sort]) Values('7','','vip_m','10','0','1','1','1','1','1','0','0','0','0','0',null,'10')
SET IDENTITY_INSERT [i_User_Class] OFF


SET IDENTITY_INSERT [i_User_Gift] ON
Insert Into [i_User_Gift] ([i_User_Gift_ID],[i_User_Gift_Name],[i_User_Gift_Class],[i_User_Gift_ImgUrl],[i_User_Gift_Price],[i_User_Gift_ShowType],[i_User_Gift_PlayTime],[i_User_Gift_SwfUrl],[i_User_Gift_MinUserClassSort],[i_User_Gift_MinUserLevelSort],[i_User_Gift_Enable],[i_User_Gift_Sort]) Values('2','','lollipop',null,'100','0','3','http://www.56.com/flashApp/vshow/gift.13.02.19.a.swf?type=small&show_time=10000&gift_shape=0&gift_id=101','0','0','1','0')
Insert Into [i_User_Gift] ([i_User_Gift_ID],[i_User_Gift_Name],[i_User_Gift_Class],[i_User_Gift_ImgUrl],[i_User_Gift_Price],[i_User_Gift_ShowType],[i_User_Gift_PlayTime],[i_User_Gift_SwfUrl],[i_User_Gift_MinUserClassSort],[i_User_Gift_MinUserLevelSort],[i_User_Gift_Enable],[i_User_Gift_Sort]) Values('4','ͷ','pig',null,'2','0','3','http://www.56.com/flashApp/vshow/gift.13.02.19.a.swf?type=small&show_time=10000&gift_shape=0&gift_id=106','0','0','1','0')
Insert Into [i_User_Gift] ([i_User_Gift_ID],[i_User_Gift_Name],[i_User_Gift_Class],[i_User_Gift_ImgUrl],[i_User_Gift_Price],[i_User_Gift_ShowType],[i_User_Gift_PlayTime],[i_User_Gift_SwfUrl],[i_User_Gift_MinUserClassSort],[i_User_Gift_MinUserLevelSort],[i_User_Gift_Enable],[i_User_Gift_Sort]) Values('5','','applause',null,'2','0','3','http://www.56.com/flashApp/vshow/gift.13.02.19.a.swf?type=small&show_time=10000&gift_shape=0&gift_id=105','0','0','1','0')
Insert Into [i_User_Gift] ([i_User_Gift_ID],[i_User_Gift_Name],[i_User_Gift_Class],[i_User_Gift_ImgUrl],[i_User_Gift_Price],[i_User_Gift_ShowType],[i_User_Gift_PlayTime],[i_User_Gift_SwfUrl],[i_User_Gift_MinUserClassSort],[i_User_Gift_MinUserLevelSort],[i_User_Gift_Enable],[i_User_Gift_Sort]) Values('6','ôô','kiss',null,'3','0','3','http://www.56.com/flashApp/vshow/gift.13.02.19.a.swf?type=small&show_time=15000&gift_shape=0&gift_id=212','0','0','1','0')
Insert Into [i_User_Gift] ([i_User_Gift_ID],[i_User_Gift_Name],[i_User_Gift_Class],[i_User_Gift_ImgUrl],[i_User_Gift_Price],[i_User_Gift_ShowType],[i_User_Gift_PlayTime],[i_User_Gift_SwfUrl],[i_User_Gift_MinUserClassSort],[i_User_Gift_MinUserLevelSort],[i_User_Gift_Enable],[i_User_Gift_Sort]) Values('7','Ҵ','resipiscence',null,'3','0','3','http://www.56.com/flashApp/vshow/gift.13.02.19.a.swf?type=small&show_time=15000&gift_shape=0&gift_id=109','0','0','1','0')
Insert Into [i_User_Gift] ([i_User_Gift_ID],[i_User_Gift_Name],[i_User_Gift_Class],[i_User_Gift_ImgUrl],[i_User_Gift_Price],[i_User_Gift_ShowType],[i_User_Gift_PlayTime],[i_User_Gift_SwfUrl],[i_User_Gift_MinUserClassSort],[i_User_Gift_MinUserLevelSort],[i_User_Gift_Enable],[i_User_Gift_Sort]) Values('8','ֱ','helicopter',null,'3','0','3','http://www.56.com/flashApp/vshow/gift.13.02.19.a.swf?type=large&show_time=30000&gift_shape=0&gift_id=402','0','0','1','0')
Insert Into [i_User_Gift] ([i_User_Gift_ID],[i_User_Gift_Name],[i_User_Gift_Class],[i_User_Gift_ImgUrl],[i_User_Gift_Price],[i_User_Gift_ShowType],[i_User_Gift_PlayTime],[i_User_Gift_SwfUrl],[i_User_Gift_MinUserClassSort],[i_User_Gift_MinUserLevelSort],[i_User_Gift_Enable],[i_User_Gift_Sort]) Values('9','˽˱','villa',null,'3','0','15','http://www.56.com/flashApp/vshow/gift.13.02.19.a.swf?type=large&show_time=30000&gift_shape=0&gift_id=405','0','0','1','0')
Insert Into [i_User_Gift] ([i_User_Gift_ID],[i_User_Gift_Name],[i_User_Gift_Class],[i_User_Gift_ImgUrl],[i_User_Gift_Price],[i_User_Gift_ShowType],[i_User_Gift_PlayTime],[i_User_Gift_SwfUrl],[i_User_Gift_MinUserClassSort],[i_User_Gift_MinUserLevelSort],[i_User_Gift_Enable],[i_User_Gift_Sort]) Values('10','˽˷ɻ','airplane',null,'3','0','25','http://www.56.com/flashApp/vshow/gift.13.02.19.a.swf?type=large&show_time=30000&gift_shape=0&gift_id=404','0','0','1','0')
Insert Into [i_User_Gift] ([i_User_Gift_ID],[i_User_Gift_Name],[i_User_Gift_Class],[i_User_Gift_ImgUrl],[i_User_Gift_Price],[i_User_Gift_ShowType],[i_User_Gift_PlayTime],[i_User_Gift_SwfUrl],[i_User_Gift_MinUserClassSort],[i_User_Gift_MinUserLevelSort],[i_User_Gift_Enable],[i_User_Gift_Sort]) Values('11','ս','fighter',null,'4','0','3','http://www.56.com/flashApp/vshow/gift.13.02.19.a.swf?type=large&show_time=30000&gift_shape=0&gift_id=406','0','0','1','0')
Insert Into [i_User_Gift] ([i_User_Gift_ID],[i_User_Gift_Name],[i_User_Gift_Class],[i_User_Gift_ImgUrl],[i_User_Gift_Price],[i_User_Gift_ShowType],[i_User_Gift_PlayTime],[i_User_Gift_SwfUrl],[i_User_Gift_MinUserClassSort],[i_User_Gift_MinUserLevelSort],[i_User_Gift_Enable],[i_User_Gift_Sort]) Values('12','ĸ','aircraftCarrier',null,'5','3','30','http://www.56.com/flashApp/vshow/gift.13.02.19.a.swf?type=large&show_time=30000&gift_shape=0&gift_id=616','0','0','1','0')
Insert Into [i_User_Gift] ([i_User_Gift_ID],[i_User_Gift_Name],[i_User_Gift_Class],[i_User_Gift_ImgUrl],[i_User_Gift_Price],[i_User_Gift_ShowType],[i_User_Gift_PlayTime],[i_User_Gift_SwfUrl],[i_User_Gift_MinUserClassSort],[i_User_Gift_MinUserLevelSort],[i_User_Gift_Enable],[i_User_Gift_Sort]) Values('13','','qiuhun',null,'9','3','7','http://www.56.com/flashApp/vshow/gift.13.02.19.a.swf?type=large&show_time=30000&gift_shape=0&gift_id=411','0','0','1','0')
Insert Into [i_User_Gift] ([i_User_Gift_ID],[i_User_Gift_Name],[i_User_Gift_Class],[i_User_Gift_ImgUrl],[i_User_Gift_Price],[i_User_Gift_ShowType],[i_User_Gift_PlayTime],[i_User_Gift_SwfUrl],[i_User_Gift_MinUserClassSort],[i_User_Gift_MinUserLevelSort],[i_User_Gift_Enable],[i_User_Gift_Sort]) Values('14','Ļɽ','loveMountain',null,'6','3','3','','0','0','1','0')
Insert Into [i_User_Gift] ([i_User_Gift_ID],[i_User_Gift_Name],[i_User_Gift_Class],[i_User_Gift_ImgUrl],[i_User_Gift_Price],[i_User_Gift_ShowType],[i_User_Gift_PlayTime],[i_User_Gift_SwfUrl],[i_User_Gift_MinUserClassSort],[i_User_Gift_MinUserLevelSort],[i_User_Gift_Enable],[i_User_Gift_Sort]) Values('15','ˮЬ','shoes',null,'9','0','3','http://www.56.com/flashApp/vshow/gift.13.02.19.a.swf?type=small&show_time=10000&gift_shape=0&gift_id=300','0','0','1','0')
Insert Into [i_User_Gift] ([i_User_Gift_ID],[i_User_Gift_Name],[i_User_Gift_Class],[i_User_Gift_ImgUrl],[i_User_Gift_Price],[i_User_Gift_ShowType],[i_User_Gift_PlayTime],[i_User_Gift_SwfUrl],[i_User_Gift_MinUserClassSort],[i_User_Gift_MinUserLevelSort],[i_User_Gift_Enable],[i_User_Gift_Sort]) Values('16','','ring',null,'9','0','3','http://www.56.com/flashApp/vshow/gift.13.02.19.a.swf?type=small&show_time=15000&gift_shape=0&gift_id=306','0','0','1','0')
Insert Into [i_User_Gift] ([i_User_Gift_ID],[i_User_Gift_Name],[i_User_Gift_Class],[i_User_Gift_ImgUrl],[i_User_Gift_Price],[i_User_Gift_ShowType],[i_User_Gift_PlayTime],[i_User_Gift_SwfUrl],[i_User_Gift_MinUserClassSort],[i_User_Gift_MinUserLevelSort],[i_User_Gift_Enable],[i_User_Gift_Sort]) Values('17','','necklace',null,'9','0','3','http://www.56.com/flashApp/vshow/gift.13.02.19.a.swf?type=small&show_time=15000&gift_shape=0&gift_id=216','0','0','1','0')
Insert Into [i_User_Gift] ([i_User_Gift_ID],[i_User_Gift_Name],[i_User_Gift_Class],[i_User_Gift_ImgUrl],[i_User_Gift_Price],[i_User_Gift_ShowType],[i_User_Gift_PlayTime],[i_User_Gift_SwfUrl],[i_User_Gift_MinUserClassSort],[i_User_Gift_MinUserLevelSort],[i_User_Gift_Enable],[i_User_Gift_Sort]) Values('18','LV','lvbag',null,'9','0','3','http://www.56.com/flashApp/vshow/gift.13.02.19.a.swf?type=small&show_time=15000&gift_shape=0&gift_id=311','0','0','1','0')
Insert Into [i_User_Gift] ([i_User_Gift_ID],[i_User_Gift_Name],[i_User_Gift_Class],[i_User_Gift_ImgUrl],[i_User_Gift_Price],[i_User_Gift_ShowType],[i_User_Gift_PlayTime],[i_User_Gift_SwfUrl],[i_User_Gift_MinUserClassSort],[i_User_Gift_MinUserLevelSort],[i_User_Gift_Enable],[i_User_Gift_Sort]) Values('19','ʹ','crown',null,'3','0','3','http://www.56.com/flashApp/vshow/gift.13.02.19.a.swf?type=small&show_time=10000&gift_shape=0&gift_id=309','0','0','1','0')
Insert Into [i_User_Gift] ([i_User_Gift_ID],[i_User_Gift_Name],[i_User_Gift_Class],[i_User_Gift_ImgUrl],[i_User_Gift_Price],[i_User_Gift_ShowType],[i_User_Gift_PlayTime],[i_User_Gift_SwfUrl],[i_User_Gift_MinUserClassSort],[i_User_Gift_MinUserLevelSort],[i_User_Gift_Enable],[i_User_Gift_Sort]) Values('22','','car',null,'5','0','15','http://www.56.com/flashApp/vshow/gift.13.02.19.a.swf?type=large&show_time=10000&gift_shape=0&gift_id=409','0','0','1','0')
Insert Into [i_User_Gift] ([i_User_Gift_ID],[i_User_Gift_Name],[i_User_Gift_Class],[i_User_Gift_ImgUrl],[i_User_Gift_Price],[i_User_Gift_ShowType],[i_User_Gift_PlayTime],[i_User_Gift_SwfUrl],[i_User_Gift_MinUserClassSort],[i_User_Gift_MinUserLevelSort],[i_User_Gift_Enable],[i_User_Gift_Sort]) Values('23','õ','rose2',null,'81','0','3','http://www.56.com/flashApp/vshow/gift.13.02.19.a.swf?type=small&show_time=10000&gift_shape=0&gift_id=100','0','0','1','0')
Insert Into [i_User_Gift] ([i_User_Gift_ID],[i_User_Gift_Name],[i_User_Gift_Class],[i_User_Gift_ImgUrl],[i_User_Gift_Price],[i_User_Gift_ShowType],[i_User_Gift_PlayTime],[i_User_Gift_SwfUrl],[i_User_Gift_MinUserClassSort],[i_User_Gift_MinUserLevelSort],[i_User_Gift_Enable],[i_User_Gift_Sort]) Values('24','ɫ','blueRose2',null,'6','0','3','http://www.56.com/flashApp/vshow/gift.13.02.19.a.swf?type=small&show_time=10000&gift_shape=0&gift_id=238','0','0','1','0')
Insert Into [i_User_Gift] ([i_User_Gift_ID],[i_User_Gift_Name],[i_User_Gift_Class],[i_User_Gift_ImgUrl],[i_User_Gift_Price],[i_User_Gift_ShowType],[i_User_Gift_PlayTime],[i_User_Gift_SwfUrl],[i_User_Gift_MinUserClassSort],[i_User_Gift_MinUserLevelSort],[i_User_Gift_Enable],[i_User_Gift_Sort]) Values('25','ű','barbieDoll',null,'8','0','3','http://www.56.com/flashApp/vshow/gift.13.02.19.a.swf?type=small&show_time=15000&gift_shape=0&gift_id=249','0','0','1','0')
Insert Into [i_User_Gift] ([i_User_Gift_ID],[i_User_Gift_Name],[i_User_Gift_Class],[i_User_Gift_ImgUrl],[i_User_Gift_Price],[i_User_Gift_ShowType],[i_User_Gift_PlayTime],[i_User_Gift_SwfUrl],[i_User_Gift_MinUserClassSort],[i_User_Gift_MinUserLevelSort],[i_User_Gift_Enable],[i_User_Gift_Sort]) Values('26','̩','teddyBear',null,'7','0','7','http://www.56.com/flashApp/vshow/gift.13.02.19.a.swf?type=small&show_time=15000&gift_shape=0&gift_id=210','0','0','1','0')
Insert Into [i_User_Gift] ([i_User_Gift_ID],[i_User_Gift_Name],[i_User_Gift_Class],[i_User_Gift_ImgUrl],[i_User_Gift_Price],[i_User_Gift_ShowType],[i_User_Gift_PlayTime],[i_User_Gift_SwfUrl],[i_User_Gift_MinUserClassSort],[i_User_Gift_MinUserLevelSort],[i_User_Gift_Enable],[i_User_Gift_Sort]) Values('28','','cupid',null,'7','0','3','http://www.56.com/flashApp/vshow/gift.13.02.19.a.swf?type=small&show_time=10000&gift_shape=0&gift_id=149','0','0','1','0')
Insert Into [i_User_Gift] ([i_User_Gift_ID],[i_User_Gift_Name],[i_User_Gift_Class],[i_User_Gift_ImgUrl],[i_User_Gift_Price],[i_User_Gift_ShowType],[i_User_Gift_PlayTime],[i_User_Gift_SwfUrl],[i_User_Gift_MinUserClassSort],[i_User_Gift_MinUserLevelSort],[i_User_Gift_Enable],[i_User_Gift_Sort]) Values('29','','fighting',null,'7','0','6','http://www.56.com/flashApp/vshow/gift.13.02.19.a.swf?type=small&show_time=10000&gift_shape=0&gift_id=103','0','0','1','0')
Insert Into [i_User_Gift] ([i_User_Gift_ID],[i_User_Gift_Name],[i_User_Gift_Class],[i_User_Gift_ImgUrl],[i_User_Gift_Price],[i_User_Gift_ShowType],[i_User_Gift_PlayTime],[i_User_Gift_SwfUrl],[i_User_Gift_MinUserClassSort],[i_User_Gift_MinUserLevelSort],[i_User_Gift_Enable],[i_User_Gift_Sort]) Values('30','лл','thanks',null,'7','0','2','http://www.56.com/flashApp/vshow/gift.13.02.19.a.swf?type=small&show_time=10000&gift_shape=0&gift_id=108','0','0','1','0')
Insert Into [i_User_Gift] ([i_User_Gift_ID],[i_User_Gift_Name],[i_User_Gift_Class],[i_User_Gift_ImgUrl],[i_User_Gift_Price],[i_User_Gift_ShowType],[i_User_Gift_PlayTime],[i_User_Gift_SwfUrl],[i_User_Gift_MinUserClassSort],[i_User_Gift_MinUserLevelSort],[i_User_Gift_Enable],[i_User_Gift_Sort]) Values('32','','lozenge',null,'8','0','3','http://www.56.com/flashApp/vshow/gift.13.02.19.a.swf?type=small&show_time=15000&gift_shape=0&gift_id=113','0','0','1','0')
Insert Into [i_User_Gift] ([i_User_Gift_ID],[i_User_Gift_Name],[i_User_Gift_Class],[i_User_Gift_ImgUrl],[i_User_Gift_Price],[i_User_Gift_ShowType],[i_User_Gift_PlayTime],[i_User_Gift_SwfUrl],[i_User_Gift_MinUserClassSort],[i_User_Gift_MinUserLevelSort],[i_User_Gift_Enable],[i_User_Gift_Sort]) Values('33','','flyMsg giftSmall',null,'50','0','3','','0','0','0','0')
Insert Into [i_User_Gift] ([i_User_Gift_ID],[i_User_Gift_Name],[i_User_Gift_Class],[i_User_Gift_ImgUrl],[i_User_Gift_Price],[i_User_Gift_ShowType],[i_User_Gift_PlayTime],[i_User_Gift_SwfUrl],[i_User_Gift_MinUserClassSort],[i_User_Gift_MinUserLevelSort],[i_User_Gift_Enable],[i_User_Gift_Sort]) Values('37','ѩ','gf gf_194',null,'10','0','3','http://www.56.com/flashApp/vshow/gift.13.02.19.a.swf?type=small&show_time=8000&gift_shape=0&gift_id=194','0','0','1','0')
Insert Into [i_User_Gift] ([i_User_Gift_ID],[i_User_Gift_Name],[i_User_Gift_Class],[i_User_Gift_ImgUrl],[i_User_Gift_Price],[i_User_Gift_ShowType],[i_User_Gift_PlayTime],[i_User_Gift_SwfUrl],[i_User_Gift_MinUserClassSort],[i_User_Gift_MinUserLevelSort],[i_User_Gift_Enable],[i_User_Gift_Sort]) Values('38','','gf gf_187',null,'10','0','3','http://www.56.com/flashApp/vshow/gift.13.02.19.a.swf?type=small&show_time=8000&gift_shape=0&gift_id=187','0','0','1','0')
Insert Into [i_User_Gift] ([i_User_Gift_ID],[i_User_Gift_Name],[i_User_Gift_Class],[i_User_Gift_ImgUrl],[i_User_Gift_Price],[i_User_Gift_ShowType],[i_User_Gift_PlayTime],[i_User_Gift_SwfUrl],[i_User_Gift_MinUserClassSort],[i_User_Gift_MinUserLevelSort],[i_User_Gift_Enable],[i_User_Gift_Sort]) Values('39','˲','gf gf_128',null,'10','0','3','http://www.56.com/flashApp/vshow/gift.13.02.19.a.swf?type=small&show_time=8000&gift_shape=0&gift_id=128','0','0','1','0')
Insert Into [i_User_Gift] ([i_User_Gift_ID],[i_User_Gift_Name],[i_User_Gift_Class],[i_User_Gift_ImgUrl],[i_User_Gift_Price],[i_User_Gift_ShowType],[i_User_Gift_PlayTime],[i_User_Gift_SwfUrl],[i_User_Gift_MinUserClassSort],[i_User_Gift_MinUserLevelSort],[i_User_Gift_Enable],[i_User_Gift_Sort]) Values('40','Ȳ','gf gf_102',null,'10','0','3','http://www.56.com/flashApp/vshow/gift.13.02.19.a.swf?type=small&show_time=8000&gift_shape=0&gift_id=102','0','0','1','0')
Insert Into [i_User_Gift] ([i_User_Gift_ID],[i_User_Gift_Name],[i_User_Gift_Class],[i_User_Gift_ImgUrl],[i_User_Gift_Price],[i_User_Gift_ShowType],[i_User_Gift_PlayTime],[i_User_Gift_SwfUrl],[i_User_Gift_MinUserClassSort],[i_User_Gift_MinUserLevelSort],[i_User_Gift_Enable],[i_User_Gift_Sort]) Values('41','ܰ','gf gf_124',null,'10','0','3','http://www.56.com/flashApp/vshow/gift.13.02.19.a.swf?type=small&show_time=8000&gift_shape=0&gift_id=124','0','0','1','0')
Insert Into [i_User_Gift] ([i_User_Gift_ID],[i_User_Gift_Name],[i_User_Gift_Class],[i_User_Gift_ImgUrl],[i_User_Gift_Price],[i_User_Gift_ShowType],[i_User_Gift_PlayTime],[i_User_Gift_SwfUrl],[i_User_Gift_MinUserClassSort],[i_User_Gift_MinUserLevelSort],[i_User_Gift_Enable],[i_User_Gift_Sort]) Values('42','','gf gf_251',null,'10','0','3','http://www.56.com/flashApp/vshow/gift.13.02.19.a.swf?type=small&show_time=15000&gift_shape=0&gift_id=251','0','0','1','0')
Insert Into [i_User_Gift] ([i_User_Gift_ID],[i_User_Gift_Name],[i_User_Gift_Class],[i_User_Gift_ImgUrl],[i_User_Gift_Price],[i_User_Gift_ShowType],[i_User_Gift_PlayTime],[i_User_Gift_SwfUrl],[i_User_Gift_MinUserClassSort],[i_User_Gift_MinUserLevelSort],[i_User_Gift_Enable],[i_User_Gift_Sort]) Values('43','û','gf gf_263',null,'10','0','3','http://www.56.com/flashApp/vshow/gift.13.02.19.a.swf?type=small&show_time=15000&gift_shape=0&gift_id=263','0','0','1','0')
Insert Into [i_User_Gift] ([i_User_Gift_ID],[i_User_Gift_Name],[i_User_Gift_Class],[i_User_Gift_ImgUrl],[i_User_Gift_Price],[i_User_Gift_ShowType],[i_User_Gift_PlayTime],[i_User_Gift_SwfUrl],[i_User_Gift_MinUserClassSort],[i_User_Gift_MinUserLevelSort],[i_User_Gift_Enable],[i_User_Gift_Sort]) Values('44','Сʹ','gf gf_235',null,'10','0','3','http://www.56.com/flashApp/vshow/gift.13.02.19.a.swf?type=small&show_time=15000&gift_shape=0&gift_id=235','0','0','1','0')
Insert Into [i_User_Gift] ([i_User_Gift_ID],[i_User_Gift_Name],[i_User_Gift_Class],[i_User_Gift_ImgUrl],[i_User_Gift_Price],[i_User_Gift_ShowType],[i_User_Gift_PlayTime],[i_User_Gift_SwfUrl],[i_User_Gift_MinUserClassSort],[i_User_Gift_MinUserLevelSort],[i_User_Gift_Enable],[i_User_Gift_Sort]) Values('45','ں','gf gf_207',null,'10','0','3','http://www.56.com/flashApp/vshow/gift.13.02.19.a.swf?type=small&show_time=15000&gift_shape=0&gift_id=207','0','0','1','0')
Insert Into [i_User_Gift] ([i_User_Gift_ID],[i_User_Gift_Name],[i_User_Gift_Class],[i_User_Gift_ImgUrl],[i_User_Gift_Price],[i_User_Gift_ShowType],[i_User_Gift_PlayTime],[i_User_Gift_SwfUrl],[i_User_Gift_MinUserClassSort],[i_User_Gift_MinUserLevelSort],[i_User_Gift_Enable],[i_User_Gift_Sort]) Values('46','','gf gf_350',null,'10','0','3','http://www.56.com/flashApp/vshow/gift.13.02.19.a.swf?type=small&show_time=15000&gift_shape=0&gift_id=350','0','0','1','0')
Insert Into [i_User_Gift] ([i_User_Gift_ID],[i_User_Gift_Name],[i_User_Gift_Class],[i_User_Gift_ImgUrl],[i_User_Gift_Price],[i_User_Gift_ShowType],[i_User_Gift_PlayTime],[i_User_Gift_SwfUrl],[i_User_Gift_MinUserClassSort],[i_User_Gift_MinUserLevelSort],[i_User_Gift_Enable],[i_User_Gift_Sort]) Values('47','ʻ','gf gf_200',null,'10','0','3','http://www.56.com/flashApp/vshow/gift.13.02.19.a.swf?type=small&show_time=15000&gift_shape=0&gift_id=200','0','0','1','0')
Insert Into [i_User_Gift] ([i_User_Gift_ID],[i_User_Gift_Name],[i_User_Gift_Class],[i_User_Gift_ImgUrl],[i_User_Gift_Price],[i_User_Gift_ShowType],[i_User_Gift_PlayTime],[i_User_Gift_SwfUrl],[i_User_Gift_MinUserClassSort],[i_User_Gift_MinUserLevelSort],[i_User_Gift_Enable],[i_User_Gift_Sort]) Values('48','','gf gf_204',null,'10','0','3','http://www.56.com/flashApp/vshow/gift.13.02.19.a.swf?type=small&show_time=15000&gift_shape=0&gift_id=204','0','0','1','0')
Insert Into [i_User_Gift] ([i_User_Gift_ID],[i_User_Gift_Name],[i_User_Gift_Class],[i_User_Gift_ImgUrl],[i_User_Gift_Price],[i_User_Gift_ShowType],[i_User_Gift_PlayTime],[i_User_Gift_SwfUrl],[i_User_Gift_MinUserClassSort],[i_User_Gift_MinUserLevelSort],[i_User_Gift_Enable],[i_User_Gift_Sort]) Values('49','ơ','gf gf_222',null,'10','0','3','http://www.56.com/flashApp/vshow/gift.13.02.19.a.swf?type=small&show_time=15000&gift_shape=0&gift_id=222','0','0','1','0')
Insert Into [i_User_Gift] ([i_User_Gift_ID],[i_User_Gift_Name],[i_User_Gift_Class],[i_User_Gift_ImgUrl],[i_User_Gift_Price],[i_User_Gift_ShowType],[i_User_Gift_PlayTime],[i_User_Gift_SwfUrl],[i_User_Gift_MinUserClassSort],[i_User_Gift_MinUserLevelSort],[i_User_Gift_Enable],[i_User_Gift_Sort]) Values('50','ں','gf gf_207',null,'10','0','3','http://www.56.com/flashApp/vshow/gift.13.02.19.a.swf?type=small&show_time=15000&gift_shape=0&gift_id=207','0','0','1','0')
Insert Into [i_User_Gift] ([i_User_Gift_ID],[i_User_Gift_Name],[i_User_Gift_Class],[i_User_Gift_ImgUrl],[i_User_Gift_Price],[i_User_Gift_ShowType],[i_User_Gift_PlayTime],[i_User_Gift_SwfUrl],[i_User_Gift_MinUserClassSort],[i_User_Gift_MinUserLevelSort],[i_User_Gift_Enable],[i_User_Gift_Sort]) Values('51','ӣ','gf gf_605',null,'10','3','3','http://www.56.com/flashApp/vshow/gift.13.02.19.a.swf?type=lage&show_time=40000&gift_shape=0&gift_id=605','0','0','1','0')
Insert Into [i_User_Gift] ([i_User_Gift_ID],[i_User_Gift_Name],[i_User_Gift_Class],[i_User_Gift_ImgUrl],[i_User_Gift_Price],[i_User_Gift_ShowType],[i_User_Gift_PlayTime],[i_User_Gift_SwfUrl],[i_User_Gift_MinUserClassSort],[i_User_Gift_MinUserLevelSort],[i_User_Gift_Enable],[i_User_Gift_Sort]) Values('52','̻','gf gf_615',null,'10','3','3','http://www.56.com/flashApp/vshow/gift.13.02.19.a.swf?type=lage&show_time=40000&gift_shape=0&gift_id=615','0','0','1','0')
Insert Into [i_User_Gift] ([i_User_Gift_ID],[i_User_Gift_Name],[i_User_Gift_Class],[i_User_Gift_ImgUrl],[i_User_Gift_Price],[i_User_Gift_ShowType],[i_User_Gift_PlayTime],[i_User_Gift_SwfUrl],[i_User_Gift_MinUserClassSort],[i_User_Gift_MinUserLevelSort],[i_User_Gift_Enable],[i_User_Gift_Sort]) Values('53','','gf gf_613',null,'10','3','3','http://www.56.com/flashApp/vshow/gift.13.02.19.a.swf?type=lage&show_time=40000&gift_shape=0&gift_id=613','0','0','1','0')
Insert Into [i_User_Gift] ([i_User_Gift_ID],[i_User_Gift_Name],[i_User_Gift_Class],[i_User_Gift_ImgUrl],[i_User_Gift_Price],[i_User_Gift_ShowType],[i_User_Gift_PlayTime],[i_User_Gift_SwfUrl],[i_User_Gift_MinUserClassSort],[i_User_Gift_MinUserLevelSort],[i_User_Gift_Enable],[i_User_Gift_Sort]) Values('54','','gf gf_612',null,'10','3','3','http://www.56.com/flashApp/vshow/gift.13.02.19.a.swf?type=lage&show_time=40000&gift_shape=0&gift_id=612','0','0','1','0')
Insert Into [i_User_Gift] ([i_User_Gift_ID],[i_User_Gift_Name],[i_User_Gift_Class],[i_User_Gift_ImgUrl],[i_User_Gift_Price],[i_User_Gift_ShowType],[i_User_Gift_PlayTime],[i_User_Gift_SwfUrl],[i_User_Gift_MinUserClassSort],[i_User_Gift_MinUserLevelSort],[i_User_Gift_Enable],[i_User_Gift_Sort]) Values('55','ʻ','gf gf_602',null,'10','3','3','http://www.56.com/flashApp/vshow/gift.13.02.19.a.swf?type=lage&show_time=40000&gift_shape=0&gift_id=602','0','0','1','0')
Insert Into [i_User_Gift] ([i_User_Gift_ID],[i_User_Gift_Name],[i_User_Gift_Class],[i_User_Gift_ImgUrl],[i_User_Gift_Price],[i_User_Gift_ShowType],[i_User_Gift_PlayTime],[i_User_Gift_SwfUrl],[i_User_Gift_MinUserClassSort],[i_User_Gift_MinUserLevelSort],[i_User_Gift_Enable],[i_User_Gift_Sort]) Values('56','ɳ̲','gf gf_609',null,'10','3','3','http://www.56.com/flashApp/vshow/gift.13.02.19.a.swf?type=lage&show_time=40000&gift_shape=0&gift_id=609','0','0','1','0')
Insert Into [i_User_Gift] ([i_User_Gift_ID],[i_User_Gift_Name],[i_User_Gift_Class],[i_User_Gift_ImgUrl],[i_User_Gift_Price],[i_User_Gift_ShowType],[i_User_Gift_PlayTime],[i_User_Gift_SwfUrl],[i_User_Gift_MinUserClassSort],[i_User_Gift_MinUserLevelSort],[i_User_Gift_Enable],[i_User_Gift_Sort]) Values('57','Ҹ','gf gf_606',null,'10','3','3','http://www.56.com/flashApp/vshow/gift.13.02.19.a.swf?type=lage&show_time=40000&gift_shape=0&gift_id=606','0','0','1','0')
Insert Into [i_User_Gift] ([i_User_Gift_ID],[i_User_Gift_Name],[i_User_Gift_Class],[i_User_Gift_ImgUrl],[i_User_Gift_Price],[i_User_Gift_ShowType],[i_User_Gift_PlayTime],[i_User_Gift_SwfUrl],[i_User_Gift_MinUserClassSort],[i_User_Gift_MinUserLevelSort],[i_User_Gift_Enable],[i_User_Gift_Sort]) Values('58','ѩ','gf gf_600',null,'10','3','3','http://www.56.com/flashApp/vshow/gift.13.02.19.a.swf?type=lage&show_time=40000&gift_shape=0&gift_id=600','0','0','1','0')
Insert Into [i_User_Gift] ([i_User_Gift_ID],[i_User_Gift_Name],[i_User_Gift_Class],[i_User_Gift_ImgUrl],[i_User_Gift_Price],[i_User_Gift_ShowType],[i_User_Gift_PlayTime],[i_User_Gift_SwfUrl],[i_User_Gift_MinUserClassSort],[i_User_Gift_MinUserLevelSort],[i_User_Gift_Enable],[i_User_Gift_Sort]) Values('59','ٲ','gf gf_601',null,'10','3','3','http://www.56.com/flashApp/vshow/gift.13.02.19.a.swf?type=lage&show_time=40000&gift_shape=0&gift_id=601','0','0','1','0')
Insert Into [i_User_Gift] ([i_User_Gift_ID],[i_User_Gift_Name],[i_User_Gift_Class],[i_User_Gift_ImgUrl],[i_User_Gift_Price],[i_User_Gift_ShowType],[i_User_Gift_PlayTime],[i_User_Gift_SwfUrl],[i_User_Gift_MinUserClassSort],[i_User_Gift_MinUserLevelSort],[i_User_Gift_Enable],[i_User_Gift_Sort]) Values('60','׶','gf gf_603',null,'10','3','3','http://www.56.com/flashApp/vshow/gift.13.02.19.a.swf?type=lage&show_time=40000&gift_shape=0&gift_id=603','0','0','1','0')
Insert Into [i_User_Gift] ([i_User_Gift_ID],[i_User_Gift_Name],[i_User_Gift_Class],[i_User_Gift_ImgUrl],[i_User_Gift_Price],[i_User_Gift_ShowType],[i_User_Gift_PlayTime],[i_User_Gift_SwfUrl],[i_User_Gift_MinUserClassSort],[i_User_Gift_MinUserLevelSort],[i_User_Gift_Enable],[i_User_Gift_Sort]) Values('61','','gf gf_608',null,'10','3','3','http://www.56.com/flashApp/vshow/gift.13.02.19.a.swf?type=lage&show_time=40000&gift_shape=0&gift_id=608','0','0','1','0')
Insert Into [i_User_Gift] ([i_User_Gift_ID],[i_User_Gift_Name],[i_User_Gift_Class],[i_User_Gift_ImgUrl],[i_User_Gift_Price],[i_User_Gift_ShowType],[i_User_Gift_PlayTime],[i_User_Gift_SwfUrl],[i_User_Gift_MinUserClassSort],[i_User_Gift_MinUserLevelSort],[i_User_Gift_Enable],[i_User_Gift_Sort]) Values('62','','gf gf_428',null,'10','0','3','http://www.56.com/flashApp/vshow/gift.13.02.19.a.swf?type=lage&show_time=30000&gift_shape=0&gift_id=428','0','0','1','0')
Insert Into [i_User_Gift] ([i_User_Gift_ID],[i_User_Gift_Name],[i_User_Gift_Class],[i_User_Gift_ImgUrl],[i_User_Gift_Price],[i_User_Gift_ShowType],[i_User_Gift_PlayTime],[i_User_Gift_SwfUrl],[i_User_Gift_MinUserClassSort],[i_User_Gift_MinUserLevelSort],[i_User_Gift_Enable],[i_User_Gift_Sort]) Values('63','ͧ','gf gf_400',null,'10','0','3','http://www.56.com/flashApp/vshow/gift.13.02.19.a.swf?type=lage&show_time=30000&gift_shape=0&gift_id=400','0','0','1','0')
Insert Into [i_User_Gift] ([i_User_Gift_ID],[i_User_Gift_Name],[i_User_Gift_Class],[i_User_Gift_ImgUrl],[i_User_Gift_Price],[i_User_Gift_ShowType],[i_User_Gift_PlayTime],[i_User_Gift_SwfUrl],[i_User_Gift_MinUserClassSort],[i_User_Gift_MinUserLevelSort],[i_User_Gift_Enable],[i_User_Gift_Sort]) Values('64','̹','gf gf_403',null,'10','0','3','http://www.56.com/flashApp/vshow/gift.13.02.19.a.swf?type=lage&show_time=30000&gift_shape=0&gift_id=403','0','0','1','0')
Insert Into [i_User_Gift] ([i_User_Gift_ID],[i_User_Gift_Name],[i_User_Gift_Class],[i_User_Gift_ImgUrl],[i_User_Gift_Price],[i_User_Gift_ShowType],[i_User_Gift_PlayTime],[i_User_Gift_SwfUrl],[i_User_Gift_MinUserClassSort],[i_User_Gift_MinUserLevelSort],[i_User_Gift_Enable],[i_User_Gift_Sort]) Values('65','յ','gf gf_410',null,'10','0','3','http://www.56.com/flashApp/vshow/gift.13.02.19.a.swf?type=lage&show_time=30000&gift_shape=0&gift_id=410','0','0','1','0')
Insert Into [i_User_Gift] ([i_User_Gift_ID],[i_User_Gift_Name],[i_User_Gift_Class],[i_User_Gift_ImgUrl],[i_User_Gift_Price],[i_User_Gift_ShowType],[i_User_Gift_PlayTime],[i_User_Gift_SwfUrl],[i_User_Gift_MinUserClassSort],[i_User_Gift_MinUserLevelSort],[i_User_Gift_Enable],[i_User_Gift_Sort]) Values('66','֮','gf gf_414',null,'10','3','3','http://www.56.com/flashApp/vshow/gift.13.02.19.a.swf?type=lage&show_time=30000&gift_shape=0&gift_id=414','0','0','1','0')
Insert Into [i_User_Gift] ([i_User_Gift_ID],[i_User_Gift_Name],[i_User_Gift_Class],[i_User_Gift_ImgUrl],[i_User_Gift_Price],[i_User_Gift_ShowType],[i_User_Gift_PlayTime],[i_User_Gift_SwfUrl],[i_User_Gift_MinUserClassSort],[i_User_Gift_MinUserLevelSort],[i_User_Gift_Enable],[i_User_Gift_Sort]) Values('68','','gf gf_20',null,'10','3','3','http://www.56.com/flashApp/vshow/gift.13.02.19.a.swf?type=lage&show_time=12000&gift_shape=0&gift_id=20','0','0','1','0')
Insert Into [i_User_Gift] ([i_User_Gift_ID],[i_User_Gift_Name],[i_User_Gift_Class],[i_User_Gift_ImgUrl],[i_User_Gift_Price],[i_User_Gift_ShowType],[i_User_Gift_PlayTime],[i_User_Gift_SwfUrl],[i_User_Gift_MinUserClassSort],[i_User_Gift_MinUserLevelSort],[i_User_Gift_Enable],[i_User_Gift_Sort]) Values('69','','gf gf_10',null,'10','3','3','http://www.56.com/flashApp/vshow/gift.13.02.19.a.swf?type=large&show_time=12000&gift_shape=0&gift_id=10','0','0','1','0')
Insert Into [i_User_Gift] ([i_User_Gift_ID],[i_User_Gift_Name],[i_User_Gift_Class],[i_User_Gift_ImgUrl],[i_User_Gift_Price],[i_User_Gift_ShowType],[i_User_Gift_PlayTime],[i_User_Gift_SwfUrl],[i_User_Gift_MinUserClassSort],[i_User_Gift_MinUserLevelSort],[i_User_Gift_Enable],[i_User_Gift_Sort]) Values('70','è','gf gf_12',null,'10','3','3','http://www.56.com/flashApp/vshow/gift.13.02.19.a.swf?type=large&show_time=12000&gift_shape=0&gift_id=12','0','0','1','0')
Insert Into [i_User_Gift] ([i_User_Gift_ID],[i_User_Gift_Name],[i_User_Gift_Class],[i_User_Gift_ImgUrl],[i_User_Gift_Price],[i_User_Gift_ShowType],[i_User_Gift_PlayTime],[i_User_Gift_SwfUrl],[i_User_Gift_MinUserClassSort],[i_User_Gift_MinUserLevelSort],[i_User_Gift_Enable],[i_User_Gift_Sort]) Values('71','è','gf gf_11',null,'10','3','3','http://www.56.com/flashApp/vshow/gift.13.02.19.a.swf?type=large&show_time=12000&gift_shape=0&gift_id=11','0','0','1','0')
Insert Into [i_User_Gift] ([i_User_Gift_ID],[i_User_Gift_Name],[i_User_Gift_Class],[i_User_Gift_ImgUrl],[i_User_Gift_Price],[i_User_Gift_ShowType],[i_User_Gift_PlayTime],[i_User_Gift_SwfUrl],[i_User_Gift_MinUserClassSort],[i_User_Gift_MinUserLevelSort],[i_User_Gift_Enable],[i_User_Gift_Sort]) Values('72','','gf gf_13',null,'10','3','3','http://www.56.com/flashApp/vshow/gift.13.02.19.a.swf?type=large&show_time=12000&gift_shape=0&gift_id=13','0','0','1','0')
Insert Into [i_User_Gift] ([i_User_Gift_ID],[i_User_Gift_Name],[i_User_Gift_Class],[i_User_Gift_ImgUrl],[i_User_Gift_Price],[i_User_Gift_ShowType],[i_User_Gift_PlayTime],[i_User_Gift_SwfUrl],[i_User_Gift_MinUserClassSort],[i_User_Gift_MinUserLevelSort],[i_User_Gift_Enable],[i_User_Gift_Sort]) Values('73','è','gf gf_14',null,'10','3','3','http://www.56.com/flashApp/vshow/gift.13.02.19.a.swf?type=large&show_time=12000&gift_shape=0&gift_id=14','0','0','1','0')
Insert Into [i_User_Gift] ([i_User_Gift_ID],[i_User_Gift_Name],[i_User_Gift_Class],[i_User_Gift_ImgUrl],[i_User_Gift_Price],[i_User_Gift_ShowType],[i_User_Gift_PlayTime],[i_User_Gift_SwfUrl],[i_User_Gift_MinUserClassSort],[i_User_Gift_MinUserLevelSort],[i_User_Gift_Enable],[i_User_Gift_Sort]) Values('74','','gf gf_800',null,'10','3','3','http://www.56.com/flashApp/vshow/gift.13.02.19.a.swf?type=large&show_time=20000&gift_shape=0&gift_id=800','0','0','1','0')
Insert Into [i_User_Gift] ([i_User_Gift_ID],[i_User_Gift_Name],[i_User_Gift_Class],[i_User_Gift_ImgUrl],[i_User_Gift_Price],[i_User_Gift_ShowType],[i_User_Gift_PlayTime],[i_User_Gift_SwfUrl],[i_User_Gift_MinUserClassSort],[i_User_Gift_MinUserLevelSort],[i_User_Gift_Enable],[i_User_Gift_Sort]) Values('75','','gf gf_801',null,'10','3','3','http://www.56.com/flashApp/vshow/gift.13.02.19.a.swf?type=large&show_time=20000&gift_shape=0&gift_id=801','0','0','1','0')
Insert Into [i_User_Gift] ([i_User_Gift_ID],[i_User_Gift_Name],[i_User_Gift_Class],[i_User_Gift_ImgUrl],[i_User_Gift_Price],[i_User_Gift_ShowType],[i_User_Gift_PlayTime],[i_User_Gift_SwfUrl],[i_User_Gift_MinUserClassSort],[i_User_Gift_MinUserLevelSort],[i_User_Gift_Enable],[i_User_Gift_Sort]) Values('76','Լ','gf gf_802',null,'10','3','3','http://www.56.com/flashApp/vshow/gift.13.02.19.a.swf?type=large&show_time=40000&gift_shape=0&gift_id=802','0','0','1','0')
Insert Into [i_User_Gift] ([i_User_Gift_ID],[i_User_Gift_Name],[i_User_Gift_Class],[i_User_Gift_ImgUrl],[i_User_Gift_Price],[i_User_Gift_ShowType],[i_User_Gift_PlayTime],[i_User_Gift_SwfUrl],[i_User_Gift_MinUserClassSort],[i_User_Gift_MinUserLevelSort],[i_User_Gift_Enable],[i_User_Gift_Sort]) Values('77','Ҹ԰','gf gf_803',null,'10','3','3','http://www.56.com/flashApp/vshow/gift.13.02.19.a.swf?type=large&show_time=20000&gift_shape=0&gift_id=803','0','0','1','0')
Insert Into [i_User_Gift] ([i_User_Gift_ID],[i_User_Gift_Name],[i_User_Gift_Class],[i_User_Gift_ImgUrl],[i_User_Gift_Price],[i_User_Gift_ShowType],[i_User_Gift_PlayTime],[i_User_Gift_SwfUrl],[i_User_Gift_MinUserClassSort],[i_User_Gift_MinUserLevelSort],[i_User_Gift_Enable],[i_User_Gift_Sort]) Values('78','С','gf gf_456',null,'10','0','3','www.56.com/flashApp/vshow/gift.13.02.19.a.swf?type=small&show_time=30000&gift_shape=0&gift_id=456','0','0','1','0')
Insert Into [i_User_Gift] ([i_User_Gift_ID],[i_User_Gift_Name],[i_User_Gift_Class],[i_User_Gift_ImgUrl],[i_User_Gift_Price],[i_User_Gift_ShowType],[i_User_Gift_PlayTime],[i_User_Gift_SwfUrl],[i_User_Gift_MinUserClassSort],[i_User_Gift_MinUserLevelSort],[i_User_Gift_Enable],[i_User_Gift_Sort]) Values('79','שͷ','gf gf_104',null,'10','0','3','http://www.56.com/flashApp/vshow/gift.13.02.19.a.swf?type=small&show_time=10000&gift_shape=0&gift_id=104','0','0','1','0')
SET IDENTITY_INSERT [i_User_Gift] OFF


SET IDENTITY_INSERT [i_User_InComeLevel] ON
Insert Into [i_User_InComeLevel] ([i_User_InComeLevel_ID],[i_User_InComeLevel_Name],[i_User_InComeLevel_Style],[i_User_InComeLevel_MinNum],[i_User_InComeLevel_MaxNum],[i_User_InComeLevel_Sort]) Values('1','һ','star1','1000','3000','1')
Insert Into [i_User_InComeLevel] ([i_User_InComeLevel_ID],[i_User_InComeLevel_Name],[i_User_InComeLevel_Style],[i_User_InComeLevel_MinNum],[i_User_InComeLevel_MaxNum],[i_User_InComeLevel_Sort]) Values('2','','star2','3000','6000','2')
Insert Into [i_User_InComeLevel] ([i_User_InComeLevel_ID],[i_User_InComeLevel_Name],[i_User_InComeLevel_Style],[i_User_InComeLevel_MinNum],[i_User_InComeLevel_MaxNum],[i_User_InComeLevel_Sort]) Values('3','','star3','6000','9000','3')
Insert Into [i_User_InComeLevel] ([i_User_InComeLevel_ID],[i_User_InComeLevel_Name],[i_User_InComeLevel_Style],[i_User_InComeLevel_MinNum],[i_User_InComeLevel_MaxNum],[i_User_InComeLevel_Sort]) Values('4','','star4','9000','15000','4')
Insert Into [i_User_InComeLevel] ([i_User_InComeLevel_ID],[i_User_InComeLevel_Name],[i_User_InComeLevel_Style],[i_User_InComeLevel_MinNum],[i_User_InComeLevel_MaxNum],[i_User_InComeLevel_Sort]) Values('5','','star5','15000','21000','5')
Insert Into [i_User_InComeLevel] ([i_User_InComeLevel_ID],[i_User_InComeLevel_Name],[i_User_InComeLevel_Style],[i_User_InComeLevel_MinNum],[i_User_InComeLevel_MaxNum],[i_User_InComeLevel_Sort]) Values('6','һ','star6','21000','31000','6')
Insert Into [i_User_InComeLevel] ([i_User_InComeLevel_ID],[i_User_InComeLevel_Name],[i_User_InComeLevel_Style],[i_User_InComeLevel_MinNum],[i_User_InComeLevel_MaxNum],[i_User_InComeLevel_Sort]) Values('7','','star7','31000','45000','7')
Insert Into [i_User_InComeLevel] ([i_User_InComeLevel_ID],[i_User_InComeLevel_Name],[i_User_InComeLevel_Style],[i_User_InComeLevel_MinNum],[i_User_InComeLevel_MaxNum],[i_User_InComeLevel_Sort]) Values('8','','star8','45000','65000','8')
Insert Into [i_User_InComeLevel] ([i_User_InComeLevel_ID],[i_User_InComeLevel_Name],[i_User_InComeLevel_Style],[i_User_InComeLevel_MinNum],[i_User_InComeLevel_MaxNum],[i_User_InComeLevel_Sort]) Values('9','','star9','65000','85000','9')
Insert Into [i_User_InComeLevel] ([i_User_InComeLevel_ID],[i_User_InComeLevel_Name],[i_User_InComeLevel_Style],[i_User_InComeLevel_MinNum],[i_User_InComeLevel_MaxNum],[i_User_InComeLevel_Sort]) Values('10','','star10','85000','120000','10')
Insert Into [i_User_InComeLevel] ([i_User_InComeLevel_ID],[i_User_InComeLevel_Name],[i_User_InComeLevel_Style],[i_User_InComeLevel_MinNum],[i_User_InComeLevel_MaxNum],[i_User_InComeLevel_Sort]) Values('11','һʹ','star11','120000','200000','11')
Insert Into [i_User_InComeLevel] ([i_User_InComeLevel_ID],[i_User_InComeLevel_Name],[i_User_InComeLevel_Style],[i_User_InComeLevel_MinNum],[i_User_InComeLevel_MaxNum],[i_User_InComeLevel_Sort]) Values('12','ʹ','star12','200000','300000','12')
Insert Into [i_User_InComeLevel] ([i_User_InComeLevel_ID],[i_User_InComeLevel_Name],[i_User_InComeLevel_Style],[i_User_InComeLevel_MinNum],[i_User_InComeLevel_MaxNum],[i_User_InComeLevel_Sort]) Values('13','ʹ','star13','300000','400000','13')
Insert Into [i_User_InComeLevel] ([i_User_InComeLevel_ID],[i_User_InComeLevel_Name],[i_User_InComeLevel_Style],[i_User_InComeLevel_MinNum],[i_User_InComeLevel_MaxNum],[i_User_InComeLevel_Sort]) Values('14','Ļʹ','star14','500000','600000','14')
Insert Into [i_User_InComeLevel] ([i_User_InComeLevel_ID],[i_User_InComeLevel_Name],[i_User_InComeLevel_Style],[i_User_InComeLevel_MinNum],[i_User_InComeLevel_MaxNum],[i_User_InComeLevel_Sort]) Values('15','ʹ','star15','600000','700000','15')
Insert Into [i_User_InComeLevel] ([i_User_InComeLevel_ID],[i_User_InComeLevel_Name],[i_User_InComeLevel_Style],[i_User_InComeLevel_MinNum],[i_User_InComeLevel_MaxNum],[i_User_InComeLevel_Sort]) Values('16','ʹ','star16','700000','800000','16')
Insert Into [i_User_InComeLevel] ([i_User_InComeLevel_ID],[i_User_InComeLevel_Name],[i_User_InComeLevel_Style],[i_User_InComeLevel_MinNum],[i_User_InComeLevel_MaxNum],[i_User_InComeLevel_Sort]) Values('17','߻ʹ','star17','800000','900000','17')
Insert Into [i_User_InComeLevel] ([i_User_InComeLevel_ID],[i_User_InComeLevel_Name],[i_User_InComeLevel_Style],[i_User_InComeLevel_MinNum],[i_User_InComeLevel_MaxNum],[i_User_InComeLevel_Sort]) Values('18','˻ʹ','star18','900000','1000000','18')
Insert Into [i_User_InComeLevel] ([i_User_InComeLevel_ID],[i_User_InComeLevel_Name],[i_User_InComeLevel_Style],[i_User_InComeLevel_MinNum],[i_User_InComeLevel_MaxNum],[i_User_InComeLevel_Sort]) Values('19','Żʹ','star19','1000000','1100000','19')
Insert Into [i_User_InComeLevel] ([i_User_InComeLevel_ID],[i_User_InComeLevel_Name],[i_User_InComeLevel_Style],[i_User_InComeLevel_MinNum],[i_User_InComeLevel_MaxNum],[i_User_InComeLevel_Sort]) Values('20','ʮʹ','star20','1100000','1200000','21')
Insert Into [i_User_InComeLevel] ([i_User_InComeLevel_ID],[i_User_InComeLevel_Name],[i_User_InComeLevel_Style],[i_User_InComeLevel_MinNum],[i_User_InComeLevel_MaxNum],[i_User_InComeLevel_Sort]) Values('21','ʮһʹ','star21','1200000','1300000','22')
Insert Into [i_User_InComeLevel] ([i_User_InComeLevel_ID],[i_User_InComeLevel_Name],[i_User_InComeLevel_Style],[i_User_InComeLevel_MinNum],[i_User_InComeLevel_MaxNum],[i_User_InComeLevel_Sort]) Values('22','ʮʹ','star22','1300000','1400000','23')
Insert Into [i_User_InComeLevel] ([i_User_InComeLevel_ID],[i_User_InComeLevel_Name],[i_User_InComeLevel_Style],[i_User_InComeLevel_MinNum],[i_User_InComeLevel_MaxNum],[i_User_InComeLevel_Sort]) Values('23','ʮʹ','star23','1400000','1600000','24')
Insert Into [i_User_InComeLevel] ([i_User_InComeLevel_ID],[i_User_InComeLevel_Name],[i_User_InComeLevel_Style],[i_User_InComeLevel_MinNum],[i_User_InComeLevel_MaxNum],[i_User_InComeLevel_Sort]) Values('24','ʮĻʹ','star24','1600000','1800000','25')
Insert Into [i_User_InComeLevel] ([i_User_InComeLevel_ID],[i_User_InComeLevel_Name],[i_User_InComeLevel_Style],[i_User_InComeLevel_MinNum],[i_User_InComeLevel_MaxNum],[i_User_InComeLevel_Sort]) Values('25','ʮʹ','star25','1800000','2000000','26')
Insert Into [i_User_InComeLevel] ([i_User_InComeLevel_ID],[i_User_InComeLevel_Name],[i_User_InComeLevel_Style],[i_User_InComeLevel_MinNum],[i_User_InComeLevel_MaxNum],[i_User_InComeLevel_Sort]) Values('26','ʮʹ','star26','2000000','3000000','27')
Insert Into [i_User_InComeLevel] ([i_User_InComeLevel_ID],[i_User_InComeLevel_Name],[i_User_InComeLevel_Style],[i_User_InComeLevel_MinNum],[i_User_InComeLevel_MaxNum],[i_User_InComeLevel_Sort]) Values('27','ʮ߻ʹ','star27','3000000','4000000','28')
Insert Into [i_User_InComeLevel] ([i_User_InComeLevel_ID],[i_User_InComeLevel_Name],[i_User_InComeLevel_Style],[i_User_InComeLevel_MinNum],[i_User_InComeLevel_MaxNum],[i_User_InComeLevel_Sort]) Values('28','ʮ˻ʹ','star28','4000000','6000000','29')
Insert Into [i_User_InComeLevel] ([i_User_InComeLevel_ID],[i_User_InComeLevel_Name],[i_User_InComeLevel_Style],[i_User_InComeLevel_MinNum],[i_User_InComeLevel_MaxNum],[i_User_InComeLevel_Sort]) Values('29','ʮŻʹ','star29','6000000','10000000','30')
Insert Into [i_User_InComeLevel] ([i_User_InComeLevel_ID],[i_User_InComeLevel_Name],[i_User_InComeLevel_Style],[i_User_InComeLevel_MinNum],[i_User_InComeLevel_MaxNum],[i_User_InComeLevel_Sort]) Values('30','ʮʹ','star30','10000000','9999999999999','31')
Insert Into [i_User_InComeLevel] ([i_User_InComeLevel_ID],[i_User_InComeLevel_Name],[i_User_InComeLevel_Style],[i_User_InComeLevel_MinNum],[i_User_InComeLevel_MaxNum],[i_User_InComeLevel_Sort]) Values('32','','start0','0','1000','0')
SET IDENTITY_INSERT [i_User_InComeLevel] OFF





SET IDENTITY_INSERT [i_User_PaymentLevel] ON
Insert Into [i_User_PaymentLevel] ([i_User_PaymentLevel_ID],[i_User_PaymentLevel_Name],[i_User_PaymentLevel_Style],[i_User_PaymentLevel_MinNum],[i_User_PaymentLevel_MaxNum],[i_User_PaymentLevel_Sort]) Values('1','ƶũ','rich0','0','1000','1')
Insert Into [i_User_PaymentLevel] ([i_User_PaymentLevel_ID],[i_User_PaymentLevel_Name],[i_User_PaymentLevel_Style],[i_User_PaymentLevel_MinNum],[i_User_PaymentLevel_MaxNum],[i_User_PaymentLevel_Sort]) Values('2','һ','rich1','1000','2000','2')
Insert Into [i_User_PaymentLevel] ([i_User_PaymentLevel_ID],[i_User_PaymentLevel_Name],[i_User_PaymentLevel_Style],[i_User_PaymentLevel_MinNum],[i_User_PaymentLevel_MaxNum],[i_User_PaymentLevel_Sort]) Values('3','','rich2','2000','4000','3')
Insert Into [i_User_PaymentLevel] ([i_User_PaymentLevel_ID],[i_User_PaymentLevel_Name],[i_User_PaymentLevel_Style],[i_User_PaymentLevel_MinNum],[i_User_PaymentLevel_MaxNum],[i_User_PaymentLevel_Sort]) Values('4','','rich3','4000','8000','4')
Insert Into [i_User_PaymentLevel] ([i_User_PaymentLevel_ID],[i_User_PaymentLevel_Name],[i_User_PaymentLevel_Style],[i_User_PaymentLevel_MinNum],[i_User_PaymentLevel_MaxNum],[i_User_PaymentLevel_Sort]) Values('5','ĸ','rich4','8000','12000','5')
Insert Into [i_User_PaymentLevel] ([i_User_PaymentLevel_ID],[i_User_PaymentLevel_Name],[i_User_PaymentLevel_Style],[i_User_PaymentLevel_MinNum],[i_User_PaymentLevel_MaxNum],[i_User_PaymentLevel_Sort]) Values('6','帻1','rich5','12000','16000','6')
Insert Into [i_User_PaymentLevel] ([i_User_PaymentLevel_ID],[i_User_PaymentLevel_Name],[i_User_PaymentLevel_Style],[i_User_PaymentLevel_MinNum],[i_User_PaymentLevel_MaxNum],[i_User_PaymentLevel_Sort]) Values('7','','rich6','16000','22000','7')
Insert Into [i_User_PaymentLevel] ([i_User_PaymentLevel_ID],[i_User_PaymentLevel_Name],[i_User_PaymentLevel_Style],[i_User_PaymentLevel_MinNum],[i_User_PaymentLevel_MaxNum],[i_User_PaymentLevel_Sort]) Values('8','߸','rich7','22000','28000','8')
Insert Into [i_User_PaymentLevel] ([i_User_PaymentLevel_ID],[i_User_PaymentLevel_Name],[i_User_PaymentLevel_Style],[i_User_PaymentLevel_MinNum],[i_User_PaymentLevel_MaxNum],[i_User_PaymentLevel_Sort]) Values('9','˸','rich8','28000','36000','9')
Insert Into [i_User_PaymentLevel] ([i_User_PaymentLevel_ID],[i_User_PaymentLevel_Name],[i_User_PaymentLevel_Style],[i_User_PaymentLevel_MinNum],[i_User_PaymentLevel_MaxNum],[i_User_PaymentLevel_Sort]) Values('10','Ÿ','rich9','36000','44000','10')
Insert Into [i_User_PaymentLevel] ([i_User_PaymentLevel_ID],[i_User_PaymentLevel_Name],[i_User_PaymentLevel_Style],[i_User_PaymentLevel_MinNum],[i_User_PaymentLevel_MaxNum],[i_User_PaymentLevel_Sort]) Values('11','ʮ','rich10','44000','52000','11')
Insert Into [i_User_PaymentLevel] ([i_User_PaymentLevel_ID],[i_User_PaymentLevel_Name],[i_User_PaymentLevel_Style],[i_User_PaymentLevel_MinNum],[i_User_PaymentLevel_MaxNum],[i_User_PaymentLevel_Sort]) Values('12','о','rich11','52000','60000','12')
Insert Into [i_User_PaymentLevel] ([i_User_PaymentLevel_ID],[i_User_PaymentLevel_Name],[i_User_PaymentLevel_Style],[i_User_PaymentLevel_MinNum],[i_User_PaymentLevel_MaxNum],[i_User_PaymentLevel_Sort]) Values('13','Ӿ','rich12','60000','70000','13')
Insert Into [i_User_PaymentLevel] ([i_User_PaymentLevel_ID],[i_User_PaymentLevel_Name],[i_User_PaymentLevel_Style],[i_User_PaymentLevel_MinNum],[i_User_PaymentLevel_MaxNum],[i_User_PaymentLevel_Sort]) Values('14','','rich13','70000','80000','14')
Insert Into [i_User_PaymentLevel] ([i_User_PaymentLevel_ID],[i_User_PaymentLevel_Name],[i_User_PaymentLevel_Style],[i_User_PaymentLevel_MinNum],[i_User_PaymentLevel_MaxNum],[i_User_PaymentLevel_Sort]) Values('15','','rich14','80000','90000','15')
Insert Into [i_User_PaymentLevel] ([i_User_PaymentLevel_ID],[i_User_PaymentLevel_Name],[i_User_PaymentLevel_Style],[i_User_PaymentLevel_MinNum],[i_User_PaymentLevel_MaxNum],[i_User_PaymentLevel_Sort]) Values('16','','rich15','90000','100000','16')
Insert Into [i_User_PaymentLevel] ([i_User_PaymentLevel_ID],[i_User_PaymentLevel_Name],[i_User_PaymentLevel_Style],[i_User_PaymentLevel_MinNum],[i_User_PaymentLevel_MaxNum],[i_User_PaymentLevel_Sort]) Values('17','','rich16','100000','150000','17')
Insert Into [i_User_PaymentLevel] ([i_User_PaymentLevel_ID],[i_User_PaymentLevel_Name],[i_User_PaymentLevel_Style],[i_User_PaymentLevel_MinNum],[i_User_PaymentLevel_MaxNum],[i_User_PaymentLevel_Sort]) Values('18','','rich17','150000','200000','18')
Insert Into [i_User_PaymentLevel] ([i_User_PaymentLevel_ID],[i_User_PaymentLevel_Name],[i_User_PaymentLevel_Style],[i_User_PaymentLevel_MinNum],[i_User_PaymentLevel_MaxNum],[i_User_PaymentLevel_Sort]) Values('19','','rich18','200000','300000','19')
Insert Into [i_User_PaymentLevel] ([i_User_PaymentLevel_ID],[i_User_PaymentLevel_Name],[i_User_PaymentLevel_Style],[i_User_PaymentLevel_MinNum],[i_User_PaymentLevel_MaxNum],[i_User_PaymentLevel_Sort]) Values('20','','rich19','300000','500000','20')
Insert Into [i_User_PaymentLevel] ([i_User_PaymentLevel_ID],[i_User_PaymentLevel_Name],[i_User_PaymentLevel_Style],[i_User_PaymentLevel_MinNum],[i_User_PaymentLevel_MaxNum],[i_User_PaymentLevel_Sort]) Values('21','','rich20','500000','1000000','21')
Insert Into [i_User_PaymentLevel] ([i_User_PaymentLevel_ID],[i_User_PaymentLevel_Name],[i_User_PaymentLevel_Style],[i_User_PaymentLevel_MinNum],[i_User_PaymentLevel_MaxNum],[i_User_PaymentLevel_Sort]) Values('22','','rich21','1000000','2000000','22')
Insert Into [i_User_PaymentLevel] ([i_User_PaymentLevel_ID],[i_User_PaymentLevel_Name],[i_User_PaymentLevel_Style],[i_User_PaymentLevel_MinNum],[i_User_PaymentLevel_MaxNum],[i_User_PaymentLevel_Sort]) Values('23','','rich22','2000000','3000000','23')
Insert Into [i_User_PaymentLevel] ([i_User_PaymentLevel_ID],[i_User_PaymentLevel_Name],[i_User_PaymentLevel_Style],[i_User_PaymentLevel_MinNum],[i_User_PaymentLevel_MaxNum],[i_User_PaymentLevel_Sort]) Values('24','ʵ','rich23','3000000','5000000','24')
Insert Into [i_User_PaymentLevel] ([i_User_PaymentLevel_ID],[i_User_PaymentLevel_Name],[i_User_PaymentLevel_Style],[i_User_PaymentLevel_MinNum],[i_User_PaymentLevel_MaxNum],[i_User_PaymentLevel_Sort]) Values('25','','rich24','5000000','9999999999999','25')
SET IDENTITY_INSERT [i_User_PaymentLevel] OFF

