-- ----------------------------------------
-- EyouCms MySQL Data Transfer 
-- 
-- Server         : 127.0.0.1_3306
-- Server Version : 5.5.47
-- Host           : 127.0.0.1:3306
-- Database       : eyoucms
-- 
-- Part : #1
-- Version : #v1.2.6
-- Date : 2019-01-18 11:30:49
-- -----------------------------------------

SET FOREIGN_KEY_CHECKS = 0;


-- -----------------------------
-- Table structure for `ey_ad`
-- -----------------------------
DROP TABLE IF EXISTS `ey_ad`;
CREATE TABLE `ey_ad` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '广告id',
  `pid` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '广告位置ID',
  `media_type` tinyint(1) DEFAULT '0' COMMENT '广告类型',
  `title` varchar(60) DEFAULT '' COMMENT '广告名称',
  `links` varchar(255) DEFAULT '' COMMENT '广告链接',
  `litpic` varchar(255) DEFAULT '' COMMENT '图片地址',
  `start_time` int(11) DEFAULT '0' COMMENT '投放时间',
  `end_time` int(11) DEFAULT '0' COMMENT '结束时间',
  `intro` text COMMENT '描述',
  `link_man` varchar(60) DEFAULT '' COMMENT '添加人',
  `link_email` varchar(60) DEFAULT '' COMMENT '添加人邮箱',
  `link_phone` varchar(60) DEFAULT '' COMMENT '添加人联系电话',
  `click` int(11) DEFAULT '0' COMMENT '点击量',
  `bgcolor` varchar(30) DEFAULT '' COMMENT '背景颜色',
  `status` tinyint(1) unsigned DEFAULT '1' COMMENT '1=显示，0=屏蔽',
  `sort_order` int(11) DEFAULT '0' COMMENT '排序',
  `target` varchar(50) DEFAULT '' COMMENT '是否开启浏览器新窗口',
  `admin_id` int(10) DEFAULT '0' COMMENT '管理员ID',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '多语言',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `position_id` (`pid`) USING BTREE,
  KEY `status` (`status`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

-- -----------------------------
-- Records of `ey_ad`
-- -----------------------------
INSERT INTO `ey_ad` VALUES ('1', '1', '1', '幻灯一', '', '/public/upload/other/2018/08/29/4fcc3dc76d19f6743aa57c49ae0c757f.jpg', '0', '0', '', '', '', '', '0', '', '1', '100', '1', '0', 'cn', '1533543051', '1535503396');
INSERT INTO `ey_ad` VALUES ('2', '1', '1', '幻灯二', '', '/public/upload/other/2018/08/29/4c37b5b6c6f77bca41688c5290ca9b49.jpg', '0', '0', '', '', '', '', '0', '', '1', '100', '1', '0', 'cn', '1533543086', '1535503380');

-- -----------------------------
-- Table structure for `ey_ad_position`
-- -----------------------------
DROP TABLE IF EXISTS `ey_ad_position`;
CREATE TABLE `ey_ad_position` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(60) DEFAULT '' COMMENT '广告位置名称',
  `width` smallint(5) unsigned DEFAULT '0' COMMENT '广告位宽度',
  `height` smallint(5) unsigned DEFAULT '0' COMMENT '广告位高度',
  `intro` text COMMENT '广告描述',
  `status` tinyint(1) DEFAULT '1' COMMENT '0关闭1开启',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '多语言',
  `admin_id` int(10) DEFAULT '0' COMMENT '管理员ID',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COMMENT='广告位置表';

-- -----------------------------
-- Records of `ey_ad_position`
-- -----------------------------
INSERT INTO `ey_ad_position` VALUES ('1', '首页幻灯', '1600', '550', '', '1', 'cn', '0', '1533542954', '1535529096');

-- -----------------------------
-- Table structure for `ey_admin`
-- -----------------------------
DROP TABLE IF EXISTS `ey_admin`;
CREATE TABLE `ey_admin` (
  `admin_id` smallint(5) unsigned NOT NULL AUTO_INCREMENT COMMENT '用户id',
  `user_name` varchar(20) NOT NULL DEFAULT '' COMMENT '用户名',
  `pen_name` varchar(50) DEFAULT '' COMMENT '笔名（发布文章后显示责任编辑的名字）',
  `true_name` varchar(20) DEFAULT '' COMMENT '真实姓名',
  `mobile` varchar(11) DEFAULT '' COMMENT '手机号码',
  `email` varchar(60) DEFAULT '' COMMENT 'email',
  `password` varchar(32) NOT NULL DEFAULT '' COMMENT '密码',
  `last_login` int(11) DEFAULT '0' COMMENT '最后登录时间',
  `last_ip` varchar(15) DEFAULT '' COMMENT '最后登录ip',
  `login_cnt` int(11) DEFAULT '0' COMMENT '登录次数',
  `session_id` varchar(50) DEFAULT '' COMMENT 'session_id',
  `parent_id` int(10) DEFAULT '0' COMMENT '父管理员ID',
  `role_id` int(10) NOT NULL DEFAULT '-1' COMMENT '角色组ID（-1表示超级管理员）',
  `mark_lang` varchar(50) DEFAULT 'cn' COMMENT '当前语言标识',
  `status` tinyint(1) DEFAULT '1' COMMENT '状态(0=屏蔽，1=正常)',
  `add_time` int(11) DEFAULT '0' COMMENT '添加时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`admin_id`),
  KEY `user_name` (`user_name`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

-- -----------------------------
-- Records of `ey_admin`
-- -----------------------------
INSERT INTO `ey_admin` VALUES ('1', 'admin', '', 'admin', '', '', '7959ec68e999edd0380ff0809f76fa42', '1547781865', '127.0.0.1', '2', 'mae9cqqac8cueuujook6q3npj7', '0', '-1', 'cn', '1', '1547781843', '0');

-- -----------------------------
-- Table structure for `ey_admin_log`
-- -----------------------------
DROP TABLE IF EXISTS `ey_admin_log`;
CREATE TABLE `ey_admin_log` (
  `log_id` bigint(16) unsigned NOT NULL AUTO_INCREMENT COMMENT '表id',
  `admin_id` int(10) DEFAULT NULL COMMENT '管理员id',
  `log_info` varchar(255) DEFAULT NULL COMMENT '日志描述',
  `log_ip` varchar(30) DEFAULT NULL COMMENT 'ip地址',
  `log_url` varchar(255) DEFAULT NULL COMMENT 'url',
  `log_time` int(10) DEFAULT NULL COMMENT '日志时间',
  PRIMARY KEY (`log_id`),
  KEY `admin_id` (`admin_id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=301 DEFAULT CHARSET=utf8;

-- -----------------------------
-- Records of `ey_admin_log`
-- -----------------------------
INSERT INTO `ey_admin_log` VALUES ('1', '1', '后台登录', '127.0.0.1', '/index.php/admin/Admin/login.html', '1531800409');
INSERT INTO `ey_admin_log` VALUES ('2', '1', '后台登录', '127.0.0.1', '/index.php/admin/Admin/login.html', '1533540221');
INSERT INTO `ey_admin_log` VALUES ('3', '1', '新增栏目：关于我们', '127.0.0.1', '/index.php/admin/Arctype/add.html', '1533541630');
INSERT INTO `ey_admin_log` VALUES ('4', '1', '新增栏目：产品展示', '127.0.0.1', '/index.php/admin/Arctype/add.html', '1533541671');
INSERT INTO `ey_admin_log` VALUES ('5', '1', '新增栏目：新闻资讯', '127.0.0.1', '/index.php/admin/Arctype/add.html', '1533541713');
INSERT INTO `ey_admin_log` VALUES ('6', '1', '编辑栏目：新闻资讯', '127.0.0.1', '/index.php/admin/Arctype/edit.html', '1533541726');
INSERT INTO `ey_admin_log` VALUES ('7', '1', '新增栏目：养生功效', '127.0.0.1', '/index.php/admin/Arctype/add.html', '1533541787');
INSERT INTO `ey_admin_log` VALUES ('8', '1', '新增栏目：资质荣誉', '127.0.0.1', '/index.php/admin/Arctype/add.html', '1533541838');
INSERT INTO `ey_admin_log` VALUES ('9', '1', '新增栏目：基地展示', '127.0.0.1', '/index.php/admin/Arctype/add.html', '1533541928');
INSERT INTO `ey_admin_log` VALUES ('10', '1', '编辑栏目：养生功效', '127.0.0.1', '/index.php/admin/Arctype/edit.html', '1533541970');
INSERT INTO `ey_admin_log` VALUES ('11', '1', '新增栏目：在线留言', '127.0.0.1', '/index.php/admin/Arctype/add.html', '1533542038');
INSERT INTO `ey_admin_log` VALUES ('12', '1', '新增栏目：联系我们', '127.0.0.1', '/index.php/admin/Arctype/add.html', '1533542102');
INSERT INTO `ey_admin_log` VALUES ('13', '1', '新增广告位：广告一', '127.0.0.1', '/index.php/admin/AdPosition/add.html', '1533542954');
INSERT INTO `ey_admin_log` VALUES ('14', '1', '新增广告：幻灯一', '127.0.0.1', '/index.php/admin/Ad/add.html', '1533543051');
INSERT INTO `ey_admin_log` VALUES ('15', '1', '新增广告：幻灯二', '127.0.0.1', '/index.php/admin/Ad/add.html', '1533543086');
INSERT INTO `ey_admin_log` VALUES ('16', '1', '新增自定义变量：网站公告', '127.0.0.1', '/index.php', '1533544029');
INSERT INTO `ey_admin_log` VALUES ('17', '1', '新增栏目：产品分类1', '127.0.0.1', '/index.php/admin/Arctype/add.html', '1533544954');
INSERT INTO `ey_admin_log` VALUES ('18', '1', '新增栏目：产品分类2', '127.0.0.1', '/index.php/admin/Arctype/add.html', '1533544988');
INSERT INTO `ey_admin_log` VALUES ('19', '1', '新增栏目：产品分类3', '127.0.0.1', '/index.php/admin/Arctype/add.html', '1533545013');
INSERT INTO `ey_admin_log` VALUES ('20', '1', '新增栏目：产品分类4', '127.0.0.1', '/index.php/admin/Arctype/add.html', '1533545041');
INSERT INTO `ey_admin_log` VALUES ('21', '1', '新增普通文章：产品分类1', '127.0.0.1', '/index.php/admin/Article/add.html', '1533545137');
INSERT INTO `ey_admin_log` VALUES ('22', '1', '新增普通文章：产品分类2', '127.0.0.1', '/index.php/admin/Article/add.html', '1533545176');
INSERT INTO `ey_admin_log` VALUES ('23', '1', '新增普通文章：产品分类3', '127.0.0.1', '/index.php/admin/Article/add.html', '1533545213');
INSERT INTO `ey_admin_log` VALUES ('24', '1', '新增普通文章：产品分类4', '127.0.0.1', '/index.php/admin/Article/add.html', '1533545259');
INSERT INTO `ey_admin_log` VALUES ('25', '1', '新增普通文章：产品分类5', '127.0.0.1', '/index.php/admin/Article/add.html', '1533545741');
INSERT INTO `ey_admin_log` VALUES ('26', '1', '新增普通文章：产品分类6', '127.0.0.1', '/index.php/admin/Article/add.html', '1533545871');
INSERT INTO `ey_admin_log` VALUES ('27', '1', '新增普通文章：产品分类7', '127.0.0.1', '/index.php/admin/Article/add.html', '1533545919');
INSERT INTO `ey_admin_log` VALUES ('28', '1', '新增普通文章：产品分类8', '127.0.0.1', '/index.php/admin/Article/add.html', '1533545966');
INSERT INTO `ey_admin_log` VALUES ('29', '1', '新增普通文章：鹿茸的功效与作用', '127.0.0.1', '/index.php/admin/Article/add.html', '1533546473');
INSERT INTO `ey_admin_log` VALUES ('30', '1', '新增普通文章：鹿茸的功效与作用及食用方法', '127.0.0.1', '/index.php/admin/Article/add.html', '1533546573');
INSERT INTO `ey_admin_log` VALUES ('31', '1', '编辑普通文章：鹿茸的功效与作用及食用方法', '127.0.0.1', '/index.php/admin/Article/edit.html', '1533547033');
INSERT INTO `ey_admin_log` VALUES ('32', '1', '新增普通文章：鹿茸是马鹿的好还是梅花鹿的好?', '127.0.0.1', '/index.php/admin/Article/add.html', '1533547560');
INSERT INTO `ey_admin_log` VALUES ('33', '1', '新增普通文章：鹿茸片怎么吃', '127.0.0.1', '/index.php/admin/Article/add.html', '1533547613');
INSERT INTO `ey_admin_log` VALUES ('34', '1', '编辑栏目：关于我们', '127.0.0.1', '/index.php/admin/Arctype/edit.html', '1533548666');
INSERT INTO `ey_admin_log` VALUES ('35', '1', '新增自定义变量：手机号码', '127.0.0.1', '/index.php', '1533550261');
INSERT INTO `ey_admin_log` VALUES ('36', '1', '新增自定义变量：地址', '127.0.0.1', '/index.php', '1533550302');
INSERT INTO `ey_admin_log` VALUES ('37', '1', '新增自定义变量：电话', '127.0.0.1', '/index.php', '1533550375');
INSERT INTO `ey_admin_log` VALUES ('38', '1', '新增自定义变量：邮箱', '127.0.0.1', '/index.php', '1533550438');
INSERT INTO `ey_admin_log` VALUES ('39', '1', '新增普通文章：资质荣誉1', '127.0.0.1', '/index.php/admin/Article/add.html', '1533550537');
INSERT INTO `ey_admin_log` VALUES ('40', '1', '新增普通文章：资质荣誉2', '127.0.0.1', '/index.php/admin/Article/add.html', '1533550567');
INSERT INTO `ey_admin_log` VALUES ('41', '1', '新增友情链接：易优cms', '127.0.0.1', '/index.php/admin/Links/add.html', '1533550678');
INSERT INTO `ey_admin_log` VALUES ('42', '1', '新增友情链接：微信小程序开发教程', '127.0.0.1', '/index.php/admin/Links/add.html', '1533550745');
INSERT INTO `ey_admin_log` VALUES ('43', '1', '新增友情链接：素材58', '127.0.0.1', '/index.php/admin/Links/add.html', '1533550767');
INSERT INTO `ey_admin_log` VALUES ('44', '1', '新增友情链接：区块链是什么', '127.0.0.1', '/index.php/admin/Links/add.html', '1533550789');
INSERT INTO `ey_admin_log` VALUES ('45', '1', '后台登录', '127.0.0.1', '/index.php/admin/Admin/login.html', '1533602292');
INSERT INTO `ey_admin_log` VALUES ('46', '1', '新增自定义变量：微信二维码', '127.0.0.1', '/index.php', '1533607848');
INSERT INTO `ey_admin_log` VALUES ('47', '1', '新增自定义变量：QQ在线', '127.0.0.1', '/index.php', '1533608360');
INSERT INTO `ey_admin_log` VALUES ('48', '1', '新增留言表单：姓名', '127.0.0.1', '/index.php/admin/Guestbook/attribute_add.html', '1533612170');
INSERT INTO `ey_admin_log` VALUES ('49', '1', '新增留言表单：留言内容', '127.0.0.1', '/index.php/admin/Guestbook/attribute_add.html', '1533612191');
INSERT INTO `ey_admin_log` VALUES ('50', '1', '新增留言表单：手机号码', '127.0.0.1', '/index.php/admin/Guestbook/attribute_add.html', '1533612201');
INSERT INTO `ey_admin_log` VALUES ('51', '1', '新增普通文章：养生功效的的那些事？？？', '127.0.0.1', '/index.php/admin/Article/add.html', '1533615022');
INSERT INTO `ey_admin_log` VALUES ('52', '1', '编辑栏目：养生功效', '127.0.0.1', '/index.php/admin/Arctype/edit.html', '1533615068');
INSERT INTO `ey_admin_log` VALUES ('53', '1', '编辑普通文章：养生功效的的那些事？？？', '127.0.0.1', '/index.php/admin/Article/edit.html', '1533615114');
INSERT INTO `ey_admin_log` VALUES ('54', '1', '新增普通文章：产品分类2', '127.0.0.1', '/index.php/admin/Article/add.html', '1533626709');
INSERT INTO `ey_admin_log` VALUES ('55', '1', '新增普通文章：产品分类3', '127.0.0.1', '/index.php/admin/Article/add.html', '1533626756');
INSERT INTO `ey_admin_log` VALUES ('56', '1', '新增普通文章：产品分类4', '127.0.0.1', '/index.php/admin/Article/add.html', '1533626796');
INSERT INTO `ey_admin_log` VALUES ('57', '1', '新增普通文章：基地展示一', '127.0.0.1', '/index.php/admin/Article/add.html', '1533627963');
INSERT INTO `ey_admin_log` VALUES ('58', '1', '新增普通文章：基地展示二', '127.0.0.1', '/index.php/admin/Article/add.html', '1533627996');
INSERT INTO `ey_admin_log` VALUES ('59', '1', '新增普通文章：基地展示三', '127.0.0.1', '/index.php/admin/Article/add.html', '1533628028');
INSERT INTO `ey_admin_log` VALUES ('60', '1', '编辑普通文章：基地展示三', '127.0.0.1', '/index.php/admin/Article/edit.html', '1533628124');
INSERT INTO `ey_admin_log` VALUES ('61', '1', '编辑普通文章：基地展示二', '127.0.0.1', '/index.php/admin/Article/edit.html', '1533628162');
INSERT INTO `ey_admin_log` VALUES ('62', '1', '删除普通文章-id：21', '127.0.0.1', '/index.php/admin/Article/del.html', '1533628171');
INSERT INTO `ey_admin_log` VALUES ('63', '1', '编辑普通文章：基地展示二', '127.0.0.1', '/index.php/admin/Article/edit.html', '1533628210');
INSERT INTO `ey_admin_log` VALUES ('64', '1', '新增普通文章：荣誉资质3', '127.0.0.1', '/index.php/admin/Article/add.html', '1533628273');
INSERT INTO `ey_admin_log` VALUES ('65', '1', '编辑栏目：产品分类1', '127.0.0.1', '/index.php/admin/Arctype/edit.html', '1533631127');
INSERT INTO `ey_admin_log` VALUES ('66', '1', '编辑栏目：产品分类1', '127.0.0.1', '/index.php/admin/Arctype/edit.html', '1533631165');
INSERT INTO `ey_admin_log` VALUES ('67', '1', '编辑栏目：产品分类2', '127.0.0.1', '/index.php/admin/Arctype/edit.html', '1533631211');
INSERT INTO `ey_admin_log` VALUES ('68', '1', '编辑栏目：产品分类1', '127.0.0.1', '/index.php/admin/Arctype/edit.html', '1533631232');
INSERT INTO `ey_admin_log` VALUES ('69', '1', '编辑栏目：产品分类3', '127.0.0.1', '/index.php/admin/Arctype/edit.html', '1533631254');
INSERT INTO `ey_admin_log` VALUES ('70', '1', '编辑栏目：产品分类4', '127.0.0.1', '/index.php/admin/Arctype/edit.html', '1533631275');
INSERT INTO `ey_admin_log` VALUES ('71', '1', '后台登录', '127.0.0.1', '/index.php/admin/Admin/login.html', '1533886871');
INSERT INTO `ey_admin_log` VALUES ('72', '1', '编辑栏目：工程流程', '127.0.0.1', '/index.php/admin/Arctype/edit.html', '1533886996');
INSERT INTO `ey_admin_log` VALUES ('73', '1', '编辑栏目：客户案例', '127.0.0.1', '/index.php/admin/Arctype/edit.html', '1533887032');
INSERT INTO `ey_admin_log` VALUES ('74', '1', '编辑栏目：工艺流程', '127.0.0.1', '/index.php/admin/Arctype/edit.html', '1533888249');
INSERT INTO `ey_admin_log` VALUES ('75', '1', '编辑普通文章：鹿茸片怎么吃', '127.0.0.1', '/index.php/admin/Article/edit.html', '1533888341');
INSERT INTO `ey_admin_log` VALUES ('76', '1', '编辑普通文章：案例展示一', '127.0.0.1', '/index.php/admin/Article/edit.html', '1533891102');
INSERT INTO `ey_admin_log` VALUES ('77', '1', '编辑普通文章：案例展示二', '127.0.0.1', '/index.php/admin/Article/edit.html', '1533891160');
INSERT INTO `ey_admin_log` VALUES ('78', '1', '编辑普通文章：荣誉资质3', '127.0.0.1', '/index.php/admin/Article/edit.html', '1533891708');
INSERT INTO `ey_admin_log` VALUES ('79', '1', '编辑普通文章：资质荣誉2', '127.0.0.1', '/index.php/admin/Article/edit.html', '1533891748');
INSERT INTO `ey_admin_log` VALUES ('80', '1', '编辑普通文章：资质荣誉1', '127.0.0.1', '/index.php/admin/Article/edit.html', '1533891773');
INSERT INTO `ey_admin_log` VALUES ('81', '1', '编辑普通文章：荣誉资质3', '127.0.0.1', '/index.php/admin/Article/edit.html', '1533891832');
INSERT INTO `ey_admin_log` VALUES ('82', '1', '编辑普通文章：资质荣誉1', '127.0.0.1', '/index.php/admin/Article/edit.html', '1533891854');
INSERT INTO `ey_admin_log` VALUES ('83', '1', '编辑普通文章：荣誉资质3', '127.0.0.1', '/index.php/admin/Article/edit.html', '1533891935');
INSERT INTO `ey_admin_log` VALUES ('84', '1', '删除普通文章-id：10,9,8,7,6,5,4,3', '127.0.0.1', '/index.php/admin/Article/del.html', '1533892754');
INSERT INTO `ey_admin_log` VALUES ('85', '1', '新增普通文章：产品分类1', '127.0.0.1', '/index.php/admin/Article/add.html', '1533892809');
INSERT INTO `ey_admin_log` VALUES ('86', '1', '新增普通文章：产品分类2', '127.0.0.1', '/index.php/admin/Article/add.html', '1533892847');
INSERT INTO `ey_admin_log` VALUES ('87', '1', '编辑普通文章：产品分类2', '127.0.0.1', '/index.php/admin/Article/edit.html', '1533892884');
INSERT INTO `ey_admin_log` VALUES ('88', '1', '编辑普通文章：产品分类3', '127.0.0.1', '/index.php/admin/Article/edit.html', '1533892929');
INSERT INTO `ey_admin_log` VALUES ('89', '1', '编辑普通文章：产品分类4', '127.0.0.1', '/index.php/admin/Article/edit.html', '1533892969');
INSERT INTO `ey_admin_log` VALUES ('90', '1', '编辑广告', '127.0.0.1', '/index.php/admin/Ad/edit.html', '1533893417');
INSERT INTO `ey_admin_log` VALUES ('91', '1', '编辑广告', '127.0.0.1', '/index.php/admin/Ad/edit.html', '1533893438');
INSERT INTO `ey_admin_log` VALUES ('92', '1', '编辑普通文章：干豆腐机的工作原理简介', '127.0.0.1', '/index.php/admin/Article/edit.html', '1533897059');
INSERT INTO `ey_admin_log` VALUES ('93', '1', '编辑普通文章：干豆腐机结构简介', '127.0.0.1', '/index.php/admin/Article/edit.html', '1533897089');
INSERT INTO `ey_admin_log` VALUES ('94', '1', '编辑普通文章：干豆腐机的特点', '127.0.0.1', '/index.php/admin/Article/edit.html', '1533897122');
INSERT INTO `ey_admin_log` VALUES ('95', '1', '编辑普通文章：干豆腐的制作原理', '127.0.0.1', '/index.php/admin/Article/edit.html', '1533897179');
INSERT INTO `ey_admin_log` VALUES ('96', '1', '编辑栏目：关于我们', '127.0.0.1', '/index.php/admin/Arctype/edit.html', '1533897387');
INSERT INTO `ey_admin_log` VALUES ('97', '1', '编辑普通文章：ZM150半自动磨浆机组', '127.0.0.1', '/index.php/admin/Article/edit.html', '1533897506');
INSERT INTO `ey_admin_log` VALUES ('98', '1', '编辑栏目：联系我们', '127.0.0.1', '/index.php/admin/Arctype/edit.html', '1533897598');
INSERT INTO `ey_admin_log` VALUES ('99', '1', '后台登录', '127.0.0.1', '/index.php/admin/Admin/login.html', '1533970580');
INSERT INTO `ey_admin_log` VALUES ('100', '1', '编辑普通文章：干豆腐机结构简介', '127.0.0.1', '/index.php/admin/Article/edit.html', '1533970655');
INSERT INTO `ey_admin_log` VALUES ('101', '1', '编辑普通文章：干豆腐机的工作原理简介', '127.0.0.1', '/index.php/admin/Article/edit.html', '1533970663');
INSERT INTO `ey_admin_log` VALUES ('102', '1', '编辑普通文章：干豆腐机的特点', '127.0.0.1', '/index.php/admin/Article/edit.html', '1533970677');
INSERT INTO `ey_admin_log` VALUES ('103', '1', '编辑普通文章：干豆腐的制作原理', '127.0.0.1', '/index.php/admin/Article/edit.html', '1533970687');
INSERT INTO `ey_admin_log` VALUES ('104', '1', '后台登录', '127.0.0.1', '/index.php/admin/Admin/login.html', '1534149130');
INSERT INTO `ey_admin_log` VALUES ('105', '1', '编辑广告', '127.0.0.1', '/index.php/admin/Ad/edit.html', '1534150998');
INSERT INTO `ey_admin_log` VALUES ('106', '1', '编辑广告', '127.0.0.1', '/index.php/admin/Ad/edit.html', '1534151024');
INSERT INTO `ey_admin_log` VALUES ('107', '1', '编辑栏目：课程设置', '127.0.0.1', '/index.php/admin/Arctype/edit.html', '1534151172');
INSERT INTO `ey_admin_log` VALUES ('108', '1', '新增栏目：招生简章', '127.0.0.1', '/index.php/admin/Arctype/add.html', '1534151326');
INSERT INTO `ey_admin_log` VALUES ('109', '1', '编辑栏目：课程设置', '127.0.0.1', '/index.php/admin/Arctype/edit.html', '1534151344');
INSERT INTO `ey_admin_log` VALUES ('110', '1', '编辑栏目：外交团队', '127.0.0.1', '/index.php/admin/Arctype/edit.html', '1534151425');
INSERT INTO `ey_admin_log` VALUES ('111', '1', '删除栏目：工艺流程', '127.0.0.1', '/index.php/admin/Arctype/del.html', '1534151454');
INSERT INTO `ey_admin_log` VALUES ('112', '1', '删除栏目：资质荣誉', '127.0.0.1', '/index.php/admin/Arctype/del.html', '1534151460');
INSERT INTO `ey_admin_log` VALUES ('113', '1', '新增栏目：就业指南', '127.0.0.1', '/index.php/admin/Arctype/add.html', '1534151499');
INSERT INTO `ey_admin_log` VALUES ('114', '1', '新增栏目：学员风采', '127.0.0.1', '/index.php/admin/Arctype/add.html', '1534151594');
INSERT INTO `ey_admin_log` VALUES ('115', '1', '编辑普通文章：外交团队标题', '127.0.0.1', '/index.php/admin/Article/edit.html', '1534155468');
INSERT INTO `ey_admin_log` VALUES ('116', '1', '编辑普通文章：外交团队标题', '127.0.0.1', '/index.php/admin/Article/edit.html', '1534155522');
INSERT INTO `ey_admin_log` VALUES ('117', '1', '新增普通文章：外加团队标题', '127.0.0.1', '/index.php/admin/Article/add.html', '1534155566');
INSERT INTO `ey_admin_log` VALUES ('118', '1', '新增普通文章：外教团队标题4', '127.0.0.1', '/index.php/admin/Article/add.html', '1534155610');
INSERT INTO `ey_admin_log` VALUES ('119', '1', '编辑普通文章：外加团队标题3', '127.0.0.1', '/index.php/admin/Article/edit.html', '1534155620');
INSERT INTO `ey_admin_log` VALUES ('120', '1', '编辑普通文章：外交团队标题2', '127.0.0.1', '/index.php/admin/Article/edit.html', '1534155628');
INSERT INTO `ey_admin_log` VALUES ('121', '1', '编辑普通文章：外交团队标题1', '127.0.0.1', '/index.php/admin/Article/edit.html', '1534155636');
INSERT INTO `ey_admin_log` VALUES ('122', '1', '新增普通文章：学员风采一', '127.0.0.1', '/index.php/admin/Article/add.html', '1534156130');
INSERT INTO `ey_admin_log` VALUES ('123', '1', '新增普通文章：学员风采二', '127.0.0.1', '/index.php/admin/Article/add.html', '1534156172');
INSERT INTO `ey_admin_log` VALUES ('124', '1', '新增普通文章：学员风采三', '127.0.0.1', '/index.php/admin/Article/add.html', '1534156221');
INSERT INTO `ey_admin_log` VALUES ('125', '1', '新增普通文章：学员风采四', '127.0.0.1', '/index.php/admin/Article/add.html', '1534156264');
INSERT INTO `ey_admin_log` VALUES ('126', '1', '后台登录', '127.0.0.1', '/index.php/admin/Admin/login.html', '1534217800');
INSERT INTO `ey_admin_log` VALUES ('127', '1', '编辑栏目：关于我们', '127.0.0.1', '/index.php/admin/Arctype/edit.html', '1534218841');
INSERT INTO `ey_admin_log` VALUES ('128', '1', '编辑栏目：关于我们', '127.0.0.1', '/index.php/admin/Arctype/edit.html', '1534218890');
INSERT INTO `ey_admin_log` VALUES ('129', '1', '编辑栏目：关于我们', '127.0.0.1', '/index.php/admin/Arctype/edit.html', '1534218958');
INSERT INTO `ey_admin_log` VALUES ('130', '1', '编辑栏目：关于我们', '127.0.0.1', '/index.php/admin/Arctype/edit.html', '1534219133');
INSERT INTO `ey_admin_log` VALUES ('131', '1', '编辑栏目：关于我们', '127.0.0.1', '/index.php/admin/Arctype/edit.html', '1534219154');
INSERT INTO `ey_admin_log` VALUES ('132', '1', '编辑栏目：关于我们', '127.0.0.1', '/index.php/admin/Arctype/edit.html', '1534219336');
INSERT INTO `ey_admin_log` VALUES ('133', '1', '编辑栏目：关于我们', '127.0.0.1', '/index.php/admin/Arctype/edit.html', '1534219562');
INSERT INTO `ey_admin_log` VALUES ('134', '1', '编辑栏目：联系我们', '127.0.0.1', '/index.php/admin/Arctype/edit.html', '1534219608');
INSERT INTO `ey_admin_log` VALUES ('135', '1', '编辑栏目：关于我们', '127.0.0.1', '/index.php/admin/Arctype/edit.html', '1534229164');
INSERT INTO `ey_admin_log` VALUES ('136', '1', '编辑栏目：关于我们', '127.0.0.1', '/index.php/admin/Arctype/edit.html', '1534238622');
INSERT INTO `ey_admin_log` VALUES ('137', '1', '编辑栏目：关于我们', '127.0.0.1', '/index.php/admin/Arctype/edit.html', '1534238667');
INSERT INTO `ey_admin_log` VALUES ('138', '1', '删除栏目：产品分类1', '127.0.0.1', '/index.php/admin/Arctype/del.html', '1534240736');
INSERT INTO `ey_admin_log` VALUES ('139', '1', '删除栏目：产品分类2', '127.0.0.1', '/index.php/admin/Arctype/del.html', '1534240742');
INSERT INTO `ey_admin_log` VALUES ('140', '1', '删除栏目：产品分类3', '127.0.0.1', '/index.php/admin/Arctype/del.html', '1534240748');
INSERT INTO `ey_admin_log` VALUES ('141', '1', '删除栏目：产品分类4', '127.0.0.1', '/index.php/admin/Arctype/del.html', '1534240753');
INSERT INTO `ey_admin_log` VALUES ('142', '1', '新增栏目：课程类一', '127.0.0.1', '/index.php/admin/Arctype/add.html', '1534240861');
INSERT INTO `ey_admin_log` VALUES ('143', '1', '新增栏目：课程类别二', '127.0.0.1', '/index.php/admin/Arctype/add.html', '1534241073');
INSERT INTO `ey_admin_log` VALUES ('144', '1', '编辑栏目：课程类别二', '127.0.0.1', '/index.php/admin/Arctype/edit.html', '1534241411');
INSERT INTO `ey_admin_log` VALUES ('145', '1', '编辑栏目：课程类二', '127.0.0.1', '/index.php/admin/Arctype/edit.html', '1534241761');
INSERT INTO `ey_admin_log` VALUES ('146', '1', '编辑普通文章：线上线下深度匹配', '127.0.0.1', '/index.php/admin/Article/edit.html', '1534241923');
INSERT INTO `ey_admin_log` VALUES ('147', '1', '编辑普通文章：固定专属外教', '127.0.0.1', '/index.php/admin/Article/edit.html', '1534241950');
INSERT INTO `ey_admin_log` VALUES ('148', '1', '编辑普通文章：在线一对一', '127.0.0.1', '/index.php/admin/Article/edit.html', '1534241989');
INSERT INTO `ey_admin_log` VALUES ('149', '1', '编辑普通文章：严选每一位教师  严把教学质量关', '127.0.0.1', '/index.php/admin/Article/edit.html', '1534242050');
INSERT INTO `ey_admin_log` VALUES ('150', '1', '编辑栏目：招生简章', '127.0.0.1', '/index.php/admin/Arctype/edit.html', '1534242110');
INSERT INTO `ey_admin_log` VALUES ('151', '1', '新增普通文章：外教持证上岗', '127.0.0.1', '/index.php/admin/Article/add.html', '1534242198');
INSERT INTO `ey_admin_log` VALUES ('152', '1', '新增普通文章：外教一对一外教英语', '127.0.0.1', '/index.php/admin/Article/add.html', '1534242290');
INSERT INTO `ey_admin_log` VALUES ('153', '1', '新增普通文章：学而思外教 - 在家与外教实时互动练口语', '127.0.0.1', '/index.php/admin/Article/add.html', '1534242319');
INSERT INTO `ey_admin_log` VALUES ('154', '1', '后台登录', '127.0.0.1', '/index.php/admin/Admin/login.html', '1534294843');
INSERT INTO `ey_admin_log` VALUES ('155', '1', '编辑普通文章：线上线下深度匹配', '127.0.0.1', '/index.php/admin/Article/edit.html', '1534294889');
INSERT INTO `ey_admin_log` VALUES ('156', '1', '编辑普通文章：固定专属外教', '127.0.0.1', '/index.php/admin/Article/edit.html', '1534294899');
INSERT INTO `ey_admin_log` VALUES ('157', '1', '编辑普通文章：在线一对一', '127.0.0.1', '/index.php/admin/Article/edit.html', '1534294911');
INSERT INTO `ey_admin_log` VALUES ('158', '1', '编辑普通文章：严选每一位教师  严把教学质量关', '127.0.0.1', '/index.php/admin/Article/edit.html', '1534294927');
INSERT INTO `ey_admin_log` VALUES ('159', '1', '编辑栏目：关于我们', '127.0.0.1', '/index.php/admin/Arctype/edit.html', '1534294994');
INSERT INTO `ey_admin_log` VALUES ('160', '1', '编辑栏目：关于我们', '127.0.0.1', '/index.php/admin/Arctype/edit.html', '1534295049');
INSERT INTO `ey_admin_log` VALUES ('161', '1', '编辑栏目：关于我们', '127.0.0.1', '/index.php/admin/Arctype/edit.html', '1534295083');
INSERT INTO `ey_admin_log` VALUES ('162', '1', '后台登录', '127.0.0.1', '/index.php/admin/Admin/login.html', '1534317604');
INSERT INTO `ey_admin_log` VALUES ('163', '1', '编辑栏目：产品展示', '127.0.0.1', '/index.php/admin/Arctype/edit.html', '1534318602');
INSERT INTO `ey_admin_log` VALUES ('164', '1', '编辑栏目：工程案例', '127.0.0.1', '/index.php/admin/Arctype/edit.html', '1534318647');
INSERT INTO `ey_admin_log` VALUES ('165', '1', '编辑栏目：安全常识', '127.0.0.1', '/index.php/admin/Arctype/edit.html', '1534318696');
INSERT INTO `ey_admin_log` VALUES ('166', '1', '编辑栏目：人才招聘', '127.0.0.1', '/index.php/admin/Arctype/edit.html', '1534318765');
INSERT INTO `ey_admin_log` VALUES ('167', '1', '新增栏目：资质荣誉', '127.0.0.1', '/index.php/admin/Arctype/add.html', '1534318840');
INSERT INTO `ey_admin_log` VALUES ('168', '1', '删除栏目：学员风采', '127.0.0.1', '/index.php/admin/Arctype/del.html', '1534318873');
INSERT INTO `ey_admin_log` VALUES ('169', '1', '编辑广告', '127.0.0.1', '/index.php/admin/Ad/edit.html', '1534319147');
INSERT INTO `ey_admin_log` VALUES ('170', '1', '编辑广告', '127.0.0.1', '/index.php/admin/Ad/edit.html', '1534319158');
INSERT INTO `ey_admin_log` VALUES ('171', '1', '编辑栏目：灭火器具', '127.0.0.1', '/index.php/admin/Arctype/edit.html', '1534321930');
INSERT INTO `ey_admin_log` VALUES ('172', '1', '编辑栏目：安防用品', '127.0.0.1', '/index.php/admin/Arctype/edit.html', '1534321993');
INSERT INTO `ey_admin_log` VALUES ('173', '1', '编辑栏目：灭火器具', '127.0.0.1', '/index.php/admin/Arctype/edit.html', '1534322013');
INSERT INTO `ey_admin_log` VALUES ('174', '1', '新增栏目：消防用水', '127.0.0.1', '/index.php/admin/Arctype/add.html', '1534322047');
INSERT INTO `ey_admin_log` VALUES ('175', '1', '新增栏目：消防栓', '127.0.0.1', '/index.php/admin/Arctype/add.html', '1534322092');
INSERT INTO `ey_admin_log` VALUES ('176', '1', '编辑普通文章：产品中心标题', '127.0.0.1', '/index.php/admin/Article/edit.html', '1534322155');
INSERT INTO `ey_admin_log` VALUES ('177', '1', '编辑普通文章：产品中心标题2', '127.0.0.1', '/index.php/admin/Article/edit.html', '1534322201');
INSERT INTO `ey_admin_log` VALUES ('178', '1', '新增普通文章：产品中心标题3', '127.0.0.1', '/index.php/admin/Article/add.html', '1534322231');
INSERT INTO `ey_admin_log` VALUES ('179', '1', '新增普通文章：产品中心标题4', '127.0.0.1', '/index.php/admin/Article/add.html', '1534322270');
INSERT INTO `ey_admin_log` VALUES ('180', '1', '新增普通文章：产品中心标题5', '127.0.0.1', '/index.php/admin/Article/add.html', '1534322340');
INSERT INTO `ey_admin_log` VALUES ('181', '1', '新增普通文章：产品中心标题6', '127.0.0.1', '/index.php/admin/Article/add.html', '1534322370');
INSERT INTO `ey_admin_log` VALUES ('182', '1', '新增普通文章：产品中心标题7', '127.0.0.1', '/index.php/admin/Article/add.html', '1534322395');
INSERT INTO `ey_admin_log` VALUES ('183', '1', '新增普通文章：产品中心标题8', '127.0.0.1', '/index.php/admin/Article/add.html', '1534322430');
INSERT INTO `ey_admin_log` VALUES ('184', '1', '新增普通文章：产品中心标题9', '127.0.0.1', '/index.php/admin/Article/add.html', '1534322472');
INSERT INTO `ey_admin_log` VALUES ('185', '1', '编辑普通文章：线上线下深度匹配', '127.0.0.1', '/index.php/admin/Article/edit.html', '1534323126');
INSERT INTO `ey_admin_log` VALUES ('186', '1', '编辑普通文章：固定专属外教', '127.0.0.1', '/index.php/admin/Article/edit.html', '1534323160');
INSERT INTO `ey_admin_log` VALUES ('187', '1', '编辑普通文章：在线一对一', '127.0.0.1', '/index.php/admin/Article/edit.html', '1534323183');
INSERT INTO `ey_admin_log` VALUES ('188', '1', '编辑普通文章：严选每一位教师  严把教学质量关', '127.0.0.1', '/index.php/admin/Article/edit.html', '1534323195');
INSERT INTO `ey_admin_log` VALUES ('189', '1', '编辑普通文章：工程案例一', '127.0.0.1', '/index.php/admin/Article/edit.html', '1534323535');
INSERT INTO `ey_admin_log` VALUES ('190', '1', '编辑普通文章：工程案例二', '127.0.0.1', '/index.php/admin/Article/edit.html', '1534323555');
INSERT INTO `ey_admin_log` VALUES ('191', '1', '编辑普通文章：工程案例三', '127.0.0.1', '/index.php/admin/Article/edit.html', '1534323590');
INSERT INTO `ey_admin_log` VALUES ('192', '1', '编辑普通文章：外交团队标题1', '127.0.0.1', '/index.php/admin/Article/edit.html', '1534323623');
INSERT INTO `ey_admin_log` VALUES ('193', '1', '编辑普通文章：工程案例一', '127.0.0.1', '/index.php/admin/Article/edit.html', '1534323761');
INSERT INTO `ey_admin_log` VALUES ('194', '1', '编辑普通文章：工程案例', '127.0.0.1', '/index.php/admin/Article/edit.html', '1534323811');
INSERT INTO `ey_admin_log` VALUES ('195', '1', '后台登录', '127.0.0.1', '/index.php/admin/Admin/login.html', '1534384467');
INSERT INTO `ey_admin_log` VALUES ('196', '1', '编辑栏目：关于我们', '127.0.0.1', '/index.php/admin/Arctype/edit.html', '1534403478');
INSERT INTO `ey_admin_log` VALUES ('197', '1', '编辑普通文章：公安部消防局解读新消防法', '127.0.0.1', '/index.php/admin/Article/edit.html', '1534404456');
INSERT INTO `ey_admin_log` VALUES ('198', '1', '编辑普通文章： 新的消防工作原则', '127.0.0.1', '/index.php/admin/Article/edit.html', '1534404491');
INSERT INTO `ey_admin_log` VALUES ('199', '1', '编辑普通文章：  消防监督管理主体例外规定', '127.0.0.1', '/index.php/admin/Article/edit.html', '1534404512');
INSERT INTO `ey_admin_log` VALUES ('200', '1', '编辑普通文章：公众聚集场所消防安全检查', '127.0.0.1', '/index.php/admin/Article/edit.html', '1534404535');
INSERT INTO `ey_admin_log` VALUES ('201', '1', '编辑普通文章： 消防产品监督管理制度', '127.0.0.1', '/index.php/admin/Article/edit.html', '1534404595');
INSERT INTO `ey_admin_log` VALUES ('202', '1', '新增普通文章： 完善消防行政处罚制度', '127.0.0.1', '/index.php/admin/Article/add.html', '1534404650');
INSERT INTO `ey_admin_log` VALUES ('203', '1', '新增普通文章：新的消防工作原则', '127.0.0.1', '/index.php/admin/Article/add.html', '1534404693');
INSERT INTO `ey_admin_log` VALUES ('204', '1', '新增普通文章： 消防安全关系人民安居乐业、社会安定和经济建设', '127.0.0.1', '/index.php/admin/Article/add.html', '1534404718');
INSERT INTO `ey_admin_log` VALUES ('205', '1', '后台登录', '127.0.0.1', '/index.php/admin/Admin/login.html', '1534412066');
INSERT INTO `ey_admin_log` VALUES ('206', '1', '编辑广告', '127.0.0.1', '/index.php/admin/Ad/edit.html', '1534412751');
INSERT INTO `ey_admin_log` VALUES ('207', '1', '编辑广告', '127.0.0.1', '/index.php/admin/Ad/edit.html', '1534412765');
INSERT INTO `ey_admin_log` VALUES ('208', '1', '编辑栏目：热门游戏', '127.0.0.1', '/index.php/admin/Arctype/edit.html', '1534415822');
INSERT INTO `ey_admin_log` VALUES ('209', '1', '后台登录', '127.0.0.1', '/index.php/admin/Admin/login.html', '1534472758');
INSERT INTO `ey_admin_log` VALUES ('210', '1', '编辑栏目：热门游戏', '127.0.0.1', '/index.php/admin/Arctype/edit.html', '1534472840');
INSERT INTO `ey_admin_log` VALUES ('211', '1', '删除普通文章-id：43,42,41,40,39,38,37,36,35', '127.0.0.1', '/index.php/admin/Article/del.html', '1534473458');
INSERT INTO `ey_admin_log` VALUES ('212', '1', '删除栏目：灭火器具', '127.0.0.1', '/index.php/admin/Arctype/del.html', '1534473543');
INSERT INTO `ey_admin_log` VALUES ('213', '1', '删除栏目：安防用品', '127.0.0.1', '/index.php/admin/Arctype/del.html', '1534473552');
INSERT INTO `ey_admin_log` VALUES ('214', '1', '删除栏目：消防用水', '127.0.0.1', '/index.php/admin/Arctype/del.html', '1534473588');
INSERT INTO `ey_admin_log` VALUES ('215', '1', '删除栏目：消防栓', '127.0.0.1', '/index.php/admin/Arctype/del.html', '1534473598');
INSERT INTO `ey_admin_log` VALUES ('216', '1', '新增普通文章：热门游戏1', '127.0.0.1', '/index.php/admin/Article/add.html', '1534473772');
INSERT INTO `ey_admin_log` VALUES ('217', '1', '新增普通文章：热门游戏2', '127.0.0.1', '/index.php/admin/Article/add.html', '1534473891');
INSERT INTO `ey_admin_log` VALUES ('218', '1', '新增普通文章：热门游戏3', '127.0.0.1', '/index.php/admin/Article/add.html', '1534490575');
INSERT INTO `ey_admin_log` VALUES ('219', '1', '新增普通文章：热门游戏4', '127.0.0.1', '/index.php/admin/Article/add.html', '1534490652');
INSERT INTO `ey_admin_log` VALUES ('220', '1', '编辑栏目：游戏展示', '127.0.0.1', '/index.php/admin/Arctype/edit.html', '1534490901');
INSERT INTO `ey_admin_log` VALUES ('221', '1', '编辑普通文章：游戏展示一', '127.0.0.1', '/index.php/admin/Article/edit.html', '1534490952');
INSERT INTO `ey_admin_log` VALUES ('222', '1', '编辑普通文章：游戏展示二', '127.0.0.1', '/index.php/admin/Article/edit.html', '1534490987');
INSERT INTO `ey_admin_log` VALUES ('223', '1', '编辑普通文章：游戏展示三', '127.0.0.1', '/index.php/admin/Article/edit.html', '1534491027');
INSERT INTO `ey_admin_log` VALUES ('224', '1', '编辑普通文章：游戏展示四', '127.0.0.1', '/index.php/admin/Article/edit.html', '1534491067');
INSERT INTO `ey_admin_log` VALUES ('225', '1', '新增普通文章：游戏展示5', '127.0.0.1', '/index.php/admin/Article/add.html', '1534491098');
INSERT INTO `ey_admin_log` VALUES ('226', '1', '新增普通文章：游戏展示六', '127.0.0.1', '/index.php/admin/Article/add.html', '1534491139');
INSERT INTO `ey_admin_log` VALUES ('227', '1', '编辑普通文章：游戏展示五', '127.0.0.1', '/index.php/admin/Article/edit.html', '1534491149');
INSERT INTO `ey_admin_log` VALUES ('228', '1', '新增普通文章：游戏展示七', '127.0.0.1', '/index.php/admin/Article/add.html', '1534491180');
INSERT INTO `ey_admin_log` VALUES ('229', '1', '新增普通文章：游戏展示八', '127.0.0.1', '/index.php/admin/Article/add.html', '1534491215');
INSERT INTO `ey_admin_log` VALUES ('230', '1', '编辑栏目：功能介绍', '127.0.0.1', '/index.php/admin/Arctype/edit.html', '1534491423');
INSERT INTO `ey_admin_log` VALUES ('231', '1', '编辑普通文章：功能游戏将有两位数的年均复合增长率', '127.0.0.1', '/index.php/admin/Article/edit.html', '1534491596');
INSERT INTO `ey_admin_log` VALUES ('232', '1', '编辑普通文章：游戏展示四', '127.0.0.1', '/index.php/admin/Article/edit.html', '1534492945');
INSERT INTO `ey_admin_log` VALUES ('233', '1', '编辑普通文章：开发功能性游戏，对在全球网络游戏市场份额占比近10%的腾讯来说', '127.0.0.1', '/index.php/admin/Article/edit.html', '1534493199');
INSERT INTO `ey_admin_log` VALUES ('234', '1', '编辑普通文章：　以网络游戏为代表的网络文艺治理，已经构成我们无法回避的时代性挑战', '127.0.0.1', '/index.php/admin/Article/edit.html', '1534493232');
INSERT INTO `ey_admin_log` VALUES ('235', '1', '编辑普通文章：在全部网民中的占比接近7成。我国网络游戏行业整体营收达2189.6亿元', '127.0.0.1', '/index.php/admin/Article/edit.html', '1534493286');
INSERT INTO `ey_admin_log` VALUES ('236', '1', '编辑普通文章：近日，腾讯公司正式对外宣布，将从今年开始，对功能游戏进行全方位调整和布局，包括传统文化、前沿探索、理工锻炼、科学普及以及亲子互动类型。', '127.0.0.1', '/index.php/admin/Article/edit.html', '1534493638');
INSERT INTO `ey_admin_log` VALUES ('237', '1', '编辑普通文章：近日，腾讯公司正式对外宣布', '127.0.0.1', '/index.php/admin/Article/edit.html', '1534493650');
INSERT INTO `ey_admin_log` VALUES ('238', '1', '编辑普通文章：未来几年，功能游戏将有两位数的年均复合增长率', '127.0.0.1', '/index.php/admin/Article/edit.html', '1534493684');
INSERT INTO `ey_admin_log` VALUES ('239', '1', '编辑普通文章：　以网络游戏为代表的网络文艺治理', '127.0.0.1', '/index.php/admin/Article/edit.html', '1534493723');
INSERT INTO `ey_admin_log` VALUES ('240', '1', '编辑普通文章：功能游戏将有两位数的年均复合增长率', '127.0.0.1', '/index.php/admin/Article/edit.html', '1534494219');
INSERT INTO `ey_admin_log` VALUES ('241', '1', '编辑普通文章：近日，腾讯公司正式对外宣布', '127.0.0.1', '/index.php/admin/Article/edit.html', '1534497384');
INSERT INTO `ey_admin_log` VALUES ('242', '1', '编辑普通文章：未来几年，功能游戏将有两位数的年均复合增长率', '127.0.0.1', '/index.php/admin/Article/edit.html', '1534497392');
INSERT INTO `ey_admin_log` VALUES ('243', '1', '编辑普通文章：　以网络游戏为代表的网络文艺治理', '127.0.0.1', '/index.php/admin/Article/edit.html', '1534497399');
INSERT INTO `ey_admin_log` VALUES ('244', '1', '编辑普通文章：公众聚集场所消防安全检查', '127.0.0.1', '/index.php/admin/Article/edit.html', '1534497406');
INSERT INTO `ey_admin_log` VALUES ('245', '1', '编辑普通文章：游戏展示八', '127.0.0.1', '/index.php/admin/Article/edit.html', '1534498204');
INSERT INTO `ey_admin_log` VALUES ('246', '1', '编辑普通文章：游戏展示七', '127.0.0.1', '/index.php/admin/Article/edit.html', '1534498364');
INSERT INTO `ey_admin_log` VALUES ('247', '1', '编辑普通文章：游戏展示六', '127.0.0.1', '/index.php/admin/Article/edit.html', '1534498382');
INSERT INTO `ey_admin_log` VALUES ('248', '1', '编辑普通文章：游戏展示五', '127.0.0.1', '/index.php/admin/Article/edit.html', '1534498405');
INSERT INTO `ey_admin_log` VALUES ('249', '1', '编辑普通文章：游戏展示一', '127.0.0.1', '/index.php/admin/Article/edit.html', '1534498422');
INSERT INTO `ey_admin_log` VALUES ('250', '1', '编辑普通文章：游戏展示二', '127.0.0.1', '/index.php/admin/Article/edit.html', '1534498449');
INSERT INTO `ey_admin_log` VALUES ('251', '1', '编辑普通文章：游戏展示一', '127.0.0.1', '/index.php/admin/Article/edit.html', '1534498477');
INSERT INTO `ey_admin_log` VALUES ('252', '1', '编辑普通文章：游戏展示二', '127.0.0.1', '/index.php/admin/Article/edit.html', '1534498485');
INSERT INTO `ey_admin_log` VALUES ('253', '1', '编辑普通文章：游戏展示三', '127.0.0.1', '/index.php/admin/Article/edit.html', '1534498494');
INSERT INTO `ey_admin_log` VALUES ('254', '1', '编辑普通文章：游戏展示三', '127.0.0.1', '/index.php/admin/Article/edit.html', '1534498522');
INSERT INTO `ey_admin_log` VALUES ('255', '1', '编辑普通文章：游戏展示四', '127.0.0.1', '/index.php/admin/Article/edit.html', '1534498539');
INSERT INTO `ey_admin_log` VALUES ('256', '1', '新增栏目：竞技游戏', '127.0.0.1', '/index.php/admin/Arctype/add.html', '1534499010');
INSERT INTO `ey_admin_log` VALUES ('257', '1', '新增栏目：场景游戏', '127.0.0.1', '/index.php/admin/Arctype/add.html', '1534499036');
INSERT INTO `ey_admin_log` VALUES ('258', '1', '新增栏目：互动游戏', '127.0.0.1', '/index.php/admin/Arctype/add.html', '1534499052');
INSERT INTO `ey_admin_log` VALUES ('259', '1', '后台登录', '127.0.0.1', '/index.php/admin/Admin/login.html', '1534560528');
INSERT INTO `ey_admin_log` VALUES ('260', '1', '新增普通文章：荣誉资质', '127.0.0.1', '/index.php/admin/Article/add.html', '1534579683');
INSERT INTO `ey_admin_log` VALUES ('261', '1', '新增普通文章：荣誉资质2', '127.0.0.1', '/index.php/admin/Article/add.html', '1534579712');
INSERT INTO `ey_admin_log` VALUES ('262', '1', '编辑栏目：资质荣誉', '127.0.0.1', '/index.php/admin/Arctype/edit.html', '1534579739');
INSERT INTO `ey_admin_log` VALUES ('263', '1', '删除栏目：资质荣誉', '127.0.0.1', '/index.php/admin/Arctype/del.html', '1534579787');
INSERT INTO `ey_admin_log` VALUES ('264', '1', '编辑普通文章：热门游戏4', '127.0.0.1', '/index.php/admin/Article/edit.html', '1534584661');
INSERT INTO `ey_admin_log` VALUES ('265', '1', '编辑普通文章：热门游戏3', '127.0.0.1', '/index.php/admin/Article/edit.html', '1534584703');
INSERT INTO `ey_admin_log` VALUES ('266', '1', '编辑普通文章：热门游戏2', '127.0.0.1', '/index.php/admin/Article/edit.html', '1534584736');
INSERT INTO `ey_admin_log` VALUES ('267', '1', '编辑普通文章：热门游戏1', '127.0.0.1', '/index.php/admin/Article/edit.html', '1534584755');
INSERT INTO `ey_admin_log` VALUES ('268', '1', '编辑普通文章：游戏展示八', '127.0.0.1', '/index.php/admin/Article/edit.html', '1534584897');
INSERT INTO `ey_admin_log` VALUES ('269', '1', '编辑普通文章：游戏展示七', '127.0.0.1', '/index.php/admin/Article/edit.html', '1534584922');
INSERT INTO `ey_admin_log` VALUES ('270', '1', '编辑普通文章：游戏展示六', '127.0.0.1', '/index.php/admin/Article/edit.html', '1534584940');
INSERT INTO `ey_admin_log` VALUES ('271', '1', '编辑普通文章：游戏展示五', '127.0.0.1', '/index.php/admin/Article/edit.html', '1534584966');
INSERT INTO `ey_admin_log` VALUES ('272', '1', '编辑普通文章：游戏展示一', '127.0.0.1', '/index.php/admin/Article/edit.html', '1534584988');
INSERT INTO `ey_admin_log` VALUES ('273', '1', '编辑普通文章：游戏展示二', '127.0.0.1', '/index.php/admin/Article/edit.html', '1534585010');
INSERT INTO `ey_admin_log` VALUES ('274', '1', '编辑普通文章：游戏展示三', '127.0.0.1', '/index.php/admin/Article/edit.html', '1534585035');
INSERT INTO `ey_admin_log` VALUES ('275', '1', '编辑普通文章：游戏展示四', '127.0.0.1', '/index.php/admin/Article/edit.html', '1534585056');
INSERT INTO `ey_admin_log` VALUES ('276', '1', '后台登录', '127.0.0.1', '/index.php/admin/Admin/login.html', '1535503285');
INSERT INTO `ey_admin_log` VALUES ('277', '1', '编辑广告', '127.0.0.1', '/index.php/admin/Ad/edit.html', '1535503381');
INSERT INTO `ey_admin_log` VALUES ('278', '1', '编辑广告', '127.0.0.1', '/index.php/admin/Ad/edit.html', '1535503396');
INSERT INTO `ey_admin_log` VALUES ('279', '1', '编辑文章：功能游戏将有两位数的年均复合增长率', '127.0.0.1', '/index.php/admin/Article/edit.html', '1535503467');
INSERT INTO `ey_admin_log` VALUES ('280', '1', '编辑文章：开发功能性游戏，对在全球网络游戏市场份额占比近10%的腾讯来说', '127.0.0.1', '/index.php/admin/Article/edit.html', '1535503482');
INSERT INTO `ey_admin_log` VALUES ('281', '1', '后台登录', '127.0.0.1', '/index.php/admin/Admin/login.html', '1535528799');
INSERT INTO `ey_admin_log` VALUES ('282', '1', '编辑自定义变量：QQ客服', '127.0.0.1', '/index.php/admin/System/customvar.html', '1535528908');
INSERT INTO `ey_admin_log` VALUES ('283', '1', '编辑广告位：首页幻灯', '127.0.0.1', '/index.php/admin/AdPosition/edit.html', '1535529096');
INSERT INTO `ey_admin_log` VALUES ('284', '1', '编辑友情链接：易优cms', '127.0.0.1', '/index.php/admin/Links/edit.html', '1535529160');
INSERT INTO `ey_admin_log` VALUES ('285', '1', '编辑栏目：联系我们', '127.0.0.1', '/index.php/admin/Arctype/edit.html', '1535529356');
INSERT INTO `ey_admin_log` VALUES ('286', '1', '编辑栏目：功能介绍', '127.0.0.1', '/index.php/admin/Arctype/edit.html', '1535529367');
INSERT INTO `ey_admin_log` VALUES ('287', '1', '删除留言-id：4,3,2,1', '127.0.0.1', '/index.php/admin/Guestbook/del.html', '1535531052');
INSERT INTO `ey_admin_log` VALUES ('288', '1', '编辑栏目：联系我们', '127.0.0.1', '/index.php/admin/Arctype/single.html', '1535531150');
INSERT INTO `ey_admin_log` VALUES ('289', '1', '移动文档-id：54,53,52,51,29,28,23,22', '127.0.0.1', '/index.php/admin/Article/move.html', '1535531282');
INSERT INTO `ey_admin_log` VALUES ('290', '1', '编辑栏目：竞技游戏', '127.0.0.1', '/index.php/admin/Arctype/edit.html', '1535531304');
INSERT INTO `ey_admin_log` VALUES ('291', '1', '编辑栏目：场景游戏', '127.0.0.1', '/index.php/admin/Arctype/edit.html', '1535531311');
INSERT INTO `ey_admin_log` VALUES ('292', '1', '编辑栏目：互动游戏', '127.0.0.1', '/index.php/admin/Arctype/edit.html', '1535531318');
INSERT INTO `ey_admin_log` VALUES ('293', '1', '编辑栏目：热门游戏', '127.0.0.1', '/index.php/admin/Arctype/edit.html', '1535531480');
INSERT INTO `ey_admin_log` VALUES ('294', '1', '编辑栏目：场景游戏', '127.0.0.1', '/index.php/admin/Arctype/edit.html', '1535531522');
INSERT INTO `ey_admin_log` VALUES ('295', '1', '编辑栏目：新闻资讯', '127.0.0.1', '/index.php/admin/Arctype/edit.html', '1535532112');
INSERT INTO `ey_admin_log` VALUES ('296', '1', '编辑文章：以网络游戏为代表的网络文艺治理', '127.0.0.1', '/index.php/admin/Article/edit.html', '1535532129');
INSERT INTO `ey_admin_log` VALUES ('297', '1', '编辑文章：以网络游戏为代表的网络文艺治理，已经构成我们无法回避的时代性挑战', '127.0.0.1', '/index.php/admin/Article/edit.html', '1535532139');
INSERT INTO `ey_admin_log` VALUES ('298', '1', '删除留言-id：5', '127.0.0.1', '/index.php/admin/Guestbook/del.html', '1535532521');
INSERT INTO `ey_admin_log` VALUES ('299', '1', '后台登录', '127.0.0.1', '/index.php/admin/Admin/login.html', '1540541729');
INSERT INTO `ey_admin_log` VALUES ('300', '1', '后台登录', '127.0.0.1', '/login.php', '1547781865');

-- -----------------------------
-- Table structure for `ey_archives`
-- -----------------------------
DROP TABLE IF EXISTS `ey_archives`;
CREATE TABLE `ey_archives` (
  `aid` int(10) NOT NULL AUTO_INCREMENT,
  `typeid` int(10) NOT NULL DEFAULT '0' COMMENT '当前栏目',
  `channel` int(10) NOT NULL DEFAULT '0' COMMENT '模型ID',
  `is_b` tinyint(1) DEFAULT '0' COMMENT '加粗',
  `title` varchar(200) DEFAULT '' COMMENT '标题',
  `litpic` varchar(250) DEFAULT '' COMMENT '封面图',
  `is_head` tinyint(1) DEFAULT '0' COMMENT '头条（0=否，1=是）',
  `is_special` tinyint(1) DEFAULT '0' COMMENT '特荐（0=否，1=是）',
  `is_top` tinyint(1) DEFAULT '0' COMMENT '置顶（0=否，1=是）',
  `is_recom` tinyint(1) DEFAULT '0' COMMENT '推荐（0=否，1=是）',
  `is_jump` tinyint(1) DEFAULT '0' COMMENT '跳转链接（0=否，1=是）',
  `author` varchar(200) DEFAULT '' COMMENT '编辑者',
  `click` int(10) DEFAULT '0' COMMENT '浏览量',
  `arcrank` tinyint(1) DEFAULT '0' COMMENT '阅读权限：0=开放浏览，-1=待审核稿件',
  `jumplinks` varchar(200) DEFAULT '' COMMENT '外链跳转',
  `ismake` tinyint(1) DEFAULT '0' COMMENT '是否静态页面（0=动态，1=静态）',
  `seo_title` varchar(200) DEFAULT '' COMMENT 'SEO标题',
  `seo_keywords` varchar(200) DEFAULT '' COMMENT 'SEO关键词',
  `seo_description` text COMMENT 'SEO描述',
  `status` tinyint(1) DEFAULT '1' COMMENT '状态(0=屏蔽，1=正常)',
  `sort_order` int(10) DEFAULT '0' COMMENT '排序号',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `admin_id` int(10) DEFAULT '0' COMMENT '管理员ID',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`aid`),
  KEY `aid` (`typeid`,`channel`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=57 DEFAULT CHARSET=utf8 COMMENT='资讯表';

-- -----------------------------
-- Records of `ey_archives`
-- -----------------------------
INSERT INTO `ey_archives` VALUES ('1', '1', '6', '0', '关于我们', '', '0', '0', '0', '0', '0', '', '0', '0', '', '0', '', '', '', '1', '100', 'cn', '0', '1533541630', '1534403477');
INSERT INTO `ey_archives` VALUES ('2', '8', '6', '0', '联系我们', '', '0', '0', '0', '0', '0', '', '0', '0', '', '0', '', '', '', '1', '100', 'cn', '0', '1533542101', '1534219608');
INSERT INTO `ey_archives` VALUES ('11', '3', '1', '0', '公众聚集场所消防安全检查', '/public/upload/article/2018/08/15/6f700335422d8666e5bd486fdb8839e1.jpg', '0', '0', '0', '0', '0', '', '256', '0', '', '0', '', '', '公众聚集场所的消防安全，历来是消防监督管理的重点。新消防法继承和发展了原消防法关于公安机关消防机构对公众聚集的场所在使用、营业前实施消防安全检查的规定，取消了原消防法中关于对公众聚集场所未经消防安全检查或者经检查不符合消防安全要求擅自投入使用、营业的行政处罚中，限期改正的前置条件，对存在上述违法行为的，规定了直接给予责令停止施工、停止使用、停产停业和罚款的行政处罚。&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;举办大型群众性活动消防安全有要求&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;为减少行政许可事项，新消防法将大型群众性活动的消防安全纳入《大型群众性活动安全管理条例》规定的治安行政许可审查内容，避免了多头审批，方便社会，方便群众，同时明确了消防安全要求，规定举办大型群众性活动，承办人应当依法向公安机关申请安全许可，制定灭火和应急疏散预案并组织演练，明确消防安全责任分工，确定消防安全管理人员，保持消防设施和消防器材配置齐全、完好有效，保证疏散通道、安全出口、疏散指示标志、应急照明和消防车通道符合消防技术标准', '1', '100', 'cn', '0', '1533546369', '1534497406');
INSERT INTO `ey_archives` VALUES ('12', '3', '1', '0', '以网络游戏为代表的网络文艺治理', '/public/upload/article/2018/08/17/6ae0370cfd6d509110db63a11ea977c9.jpg', '0', '0', '0', '0', '0', '', '136', '0', '', '0', '', '', '　开发功能性游戏，对在全球网络游戏市场份额占比近10%的腾讯来说，显然是一个重要节点，对全行业也有积极影响。但是，对我国这一全球最大的网络游戏市场而言，对不断加大走出去力度的众多中国互联网企业而言，这仅仅是漫长征程的第一步。开发出更多可以服务具体应用目的和应用场景的，具有正面主流价值的功能游戏，应当成为全行业的共识。因为，这绝不仅仅关乎企业自身的商业利益，对于改变当前社会上对网络游戏的一些片面认识，促进网络游戏全行业的转型升级，更是有着重要意义。', '1', '100', 'cn', '0', '1533546479', '1535532129');
INSERT INTO `ey_archives` VALUES ('13', '3', '1', '0', '未来几年，功能游戏将有两位数的年均复合增长率', '/public/upload/article/2018/08/17/e3953697b81d7a9dc6b4ecad50a6e3c2.jpg', '0', '0', '0', '0', '0', '', '266', '0', '', '0', '', '', '市场规模将迅速增长到300亿元到500亿元，其广阔的发展前景和深远影响更将远远超过其商业价值。在可预见的将来，功能游戏还将进一步主流化，成为主流社会日常性的互联网应用工具。过去几年，我国出现了《韩熙载夜宴图》《每日故宫》《紫禁城祥瑞》《皇帝的一天》以及《榫卯》《折扇》等和传统文化深入融合的功能游戏精品佳作，但就我国网络游戏行业的实际发展情况而言，在功能游戏领域，我们只是刚刚起步。', '1', '100', 'cn', '0', '1533547487', '1534497391');
INSERT INTO `ey_archives` VALUES ('14', '3', '1', '0', '近日，腾讯公司正式对外宣布', '/public/upload/article/2018/08/17/670ffe248573ab60575b12308d6ad692.jpg', '0', '0', '0', '0', '0', '', '127', '0', '', '0', '', '', '自世纪之交以来，网络游戏及其所依托的网络文艺，作为移动互联网时代新兴媒介的文化娱乐形态，在全世界方兴未艾。2017年，我国网络游戏用户整体规模已有5亿左右，在全部网民中的占比接近7成。我国网络游戏行业整体营收达2189.6亿元，相当于全球电影票房的总和。', '1', '100', 'cn', '0', '1533547565', '1534497384');
INSERT INTO `ey_archives` VALUES ('29', '21', '1', '0', '游戏展示一', '/public/upload/article/2018/08/18/b12c929590bdc85e9bc612b674445d73.jpg', '0', '0', '0', '0', '0', '', '126', '0', '', '0', '', '', '　　需要指出的是，一般网民的网络游戏概念基本上停留在消遣娱乐的刻板化印象上。但实际上，网络游戏的内在构成已经有了相当程度的发展，有着丰富的内涵。例如，功能游戏是网络游戏一个极为重要的组成部分，是以解决社会和行业问题为主要目的的游戏类型，但其在主流视野中却鲜为人知。　　1994年，基于海湾战争的经验，美国海军陆战队成立了世界上第一个功能游戏军事训练机构，将功能游戏作为军队模拟训练的辅助手段。经过互联网领域在世纪之交的爆炸式发展，2006年之后，功能游戏逐渐拓展到了民用领域，在教育、医疗、交通、应急管理、环境保护、企业管理、文化传承等方面发挥了重要作用，为很多国家的政府部门、社会机构解决社会公共生活的各类难题，提供了不可替代的治理演练和经验。', '1', '100', 'cn', '0', '1534155569', '1535531282');
INSERT INTO `ey_archives` VALUES ('54', '21', '1', '0', '游戏展示八', '/public/upload/article/2018/08/18/8f97c1d89026d09b9ac5b23c9b05a29d.jpg', '0', '0', '0', '0', '0', '', '274', '0', '', '0', '', '', '　开发功能性游戏，对在全球网络游戏市场份额占比近10%的腾讯来说，显然是一个重要节点，对全行业也有积极影响。但是，对我国这一全球最大的网络游戏市场而言，对不断加大走出去力度的众多中国互联网企业而言，这仅仅是漫长征程的第一步。开发出更多可以服务具体应用目的和应用场景的，具有正面主流价值的功能游戏，应当成为全行业的共识。因为，这绝不仅仅关乎企业自身的商业利益，对于改变当前社会上对网络游戏的一些片面认识，促进网络游戏全行业的转型升级，更是有着重要意义。', '1', '100', 'cn', '0', '1534491184', '1535531282');
INSERT INTO `ey_archives` VALUES ('53', '21', '1', '0', '游戏展示七', '/public/upload/article/2018/08/18/ab1e7a9cfd0a681e5a15f4d54a1e1094.jpg', '0', '0', '0', '0', '0', '', '202', '0', '', '0', '', '', '以网络游戏为代表的网络文艺治理，已经构成我们无法回避的时代性挑战。动员政府部门、专家学者、行业企业、游戏用户和社会媒体等多方力量的广泛参与，开展对包括功能游戏在内的不同类型网络游戏的评论、批评，科学认识和评价网络游戏的复合价值，激浊扬清，发掘游戏文化中的优秀内容，加强价值引导和舆论监督，规范网络游戏经营行为，建立和完善立足于我国国情的网络游戏作品评价体系，进而最终完成我国网络游戏全行业的转型升级，促进我国以网络游戏为代表的网络文艺的健康发展，其重大意义就不仅仅局限于网络游戏行业本身，其对于我国网络文艺乃至整体性文化产业格局的转型升级，都将产生示范和引领作用。', '1', '100', 'cn', '0', '1534491152', '1535531282');
INSERT INTO `ey_archives` VALUES ('52', '21', '1', '0', '游戏展示六', '/public/upload/article/2018/08/18/54148d16ead44dba35098eb70ead1e3a.jpg', '0', '0', '0', '0', '0', '', '120', '0', '', '0', '', '', '未来几年，功能游戏将有两位数的年均复合增长率，市场规模将迅速增长到300亿元到500亿元，其广阔的发展前景和深远影响更将远远超过其商业价值。在可预见的将来，功能游戏还将进一步主流化，成为主流社会日常性的互联网应用工具。过去几年，我国出现了《韩熙载夜宴图》《每日故宫》《紫禁城祥瑞》《皇帝的一天》以及《榫卯》《折扇》等和传统文化深入融合的功能游戏精品佳作，但就我国网络游戏行业的实际发展情况而言，在功能游戏领域，我们只是刚刚起步。', '1', '100', 'cn', '0', '1534491102', '1535531282');
INSERT INTO `ey_archives` VALUES ('34', '14', '1', '0', '在全部网民中的占比接近7成。我国网络游戏行业整体营收达2189.6亿元', '', '0', '0', '0', '0', '0', '', '250', '0', '', '0', '', '', '　自世纪之交以来，网络游戏及其所依托的网络文艺，作为移动互联网时代新兴媒介的文化娱乐形态，在全世界方兴未艾。2017年，我国网络游戏用户整体规模已有5亿左右，在全部网民中的占比接近7成。我国网络游戏行业整体营收达2189.6亿元，相当于全球电影票房的总和。　　需要指出的是，一般网民的网络游戏概念基本上停留在消遣娱乐的刻板化印象上。但实际上，网络游戏的内在构成已经有了相当程度的发展，有着丰富的内涵。例如，功能游戏是网络游戏一个极为重要的组成部分，是以解决社会和行业问题为主要目的的游戏类型，但其在主流视野中却鲜为人知', '1', '100', 'cn', '0', '1534242157', '1534493286');
INSERT INTO `ey_archives` VALUES ('50', '2', '1', '0', '热门游戏4', '/public/upload/article/2018/08/18/1ff50a196ecc3b7c728b04618cf3ade7.jpg', '0', '0', '0', '0', '0', '', '300', '0', '', '0', '', '', '', '1', '100', 'cn', '0', '1534490623', '1534584661');
INSERT INTO `ey_archives` VALUES ('51', '21', '1', '0', '游戏展示五', '/public/upload/article/2018/08/18/72e8e76a047c2c8888a47a4ef0f82f3c.jpg', '0', '0', '0', '0', '0', '', '296', '0', '', '0', '', '', '　自世纪之交以来，网络游戏及其所依托的网络文艺，作为移动互联网时代新兴媒介的文化娱乐形态，在全世界方兴未艾。2017年，我国网络游戏用户整体规模已有5亿左右，在全部网民中的占比接近7成。我国网络游戏行业整体营收达2189.6亿元，相当于全球电影票房的总和。　　需要指出的是，一般网民的网络游戏概念基本上停留在消遣娱乐的刻板化印象上。但实际上，网络游戏的内在构成已经有了相当程度的发展，有着丰富的内涵。例如，功能游戏是网络游戏一个极为重要的组成部分，是以解决社会和行业问题为主要目的的游戏类型，但其在主流视野中却鲜为人知。　　1994年，基于海湾战争的经验，美国海军陆战队成立了世界上第一个功能游戏军事训练机构，将功能游戏作为军队模拟训练的辅助手段。经过互联网领域在世纪之交的爆炸式发展，2006年之后，功能游戏逐渐拓展到了民用领域，在教育、医疗、交通、应急管理、环境保护、企业管理、文化传承等方面发挥了重要作用，为很多国家的政府部门、社会机构解决社会公共生活的各类难题，提供了不可替代的治理演练和经验。', '1', '100', 'cn', '0', '1534491071', '1535531282');
INSERT INTO `ey_archives` VALUES ('47', '2', '1', '0', '热门游戏1', '/public/upload/article/2018/08/18/5c16821429cc96e575013b5da997d099.jpg', '0', '0', '0', '0', '0', '', '231', '0', '', '0', '', '', '', '1', '100', 'cn', '0', '1534473672', '1534584755');
INSERT INTO `ey_archives` VALUES ('48', '2', '1', '0', '热门游戏2', '/public/upload/article/2018/08/18/8bc6591efdda3e35e635001fce46adf2.jpg', '0', '0', '0', '0', '0', '', '256', '0', '', '0', '', '', '', '1', '100', 'cn', '0', '1534473824', '1534584735');
INSERT INTO `ey_archives` VALUES ('49', '2', '1', '0', '热门游戏3', '/public/upload/article/2018/08/18/457bb093c7183aa48abf3c43dcb98577.jpg', '0', '0', '0', '0', '0', '', '182', '0', '', '0', '', '', '', '1', '100', 'cn', '0', '1534490511', '1534584703');
INSERT INTO `ey_archives` VALUES ('28', '21', '1', '0', '游戏展示二', '/public/upload/article/2018/08/18/9eb7667230e11f3b3983ee404d4d9fd4.jpg', '0', '0', '0', '0', '0', '', '123', '0', '', '0', '', '', '未来几年，功能游戏将有两位数的年均复合增长率，市场规模将迅速增长到300亿元到500亿元，其广阔的发展前景和深远影响更将远远超过其商业价值。在可预见的将来，功能游戏还将进一步主流化，成为主流社会日常性的互联网应用工具。过去几年，我国出现了《韩熙载夜宴图》《每日故宫》《紫禁城祥瑞》《皇帝的一天》以及《榫卯》《折扇》等和传统文化深入融合的功能游戏精品佳作，但就我国网络游戏行业的实际发展情况而言，在功能游戏领域，我们只是刚刚起步。', '1', '100', 'cn', '0', '1534155527', '1535531282');
INSERT INTO `ey_archives` VALUES ('22', '21', '1', '0', '游戏展示四', '/public/upload/article/2018/08/18/2162e3e3b31fca0082135ffd6e74b3bc.jpg', '0', '0', '0', '0', '0', '', '153', '0', '', '0', '', '', '开发功能性游戏，对在全球网络游戏市场份额占比近10%的腾讯来说，显然是一个重要节点，对全行业也有积极影响。但是，对我国这一全球最大的网络游戏市场而言，对不断加大走出去力度的众多中国互联网企业而言，这仅仅是漫长征程的第一步。开发出更多可以服务具体应用目的和应用场景的，具有正面主流价值的功能游戏，应当成为全行业的共识。因为，这绝不仅仅关乎企业自身的商业利益，对于改变当前社会上对网络游戏的一些片面认识，促进网络游戏全行业的转型升级，更是有着重要意义。', '1', '100', 'cn', '0', '1533627969', '1535531282');
INSERT INTO `ey_archives` VALUES ('23', '21', '1', '0', '游戏展示三', '/public/upload/article/2018/08/18/28376faed92df519535203016f4b5490.jpg', '0', '0', '0', '0', '0', '', '251', '0', '', '0', '', '', '1994年，基于海湾战争的经验，美国海军陆战队成立了世界上第一个功能游戏军事训练机构，将功能游戏作为军队模拟训练的辅助手段。经过互联网领域在世纪之交的爆炸式发展，2006年之后，功能游戏逐渐拓展到了民用领域，在教育、医疗、交通、应急管理、环境保护、企业管理、文化传承等方面发挥了重要作用，为很多国家的政府部门、社会机构解决社会公共生活的各类难题，提供了不可替代的治理演练和经验。', '1', '100', 'cn', '0', '1533628002', '1535531282');
INSERT INTO `ey_archives` VALUES ('27', '13', '6', '0', '人才招聘', '', '0', '0', '0', '0', '0', '', '0', '0', '', '0', '', '', '', '1', '100', 'cn', '0', '1534151326', '1534318765');
INSERT INTO `ey_archives` VALUES ('44', '14', '1', '0', '以网络游戏为代表的网络文艺治理，已经构成我们无法回避的时代性挑战', '', '0', '0', '0', '0', '0', '', '135', '0', '', '0', '', '', '动员政府部门、专家学者、行业企业、游戏用户和社会媒体等多方力量的广泛参与，开展对包括功能游戏在内的不同类型网络游戏的评论、批评，科学认识和评价网络游戏的复合价值，激浊扬清，发掘游戏文化中的优秀内容，加强价值引导和舆论监督，规范网络游戏经营行为，建立和完善立足于我国国情的网络游戏作品评价体系，进而最终完成我国网络游戏全行业的转型升级，促进我国以网络游戏为代表的网络文艺的健康发展，其重大意义就不仅仅局限于网络游戏行业本身，其对于我国网络文艺乃至整体性文化产业格局的转型升级，都将产生示范和引领作用。', '1', '100', 'cn', '0', '1534404634', '1535532139');
INSERT INTO `ey_archives` VALUES ('45', '14', '1', '0', '开发功能性游戏，对在全球网络游戏市场份额占比近10%的腾讯来说', '/public/upload/article/2018/08/29/8d43045f414c001f6763e16319cb080c.jpg', '0', '0', '0', '0', '0', '', '151', '0', '', '0', '', '', '　开发功能性游戏，对在全球网络游戏市场份额占比近10%的腾讯来说，显然是一个重要节点，对全行业也有积极影响。但是，对我国这一全球最大的网络游戏市场而言，对不断加大走出去力度的众多中国互联网企业而言，这仅仅是漫长征程的第一步。开发出更多可以服务具体应用目的和应用场景的，具有正面主流价值的功能游戏，应当成为全行业的共识。因为，这绝不仅仅关乎企业自身的商业利益，对于改变当前社会上对网络游戏的一些片面认识，促进网络游戏全行业的转型升级，更是有着重要意义。', '1', '100', 'cn', '0', '1534404653', '1535503482');
INSERT INTO `ey_archives` VALUES ('46', '14', '1', '0', '功能游戏将有两位数的年均复合增长率', '/public/upload/article/2018/08/29/26c0a059367966316bca704b0913ec5d.jpg', '0', '0', '0', '0', '0', '', '122', '0', '', '0', '', '', '　未来几年，功能游戏将有两位数的年均复合增长率，市场规模将迅速增长到300亿元到500亿元，其广阔的发展前景和深远影响更将远远超过其商业价值。在可预见的将来，功能游戏还将进一步主流化，成为主流社会日常性的互联网应用工具。过去几年，我国出现了《韩熙载夜宴图》《每日故宫》《紫禁城祥瑞》《皇帝的一天》以及《榫卯》《折扇》等和传统文化深入融合的功能游戏精品佳作，但就我国网络游戏行业的实际发展情况而言，在功能游戏领域，我们只是刚刚起步。', '1', '100', 'cn', '0', '1534404698', '1535503467');

-- -----------------------------
-- Table structure for `ey_arcrank`
-- -----------------------------
DROP TABLE IF EXISTS `ey_arcrank`;
CREATE TABLE `ey_arcrank` (
  `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT COMMENT '权限ID',
  `rank` smallint(6) DEFAULT '0' COMMENT '权限值',
  `name` char(20) DEFAULT '' COMMENT '会员名称',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='文档阅读权限表';

-- -----------------------------
-- Records of `ey_arcrank`
-- -----------------------------
INSERT INTO `ey_arcrank` VALUES ('1', '0', '开放浏览', 'cn', '0', '0');
INSERT INTO `ey_arcrank` VALUES ('2', '-1', '待审核稿件', 'cn', '0', '0');

-- -----------------------------
-- Table structure for `ey_arctype`
-- -----------------------------
DROP TABLE IF EXISTS `ey_arctype`;
CREATE TABLE `ey_arctype` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `channeltype` int(10) DEFAULT '0' COMMENT '栏目顶级模型ID',
  `current_channel` int(10) DEFAULT '0' COMMENT '栏目当前模型ID',
  `parent_id` int(10) DEFAULT '0' COMMENT '栏目上级ID',
  `typename` varchar(200) DEFAULT '' COMMENT '栏目名称',
  `dirname` varchar(200) DEFAULT '' COMMENT '目录英文名',
  `dirpath` varchar(200) DEFAULT '' COMMENT '目录存放HTML路径',
  `englist_name` varchar(200) DEFAULT '' COMMENT '栏目英文名',
  `grade` tinyint(1) DEFAULT '0' COMMENT '栏目等级',
  `typelink` varchar(200) DEFAULT '' COMMENT '栏目链接',
  `litpic` varchar(250) DEFAULT '' COMMENT '栏目图片',
  `templist` varchar(200) DEFAULT '' COMMENT '列表模板文件名',
  `tempview` varchar(200) DEFAULT '' COMMENT '文档模板文件名',
  `seo_title` varchar(200) DEFAULT '' COMMENT 'SEO标题',
  `seo_keywords` varchar(200) DEFAULT '' COMMENT 'seo关键字',
  `seo_description` text COMMENT 'seo描述',
  `sort_order` int(10) DEFAULT '0' COMMENT '排序号',
  `is_hidden` tinyint(1) DEFAULT '0' COMMENT '是否隐藏栏目：0=显示，1=隐藏',
  `is_part` tinyint(1) DEFAULT '0' COMMENT '栏目属性：0=内容栏目，1=外部链接',
  `admin_id` int(10) DEFAULT '0' COMMENT '管理员ID',
  `is_del` tinyint(1) DEFAULT '0' COMMENT '伪删除，1=是，0=否',
  `status` tinyint(1) DEFAULT '1' COMMENT '启用 (1=正常，0=屏蔽)',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  UNIQUE KEY `dirname` (`dirname`,`lang`) USING BTREE,
  KEY `parent_id` (`channeltype`,`parent_id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=24 DEFAULT CHARSET=utf8;

-- -----------------------------
-- Records of `ey_arctype`
-- -----------------------------
INSERT INTO `ey_arctype` VALUES ('1', '6', '6', '0', '关于我们', 'guanyuwomen', '/html', 'ABOUT US', '0', '', '/public/upload/arctype/2018/08/15/e584e33d3b5edb37535cc7d9e4416085.jpg', 'lists_single.htm', '', '', '', '', '1', '0', '0', '0', '0', '1', 'cn', '1533541630', '1534403477');
INSERT INTO `ey_arctype` VALUES ('2', '1', '1', '0', '热门游戏', 'chanpzhanshi', '/html/chanpinzhanshi', 'TOP GAMES', '0', '', '', 'lists_article_img.htm', 'view_article.htm', '', '', '', '2', '0', '0', '0', '0', '1', 'cn', '1533541671', '1535531480');
INSERT INTO `ey_arctype` VALUES ('3', '1', '1', '0', '新闻资讯', 'xinwenzixun', '/html/NEWS_CENTER', 'NEWS', '0', '', '', 'lists_article.htm', 'view_article.htm', '', '', '', '3', '0', '0', '0', '0', '1', 'cn', '1533541713', '1535532112');
INSERT INTO `ey_arctype` VALUES ('14', '1', '1', '0', '功能介绍', 'gongnenjieshao', '/html/jiuyezhinan', 'SAFETY KNOWLEDGE', '0', '', '', 'lists_article.htm', 'view_article.htm', '', '', '', '7', '0', '0', '0', '0', '1', 'cn', '1534151499', '1535529367');
INSERT INTO `ey_arctype` VALUES ('6', '1', '1', '0', '游戏展示', 'youxizhanshi', '/html/jidizhanshi', 'THE ENGINEERING CASE', '0', '', '', 'lists_article_product.htm', 'view_article.htm', '', '', '', '4', '0', '0', '0', '0', '1', 'cn', '1533541928', '1534490901');
INSERT INTO `ey_arctype` VALUES ('7', '8', '8', '0', '在线留言', 'zaixianliuyan', '/html/zaixianliuyan', 'Message', '0', '', '', 'lists_guestbook.htm', '', '', '', '', '5', '0', '0', '0', '0', '1', 'cn', '1533542038', '1533542038');
INSERT INTO `ey_arctype` VALUES ('8', '6', '6', '0', '联系我们', 'lianxiwomen', '/html/Contact_us', 'CONTACT US', '0', '', '', 'lists_single.htm', '', '', '', '', '8', '0', '0', '0', '0', '1', 'cn', '1533542101', '1535529356');
INSERT INTO `ey_arctype` VALUES ('13', '6', '6', '0', '人才招聘', 'rencaizhaopin', '/html/zhaoshengjianzhang', 'RECRUITMENT', '0', '', '', 'lists_single.htm', '', '', '', '', '6', '0', '0', '0', '0', '1', 'cn', '1534151326', '1534318765');
INSERT INTO `ey_arctype` VALUES ('23', '1', '1', '6', '互动游戏', 'hudongyouxi', '/html/jidizhanshi/hudongyouxi', '', '1', '', '', 'lists_article_product.htm', 'view_article.htm', '', '', '', '100', '0', '0', '0', '0', '1', 'cn', '1534499052', '1535531318');
INSERT INTO `ey_arctype` VALUES ('21', '1', '1', '6', '竞技游戏', 'jingjiyouxi', '/html/jidizhanshi/jingjiyouxi', '', '1', '', '', 'lists_article_product.htm', 'view_article.htm', '', '', '', '100', '0', '0', '0', '0', '1', 'cn', '1534499010', '1535531304');
INSERT INTO `ey_arctype` VALUES ('22', '1', '1', '6', '场景游戏', 'changjingyouxi', '/html/jidizhanshi/changjingyouxi', '', '1', '', '', 'lists_article_product.htm', 'view_article.htm', '', '', '', '100', '0', '0', '0', '0', '1', 'cn', '1534499036', '1535531522');

-- -----------------------------
-- Table structure for `ey_article_content`
-- -----------------------------
DROP TABLE IF EXISTS `ey_article_content`;
CREATE TABLE `ey_article_content` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `aid` int(10) DEFAULT '0' COMMENT '文档ID',
  `content` longtext COMMENT '内容详情',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `news_id` (`aid`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=54 DEFAULT CHARSET=utf8 COMMENT='资讯内容表_存储正常内容';

-- -----------------------------
-- Records of `ey_article_content`
-- -----------------------------
INSERT INTO `ey_article_content` VALUES ('9', '11', '&lt;p&gt;公众聚集场所的消防安全，历来是消防监督管理的重点。新消防法继承和发展了原消防法关于公安机关消防机构对公众聚集的场所在使用、营业前实施消防安全检查的规定，取消了原消防法中关于对公众聚集场所未经消防安全检查或者经检查不符合消防安全要求擅自投入使用、营业的行政处罚中，限期改正的前置条件，对存在上述违法行为的，规定了直接给予责令停止施工、停止使用、停产停业和罚款的行政处罚。&lt;/p&gt;&lt;p&gt;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;举办大型群众性活动消防安全有要求&lt;/p&gt;&lt;p&gt;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;为减少行政许可事项，新消防法将大型群众性活动的消防安全纳入《大型群众性活动安全管理条例》规定的治安行政许可审查内容，避免了多头审批，方便社会，方便群众，同时明确了消防安全要求，规定举办大型群众性活动，承办人应当依法向公安机关申请安全许可，制定灭火和应急疏散预案并组织演练，明确消防安全责任分工，确定消防安全管理人员，保持消防设施和消防器材配置齐全、完好有效，保证疏散通道、安全出口、疏散指示标志、应急照明和消防车通道符合消防技术标准和管理规定。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;', '1533546369', '1534497406');
INSERT INTO `ey_article_content` VALUES ('31', '34', '&lt;p&gt;　自世纪之交以来，网络游戏及其所依托的网络文艺，作为移动互联网时代新兴媒介的文化娱乐形态，在全世界方兴未艾。2017年，我国网络游戏用户整体规模已有5亿左右，在全部网民中的占比接近7成。我国网络游戏行业整体营收达2189.6亿元，相当于全球电影票房的总和。&lt;/p&gt;&lt;p&gt;　　需要指出的是，一般网民的网络游戏概念基本上停留在消遣娱乐的刻板化印象上。但实际上，网络游戏的内在构成已经有了相当程度的发展，有着丰富的内涵。例如，功能游戏是网络游戏一个极为重要的组成部分，是以解决社会和行业问题为主要目的的游戏类型，但其在主流视野中却鲜为人知&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;', '1534242157', '1534493286');
INSERT INTO `ey_article_content` VALUES ('10', '12', '&lt;p&gt;　开发功能性游戏，对在全球网络游戏市场份额占比近10%的腾讯来说，显然是一个重要节点，对全行业也有积极影响。但是，对我国这一全球最大的网络游戏市场而言，对不断加大走出去力度的众多中国互联网企业而言，这仅仅是漫长征程的第一步。开发出更多可以服务具体应用目的和应用场景的，具有正面主流价值的功能游戏，应当成为全行业的共识。因为，这绝不仅仅关乎企业自身的商业利益，对于改变当前社会上对网络游戏的一些片面认识，促进网络游戏全行业的转型升级，更是有着重要意义。&lt;/p&gt;', '1535532129', '1535532129');
INSERT INTO `ey_article_content` VALUES ('11', '13', '&lt;p&gt;市场规模将迅速增长到300亿元到500亿元，其广阔的发展前景和深远影响更将远远超过其商业价值。在可预见的将来，功能游戏还将进一步主流化，成为主流社会日常性的互联网应用工具。过去几年，我国出现了《韩熙载夜宴图》《每日故宫》《紫禁城祥瑞》《皇帝的一天》以及《榫卯》《折扇》等和传统文化深入融合的功能游戏精品佳作，但就我国网络游戏行业的实际发展情况而言，在功能游戏领域，我们只是刚刚起步。&lt;/p&gt;', '1533547487', '1534497391');
INSERT INTO `ey_article_content` VALUES ('12', '14', '&lt;p&gt;&lt;span style=&quot;color: rgb(51, 51, 51); font-family: arial; text-align: justify; background-color: rgb(255, 255, 255);&quot;&gt;自世纪之交以来，网络游戏及其所依托的网络文艺，作为移动互联网时代新兴媒介的文化娱乐形态，在全世界方兴未艾。2017年，我国网络游戏用户整体规模已有5亿左右，在全部网民中的占比接近7成。我国网络游戏行业整体营收达2189.6亿元，相当于全球电影票房的总和。&lt;/span&gt;&lt;/p&gt;', '1533547565', '1534497384');
INSERT INTO `ey_article_content` VALUES ('26', '29', '&lt;p style=&quot;text-align: center;&quot;&gt;&lt;img src=&quot;/public/upload/article/2018/08/18/92ad6537dda6a06ed4347e57490b0910.jpg&quot; title=&quot;92ad6537dda6a06ed4347e57490b0910.jpg&quot; alt=&quot;92ad6537dda6a06ed4347e57490b0910.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;&lt;p style=&quot;text-align: center;&quot;&gt;　　需要指出的是，一般网民的网络游戏概念基本上停留在消遣娱乐的刻板化印象上。但实际上，网络游戏的内在构成已经有了相当程度的发展，有着丰富的内涵。例如，功能游戏是网络游戏一个极为重要的组成部分，是以解决社会和行业问题为主要目的的游戏类型，但其在主流视野中却鲜为人知。&lt;/p&gt;&lt;p style=&quot;text-align: center;&quot;&gt;　　1994年，基于海湾战争的经验，美国海军陆战队成立了世界上第一个功能游戏军事训练机构，将功能游戏作为军队模拟训练的辅助手段。经过互联网领域在世纪之交的爆炸式发展，2006年之后，功能游戏逐渐拓展到了民用领域，在教育、医疗、交通、应急管理、环境保护、企业管理、文化传承等方面发挥了重要作用，为很多国家的政府部门、社会机构解决社会公共生活的各类难题，提供了不可替代的治理演练和经验。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;', '1534155569', '1534584988');
INSERT INTO `ey_article_content` VALUES ('20', '22', '&lt;p style=&quot;text-align: center;&quot;&gt;&lt;img src=&quot;/public/upload/article/2018/08/18/f92a4618e6c60d69bf67fb77803c4631.jpg&quot; title=&quot;f92a4618e6c60d69bf67fb77803c4631.jpg&quot; alt=&quot;f92a4618e6c60d69bf67fb77803c4631.jpg&quot;/&gt;&lt;/p&gt;&lt;p style=&quot;text-align: center;&quot;&gt;开发功能性游戏，对在全球网络游戏市场份额占比近10%的腾讯来说，显然是一个重要节点，对全行业也有积极影响。但是，对我国这一全球最大的网络游戏市场而言，对不断加大走出去力度的众多中国互联网企业而言，这仅仅是漫长征程的第一步。开发出更多可以服务具体应用目的和应用场景的，具有正面主流价值的功能游戏，应当成为全行业的共识。因为，这绝不仅仅关乎企业自身的商业利益，对于改变当前社会上对网络游戏的一些片面认识，促进网络游戏全行业的转型升级，更是有着重要意义。&lt;/p&gt;', '1533627969', '1534585056');
INSERT INTO `ey_article_content` VALUES ('48', '51', '&lt;p style=&quot;text-align: center;&quot;&gt;&lt;img src=&quot;/public/upload/article/2018/08/18/103a6c19992526fe37fc7e9270c319c7.jpg&quot; title=&quot;103a6c19992526fe37fc7e9270c319c7.jpg&quot; alt=&quot;103a6c19992526fe37fc7e9270c319c7.jpg&quot;/&gt;&lt;/p&gt;&lt;p style=&quot;text-align: center;&quot;&gt;　自世纪之交以来，网络游戏及其所依托的网络文艺，作为移动互联网时代新兴媒介的文化娱乐形态，在全世界方兴未艾。2017年，我国网络游戏用户整体规模已有5亿左右，在全部网民中的占比接近7成。我国网络游戏行业整体营收达2189.6亿元，相当于全球电影票房的总和。&lt;/p&gt;&lt;p style=&quot;text-align: center;&quot;&gt;　　需要指出的是，一般网民的网络游戏概念基本上停留在消遣娱乐的刻板化印象上。但实际上，网络游戏的内在构成已经有了相当程度的发展，有着丰富的内涵。例如，功能游戏是网络游戏一个极为重要的组成部分，是以解决社会和行业问题为主要目的的游戏类型，但其在主流视野中却鲜为人知。&lt;/p&gt;&lt;p style=&quot;text-align: center;&quot;&gt;　　1994年，基于海湾战争的经验，美国海军陆战队成立了世界上第一个功能游戏军事训练机构，将功能游戏作为军队模拟训练的辅助手段。经过互联网领域在世纪之交的爆炸式发展，2006年之后，功能游戏逐渐拓展到了民用领域，在教育、医疗、交通、应急管理、环境保护、企业管理、文化传承等方面发挥了重要作用，为很多国家的政府部门、社会机构解决社会公共生活的各类难题，提供了不可替代的治理演练和经验。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;', '1534491071', '1534584966');
INSERT INTO `ey_article_content` VALUES ('49', '52', '&lt;p style=&quot;text-align: center;&quot;&gt;&lt;img src=&quot;/public/upload/article/2018/08/18/2180bd10694c65709d5b846720c2b816.jpg&quot; title=&quot;2180bd10694c65709d5b846720c2b816.jpg&quot; alt=&quot;2180bd10694c65709d5b846720c2b816.jpg&quot;/&gt;&lt;/p&gt;&lt;p style=&quot;text-align: center;&quot;&gt;未来几年，功能游戏将有两位数的年均复合增长率，市场规模将迅速增长到300亿元到500亿元，其广阔的发展前景和深远影响更将远远超过其商业价值。在可预见的将来，功能游戏还将进一步主流化，成为主流社会日常性的互联网应用工具。过去几年，我国出现了《韩熙载夜宴图》《每日故宫》《紫禁城祥瑞》《皇帝的一天》以及《榫卯》《折扇》等和传统文化深入融合的功能游戏精品佳作，但就我国网络游戏行业的实际发展情况而言，在功能游戏领域，我们只是刚刚起步。&lt;/p&gt;', '1534491102', '1534584940');
INSERT INTO `ey_article_content` VALUES ('50', '53', '&lt;p style=&quot;text-align: center;&quot;&gt;&lt;img src=&quot;/public/upload/article/2018/08/18/f440af2ad3998065606e0caaaef9d311.jpg&quot; title=&quot;f440af2ad3998065606e0caaaef9d311.jpg&quot; alt=&quot;f440af2ad3998065606e0caaaef9d311.jpg&quot;/&gt;&lt;/p&gt;&lt;p style=&quot;text-align: center;&quot;&gt;以网络游戏为代表的网络文艺治理，已经构成我们无法回避的时代性挑战。动员政府部门、专家学者、行业企业、游戏用户和社会媒体等多方力量的广泛参与，开展对包括功能游戏在内的不同类型网络游戏的评论、批评，科学认识和评价网络游戏的复合价值，激浊扬清，发掘游戏文化中的优秀内容，加强价值引导和舆论监督，规范网络游戏经营行为，建立和完善立足于我国国情的网络游戏作品评价体系，进而最终完成我国网络游戏全行业的转型升级，促进我国以网络游戏为代表的网络文艺的健康发展，其重大意义就不仅仅局限于网络游戏行业本身，其对于我国网络文艺乃至整体性文化产业格局的转型升级，都将产生示范和引领作用。&lt;/p&gt;', '1534491152', '1534584922');
INSERT INTO `ey_article_content` VALUES ('51', '54', '&lt;p style=&quot;text-align: center;&quot;&gt;&lt;img src=&quot;/public/upload/article/2018/08/18/f56fa5203d3f26f4737152c2456ad92e.jpg&quot; title=&quot;f56fa5203d3f26f4737152c2456ad92e.jpg&quot; alt=&quot;f56fa5203d3f26f4737152c2456ad92e.jpg&quot;/&gt;&lt;/p&gt;&lt;p style=&quot;text-align: center;&quot;&gt;　开发功能性游戏，对在全球网络游戏市场份额占比近10%的腾讯来说，显然是一个重要节点，对全行业也有积极影响。但是，对我国这一全球最大的网络游戏市场而言，对不断加大走出去力度的众多中国互联网企业而言，这仅仅是漫长征程的第一步。开发出更多可以服务具体应用目的和应用场景的，具有正面主流价值的功能游戏，应当成为全行业的共识。因为，这绝不仅仅关乎企业自身的商业利益，对于改变当前社会上对网络游戏的一些片面认识，促进网络游戏全行业的转型升级，更是有着重要意义。&lt;/p&gt;', '1534491184', '1534584897');
INSERT INTO `ey_article_content` VALUES ('25', '28', '&lt;p style=&quot;text-align: center;&quot;&gt;&lt;img src=&quot;/public/upload/article/2018/08/18/cdfc64e6554748f11219d9da4d8359de.jpg&quot; title=&quot;cdfc64e6554748f11219d9da4d8359de.jpg&quot; alt=&quot;cdfc64e6554748f11219d9da4d8359de.jpg&quot;/&gt;&lt;/p&gt;&lt;p style=&quot;text-align: center;&quot;&gt;未来几年，功能游戏将有两位数的年均复合增长率，市场规模将迅速增长到300亿元到500亿元，其广阔的发展前景和深远影响更将远远超过其商业价值。在可预见的将来，功能游戏还将进一步主流化，成为主流社会日常性的互联网应用工具。过去几年，我国出现了《韩熙载夜宴图》《每日故宫》《紫禁城祥瑞》《皇帝的一天》以及《榫卯》《折扇》等和传统文化深入融合的功能游戏精品佳作，但就我国网络游戏行业的实际发展情况而言，在功能游戏领域，我们只是刚刚起步。&lt;/p&gt;', '1534155527', '1534585010');
INSERT INTO `ey_article_content` VALUES ('21', '23', '&lt;p style=&quot;text-align: center;&quot;&gt;&lt;img src=&quot;/public/upload/article/2018/08/18/6e3d812ecf3975306f3b470cb9e6e5b0.jpg&quot; title=&quot;6e3d812ecf3975306f3b470cb9e6e5b0.jpg&quot; alt=&quot;6e3d812ecf3975306f3b470cb9e6e5b0.jpg&quot;/&gt;&lt;/p&gt;&lt;p style=&quot;text-align: center;&quot;&gt;1994年，基于海湾战争的经验，美国海军陆战队成立了世界上第一个功能游戏军事训练机构，将功能游戏作为军队模拟训练的辅助手段。经过互联网领域在世纪之交的爆炸式发展，2006年之后，功能游戏逐渐拓展到了民用领域，在教育、医疗、交通、应急管理、环境保护、企业管理、文化传承等方面发挥了重要作用，为很多国家的政府部门、社会机构解决社会公共生活的各类难题，提供了不可替代的治理演练和经验。&lt;/p&gt;', '1533628002', '1534585035');
INSERT INTO `ey_article_content` VALUES ('47', '50', '&lt;p style=&quot;text-align:center&quot;&gt;&lt;img src=&quot;/public/upload/article/2018/08/18/3b60112e4c0db75f914d76c3e514c7bc.jpg&quot; title=&quot;3b60112e4c0db75f914d76c3e514c7bc.jpg&quot; alt=&quot;3b60112e4c0db75f914d76c3e514c7bc.jpg&quot;/&gt;&lt;/p&gt;', '1534490623', '1534584661');
INSERT INTO `ey_article_content` VALUES ('46', '49', '&lt;p style=&quot;text-align: center;&quot;&gt;&lt;img src=&quot;/public/upload/article/2018/08/18/60741fa39741a56bd798f3008a0514e1.jpg&quot; title=&quot;60741fa39741a56bd798f3008a0514e1.jpg&quot; alt=&quot;60741fa39741a56bd798f3008a0514e1.jpg&quot;/&gt;&lt;/p&gt;', '1534490511', '1534584703');
INSERT INTO `ey_article_content` VALUES ('45', '48', '&lt;p style=&quot;text-align:center&quot;&gt;&lt;img src=&quot;/public/upload/article/2018/08/18/7e7da58da302efe111243d436d6212fa.jpg&quot; title=&quot;7e7da58da302efe111243d436d6212fa.jpg&quot; alt=&quot;7e7da58da302efe111243d436d6212fa.jpg&quot;/&gt;&lt;/p&gt;', '1534473824', '1534584735');
INSERT INTO `ey_article_content` VALUES ('44', '47', '&lt;p style=&quot;text-align:center&quot;&gt;&lt;img src=&quot;/public/upload/article/2018/08/18/b606866e3714255c14e79481645e4151.jpg&quot; title=&quot;b606866e3714255c14e79481645e4151.jpg&quot; alt=&quot;b606866e3714255c14e79481645e4151.jpg&quot;/&gt;&lt;/p&gt;', '1534473672', '1534584755');
INSERT INTO `ey_article_content` VALUES ('41', '44', '&lt;p&gt;动员政府部门、专家学者、行业企业、游戏用户和社会媒体等多方力量的广泛参与，开展对包括功能游戏在内的不同类型网络游戏的评论、批评，科学认识和评价网络游戏的复合价值，激浊扬清，发掘游戏文化中的优秀内容，加强价值引导和舆论监督，规范网络游戏经营行为，建立和完善立足于我国国情的网络游戏作品评价体系，进而最终完成我国网络游戏全行业的转型升级，促进我国以网络游戏为代表的网络文艺的健康发展，其重大意义就不仅仅局限于网络游戏行业本身，其对于我国网络文艺乃至整体性文化产业格局的转型升级，都将产生示范和引领作用。&lt;/p&gt;', '1535532139', '1535532139');
INSERT INTO `ey_article_content` VALUES ('42', '45', '&lt;p&gt;　开发功能性游戏，对在全球网络游戏市场份额占比近10%的腾讯来说，显然是一个重要节点，对全行业也有积极影响。但是，对我国这一全球最大的网络游戏市场而言，对不断加大走出去力度的众多中国互联网企业而言，这仅仅是漫长征程的第一步。开发出更多可以服务具体应用目的和应用场景的，具有正面主流价值的功能游戏，应当成为全行业的共识。因为，这绝不仅仅关乎企业自身的商业利益，对于改变当前社会上对网络游戏的一些片面认识，促进网络游戏全行业的转型升级，更是有着重要意义。&lt;/p&gt;', '1535503482', '1535503482');
INSERT INTO `ey_article_content` VALUES ('43', '46', '&lt;p&gt;　未来几年，功能游戏将有两位数的年均复合增长率，市场规模将迅速增长到300亿元到500亿元，其广阔的发展前景和深远影响更将远远超过其商业价值。在可预见的将来，功能游戏还将进一步主流化，成为主流社会日常性的互联网应用工具。过去几年，我国出现了《韩熙载夜宴图》《每日故宫》《紫禁城祥瑞》《皇帝的一天》以及《榫卯》《折扇》等和传统文化深入融合的功能游戏精品佳作，但就我国网络游戏行业的实际发展情况而言，在功能游戏领域，我们只是刚刚起步。&lt;/p&gt;', '1535503467', '1535503467');

-- -----------------------------
-- Table structure for `ey_auth_role`
-- -----------------------------
DROP TABLE IF EXISTS `ey_auth_role`;
CREATE TABLE `ey_auth_role` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT '' COMMENT '角色名',
  `pid` int(10) DEFAULT '0' COMMENT '父角色ID',
  `remark` text COMMENT '备注信息',
  `grade` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT '级别',
  `language` text COMMENT '多语言权限',
  `online_update` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '在线升级',
  `only_oneself` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '只看自己发布',
  `cud` varchar(255) DEFAULT '' COMMENT '增改删',
  `permission` text COMMENT '已允许的权限',
  `built_in` tinyint(1) DEFAULT '0' COMMENT '内置用户组，1表示内置',
  `sort_order` int(10) DEFAULT '0' COMMENT '排序号',
  `status` tinyint(1) DEFAULT '1' COMMENT '状态(1=正常，0=屏蔽)',
  `admin_id` int(10) DEFAULT '0' COMMENT '操作管理员ID',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COMMENT='管理员角色表';

-- -----------------------------
-- Records of `ey_auth_role`
-- -----------------------------
INSERT INTO `ey_auth_role` VALUES ('1', '优化推广员', '0', '', '0', 'a:1:{i:0;s:2:\"cn\";}', '0', '1', 'a:3:{i:0;s:3:\"add\";i:1;s:4:\"edit\";i:2;s:3:\"del\";}', 'a:2:{s:5:\"rules\";a:8:{i:0;s:1:\"1\";i:1;s:1:\"3\";i:2;s:1:\"4\";i:3;s:1:\"8\";i:4;s:1:\"9\";i:5;s:2:\"10\";i:6;s:2:\"14\";i:7;i:2;}s:7:\"arctype\";a:40:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";i:3;s:1:\"4\";i:4;s:1:\"5\";i:5;s:1:\"6\";i:6;s:2:\"33\";i:7;s:2:\"34\";i:8;s:2:\"35\";i:9;s:2:\"36\";i:10;s:2:\"37\";i:11;s:2:\"38\";i:12;s:2:\"39\";i:13;s:2:\"40\";i:14;s:2:\"41\";i:15;s:2:\"42\";i:16;s:2:\"43\";i:17;s:2:\"44\";i:18;s:2:\"45\";i:19;s:2:\"46\";i:20;s:2:\"47\";i:21;s:2:\"48\";i:22;s:1:\"8\";i:23;s:2:\"32\";i:24;s:1:\"9\";i:25;s:2:\"30\";i:26;s:2:\"31\";i:27;s:2:\"11\";i:28;s:2:\"12\";i:29;s:2:\"13\";i:30;s:2:\"23\";i:31;s:2:\"20\";i:32;s:2:\"24\";i:33;s:2:\"25\";i:34;s:2:\"21\";i:35;s:2:\"26\";i:36;s:2:\"22\";i:37;s:2:\"27\";i:38;s:2:\"28\";i:39;s:2:\"29\";}}', '1', '100', '1', '0', '1541207843', '0');
INSERT INTO `ey_auth_role` VALUES ('2', '内容管理员', '0', '', '0', 'a:1:{i:0;s:2:\"cn\";}', '0', '1', 'a:3:{i:0;s:3:\"add\";i:1;s:4:\"edit\";i:2;s:3:\"del\";}', 'a:2:{s:5:\"rules\";a:4:{i:0;s:1:\"1\";i:1;s:2:\"10\";i:2;s:2:\"14\";i:3;i:2;}s:7:\"arctype\";a:40:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";i:3;s:1:\"4\";i:4;s:1:\"5\";i:5;s:1:\"6\";i:6;s:2:\"33\";i:7;s:2:\"34\";i:8;s:2:\"35\";i:9;s:2:\"36\";i:10;s:2:\"37\";i:11;s:2:\"38\";i:12;s:2:\"39\";i:13;s:2:\"40\";i:14;s:2:\"41\";i:15;s:2:\"42\";i:16;s:2:\"43\";i:17;s:2:\"44\";i:18;s:2:\"45\";i:19;s:2:\"46\";i:20;s:2:\"47\";i:21;s:2:\"48\";i:22;s:1:\"8\";i:23;s:2:\"32\";i:24;s:1:\"9\";i:25;s:2:\"30\";i:26;s:2:\"31\";i:27;s:2:\"11\";i:28;s:2:\"12\";i:29;s:2:\"13\";i:30;s:2:\"23\";i:31;s:2:\"20\";i:32;s:2:\"24\";i:33;s:2:\"25\";i:34;s:2:\"21\";i:35;s:2:\"26\";i:36;s:2:\"22\";i:37;s:2:\"27\";i:38;s:2:\"28\";i:39;s:2:\"29\";}}', '1', '100', '1', '0', '1541207846', '0');

-- -----------------------------
-- Table structure for `ey_channelfield`
-- -----------------------------
DROP TABLE IF EXISTS `ey_channelfield`;
CREATE TABLE `ey_channelfield` (
  `id` int(10) NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `name` varchar(32) NOT NULL DEFAULT '' COMMENT '字段名称',
  `channel_id` int(10) NOT NULL DEFAULT '0' COMMENT '所属文档模型id',
  `title` varchar(32) NOT NULL DEFAULT '' COMMENT '字段标题',
  `dtype` varchar(32) NOT NULL DEFAULT '' COMMENT '字段类型',
  `define` varchar(128) NOT NULL DEFAULT '' COMMENT '字段定义',
  `maxlength` int(10) NOT NULL DEFAULT '0' COMMENT '最大长度，文本数据必须填写，大于255为text类型',
  `dfvalue` varchar(1000) NOT NULL DEFAULT '' COMMENT '默认值',
  `dfvalue_unit` varchar(50) NOT NULL DEFAULT '' COMMENT '数值单位',
  `remark` varchar(256) NOT NULL DEFAULT '' COMMENT '提示说明',
  `ifeditable` tinyint(1) NOT NULL DEFAULT '1' COMMENT '是否在编辑页显示',
  `ifrequire` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否必填',
  `ifsystem` tinyint(1) NOT NULL DEFAULT '0' COMMENT '字段分类，1=系统(不可修改)，0=自定义',
  `ifmain` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否主表字段',
  `sort_order` int(5) NOT NULL DEFAULT '100' COMMENT '排序',
  `status` tinyint(1) NOT NULL DEFAULT '1' COMMENT '状态',
  `add_time` int(11) NOT NULL DEFAULT '0' COMMENT '创建时间',
  `update_time` int(11) NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`,`channel_id`)
) ENGINE=MyISAM AUTO_INCREMENT=52 DEFAULT CHARSET=utf8 COMMENT='自定义字段表';

-- -----------------------------
-- Records of `ey_channelfield`
-- -----------------------------
INSERT INTO `ey_channelfield` VALUES ('1', 'add_time', '0', '新增时间', 'datetime', 'int(11)', '250', '', '', '', '1', '0', '1', '1', '100', '1', '1533091575', '1533091575');
INSERT INTO `ey_channelfield` VALUES ('2', 'update_time', '0', '更新时间', 'datetime', 'int(11)', '250', '', '', '', '1', '0', '1', '1', '100', '1', '1533091601', '1533091601');
INSERT INTO `ey_channelfield` VALUES ('3', 'aid', '0', '文档ID', 'int', 'int(11)', '250', '', '', '', '1', '0', '1', '1', '100', '1', '1533091624', '1533091624');
INSERT INTO `ey_channelfield` VALUES ('4', 'typeid', '0', '当前栏目ID', 'int', 'int(11)', '250', '', '', '', '1', '0', '1', '1', '100', '1', '1533091930', '1533091930');
INSERT INTO `ey_channelfield` VALUES ('5', 'channel', '0', '模型ID', 'int', 'int(11)', '250', '', '', '', '1', '0', '1', '1', '100', '1', '1533092214', '1533092214');
INSERT INTO `ey_channelfield` VALUES ('6', 'is_b', '0', '是否加粗', 'switch', 'tinyint(1)', '250', '', '', '', '1', '0', '1', '1', '100', '1', '1533092246', '1533092246');
INSERT INTO `ey_channelfield` VALUES ('7', 'title', '0', '文档标题', 'text', 'varchar(250)', '250', '', '', '', '1', '0', '1', '1', '100', '1', '1533092381', '1533092381');
INSERT INTO `ey_channelfield` VALUES ('8', 'litpic', '0', '封面图', 'img', 'varchar(250)', '250', '', '', '', '1', '0', '1', '1', '100', '1', '1533092398', '1533092398');
INSERT INTO `ey_channelfield` VALUES ('9', 'is_head', '0', '是否头条', 'switch', 'tinyint(1)', '250', '', '', '', '1', '0', '1', '1', '100', '1', '1533092420', '1533092420');
INSERT INTO `ey_channelfield` VALUES ('10', 'is_special', '0', '是否特荐', 'switch', 'tinyint(1)', '250', '', '', '', '1', '0', '1', '1', '100', '1', '1533092439', '1533092439');
INSERT INTO `ey_channelfield` VALUES ('11', 'is_top', '0', '是否置顶', 'switch', 'tinyint(1)', '250', '', '', '', '1', '0', '1', '1', '100', '1', '1533092454', '1533092454');
INSERT INTO `ey_channelfield` VALUES ('12', 'is_recom', '0', '是否推荐', 'switch', 'tinyint(1)', '250', '', '', '', '1', '0', '1', '1', '100', '1', '1533092468', '1533092468');
INSERT INTO `ey_channelfield` VALUES ('13', 'is_jump', '0', '是否跳转', 'switch', 'tinyint(1)', '250', '', '', '', '1', '0', '1', '1', '100', '1', '1533092484', '1533092484');
INSERT INTO `ey_channelfield` VALUES ('14', 'author', '0', '编辑者', 'text', 'varchar(250)', '250', '', '', '', '1', '0', '1', '1', '100', '1', '1533092498', '1533092498');
INSERT INTO `ey_channelfield` VALUES ('15', 'click', '0', '浏览量', 'int', 'int(11)', '250', '', '', '', '1', '0', '1', '1', '100', '1', '1533092512', '1533092512');
INSERT INTO `ey_channelfield` VALUES ('16', 'arcrank', '0', '阅读权限', 'select', 'tinyint(1)', '250', '', '', '', '1', '0', '1', '1', '100', '1', '1533092534', '1533092534');
INSERT INTO `ey_channelfield` VALUES ('17', 'jumplinks', '0', '跳转链接', 'text', 'varchar(250)', '250', '', '', '', '1', '0', '1', '1', '100', '1', '1533092553', '1533092553');
INSERT INTO `ey_channelfield` VALUES ('18', 'ismake', '0', '是否静态页面', 'switch', 'tinyint(1)', '250', '', '', '', '1', '0', '1', '1', '100', '1', '1533092698', '1533092698');
INSERT INTO `ey_channelfield` VALUES ('19', 'seo_title', '0', 'SEO标题', 'text', 'varchar(250)', '250', '', '', '', '1', '0', '1', '1', '100', '1', '1533092713', '1533092713');
INSERT INTO `ey_channelfield` VALUES ('20', 'seo_keywords', '0', 'SEO关键词', 'text', 'varchar(250)', '250', '', '', '', '1', '0', '1', '1', '100', '1', '1533092725', '1533092725');
INSERT INTO `ey_channelfield` VALUES ('21', 'seo_description', '0', 'SEO描述', 'text', 'varchar(250)', '250', '', '', '', '1', '0', '1', '1', '100', '1', '1533092739', '1533092739');
INSERT INTO `ey_channelfield` VALUES ('22', 'status', '0', '状态', 'switch', 'tinyint(1)', '250', '', '', '', '1', '0', '1', '1', '100', '1', '1533092753', '1533092753');
INSERT INTO `ey_channelfield` VALUES ('23', 'sort_order', '0', '排序号', 'int', 'int(11)', '250', '', '', '', '1', '0', '1', '1', '100', '1', '1533092766', '1533092766');
INSERT INTO `ey_channelfield` VALUES ('24', 'content', '2', '内容', 'htmltext', 'longtext', '250', '', '', '', '1', '0', '1', '0', '100', '1', '1533359739', '1533359739');
INSERT INTO `ey_channelfield` VALUES ('25', 'content', '3', '内容详情', 'htmltext', 'longtext', '250', '', '', '', '1', '0', '1', '0', '100', '1', '1533359588', '1533359588');
INSERT INTO `ey_channelfield` VALUES ('26', 'content', '4', '内容详情', 'htmltext', 'longtext', '250', '', '', '', '1', '0', '1', '0', '100', '1', '1533359752', '1533359752');
INSERT INTO `ey_channelfield` VALUES ('27', 'content', '6', '内容详情', 'htmltext', 'longtext', '250', '', '', '', '1', '0', '1', '0', '100', '1', '1533464715', '1533464715');
INSERT INTO `ey_channelfield` VALUES ('29', 'content', '1', '内容详情', 'htmltext', 'longtext', '250', '', '', '', '1', '0', '1', '0', '100', '1', '1533464713', '1533464713');
INSERT INTO `ey_channelfield` VALUES ('30', 'update_time', '-99', '更新时间', 'datetime', 'int(11)', '11', '0', '', '', '1', '0', '1', '1', '100', '1', '1533524780', '1533524780');
INSERT INTO `ey_channelfield` VALUES ('31', 'add_time', '-99', '新增时间', 'datetime', 'int(11)', '11', '0', '', '', '1', '0', '1', '1', '100', '1', '1533524780', '1533524780');
INSERT INTO `ey_channelfield` VALUES ('32', 'status', '-99', '启用 (1=正常，0=屏蔽)', 'switch', 'tinyint(1)', '1', '1', '', '', '1', '0', '1', '1', '100', '1', '1533524780', '1533524780');
INSERT INTO `ey_channelfield` VALUES ('33', 'is_part', '-99', '栏目属性：0=内容栏目，1=外部链接', 'switch', 'tinyint(1)', '1', '0', '', '', '1', '0', '1', '1', '100', '1', '1533524780', '1533524780');
INSERT INTO `ey_channelfield` VALUES ('34', 'is_hidden', '-99', '是否隐藏栏目：0=显示，1=隐藏', 'switch', 'tinyint(1)', '1', '0', '', '', '1', '0', '1', '1', '100', '1', '1533524780', '1533524780');
INSERT INTO `ey_channelfield` VALUES ('35', 'sort_order', '-99', '排序号', 'int', 'int(10)', '10', '0', '', '', '1', '0', '1', '1', '100', '1', '1533524780', '1533524780');
INSERT INTO `ey_channelfield` VALUES ('36', 'seo_description', '-99', 'seo描述', 'multitext', 'text', '0', '', '', '', '1', '0', '1', '1', '100', '1', '1533524780', '1533524780');
INSERT INTO `ey_channelfield` VALUES ('37', 'seo_keywords', '-99', 'seo关键字', 'text', 'varchar(200)', '200', '', '', '', '1', '0', '1', '1', '100', '1', '1533524780', '1533524780');
INSERT INTO `ey_channelfield` VALUES ('38', 'seo_title', '-99', 'SEO标题', 'text', 'varchar(200)', '200', '', '', '', '1', '0', '1', '1', '100', '1', '1533524780', '1533524780');
INSERT INTO `ey_channelfield` VALUES ('39', 'tempview', '-99', '文档模板文件名', 'text', 'varchar(200)', '200', '', '', '', '1', '0', '1', '1', '100', '1', '1533524780', '1533524780');
INSERT INTO `ey_channelfield` VALUES ('40', 'templist', '-99', '列表模板文件名', 'text', 'varchar(200)', '200', '', '', '', '1', '0', '1', '1', '100', '1', '1533524780', '1533524780');
INSERT INTO `ey_channelfield` VALUES ('41', 'litpic', '-99', '栏目图片', 'img', 'varchar(250)', '250', '', '', '', '1', '0', '1', '1', '100', '1', '1533524780', '1533524780');
INSERT INTO `ey_channelfield` VALUES ('42', 'typelink', '-99', '栏目链接', 'text', 'varchar(200)', '200', '', '', '', '1', '0', '1', '1', '100', '1', '1533524780', '1533524780');
INSERT INTO `ey_channelfield` VALUES ('43', 'grade', '-99', '栏目等级', 'switch', 'tinyint(1)', '1', '0', '', '', '1', '0', '1', '1', '100', '1', '1533524780', '1533524780');
INSERT INTO `ey_channelfield` VALUES ('44', 'englist_name', '-99', '栏目英文名', 'text', 'varchar(200)', '200', '', '', '', '1', '0', '1', '1', '100', '1', '1533524780', '1533524780');
INSERT INTO `ey_channelfield` VALUES ('45', 'dirpath', '-99', '目录存放HTML路径', 'text', 'varchar(200)', '200', '', '', '', '1', '0', '1', '1', '100', '1', '1533524780', '1533524780');
INSERT INTO `ey_channelfield` VALUES ('46', 'dirname', '-99', '目录英文名', 'text', 'varchar(200)', '200', '', '', '', '1', '0', '1', '1', '100', '1', '1533524780', '1533524780');
INSERT INTO `ey_channelfield` VALUES ('47', 'typename', '-99', '栏目名称', 'text', 'varchar(200)', '200', '', '', '', '1', '0', '1', '1', '100', '1', '1533524780', '1533524780');
INSERT INTO `ey_channelfield` VALUES ('48', 'parent_id', '-99', '栏目上级ID', 'int', 'int(10)', '10', '0', '', '', '1', '0', '1', '1', '100', '1', '1533524780', '1533524780');
INSERT INTO `ey_channelfield` VALUES ('49', 'current_channel', '-99', '栏目当前模型ID', 'int', 'int(10)', '10', '0', '', '', '1', '0', '1', '1', '100', '1', '1533524780', '1533524780');
INSERT INTO `ey_channelfield` VALUES ('50', 'channeltype', '-99', '栏目顶级模型ID', 'int', 'int(10)', '10', '0', '', '', '1', '0', '1', '1', '100', '1', '1533524780', '1533524780');
INSERT INTO `ey_channelfield` VALUES ('51', 'id', '-99', '栏目ID', 'int', 'int(10)', '10', '', '', '', '1', '0', '1', '1', '100', '1', '1533524780', '1533524780');

-- -----------------------------
-- Table structure for `ey_channeltype`
-- -----------------------------
DROP TABLE IF EXISTS `ey_channeltype`;
CREATE TABLE `ey_channeltype` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nid` varchar(50) NOT NULL DEFAULT '' COMMENT '识别id',
  `title` varchar(30) DEFAULT '' COMMENT '名称',
  `ntitle` varchar(30) DEFAULT '' COMMENT '左侧菜单名称',
  `table` varchar(50) DEFAULT '' COMMENT '表名',
  `ctl_name` varchar(50) DEFAULT '' COMMENT '控制器名称（区分大小写）',
  `status` tinyint(1) DEFAULT '1' COMMENT '状态(1=启用，0=屏蔽)',
  `sort_order` smallint(6) DEFAULT '50' COMMENT '排序',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idention` (`nid`) USING BTREE,
  UNIQUE KEY `ctl_name` (`ctl_name`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=9 DEFAULT CHARSET=utf8;

-- -----------------------------
-- Records of `ey_channeltype`
-- -----------------------------
INSERT INTO `ey_channeltype` VALUES ('1', 'article', '文章模型', '文章', 'article', 'Article', '1', '1', '0', '1547782055');
INSERT INTO `ey_channeltype` VALUES ('4', 'download', '下载模型', '下载', 'download', 'Download', '0', '4', '0', '1547782055');
INSERT INTO `ey_channeltype` VALUES ('2', 'product', '产品模型', '产品', 'product', 'Product', '0', '2', '0', '1547782055');
INSERT INTO `ey_channeltype` VALUES ('8', 'guestbook', '留言模型', '留言', 'guestbook', 'Guestbook', '1', '8', '1509197711', '1547782055');
INSERT INTO `ey_channeltype` VALUES ('6', 'single', '单页模型', '单页', 'single', 'Single', '1', '6', '1523091961', '1547782055');
INSERT INTO `ey_channeltype` VALUES ('3', 'images', '图集模型', '图集', 'images', 'Images', '0', '3', '1523929121', '1547782055');

-- -----------------------------
-- Table structure for `ey_config`
-- -----------------------------
DROP TABLE IF EXISTS `ey_config`;
CREATE TABLE `ey_config` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) DEFAULT '' COMMENT '配置的key键名',
  `value` text,
  `inc_type` varchar(64) DEFAULT '' COMMENT '配置分组',
  `desc` varchar(50) DEFAULT '' COMMENT '描述',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `is_del` tinyint(1) DEFAULT '0' COMMENT '是否已删除，0=否，1=是',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=91 DEFAULT CHARSET=utf8;

-- -----------------------------
-- Records of `ey_config`
-- -----------------------------
INSERT INTO `ey_config` VALUES ('1', 'is_mark', '0', 'water', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('2', 'mark_txt', '易优Cms', 'water', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('3', 'mark_img', '/public/upload/water/2018/05/08/93806077e5a4c4e12ceed30df5cde761.png', 'water', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('4', 'mark_width', '200', 'water', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('5', 'mark_height', '50', 'water', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('6', 'mark_degree', '54', 'water', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('7', 'mark_quality', '56', 'water', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('8', 'mark_sel', '9', 'water', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('9', 'sms_time_out', '120', 'sms', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('10', 'theme_style', '1', 'basic', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('11', 'file_size', '500', 'basic', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('12', 'image_type', 'jpg|gif|png|bmp|jpeg|ico', 'basic', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('13', 'file_type', 'zip|gz|rar|iso|doc|xsl|ppt|wps', 'basic', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('14', 'media_type', 'swf|mpg|mp3|rm|rmvb|wmv|wma|wav|mid|mov|mp4', 'basic', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('15', 'web_keywords', '', 'web', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('17', 'sms_platform', '1', 'sms', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('18', 'seo_viewtitle_format', '2', 'seo', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('19', 'smtp_server', 'smtp.qq.com', 'smtp', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('20', 'smtp_port', '465', 'smtp', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('21', 'smtp_user', 'xxxxxxxxx@qq.com', 'smtp', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('22', 'smtp_pwd', 'xxxxxxxxxxx', 'smtp', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('23', 'inc_type', 'smtp', 'smtp', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('24', 'mark_type', 'img', 'water', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('25', 'mark_txt_size', '30', 'water', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('26', 'mark_txt_color', '#000000', 'water', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('27', 'oss_switch', '0', 'oss', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('28', 'web_name', '易优Cms-演示站', 'web', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('29', 'web_logo', '/public/upload/system/2018/08/29/a6e8898701720768fba2ccd39f5f7ab5.png', 'web', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('30', 'web_ico', '/favicon.ico', 'web', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('31', 'web_basehost', 'http://127.0.0.86', 'web', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('32', 'web_description', '', 'web', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('79', 'web_recordnum', '琼ICP备888999号', 'web', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('33', 'web_copyright', 'Copyright © 2012-2018 某某网站 版权所有', 'web', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('34', 'web_thirdcode_pc', '', 'web', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('35', 'web_thirdcode_wap', '', 'web', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('39', 'seo_arcdir', '/html', 'seo', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('40', 'seo_pseudo', '1', 'seo', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('41', 'list_symbol', '&gt;', 'basic', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('42', 'sitemap_auto', '1', 'sitemap', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('43', 'sitemap_not1', '0', 'sitemap', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('44', 'sitemap_not2', '1', 'sitemap', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('45', 'sitemap_xml', '1', 'sitemap', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('46', 'sitemap_txt', '0', 'sitemap', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('47', 'sitemap_zzbaidutoken', '', 'sitemap', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('48', 'seo_expires_in', '7200', 'seo', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('55', 'web_title', '传奇竞技游戏类网站模板', 'web', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('56', 'smtp_test_eamil', 'xxxxxxxx@qq.com', 'smtp', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('57', 'web_authortoken', '6e27af8a47788c33317c98fd9b0d8e03', 'web', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('58', 'web_attr_3', '海南省海口市玉沙路58号', 'web', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('59', 'web_attr_2', '13988889999', 'web', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('60', 'web_attr_1', '诚信为本：市场永远在变，诚信永远不变。', 'web', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('61', 'web_attr_4', '0898-66889888', 'web', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('81', 'web_attr_5', 'admin@youweb.com', 'web', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('62', 'seo_inlet', '1', 'seo', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('63', 'web_cmspath', '', 'web', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('64', 'web_sqldatapath', '/data/sqldata', 'web', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('65', 'web_cmsurl', '', 'web', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('66', 'web_templets_dir', '/template', 'web', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('67', 'web_templeturl', '/template', 'web', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('68', 'web_templets_pc', '/template/pc', 'web', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('69', 'web_templets_m', '/template/mobile', 'web', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('70', 'web_eyoucms', 'http://www.eyoucms.com', 'web', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('78', '_cmscopyright', 'pmsa9DMfLoc9pNENhfJgDu2i', 'php', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('76', 'seo_liststitle_format', '2', 'seo', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('77', 'web_status', '0', 'web', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('80', 'web_is_authortoken', '-1', 'web', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('82', 'web_attr_6', '/public/upload/system/2018/08/15/c57f1b1034dcdd4e1ed59619752d6ce3.jpg', 'web', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('83', 'web_attr_7', '88889999', 'web', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('84', 'seo_rewrite_format', '2', 'seo', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('85', 'seo_dynamic_format', '1', 'seo', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('86', 'system_sql_mode', 'NO_AUTO_CREATE_USER,NO_ENGINE_SUBSTITUTION', 'system', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('87', 'web_adminbasefile', '/login.php', 'web', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('88', 'system_home_default_lang', 'cn', 'system', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('89', 'system_langnum', '1', 'system', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('90', 'system_version', 'v1.2.6', 'system', '', 'cn', '0', '0');

-- -----------------------------
-- Table structure for `ey_config_attribute`
-- -----------------------------
DROP TABLE IF EXISTS `ey_config_attribute`;
CREATE TABLE `ey_config_attribute` (
  `attr_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '表单id',
  `inc_type` varchar(20) DEFAULT '' COMMENT '变量分组',
  `attr_name` varchar(60) DEFAULT '' COMMENT '变量标题',
  `attr_var_name` varchar(50) DEFAULT '' COMMENT '变量名',
  `attr_input_type` tinyint(1) unsigned DEFAULT '0' COMMENT ' 0=文本框，1=下拉框，2=多行文本框，3=上传图片',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`attr_id`)
) ENGINE=MyISAM AUTO_INCREMENT=8 DEFAULT CHARSET=utf8 COMMENT='留言表单属性';

-- -----------------------------
-- Records of `ey_config_attribute`
-- -----------------------------
INSERT INTO `ey_config_attribute` VALUES ('1', 'web', '网站公告', 'web_attr_1', '0', 'cn', '1533544029', '1533544029');
INSERT INTO `ey_config_attribute` VALUES ('2', 'web', '手机号码', 'web_attr_2', '0', 'cn', '1533550261', '1533550261');
INSERT INTO `ey_config_attribute` VALUES ('3', 'web', '地址', 'web_attr_3', '0', 'cn', '1533550302', '1533550302');
INSERT INTO `ey_config_attribute` VALUES ('4', 'web', '电话', 'web_attr_4', '0', 'cn', '1533550375', '1533550375');
INSERT INTO `ey_config_attribute` VALUES ('5', 'web', '邮箱', 'web_attr_5', '0', 'cn', '1533550438', '1533550438');
INSERT INTO `ey_config_attribute` VALUES ('6', 'web', '微信二维码', 'web_attr_6', '3', 'cn', '1533607848', '1533607848');
INSERT INTO `ey_config_attribute` VALUES ('7', 'web', 'QQ客服', 'web_attr_7', '0', 'cn', '1533608360', '1535528908');

-- -----------------------------
-- Table structure for `ey_download_content`
-- -----------------------------
DROP TABLE IF EXISTS `ey_download_content`;
CREATE TABLE `ey_download_content` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `aid` int(10) DEFAULT '0' COMMENT '文档ID',
  `content` longtext COMMENT '内容详情',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `news_id` (`aid`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='资讯内容表_存储正常内容';


-- -----------------------------
-- Table structure for `ey_download_file`
-- -----------------------------
DROP TABLE IF EXISTS `ey_download_file`;
CREATE TABLE `ey_download_file` (
  `file_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `aid` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '产品ID',
  `title` varchar(200) DEFAULT '' COMMENT '产品标题',
  `file_url` varchar(255) DEFAULT '' COMMENT '文件存储路径',
  `file_size` varchar(255) DEFAULT '' COMMENT '文件大小',
  `file_ext` varchar(50) DEFAULT '' COMMENT '文件后缀名',
  `file_name` varchar(200) DEFAULT '' COMMENT '文件名',
  `file_mime` varchar(200) DEFAULT '' COMMENT '文件类型',
  `uhash` varchar(200) DEFAULT '' COMMENT '自定义的一种加密方式，用于文件下载权限验证',
  `md5file` varchar(200) DEFAULT '' COMMENT 'md5_file加密，可以检测上传/下载的文件包是否损坏',
  `sort_order` smallint(5) DEFAULT '0' COMMENT '排序',
  `add_time` int(10) unsigned DEFAULT '0' COMMENT '上传时间',
  PRIMARY KEY (`file_id`),
  KEY `arcid` (`aid`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


-- -----------------------------
-- Table structure for `ey_field_type`
-- -----------------------------
DROP TABLE IF EXISTS `ey_field_type`;
CREATE TABLE `ey_field_type` (
  `name` varchar(32) NOT NULL DEFAULT '' COMMENT '字段类型',
  `title` varchar(64) NOT NULL DEFAULT '' COMMENT '中文类型名',
  `ifoption` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否需要设置选项',
  `sort_order` int(10) NOT NULL DEFAULT '0' COMMENT '排序',
  `add_time` int(11) NOT NULL DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`name`),
  UNIQUE KEY `name` (`name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='字段类型表';

-- -----------------------------
-- Records of `ey_field_type`
-- -----------------------------
INSERT INTO `ey_field_type` VALUES ('text', '单行文本', '0', '1', '1532485708', '1532485708');
INSERT INTO `ey_field_type` VALUES ('checkbox', '多选项', '1', '5', '1532485708', '1532485708');
INSERT INTO `ey_field_type` VALUES ('multitext', '多行文本', '0', '2', '1532485708', '1532485708');
INSERT INTO `ey_field_type` VALUES ('radio', '单选项', '1', '4', '1532485708', '1532485708');
INSERT INTO `ey_field_type` VALUES ('switch', '开关', '0', '13', '1532485708', '1532485708');
INSERT INTO `ey_field_type` VALUES ('select', '下拉框', '1', '6', '1532485708', '1532485708');
INSERT INTO `ey_field_type` VALUES ('img', '单张图', '0', '10', '1532485708', '1532485708');
INSERT INTO `ey_field_type` VALUES ('int', '整数类型', '0', '7', '1532485708', '1532485708');
INSERT INTO `ey_field_type` VALUES ('datetime', '日期和时间', '0', '12', '1532485708', '1532485708');
INSERT INTO `ey_field_type` VALUES ('htmltext', 'HTML文本', '0', '3', '1532485708', '1532485708');
INSERT INTO `ey_field_type` VALUES ('imgs', '多张图', '0', '11', '1532485708', '1532485708');
INSERT INTO `ey_field_type` VALUES ('decimal', '金额类型', '0', '9', '1532485708', '1532485708');
INSERT INTO `ey_field_type` VALUES ('float', '小数类型', '0', '8', '1532485708', '1532485708');

-- -----------------------------
-- Table structure for `ey_guestbook`
-- -----------------------------
DROP TABLE IF EXISTS `ey_guestbook`;
CREATE TABLE `ey_guestbook` (
  `aid` int(11) NOT NULL AUTO_INCREMENT,
  `typeid` int(11) DEFAULT '0' COMMENT '栏目ID',
  `channel` smallint(5) DEFAULT '0' COMMENT '模型ID',
  `ip` varchar(255) DEFAULT '' COMMENT 'ip地址',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`aid`)
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=utf8;


-- -----------------------------
-- Table structure for `ey_guestbook_attr`
-- -----------------------------
DROP TABLE IF EXISTS `ey_guestbook_attr`;
CREATE TABLE `ey_guestbook_attr` (
  `guest_attr_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '留言表单id自增',
  `aid` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '留言id',
  `attr_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '表单id',
  `attr_value` text COMMENT '表单值',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`guest_attr_id`),
  KEY `attr_id` (`attr_id`) USING BTREE,
  KEY `guest_id` (`aid`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=16 DEFAULT CHARSET=utf8 COMMENT='留言表单属性值';


-- -----------------------------
-- Table structure for `ey_guestbook_attribute`
-- -----------------------------
DROP TABLE IF EXISTS `ey_guestbook_attribute`;
CREATE TABLE `ey_guestbook_attribute` (
  `attr_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '表单id',
  `attr_name` varchar(60) DEFAULT '' COMMENT '表单名称',
  `typeid` int(11) unsigned DEFAULT '0' COMMENT '栏目ID',
  `attr_input_type` tinyint(1) unsigned DEFAULT '0' COMMENT ' 0=文本框，1=下拉框，2=多行文本框',
  `attr_values` text COMMENT '可选值列表',
  `sort_order` int(11) unsigned DEFAULT '0' COMMENT '表单排序',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `is_del` tinyint(1) DEFAULT '0' COMMENT '是否已删除，0=否，1=是',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`attr_id`),
  KEY `guest_id` (`typeid`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COMMENT='留言表单属性';

-- -----------------------------
-- Records of `ey_guestbook_attribute`
-- -----------------------------
INSERT INTO `ey_guestbook_attribute` VALUES ('1', '姓名', '7', '0', '', '100', 'cn', '0', '1533612170', '1533612170');
INSERT INTO `ey_guestbook_attribute` VALUES ('2', '留言内容', '7', '2', '', '100', 'cn', '0', '1533612191', '1533612191');
INSERT INTO `ey_guestbook_attribute` VALUES ('3', '手机号码', '7', '0', '', '100', 'cn', '0', '1533612201', '1533612201');

-- -----------------------------
-- Table structure for `ey_hooks`
-- -----------------------------
DROP TABLE IF EXISTS `ey_hooks`;
CREATE TABLE `ey_hooks` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键',
  `name` varchar(50) NOT NULL DEFAULT '' COMMENT '钩子名称',
  `description` text COMMENT '描述',
  `module` varchar(50) DEFAULT '' COMMENT '钩子挂载的插件',
  `status` tinyint(1) unsigned DEFAULT '1' COMMENT '状态：0=无效，1=有效',
  `add_time` int(10) DEFAULT NULL,
  `update_time` int(10) unsigned DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `name` (`name`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


-- -----------------------------
-- Table structure for `ey_images_content`
-- -----------------------------
DROP TABLE IF EXISTS `ey_images_content`;
CREATE TABLE `ey_images_content` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `aid` int(10) DEFAULT '0' COMMENT '文档ID',
  `content` longtext COMMENT '内容详情',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `news_id` (`aid`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='资讯内容表_存储正常内容';


-- -----------------------------
-- Table structure for `ey_images_upload`
-- -----------------------------
DROP TABLE IF EXISTS `ey_images_upload`;
CREATE TABLE `ey_images_upload` (
  `img_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `aid` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '图集ID',
  `title` varchar(200) DEFAULT '' COMMENT '产品标题',
  `image_url` varchar(255) DEFAULT '' COMMENT '文件存储路径',
  `width` int(11) DEFAULT '0' COMMENT '图片宽度',
  `height` int(11) DEFAULT '0' COMMENT '图片高度',
  `filesize` mediumint(8) unsigned DEFAULT '0' COMMENT '文件大小',
  `mime` varchar(50) DEFAULT '' COMMENT '图片类型',
  `sort_order` smallint(5) DEFAULT '0' COMMENT '排序',
  `add_time` int(10) unsigned DEFAULT '0' COMMENT '上传时间',
  PRIMARY KEY (`img_id`),
  KEY `arcid` (`aid`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


-- -----------------------------
-- Table structure for `ey_language`
-- -----------------------------
DROP TABLE IF EXISTS `ey_language`;
CREATE TABLE `ey_language` (
  `id` int(10) NOT NULL AUTO_INCREMENT COMMENT '信息ID，自增',
  `title` varchar(100) NOT NULL DEFAULT '' COMMENT '语言名称',
  `mark` varchar(50) NOT NULL DEFAULT '' COMMENT '语言标识（唯一）',
  `url` varchar(200) NOT NULL DEFAULT '' COMMENT '单独域名(外部链接)',
  `target` tinyint(1) NOT NULL DEFAULT '0' COMMENT '新窗口打开，0=否，1=是',
  `is_home_default` tinyint(1) DEFAULT '0' COMMENT '默认前台语言，1=是，0=否',
  `is_admin_default` tinyint(1) DEFAULT '0' COMMENT '默认后台语言，1=是，0=否',
  `syn_pack_id` int(10) DEFAULT '0' COMMENT '最后一次同步官方语言包ID',
  `status` tinyint(1) NOT NULL DEFAULT '0' COMMENT '语言状态，0=关闭，1=开启',
  `sort_order` int(10) DEFAULT '0' COMMENT '排序号',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COMMENT='多语言主表';

-- -----------------------------
-- Records of `ey_language`
-- -----------------------------
INSERT INTO `ey_language` VALUES ('1', '简体中文', 'cn', '', '0', '1', '1', '24', '1', '100', '1541583096', '1543890743');

-- -----------------------------
-- Table structure for `ey_language_attr`
-- -----------------------------
DROP TABLE IF EXISTS `ey_language_attr`;
CREATE TABLE `ey_language_attr` (
  `id` int(10) NOT NULL AUTO_INCREMENT COMMENT '信息ID，自增',
  `attr_name` varchar(200) NOT NULL DEFAULT '' COMMENT '来自ey_weapp_language_attr表的attr_name',
  `attr_value` text NOT NULL COMMENT '变量值',
  `attr_group` varchar(50) DEFAULT '' COMMENT '分组，以表名划分（不含表前缀）',
  `lang` varchar(50) NOT NULL DEFAULT '' COMMENT '所属语言',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `attr_value` (`attr_name`,`lang`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='多语言模板变量关联绑定表';


-- -----------------------------
-- Table structure for `ey_language_attribute`
-- -----------------------------
DROP TABLE IF EXISTS `ey_language_attribute`;
CREATE TABLE `ey_language_attribute` (
  `attr_id` int(10) NOT NULL AUTO_INCREMENT COMMENT '信息ID，自增',
  `attr_title` varchar(200) NOT NULL DEFAULT '' COMMENT '变量标题',
  `attr_name` varchar(200) NOT NULL DEFAULT '' COMMENT '变量名称',
  `attr_group` varchar(50) DEFAULT '' COMMENT '分组，以表名划分（不含表前缀）',
  `is_del` tinyint(1) DEFAULT '0' COMMENT '伪删除，0=否，1=是',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`attr_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='多语言模板变量表';


-- -----------------------------
-- Table structure for `ey_language_mark`
-- -----------------------------
DROP TABLE IF EXISTS `ey_language_mark`;
CREATE TABLE `ey_language_mark` (
  `id` int(10) NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `title` varchar(50) NOT NULL DEFAULT '' COMMENT '国家语言名称',
  `cn_title` varchar(50) NOT NULL DEFAULT '' COMMENT '中文名称',
  `mark` varchar(50) DEFAULT '' COMMENT '多语言标识',
  `pinyin` varchar(100) DEFAULT '' COMMENT '拼音',
  `sort_order` int(10) NOT NULL DEFAULT '0' COMMENT '排序号',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=57 DEFAULT CHARSET=utf8 COMMENT='国家语言表';

-- -----------------------------
-- Records of `ey_language_mark`
-- -----------------------------
INSERT INTO `ey_language_mark` VALUES ('1', '简体中文', '简体中文', 'cn', 'zhongwenjianti', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('2', 'Vietnamese', '越南语', 'vi', 'yuenanyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('3', '繁体中文', '繁体中文', 'zh', 'zhongwenfanti', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('4', 'English', '英语', 'en', 'yingyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('5', 'Indonesian', '印尼语', 'id', 'yinniyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('6', 'Urdu', '乌尔都语', 'ur', 'wuerduyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('7', 'Yiddish', '意第绪语', 'yi', 'yidixuyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('8', 'Italian', '意大利语', 'it', 'yidaliyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('9', 'Greek', '希腊语', 'el', 'xilayu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('10', 'Spanish Basque', '西班牙的巴斯克语', 'eu', 'xibanyadebasikeyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('11', 'Spanish', '西班牙语', 'es', 'xibanyayu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('12', 'Hungarian', '匈牙利语', 'hu', 'xiongyaliyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('13', 'Hebrew', '希伯来语', 'iw', 'xibolaiyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('14', 'Ukrainian', '乌克兰语', 'uk', 'wukelanyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('15', 'Welsh', '威尔士语', 'cy', 'weiershiyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('16', 'Thai', '泰语', 'th', 'taiyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('17', 'Turkish', '土耳其语', 'tr', 'tuerqiyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('18', 'Swahili', '斯瓦希里语', 'sw', 'siwaxiliyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('19', 'Japanese', '日语', 'ja', 'riyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('20', 'Swedish', '瑞典语', 'sv', 'ruidianyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('21', 'Serbian', '塞尔维亚语', 'sr', 'saierweiyayu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('22', 'Slovak', '斯洛伐克语', 'sk', 'siluofakeyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('23', 'Slovenian', '斯洛文尼亚语', 'sl', 'siluowenniyayu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('24', 'Portuguese', '葡萄牙语', 'pt', 'putaoyayu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('25', 'Norwegian', '挪威语', 'no', 'nuoweiyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('26', 'Macedonian', '马其顿语', 'mk', 'maqidunyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('27', 'Malay', '马来语', 'ms', 'malaiyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('28', 'Maltese', '马耳他语', 'mt', 'maertayu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('29', 'Romanian', '罗马尼亚语', 'ro', 'luomaniyayu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('30', 'Lithuanian', '立陶宛语', 'lt', 'litaowanyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('31', 'Latvian', '拉脱维亚语', 'lv', 'latuoweiyayu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('32', 'Latin', '拉丁语', 'la', 'ladingyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('33', 'Croatian', '克罗地亚语', 'hr', 'keluodiyayu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('34', 'Czech', '捷克语', 'cs', 'jiekeyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('35', 'Catalan', '加泰罗尼亚语', 'ca', 'jiatailuoniyayu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('36', 'Galician', '加利西亚语', 'gl', 'jialixiyayu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('37', 'Dutch', '荷兰语', 'nl', 'helanyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('38', 'Korean', '韩语', 'ko', 'hanyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('39', 'Haitian Creole', '海地克里奥尔语', 'ht', 'haidikeliaoeryu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('40', 'Finnish', '芬兰语', 'fi', 'fenlanyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('41', 'Filipino', '菲律宾语', 'tl', 'feilvbinyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('42', 'Russian', '俄语', 'ru', 'eyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('43', 'Boolean (Afrikaans)', '布尔语(南非荷兰语)', 'af', 'bueryunanfeihelanyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('44', 'French', '法语', 'fr', 'fayu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('45', 'Danish', '丹麦语', 'da', 'danmaiyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('46', 'German', '德语', 'de', 'deyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('47', 'Azerbaijani', '阿塞拜疆语', 'az', 'asaibaijiangyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('48', 'Irish', '爱尔兰语', 'ga', 'aierlanyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('49', 'Estonian', '爱沙尼亚语', 'et', 'aishaniyayu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('50', 'Belarusian', '白俄罗斯语', 'be', 'baieluosiyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('51', 'Bulgarian', '保加利亚语', 'bg', 'baojialiyayu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('52', 'Icelandic', '冰岛语', 'is', 'bingdaoyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('53', 'Polish', '波兰语', 'pl', 'bolanyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('54', 'Persian', '波斯语', 'fa', 'bosiyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('55', 'Arabic', '阿拉伯语', 'ar', 'alaboyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('56', 'Albanian', '阿尔巴尼亚语', 'sq', 'aerbaniyayu', '100', '0', '1541583096');

-- -----------------------------
-- Table structure for `ey_language_pack`
-- -----------------------------
DROP TABLE IF EXISTS `ey_language_pack`;
CREATE TABLE `ey_language_pack` (
  `id` int(10) NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `name` varchar(50) NOT NULL DEFAULT '' COMMENT '变量名',
  `value` text NOT NULL COMMENT '变量值',
  `is_syn` tinyint(1) DEFAULT '0' COMMENT '同步官方语言包：0=否，1=是',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `sort_order` int(10) DEFAULT '0' COMMENT '排序号',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=13 DEFAULT CHARSET=utf8 COMMENT='模板语言包变量';

-- -----------------------------
-- Records of `ey_language_pack`
-- -----------------------------
INSERT INTO `ey_language_pack` VALUES ('1', 'sys1', '首页', '1', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_language_pack` VALUES ('2', 'sys2', '上一页', '1', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_language_pack` VALUES ('3', 'sys3', '下一页', '1', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_language_pack` VALUES ('4', 'sys4', '末页', '1', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_language_pack` VALUES ('5', 'sys5', '共<strong>%s</strong>页 <strong>%s</strong>条', '1', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_language_pack` VALUES ('6', 'sys6', '全部', '1', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_language_pack` VALUES ('7', 'sys7', '搜索', '1', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_language_pack` VALUES ('8', 'sys8', '查看详情', '1', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_language_pack` VALUES ('9', 'sys9', '网站首页', '1', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_language_pack` VALUES ('10', 'sys10', '暂无', '1', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_language_pack` VALUES ('11', 'sys11', '上一篇', '1', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_language_pack` VALUES ('12', 'sys12', '下一篇', '1', 'cn', '100', '1543890216', '1543890216');

-- -----------------------------
-- Table structure for `ey_links`
-- -----------------------------
DROP TABLE IF EXISTS `ey_links`;
CREATE TABLE `ey_links` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `typeid` tinyint(1) DEFAULT '1' COMMENT '类型：1=文字链接，2=图片链接',
  `title` varchar(50) DEFAULT '' COMMENT '网站标题',
  `url` varchar(100) DEFAULT '' COMMENT '网站地址',
  `logo` varchar(255) DEFAULT '' COMMENT '网站LOGO',
  `sort_order` int(11) DEFAULT '0' COMMENT '排序号',
  `target` tinyint(1) DEFAULT '0' COMMENT '是否开启浏览器新窗口',
  `email` varchar(50) DEFAULT NULL,
  `intro` text COMMENT '网站简况',
  `status` tinyint(1) DEFAULT '1' COMMENT '状态(1=显示，0=屏蔽)',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `delete_time` int(11) DEFAULT '0' COMMENT '软删除时间',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;

-- -----------------------------
-- Records of `ey_links`
-- -----------------------------
INSERT INTO `ey_links` VALUES ('1', '1', '易优cms', 'http://www.eyoucms.com/', '', '100', '1', '', '', '1', 'cn', '0', '1533550678', '1535529160');
INSERT INTO `ey_links` VALUES ('2', '1', '微信小程序开发教程', 'http://www.yiyongtong.com/', '', '100', '1', '', '', '1', 'cn', '0', '1533550745', '1533550745');
INSERT INTO `ey_links` VALUES ('3', '1', '素材58', 'http://www.sucai58.com/', '', '100', '1', '', '', '1', 'cn', '0', '1533550767', '1533550767');
INSERT INTO `ey_links` VALUES ('4', '1', '区块链是什么', 'http://www.yiyocms.com/', '', '100', '1', '', '', '1', 'cn', '0', '1533550789', '1533550789');

-- -----------------------------
-- Table structure for `ey_product_attr`
-- -----------------------------
DROP TABLE IF EXISTS `ey_product_attr`;
CREATE TABLE `ey_product_attr` (
  `product_attr_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '产品属性id自增',
  `aid` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '产品id',
  `attr_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '属性id',
  `attr_value` text COMMENT '属性值',
  `attr_price` varchar(255) DEFAULT '' COMMENT '属性价格',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`product_attr_id`),
  KEY `aid` (`aid`) USING BTREE,
  KEY `attr_id` (`attr_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


-- -----------------------------
-- Table structure for `ey_product_attribute`
-- -----------------------------
DROP TABLE IF EXISTS `ey_product_attribute`;
CREATE TABLE `ey_product_attribute` (
  `attr_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '属性id',
  `attr_name` varchar(60) DEFAULT '' COMMENT '属性名称',
  `typeid` int(11) unsigned DEFAULT '0' COMMENT '栏目id',
  `attr_index` tinyint(1) unsigned DEFAULT '0' COMMENT '0不需要检索 1关键字检索 2范围检索',
  `attr_input_type` tinyint(1) unsigned DEFAULT '0' COMMENT ' 0=文本框，1=下拉框，2=多行文本框',
  `attr_values` text COMMENT '可选值列表',
  `sort_order` int(11) unsigned DEFAULT '0' COMMENT '属性排序',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `is_del` tinyint(1) DEFAULT '0' COMMENT '是否已删除，0=否，1=是',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`attr_id`),
  KEY `cat_id` (`typeid`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


-- -----------------------------
-- Table structure for `ey_product_content`
-- -----------------------------
DROP TABLE IF EXISTS `ey_product_content`;
CREATE TABLE `ey_product_content` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `aid` int(10) DEFAULT '0' COMMENT '文档ID',
  `content` longtext COMMENT '内容详情',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `news_id` (`aid`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='资讯内容表_存储正常内容';


-- -----------------------------
-- Table structure for `ey_product_img`
-- -----------------------------
DROP TABLE IF EXISTS `ey_product_img`;
CREATE TABLE `ey_product_img` (
  `img_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `aid` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '产品ID',
  `title` varchar(200) DEFAULT '' COMMENT '产品标题',
  `image_url` varchar(255) DEFAULT '' COMMENT '文件存储路径',
  `width` int(11) DEFAULT '0' COMMENT '图片宽度',
  `height` int(11) DEFAULT '0' COMMENT '图片高度',
  `filesize` varchar(255) DEFAULT '' COMMENT '文件大小',
  `mime` varchar(50) DEFAULT '' COMMENT '图片类型',
  `sort_order` smallint(5) DEFAULT '0' COMMENT '排序',
  `add_time` int(10) unsigned DEFAULT '0' COMMENT '上传时间',
  PRIMARY KEY (`img_id`),
  KEY `arcid` (`aid`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


-- -----------------------------
-- Table structure for `ey_single_content`
-- -----------------------------
DROP TABLE IF EXISTS `ey_single_content`;
CREATE TABLE `ey_single_content` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `aid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '文档ID',
  `typeid` int(10) DEFAULT '0' COMMENT '栏目ID',
  `content` longtext COMMENT '内容详情',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `aid` (`aid`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

-- -----------------------------
-- Records of `ey_single_content`
-- -----------------------------
INSERT INTO `ey_single_content` VALUES ('1', '1', '1', '&lt;p&gt;&lt;br/&gt;&lt;/p&gt;&lt;p&gt;我们的服务宗旨：&lt;/p&gt;&lt;p&gt;&amp;nbsp;专业，速度，诚信&lt;br/&gt;&lt;/p&gt;&lt;p&gt;服务项目：&lt;br/&gt;&lt;/p&gt;&lt;p&gt;1、全职外教推荐及外教管理：&lt;br/&gt;&lt;/p&gt;&lt;p&gt;&amp;nbsp;随着教学的发展，学校对英语的教学不仅侧重于应试，同时也增加了学生语言应用能力的培养，学校聘请外教人数逐年增多。我公司专业为国内大、中、小及语言培训学校提供符合要求的优质外教资源，外教筛选，初步面试，中间沟通协调，直到外教到位。&lt;br/&gt;&lt;/p&gt;&lt;p&gt;&amp;nbsp;&amp;nbsp;&amp;nbsp; 长期管理型：外教来华后的管理工作例如发放工资、补助、协调关系等由我公司负责，用人单位每月将外教的工资、津贴打入我公司账号，然后由我们支付。我们与聘用单位共同管理专家(外教)，避免其随意辞职或者不遵守规章制度等。&lt;br style=&quot;padding: 0px; margin: 0px;&quot;/&gt;&lt;/p&gt;&lt;p&gt;&amp;nbsp;&lt;/p&gt;&lt;p&gt;2、企业培训、及外籍员工推荐。随着中国企业的国际化程度的提高，对员工的语言要求也逐渐提高，我们专业从事企业英语培训，经验丰富的商务英语外教，根据企业实际情况制订专业的培训计划。&lt;/p&gt;&lt;p&gt;&amp;nbsp;&lt;/p&gt;&lt;p&gt;3、一对一及小班外语培训。一对一外教的优势在于上课时间、地点、教材随机选择，真正体现个性化教学理念，专业的外教顾问随时为您服务，解决您学习中的任何问题。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;', '1533541630', '1534403477');
INSERT INTO `ey_single_content` VALUES ('2', '2', '8', '&lt;div style=&quot;text-align: center;&quot;&gt;手机：1888888999&lt;/div&gt;&lt;div style=&quot;text-align: center;&quot;&gt;电话：0898-999-888&lt;/div&gt;&lt;div style=&quot;text-align: center;&quot;&gt;邮箱：893639163&lt;/div&gt;&lt;div style=&quot;text-align: center;&quot;&gt;地址：海南海口&lt;/div&gt;&lt;p style=&quot;text-align: center;&quot;&gt;&lt;iframe class=&quot;ueditor_baidumap&quot; src=&quot;http://127.0.0.3/public/plugins/Ueditor/dialogs/map/show.html#center=117.655016,40.936091&amp;zoom=7&amp;width=530&amp;height=340&amp;markers=116.404,39.915&amp;markerStyles=l,A&quot; frameborder=&quot;0&quot; width=&quot;534&quot; height=&quot;344&quot;&gt;&lt;/iframe&gt;&lt;/p&gt;', '1535531150', '1535531150');
INSERT INTO `ey_single_content` VALUES ('3', '27', '13', '&lt;h3&gt;严选每一位教师&amp;nbsp; 严把教学质量关&lt;/h3&gt;&lt;p&gt;· 每一名外教都有本科及以上学历，有过教学经验和商业背景&lt;/p&gt;&lt;p&gt;· 每一名外教要在总部接受60天封闭培训，最后再经过六轮筛选&lt;/p&gt;&lt;p&gt;· 拥有TEFL和TESOL国际权威认证和外籍专家证&lt;/p&gt;&lt;p&gt;· 口音纯正，来自以英语为母语的国家&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;', '1534151326', '1534318765');

-- -----------------------------
-- Table structure for `ey_tagindex`
-- -----------------------------
DROP TABLE IF EXISTS `ey_tagindex`;
CREATE TABLE `ey_tagindex` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `tag` varchar(50) NOT NULL DEFAULT '' COMMENT 'tag内容',
  `typeid` smallint(5) unsigned NOT NULL DEFAULT '0',
  `count` int(10) unsigned DEFAULT '0',
  `total` int(10) unsigned DEFAULT '0',
  `weekcc` int(10) unsigned DEFAULT '0',
  `monthcc` int(10) unsigned DEFAULT '0',
  `weekup` int(10) unsigned DEFAULT '0',
  `monthup` int(10) unsigned DEFAULT '0',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(10) unsigned DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `typeid` (`typeid`) USING BTREE,
  KEY `count` (`count`,`total`,`weekcc`,`monthcc`,`weekup`,`monthup`,`add_time`) USING BTREE,
  KEY `tag` (`tag`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


-- -----------------------------
-- Table structure for `ey_taglist`
-- -----------------------------
DROP TABLE IF EXISTS `ey_taglist`;
CREATE TABLE `ey_taglist` (
  `tid` int(10) unsigned NOT NULL DEFAULT '0',
  `aid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '文章ID',
  `typeid` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT '栏目ID',
  `tag` varchar(50) DEFAULT '' COMMENT 'tag内容',
  `arcrank` tinyint(1) DEFAULT '0' COMMENT '阅读权限',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`tid`,`aid`),
  KEY `aid` (`aid`,`typeid`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='文章标签表';


-- -----------------------------
-- Table structure for `ey_ui_config`
-- -----------------------------
DROP TABLE IF EXISTS `ey_ui_config`;
CREATE TABLE `ey_ui_config` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '表id',
  `md5key` varchar(100) NOT NULL DEFAULT '' COMMENT '唯一键值（由 theme_style、page、name）组成',
  `theme_style` varchar(20) DEFAULT 'pc' COMMENT '模板风格',
  `page` varchar(64) DEFAULT '' COMMENT '页面分组',
  `type` varchar(50) DEFAULT '' COMMENT '编辑类型',
  `name` varchar(50) DEFAULT '' COMMENT '与页面的e-id对应',
  `value` text COMMENT '页面美化的val值',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  UNIQUE KEY `md5key` (`md5key`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='页面美化参数设置';


-- -----------------------------
-- Table structure for `ey_weapp`
-- -----------------------------
DROP TABLE IF EXISTS `ey_weapp`;
CREATE TABLE `ey_weapp` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `code` varchar(50) DEFAULT '' COMMENT '插件标识',
  `name` varchar(55) DEFAULT '' COMMENT '中文名字',
  `config` text COMMENT '配置信息',
  `data` text COMMENT '额外序列化存储数据，简单插件可以不创建表，存储这里即可',
  `status` tinyint(1) DEFAULT '0' COMMENT '状态：0=未安装，1=启用，-1=禁用',
  `tag_weapp` tinyint(1) DEFAULT '1' COMMENT '1=自动绑定，2=手工调用。关联模板标签weapp，自动调用内置的show钩子方法',
  `thorough` tinyint(1) DEFAULT '0' COMMENT '彻底卸载：0=是，1=否',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `code` (`code`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

