<%

function GuDataStatusText(GuDataStatusCode)

	if trim(GuDataStatusCode)="" or isNull(GuDataStatusCode)=true then
		GuDataStatusText="--"
		exit function
	end if

	select case GuDataStatusCode
	case "Approve"
		GuDataStatusText="ͨ"
	case "Approving"
		GuDataStatusText=""
	case "Delete"
		GuDataStatusText="ɾ[ע]"
	case "Disabled"
		GuDataStatusText=""
	case "Enabled"
		GuDataStatusText=""
	case "Expire"
		GuDataStatusText=""
	case "Hidden"
		GuDataStatusText=""
	case "Normal"
		GuDataStatusText=""
	case "Read"
		GuDataStatusText="Ѷ"
	case "Show"
		GuDataStatusText="ʾ"
	case "Wait"
		GuDataStatusText="ȴ"
	case "Unread"
		GuDataStatusText="δ"
	case "Used"
		GuDataStatusText=""
	case else
		GuDataStatusText="--"
	end select

	GuDataStatusText=GuDataStatusText

end function


function GuDateTimeInitialization(GuObjectType,GuObjectNumerical,GuYearFormerDigit,GuYearAfterDigit)

	if trim(GuObjectType)="" or isNull(GuObjectType)=true then
		GuDateTimeInitialization="0"
		exit function
	end if

	if GuObjectType="Year" then

		dim GuDateTimeYear
		if trim(GuObjectNumerical)="" or isNull(GuObjectNumerical)=true or isNumeric(GuObjectNumerical)=false or len(GuObjectNumerical)<>4 then
			GuDateTimeYear=year(now())
		else
			GuDateTimeYear=GuObjectNumerical
		end if

		if year(now())-GuDateTimeYear>=80 then
			GuDateTimeYear=year(now())-20
		end if

		if trim(GuYearFormerDigit)="" or isNull(GuYearFormerDigit)=true or isNumeric(GuYearFormerDigit)=false or len(GuYearFormerDigit)>=3 then
			GuYearFormerDigit=1
		else
			GuYearFormerDigit=GuYearFormerDigit
		end if

		if year(now())-(GuDateTimeYear-GuYearFormerDigit)>=80 then
			GuYearFormerDigit=GuDateTimeYear-(year(now())-80)
		end if

		if trim(GuYearAfterDigit)="" or isNull(GuYearAfterDigit)=true or isNumeric(GuYearAfterDigit)=false or len(GuYearAfterDigit)>=3 then
			GuYearAfterDigit=1
		else
			GuYearAfterDigit=GuYearAfterDigit
		end if

		if GuYearFormerDigit>=1 then
		for YY=GuDateTimeYear-GuYearFormerDigit to GuDateTimeYear-1 step 1
			GuDateTimeInitialization=GuDateTimeInitialization&"<option value="""&YY&""">"&YY&"</option>"
		next
		end if

			GuDateTimeInitialization=GuDateTimeInitialization&"<option value="""&GuDateTimeYear&""" selected=""selected"">"&GuDateTimeYear&"</option>"

		if GuYearAfterDigit>=1 then
		for YY=GuDateTimeYear+1 to GuDateTimeYear+GuYearAfterDigit step 1
			GuDateTimeInitialization=GuDateTimeInitialization&"<option value="""&YY&""">"&YY&"</option>"
		next
		end if

		if (GuDateTimeYear+GuYearAfterDigit)<=year(now()) then
		for YY=GuDateTimeYear+GuYearAfterDigit+1 to year(now())+GuYearAfterDigit step 1
			GuDateTimeInitialization=GuDateTimeInitialization&"<option value="""&YY&""">"&YY&"</option>"
		next
		end if

	end if

	if GuObjectType="Month" then

		dim GuDateTimeMonth,GuSelectedMonth
		if trim(GuObjectNumerical)="" or isNull(GuObjectNumerical)=true or isNumeric(GuObjectNumerical)=false or len(GuObjectNumerical)>=3 then
			GuDateTimeMonth=month(now())
		else
			GuDateTimeMonth=GuObjectNumerical
		end if

		if GuDateTimeMonth<=0 or GuDateTimeMonth>=13 then
			GuDateTimeMonth=1
		end if

		for MM=1 to 12 step 1
			if MM=GuDateTimeMonth then
				GuSelectedMonth="selected=""selected"""
			else
				GuSelectedMonth=""
			end if
			GuDateTimeInitialization=GuDateTimeInitialization&"<option value="""&MM&""" "&GuSelectedMonth&">"&MM&"</option>"
		next

	end if

	if GuObjectType="Day" then

		dim GuDateTimeDay,GuSelectedDay
		if trim(GuObjectNumerical)="" or isNull(GuObjectNumerical)=true or isNumeric(GuObjectNumerical)=false or len(GuObjectNumerical)>=3 then
			GuDateTimeDay=day(now())
		else
			GuDateTimeDay=GuObjectNumerical
		end if

		if GuDateTimeDay<=0 or GuDateTimeDay>=32 then
			GuDateTimeMonth=1
		end if

		for DD=1 to 31 step 1
			if DD=GuDateTimeDay then
				GuSelectedDay="selected=""selected"""
			else
				GuSelectedDay=""
			end if
			GuDateTimeInitialization=GuDateTimeInitialization&"<option value="""&DD&""" "&GuSelectedDay&">"&DD&"</option>"
		next

	end if

	if GuObjectType="Hour" then

		dim GuDateTimeHour,GuSelectedHour
		if trim(GuObjectNumerical)="" or isNull(GuObjectNumerical)=true or isNumeric(GuObjectNumerical)=false or len(GuObjectNumerical)>=3 then
			GuDateTimeHour=hour(now())
		else
			GuDateTimeHour=GuObjectNumerical
		end if

		if GuDateTimeHour<=0 or GuDateTimeHour>=24 then
			GuDateTimeHour=1
		end if

		for HH=0 to 23 step 1
			if HH=GuDateTimeHour then
				GuSelectedHour="selected=""selected"""
			else
				GuSelectedHour=""
			end if
			GuDateTimeInitialization=GuDateTimeInitialization&"<option value="""&HH&""" "&GuSelectedHour&">"&HH&"</option>"
		next

	end if

	if GuObjectType="Minute" then

		dim GuDateTimeMinute,GuSelectedMinute
		if trim(GuObjectNumerical)="" or isNull(GuObjectNumerical)=true or isNumeric(GuObjectNumerical)=false or len(GuObjectNumerical)>=3 then
			GuDateTimeMinute=minute(now())
		else
			GuDateTimeMinute=GuObjectNumerical
		end if

		if GuDateTimeMinute<=0 or GuDateTimeMinute>=60 then
			GuDateTimeMinute=1
		end if

		for MM=0 to 59 step 1
			if MM=GuDateTimeMinute then
				GuSelectedMinute="selected=""selected"""
			else
				GuSelectedMinute=""
			end if
			GuDateTimeInitialization=GuDateTimeInitialization&"<option value="""&MM&""" "&GuSelectedMinute&">"&MM&"</option>"
		next

	end if

	if GuObjectType="Second" then

		dim GuDateTimeSecond,GuSelectedSecond
		if trim(GuObjectNumerical)="" or isNull(GuObjectNumerical)=true or isNumeric(GuObjectNumerical)=false or len(GuObjectNumerical)>=3 then
			GuDateTimeSecond=second(now())
		else
			GuDateTimeSecond=GuObjectNumerical
		end if

		if GuDateTimeSecond<=0 or GuDateTimeSecond>=60 then
			GuDateTimeSecond=1
		end if

		for SS=0 to 59 step 1
			if SS=GuDateTimeSecond then
				GuSelectedSecond="selected=""selected"""
			else
				GuSelectedSecond=""
			end if
			GuDateTimeInitialization=GuDateTimeInitialization&"<option value="""&SS&""" "&GuSelectedSecond&">"&SS&"</option>"
		next

	end if

	GuDateTimeInitialization=GuDateTimeInitialization

end function


function GuDateTimeVerify(GuObjectNumerical)

	if trim(GuObjectNumerical)="" or isNull(GuObjectNumerical)=true or (instr(GuObjectNumerical,"-")<=0 and instr(GuObjectNumerical,":")<=0) then
		GuDateTimeVerify=now()
		exit function
	end if

	if instr(split(GuObjectNumerical&" 0"," ")(0),"-")>=1 then

		dim GuDateTimeYear,GuDateTimeMonth,GuDateTimeDay

		GuDateTimeYear=split(split(GuObjectNumerical&" 0"," ")(0),"-")(0)
		if trim(GuDateTimeYear)="" or isNull(GuDateTimeYear)=true or isNumeric(GuDateTimeYear)=false or len(GuDateTimeYear)<>4 then
			GuDateTimeYear=year(now())
		else
			if GuDateTimeYear<=1900 or GuDateTimeYear>=2100 then
				GuDateTimeYear=year(now())
			else
				GuDateTimeYear=GuDateTimeYear
			end if
		end if

		GuDateTimeMonth=split(split(GuObjectNumerical&" 0"," ")(0),"-")(1)
		if trim(GuDateTimeMonth)="" or isNull(GuDateTimeMonth)=true or isNumeric(GuDateTimeMonth)=false or len(GuDateTimeMonth)>=3 then
			GuDateTimeMonth=month(now())
		else
			if GuDateTimeMonth<=0 or GuDateTimeMonth>=13 then
				GuDateTimeMonth=month(now())
			else
				GuDateTimeMonth=GuDateTimeMonth
			end if
		end if

		GuDateTimeDay=split(split(GuObjectNumerical&" 0"," ")(0),"-")(2)
		if trim(GuDateTimeDay)="" or isNull(GuDateTimeDay)=true or isNumeric(GuDateTimeDay)=false or len(GuDateTimeDay)>=3 then
			GuDateTimeDay=day(now())
		else
			if GuDateTimeDay<=0 then
				GuDateTimeDay=day(now())
			else
				if (GuDateTimeMonth=1 or GuDateTimeMonth=3 or GuDateTimeMonth=5 or GuDateTimeMonth=7 or GuDateTimeMonth=8 or GuDateTimeMonth=10 or GuDateTimeMonth=12) and GuDateTimeDay>=32 then
					GuDateTimeDay=31
				elseif GuDateTimeMonth=2 and (GuDateTimeYear mod 4)<>0 and GuDateTimeDay>=29 then
					GuDateTimeDay=28
				elseif GuDateTimeMonth=2 and (GuDateTimeYear mod 4)=0 and GuDateTimeDay>=30 then
					GuDateTimeDay=29
				elseif (GuDateTimeMonth=4 or GuDateTimeMonth=6 or GuDateTimeMonth=9 or GuDateTimeMonth=11) and GuDateTimeDay>=31 then
					GuDateTimeDay=30
				else
					GuDateTimeDay=GuDateTimeDay
				end if
			end if
		end if

	end if

	if instr(split(GuObjectNumerical&" 0"," ")(1),":")>=1 then

		dim GuDateTimeHour,GuDateTimeMinute,GuDateTimeSecond

		GuDateTimeHour=split(split(GuObjectNumerical&" 0"," ")(1),":")(0)
		if trim(GuDateTimeHour)="" or isNull(GuDateTimeHour)=true or isNumeric(GuDateTimeHour)=false or len(GuDateTimeHour)>=3 then
			GuDateTimeHour=hour(now())
		else
			if GuDateTimeHour<=0 or GuDateTimeHour>=24 then
				GuDateTimeHour=0
			else
				GuDateTimeHour=GuDateTimeHour
			end if
		end if

		GuDateTimeMinute=split(split(GuObjectNumerical&" 0"," ")(1),":")(1)
		if trim(GuDateTimeMinute)="" or isNull(GuDateTimeMinute)=true or isNumeric(GuDateTimeMinute)=false or len(GuDateTimeMinute)>=3 then
			GuDateTimeMinute=minute(now())
		else
			if GuDateTimeMinute<=0 or GuDateTimeMinute>=60 then
				GuDateTimeMinute=0
			else
				GuDateTimeMinute=GuDateTimeMinute
			end if
		end if

		GuDateTimeSecond=second(now())

	end if

	if instr(split(GuObjectNumerical&" 0"," ")(0),"-")>=1 and instr(split(GuObjectNumerical&" 0"," ")(1),":")<=0 then
		GuDateTimeVerify=GuDateTimeYear&"-"&GuDateTimeMonth&"-"&GuDateTimeDay
	elseif instr(split(GuObjectNumerical&" 0"," ")(0),"-")<=0 and instr(split(GuObjectNumerical&" 0"," ")(1),":")>=1 then
		GuDateTimeVerify=GuDateTimeHour&":"&GuDateTimeMinute&":"&GuDateTimeSecond
	else
		GuDateTimeVerify=GuDateTimeYear&"-"&GuDateTimeMonth&"-"&GuDateTimeDay&" "&GuDateTimeHour&":"&GuDateTimeMinute&":"&GuDateTimeSecond
	end if

	GuDateTimeVerify=cdate(GuDateTimeVerify)

end function


function GuExplorerFolderCreate(GuFolderPath)

	if trim(GuFolderPath)="" or isNull(GuFolderPath)=true then
		GuExplorerFolderCreate=""
		exit function
	end if

	set SFCF=Server.CreateObject("Scripting.FileSystemObject")
	if SFCF.FolderExists(Server.MapPath(GuFolderPath))=false then
		SFCF.CreateFolder(Server.MapPath(GuFolderPath))
	end if
	set SFCF=nothing

	GuExplorerFolderCreate=""

end function


function GuExplorerFolderDelete(GuFolderPath)

	if trim(GuFolderPath)="" or isNull(GuFolderPath)=true then
		GuExplorerFolderDelete=""
		exit function
	end if

	set SFDF=Server.CreateObject("Scripting.FileSystemObject")
	if SFDF.FolderExists(Server.MapPath(GuFolderPath))=true then
		SFDF.DeleteFolder(Server.MapPath(GuFolderPath))
	end if
	set SFDF=nothing

	GuExplorerFolderDelete=""

end function


function GuExplorerFolderExists(GuFolderPath)

	if trim(GuFolderPath)="" or isNull(GuFolderPath)=true Then
		GuExplorerFolderExists=false
		exit function
	end if

	set SFFE=Server.CreateObject("Scripting.FileSystemObject")
	if SFFE.FolderExists(Server.MapPath(GuFolderPath))=true then
		GuExplorerFolderExists=true
	else
		GuExplorerFolderExists=false
	end if
	set SFFE=nothing

end function


function GuExplorerFolderSubFolders(GuFolderName)

	if trim(GuFolderName)="" or isNull(GuFolderName)=true then
		GuExplorerFolderSubFolders=""
		exit function
	end if

	set SFGF=Server.CreateObject("Scripting.FileSystemObject")
	set SGFF=SFGF.GetFolder(Server.MapPath(GuFolderName))
	for each SGFO in SGFF.SubFolders
		GuExplorerFolderSubFolders=SGFO.name&"|"&GuExplorerFolderSubFolders
	next
	set SGFF=nothing
	set SFGF=nothing

	if trim(GuExplorerFolderSubFolders)="|" then
		GuExplorerFolderSubFolders=""
	elseif right(GuExplorerFolderSubFolders,1)="|" then
		GuExplorerFolderSubFolders=left(GuExplorerFolderSubFolders,len(GuExplorerFolderSubFolders)-1)
	else
		GuExplorerFolderSubFolders=trim(GuExplorerFolderSubFolders)
	end if

end function


function GuExplorerFileCreate(GuFilePath,GuFileContent)

	if trim(GuFilePath)="" or isNull(GuFilePath)=true then
		GuExplorerFileCreate=""
		exit function
	end if

	if trim(GuFileContent)="" or isNull(GuFileContent)=true then
		GuFileContent=""
	else
		GuFileContent=trim(GuFileContent)
	end if

	set SFCF=Server.CreateObject("Scripting.FileSystemObject")
	set SCTF=SFCF.CreateTextFile(Server.MapPath(GuFilePath),true)
	SCTF.Write GuFileContent
	SCTF.Close
	set SCTF=nothing
	set SFCF=nothing

	GuExplorerFileCreate=""

end function


function GuExplorerFileDelete(GuFilePath)

	if trim(GuFilePath)="" or isNull(GuFilePath)=true then
		GuExplorerFileDelete=""
		exit function
	end if

	set SFDF=Server.CreateObject("Scripting.FileSystemObject")
	if SFDF.FileExists(Server.MapPath(GuFilePath))=true then
		SFDF.DeleteFile(Server.MapPath(GuFilePath))
	end if
	set SFDF=nothing

	GuExplorerFileDelete=""

end function


function GuExplorerFileExists(GuFilePath)

	if trim(GuFilePath)="" or isNull(GuFilePath)=true then
		exit function
	end if

	set SFFE=Server.CreateObject("Scripting.FileSystemObject")
	if SFFE.FileExists(Server.MapPath(GuFilePath))=true then
		GuExplorerFileExists=true
	else
		GuExplorerFileExists=false
	end if
	set SFFE=nothing

end function


function GuExplorerFileExtension(GuFileName)

	if trim(GuFileName)="" or isNull(GuFileName)=true then
		GuExplorerFileExtension=""
		exit function
	end if

	if instr(GuFileName,".")<=0 then
		GuExplorerFileExtension=""
		exit function
	end if

	dim GuResourceNameSplit
	GuResourceNameSplit=split(GuFileName,".")
	GuExplorerFileExtension=GuResourceNameSplit(ubound(GuResourceNameSplit))
	GuExplorerFileExtension=lcase(GuExplorerFileExtension)

end function


function GuExplorerFileSize(GuFileSize)

	if trim(GuFileSize)="" or isNull(GuFileSize)=true or isNumeric(GuFileSize)=false then
		GuExplorerFileSize="0 Bytes"
		exit function
	end if

	if GuFileSize<=1023 then
		GuExplorerFileSize=GuFileSize&" Bytes"
	else
		if GuFileSize>=1024 and GuFileSize<=1048552 then
			GuExplorerFileSize=GuFileSize/1024&" KB"
		else
			if GuFileSize>=1048576 and GuFileSize<=1072693248 then
				GuExplorerFileSize=GuFileSize/1024/1024&" MB"
			else
				if GuFileSize>=1073741824 then
					GuExplorerFileSize=GuFileSize/1024/1024/1024&" GB"
				else
					GuExplorerFileSize=GuFileSize&" Bytes"
				end if
			end if
		end if
	end if

end function


function GuExplorerFileIcon(GuFileType)

	if trim(GuFileType)="" or isNull(GuFileType)=true then
		GuExplorerFileIcon=""
		exit function
	end if

	select case GuFileType
	case "mdb"
		GuExplorerFileIcon="Access.png"
	case "mid","mp3","wav"
		GuExplorerFileIcon="Audio.png"
	case "asa","asp","aspx","c","cgi","jsp","php","php3","php4"
		GuExplorerFileIcon="Code.png"
	case "bat","cmd"
		GuExplorerFileIcon="Commend.png"
	case "css"
		GuExplorerFileIcon="CSS.png"
	case "xls","xlsx"
		GuExplorerFileIcon="Excel.png"
	case "exe"
		GuExplorerFileIcon="EXE.png"
	case "fla","swf"
		GuExplorerFileIcon="Flash.png"
	case "chm"
		GuExplorerFileIcon="Help.png"
	case "htm","html","mht"
		GuExplorerFileIcon="HTML.png"
	case "js"
		GuExplorerFileIcon="JavaScript.png"
	case "avi","dat","mp4","rm","rmvb"
		GuExplorerFileIcon="Media.png"
	case "pdf"
		GuExplorerFileIcon="PDF.png"
	case "bmp","gif","jpg","jpeg","png"
		GuExplorerFileIcon="Picture.png"
	case "ppt"
		GuExplorerFileIcon="PowerPoint.png"
	case "key","reg"
		GuExplorerFileIcon="Registry.png"
	case "txt","inc"
		GuExplorerFileIcon="Text.png"
	case "cab","iso","rar","uue","z","zip"
		GuExplorerFileIcon="WinZIP.png"
	case "doc","docx","wps"
		GuExplorerFileIcon="Word.png"
	case "xml"
		GuExplorerFileIcon="XML.png"
	case else
		GuExplorerFileIcon="Undefinition.png"
	end select

end function


function GuExplorerPathPresentGet()

	GuExplorerPathPresentGet=Request.ServerVariables("SCRIPT_NAME")
	GuExplorerPathPresentGet=left(GuExplorerPathPresentGet,instrrev(GuExplorerPathPresentGet,"/"))

end function


function GuFilterFolderName(GuFolderName)

	if trim(GuFolderName)="" or isNull(GuFolderName)=true then
		GuFilterFolderName=""
		exit function
	end if

	GuFilterFolderName=trim(GuFolderName)
	GuFilterFolderName=replace(GuFilterFolderName,"~","_")
	GuFilterFolderName=replace(GuFilterFolderName,"`","_")
	GuFilterFolderName=replace(GuFilterFolderName,"!","_")
	GuFilterFolderName=replace(GuFilterFolderName,"@","_")
	GuFilterFolderName=replace(GuFilterFolderName,"#","_")
	GuFilterFolderName=replace(GuFilterFolderName,"$","_")
	GuFilterFolderName=replace(GuFilterFolderName,"%","_")
	GuFilterFolderName=replace(GuFilterFolderName,"^","_")
	GuFilterFolderName=replace(GuFilterFolderName,"&","_")
	GuFilterFolderName=replace(GuFilterFolderName,"*","_")
	GuFilterFolderName=replace(GuFilterFolderName,"-","_")
	GuFilterFolderName=replace(GuFilterFolderName,"+","_")
	GuFilterFolderName=replace(GuFilterFolderName,"=","_")
	GuFilterFolderName=replace(GuFilterFolderName,"{","_")
	GuFilterFolderName=replace(GuFilterFolderName,"}","_")
	GuFilterFolderName=replace(GuFilterFolderName,":","_")
	GuFilterFolderName=replace(GuFilterFolderName,";","_")
	GuFilterFolderName=replace(GuFilterFolderName,"""","_")
	GuFilterFolderName=replace(GuFilterFolderName,"'","_")
	GuFilterFolderName=replace(GuFilterFolderName,"|","_")
	GuFilterFolderName=replace(GuFilterFolderName,"\","_")
	GuFilterFolderName=replace(GuFilterFolderName,"<","_")
	GuFilterFolderName=replace(GuFilterFolderName,",","_")
	GuFilterFolderName=replace(GuFilterFolderName,">","_")
	GuFilterFolderName=replace(GuFilterFolderName,".","_")
	GuFilterFolderName=replace(GuFilterFolderName,"?","_")
	GuFilterFolderName=replace(GuFilterFolderName,"/","_")

end function


function GuFilterFileName(GuFileName)

	if trim(GuFileName)="" or isNull(GuFileName)=true then
		GuFilterFileName=""
		exit function
	end if

	GuFilterFileName=trim(GuFileName)
	GuFilterFileName=replace(GuFilterFileName,"~","_")
	GuFilterFileName=replace(GuFilterFileName,"`","_")
	GuFilterFileName=replace(GuFilterFileName,"!","_")
	GuFilterFileName=replace(GuFilterFileName,"@","_")
	GuFilterFileName=replace(GuFilterFileName,"$","_")
	GuFilterFileName=replace(GuFilterFileName,"%","_")
	GuFilterFileName=replace(GuFilterFileName,"^","_")
	GuFilterFileName=replace(GuFilterFileName,"&","_")
	GuFilterFileName=replace(GuFilterFileName,"*","_")
	GuFilterFileName=replace(GuFilterFileName,"+","_")
	GuFilterFileName=replace(GuFilterFileName,"=","_")
	GuFilterFileName=replace(GuFilterFileName,"{","_")
	GuFilterFileName=replace(GuFilterFileName,"}","_")
	GuFilterFileName=replace(GuFilterFileName,":","_")
	GuFilterFileName=replace(GuFilterFileName,";","_")
	GuFilterFileName=replace(GuFilterFileName,"""","_")
	GuFilterFileName=replace(GuFilterFileName,"'","_")
	GuFilterFileName=replace(GuFilterFileName,"|","_")
	GuFilterFileName=replace(GuFilterFileName,"\","_")
	GuFilterFileName=replace(GuFilterFileName,"<","_")
	GuFilterFileName=replace(GuFilterFileName,",","_")
	GuFilterFileName=replace(GuFilterFileName,">","_")
	GuFilterFileName=replace(GuFilterFileName,"?","_")
	GuFilterFileName=replace(GuFilterFileName,"/","_")

end function


function GuFilterLinefeed(GuStringData)

	if trim(GuStringData)="" or isNull(GuStringData)=true then
		GuFilterLinefeed=""
		exit function
	end if

	GuFilterLinefeed=trim(GuStringData)
	GuFilterLinefeed=replace(GuFilterLinefeed,vbcrlf,"")
	GuFilterLinefeed=replace(GuFilterLinefeed,"<br>","")
	GuFilterLinefeed=replace(GuFilterLinefeed,"<BR>","")
	GuFilterLinefeed=replace(GuFilterLinefeed,"<br />","")
	GuFilterLinefeed=replace(GuFilterLinefeed,"<BR />","")
	GuFilterLinefeed=replace(GuFilterLinefeed,"<p>","")
	GuFilterLinefeed=replace(GuFilterLinefeed,"<P>","")
	GuFilterLinefeed=replace(GuFilterLinefeed,"</p>","")
	GuFilterLinefeed=replace(GuFilterLinefeed,"</P>","")

end function


function GuFilterHTML(GuStringData)

	if trim(GuStringData)="" or isNull(GuStringData)=true then
		GuFilterHTML=""
		exit function
	end if

	dim REFH
	set REFH=New RegExp
	REFH.Global=true
	REFH.Pattern="<[^>]*>"
	GuFilterHTML=REFH.replace(GuStringData,"")
	REFH.Pattern="&.\w+;"
	GuFilterHTML=REFH.replace(GuFilterHTML,"")
	set REFH=nothing

end function


function GuFilterID(GuID)

	if trim(GuID)="" or isNull(GuID)=true then
		GuFilterID=""
		exit function
	end if

	GuFilterID=trim(GuID)
	GuFilterID=replace(GuFilterID,"~","")
	GuFilterID=replace(GuFilterID,"`","")
	GuFilterID=replace(GuFilterID,"!","")
	GuFilterID=replace(GuFilterID,"@","")
	GuFilterID=replace(GuFilterID,"#","")
	GuFilterID=replace(GuFilterID,"$","")
	GuFilterID=replace(GuFilterID,"%","")
	GuFilterID=replace(GuFilterID,"^","")
	GuFilterID=replace(GuFilterID,"&","")
	GuFilterID=replace(GuFilterID,"*","")
	GuFilterID=replace(GuFilterID,"(","")
	GuFilterID=replace(GuFilterID,")","")
	GuFilterID=replace(GuFilterID,"_","")
	GuFilterID=replace(GuFilterID,"-","")
	GuFilterID=replace(GuFilterID,"+","")
	GuFilterID=replace(GuFilterID,"=","")
	GuFilterID=replace(GuFilterID,"{","")
	GuFilterID=replace(GuFilterID,"[","")
	GuFilterID=replace(GuFilterID,"}","")
	GuFilterID=replace(GuFilterID,"]","")
	GuFilterID=replace(GuFilterID,":","")
	GuFilterID=replace(GuFilterID,";","")
	GuFilterID=replace(GuFilterID,"""","")
	GuFilterID=replace(GuFilterID,"'","")
	GuFilterID=replace(GuFilterID,"|","")
	GuFilterID=replace(GuFilterID,"\","")
	GuFilterID=replace(GuFilterID,"<","")
	GuFilterID=replace(GuFilterID,",","")
	GuFilterID=replace(GuFilterID,">","")
	GuFilterID=replace(GuFilterID,".","")
	GuFilterID=replace(GuFilterID,"?","")
	GuFilterID=replace(GuFilterID,"/","")
	GuFilterID=replace(GuFilterID," ","")

end function


function GuImageDimensionProportion(GuTableWidth,GuTableHeight,GuImageWidth,GuImageHeight,GuDimensionType)

	if trim(GuTableWidth)="" or isNull(GuTableWidth)=true or trim(GuTableHeight)="" or isNull(GuTableHeight)=true then
		GuImageDimensionProportion="16"
		exit function
	end if

	if trim(GuImageWidth)="" or isNull(GuImageWidth)=true or trim(GuImageHeight)="" or isNull(GuImageHeight)=true then
		GuImageDimensionProportion="16"
		exit function
	end if

	GuTableWidth=fix(cint(GuTableWidth))
	GuTableHeight=fix(cint(GuTableHeight))
	GuImageWidth=fix(cint(GuImageWidth))
	GuImageHeight=fix(cint(GuImageHeight))
	dim GuProportionWidth,GuProportionHeight,GuProportionValue
	if (GuTableWidth>=GuImageWidth) and (GuTableHeight>=GuImageHeight) then
		GuProportionWidth=GuImageWidth
		GuProportionHeight=GuImageHeight
	else
		if (GuTableWidth/GuImageWidth)=(GuTableHeight/GuImageHeight) then
			GuProportionWidth=GuTableWidth
			GuProportionHeight=GuTableHeight
		else
			GuProportionValue=GuTableWidth/GuImageWidth
			if (GuImageHeight*GuProportionValue)>GuTableHeight then
				GuProportionValue=GuTableHeight/GuImageHeight
			end if
			GuProportionWidth=GuImageWidth*GuProportionValue
			GuProportionHeight=GuImageHeight*GuProportionValue
		end if
	end if

	if GuDimensionType="Width" then
		GuImageDimensionProportion=fix(GuProportionWidth)
	elseif GuDimensionType="Height" then
		GuImageDimensionProportion=fix(GuProportionHeight)
	else
		GuImageDimensionProportion="16"
	end if

end function


function GuLeftString(GuStringData,GuStringLength)

	if GuStringData="" or isNull(GuStringData)=true then
		GuLeftString=""
		exit function
	end if

	if GuStringLength="" or isNull(GuStringLength)=true or isNumeric(GuStringLength)=false then
		GuLeftString=""
		exit function
	end if

	if fix(GuStringLength)<=0 then
		GuLeftString=GuStringData
		exit function
	else
		GuStringLength=fix(GuStringLength)
	end if

	YY=0
	for ZZ=1 to len(GuStringData)
		if abs(asc(mid(GuStringData,ZZ,1)))>255 then
			YY=YY+2
		else
			YY=YY+1
		end if

		if YY>=GuStringLength then
			exit for
		end if
	next

	if YY>GuStringLength then
		YY=GuStringLength
		ZZ=ZZ-1
	end if

	if YY=GuStringLength then
		if ZZ<len(GuStringData) then
			GuLeftString=left(GuStringData,ZZ-1)&".."
		else
			GuLeftString=GuStringData
		end if
	else
		GuLeftString=GuStringData
	end if

	GuLeftString=replace(GuLeftString,chr(10),"")

end function


function GuRandomString(GuDigit)

	dim RandomArray(80),GuRandomOutput,GuRandomNumber
	for II=0 to 9
		RandomArray(II)=cstr(II)
	next
	for II=10 to 35
		RandomArray(II)=chr(II+55)
	next
	for II=36 to 61
		RandomArray(II)=chr(II+61)
	next
	randomize
	do while len(GuRandomOutput)<GuDigit
		GuRandomNumber=RandomArray(int((61-0+1)*rnd+0))
		GuRandomOutput=GuRandomOutput+GuRandomNumber
	loop

	GuRandomString=GuRandomOutput

end function


function GuReplaceFilterRight(GuStringData,GuReplaceData,GuFilterData)

	if trim(GuStringData)="" or isNull(GuStringData)=true then
		GuReplaceFilterRight=""
		exit function
	end if

	if (trim(GuReplaceData)="" or isNull(GuReplaceData)=true) and (trim(GuFilterData)="" or isNull(GuFilterData)=true) then
		GuReplaceFilterRight=GuStringData
		exit function
	end if

	GuReplaceFilterRight=trim(GuStringData)

	if len(GuReplaceData)>=1 then
		GuReplaceFilterRight=replace(GuReplaceFilterRight,GuReplaceData,"")
	end if

	if len(GuFilterData)>=1 and right(GuReplaceFilterRight,1)=GuFilterData then
		GuReplaceFilterRight=left(GuReplaceFilterRight,len(GuReplaceFilterRight)-1)
	end if

	GuReplaceFilterRight=GuReplaceFilterRight

end function


function GuReplaceKeyword(GuStringData)

	if trim(GuStringData)="" or isNull(GuStringData)=true then
		GuReplaceKeyword=""
		exit function
	end if

	GuReplaceKeyword=trim(GuStringData)
	GuReplaceKeyword=replace(GuReplaceKeyword,"~","n")
	GuReplaceKeyword=replace(GuReplaceKeyword,"`","n")
	GuReplaceKeyword=replace(GuReplaceKeyword,"!","n")
	GuReplaceKeyword=replace(GuReplaceKeyword,"@","n")
	GuReplaceKeyword=replace(GuReplaceKeyword,"#","n")
	GuReplaceKeyword=replace(GuReplaceKeyword,"$","n")
	GuReplaceKeyword=replace(GuReplaceKeyword,"%","n")
	GuReplaceKeyword=replace(GuReplaceKeyword,"^","n")
	GuReplaceKeyword=replace(GuReplaceKeyword,"&","n")
	GuReplaceKeyword=replace(GuReplaceKeyword,"*","n")
	GuReplaceKeyword=replace(GuReplaceKeyword,"+","n")
	GuReplaceKeyword=replace(GuReplaceKeyword,"=","n")
	GuReplaceKeyword=replace(GuReplaceKeyword,"{","n")
	GuReplaceKeyword=replace(GuReplaceKeyword,"[","n")
	GuReplaceKeyword=replace(GuReplaceKeyword,"}","n")
	GuReplaceKeyword=replace(GuReplaceKeyword,"]","n")
	GuReplaceKeyword=replace(GuReplaceKeyword,":","n")
	GuReplaceKeyword=replace(GuReplaceKeyword,";","n")
	GuReplaceKeyword=replace(GuReplaceKeyword,"""","n")
	GuReplaceKeyword=replace(GuReplaceKeyword,"'","n")
	GuReplaceKeyword=replace(GuReplaceKeyword,"|","n")
	GuReplaceKeyword=replace(GuReplaceKeyword,"\","n")
	GuReplaceKeyword=replace(GuReplaceKeyword,"<","n")
	GuReplaceKeyword=replace(GuReplaceKeyword,",","n")
	GuReplaceKeyword=replace(GuReplaceKeyword,">","n")
	GuReplaceKeyword=replace(GuReplaceKeyword,"?","n")
	GuReplaceKeyword=replace(GuReplaceKeyword,"/","n")
	GuReplaceKeyword=replace(GuReplaceKeyword,"and","nd")
	GuReplaceKeyword=replace(GuReplaceKeyword,"delete","elete")
	GuReplaceKeyword=replace(GuReplaceKeyword,"update","Pdate")
	GuReplaceKeyword=replace(GuReplaceKeyword,"insert","nsert")
	GuReplaceKeyword=replace(GuReplaceKeyword,"select","elect")

end function


function GuReplaceLinefeed(GuStringData,GuReplaceData)

	if trim(GuStringData)="" or isNull(GuStringData)=true then
		GuReplaceLinefeed=""
		exit function
	end if

	if trim(GuReplaceData)="" or isNull(GuReplaceData)=true then
		GuReplaceData="|"
	else
		GuReplaceData=trim(GuReplaceData)
	end if

	GuReplaceLinefeed=trim(GuStringData)
	GuReplaceLinefeed=replace(GuReplaceLinefeed,vbcrlf,GuReplaceData)
	GuReplaceLinefeed=replace(GuReplaceLinefeed,"<br>",GuReplaceData)
	GuReplaceLinefeed=replace(GuReplaceLinefeed,"<BR>",GuReplaceData)
	GuReplaceLinefeed=replace(GuReplaceLinefeed,"<br />",GuReplaceData)
	GuReplaceLinefeed=replace(GuReplaceLinefeed,"<BR />",GuReplaceData)
	GuReplaceLinefeed=replace(GuReplaceLinefeed,"<p>",GuReplaceData)
	GuReplaceLinefeed=replace(GuReplaceLinefeed,"<P>",GuReplaceData)
	GuReplaceLinefeed=replace(GuReplaceLinefeed,"</p>",GuReplaceData)
	GuReplaceLinefeed=replace(GuReplaceLinefeed,"</P>",GuReplaceData)

end function


function GuReplaceString(GuStringData,GuReplaceData)

	if GuStringData="" or isNull(GuStringData)=true then
		GuReplaceString=""
		exit function
	end if

	if GuReplaceData="" or isNull(GuReplaceData)=true or instr(GuReplaceData,vbcrlf)<=0 or instr(GuReplaceData,"=")<=0 then
		GuReplaceString=GuStringData
		exit function
	end if

	dim GuReplaceSplitA,GuReplaceSplitB
	GuReplaceSplitA=split(GuReplaceData,vbcrlf)
	for RR=0 to ubound(GuReplaceSplitA)
		if len(GuReplaceSplitA(RR))>=1 and instr(GuReplaceSplitA(RR),"=")>=1 then
			GuReplaceSplitB=split(GuReplaceSplitA(RR),"=")
			GuStringData=replace(GuStringData,GuReplaceSplitB(0),GuReplaceSplitB(1))
		else
			GuStringData=GuStringData
		end if
	next

	GuReplaceString=GuStringData

end function


function GuReplaceSubmit(GuStringData)

	if trim(GuStringData)="" or isNull(GuStringData)=true then
		GuReplaceSubmit=""
		exit function
	end if

	GuReplaceSubmit=trim(GuStringData)
	GuReplaceSubmit=replace(GuReplaceSubmit,"~","")
	GuReplaceSubmit=replace(GuReplaceSubmit,"`","")
	GuReplaceSubmit=replace(GuReplaceSubmit,"#","")
	GuReplaceSubmit=replace(GuReplaceSubmit,"$","")
	GuReplaceSubmit=replace(GuReplaceSubmit,"^","")
	GuReplaceSubmit=replace(GuReplaceSubmit,"*","")
	GuReplaceSubmit=replace(GuReplaceSubmit,"{","")
	GuReplaceSubmit=replace(GuReplaceSubmit,"}","")
	GuReplaceSubmit=replace(GuReplaceSubmit,";","")
	GuReplaceSubmit=replace(GuReplaceSubmit,"'","")
	GuReplaceSubmit=replace(GuReplaceSubmit,"\","")
	GuReplaceSubmit=replace(GuReplaceSubmit,"<","")
	GuReplaceSubmit=replace(GuReplaceSubmit,",","")
	GuReplaceSubmit=replace(GuReplaceSubmit,">","")
	GuReplaceSubmit=replace(GuReplaceSubmit,"and","nd")
	GuReplaceSubmit=replace(GuReplaceSubmit,"delete","elete")
	GuReplaceSubmit=replace(GuReplaceSubmit,"update","pdate")
	GuReplaceSubmit=replace(GuReplaceSubmit,"insert","nsert")
	GuReplaceSubmit=replace(GuReplaceSubmit,"select","elect")

end function


function GuReplaceVerticalline(GuStringData,GuReplaceData)

	if trim(GuStringData)="" or isNull(GuStringData)=true then
		GuReplaceVerticalline=""
		exit function
	end if

	if trim(GuReplaceData)="" or isNull(GuReplaceData)=true then
		GuReplaceData=vbcrlf
	else
		GuReplaceData=trim(GuReplaceData)
	end if

	GuReplaceVerticalline=trim(GuStringData)
	GuReplaceVerticalline=replace(GuReplaceVerticalline,"|",GuReplaceData)

end function


function GuReplaceIndexhtml(GuStringData)

	if trim(GuStringData)="" or isNull(GuStringData)=true then
		GuReplaceIndexhtml=""
		exit function
	end if

	GuReplaceIndexhtml=trim(GuStringData)
	GuReplaceIndexhtml=replace(GuReplaceIndexhtml,"GuHrefIndex href="""&WebsitePath&"/Index.asp","href="""&WebsitePath&"/Index.html")
	GuReplaceIndexhtml=replace(GuReplaceIndexhtml,"GuHrefSort href="""&WebsitePath&"/List.asp?Sort=","href="""&WebsitePath&"/"&WebsiteFolderList&"/")
	GuReplaceIndexhtml=replace(GuReplaceIndexhtml,""" GuHrefSort",".html""")
	GuReplaceIndexhtml=replace(GuReplaceIndexhtml,"GuHrefArticle href="""&WebsitePath&"/Article.asp?ID=","href="""&WebsitePath&"/"&WebsiteFolderArticle&"/")
	GuReplaceIndexhtml=replace(GuReplaceIndexhtml,""" GuHrefArticle",".html""")

end function


function GuReplaceListhtml(GuStringData)

	if trim(GuStringData)="" or isNull(GuStringData)=true then
		GuReplaceListhtml=""
		exit function
	end if

	GuReplaceListhtml=trim(GuStringData)
	GuReplaceListhtml=replace(GuReplaceListhtml,"GuHrefIndex href="""&WebsitePath&"/Index.asp","href="""&WebsitePath&"/Index.html")
	GuReplaceListhtml=replace(GuReplaceListhtml,"GuHrefSort href="""&WebsitePath&"/List.asp?Sort=","href="""&WebsitePath&"/"&WebsiteFolderList&"/")
	GuReplaceListhtml=replace(GuReplaceListhtml,""" GuHrefSort",".html""")
	GuReplaceListhtml=replace(GuReplaceListhtml,"GuHrefArticle href="""&WebsitePath&"/Article.asp?ID=","href="""&WebsitePath&"/"&WebsiteFolderArticle&"/")
	GuReplaceListhtml=replace(GuReplaceListhtml,""" GuHrefArticle",".html""")
	GuReplaceListhtml=replace(GuReplaceListhtml,"GuHrefSort value="""&WebsitePath&"/List.asp?Sort=","value="""&WebsitePath&"/"&WebsiteFolderList&"/")
	GuReplaceListhtml=replace(GuReplaceListhtml,"&Column=&Keyword=&Option=&Field=&Order=&Page=","_")
	GuReplaceListhtml=replace(GuReplaceListhtml,""" GuHrefPage",".html""")
	GuReplaceListhtml=replace(GuReplaceListhtml,"_1.html",".html")

end function


function GuReplaceArticlehtml(GuStringData)

	if trim(GuStringData)="" or isNull(GuStringData)=true then
		GuReplaceArticlehtml=""
		exit function
	end if

	GuReplaceArticlehtml=trim(GuStringData)
	GuReplaceArticlehtml=replace(GuReplaceArticlehtml,"GuHrefIndex href="""&WebsitePath&"/Index.asp","href="""&WebsitePath&"/Index.html")
	GuReplaceArticlehtml=replace(GuReplaceArticlehtml,"GuHrefSort href="""&WebsitePath&"/List.asp?Sort=","href="""&WebsitePath&"/"&WebsiteFolderList&"/")
	GuReplaceArticlehtml=replace(GuReplaceArticlehtml,""" GuHrefSort",".html""")
	GuReplaceArticlehtml=replace(GuReplaceArticlehtml,"GuHrefArticle href="""&WebsitePath&"/Article.asp?ID=","href="""&WebsitePath&"/"&WebsiteFolderArticle&"/")
	GuReplaceArticlehtml=replace(GuReplaceArticlehtml,"&Page=","_")
	GuReplaceArticlehtml=replace(GuReplaceArticlehtml,""" GuHrefArticle",".html""")
	GuReplaceArticlehtml=replace(GuReplaceArticlehtml,"_1.html"" GuHrefPage",".html""")
	GuReplaceArticlehtml=replace(GuReplaceArticlehtml,".html"" GuHrefPage",".html""")
	GuReplaceArticlehtml=replace(GuReplaceArticlehtml,"&GuPage=ASP","&GuPage=HTML")

end function


function GuReplaceSitemapData(GuStringData,GuReplaceOption)

	if trim(GuStringData)="" or isNull(GuStringData)=true then
		GuReplaceSitemapData=""
		exit function
	end if

	if trim(GuReplaceOption)="" or isNull(GuReplaceOption)=true or trim(GuReplaceOption)="ASP" then
		GuReplaceSitemapData=GuStringData
		exit function
	end if

	GuReplaceSitemapData=trim(GuStringData)
	GuReplaceSitemapData=replace(GuReplaceSitemapData,"Index.asp","Index.html")
	GuReplaceSitemapData=replace(GuReplaceSitemapData,"Article.asp?ID=",""&WebsiteFolderArticle&"/")
	GuReplaceSitemapData=replace(GuReplaceSitemapData,"</loc>",".html</loc>")
	GuReplaceSitemapData=replace(GuReplaceSitemapData,".html.html",".html")
	GuReplaceSitemapData=replace(GuReplaceSitemapData,".asp.html",".asp")

end function


function GuReplaceSendasp(GuStringData)

	if trim(GuStringData)="" or isNull(GuStringData)=true then
		GuReplaceSendasp=""
		exit function
	end if

	GuReplaceSendasp=trim(GuStringData)
	GuReplaceSendasp=replace(GuReplaceSendasp,ArticleContentPageCode,"")
	GuReplaceSendasp=replace(GuReplaceSendasp,"src="&WebsitePath&"/"&AdminUploadArticleFolderParent&"/","src="&WebsiteURL&WebsitePath&"/"&AdminUploadArticleFolderParent&"/")
	GuReplaceSendasp=replace(GuReplaceSendasp,"src="""&WebsitePath&"/"&AdminUploadArticleFolderParent&"/","src="""&WebsiteURL&WebsitePath&"/"&AdminUploadArticleFolderParent&"/")

end function


function GuReplacePageCode(GuStringData)

	if trim(GuStringData)="" or isNull(GuStringData)=true then
		GuReplacePageCode=""
		exit function
	end if

	GuReplacePageCode=trim(GuStringData)
	GuReplacePageCode=replace(GuReplacePageCode,"~","_")
	GuReplacePageCode=replace(GuReplacePageCode,"`","_")
	GuReplacePageCode=replace(GuReplacePageCode,"%","_")
	GuReplacePageCode=replace(GuReplacePageCode,"^","_")
	GuReplacePageCode=replace(GuReplacePageCode,"&","_")
	GuReplacePageCode=replace(GuReplacePageCode,"*","_")
	GuReplacePageCode=replace(GuReplacePageCode,"-","_")
	GuReplacePageCode=replace(GuReplacePageCode,"+","_")
	GuReplacePageCode=replace(GuReplacePageCode,"=","_")
	GuReplacePageCode=replace(GuReplacePageCode,":","_")
	GuReplacePageCode=replace(GuReplacePageCode,";","_")
	GuReplacePageCode=replace(GuReplacePageCode,"""","_")
	GuReplacePageCode=replace(GuReplacePageCode,"'","_")
	GuReplacePageCode=replace(GuReplacePageCode,"\","_")
	GuReplacePageCode=replace(GuReplacePageCode,"<","_")
	GuReplacePageCode=replace(GuReplacePageCode,",","_")
	GuReplacePageCode=replace(GuReplacePageCode,">","_")
	GuReplacePageCode=replace(GuReplacePageCode,".","_")
	GuReplacePageCode=replace(GuReplacePageCode,"?","_")
	GuReplacePageCode=replace(GuReplacePageCode,"/","_")
	GuReplacePageCode=replace(GuReplacePageCode," ","_")

end function


function GuHTML2JavaScript(GuStringData)

	if GuStringData="" or isNull(GuStringData)=true then
		GuHTML2JavaScript=""
		exit function
	end if

	GuStringData=trim(GuStringData)
	GuStringData=replace(GuStringData,chr(10),"")
	GuStringData=replace(GuStringData,chr(32)&chr(32),"")
	GuStringData=split(GuStringData,chr(13))
	GuHTML2JavaScript=""

	for HH=0 to ubound(GuStringData)
		if len(trim(GuStringData(HH)))>=1 then
			GuStringData(HH)=replace(GuStringData(HH),chr(34),chr(92)&chr(34))
			GuStringData(HH)=replace(GuStringData(HH),chr(39),chr(92)&chr(39))
'			GuStringData(HH)=replace(GuStringData(HH),chr(47),chr(92)&chr(47))
			GuHTML2JavaScript=GuHTML2JavaScript&"document.write("&chr(34)&GuStringData(HH)&chr(34)&");"&chr(10)
		end if
	next

	GuHTML2JavaScript=GuHTML2JavaScript

end function


function GuFlashPlayerLoad(GuFlashID,GuFlashPath,GuFlashVars,GuFlashWidth,GuFlashHeight,GuFlashAllowScriptAccess,GuFlashBGColor,GuFlashWMode)

	if trim(GuFlashID)="" or isNull(GuFlashID)=true then
		GuFlashPlayerLoad=""
		exit function
	end if

	if trim(GuFlashPath)="" or isNull(GuFlashPath)=true then
		GuFlashPlayerLoad=""
		exit function
	end if

	if trim(GuFlashWidth)="" or isNull(GuFlashWidth)=true then
		GuFlashWidth="100"
	else
		GuFlashWidth=fix(GuFlashWidth)
	end if

	if trim(GuFlashHeight)="" or isNull(GuFlashHeight)=true then
		GuFlashHeight="72"
	else
		GuFlashHeight=fix(GuFlashHeight)
	end if

	if trim(GuFlashWMode)="" or isNull(GuFlashWMode)=true then
		GuFlashWMode="opaque"
	else
		GuFlashWMode=GuFlashWMode
	end if

	GuFlashPlayerLoad="<object id='GuFlashPlayer_"&GuFlashID&"' classid='clsid:D27CDB6E-AE6D-11CF-96B8-444553540000' codebase='http://fpdownload.macromedia.com/get/shockwave/cabs/flash/swflash.cab#version=7,0,0,0' width='"&GuFlashWidth&"' height='"&GuFlashHeight&"' border='0' align=''>" &vbcrlf
	GuFlashPlayerLoad=GuFlashPlayerLoad&"<param name='movie' value='"&GuFlashPath&"' />" &vbcrlf
	GuFlashPlayerLoad=GuFlashPlayerLoad&"<param name='flashvars' value='"&GuFlashVars&"' />" &vbcrlf
	GuFlashPlayerLoad=GuFlashPlayerLoad&"<param name='quality' value='high' />" &vbcrlf
	GuFlashPlayerLoad=GuFlashPlayerLoad&"<param name='bgcolor' value='"&GuFlashBGColor&"' />" &vbcrlf
	GuFlashPlayerLoad=GuFlashPlayerLoad&"<param name='wmode' value='"&GuFlashWMode&"' />" &vbcrlf
	GuFlashPlayerLoad=GuFlashPlayerLoad&"<embed type='application/x-shockwave-flash' name='GuFlashPlayer_"&GuFlashID&"' pluginspage='http://www.adobe.com/go/getflashplayer' src='"&GuFlashPath&"' flashVars='"&GuFlashVars&"' width='"&GuFlashWidth&"' height='"&GuFlashHeight&"' allowScriptAccess='"&GuFlashAllowScriptAccess&"' quality='high' bgcolor='"&GuFlashBGColor&"' wmode='"&GuFlashWMode&"' align='' />" &vbcrlf
	GuFlashPlayerLoad=GuFlashPlayerLoad&"</object>"

end function


function GuServerObjectCheck(GuObjectString)

	on error resume next
	GuServerObjectCheck=false
	Err=0
	dim SCOS
	set SCOS=Server.CreateObject(GuObjectString)
	if 0=Err then
		GuServerObjectCheck=true
	end if
	set SCOS=nothing
	Err=0

end function


function GuServerObjectVersionGet(GuObjectString)

	on error resume next
	GuServerObjectVersionGet=""
	Err=0
	dim SCOS
	set SCOS=Server.CreateObject(GuObjectString)
	if 0=Err then
		GuServerObjectVersionGet=SCOS.Version
	end if
	set SCOS=nothing
	Err=0

end function


function GuWebpageDataGet(GuWebpageURL,GuWebpagePath)

	if trim(GuWebpageURL)="" or isNull(GuWebpageURL)=true then
		GuWebpageDataGet=""
		exit function
	end if

	if trim(GuWebpagePath)="" or isNull(GuWebpagePath)=true then
		GuWebpageDataGet=""
		exit function
	end if

	dim MXWS
	set MXWS=Server.CreateObject("Microsoft.XMLHTTP")
	MXWS.Open "get",GuWebpageURL,false
	MXWS.Send()
	dim ASWS
	set ASWS=Server.CreateObject("ADODB.Stream")
	ASWS.Type=1
	ASWS.Open
	ASWS.Write MXWS.ResponseBody
	ASWS.SaveToFile Server.MapPath(GuWebpagePath),2
	ASWS.Close
	set ASWS=nothing
	set MXWS=nothing

	set SFOF=Server.CreateObject("Scripting.FileSystemObject")
	set SOTF=SFOF.OpenTextFile(Server.MapPath(GuWebpagePath),1,false)
		GuFileContent=SOTF.ReadAll()
	SOTF.Close
	set SOTF=nothing
	set SFOF=nothing

	GuWebpageDataGet=GuFileContent

end function


function GuURLEncoding(GuURLEncoding0)

	dim GuURLEncoding1,GuStringSpecial,GuThischr,GuInnercode,GuHight8,GuLow8

	GuStringSpecial="!""#$%&'()*+,/:;<=>?@[\]^`{|}~%"
	GuURLEncoding1=""
	for UU=1 to len(GuURLEncoding0)
	GuThischr=mid(GuURLEncoding0,UU,1)
	if abs(asc(GuThischr)) < &hff then
		if GuThischr=" " then
			GuURLEncoding1=GuURLEncoding1 & "+"
		elseif instr(GuStringSpecial,GuThischr)>0 then
			GuURLEncoding1=GuURLEncoding1 & "%" & hex(asc(GuThischr))
		else
			GuURLEncoding1=GuURLEncoding1 & GuThischr
		end if
	else
		GuInnercode=asc(GuThischr)
		if GuInnercode<0 then
			GuInnercode=GuInnercode + &h10000
		end if
		GuHight8=(GuInnercode and &hff00)\ &hff
		GuLow8=GuInnercode and &hff
		GuURLEncoding1=GuURLEncoding1& "%" & hex(GuHight8) & "%" & hex(GuLow8)
	end if
	next

	GuURLEncoding=GuURLEncoding1

end function


class GuImageDimensionClass

	dim ASID
	private sub class_Initialize
		set ASID=Server.CreateObject("Adodb.Stream")
		ASID.Mode=3
		ASID.Type=1
		ASID.Open
	end sub

	private sub class_Terminate
		set ASID=nothing
	end sub

	private function Bin2Str(Bin)
		dim Str,clow
		for II=1 to LenB(Bin)
		clow=MidB(Bin,II,1)
		if ASCB(clow)<128 then
			Str = Str & Chr(ASCB(clow))
		else
			II=II+1
			if II <= LenB(Bin) then
				Str = Str & Chr(ASCW(MidB(Bin,II,1)&clow))
			end if
		end if
		next
		Bin2Str = Str
	end function

	private function Num2Str(num,base,lens)
		dim ret
		ret = ""
		while(num>=base)
		ret = (num mod base) & ret
		num = (num - num mod base)/base
		wend
		Num2Str = right(string(lens,"0") & num & ret,lens)
	end function

	private function Str2Num(str,base)
		dim ret
		ret = 0
		for II=1 to len(str)
			ret = ret *base + cint(mid(str,II,1))
		next
		Str2Num=ret
	end function

	private function BinVal(bin)
		dim ret
		ret = 0
		for II = lenb(bin) to 1 step -1
			ret = ret *256 + ascb(midb(bin,II,1))
		next
		BinVal=ret
	end function

	private function BinVal2(bin)
		dim ret
		ret = 0
		for II = 1 to lenb(bin)
			ret = ret *256 + ascb(midb(bin,II,1))
		next
		BinVal2=ret
	end function

	function GuImageDimensionGet(filespec)
		dim ret(3),bFlag,p1,binData,sConv,nBits
		ASID.LoadFromFile(filespec)
		bFlag=ASID.read(3)
		select case hex(binVal(bFlag))
		case "4E5089":
			ASID.read(15)
			ret(0)="PNG"
			ret(1)=BinVal2(ASID.read(2))
			ASID.read(2)
			ret(2)=BinVal2(ASID.read(2))
		case "464947":
			ASID.read(3)
			ret(0)="GIF"
			ret(1)=BinVal(ASID.read(2))
			ret(2)=BinVal(ASID.read(2))
		case "535746":
			ASID.read(5)
			binData=ASID.Read(1)
			sConv=Num2Str(ascb(binData),2 ,8)
			nBits=Str2Num(left(sConv,5),2)
			sConv=mid(sConv,6)
			while(len(sConv)<nBits*4)
			binData=ASID.Read(1)
			sConv=sConv&Num2Str(ascb(binData),2 ,8)
			wend
			ret(0)="SWF"
			ret(1)=int(abs(Str2Num(mid(sConv,1*nBits+1,nBits),2)-Str2Num(mid(sConv,0*nBits+1,nBits),2))/20)
			ret(2)=int(abs(Str2Num(mid(sConv,3*nBits+1,nBits),2)-Str2Num(mid(sConv,2*nBits+1,nBits),2))/20)
		case "FFD8FF":
			do
			do: p1=binVal(ASID.Read(1)): loop while p1=255 and not ASID.eos
			if p1>191 and p1<196 then exit do else ASID.read(binval2(ASID.Read(2))-2)
			do:p1=binVal(ASID.Read(1)):loop while p1<255 and not ASID.eos
			loop while true
			ASID.Read(3)
			ret(0)="JPG"
			ret(2)=binval2(ASID.Read(2))
			ret(1)=binval2(ASID.Read(2))
		case else:
			if left(Bin2Str(bFlag),2)="BM" then
			ASID.Read(15)
			ret(0)="BMP"
			ret(1)=binval(ASID.Read(4))
			ret(2)=binval(ASID.Read(4))
		else
			ret(0)=""
			end if
		end select
		ret(3)="width=""" & ret(1) &""" height=""" & ret(2) &""""
		GuImageDimensionGet=ret
	end function

'	Examples
'	dim IDWH,AEID
'	set IDWH=new GuImageDimensionClass
'	AEID=IDWH.GuImageDimensionGet(Server.MapPath("/Image/Logo.jpg"))
'	Response.Write "Image Type"&AEID(0)
'	Response.Write "Image Width"&AEID(1)
'	Response.Write "Image Height"&AEID(2)
'	Response.Write "Image Width and Height"&AEID(3)
'	set IDWH=nothing

end class

%>

