<%
Class Cls_fun 

'－－－－－－－－字符处理－－－－－－－－－－－－－－－－－－－－－－－－－－
	'****************************************************
	'函数名：StrLength
	'作  用：取得字符串长度（汉字为2)
	'参  数：str ----字符串内容
	'返回值：字符串长度
	'****************************************************
	Public function StrLength(str)
			Dim Rep,lens,i
			Set rep=new regexp
			rep.Global=true
			rep.IgnoreCase=true
			rep.Pattern="[\u4E00-\u9FA5\uF900-\uFA2D]"
			For each i in rep.Execute(str)
				lens=lens+1
			Next
			Set Rep=Nothing
			lens=lens + len(str)
			strLength=lens
		End Function
		
	'****************************************************
	'函数名：CutStr
	'作  用：字符串长度切割，超过显示省略号
	'参  数：str    ----字符串内容
	'       strlen ------要显示的长度
	'返回值：切割后字符串内容
	'****************************************************
	Public Function CutStr(str,strlen)
		   Dim l,t,i,c
		   If str="" Then
			  cutstr=""
			  Exit Function
		   End If
		   str=Replace(Replace(Replace(Replace(Replace(str,"&nbsp;"," "),"&quot;",Chr(34)),"&gt;",">"),"&lt;","<"),"&#124;","|")
		   l=Len(str)
		   t=0
		   For i=1 To l
			  c=Abs(Asc(Mid(str,i,1)))
			  If c>255 Then
				t=t+2
			  Else
				t=t+1
			  End If
			  If t>=strlen Then
				cutstr=Left(str,i) & "..."
				Exit For
			  Else
				cutstr=str
			  End If
		   Next
		   cutstr=Replace(Replace(Replace(Replace(replace(cutstr," ","&nbsp;"),Chr(34),"&quot;"),">","&gt;"),"<","&lt;"),"|","&#124;")
		End Function

	'****************************************************
	'函数名：FormatReArray
	'作  用：去掉数组重复项目，去掉数组内多余的分隔符
	'参  数：str          需要进行进行处理的数组
	'       sep          数组分隔符
	'返回值:FormatReArray      输出参数 为一个二维数组，数组的第一项为是否取到数据，如果有数据则为大于0的数字，否则为0。参数一次类推为字段
	'****************************************************
	function FormatReArray(str,sep)
	dim temp,i,Arraytemp
	temp=""
	Arraytemp=split(str,sep)
	for i=0 to ubound(Arraytemp)
		if Arraytemp(i)<>""  then
			if instr(sep&temp&sep,sep&Arraytemp(i)&sep)=0 then temp=temp&Arraytemp(i)&sep
		end if
	next
	FormatReArray=left(temp,len(temp)-1)
	end function
		

'－－－－－－－－－－－－－－系列验证－－－－－－－－－－－－－－－－－－－－－－－－－－－－
    '****************************************************
	'函数名：isInteger
	'作  用：整数检验
	'参  数：tstr ----字符
	'返回值：true是整数，false不是整数
	'****************************************************
	Public function isInteger(para)
		   on error resume Next
		   Dim str
		   Dim l,i
		   If isNUll(para) then 
			  isInteger=false
			  exit function
		   End if
		   str=cstr(para)
		   If trim(str)="" then
			  isInteger=false
			  exit function
		   End if
		   l=len(str)
		   For i=1 to l
			   If mid(str,i,1)>"9" or mid(str,i,1)<"0" then
				  isInteger=false 
				  exit function
			   End if
		   Next
		   isInteger=true
		   If err.number<>0 then err.clear
	End Function
	
    '****************************************************
	'函数名：CheckName
	'作  用：名字字符检验【以字母，数字，下划线、汉字开头，且不超过19】
	'参  数：str ----字符串
	'返回值：true无误，false有误
	'****************************************************
	Public Function CheckName(Str)
		Checkname=true
		Dim Rep,pass
		Set Rep=New RegExp
		Rep.Global=True
		Rep.IgnoreCase=True
		'匹配字母、数字、下划线、汉字且必须以字母或下划线或汉字开始
		Rep.Pattern="^[a-zA-Z_u4e00-\u9fa5][\w\u4e00-\u9fa5]{1,19}$"
		Set pass=Rep.Execute(Str)
		If pass.count=0 Then CheckName=false
		Set Rep=Nothing
	End Function
	
	'****************************************************
	'函数名：CheckPassword
	'作  用：密码检验 验证密码是 字母+数字+下划线+。 并且在6到20位内 
	'参  数：str ----字符串
	'返回值：true无误，false有误
	'****************************************************
	Public Function CheckPassword(Str)
		Dim pass
		CheckPassword=false
		If Str="" Then CheckPassword=false
			Dim Rep
			Set Rep = New RegExp
			Rep.Global = True
			Rep.IgnoreCase = True
			'匹配字母、数字、下划线、点号
			Rep.Pattern="[a-zA-Z0-9_\.]{6,20}$"
			Pass=rep.Test(Str)
			Set Rep=nothing
			If not Pass Then CheckPassword=false
	End Function	
	
	'****************************************************
	'函数名：CheckEmail
	'作  用：邮箱格式检测
	'参  数：str ----Email地址
	'返回值：true无误，false有误
	'****************************************************
	Public function CheckEmail(email)
	    CheckEmail=true
		Dim Rep,pass
		Set Rep = new RegExp
		rep.pattern="([\.a-zA-Z0-9_-]){2,10}@([a-zA-Z0-9_-]){2,10}(\.([a-zA-Z0-9]){2,}){1,4}$"
		pass=rep.Test(email)
		Set Rep=Nothing
		If not pass Then CheckEmail=false
	End function


'－－－－－－－－－－－－－－安全处理－－－－－－－－－－－－－－－－－－－－－－－－－－－－	
	'****************************************************
	'函数名：ChkPost
	'作  用：禁止站外提交表单
	'返回值：true站内提交，flase站外提交
	'****************************************************
	Public Function ChkPost()
		Dim url1,url2
		chkpost=true
		url1=Cstr(Request.ServerVariables("HTTP_REFERER"))
		url2=Cstr(Request.ServerVariables("SERVER_NAME"))
		If Mid(url1,8,Len(url2))<>url2 Then
			 chkpost=false
			 exit function
		End If
	End function

	'****************************************************
	'函数名：PSql
	'作  用：防止SQL注入
	'返回值：为空则无注入，不为空则注入并返回注入的字符
	'****************************************************
	public Function PSql()
	    Psql=""
		badwords= "'防''防;防and防exec防insert防select防update防delete防count防*防%防chr防mid防master防truncate防char防declare防|"
		badword=split(badwords,"防")
		If Request.Form<>"" Then
			For Each TF_Post In Request.Form
				For i=0 To Ubound(badword)
					If Instr(LCase(Request.Form(TF_Post)),badword(i))>0 Then
						Psql=badword(i)
						exit function
					End If
				Next
			Next
		End If
		If Request.QueryString<>"" Then
			For Each TF_Get In Request.QueryString
				For i=0 To Ubound(badword)
					If Instr(LCase(Request.QueryString(TF_Get)),badword(i))>0 Then
						Psql=badword(i)
						exit function
					End If
				Next
			Next
		End If
	End Function

    '****************************************************
	'函数名：HtmlCode
	'作  用：过滤Html标签
	'参  数：str ----字符串
	'****************************************************
	Public function HtmlCode(str)
		If Not isnull(str) And str<>"" then
			str = replace(str, ">", "&gt;")
			str = replace(str, "<", "&lt;")
			str = Replace(str, CHR(32), " ")
			str = Replace(str, CHR(9), "&nbsp;")
			str = Replace(str, CHR(34), "&quot;")
			str = Replace(str, "%", "&#37;")
			str = Replace(str, CHR(39), "&#39;")
			str = Replace(str, CHR(13), "")
			str = Replace(str, CHR(10), "")
			str = Replace(str, "script", "&#115cript",1,-1,1)
			HtmlCode = str
		End If
	End Function



    '****************************************************
	'函数名：SafeRequest
	'作  用：过滤获取request获取参数
	'参  数：Para        需要过滤的参数
	'       ParaType    参数类型 0 数字型 1字符串型
	'       DefaultValue   参数默认值
	'****************************************************
	public function SafeRequest(Para,ParaType,DefaultValue)
		Para=HtmlCode(Para)
		If ParaType = 0 Then '数字
			If isempty(Para) or isnull(Para) or (not isnumeric(Para)) or Para = "" Then
				 Para = DefaultValue 
			Elseif Para<0 Then
				 Para = DefaultValue 
			End If	 
		ElseIf ParaType = 1 Then '空值
			If isempty(Para) or isnull(Para) or Para = "" Then Para = DefaultValue 
		ElseIf ParaType = 2 Then '时间值
			If (not isdate(Para)) or Para = "" Then Para = DefaultValue 
		End If	
		SafeRequest = Para
	End function
	
	
    '****************************************************
	'函数名：Replacehtml
	'作  用：清理html
	'参  数：tstr ----字符串
	'****************************************************
	Public Function Replacehtml(tstr)
		Dim Str,re
		Str=Tstr
		Set re=new RegExp
			re.IgnoreCase =True
			re.Global=True
			re.Pattern="<(p|\/p|br)>"
			Str=re.Replace(Str,vbNewLine)
			re.Pattern="<img.[^>]*src(=| )(.[^>]*)>"
			str=re.replace(str,"[img]$2[/img]")
			re.Pattern="<(.[^>]*)>"
			Str=re.Replace(Str,"")
			Set Re=Nothing
			Replacehtml=Str
	End Function


'－－－－－－－－－－－－－－－获取客户端和服务端的一些信息－－－－－－－－－－－－－－－－－－－

    '****************************************************
	'函数名：GetIP
	'作  用：获取客户端IP地址
	'返回值：客户端IP地址
	'****************************************************
    Public Function GetIP()
		Dim Temp
		Temp = Request.ServerVariables("HTTP_X_FORWARDED_FOR")
		If Temp = "" or isnull(Temp) or isEmpty(Temp) Then Temp = Request.ServerVariables("REMOTE_ADDR")
		If Instr(Temp,"'")>0 Then Temp="0.0.0.0"
		GetIP = Temp
	End Function

    '****************************************************
	'函数名：GetBrowser
	'作  用：获取客户端浏览器信息
	'返回值：客户端浏览器信息
	'****************************************************
    Public Function GetBrowser()
	       info=Request.ServerVariables(HTTP_USER_AGENT) 
		if Instr(info,"NetCaptor 6.5.0")>0 then
			browser="NetCaptor 6.5.0"
		elseif Instr(info,"MyIe 3.1")>0 then
			browser="MyIe 3.1"
		elseif Instr(info,"NetCaptor 6.5.0RC1")>0 then
			browser="NetCaptor 6.5.0RC1"
		elseif Instr(info,"NetCaptor 6.5.PB1")>0 then
			browser="NetCaptor 6.5.PB1"
		elseif Instr(info,"MSIE 5.5")>0 then
			browser="Internet Explorer 5.5"
		elseif Instr(info,"MSIE 6.0")>0 then
			browser="Internet Explorer 6.0"
		elseif Instr(info,"MSIE 6.0b")>0 then
			browser="Internet Explorer 6.0b"
		elseif Instr(info,"MSIE 5.01")>0 then
			browser="Internet Explorer 5.01"
		elseif Instr(info,"MSIE 5.0")>0 then
			browser="Internet Explorer 5.00"
		elseif Instr(info,"MSIE 4.0")>0 then
			browser="Internet Explorer 4.01"
		else
			browser="其它"
		end if
	End Function

    '****************************************************
	'函数名：GetSystem
	'作  用：获取客户端操作系统
	'返回值：客户端操作系统
	'****************************************************
    Function GetSystem()
	    info=Request.ServerVariables(HTTP_USER_AGENT) 
		if Instr(info,"NT 5.1")>0 then
			system="Windows XP"
		elseif Instr(info,"Tel")>0 then
			system="Telport"
		elseif Instr(info,"webzip")>0 then
			system="webzip"
		elseif Instr(info,"flashget")>0 then
			system="flashget"
		elseif Instr(info,"offline")>0 then
			system="offline"
		elseif Instr(info,"NT 5")>0 then
			system="Windows 2000"
		elseif Instr(info,"NT 4")>0 then
			system="Windows NT4"
		elseif Instr(info,"98")>0 then
			system="Windows 98"
		elseif Instr(info,"95")>0 then
			system="Windows 95"
		elseif instr(info,"unix") or instr(info,"linux") or instr(info,"SunOS") or instr(info,"BSD") then
			system="类Unix"
		elseif instr(thesoft,"Mac") then
			system="Mac"
		else
			system="其它"
		end if
	End Function
	
	'****************************************************
	'函数名：GetUrl
	'作  用：获取url包括参数
	'返回值：获取url包括参数
	'****************************************************
	Public Function GetUrl()   
		Dim strTemp     
		strTemp=Request.ServerVariables("Script_Name")      
		If  Trim(Request.QueryString)<> "" Then
			strTemp=strTemp&"?"
			For Each M_item In Request.QueryString
				strTemp=strTemp&M_item&"="&Server.UrlEncode(Trim(Request.QueryString(""&M_item&"")))
			next
		end if
		GetUrl=strTemp   
	End Function 

	'****************************************************
	'函数名：CUrl
	'作  用：获取当前页面URL的函数
	'返回值：当前页面URL的函数
	'****************************************************
	Function CUrl()
		Domain_Name = LCase(Request.ServerVariables("Server_Name"))
		Page_Name = LCase(Request.ServerVariables("Script_Name"))
		Quary_Name = LCase(Request.ServerVariables("Quary_String"))
		If Quary_Name ="" Then
			CUrl = "http://"&Domain_Name&Page_Name
		Else
			CUrl = "http://"&Domain_Name&Page_Name&"?"&Quary_Name
		End If
	End Function

    '****************************************************
	'函数名：GetExtend
	'作  用：取得文件扩展名
	'参  数：filename ----文件名
	'****************************************************
	Public Function GetExtend(filename)
		dim tmp
		if filename<>"" then
			tmp=mid(filename,instrrev(filename,".")+1,len(filename)-instrrev(filename,"."))
			tmp=LCase(tmp)
			if instr(1,tmp,"asp")>0 or instr(1,tmp,"php")>0 or instr(1,tmp,"php3")>0 or instr(1,tmp,"aspx")>0 then
				getextend="txt"
			else
				getextend=tmp
			end if
		else
			getextend=""
		end if
	End Function
  
'－－－－－－－－－－－－－－－服务端信息和操作－－－－－－－－－－－－－－－－－－－－－－－



	'****************************************************
	'函数名：FolderFileExists
	'作  用：检测文件/文件夹是否存在
	'参  数'pathtype 为0时 为文件 ，为1则为文件夹
	'****************************************************
	Function FolderFileExists(path,pathtype)
		Dim FsoExists
		if instr(path,":\")=0 Then path = server.MapPath(replace(path,"//","/"))
		Set FsoExists=Server.CreateObject(DefaultFSO)
		If pathtype=0  Then '文件
			FolderFileExists=FsoExists.fileExists(path)
		Else 
			FolderFileExists=FsoExists.FolderExists(path)
		End If	
		Set FsoExists=Nothing
	End Function

	'****************************************************
	'函数名：EFolder
	'作  用：建立文件夹
	'参  数'pathtype 为0时 为文件 ，为1则为文件夹
	'****************************************************
	Sub EFolder(FolderName) 
		Dim FSO
		Set FSO=Server.CreateObject(DefaultFSO)
			If Fso.folderexists(Server.MapPath(FolderName)) Then
				Set FSO=Nothing 
				Exit Sub
			Else
				FSO.CreateFolder(Server.MapPath(FolderName))	
			End If	
		Set FSO=Nothing
	End Sub


	'****************************************************
	'函数名：DFolder
	'作  用：删除文件夹
	'参  数'pathtype 为0时 为文件 ，为1则为文件夹
	'****************************************************
	Sub DFolder(FolderName)
		Dim FSO
		Set FSO=Server.CreateObject(DefaultFSO)
			If FSO.FolderExists(Server.MapPath(FolderName)) Then
				FSO.DeleteFolder(Server.MapPath(FolderName)),true
			End If
		Set FSO=Nothing		
	End Sub



	'****************************************************
	'函数名：DFile
	'作  用：删除文件
	'参  数'pathtype 为0时 为文件 ，为1则为文件夹
	Sub DFile(files)
		Dim FSO
		if instr(files,":\")=0 Then files = server.MapPath(files)
		Set FSO=Server.CreateObject("Scripting.FileSystemObject")
			If FSO.FileExists(files) Then
				FSO.DeleteFile(files),true
			End If
		Set FSO=Nothing		
	End Sub

    '****************************************************
	'函数名：GetFolderSize
	'作  用：计算某个文件夹的大小
	'参  数：FileName ----文件夹路径及文件夹名称
	'返回值：数值
	'****************************************************
	Public Function GetFolderSize(Folderpath)
		dim fso,d,size,showsize
		set fso=server.createobject(files) 		
		drvpath=server.mappath(Folderpath) 	
		if fso.FolderExists(drvpath) Then
			set d=fso.getfolder(drvpath) 		
			size=d.size
			GetFolderSize=FormatSize(size)
		Else
            GetFolderSize=Folderpath&"文件夹不存在"
		End If 
	End Function
	
	'****************************************************
	'函数名：GetFileSize
	'作  用：计算某个文件的大小
	'参  数：FileName ----文件路径及文件名
	'返回值：数值
	'****************************************************
	Public Function GetFileSize(FileName)
		Dim fso,drvpath,d,size,showsize
		set fso=server.createobject(Folderpath)
		filepath=server.mappath(FileName)
		if fso.FileExists(filepath) then
			set d=fso.getfile(filepath)	
			size=d.size
			GetFileSize=FormatSize(size)
        Else
		    GetFileSize=FileName&"文件不存在"
        End If
		set fso=nothing
	End Function

	'****************************************************
	'函数名：IsObjInstalled
	'作  用：检查组件是否安装
	'参  数：strClassString ----组件名称
	'返回值：false不存在，true存在
	'****************************************************
	Public Function IsObjInstalled(strClassString)
		On Error Resume Next
		IsObjInstalled=False
		Err=0
		Dim xTestObj
		Set xTestObj=Server.CreateObject(strClassString)
		If 0=Err Then IsObjInstalled=True
		Set xTestObj=Nothing
		Err=0
	End Function
	
    '****************************************************
	'函数名：ReplaceReg
	'作  用：替换函数
	'参  数：str            原来的字符串
	'       patrn          要替换的字符串（正则表达式）
	'       replStr        要替换成的字符串
	'       Ignor          是否区分大小写(1不区分,0区分)  
	'****************************************************
	Function ReplaceReg(str,patrn,replStr,Ignor)
	'=========================================
	'参数解释:
	'str      原来的字符串
	'patrn    要替换的字符串（正则表达式）
	'replStr  要替换成的字符串
	'Ignor    是否区分大小写(1不区分,0区分)
	'=========================================
	  Dim regEx ,Ingor                     ' 建立变量。
	  If Ingor=1 Then Ingor=true else Ingor=false
	  Set regEx = New RegExp               ' 建立正则表达式。
	  regEx.Pattern = patrn               ' 设置模式。
	  regEx.IgnoreCase = Ignor               ' 设置是否区分大小写。
	  regEx.Global=True
	  ReplaceReg = regEx.Replace(str,replStr)         ' 作替换。
	End Function


    '****************************************************
	'函数名：Showmsg
	'作  用：错误提示函数
	'参  数：msg            消息提示信息
	'       url            跳转页面 0 获取来访页面地址；1 跳出；其他 指定页面
	'       divno          使用div或这js弹窗 ,1 div,0 js弹窗
	'       seconds        自动跳转的秒数
	'       msgmode        消息类型，成功提醒 1 ；错误提醒 0 
	'****************************************************

	Sub Showmsg(msg,url,divno,seconds,msgmode)	
	Response.Clear()
		If url="0" Then url=Request.ServerVariables("HTTP_REFERER")
		If url="1" Then Exit Sub
		Call ErrPage(divno,msg,seconds,url,msgmode)
	Response.End()
	End Sub

	Sub ErrPage(divno,msg,seconds,url,msgmode)
	response.Write("<html>")
	Response.Write("<head>")
	Response.Write("<meta http-equiv=""Content-Type"" content=""text/html; charset=utf-8"" />")
	Response.Write("<title>"&DefaultCompName&"</title>")
	Response.Write("<body>")
	If divno=1 Then
	Response.Write("<div style=""margin-top:100px"">")
	Response.Write("<script type=""text/javascript"">")
	Response.Write("var sm="&seconds&";")
	Response.Write("function closeit(){setInterval(""f();"",1000);}")
	Response.Write("function  f(){if (sm>0){ttt.innerText=""还有""+sm+""秒窗口返回！"";   document.title="""&DefaultCompName&"""+sm+""秒后跳转"";sm--;}else{location.href="""&url&""";}}</script> ")
	Response.Write("<table width=""500"" border=""0"" align=""center"" cellpadding=""0"" cellspacing=""0"" class=""kuang"">")
	Response.Write("<tr>")
	Response.Write("<td bgcolor=""#999999""><img src=""images/4.gif"" width=""7"" height=""4"" /></td>")
	Response.Write("</tr>")
	Response.Write("<tr>")
	Response.Write("<td align=""center""><table width=""100%"" border=""0"" cellspacing=""0"" cellpadding=""0"" height=""150"">")
	Response.Write("<tr>")
	Response.Write("<td width=""16%"" align=""center"" bgcolor=""#F1F1F1""><span style=""writing-mode:tb-rl;font-size:16px; letter-spacing:7px; height:100px;color:red""> 友情提示 ")
	If msgmode=1 Then Response.Write("成功") Else Response.Write("失败")
	Response.Write("<span style=""font-family:wingdings;writing-mode:lr-tb;font-size:30px;color:green"">J</span> </span> </td>")
	Response.Write("<td width=""84%"" align=""center"" bgcolor=""#F1F1F1"" style=""font-size:14px;color:red;line-height:30px"">"&msg&"</td>")
	Response.Write("</tr>")
	Response.Write("</table>")
	Response.Write("</td>")
	Response.Write("</tr>")
	Response.Write("<tr>")
	Response.Write("<td height=""47"" align=""center"" bgcolor=""#999999"" style=""color:#FFFFFF;font-size:12px""><span   id=""ttt""></span></td>")
	Response.Write("</tr>")
	Response.Write("</table>")
	Response.Write("<script>function window.onload(){closeit()}</script>")
	Response.Write("</div>")
	
		If url="2" Then 
			Response.Write("<script>setTimeout(""history.go(-1)"","&seconds&"*1000)</script>")
		Else	
			Response.Write("<meta http-equiv=refresh content="&seconds&";url="&url&" />")
		End If	
	ElseIf divno=2 Then
		Response.Write("<script>alert('"&msg&"')</script>")
		If url="2" Then 
			Response.Write("<script>setTimeout(""history.go(-1)"","&seconds&"*1000)</script>")
		Else	
			Response.Write("<meta http-equiv=refresh content="&seconds&";url="&url&" />")
		End If	
	Else	
		Response.Write("<meta http-equiv=refresh content="&seconds&";url="&url&" />")
	End If
	Response.Write("</body>")
	Response.Write("</html>")
	End Sub


	'---------------------数据处理---------------------------
	'****************************************************
	'函数名：Showmsg
	'作  用：取一条记录
	'参  数：Sql           传入参数 Sql语句
	'       ArrayCount    传入参数 需要的字段的个数
	'返回值:ShowInfo      输出参数 为一个数组，数组的第一项为是否取到数据，如果有数据则为大于0的数字，否则为0。参数一次类推为字段
	'****************************************************
	Function ShowInfo(Sql,ArrayCount)
		ReDim NewArray(ArrayCount)
		Dim Recordcounts,Rs,i,Comm
		Set Comm = Server.CreateObject("ADODB.Command")
		With Comm
			Comm.ActiveConnection = Conn
			Comm.CommandType = 4
			Comm.CommandText = "ColumnGet"
			Comm.Prepared  = true
			Comm.Parameters.Append .CreateParameter("Return",2,4)
			Comm.Parameters.Append .CreateParameter("@Sql",200,1,1000,Sql)
			Set Rs = .Execute	
		End With
		Rs.Close
		Recordcounts=Comm(0)
		NewArray(0)=Recordcounts
		If Recordcounts=0 Then ShowInfo=NewArray:Exit Function
		Set Comm=Nothing
		Rs.Open
		For i = 0 to cint(ArrayCount-1)
			NewArray(i+1)=Rs(i)
		Next
		Rs.Close
		ShowInfo=NewArray
		Erase NewArray
		Sql = ""
	End Function


	'****************************************************
	'函数名：RecordShow
	'作  用：按指定sql语句取记录集
	'参  数：Sql           传入参数 Sql语句
	'返回值:ShowInfo      输出参数 为一个二维数组，数组的第一项为是否取到数据，如果有数据则为大于0的数字，否则为0。参数一次类推为字段
	'****************************************************

	Function RecordShow(Sql)
		Dim Comm,Rs
		Dim Recordcounts
		Dim ArrayRecord
		Set Comm=Server.CreateObject("ADODB.Command")
		With Comm
		.ActiveConnection = Conn
		.CommandType = 4
		.CommandText = "Columnget"
		.Prepared = true
		.Parameters.Append .CreateParameter("@Return",3,4)
		.Parameters.Append .CreateParameter("@Sql",200,1,500,Sql)
		Set Rs=.Execute()
		End With
		Rs.Close 
		RecordCounts=Comm(0)
		Rs.Open	
		If RecordCounts=0 Then Redim ArrayRecord(0,0):ArrayRecord(0,0)="@无@" Else:ArrayRecord=Rs.GetRows()
		Rs.Close
		RecordShow=ArrayRecord
	End Function
	
	Function TableInsert(Sql)
		Dim Comm
		Dim ArrayRecord
		Set Comm=Server.CreateObject("ADODB.Command")
		With Comm
		.ActiveConnection = Conn
		.CommandType = 4
		.CommandText = "Columnget"
		.Prepared = true
		.Parameters.Append .CreateParameter("@Return",3,4)
		.Parameters.Append .CreateParameter("@Sql",200,1,2000,Sql)
		.Execute()
		End With
		TableInsert = Comm(0) 
		Set Comm = Nothing
	End Function	
	
End Class	
%>
