<%
'===================================================================
'= ASP FILENAME	: /inc/inc_cache.asp
'= CREATED TIME : 2007-6-2
'= LAST MODIFIED: 2007-6-2
'= VERSION INFO : CCASP Framework Ver 2.0.1 ALL RIGHTS RESERVED BY www.cclinux.com
'= DESCRIPTION  : Cache
'= Change Log:
'===================================================================
'===================================================================
'= Function     : CacheInsert()
'= Time		    : Created At 2007-6-2
'= Input        : strCacheName cache
'= Input        : objValue cacheֵ
'= Input		: intCacheTime cacheʱ 
'= Description  : дCache
'===================================================================
Function CacheInsert(strCacheName,objValue,intCacheTime)

	If Not CACHE_IS_OPEN Then
		CacheInsert = True
		Exit Function
	End If

	If Not IsNull(objValue) Then

		Application.Lock
		Application(GBL_strCookieURL & strCacheName) = objValue
		Application(GBL_strCookieURL & strCacheName & "_LastTime") = CStr(now())
		Application(GBL_strCookieURL & strCacheName & "_CacheTime") = CStr(intCacheTime)
		Application.UnLock

	End If

	CacheInsert = True
End Function

'===================================================================
'= Function     : CacheExist()
'= Time		    : Created At 2007-6-2
'= Input        : strCacheName cache
'= Description  : жCache
'===================================================================
Function CacheExist(strCacheName)

	If Not CACHE_IS_OPEN Then
		CacheExist = False
		Exit Function
	End If

	Dim intCacheTime,strLastTime
 
	If Not IsEmpty(Application(GBL_strCookieURL & strCacheName)) And IsArray(Application(GBL_strCookieURL & strCacheName)) Then

		strLastTime = CDate(Application(GBL_strCookieURL & strCacheName & "_LastTime"))
		intCacheTime = Cint(Application(GBL_strCookieURL & strCacheName & "_CacheTime")) 

		If DateDiff("s",strLastTime,Now()) > (intCacheTime * 60) Then

			CacheExist = False
			Application.Lock
			Set Application(GBL_strCookieURL & strCacheName) = Nothing
			Set Application(GBL_strCookieURL & strCacheName & "_LastTime") = Nothing
			Set Application(GBL_strCookieURL & strCacheName & "_CacheTime") = Nothing
			Application.UnLock
		Else
			CacheExist = True
		End If

	ElseIf Application(GBL_strCookieURL & strCacheName) <> "" And Application(GBL_strCookieURL & strCacheName & "_LastTime") <> "" And Application(GBL_strCookieURL & strCacheName & "_CacheTime") <> "" Then

		strLastTime = CDate(Application(GBL_strCookieURL & strCacheName & "_LastTime"))
		intCacheTime = Cint(Application(GBL_strCookieURL & strCacheName & "_CacheTime")) 

		If DateDiff("s",strLastTime,Now()) > (intCacheTime * 60) Then

			CacheExist = False
			Application.Lock
			Set Application(GBL_strCookieURL & strCacheName) = Nothing
			Set Application(GBL_strCookieURL & strCacheName & "_LastTime") = Nothing
			Set Application(GBL_strCookieURL & strCacheName & "_CacheTime") = Nothing
			Application.UnLock
		Else
			CacheExist = True
		End If
	Else
		CacheExist = False
	End If

End Function

'===================================================================
'= Function     : CacheGet()
'= Time		    : Created At 2007-6-2
'= Input        : strCacheName cache
'= Description  : ȡCache
'===================================================================
Function CacheGet(strCacheName)

	CacheGet = Application(GBL_strCookieURL & strCacheName)
			 
End Function

'===================================================================
'= Function     : CacheRemove()
'= Time		    : Created At 2007-6-2
'= Input        : strCacheName cache
'= Description  : Cache
'===================================================================
Function CacheRemove(strCacheName)

	If Not CACHE_IS_OPEN Then
		CacheRemove = True
		Exit Function
	End If

	If Not IsNull(Application(GBL_strCookieURL & strCacheName)) Then
		Application.Lock
		Application(GBL_strCookieURL & strCacheName) = ""
		Application(GBL_strCookieURL & strCacheName & "_LastTime") = ""
		Application(GBL_strCookieURL & strCacheName & "_CacheTime") = ""
		Application.UnLock
	End If
			
	CacheRemove = True
End Function
%>