<%
''===================================================================
'= ASP FILENAME	: /inc/logic/logic_item.asp
'= CREATED TIME : 2007-12-31
'= LAST MODIFIED: 2007-12-31
'= VERSION INFO : CCASP Framework Ver 3.1.0 ALL RIGHTS RESERVED BY www.cclinux.com
'= DESCRIPTION  :  
'= Change Log:
'==================================================================='
%>

<%
''===================================================================
'= Function    : GetItemsLogic()
'= Time		   : Created At 2007-12-31
'= Input	   : strWhere :  
'= Return      : boolean
'= Description :  
'==================================================================='
Function GetItemsLogic(strWhere)
	GBL_objPubDB.Clear()
	If Instr(strWhere,"ORDER BY") <= 0 Then
		strWhere = strWhere & " ORDER BY ITEM_ID DESC"
	End If
	GBL_objPubDB.AllSQL = "SELECT * FROM CLASS_ITEM WHERE 1=1 " & strWhere 
	If Not GBL_objPubDB.SQLRSExecute() Then
		GetItemsLogic = False
		Exit Function
	End If
	
	GetItemsLogic = True
End Function

''===================================================================
'= Function    : GetItemsOptionLogic()
'= Time		   : Created At 2007-12-31
'= Input	   : strWhere :  
'= Return      : boolean
'= Description :  
'==================================================================='
Function GetItemsOptionLogic(strWhere)
	Dim strHtml
	Dim strCacheName : strCacheName = CACHE_NAME_ITEM_OPTION
	If Not CacheExist(strCacheName) Then
		GBL_objPubDB.Clear()
		GBL_objPubDB.AllSQL = "SELECT ITEM_ID,ITEM_NAME FROM CLASS_ITEM WHERE 1=1 " & strWhere  & " ORDER BY ITEM_NAME ASC"
		If Not GBL_objPubDB.SQLRSExecute() Then
			GetItemsOptionLogic = ""
			Exit Function
		End If

		While Not GBL_objPubDB.objPubRS.Eof 
			strHtml = strHtml & " <option class=""c3"" value=""" & GBL_objPubDB.objPubRS("ITEM_NAME") & """>" & GBL_objPubDB.objPubRS("ITEM_NAME") & "</option>"
			GBL_objPubDB.objPubRS.MoveNext
		Wend

		GetItemsOptionLogic = strHtml
		Call CacheInsert(strCacheName,strHtml,CACHE_TIME_ITEM)
	Else
		GetItemsOptionLogic = CacheGet(strCacheName)
	End If

End Function

''===================================================================
'= Function    : GetItemsArrayLogic()
'= Time		   : Created At 2007-12-31
'= Input	   : strWhere :  
'= Return      : boolean
'= Description :  for autocomplete
'==================================================================='
Function GetItemsArrayLogic(strWhere)
	Dim strHtml
	Dim strCacheName : strCacheName = CACHE_NAME_ITEM_ARRAY
	If Not CacheExist(strCacheName) Then
		GBL_objPubDB.Clear()
		GBL_objPubDB.AllSQL = "SELECT ITEM_ID,ITEM_NAME FROM CLASS_ITEM WHERE 1=1 " & strWhere 
		If Not GBL_objPubDB.SQLRSExecute() Then
			GetItemsArrayLogic = ""
			Exit Function
		End If

		While Not GBL_objPubDB.objPubRS.Eof 
			strHtml = strHtml & "[" & GBL_objPubDB.objPubRS("ITEM_ID") & ",""" &  GBL_objPubDB.objPubRS("ITEM_NAME") & """,""" & GetNum(GBL_objPubDB.objPubRS("ITEM_NAME")) & """,""" & GBL_objPubDB.objPubRS("ITEM_NAME") & """],"
			GBL_objPubDB.objPubRS.MoveNext
		Wend

		Call CacheInsert(strCacheName,strHtml,CACHE_TIME_ITEM)
		GetItemsArrayLogic = strHtml
	Else 
		GetItemsArrayLogic = CacheGet(strCacheName)
	End If

End Function

''===================================================================
'= Function    : GetItemLogic()
'= Time		   : Created At 2007-12-31
'= Input	   : intId :  
'= Return      : boolean
'= Description :  
'==================================================================='
Function GetItemLogic(intId)
	GBL_objPubDB.Clear()
	GBL_objPubDB.AllSQL = "SELECT ITEM_ID,ITEM_NAME,ITEM_TYPE ,ITEM_DESC ,ITEM_ADD_USER_ID,ITEM_ADD_TYPE,ITEM_ADD_TIME,ITEM_LAST_TIME,ITEM_ADD_IP,ITEM_LAST_IP FROM CLASS_ITEM WHERE ITEM_ID=" & intId
	If Not GBL_objPubDB.SQLRSExecute() Then
		GetItemLogic = False
		Exit Function
	End If
	
	GetItemLogic = True
End Function


''===================================================================
'= Function    : RemoveItemsLogic()
'= Time		   : Created At 2007-12-31
'= Input	   : strWhere :  
'= Return      : boolean
'= Description :  
'==================================================================='
Function RemoveItemsLogic(strWhere)
	Dim strSql

	GBL_objPubDB.Clear()
	GBL_objPubDB.TableName = "CLASS_ITEM"
	GBL_objPubDB.SQLType = "DELETE"
	GBL_objPubDB.Where = " 1=1 " & strWhere
	If Not GBL_objPubDB.SQLExecute() Then
		RemoveItemsLogic = False
		Exit Function
	End If

	RemoveItemsLogic = True

	'== Clear cache
	Call CacheRemove(CACHE_NAME_ITEM_OPTION)
	Call CacheRemove(CACHE_NAME_ITEM_ARRAY)

End Function

''===================================================================
'= Function    : SaveItemLogic()
'= Time		   : Created At 2007-12-31
'= Return      : boolean
'= Description : 
'==================================================================='
Function SaveItemLogic(intId,intUserId,objDataForm)
	Dim strSqlType,strOldClass

	'== exist check
	GBL_objPubDB.Clear()
	GBL_objPubDB.TableName = "CLASS_ITEM"
	GBL_objPubDB.SQLType = "SELECT"
	GBL_objPubDB.AddField "ITEM_ID",""
	If intId = DB_PK_NULL Then
		GBL_objPubDB.Where = "ITEM_NAME='" & objDataForm.Item("Name") & "'"
	Else
		GBL_objPubDB.Where = "ITEM_NAME='" & objDataForm.Item("Name") & "' AND ITEM_ID <>" & intId
	End If
	If Not GBL_objPubDB.SQLRSExecute() Then
		SaveItemLogic = False
		Exit Function
	End If
	If GBL_objPubDB.intRSNum > 0 Then
		Call GBL_objException.catchErr(E_USER_PUB,"ð༶(" & objDataForm.Item("Name") & ")Ѵ")
		SaveItemLogic = False
		Exit Function
	End If

	If intId <> DB_PK_NULL Then
		If GetItemLogic(intId) Then
			strOldClass = GBL_objPubDB.objPubRS("ITEM_NAME")
		End If
	End If
	
	GBL_objPubDB.Clear()
	GBL_objPubDB.TableName = "CLASS_ITEM"
	
	If intId <> DB_PK_NULL Then
		strSqlType = DB_SQL_TYPE_UPDATE
	Else
		strSqlType = DB_SQL_TYPE_INSERT
	End If
	
	GBL_objPubDB.SQLType = strSqlType

	If strSqlType = DB_SQL_TYPE_INSERT Then
		GBL_objPubDB.AddField "ITEM_ADD_IP",objDataForm.Item("AddIp")
		GBL_objPubDB.AddField "ITEM_ADD_TIME",GetSysTimeStr()
		GBL_objPubDB.AddField "ITEM_ADD_USER_ID",intUserId  
		GBL_objPubDB.AddField "ITEM_NUM",objDataForm.Item("Num") 
	End If

	GBL_objPubDB.AddField "ITEM_NAME",objDataForm.Item("Name")
	GBL_objPubDB.AddField "ITEM_TYPE",objDataForm.Item("Type")
	GBL_objPubDB.AddField "ITEM_DESC",objDataForm.Item("Desc")
	
	GBL_objPubDB.AddField "ITEM_LAST_TIME",GetSysTimeStr()
	GBL_objPubDB.AddField "ITEM_LAST_IP",objDataForm.Item("LastIp") 

	If strSqlType = DB_SQL_TYPE_UPDATE Then
		GBL_objPubDB.Where = "ITEM_ID=" & intId
	Else
		GBL_objPubDB.AddField "ITEM_ADD_TYPE",objDataForm.Item("AddType") 
	End If
	
	If Not GBL_objPubDB.SQLExecute() Then
		SaveItemLogic = False
		Exit Function
	End If

	'== ޸û༶
	If strSqlType = DB_SQL_TYPE_UPDATE And objDataForm.Item("Name") <> strOldClass  Then
		
		GBL_objPubDB.Clear()
		GBL_objPubDB.AllSQL = "UPDATE CLASS_USER SET USER_CLASS=REPLACE(USER_CLASS,'" & strOldClass & ";','" & objDataForm.Item("Name") & ";') WHERE USER_CLASS LIKE '%" & strOldClass & ";%'"
		If Not GBL_objPubDB.SQLExecute() Then
			SaveItemLogic = False
			Exit Function
		End If
	End If

	Call CountItemNumLogic(objDataForm.Item("Name"))

	SaveItemLogic = True

	'== Clear cache
	Call CacheRemove(CACHE_NAME_ITEM_OPTION)
	Call CacheRemove(CACHE_NAME_ITEM_ARRAY)

End Function

''===================================================================
'= Function    : SaveUserItemLogic()
'= Time		   : Created At 2008-1-1
'= Input	   : intVal :  
'= Return      : str
'= Description :  ÿû༶
'==================================================================='
Function SaveUserItemLogic(intUserId,strItems)
	Dim i,arrItems,objDataForm
	strItems = Replace(strItems,"",";")
	If Right(strItems,1) = ";" Then
		strItems = Left(strItems,Len(strItems) - 1)
	End If
	arrItems = Split(strItems,";")

	If Not IsObject(objDataForm) Then
		Set objDataForm = CreateObject("Scripting.Dictionary")
	End If
	
	objDataForm.Item("AddIp") = GetUserIp()
	objDataForm.Item("LastIp") = GetUserIp()
	objDataForm.Item("Num") = 0
	objDataForm.Item("AddType") = 0 

	For i = Lbound(arrItems) To UBound(arrItems)
		If Trim(arrItems(i)) <> "" Then
			objDataForm.Item("Name") = Trim(arrItems(i))
			objDataForm.Item("Desc") = Trim(arrItems(i))
			objDataForm.Item("Type") = 0
			Call SaveItemLogic(DB_PK_NULL,intUserId,objDataForm)
			GBL_objException.errReset()
			Call CountItemNumLogic(arrItems(i))
		End If
	Next

	Set objDataForm = Nothing
	SaveUserItemLogic = True

	'== Clear cache
	Call CacheRemove(CACHE_NAME_ITEM_OPTION)
	Call CacheRemove(CACHE_NAME_ITEM_ARRAY)

End Function

''===================================================================
'= Function    : CountItemNumLogic()
'= Time		   : Created At 2008-1-1
'= Input	   :    
'= Return      :  
'= Description :  ĳ༶
'==================================================================='
Function CountItemNumLogic(strItem)
	Dim intNum
	GBL_objPubDB.Clear()
	GBL_objPubDB.AllSQL = "SELECT COUNT(USER_ID) AS TOTAL FROM CLASS_USER WHERE USER_CLASS LIKE '%" & strItem & ";%'"
	If Not GBL_objPubDB.SQLRSExecute() Then
		CountItemNumLogic = False
		Exit Function
	End If
	intNum = GBL_objPubDB.objPubRS("TOTAL")

	GBL_objPubDB.Clear()
	GBL_objPubDB.AllSQL = "UPDATE CLASS_ITEM SET ITEM_NUM=" & intNum & " WHERE ITEM_NAME='" & strItem & "'"
	If Not GBL_objPubDB.SQLExecute() Then
		CountItemNumLogic = False
		Exit Function
	End If

	CountItemNumLogic = True
End Function

''===================================================================
'= Function    : GetItemType()
'= Time		   : Created At 2007-12-31
'= Input	   : intVal :  
'= Return      : str
'= Description :  
'==================================================================='
Function GetItemType(intVal)
	Select Case intVal
		Case 0: GetItemType = "༶" 
		Case 1: GetItemType = ""  
		Case 2: GetItemType = "ͬ"
	End Select
End Function

''===================================================================
'= Function    : GetItemAddType()
'= Time		   : Created At 2007-12-31
'= Input	   : intVal :  
'= Return      : str
'= Description :  
'==================================================================='
Function GetItemAddType(intVal)
	Select Case intVal
		Case 0: GetItemAddType = "û" 
		Case 1: GetItemAddType = "̨Ա"   
	End Select
End Function 

%>