<%
''===================================================================
'= ASP FILENAME	: /inc/logic/logic_meet.asp
'= CREATED TIME : 2006-5-1
'= LAST MODIFIED: 2006-5-1
'= VERSION INFO : CCASP Framework Ver 2.0.1 ALL RIGHTS RESERVED BY www.cclinux.com
'= DESCRIPTION  : ߼
'= Change Log:
'==================================================================='
%>

<%
'== meet over/run
Const CONST_MEET_OVER = 1
Const CONST_MEET_RUN = 0
Const CONST_MEET_LOGO = "meet_logo.gif"

''===================================================================
'= Function    : GetMeetsCountLogic()
'= Time		   : Created At 2007-7-1
'= Input	   : 
'= Return      : boolean
'= Description : ȡ¼
'==================================================================='
Function GetMeetsCountLogic(strWhere)
	GBL_objPubDB.Clear()
	GBL_objPubDB.AllSQL = "SELECT COUNT(MEET_ID) AS TOTAL FROM CLASS_MEET a LEFT JOIN CLASS_USER b ON  a.MEET_USER_ID=b.USER_ID WHERE 1=1 " & strWhere
	If Not GBL_objPubDB.SQLRSExecute() Then
		GetMeetsCountLogic = 0
		Exit Function
	End If
	GetMeetsCountLogic = GBL_objPubDB.objPubRS("TOTAL")
End Function

''===================================================================
'= Function    : GetMeetsLogic()
'= Time		   : Created At 2006-5-5
'= Input	   : 
'= Return      : boolean
'= Description : ȡ¼
'==================================================================='
Function GetMeetsLogic(strWhere,intPageSize,intPageNow)
	GBL_objPubDB.Clear()
	If Instr(strWhere,"ORDER BY") > 0 Then
		If intPageNow = 1 Then
			GBL_objPubDB.AllSQL = "SELECT TOP " & intPageSize & " USER_ID, USER_ACCOUNT,USER_REALNAME,MEET_ID,MEET_TIME,MEET_TAG,MEET_DATE,MEET_ADD_TIME,MEET_SPOT,MEET_AREA,MEET_BBS_NUM,MEET_JOIN_NUM,MEET_TYPE,MEET_STATUS,MEET_BBS_NUM,MEET_TITLE FROM CLASS_MEET a LEFT JOIN CLASS_USER b ON a.MEET_USER_ID=b.USER_ID WHERE 1=1 " & strWhere
		Else
			GBL_objPubDB.AllSQL = "SELECT USER_ID, USER_ACCOUNT,USER_REALNAME,MEET_ID,MEET_TIME,MEET_TAG,MEET_DATE,MEET_ADD_TIME,MEET_SPOT,MEET_AREA,MEET_BBS_NUM,MEET_JOIN_NUM,MEET_TYPE,MEET_STATUS,MEET_BBS_NUM,MEET_TITLE FROM CLASS_MEET a LEFT JOIN CLASS_USER b ON a.MEET_USER_ID=b.USER_ID WHERE 1=1 " & strWhere  
		End If
	Else
		If intPageNow = 1 Then
			GBL_objPubDB.AllSQL = "SELECT TOP " & intPageSize & " USER_ID, USER_ACCOUNT,USER_REALNAME,MEET_ID,MEET_TIME,MEET_TAG,MEET_DATE,MEET_ADD_TIME,MEET_SPOT,MEET_AREA,MEET_BBS_NUM,MEET_JOIN_NUM,MEET_TYPE,MEET_STATUS,MEET_BBS_NUM,MEET_TITLE FROM CLASS_MEET a LEFT JOIN CLASS_USER b ON a.MEET_USER_ID=b.USER_ID WHERE 1=1 " & strWhere & " ORDER BY MEET_STATUS ASC,MEET_ID DESC"
		Else
			GBL_objPubDB.AllSQL = "SELECT USER_ID, USER_ACCOUNT,USER_REALNAME,MEET_ID,MEET_TIME,MEET_TAG,MEET_DATE,MEET_ADD_TIME,MEET_SPOT,MEET_AREA,MEET_BBS_NUM,MEET_JOIN_NUM,MEET_TYPE,MEET_STATUS,MEET_BBS_NUM,MEET_TITLE FROM CLASS_MEET a LEFT JOIN CLASS_USER b ON a.MEET_USER_ID=b.USER_ID WHERE 1=1 " & strWhere & " ORDER BY MEET_STATUS ASC,MEET_ID DESC"
		End If
	End If
	If Not GBL_objPubDB.SQLRSExecute() Then
		GetMeetsLogic = False
		Exit Function
	End If
	GetMeetsLogic = True
End Function

'===================================================================
'= Function    : GetHomeMeets()
'= Time		   : Created At 2007-7-3
'= Input	   : intSortId 
'= Return      : boolean
'= Description : ҳȡû¼
'==================================================================='
Function GetHomeMeets()
	Dim arr
	Dim strCacheName : strCacheName = CACHE_NAME_HOME_MEET
	If Not CacheExist(strCacheName) Then

		GBL_objPubDB.Clear()
		GBL_objPubDB.AllSQL = "SELECT TOP " & GBL_intMeetView &  " MEET_ID,MEET_STATUS,MEET_TITLE FROM CLASS_MEET ORDER BY MEET_STATUS ASC,MEET_ID DESC"
		
		If Not GBL_objPubDB.SQLRSExecute() Then
			arr = "null"
		Else
			If GBL_objPubDB.intRSNum <= 0 Then
				arr = "null"
			Else
				arr = GBL_objPubDB.objPubRS.GetRows()
			End If
		End If

		Call CacheInsert(strCacheName,arr,CACHE_TIME_HOME_MEET)
		GetHomeMeets = arr
	Else
		GetHomeMeets = CacheGet(strCacheName)
	End If

End Function

''===================================================================
'= Function    : GetUserMeetsLogic()
'= Time		   : Created At 2007-5-25
'= Input	   : 
'= Return      : boolean
'= Description : ȡĳ˲Ļ
'==================================================================='
Function GetUserMeetsLogic(strWhere)
	GBL_objPubDB.Clear()
	GBL_objPubDB.AllSQL = "SELECT * FROM CLASS_MEET_JOIN,CLASS_MEET WHERE MEET_JOIN_MEET_ID = MEET_ID " & strWhere & " ORDER BY MEET_ID DESC" 
	If Not GBL_objPubDB.SQLRSExecute() Then
		GetUserMeetsLogic = False
		Exit Function
	End If
	GetUserMeetsLogic = True
End Function

''===================================================================
'= Function    : GetMeetLogic()
'= Time		   : Created At 2006-5-5
'= Input	   : strWhere : 
'= Return      : boolean
'= Description : ȡ¼
'==================================================================='
Function GetMeetLogic(strWhere)
	GBL_objPubDB.Clear()
	GBL_objPubDB.AllSQL = "SELECT USER_ACCOUNT,USER_ID,USER_REALNAME,MEET_USER_ID,MEET_TAG,MEET_SPOT,MEET_AREA,MEET_SPEND,MEET_PEOPLE_NUM,MEET_CONTACT,MEET_INTRO,MEET_OTHER,MEET_SUM,MEET_ID,MEET_TIME,MEET_DATE,MEET_ADD_TIME,MEET_TYPE,MEET_STATUS,MEET_BBS_NUM,MEET_TITLE FROM CLASS_MEET a LEFT JOIN CLASS_USER b ON a.MEET_USER_ID=b.USER_ID WHERE 1=1 " & strWhere  
	If Not GBL_objPubDB.SQLRSExecute() Then
		GetMeetLogic = False
		Exit Function
	End If
	GetMeetLogic = True
End Function

''===================================================================
'= Function    : GetMeetMaxIdLogic()
'= Time		   : Created At 2008-1-10
'= Input	   : strWhere : 
'= Return      : boolean
'= Description :  
'==================================================================='
Function GetMeetMaxIdLogic(strWhere)
	GBL_objPubDB.Clear()
	GBL_objPubDB.AllSQL = "SELECT MAX(MEET_ID) AS MAX_ID FROM CLASS_MEET WHERE 1=1 " & strWhere
	If Not GBL_objPubDB.SQLRSExecute() Then
		GetMeetMaxIdLogic = -1
		Exit Function
	End If
	GetMeetMaxIdLogic = GBL_objPubDB.objPubRS("MAX_ID")
End Function

''===================================================================
'= Function    : GetMeetBBSsLogic()
'= Time		   : Created At 2006-5-5
'= Input	   : strWhere : 
'= Return      : boolean
'= Description : ȡԼ¼
'==================================================================='
Function GetMeetBBSsLogic(strWhere)
	GBL_objPubDB.Clear()
	GBL_objPubDB.AllSQL = "SELECT USER_ACCOUNT,USER_REALNAME,USER_NOW_FACE,USER_ID,MEET_BBS_ID,MEET_BBS_TIME,MEET_BBS_TITLE,MEET_BBS_CONTENT,MEET_BBS_MEET_ID FROM CLASS_USER,CLASS_MEET_BBS WHERE MEET_BBS_USER_ID=USER_ID " & strWhere & " ORDER BY MEET_BBS_ID DESC"
	If Not GBL_objPubDB.SQLRSExecute() Then
		GetMeetBBSsLogic = False
		Exit Function
	End If
	GetMeetBBSsLogic = True
End Function

''===================================================================
'= Function    : GetMeetJoinsLogic()
'= Time		   : Created At 2006-5-5
'= Input	   : strWhere : ID
'= Return      : boolean
'= Description : ȡ¼
'==================================================================='
Function GetMeetJoinsLogic(strWhere)
	GBL_objPubDB.Clear()
	GBL_objPubDB.AllSQL = "SELECT USER_ACCOUNT,USER_REALNAME,USER_SEX,USER_BIRTH,MEET_JOIN_STATUS,MEET_JOIN_ACCOUNT,USER_ID,MEET_JOIN_ID,MEET_JOIN_TIME,MEET_JOIN_CONTACT FROM CLASS_USER,CLASS_MEET_JOIN WHERE MEET_JOIN_USER_ID=USER_ID " & strWhere & " ORDER BY MEET_JOIN_ID DESC"
	If Not GBL_objPubDB.SQLRSExecute() Then
		GetMeetJoinsLogic = False
		Exit Function
	End If
	GetMeetJoinsLogic = True
End Function

''===================================================================
'= Function    : RemoveMeetsLogic()
'= Time		   : Created At 2006-5-5
'= Input	   : strWhere : 
'= Return      : boolean
'= Description :  ɾ
'==================================================================='
Function RemoveMeetsLogic(strWhere)
	Dim strSql

	'== remove tag
	Call RemoveTagsLogic(" AND TAG_TYPE= " & TAG_TYPE_MEET & " AND TAG_OBJECT_ID IN (SELECT MEET_ID FROM CLASS_MEET WHERE 1=1 " & strWhere & ")")

	strSql = " AND MEET_JOIN_MEET_ID IN (SELECT MEET_ID FROM CLASS_MEET WHERE 1=1 " & strWhere & ")"
	'== ɾ
	If Not RemoveMeetJoinsLogic(strSql) Then
		RemoveMeetsLogic = False
		Exit Function
	End If

	'== ɾ
	strSql = " AND MEET_BBS_MEET_ID IN (SELECT MEET_ID FROM CLASS_MEET WHERE 1=1 " & strWhere & ")"
	If Not RemoveMeetBBSsLogic(strSql) Then
		RemoveMeetsLogic = False
		Exit Function
	End If

	'== ɾ
	GBL_objPubDB.Clear()
	GBL_objPubDB.TableName = "CLASS_MEET"
	GBL_objPubDB.SQLType = "DELETE"
	GBL_objPubDB.Where = " 1=1 " & strWhere 
	If Not GBL_objPubDB.SQLRSExecute() Then
		RemoveMeetsLogic = False
		Exit Function
	End If
	RemoveMeetsLogic = True

	'== ɾtag
	GBL_objPubDB.Clear()
	GBL_objPubDB.TableName = "T_TAG"
	GBL_objPubDB.SQLType = "DELETE"
	GBL_objPubDB.Where = " TAG_TYPE=" & TAG_TYPE_MEET & " AND TAG_OBJECT_ID NOT IN (SELECT MEET_ID FROM CLASS_MEET)"
	If Not GBL_objPubDB.SQLExecute() Then
		RemoveMeetsLogic = False
		Exit Function
	End If

	'== Clear cache
	Call CacheRemove(CACHE_NAME_HOME_MEET)
	Call CacheRemove(CACHE_NAME_MEET_NUM)
	Call CacheRemove(CACHE_NAME_MEET_ACTIVE_NUM)

End Function

''===================================================================
'= Function    : RemoveMeetBBSsLogic()
'= Time		   : Created At 2006-5-5
'= Input	   : strWhere : 
'= Return      : boolean
'= Description :  ɾ
'==================================================================='
Function RemoveMeetBBSsLogic(strWhere)
	Dim intNum

	GBL_objPubDB.Clear()
	GBL_objPubDB.AllSQL = "SELECT COUNT(MEET_BBS_ID) AS TOTALNUM FROM CLASS_MEET_BBS WHERE 1=1 " & strWhere
	If Not GBL_objPubDB.SQLRSExecute() Then
		RemoveMeetBBSsLogic = False
		Exit Function
	End If
	intNum = GBL_objPubDB.objPubRS("TOTALNUM")

	'== set this bbs' number
	GBL_objPubDB.Clear()
	GBL_objPubDB.TableName = "CLASS_MEET"
	GBL_objPubDB.SQLType = "UPDATE"
	GBL_objPubDB.Where = "1=1 AND MEET_ID IN (SELECT MEET_BBS_MEET_ID FROM CLASS_MEET_BBS WHERE 1=1 " & strWhere & ")"
	GBL_objPubDB.AddSet "MEET_BBS_NUM=MEET_BBS_NUM-" & intNum
	If Not GBL_objPubDB.SQLExecute() Then
		RemoveMeetBBSsLogic = False
		Exit Function
	End If

	GBL_objPubDB.Clear()
	GBL_objPubDB.TableName = "CLASS_MEET_BBS"
	GBL_objPubDB.SQLType = "DELETE"
	GBL_objPubDB.Where = " 1=1 " & strWhere 
	If Not GBL_objPubDB.SQLRSExecute() Then
		RemoveMeetBBSsLogic = False
		Exit Function
	End If

	RemoveMeetBBSsLogic = True
End Function

''===================================================================
'= Function    : RemoveMeetJoinsLogic()
'= Time		   : Created At 2006-5-5
'= Input	   : strWhere : 
'= Return      : boolean
'= Description : ɾ
'==================================================================='
Function RemoveMeetJoinsLogic(strWhere)
	Dim intNum
	GBL_objPubDB.Clear()
	GBL_objPubDB.AllSQL = "SELECT COUNT(MEET_JOIN_ID) AS TOTALNUM FROM CLASS_MEET_JOIN WHERE 1=1 " & strWhere
	If Not GBL_objPubDB.SQLRSExecute() Then
		RemoveMeetJOINsLogic = False
		Exit Function
	End If
	intNum = GBL_objPubDB.objPubRS("TOTALNUM")

	'== set this JOIN' number
	GBL_objPubDB.Clear()
	GBL_objPubDB.TableName = "CLASS_MEET"
	GBL_objPubDB.SQLType = "UPDATE"
	GBL_objPubDB.Where = "1=1 AND MEET_ID IN (SELECT MEET_JOIN_MEET_ID FROM CLASS_MEET_JOIN WHERE 1=1 " & strWhere & ")"
	GBL_objPubDB.AddSet "MEET_JOIN_NUM=MEET_JOIN_NUM-" & intNum
	If Not GBL_objPubDB.SQLExecute() Then
		RemoveMeetJOINsLogic = False
		Exit Function
	End If

	GBL_objPubDB.Clear()
	GBL_objPubDB.TableName = "CLASS_MEET_JOIN"
	GBL_objPubDB.SQLType = "DELETE"
	GBL_objPubDB.Where = " 1=1 " & strWhere 
	If Not GBL_objPubDB.SQLRSExecute() Then
		RemoveMeetJoinsLogic = False
		Exit Function
	End If
	RemoveMeetJoinsLogic = True
End Function

''===================================================================
'= Function    : SaveMeetLogic()
'= Time		   : Created At 2006-5-5
'= Input	   : intMeetId : ID
'= Return      : boolean
'= Description : Ϣ
'==================================================================='
Function SaveMeetLogic(intMeetId,intUserId,objFormData)
	Dim strTitle,strStatus,strType,strArea,strSpot,strSpend,strTime,strPeopleNum,strContact,strSum,strContent,strOther,strDate

	strTitle = objFormData.Item("Title")
	If intMeetId <> "" Then
		strStatus = objFormData.Item("Status")
	Else
		strStatus = CONST_MEET_RUN
	End If
	strType = objFormData.Item("Type")
	strArea = objFormData.Item("Area")
	strSpot = objFormData.Item("Spot")
	strSpend = objFormData.Item("Spend")
	strDate = objFormData.Item("Date")
	strTime = objFormData.Item("Time")
	strPeopleNum = objFormData.Item("PeopleNum")
	strContact = objFormData.Item("Contact")
	strSum = objFormData.Item("Sum")
	strContent = objFormData.Item("Content")
	strOther = objFormData.Item("Other")

	GBL_objPubDB.Clear()
	GBL_objPubDB.TableName = "CLASS_MEET"
	If intMeetId <> "" Then
		GBL_objPubDB.SQLType = "UPDATE"
	Else
		GBL_objPubDB.SQLType = "INSERT"
		GBL_objPubDB.AddField "MEET_USER_ID",intUserId
		GBL_objPubDB.AddField "MEET_LOGO",CONST_MEET_LOGO
		GBL_objPubDB.AddField "MEET_ADD_TIME",GetSysTimeStr()
		GBL_objPubDB.AddField "MEET_JOIN_NUM",0
		GBL_objPubDB.AddField "MEET_REFUSE_NUM",0
		GBL_objPubDB.AddField "MEET_THINK_NUM",0
		GBL_objPubDB.AddField "MEET_BBS_NUM",0
	End If

	GBL_objPubDB.AddField "MEET_TITLE",strTitle
	GBL_objPubDB.AddField "MEET_INTRO",strContent
	GBL_objPubDB.AddField "MEET_OTHER",strOther
	GBL_objPubDB.AddField "MEET_TAG",Replace(objFormData.Item("Tag"),"",";")
	GBL_objPubDB.AddField "MEET_SUM",strSum
	GBL_objPubDB.AddField "MEET_DATE",strDate
	GBL_objPubDB.AddField "MEET_TIME",strTime
	GBL_objPubDB.AddField "MEET_SPOT",strSpot
	GBL_objPubDB.AddField "MEET_AREA",strArea
	GBL_objPubDB.AddField "MEET_SPEND",strSpend
	GBL_objPubDB.AddField "MEET_CONTACT",strContact
	GBL_objPubDB.AddField "MEET_PEOPLE_NUM",strPeopleNum
	GBL_objPubDB.AddField "MEET_TYPE",strType
	GBL_objPubDB.AddField "MEET_STATUS",strStatus
	GBL_objPubDB.AddField "MEET_LAST_TIME",GetSysTimeStr()
	If intMeetId <> "" Then
		GBL_objPubDB.Where = " MEET_ID=" & intMeetId
	End If
	If Not GBL_objPubDB.SQLExecute() Then
		SaveMeetLogic = False
		Exit Function
	End If
	SaveMeetLogic = True

	'== add tag
	If intMeetId = "" Then intMeetId = GetMeetMaxIdLogic("")
	Dim strUrl : strUrl = "meet/meet_detail.asp?intMeetId=" & intMeetId
	Call SaveTagsLogic(intUserId,TAG_TYPE_MEET,objFormData.Item("Tag"),intMeetId,strTitle,strUrl)

	'== Clear cache
	Call CacheRemove(CACHE_NAME_HOME_MEET)
	Call CacheRemove(CACHE_NAME_MEET_NUM)
	Call CacheRemove(CACHE_NAME_MEET_ACTIVE_NUM)

End Function

''===================================================================
'= Function    : GetMeetStatusLogic()
'= Time		   : Created At 2006-5-5
'= Input	   : intStatus : ״̬
'= Return      : ״̬ĺ
'= Description : ȡû״̬
'==================================================================='
Function GetMeetStatusLogic(intStatus)
	If Cint(intStatus) = CONST_MEET_RUN Then
		GetMeetStatusLogic = "ټ"
	Else
		GetMeetStatusLogic = "ѽ"
	End If
End Function

'==================================================================='
'= Function    : GetMeetOwner()
'= Time		   : Created At 2008-5-21
'= Return      :  
'= Description :  
'==================================================================='
Function GetMeetOwner(str)
	If IsNull(str) Or Trim(str) = "" Then
		GetMeetOwner = "<font style='color:red'>ϵͳ</font>" 
	End If
End Function


''===================================================================
'= Function    : GetLastNextMeetIdLogic()
'= Time		   : Created At 2006-5-5
'= Input	   : intAlbumId 
'= Output	   : intLastId 
'= Output	   : intNextId 
'= Return      : boolean
'= Description : ȡһһID
'==================================================================='
Function GetLastNextMeetIdLogic(intAlbumId,ByRef intLastId,intNextId)
	intLastId = GetNextRS("MEET_ID","CLASS_MEET","MEET_ID>" & intAlbumId,"MEET_ID ASC")
	intNextId = GetNextRS("MEET_ID","CLASS_MEET","MEET_ID<" & intAlbumId,"MEET_ID DESC")
End Function

''===================================================================
'= Function    : SaveMeetJoinLogic()
'= Time		   : Created At 2006-5-7
'= Input	   : intUserId 
'= Input	   : objFormData 
'= Return      : boolean
'= Description : û
'==================================================================='
Function SaveMeetJoinLogic(intUserId,intMeetId,objFormData)
	'== ֹͣĻܱ
	GBL_objPubDB.Clear()
	GBL_objPubDB.TableName = "CLASS_MEET"
	GBL_objPubDB.SQLType = "SELECT"
	GBL_objPubDB.AddField "MEET_STATUS",""
	GBL_objPubDB.Where =  " MEET_ID=" & intMeetId & " AND MEET_STATUS=" & CONST_MEET_OVER
	If Not GBL_objPubDB.SQLRSExecute() Then
		SaveMeetJoinLogic = False
		Exit Function
	End If
	If GBL_objPubDB.intRSNum > 0 Then
		Call GBL_objException.catchErr(E_USER_PUB,"ֹͣĻܱ")
	End If

	'==ɾϵı¼
	GBL_objPubDB.Clear()
	GBL_objPubDB.TableName = "CLASS_MEET_JOIN"
	GBL_objPubDB.SQLType = "DELETE"
	GBL_objPubDB.Where =  "MEET_JOIN_USER_ID=" & intUserId & " AND MEET_JOIN_STATUS=0 AND MEET_JOIN_MEET_ID=" & intMeetId
	If Not GBL_objPubDB.SQLExecute() Then
		SaveMeetJoinLogic = False
		Exit Function
	End If

	GBL_objPubDB.Clear()
	GBL_objPubDB.TableName = "CLASS_MEET_JOIN"
	GBL_objPubDB.SQLType = "INSERT"
	GBL_objPubDB.AddField "MEET_JOIN_ACCOUNT",objFormData.Item("User")
	GBL_objPubDB.AddField "MEET_JOIN_CONTACT",objFormData.Item("Tel")
	GBL_objPubDB.AddField "MEET_JOIN_USER_ID",intUserId
	GBL_objPubDB.AddField "MEET_JOIN_STATUS",0
	GBL_objPubDB.AddField "MEET_JOIN_MEET_ID",intMeetId
	GBL_objPubDB.AddField "MEET_JOIN_TIME",GetSysTimeStr()
	If Not GBL_objPubDB.SQLExecute() Then
		SaveMeetJoinLogic = False
		Exit Function
	End If

	'== set this join's number
	GBL_objPubDB.Clear()
	GBL_objPubDB.TableName = "CLASS_MEET"
	GBL_objPubDB.SQLType = "UPDATE"
	GBL_objPubDB.Where = "MEET_ID=" & intMeetId
	GBL_objPubDB.AddSet "MEET_JOIN_NUM=MEET_JOIN_NUM+1"
	If Not GBL_objPubDB.SQLExecute() Then
		SaveMeetBBSLogic = False
		Exit Function
	End If

	SaveMeetJoinLogic = True
End Function

''===================================================================
'= Function    : SaveMeetBBSLogic()
'= Time		   : Created At 2006-5-7
'= Input	   : intUserId 
'= Input	   : intMeetId 
'= Input	   : objFormData 
'= Return      : boolean
'= Description : 
'==================================================================='
Function SaveMeetBBSLogic(intUserId,intMeetId,objFormData)
	GBL_objPubDB.Clear()
	GBL_objPubDB.TableName = "CLASS_MEET_BBS"
	GBL_objPubDB.SQLType = "INSERT"
	GBL_objPubDB.AddField "MEET_BBS_USER_ID",intUserId
	GBL_objPubDB.AddField "MEET_BBS_CONTENT",objFormData.Item("Content")
	GBL_objPubDB.AddField "MEET_BBS_MEET_ID",intMeetId
	GBL_objPubDB.AddField "MEET_BBS_TIME",GetSysTimeStr()
	If Not GBL_objPubDB.SQLExecute() Then
		SaveMeetBBSLogic = False
		Exit Function
	End If

	'== set this bbs' number
	GBL_objPubDB.Clear()
	GBL_objPubDB.TableName = "CLASS_MEET"
	GBL_objPubDB.SQLType = "UPDATE"
	GBL_objPubDB.Where = "MEET_ID=" & intMeetId
	GBL_objPubDB.AddSet "MEET_BBS_NUM=MEET_BBS_NUM+1"
	If Not GBL_objPubDB.SQLExecute() Then
		SaveMeetBBSLogic = False
		Exit Function
	End If

	SaveMeetBBSLogic = True
End Function
%>