<%
''===================================================================
'= ASP FILENAME	: /inc/logic/logic_shopinfo.asp
'= CREATED TIME : 2007-8-8
'= LAST MODIFIED: 2007-8-8
'= VERSION INFO : CCASP Framework Ver 3.1.0 ALL RIGHTS RESERVED BY www.cclinux.com
'= DESCRIPTION  : ҳҵ߼
'= Change Log:
'==================================================================='
%>

<%
''===================================================================
'= Function    : GetShopInfosLogic()
'= Time		   : Created At 2007-8-8
'= Input	   : strWhere : 
'= Return      : boolean
'= Description : ȡҳ¼
'==================================================================='
Function GetShopInfosLogic(strWhere)
	GBL_objPubDB.Clear()
	If Instr(strWhere,"ORDER BY") <= 0 Then
		strWhere = strWhere & " ORDER BY SHOP_INFO_ID DESC"
	End If
	GBL_objPubDB.AllSQL = "SELECT a.*,b.USER_REALNAME,b.USER_ACCOUNT,b.USER_ID FROM CLASS_SHOP_INFO a LEFT JOIN CLASS_USER b ON b.USER_ID=a.SHOP_INFO_USER_ID WHERE 1=1 " & strWhere 
	If Not GBL_objPubDB.SQLRSExecute() Then
		GetShopInfosLogic = False
		Exit Function
	End If
	
	GetShopInfosLogic = True
End Function

''===================================================================
'= Function    : GetShopInfoLogic()
'= Time		   : Created At 2007-8-8
'= Input	   : intShopInfoId : ҳID
'= Return      : boolean
'= Description : ȡҳ
'==================================================================='
Function GetShopInfoLogic(intShopInfoId)
	GBL_objPubDB.Clear()
	GBL_objPubDB.AllSQL = "SELECT SHOP_INFO_ID,SHOP_INFO_TITLE,SHOP_INFO_TAG,SHOP_INFO_CONTENT,SHOP_INFO_TYPE,SHOP_INFO_EFFECT,SHOP_INFO_STATUS,SHOP_INFO_TRADE1,SHOP_INFO_TRADE2,SHOP_INFO_PROVINCE,SHOP_INFO_CITY,SHOP_INFO_ADDRESS,SHOP_INFO_CONTACT,SHOP_INFO_PERSON,SHOP_INFO_HOMEPAGE,SHOP_INFO_EMAIL,SHOP_INFO_ADD_TIME,SHOP_INFO_LAST_TIME,SHOP_INFO_ADD_IP,SHOP_INFO_LAST_IP,SHOP_INFO_USER_ID,SHOP_INFO_HITS,SHOP_INFO_LINK_ID,USER_REALNAME,USER_ACCOUNT,USER_ID FROM CLASS_SHOP_INFO a LEFT JOIN CLASS_USER b ON b.USER_ID=a.SHOP_INFO_USER_ID WHERE SHOP_INFO_ID=" & intShopInfoId
	If Not GBL_objPubDB.SQLRSExecute() Then
		GetShopInfoLogic = False
		Exit Function
	End If
	
	GetShopInfoLogic = True
End Function

''===================================================================
'= Function    : GetShopAccsGroupLogic()
'= Time		   : Created At 2007-8-11
'= Input	   : strWhere :  
'= Return      : boolean
'= Description : ҳ̻鼰Ŀ
'==================================================================='
Function GetShopAccsGroupLogic(strWhere,ByRef strTrade1Name,ByRef strTrade1Count)
	GBL_objPubDB.Clear()
	GBL_objPubDB.AllSQL = "SELECT COUNT(SHOP_INFO_ID) AS NUM, SHOP_INFO_TRADE1 FROM CLASS_SHOP_INFO WHERE 1=1 " & strWhere & " GROUP BY SHOP_INFO_TRADE1"
	If Not GBL_objPubDB.SQLRSExecute() Then
		GetShopAccsGroupLogic = False
		Exit Function
	End If
	Dim i
	If GBL_objPubDB.intRSNum > 0 Then
		For i = 1 To GBL_objPubDB.intRSNum
			strTrade1Name = strTrade1Name  & "|" & GBL_objPubDB.objPubRS("SHOP_INFO_TRADE1")
			strTrade1Count = strTrade1Count  & "|" & GBL_objPubDB.objPubRS("NUM")
			GBL_objPubDB.objPubRS.MoveNext
		Next
	End If
	
	GetShopAccsGroupLogic = True
End Function

''===================================================================
'= Function    : GetShopTypeGroupLogic()
'= Time		   : Created At 2007-8-11
'= Input	   : strWhere :  
'= Return      : boolean
'= Description : ҳͷ鼰Ŀ
'==================================================================='
Function GetShopTypeGroupLogic(strWhere,ByRef strName,ByRef strCount)
	GBL_objPubDB.Clear()
	GBL_objPubDB.AllSQL = "SELECT COUNT(SHOP_INFO_ID) AS NUM, SHOP_INFO_TYPE FROM CLASS_SHOP_INFO WHERE 1=1 " & strWhere & " GROUP BY SHOP_INFO_TYPE"
	If Not GBL_objPubDB.SQLRSExecute() Then
		GetShopTypeGroupLogic = False
		Exit Function
	End If
	Dim i
	If GBL_objPubDB.intRSNum > 0 Then
		For i = 1 To GBL_objPubDB.intRSNum
			strName = strName  & "|" & GBL_objPubDB.objPubRS("SHOP_INFO_TYPE")
			strCount = strCount  & "|" & GBL_objPubDB.objPubRS("NUM")
			GBL_objPubDB.objPubRS.MoveNext
		Next
	End If
	
	GetShopTypeGroupLogic = True
End Function

''===================================================================
'= Function    : GetShopAccNumLogic()
'= Time		   : Created At 2007-8-11
'= Input	   : strWhere :  
'= Return      : boolean
'= Description : ĳĿ
'==================================================================='
Function GetShopAccNumLogic(arrTradeName,arrTradeCount,strNowTrade)
	Dim i
	For i = Lbound(arrTradeName) To Ubound(arrTradeName)
		If arrTradeName(i) = strNowTrade Then
			GetShopAccNumLogic = arrTradeCount(i)
			Exit Function
		End If
	Next
	GetShopAccNumLogic = 0
End Function

''===================================================================
'= Function    : RemoveShopInfosLogic()
'= Time		   : Created At 2007-8-8
'= Input	   : strWhere : 
'= Return      : boolean
'= Description : ɾҳ
'==================================================================='
Function RemoveShopInfosLogic(strWhere)
	Dim strSql 

	'== ɾҳ¼
	GBL_objPubDB.Clear()
	GBL_objPubDB.TableName = "CLASS_SHOP_INFO"
	GBL_objPubDB.SQLType = "DELETE"
	GBL_objPubDB.Where = " 1=1 " & strWhere
	If Not GBL_objPubDB.SQLExecute() Then
		RemoveShopInfosLogic = False
		Exit Function
	End If 

	'== ɾtag
	GBL_objPubDB.Clear()
	GBL_objPubDB.TableName = "T_TAG"
	GBL_objPubDB.SQLType = "DELETE"
	GBL_objPubDB.Where = " TAG_TYPE=" & TAG_TYPE_SHOPINFO & " AND TAG_OBJECT_ID NOT IN (SELECT SHOP_INFO_ID FROM CLASS_SHOP_INFO)"
	If Not GBL_objPubDB.SQLExecute() Then
		RemoveShopInfosLogic = False
		Exit Function
	End If

	'== clear cache
	Call CacheRemove(CACHE_NAME_SHOP_NUM)

	RemoveShopInfosLogic = True

End Function

''===================================================================
'= Function    : SaveShopInfoLogic()
'= Time		   : Created At 2007-8-8
'= Input	   : intShopInfoId : ҳID
'= Input	   : intUserId : ûID
'= Input	   : objDataForm : 
'= Return      : boolean
'= Description : ҳ¼
'==================================================================='
Function SaveShopInfoLogic(intShopInfoId,intUserId,objDataForm)
	Dim strSqlType
	
	'== УǷظ
	GBL_objPubDB.Clear()
	GBL_objPubDB.TableName = "CLASS_SHOP_INFO"
	GBL_objPubDB.SQLType = "SELECT"
	GBL_objPubDB.AddField "SHOP_INFO_ID",""
	If intShopInfoId = DB_PK_NULL Then
		GBL_objPubDB.Where = "SHOP_INFO_TITLE='" & objDataForm.Item("Title") & "'"
	Else
		GBL_objPubDB.Where = "SHOP_INFO_TITLE='" & objDataForm.Item("Title") & "' AND SHOP_INFO_ID <>" & intShopInfoId
	End If
	If Not GBL_objPubDB.SQLRSExecute() Then
		SaveShopInfoLogic = False
		Exit Function
	End If
	If GBL_objPubDB.intRSNum > 0 Then
		Call GBL_objException.catchErr(E_USER_PUB,"ûҳ(" & objDataForm.Item("Title") & ")Ѵ")
		SaveShopInfoLogic = False
		Exit Function
	End If
	
	GBL_objPubDB.Clear()
	GBL_objPubDB.TableName = "CLASS_SHOP_INFO"
	
	If intShopInfoId <> DB_PK_NULL Then
		strSqlType = DB_SQL_TYPE_UPDATE
	Else
		strSqlType = DB_SQL_TYPE_INSERT
	End If
	
	GBL_objPubDB.SQLType = strSqlType

	If strSqlType = DB_SQL_TYPE_INSERT Then
		GBL_objPubDB.AddField "SHOP_INFO_ADD_IP",objDataForm.Item("AddIp")
		GBL_objPubDB.AddField "SHOP_INFO_ADD_TIME",GetSysTimeStr()
		GBL_objPubDB.AddField "SHOP_INFO_USER_ID",intUserId
		GBL_objPubDB.AddField "SHOP_INFO_HITS",0
	End If

	GBL_objPubDB.AddField "SHOP_INFO_TITLE",objDataForm.Item("Title")
	GBL_objPubDB.AddField "SHOP_INFO_TAG",Replace(objDataForm.Item("Tag"),"",";")
	GBL_objPubDB.AddField "SHOP_INFO_CONTENT",objDataForm.Item("Content")
	GBL_objPubDB.AddField "SHOP_INFO_TYPE",objDataForm.Item("Type")
	GBL_objPubDB.AddField "SHOP_INFO_EFFECT",objDataForm.Item("Effect")
	GBL_objPubDB.AddField "SHOP_INFO_STATUS",objDataForm.Item("Status")
	GBL_objPubDB.AddField "SHOP_INFO_TRADE1",objDataForm.Item("Trade1")
	GBL_objPubDB.AddField "SHOP_INFO_TRADE2",objDataForm.Item("Trade2")
	GBL_objPubDB.AddField "SHOP_INFO_PROVINCE",objDataForm.Item("Province")
	GBL_objPubDB.AddField "SHOP_INFO_CITY",objDataForm.Item("City")
	GBL_objPubDB.AddField "SHOP_INFO_ADDRESS",objDataForm.Item("Address")
	GBL_objPubDB.AddField "SHOP_INFO_CONTACT",objDataForm.Item("Contact")
	GBL_objPubDB.AddField "SHOP_INFO_PERSON",objDataForm.Item("Person")
	GBL_objPubDB.AddField "SHOP_INFO_HOMEPAGE",objDataForm.Item("Homepage")
	GBL_objPubDB.AddField "SHOP_INFO_EMAIL",objDataForm.Item("Email")
	
	GBL_objPubDB.AddField "SHOP_INFO_LAST_TIME",GetSysTimeStr()
	GBL_objPubDB.AddField "SHOP_INFO_LAST_IP",objDataForm.Item("LastIp")
	GBL_objPubDB.AddField "SHOP_INFO_LINK_ID",0

	If intShopInfoId <> DB_PK_NULL Then
		If intUserId > 0 Then
			GBL_objPubDB.Where = " 1=1 AND SHOP_INFO_ID=" & intShopInfoId & " AND SHOP_INFO_USER_ID=" & intUserId
		Else
			GBL_objPubDB.Where = " 1=1 AND SHOP_INFO_ID=" & intShopInfoId
		End If
	End If
	
	If Not GBL_objPubDB.SQLExecute() Then
		SaveShopInfoLogic = False
		Exit Function
	End If
	
	'== add tag
	If intShopInfoId = DB_PK_NULL Then intShopInfoId = GetShopInfoMaxIdLogic("")
	Dim strUrl : strUrl = "shop/shop_acc_detail.asp?intShopInfoId=" & intShopInfoId
	Call SaveTagsLogic(intUserId,TAG_TYPE_SHOPINFO,objDataForm.Item("Tag"),intShopInfoId,objDataForm.Item("Title"),strUrl)
	
	'== clear cache
	Call CacheRemove(CACHE_NAME_SHOP_NUM)

	SaveShopInfoLogic = True
End Function

''===================================================================
'= Function    : GetShopInfoMaxIdLogic()
'= Time		   : Created At 2008-1-10
'= Input	   : strWhere : 
'= Return      : boolean
'= Description :  
'==================================================================='
Function GetShopInfoMaxIdLogic(strWhere)
	GBL_objPubDB.Clear()
	GBL_objPubDB.AllSQL = "SELECT MAX(SHOP_INFO_ID) AS MAX_ID FROM CLASS_SHOP_INFO WHERE 1=1 " & strWhere
	If Not GBL_objPubDB.SQLRSExecute() Then
		GetShopInfoMaxIdLogic = -1
		Exit Function
	End If
	GetShopInfoMaxIdLogic = GBL_objPubDB.objPubRS("MAX_ID")
End Function


''===================================================================
'= Function    : GetShopInfoType()
'= Time		   : Created At 2007-8-8
'= Input	   : intVal :  
'= Return      : str
'= Description : Ϣ
'==================================================================='
Function GetShopInfoType(intVal)
	Select Case intVal
		Case 0: GetShopInfoType = "Ӧ" 
		Case 1: GetShopInfoType = "ɹ" 
		Case 2: GetShopInfoType = ""
		Case 3: GetShopInfoType = "" 
		Case 4: GetShopInfoType = "" 
		Case 5: GetShopInfoType = "Ƹ" 
		Case 6: GetShopInfoType = "ƷϢ" 
		Case 7: GetShopInfoType = "ҵϢ" 
		Case 8: GetShopInfoType = "" 
	End Select
End Function

''===================================================================
'= Function    : GetShopInfoStatus()
'= Time		   : Created At 2007-8-8
'= Input	   : intVal :  
'= Return      : str
'= Description : Ϣ״̬
'==================================================================='
Function GetShopInfoStatus(intVal)
	Select Case intVal
		Case 0: GetShopInfoStatus = "ͨ" 
		Case 1: GetShopInfoStatus = "ͨ" 
	End Select
End Function

%>