﻿<%
Class Cls_TempLate
	Private ITempLate,InBlock,InSelect,XMLDoc,XMLDom,XMLSQL,Node,EachNode
	Private RegExp,Matches,Match,SubMatch,CacheName,IDecode
	Private TagName,TagXml,ErrCode,RsArray,IWhere,InSQL,IPageCount,ITotal,IPage,IStrUrl
	Private IAction,IShowpage,IMaxnum,ILength,IUserid,IChannelid,IClassid,IProvince,TempUrl
	Private ITarget,IArray,ICache,IChecked,IParentID,ISortID,IDataID,IOriginal,Expression,ITransfer
	Private ICity,IOrder,IBy,IDate,IRelation,IStrLen,IGroupBy,IPrimary,ISetting
	Private Sub class_Initialize
		InBlock=""''传入标签
		Set RegExp = New RegExp
		RegExp.IgnoreCase = True
		RegExp.Global = True
		Set XMLDoc=Nslove.CreateXmlDoc("Msxml2.FreeThreadedDOMDocument")
		Set NsSQL=New Cls_SQL
		IPageCount=0:ITotal=0:IDecode=0
		ICache=""
	End Sub
	
	PrIvate Sub Class_TermInate()''关闭类
		If IsObject(NsSQL) Then Set NsSQL = NothIng
		'If IsObject(XMLDoc) Then Set XMLDoc = NothIng
		'If IsObject(RegExp) Then Set RegExp = NothIng
	End Sub
	
	Private Function CacheIsObject()
		CacheIsObject = False
		Dim dLastime
		If Len(ICache)= 0 Then Exit Function
		If Not IsObject(Application(CacheName)) then Exit Function''判断缓存对象
		dLastime = Application(CacheName&"_time")
		If ""<>dLastime And DateDiff("s", CDate(dLastime), Now()) <= CLng(60*Clng(Nslove.Ns_Setting(51))) Then
			CacheIsObject = True
		Else
			Application.Lock
			Application(CacheName&"_time")=Now()
			Application.UnLock
			CacheIsObject = False
		End If
	End Function

	Private Function UpdateCache()
		If Len(ICache)= 0 Then Exit Function
		Application.Lock
		Set Application(CacheName)=XMLSQL
		Application.unLock
	End Function
	
	Public Property Let TPL_Html(ByVal vNewValue)
		ITempLate = vNewValue
	End Property
	
	Public Property Let TPL_SQL(ByVal vNewValue)
		InSQL = vNewValue
	End Property
	
	Public Property Get TempLate()
		TempLate=ITempLate
	End Property
	
	Public Property Let TPL_Block(ByVal vNewValue)''类输入定位块
		InBlock = Lcase(vNewValue)
	End Property
	
	Public Property Let TPL_XmlDe(ByVal vNewValue)''10-4-24增加处理xml转换开关
		IDecode= Lcase(vNewValue)
	End Property
	
	Public Property Let TPL_StrUrl(ByVal vNewValue)''翻页地址
		TempUrl= Lcase(vNewValue)
	End Property
	
	Public Property Let TPL_Original(ByVal vNewValue)''原样传递
		IOriginal= Lcase(vNewValue)
	End Property
	
	Private Function XmlDecode(ByVal vNewValue)''处理转换Xml内容
		Dim i,XmlValue
		XmlValue=vNewValue
		XmlValue= Replace(XmlValue,"&amp;","&")
		XmlValue=Replace(XmlValue,"&lt;","<")
		XmlValue=Replace(XmlValue,"&gt;",">")
		For i = 0 to 31
			XmlValue= Replace(XmlValue,"&#"&i&";",Chr(i))
		Next
		For i = 95 to 96
			XmlValue= Replace(XmlValue,"&#"&i&";",Chr(i))
		Next
		XmlDecode=XmlValue
	End Function
	
	Public Sub TPL_Scan()''标签查找
		RegExp.Pattern = "{\$if:(\w*?)}([\s\S.]*?){\$endif:\1}"''条件块区配处理
		Set Matches = RegExp.Execute(ITempLate)
		For Each Match in Matches
			TagName=Lcase(Match.SubMatches(0))
			SubMatch = Match.SubMatches(1)
			If InStr(","&InBlock&",",","&TagName&",")>0 then''12-24为标签多元素数组
			'if TagName=InBlock then
				ITempLate=Replace(ITempLate,Match.value,SubMatch)
			end if
			
			'response.write TagName
			'response.end
		Next
		ITempLate=RegExp.Replace(ITempLate,"")
		RegExp.Pattern = "{\$xml:(\w*)([\s\S\.]*?)}"''xml标签处理
		Set Matches = RegExp.Execute(ITempLate)
		For Each Match in Matches
			TagName = Lcase(Match.SubMatches(0))
			SubMatch = Match.SubMatches(1)
			TagXml=AppendXmlNode(SubMatch)''Xml处理返回数据
			ITempLate=Replace(ITempLate,Match.Value,TagXml)
			'response.write TagXml
			'response.end
		Next
	End Sub
	
	Public Sub TPL_Flush()
		ITempLate=Nslove.ExReplace(ITempLate,"Chl.KeyWord",Nslove.ChlKeyWord)
		ITempLate=Nslove.ExReplace(ITempLate,"Chl.Description",Nslove.ChlDescription)
		If Nslove.Ns_Setting(28) = "1" Then''是否显示执行时间
			Dim Endtime:Endtime = Timer()
			ITempLate= Nslove.ExReplace(ITempLate,"Sys.RunTime","页面执行时间 0"&FormatNumber((Endtime-Startime),5)&" 秒")
		Else
			ITempLate= Nslove.ExReplace(ITempLate,"Sys.RunTime","")
		End If
	End Sub
	
	Public Sub TPL_Paste()
		Response.write ITempLate
	End Sub
	
	Private Function AppendXmlNode(StrAttrib)
		dim XslFile
		If XMLDoc.LoadXML("<xml><data " & StrAttrib &"/></xml>") Then
			Set Node=XMLDoc.documentElement.selectSingleNode("data")
			If Not (Node Is Nothing) Then
				XslFile = CheckFileName(Node.getAttribute("file"))
				If ""=XslFile Then XslFile = CheckFileName(TagName)
				AppendXmlNode= XMLDocument(XslFile)
			End If
			Set Node=Nothing
		Else
			
			AppendXmlNode = "载入"&TagName&"标签错误，此标签不符合XML标准。"
		End If
	End Function
	
	''
	Private Function XMLDocument(XslFile)
		Call SetDefaultXml()
		Select Case TagName
			Case "diary":			Call LoadDiaryList()
			Case "klatch":			Call LoadKlatchList()
			Case "debate":			Call LoadDebateList()
			Case "pk":				Call LoadPkList()
			Case "reward":			Call LoadRewardList()
			Case "try":				Call LoadTryList()
			Case "party":			Call LoadPartyList()
			Case "ask":			Call LoadAskList()
			Case "user":			Call LoadUserList()
			Case "count":			Call LoadUCount()
			Case "high":			Call LoadUserHigh()
			Case "clicked":			Call LoadClickList()
			Case "images":			Call LoadUpload()
			Case "friend":			Call LoadFriend()
			Case "usermsg":			Call LoadUserMsg()
			Case "certify":			Call LoadCertify()
			Case "giftsort":			Call LoadGiftSort()
			Case "giftbox":			Call LoadGiftBox()
			Case "giftlist":			Call LoadGiftList()
			Case "myservice":			Call LoadMyService()
			Case "service":			Call LoadService()
			Case "guard":			Call LoadGuard()
			Case "match":			Call LoadMatch()''会员匹配条件
			Case "wedding":			Call LoadWedding()''婚庆服务项目
			Case "bank":			Call LoadBank()''绑定银行
			Case "drawal":			Call LoadDrawal()''提现
			Case "station"			Call LoadStation()
			Case "cooperate"			Call LoadCooperate()''申请活动合作
			Case "agent"			Call LoadAgent()''商家
			Case "story":			Call LoadStory()
			Case "article":			Call LoadArticle()''文章
			Case "help":			Call LoadHelp()''帮助
			Case "complain":			Call LoadComplain()''举报反馈
			Case "link":			Call LoadLinkList()''友情链接
			Case "userjoin":			Call LoadUserJoin()''报名列表管理
			Case "board":			Call LoadBoardList()''群组版块
			Case "group":			Call LoadGroupList()''群组
			Case "grade":			Call LoadGradeList()''群组等级
			Case "topic":			Call LoadGrpTopic()''群组话题
			Case "order"			Call LoadOrderList()''订单
			Case "money"			Call LoadMoneyList()''金币记录
			Case "other":			Call LoadOtherList()''其它调用
			Case "test":			Call LoadTestList()''测试题
			Case "mettle":			Call LoadMettleList()''16性格
			Case "paper":			Call LoadPaperList()''测试题
			Case "wall":			Call LoadWallList()''祈愿墙
			Case "wallsort":			Call LoadWallSort()''装饰
			Case "remark":			Call LoadReMark()
			Case "heart":			Call LoadMyHeart()''签名
			Case "star":			Call LoadMyStar()''星座匹配
			Case "invite":			Call LoadInvite()''邀请码
			Case "tag":			Call LoadTagList()''标签列表
			Case "query":			Call LoadQueryList()''条件保存
			Case "province":			Call LoadProvince()''省份
			Case "class":			Call LoadClassList()''小类分类
			Case "channel":			Call LoadChannel()''频道分类
			Case "showpage":			Call LoadShowPage()''显示分页
		End Select
		
		if ""=XslFile Then
			
		Else
			XMLDocument=Nslove.TransformXSLT(XslFile,XMLSQL)
			if IDecode=1 then XMLDocument=XmlDecode(XMLDocument)
		End if
	End Function
	
	Private Sub SetDefaultXml()
		IWhere="":IOrder="":IShowPage=0:IBy=0:IDate=0:ILength=0:IChecked=-1:ISortID=0
		IUserid=0:IChannelid=0:IClassid=0:IProvince=0:ICity=0:ITarget="_blank":IParentID=0:ITransfer=0
		IArray=0:IStrUrl="":IDataID="":Expression="":IRelation=0:IStrLen=0:IGroupBy="":IPrimary="":ISetting=""
		IPage=Nslove.ChkNumeric(Request("page"))
		if IPage=0 then IPage=1
		Set Node=XMLDoc.documentElement.selectSingleNode("data")
		if Not (Node is Nothing) Then
			if Not (Node.selectSingleNode("@action")) is Nothing Then IAction=Nslove.ChkNumeric(Node.selectSingleNode("@action").text)
			if Not (Node.selectSingleNode("@showpage")) is Nothing Then IShowPage=Nslove.ChkNumeric(Node.selectSingleNode("@showpage").text)
			if Not (Node.selectSingleNode("@maxnum")) is Nothing Then IMaxNum=Nslove.ChkNumeric(Node.selectSingleNode("@maxnum").text)
			if Not (Node.selectSingleNode("@length")) is Nothing Then ILength=Nslove.ChkNumeric(Node.selectSingleNode("@length").text)
			if Not (Node.selectSingleNode("@strlen")) is Nothing Then IStrLen=Nslove.ChkNumeric(Node.selectSingleNode("@strlen").text)''内容长度
			if Not (Node.selectSingleNode("@userid")) is Nothing Then IUserID=Nslove.ChkNumeric(Node.selectSingleNode("@userid").text)
			if Not (Node.selectSingleNode("@channelid")) is Nothing Then IChannelID=Nslove.ChkNumeric(Node.selectSingleNode("@channelid").text)
			if Not (Node.selectSingleNode("@classid")) is Nothing Then IClassID=Nslove.ChkNumeric(Node.selectSingleNode("@classid").text)
			if Not (Node.selectSingleNode("@province")) is Nothing then IProvince=Nslove.ChkNumeric(Node.selectSingleNode("@province").text)
			if Not (Node.selectSingleNode("@city")) is Nothing Then ICity=Nslove.ChkNumeric(Node.selectSingleNode("@city").text)
			if Not (Node.selectSingleNode("@checked")) is Nothing Then IChecked=Nslove.ChkNumeric(Node.selectSingleNode("@checked").text)
			if Not (Node.selectSingleNode("@parentid")) is Nothing Then IParentID=Nslove.ChkNumeric(Node.selectSingleNode("@parentid").text)
			if Not (Node.selectSingleNode("@sortid")) is Nothing Then ISortID=Nslove.ChkNumeric(Node.selectSingleNode("@sortid").text)
			if Not (Node.selectSingleNode("@dataid")) is Nothing Then IDataID=Nslove.CheckStr(Node.selectSingleNode("@dataid").text)
			if Not (Node.selectSingleNode("@order")) is Nothing Then IOrder=Nslove.CheckBad(Node.selectSingleNode("@order").text)
			if Not (Node.selectSingleNode("@by")) is Nothing Then IBy=Nslove.ChkNumeric(Node.selectSingleNode("@by").text)
			if Not (Node.selectSingleNode("@groupby")) is Nothing Then IGroupBy=Nslove.CheckBad(Node.selectSingleNode("@groupby").text)
			if Not (Node.selectSingleNode("@date")) is Nothing Then IDate=Nslove.ChkNumeric(Node.selectSingleNode("@date").text)
			if Not (Node.selectSingleNode("@target")) is Nothing Then ITarget=Nslove.CheckStr(Node.selectSingleNode("@target").text)
			if Not (Node.selectSingleNode("@relation")) is Nothing Then IRelation=Nslove.ChkNumeric(Node.selectSingleNode("@relation").text)''是否关联
			if Not (Node.selectSingleNode("@array")) is Nothing Then IArray=Nslove.ChkNumeric(Node.selectSingleNode("@array").text)
			if Not (Node.selectSingleNode("@expression")) is Nothing Then Expression=Nslove.CheckBad(Node.selectSingleNode("@expression").text)''表达式
			if Not (Node.selectSingleNode("@transfer")) is Nothing Then ITransfer=Nslove.ChkNumeric(Node.selectSingleNode("@transfer").text)''条件开关
			if Not (Node.selectSingleNode("@primary")) is Nothing Then IPrimary=Nslove.CheckBad(Node.selectSingleNode("@primary").text)
			if Not (Node.selectSingleNode("@setting")) is Nothing Then ISetting=Nslove.CheckBad(Node.selectSingleNode("@setting").text)''会员头像设置
			if Not (Node.selectSingleNode("@cache")) is Nothing Then
				ICache=Nslove.CheckStr(Node.selectSingleNode("@cache").text)
			Else
				ICache=""
			end if
			CacheName=Nslove.CacheName & "_xml_"&ICache
		end if
		Set Node=nothing
		If ITransfer>0 and InSQL<>"" then IWhere=InSQL''修改由标签加入传递开关10-2-1
		if IUserID<>0 then
			if Len(IWhere)>0 then
				IWhere=IWhere&" and UserID="&IUserID
			Else
				IWhere=" UserID="&IUserID
			end if
			IStrUrl=IStrUrl&"&userid="&IUserID
		end if
		if IChannelID<>0 then
			if Len(IWhere)>0 then
				IWhere=IWhere&" and ChannelID="&IChannelID
			Else
				IWhere=" ChannelID="&IChannelID
			end if
			IStrUrl=IStrUrl&"&channelid="&IChannelID
		end if
		if IClassID<>0 then
			if Len(IWhere)>0 then
				IWhere=IWhere&" and ClassID="&IClassID
			Else
				IWhere=" ClassID="&IClassID
			end if
			IStrUrl=IStrUrl&"&classid="&IClassID
		end if
		if IProvince<>0 then
			if Len(IWhere)>0 then
				IWhere=IWhere&" and Province="&IProvince
			Else
				IWhere=" Province="&IProvince
			end if
			IStrUrl=IStrUrl&"&province="&IProvince
		end if
		if ICity<>0 then
			if Len(IWhere)>0 then
				IWhere=IWhere&" and City="&ICity
			Else
				IWhere=" City="&ICity
			end if
			IStrUrl=IStrUrl&"&city="&ICity
		end if
		if IChecked>-1 then
			if Len(IWhere)>0 then
				IWhere=IWhere&" and Checked="&IChecked
			Else
				IWhere=" Checked="&IChecked
			end if
			IStrUrl=IStrUrl&"&Checked="&IChecked
		end if
		if IParentID>0 then
			if Len(IWhere)>0 then
				IWhere=IWhere&" and ParentID="&IParentID
			Else
				IWhere=" ParentID="&IParentID
			end if
			IStrUrl=IStrUrl&"&ParentID="&IParentID
		end if
		if ISortID>0 then
			if Len(IWhere)>0 then
				IWhere=IWhere&" and SortID="&ISortID
			Else
				IWhere=" SortID="&ISortID
			end if
			IStrUrl=IStrUrl&"&SortID="&ISortID
		end if
		if Len(IDataID)>0 then
			if Len(IWhere)>0 then
				IWhere=IWhere&" and ID in("&IDataID&")"
			Else
				IWhere="  ID in("&IDataID&")"
			end if
			IStrUrl=IStrUrl&"&DataID="&IDataID
		end if
		if Len(Expression)>0 Then''条件表达式
			Expression=Replace(Replace(Expression,"＜","<"),"＞",">")
			if Len(IWhere)>0 then
				IWhere=IWhere&" and "&Expression&""
			Else
				IWhere=Expression
			end if
			IStrUrl=IStrUrl&Replace(Replace(Expression," and ","&"),">","=")
		end if
		IStrUrl=TempUrl&IStrUrl
		IStrUrl=FormatHref()
	End Sub
	
	Private Sub LoadSqlStr(TableName,FieldStr)''通用SQL查询构造
		if IMaxNum<>0 then''取出值为0时不设置top
			NsSQL.MaxPage=IMaxNum
		End if
		if IShowPage=1 then
			NsSQL.Page=IPage
			NsSQL.StrUrl=IStrUrl
			if IMaxNum=0 then IMaxNum=Cint(Nslove.Ns_Setting(29))
			NsSQL.MaxPage=IMaxNum
			if Len(IPrimary)>0 then NsSQL.Key=IPrimary
		end if
		NsSQL.Order=IOrder
		NsSQL.By=IBy
		if Len(IGroupBy)>0 then''2010-4-3增加查询不重复记录
			dim GWhere,TWhere,ByTable:ByTable=TableName
			GWhere="":TWhere=""
			if Len(Expression)>0 then
				GWhere=" Where "&Expression
			end if
			if IRelation=1 then
				ByTable=Split(TableName,",")(0)''取出主表名
				TWhere="P.ID in (Select min(ID) From "&ByTable &" "&GWhere&" Group By "&IGroupBy &")"
			else
				TWhere="ID in (Select min(ID) From "&ByTable &" "&GWhere&"  Group By "&IGroupBy &")"
			end if
			if Len(IWhere)>0 then
				IWhere=IWhere&" and "&TWhere
			else
				IWhere=TWhere
			end if
		end if
		NsSQL.Where=IWhere
		NsSQL.FieldStr=FieldStr
		NsSQL.Table=TableName
		if IShowPage=1 then
			NsSQL.RunSql()
			IPageCount=NsSQL.PageCount
			ITotal=NsSQL.Totalrec
		Else
			NsSQL.RunSelect()
		end if
		ErrCode=NsSQL.ErrCode
		if ErrCode=0 then
			Set XMLSQL=NsSQL.GetRow
			XmlAttribute "/xml","action",IAction''动作方式
		Else
			Set XMLSQL=XMLDoc
			XmlAttribute "/xml","action","nodata"''动作方式
		end if
	End Sub
	
	Private Sub LoadChannel()''频道分类
		Set XMLSQL=Application(Nslove.CacheName&"_channel")
		XmlAttribute "/xml","action",IAction
	End Sub
	
	Private Sub LoadClassList()''小类分类
		if Not IsObject(Application(Nslove.CacheName &"_classlist_" & IChannelID)) then
			Call Nslove.LoadClassList(IChannelID)
		end if
		Set XMLSQL=Application(Nslove.CacheName &"_classlist_" & IChannelID)
		XmlAttribute "/xml","action",IAction
		XmlAttribute "/xml","selectid",ISortID
	End Sub
	
	Private Sub LoadUserMsg()
		If Not CacheIsObject Then
			if IRelation=1 then
				'if Len(IWhere)>0 then
				'	IWhere=IWhere&" and P.UserID=F.UserID"
				'Else
				'	IWhere="P.UserID=F.UserID"
				'end if
				Call LoadSqlStr(""&SqlKeyName&"Message P,"&SqlKeyName&"User F","P.*,F.UserName,F.UserFace,F.UserInfo,F.UserNote,F.ZoneTxt")
			else
				Call LoadSqlStr(""&SqlKeyName&"Message","*")
			end if
			If Not (XMLSQL Is Nothing) and ErrCode=0 Then
				For Each Node in XMLSQL.documentElement.SelectNodes("data")
					if IRelation=1 then
						Node.selectSingleNode("@userface").text=Nslove.ShowFace(Node.selectSingleNode("@userface").text)
						Node.selectSingleNode("@userinfo").text=Split(Node.selectSingleNode("@userinfo").text,"|")(IArray)
						Node.selectSingleNode("@usernote").text=Nslove.CutStr(Node.selectSingleNode("@usernote").text,ILength)
					end if
					Node.selectSingleNode("@content").text=Nslove.CutStr(Node.selectSingleNode("@content").text,IStrLen)
					Node.selectSingleNode("@title").text=Nslove.CutStr(Node.selectSingleNode("@title").text,ILength)
					Node.selectSingleNode("@addtime").text=Nslove.FormatDate(Node.selectSingleNode("@addtime").text,IDate)
					SetLinkNode Node,Node.selectSingleNode("@userid").text,"homepage",2
				Next
				Set Node=nothing
				UpdateCache
			end if
		Else
			Set XMLSQL=Application(CacheName)
		end if
	End Sub
	
	Private Sub LoadUpload()
		If Not CacheIsObject Then
			Call LoadSqlStr(""&SqlKeyName&"Upload","*")
			If Not (XMLSQL Is Nothing) and ErrCode=0 Then
				For Each Node in XMLSQL.documentElement.SelectNodes("data")
					if IChannelID=1 then''增加对头像设置2010-08-26
						if Len(ISetting)>0 then
							Node.selectSingleNode("@filesview").text=ISetting
						end if
					end if
					Node.selectSingleNode("@addtime").text=Nslove.FormatDate(Node.selectSingleNode("@addtime").text,IDate)
					SetLinkNode Node,Node.selectSingleNode("@userid").text,"homepage",2
				Next
				UpdateCache
			end if
		Else
			Set XMLSQL=Application(CacheName)
		End if
	End Sub
	
	Private Sub LoadMyStar()
		If Not CacheIsObject Then
			Call LoadSqlStr(""&SqlKeyName&"StarMatch","*")
			If Not (XMLSQL Is Nothing) and ErrCode=0 Then
				UpdateCache
			end if
		Else
			Set XMLSQL=Application(CacheName)
		End if
	End Sub
	
	Private Sub LoadInvite()
		If Not CacheIsObject Then
			Call LoadSqlStr(""&SqlKeyName&"Invite","*")
			If Not (XMLSQL Is Nothing) and ErrCode=0 Then
				For Each Node in XMLSQL.documentElement.SelectNodes("data")
					Node.selectSingleNode("@overtime").text=Nslove.FormatDate(Node.selectSingleNode("@overtime").text,IDate)
				Next
				XmlAttribute "/xml","domain",Nslove.Ns_Domain
				UpdateCache
			end if
		Else
			Set XMLSQL=Application(CacheName)
		End if
	End Sub
	
	Private Sub LoadLinkList()
		If Not CacheIsObject Then
			Call LoadSqlStr(""&SqlKeyName&"Links","*")
			If Not (XMLSQL Is Nothing) and ErrCode=0 Then
				For Each Node in XMLSQL.documentElement.SelectNodes("data")
					Node.selectSingleNode("@content").text=Nslove.CutStr(Node.selectSingleNode("@content").text,IStrLen)
					Node.selectSingleNode("@title").text=Nslove.CutStr(Node.selectSingleNode("@title").text,ILength)
					Node.selectSingleNode("@addtime").text=Nslove.FormatDate(Node.selectSingleNode("@addtime").text,IDate)
					SetLinkNode Node,"","",0
				Next
				UpdateCache
			end if
		Else
			Set XMLSQL=Application(CacheName)
		End if
	End Sub
	
	Private Sub LoadOtherList()
		If Not CacheIsObject Then
			Call LoadSqlStr(""&SqlKeyName&"Other","*")
			If Not (XMLSQL Is Nothing) and ErrCode=0 Then
				For Each Node in XMLSQL.documentElement.SelectNodes("data")
					Node.selectSingleNode("@title").text=Nslove.CutStr(Node.selectSingleNode("@title").text,ILength)
				Next
				UpdateCache
			end if
		Else
			Set XMLSQL=Application(CacheName)
		End if
	End Sub
	
	Private Sub LoadDrawal()
		If Not CacheIsObject Then
			Call LoadSqlStr(""&SqlKeyName&"Drawal","*")
			If Not (XMLSQL Is Nothing) and ErrCode=0 Then
				For Each Node in XMLSQL.documentElement.SelectNodes("data")
					Node.selectSingleNode("@addtime").text=Nslove.FormatDate(Node.selectSingleNode("@addtime").text,IDate)
				Next
				UpdateCache
			end if
		Else
			Set XMLSQL=Application(CacheName)
		End if
	End Sub
	
	Private Sub LoadMyHeart()
		If Not CacheIsObject Then
			Call LoadSqlStr(""&SqlKeyName&"UserSign","*")
			If Not (XMLSQL Is Nothing) and ErrCode=0 Then
				For Each Node in XMLSQL.documentElement.SelectNodes("data")
					Node.selectSingleNode("@addtime").text=Nslove.FormatDate(Node.selectSingleNode("@addtime").text,IDate)
					SetLinkNode Node,Node.selectSingleNode("@userid").text,"homepage",2
				Next
				UpdateCache
			end if
		Else
			Set XMLSQL=Application(CacheName)
		End if
	End Sub
	
	Private Sub LoadQueryList()''高级会员条件列表
		If Not CacheIsObject Then
			Call LoadSqlStr(""&SqlKeyName&"Search","*")
			If Not (XMLSQL Is Nothing) and ErrCode=0 Then
				For Each Node in XMLSQL.documentElement.SelectNodes("data")
					Node.selectSingleNode("@addtime").text=Nslove.FormatDate(Node.selectSingleNode("@addtime").text,IDate)
				Next
				UpdateCache
			end if
		Else
			Set XMLSQL=Application(CacheName)
		End if
	End Sub
	
	Private Sub LoadTestList()
		dim PaperArr,J,ValArr,P:P=0
		If Not CacheIsObject Then
			Call LoadSqlStr(""&SqlKeyName&"Test","*")
			If Not (XMLSQL Is Nothing) and ErrCode=0 Then
				For Each Node in XMLSQL.documentElement.SelectNodes("data")
					if inStr(Node.selectSingleNode("@subject").text,"|")>0 then''用户提交考题
						PaperArr=Split(Node.selectSingleNode("@subject").text,"|")
						For J=0 to Ubound(PaperArr)
							Node.setAttribute "paper"&J,PaperArr(J)
						Next
						Node.selectSingleNode("@subject").text=""
						Node.setAttribute "answer",""
						if Len(IOriginal)>0 then
							ValArr=Split(IOriginal,"|")(P)
							Node.setAttribute "answer",ValArr
							P=P+1
						end if
					End if
				Next
				UpdateCache
			end if
		Else
			Set XMLSQL=Application(CacheName)
		End if
	End Sub
	
	Private Sub LoadMettleList()
		If Not CacheIsObject Then
			Call LoadSqlStr(""&SqlKeyName&"Test_Mettle","*")
			If Not (XMLSQL Is Nothing) and ErrCode=0 Then
				UpdateCache
			end if
		Else
			Set XMLSQL=Application(CacheName)
		End if
	End Sub
	
	Private Sub LoadPaperList()
		If Not CacheIsObject Then
			if IRelation=1 then
				'if Len(IWhere)>0 then
				'	IWhere=IWhere&" and P.UserID=F.UserID"
				'Else
				'	IWhere="P.UserID=F.UserID"
				'end if
				Call LoadSqlStr(""&SqlKeyName&"Test_Paper P,"&SqlKeyName&"User F","P.*,F.UserName,F.UserInfo,F.UserFace")
			else
				Call LoadSqlStr(""&SqlKeyName&"Test_Paper","*")
			end if
			If Not (XMLSQL Is Nothing) and ErrCode=0 Then
				For Each Node in XMLSQL.documentElement.SelectNodes("data")
					if IRelation=1 then
						Node.selectSingleNode("@userface").text=Nslove.ShowFace(Node.selectSingleNode("@userface").text)
						Node.selectSingleNode("@userinfo").text=Split(Node.selectSingleNode("@userinfo").text,"|")(IArray)
					end if
					Node.selectSingleNode("@addtime").text=Nslove.FormatDate(Node.selectSingleNode("@addtime").text,IDate)
					SetLinkNode Node,Node.selectSingleNode("@userid").text,"homepage",2
				Next
				Set Node=nothing
				UpdateCache
			end if
		Else
			Set XMLSQL=Application(CacheName)
		End if
	End Sub
	
	Private Sub LoadWallList()
		dim T,L,Z,ModID,TopSkin,J:J=0
		ModID=Nslove.ChkNumeric(Request("mod"))
		If Not CacheIsObject Then
			if IRelation=1 then
				if Len(IWhere)>0 then
					IWhere=IWhere&" and P.FUserID=F.UserID"
				Else
					IWhere="P.FUserID=F.UserID"
				end if
				Call LoadSqlStr(""&SqlKeyName&"Pray P,"&SqlKeyName&"User F","P.*,F.UserFace,F.UserInfo")
			else
				Call LoadSqlStr(""&SqlKeyName&"Pray","*")
			end if
			If Not (XMLSQL Is Nothing) and ErrCode=0 Then
				For Each Node in XMLSQL.documentElement.SelectNodes("data")
					TopSkin=""
					If ModID=0 then
						T=Int(510*Rnd+20)
						L=Int(680*Rnd+20)
						Z=IMaxNum-J
					end if
					if IRelation=1 then
					Node.selectSingleNode("@userface").text=Nslove.ShowFace(Node.selectSingleNode("@userface").text)
					Node.selectSingleNode("@userinfo").text=Split(Node.selectSingleNode("@userinfo").text,"|")(IArray)
					end if
					Node.selectSingleNode("@addtime").text=Nslove.FormatDate(Node.selectSingleNode("@addtime").text,IDate)
					Node.selectSingleNode("@content").text=Nslove.CutStr(Node.selectSingleNode("@content").text,IStrLen)
					if Clng(Node.selectSingleNode("@istop").text)>0 then TopSkin="istop"&Node.selectSingleNode("@istop").text
					Node.setAttribute "topskin",TopSkin
					Node.setAttribute "topdiv",T
					Node.setAttribute "leftdiv",L
					Node.setAttribute "zindex",Z
					J=J+1
				Next
				Set Node=nothing
				UpdateCache
			end if
		Else
			Set XMLSQL=Application(CacheName)
		End if
	End Sub
	
	Private Sub LoadWallSort()''装饰
		If Not CacheIsObject Then
			Call LoadSqlStr(""&SqlKeyName&"Pray_Sort","*")
			If Not (XMLSQL Is Nothing) and ErrCode=0 Then
				UpdateCache
			end if
		Else
			Set XMLSQL=Application(CacheName)
		end if
	End Sub
	
	Private Sub LoadProvince()''省
		If Not CacheIsObject Then
			Call LoadSqlStr(""&SqlKeyName&"ZipCode","*")
			If Not (XMLSQL Is Nothing) and ErrCode=0 Then
				UpdateCache
			end if
		Else
			Set XMLSQL=Application(CacheName)
		end if
	End Sub
	
	Private Sub LoadBank()''银行帐户
		If Not CacheIsObject Then
			Call LoadSqlStr(""&SqlKeyName&"Bank","*")
			If Not (XMLSQL Is Nothing) and ErrCode=0 Then
				UpdateCache
			end if
		Else
			Set XMLSQL=Application(CacheName)
		end if
	End Sub
	
	Private Sub LoadCooperate()''申请活动合作
		If Not CacheIsObject Then
			Call LoadSqlStr(""&SqlKeyName&"Cooperate","*")
			If Not (XMLSQL Is Nothing) and ErrCode=0 Then
				For Each Node in XMLSQL.documentElement.SelectNodes("data")
					Node.setAttribute "sortname",Nslove.ClassNode(Node.selectSingleNode("@sortid").text,11)
					Node.selectSingleNode("@addtime").text=Nslove.FormatDate(Node.selectSingleNode("@addtime").text,IDate)
					SetLinkNode Node,Node.selectSingleNode("@userid").text,"homepage",2
				Next
				UpdateCache
			end if
		Else
			Set XMLSQL=Application(CacheName)
		end if
	End Sub
	
	Private Sub LoadGuard()''安全交友
		If Not CacheIsObject Then
			Call LoadSqlStr(""&SqlKeyName&"Guard","*")
			If Not (XMLSQL Is Nothing) and ErrCode=0 Then
				For Each Node in XMLSQL.documentElement.SelectNodes("data")
					Node.selectSingleNode("@content").text=Nslove.CutStr(Node.selectSingleNode("@content").text,IStrLen)
					Node.selectSingleNode("@title").text=Nslove.CutStr(Node.selectSingleNode("@title").text,ILength)
					Node.selectSingleNode("@addtime").text=Nslove.FormatDate(Node.selectSingleNode("@addtime").text,IDate)
					SetLinkNode Node,Node.selectSingleNode("@id").text,"link1",39
				Next
				UpdateCache
			end if
		Else
			Set XMLSQL=Application(CacheName)
		end if
	End Sub
	
	Private Sub LoadReMark()
		If Not CacheIsObject Then
			if IRelation=1 then
				if Len(IWhere)>0 then
					IWhere=IWhere&" and P.UserID=F.UserID"
				Else
					IWhere="P.UserID=F.UserID"
				end if
				Call LoadSqlStr(""&SqlKeyName&"Marks P,"&SqlKeyName&"User F","P.*,F.UserFace,F.UserInfo,F.UserNote")
			else
				Call LoadSqlStr(""&SqlKeyName&"Marks","*")
			end if
			If Not (XMLSQL Is Nothing) and ErrCode=0 Then
				For Each Node in XMLSQL.documentElement.SelectNodes("data")
					if IRelation=1 then
					Node.selectSingleNode("@userface").text=Nslove.ShowFace(Node.selectSingleNode("@userface").text)
					Node.selectSingleNode("@userinfo").text=Split(Node.selectSingleNode("@userinfo").text,"|")(IArray)
					end if
					Node.selectSingleNode("@addtime").text=Nslove.FormatDate(Node.selectSingleNode("@addtime").text,IDate)
					SetLinkNode Node,Node.selectSingleNode("@userid").text,"homepage",2
				Next
				Set Node=nothing
				UpdateCache
			end if
		Else
			Set XMLSQL=Application(CacheName)
		end if
	End Sub
	
	Private Sub LoadOrderList()
		If Not CacheIsObject Then
			Call LoadSqlStr(""&SqlKeyName&"Orders","*")
			If Not (XMLSQL Is Nothing) and ErrCode=0 Then
				For Each Node in XMLSQL.documentElement.SelectNodes("data")
					Node.selectSingleNode("@addtime").text=Nslove.FormatDate(Node.selectSingleNode("@addtime").text,IDate)
					SetLinkNode Node,Node.selectSingleNode("@userid").text,"homepage",2
				Next
				UpdateCache
			end if
		Else
			Set XMLSQL=Application(CacheName)
		End if
	End Sub
	
	Private Sub LoadMoneyList()
		If Not CacheIsObject Then
			if IRelation=1 then
				if IWhere<>"" then
					IWhere=IWhere&" and P.UserID=F.UserID"
				Else
					IWhere="P.UserID=F.UserID"
				end if
				Call LoadSqlStr(""&SqlKeyName&"MoneyLog P,"&SqlKeyName&"User F","P.*,F.UserFace,F.UserInfo")
			else
				Call LoadSqlStr(""&SqlKeyName&"MoneyLog","*")
			end if
			If Not (XMLSQL Is Nothing) and ErrCode=0 Then
				For Each Node in XMLSQL.documentElement.SelectNodes("data")
					Node.selectSingleNode("@addtime").text=Nslove.FormatDate(Node.selectSingleNode("@addtime").text,IDate)
					SetLinkNode Node,Node.selectSingleNode("@userid").text,"homepage",2
				Next
				UpdateCache
			end if
		Else
			Set XMLSQL=Application(CacheName)
		End if
	End Sub
		''以下为取出数据
	Private Sub LoadDiaryList()
		If Not CacheIsObject Then
			if IRelation=1 then
				if IWhere<>"" then
					IWhere=IWhere&" and P.UserID=F.UserID"
				Else
					IWhere="P.UserID=F.UserID"
				end if
				Call LoadSqlStr(""&SqlKeyName&"Diary P,"&SqlKeyName&"User F","P.*,F.UserFace,F.UserInfo")
			else
				Call LoadSqlStr(""&SqlKeyName&"Diary","*")
			end if
			If Not (XMLSQL Is Nothing) and ErrCode=0 Then
				For Each Node in XMLSQL.documentElement.SelectNodes("data")
					if IRelation=1 then
					Node.selectSingleNode("@userface").text=Nslove.ShowFace(Node.selectSingleNode("@userface").text)
					Node.selectSingleNode("@userinfo").text=Split(Node.selectSingleNode("@userinfo").text,"|")(IArray)
					end if
					Node.selectSingleNode("@content").text=Nslove.CutStr(Node.selectSingleNode("@content").text,IStrLen)
					Node.selectSingleNode("@title").text=Nslove.CutStr(Node.selectSingleNode("@title").text,ILength)
					Node.selectSingleNode("@addtime").text=Nslove.FormatDate(Node.selectSingleNode("@addtime").text,IDate)
					SetLinkNode Node,Node.selectSingleNode("@userid").text,"homepage",2
					SetLinkNode Node,Node.selectSingleNode("@id").text,"link1",9
					Node.setAttribute "sortname",Nslove.ClassNode(Node.selectSingleNode("@sortid").text,9)
				Next
				Set Node=nothing
				UpdateCache
			end if
		Else
			Set XMLSQL=Application(CacheName)
		End if
	End Sub
	
	Private Sub LoadKlatchList()
		dim OverTime
		If Not CacheIsObject Then
			Call LoadSqlStr(""&SqlKeyName&"Klatch","*")
			If Not (XMLSQL Is Nothing) and ErrCode=0 Then
				For Each Node in XMLSQL.documentElement.SelectNodes("data")
					OverTime=0
					Node.selectSingleNode("@content").text=Nslove.CutStr(Node.selectSingleNode("@content").text,IStrLen)
					Node.selectSingleNode("@title").text=Nslove.CutStr(Node.selectSingleNode("@title").text,ILength)
					Node.selectSingleNode("@startime").text=Nslove.FormatDate(Node.selectSingleNode("@startime").text,IDate)
					OverTime=DateDiff("d",Now(),Node.selectSingleNode("@startime").text)
					if OverTime<0 then OverTime=0
					Node.setAttribute "overtime",OverTime
					SetLinkNode Node,Node.selectSingleNode("@userid").text,"homepage",2
					SetLinkNode Node,Node.selectSingleNode("@id").text,"link1",11
				Next
				Set Node=nothing
				UpdateCache
			end if
		Else
			Set XMLSQL=Application(CacheName)
		End if
	End Sub
	
	Private Sub LoadDebateList()
		If Not CacheIsObject Then
			Call LoadSqlStr(""&SqlKeyName&"Debate","*")
			If Not (XMLSQL Is Nothing) and ErrCode=0 Then
				For Each Node in XMLSQL.documentElement.SelectNodes("data")
					Node.selectSingleNode("@content").text=Nslove.CutStr(Node.selectSingleNode("@content").text,IStrLen)
					Node.selectSingleNode("@title").text=Nslove.CutStr(Node.selectSingleNode("@title").text,ILength)
					Node.selectSingleNode("@addtime").text=Nslove.FormatDate(Node.selectSingleNode("@addtime").text,IDate)
					SetLinkNode Node,Node.selectSingleNode("@userid").text,"homepage",2
					SetLinkNode Node,Node.selectSingleNode("@id").text,"link1",17
				Next
				Set Node=nothing
				UpdateCache
			end if
		Else
			Set XMLSQL=Application(CacheName)
		End if
	End Sub
	
	Private Sub LoadPkList()
		If Not CacheIsObject Then
			Call LoadSqlStr(""&SqlKeyName&"Pk","*")
			If Not (XMLSQL Is Nothing) and ErrCode=0 Then
				For Each Node in XMLSQL.documentElement.SelectNodes("data")
					Node.selectSingleNode("@content").text=Nslove.CutStr(Node.selectSingleNode("@content").text,IStrLen)
					Node.selectSingleNode("@title").text=Nslove.CutStr(Node.selectSingleNode("@title").text,ILength)
					Node.setAttribute "sortname",Nslove.ClassNode(Node.selectSingleNode("@sortid").text,12)
					Node.selectSingleNode("@addtime").text=Nslove.FormatDate(Node.selectSingleNode("@addtime").text,IDate)
					SetLinkNode Node,Node.selectSingleNode("@userid").text,"homepage",2
					SetLinkNode Node,Node.selectSingleNode("@id").text,"link1",12
				Next
				Set Node=nothing
				UpdateCache
			end if
		Else
			Set XMLSQL=Application(CacheName)
		End if
	End Sub
	
	Private Sub LoadStory()
		dim ParentID
		If Not CacheIsObject Then
			Call LoadSqlStr(""&SqlKeyName&"Story","*")
			If Not (XMLSQL Is Nothing) and ErrCode=0 Then
				For Each Node in XMLSQL.documentElement.SelectNodes("data")
					Node.selectSingleNode("@content").text=Nslove.CutStr(Node.selectSingleNode("@content").text,IStrLen)
					Node.selectSingleNode("@title").text=Nslove.CutStr(Node.selectSingleNode("@title").text,ILength)
					Node.setAttribute "sortname",Nslove.ClassNode(Node.selectSingleNode("@sortid").text,24)
					Node.selectSingleNode("@addtime").text=Nslove.FormatDate(Node.selectSingleNode("@addtime").text,IDate)
					SetLinkNode Node,Node.selectSingleNode("@userid").text,"homepage",2
					SetLinkNode Node,Node.selectSingleNode("@fuserid").text,"homepage1",2
					ParentID=Node.selectSingleNode("@parentid").text
					if ParentID="0" then ParentID=Node.selectSingleNode("@id").text
					SetLinkNode Node,ParentID,"link1",24
				Next
				Set Node=nothing
				UpdateCache
			end if
		Else
			Set XMLSQL=Application(CacheName)
		End if
	End Sub
	
	Private Sub LoadRewardList()
		If Not CacheIsObject Then
			if IRelation=1 then
				if IWhere<>"" then
					IWhere=IWhere&" and P.UserID=F.UserID"
				Else
					IWhere="P.UserID=F.UserID"
				end if
				Call LoadSqlStr(""&SqlKeyName&"Reward P,"&SqlKeyName&"User F","P.*,F.UserFace,F.UserInfo")
			else
				Call LoadSqlStr(""&SqlKeyName&"Reward","*")
			end if
			If Not (XMLSQL Is Nothing) and ErrCode=0 Then
				For Each Node in XMLSQL.documentElement.SelectNodes("data")
					if IRelation=1 then
						Node.selectSingleNode("@userface").text=Nslove.ShowFace(Node.selectSingleNode("@userface").text)
						Node.selectSingleNode("@userinfo").text=Split(Node.selectSingleNode("@userinfo").text,"|")(IArray)
					end if
					Node.selectSingleNode("@content").text=Nslove.CutStr(Node.selectSingleNode("@content").text,IStrLen)
					Node.selectSingleNode("@title").text=Nslove.CutStr(Node.selectSingleNode("@title").text,ILength)
					Node.selectSingleNode("@addtime").text=Nslove.FormatDate(Node.selectSingleNode("@addtime").text,IDate)
					SetLinkNode Node,Node.selectSingleNode("@userid").text,"homepage",2
					SetLinkNode Node,Node.selectSingleNode("@id").text,"link1",16
				Next
				Set Node=nothing
				UpdateCache
			end if
		Else
			Set XMLSQL=Application(CacheName)
		End if
	End Sub	
	
	Private Sub LoadAskList()
		If Not CacheIsObject Then
			Call LoadSqlStr(""&SqlKeyName&"Ask","*")
			If Not (XMLSQL Is Nothing) and ErrCode=0 Then
				For Each Node in XMLSQL.documentElement.SelectNodes("data")
					Node.selectSingleNode("@content").text=Nslove.CutStr(Node.selectSingleNode("@content").text,IStrLen)
					Node.selectSingleNode("@title").text=Nslove.CutStr(Node.selectSingleNode("@title").text,ILength)
					Node.setAttribute "sortname",Nslove.ClassNode(Node.selectSingleNode("@sortid").text,14)
					Node.selectSingleNode("@addtime").text=Nslove.FormatDate(Node.selectSingleNode("@addtime").text,IDate)
					SetLinkNode Node,Node.selectSingleNode("@userid").text,"homepage",2
					SetLinkNode Node,Node.selectSingleNode("@id").text,"link1",14
				Next
				Set Node=nothing
				UpdateCache
			end if
		Else
			Set XMLSQL=Application(CacheName)
		End if
	End Sub
	
	Private Sub LoadTryList()
		dim OverTime
		If Not CacheIsObject Then
			Call LoadSqlStr(""&SqlKeyName&"Try","*")
			If Not (XMLSQL Is Nothing) and ErrCode=0 Then
				For Each Node in XMLSQL.documentElement.SelectNodes("data")
					Node.selectSingleNode("@content").text=Nslove.CutStr(Node.selectSingleNode("@content").text,IStrLen)
					Node.selectSingleNode("@title").text=Nslove.CutStr(Node.selectSingleNode("@title").text,ILength)
					Node.selectSingleNode("@addtime").text=Nslove.FormatDate(Node.selectSingleNode("@addtime").text,IDate)
					Node.setAttribute "sortname",Nslove.ClassNode(Node.selectSingleNode("@sortid").text,13)
					Node.selectSingleNode("@overtime").text=Nslove.FormatDate(Node.selectSingleNode("@overtime").text,IDate)
					OverTime=DateDiff("d",Now(),Node.selectSingleNode("@overtime").text)
					if OverTime<0 then OverTime=0
					Node.setAttribute "endtime",OverTime
					SetLinkNode Node,Node.selectSingleNode("@userid").text,"homepage",2
					SetLinkNode Node,Node.selectSingleNode("@id").text,"link1",13
				Next
				Set Node=nothing
				UpdateCache
			end if
		Else
			Set XMLSQL=Application(CacheName)
		End if
	End Sub
	
	Private Sub LoadPartyList()
		dim OverTime
		If Not CacheIsObject Then
			if IRelation=1 then
				if IWhere<>"" then
					IWhere=IWhere&" and P.UserID=F.UserID"
				Else
					IWhere="P.UserID=F.UserID"
				end if
				Call LoadSqlStr(""&SqlKeyName&"Party P,"&SqlKeyName&"User F","P.*,F.UserFace,F.UserInfo")
			else
				Call LoadSqlStr(""&SqlKeyName&"Party","*")
			end if
			If Not (XMLSQL Is Nothing) and ErrCode=0 Then
				For Each Node in XMLSQL.documentElement.SelectNodes("data")
					if IRelation=1 then
						Node.selectSingleNode("@userface").text=Nslove.ShowFace(Node.selectSingleNode("@userface").text)
						Node.selectSingleNode("@userinfo").text=Split(Node.selectSingleNode("@userinfo").text,"|")(IArray)
					end if
					Node.selectSingleNode("@content").text=Nslove.CutStr(Node.selectSingleNode("@content").text,IStrLen)
					Node.selectSingleNode("@title").text=Nslove.CutStr(Node.selectSingleNode("@title").text,ILength)
					Node.selectSingleNode("@startime").text=Nslove.FormatDate(Node.selectSingleNode("@startime").text,IDate)
					Node.selectSingleNode("@expense").text=Nslove.GetSelect("expense",Node.selectSingleNode("@expense").text)
					OverTime=DateDiff("d",Now(),Node.selectSingleNode("@startime").text)
					if OverTime<0 then OverTime=0
					Node.setAttribute "overtime",OverTime
					Node.setAttribute "sortname",Nslove.ClassNode(Node.selectSingleNode("@sortid").text,10)
					SetLinkNode Node,Node.selectSingleNode("@userid").text,"homepage",2
					SetLinkNode Node,Node.selectSingleNode("@id").text,"link1",10
				Next
				Set Node=nothing
				UpdateCache
			end if
		Else
			Set XMLSQL=Application(CacheName)
		End if
	End Sub
	Private Sub LoadUserHigh()
		If Not CacheIsObject Then
			if IWhere<>"" then
				IWhere=IWhere&" and P.UserID=F.UserID"
			Else
				IWhere="P.UserID=F.UserID"
			end if
			Call LoadSqlStr(""&SqlKeyName&"UserHigh P,"&SqlKeyName&"User F","P.*,F.UserSex,F.UserAge,F.Industry,F.Education,F.Marriage,F.UserStar,F.UserBorn,F.Height")
			If Not (XMLSQL Is Nothing) and ErrCode=0 Then
				For Each Node in XMLSQL.documentElement.SelectNodes("data")
					Node.selectSingleNode("@wirenote").text=Nslove.CutStr(Node.selectSingleNode("@wirenote").text,IStrLen)
					'SetLinkNode Node,Node.selectSingleNode("@userid").text,"homepage",2
					SetLinkNode Node,Node.selectSingleNode("@id").text,"link1",38
				Next
				Set Node=nothing
				UpdateCache
			end if
		Else
			Set XMLSQL=Application(CacheName)
		End if
	End Sub
	
	Private Sub LoadUserList()
		dim IsOnline,IsLuck
		If Not CacheIsObject Then
			Call LoadSqlStr(""&SqlKeyName&"User","*")
			If Not (XMLSQL Is Nothing) and ErrCode=0 Then
				For Each Node in XMLSQL.documentElement.SelectNodes("data")
					IsOnline=0:IsLuck=request("luck")
					Node.selectSingleNode("@userface").text=Nslove.ShowFace(Node.selectSingleNode("@userface").text)
					Node.selectSingleNode("@userinfo").text=Nslove.CutStr(Split(Node.selectSingleNode("@userinfo").text,"|")(IArray),ILength)
					Node.selectSingleNode("@usernote").text=Nslove.CutStr(Node.selectSingleNode("@usernote").text,IStrLen)
					Node.selectSingleNode("@usermarry").text=Nslove.CutStr(Node.selectSingleNode("@usermarry").text,IStrLen)
					Node.selectSingleNode("@lastlogin").text=Nslove.FormatDate(Node.selectSingleNode("@lastlogin").text,IDate)
					SetLinkNode Node,Node.selectSingleNode("@userid").text,"homepage",2
					If Nslove.IsOnline(Node.selectSingleNode("@userid").text,0) then IsOnline=1
					if IsLuck<>"" then
						if Clng(right(Node.selectSingleNode("@userid").text,1))<>Clng(IsLuck) then IsLuck=-1
					end if
					Node.setAttribute "isluck",IsLuck
					Node.setAttribute "online",IsOnline
				Next
				Set Node=nothing
				UpdateCache
			end if
		Else
			Set XMLSQL=Application(CacheName)
		End if
	End Sub
	
	Private Sub LoadUCount()
		dim XUserID
		If Not CacheIsObject Then
			Call LoadSqlStr(""&SqlKeyName&"User","userid,userface,username,userinfo")
			If Not (XMLSQL Is Nothing) and ErrCode=0 Then
				For Each Node in XMLSQL.documentElement.SelectNodes("data")
					XUserID=Node.selectSingleNode("@userid").text
					Node.selectSingleNode("@userface").text=Nslove.ShowFace(Node.selectSingleNode("@userface").text)
					Node.selectSingleNode("@userinfo").text=Nslove.CutStr(Split(Node.selectSingleNode("@userinfo").text,"|")(IArray),ILength)
					SetLinkNode Node,Node.selectSingleNode("@userid").text,"homepage",2
					Node.setAttribute "nmsg",CountNum(SqlKeyName&"Message","userid="&XUserID&" and Flag=0 and IsSend=1")
					Node.setAttribute "amsg",CountNum(SqlKeyName&"Message","userid="&XUserID&"")
					Node.setAttribute "nfriend",CountNum(SqlKeyName&"Friend","userid="&XUserID&" and Checked=0")
					Node.setAttribute "afriend",CountNum(SqlKeyName&"Friend","userid="&XUserID&"")
					Node.setAttribute "npk",CountNum(SqlKeyName&"Pk","userid="&XUserID&" and Checked=0")
					Node.setAttribute "apk",CountNum(SqlKeyName&"Pk","userid="&XUserID&"")
					Node.setAttribute "nparty",CountNum(SqlKeyName&"Party","userid="&XUserID&" and Checked=0")
					Node.setAttribute "aparty",CountNum(SqlKeyName&"Party","userid="&XUserID&"")
					Node.setAttribute "ngift",CountNum(SqlKeyName&"Gift","userid="&XUserID&" and Checked=0")
					Node.setAttribute "agift",CountNum(SqlKeyName&"Gift","userid="&XUserID&"")
				Next
				Set Node=nothing
				UpdateCache
			end if
		Else
			Set XMLSQL=Application(CacheName)
		End if
	End Sub
	
	Private Sub LoadClickList()
		If Not CacheIsObject Then
			if IRelation=1 then
				Call LoadSqlStr(""&SqlKeyName&"UserView P,"&SqlKeyName&"User F","P.*,F.UserID,F.UserName,F.UserFace,F.UserInfo")
			else
				Call LoadSqlStr(""&SqlKeyName&"UserView","*")
			end if
			If Not (XMLSQL Is Nothing) and ErrCode=0 Then
				For Each Node in XMLSQL.documentElement.SelectNodes("data")
					if IRelation=1 then
						Node.selectSingleNode("@userface").text=Nslove.ShowFace(Node.selectSingleNode("@userface").text)
						Node.selectSingleNode("@userinfo").text=Split(Node.selectSingleNode("@userinfo").text,"|")(IArray)
					end if
					Node.selectSingleNode("@addtime").text=Nslove.FormatDate(Node.selectSingleNode("@addtime").text,IDate)
					SetLinkNode Node,Node.selectSingleNode("@userid").text,"homepage",2
				Next
				Set Node=nothing
				UpdateCache
			end if
		Else
			Set XMLSQL=Application(CacheName)
		end if
	End Sub
	
	Private Sub LoadUserJoin()
		If Not CacheIsObject Then
			if IRelation=1 then
				if IWhere<>"" then
					IWhere=IWhere&" and P.UserID=F.UserID"
				Else
					IWhere="P.UserID=F.UserID"
				end if
				Call LoadSqlStr(""&SqlKeyName&"UserJoin P,"&SqlKeyName&"User F","P.*,F.UserFace,F.UserInfo")
			else
				Call LoadSqlStr(""&SqlKeyName&"UserJoin","*")
			end if
			If Not (XMLSQL Is Nothing) and ErrCode=0 Then
				For Each Node in XMLSQL.documentElement.SelectNodes("data")
					if IRelation=1 then
					Node.selectSingleNode("@userface").text=Nslove.ShowFace(Node.selectSingleNode("@userface").text)
					Node.selectSingleNode("@userinfo").text=Split(Node.selectSingleNode("@userinfo").text,"|")(IArray)
					end if
					Node.selectSingleNode("@content").text=Nslove.CutStr(Node.selectSingleNode("@content").text,IStrLen)
					Node.selectSingleNode("@addtime").text=Nslove.FormatDate(Node.selectSingleNode("@addtime").text,IDate)
					SetLinkNode Node,Node.selectSingleNode("@userid").text,"homepage",2
				Next
				Set Node=nothing
				UpdateCache
			end if
		Else
			Set XMLSQL=Application(CacheName)
		end if
		'Response.write XMLSQL.xml
		'response.end
	End Sub
	
	Private Sub LoadGroupList()
		If Not CacheIsObject Then
			Call LoadSqlStr(""&SqlKeyName&"Group","*")
			If Not (XMLSQL Is Nothing) and ErrCode=0 Then
				For Each Node in XMLSQL.documentElement.SelectNodes("data")
					Node.selectSingleNode("@content").text=Nslove.CutStr(Node.selectSingleNode("@content").text,IStrLen)
					Node.setAttribute "sortname",Nslove.ClassNode(Node.selectSingleNode("@sortid").text,15)
					Node.selectSingleNode("@addtime").text=Nslove.FormatDate(Node.selectSingleNode("@addtime").text,IDate)
					SetLinkNode Node,Node.selectSingleNode("@userid").text,"homepage",2
					SetLinkNode Node,Node.selectSingleNode("@id").text,"link1",15
				Next
				Set Node=nothing
				UpdateCache
			end if
		Else
			Set XMLSQL=Application(CacheName)
		end if
		'Response.write XMLSQL.xml
		'response.end
	End Sub
	
	Private Sub LoadBoardList()''版块列表
		If Not CacheIsObject Then
			Call LoadSqlStr(""&SqlKeyName&"Group_Board","*")
			If Not (XMLSQL Is Nothing) and ErrCode=0 Then
				For Each Node in XMLSQL.documentElement.SelectNodes("data")
					SetLinkNode Node,Node.selectSingleNode("@masterid").text,"homepage",2
				Next
				UpdateCache
			end if
		Else
			Set XMLSQL=Application(CacheName)
		end if
	End Sub
	
	Private Sub LoadGradeList()''等级列表
		If Not CacheIsObject Then
			Call LoadSqlStr(""&SqlKeyName&"Group_Grade","*")
			If Not (XMLSQL Is Nothing) and ErrCode=0 Then
				UpdateCache
			end if
		Else
			Set XMLSQL=Application(CacheName)
		end if
	End Sub
	
	Private Sub LoadGrpTopic()''群组话题
		dim IPage,DataNum:DataNum=0
		IPage=Nslove.ChkNumeric(Request("page"))
		if IPage=1 or IPage=0 then IPage=0
		If Not CacheIsObject Then
			if IRelation=1 then
				if IWhere<>"" then
					IWhere=IWhere&" and P.UserID=F.UserID"
				Else
					IWhere="P.UserID=F.UserID"
				end if
				Call LoadSqlStr(""&SqlKeyName&"Group_Forum P,"&SqlKeyName&"User F","P.*,F.UserFace,F.UserInfo")
			else
				Call LoadSqlStr(""&SqlKeyName&"Group_Forum","*")
			end if
			If Not (XMLSQL Is Nothing) and ErrCode=0 Then
				For Each Node in XMLSQL.documentElement.SelectNodes("data")
					if IRelation=1 then
						Node.selectSingleNode("@userface").text=Nslove.ShowFace(Node.selectSingleNode("@userface").text)
						Node.selectSingleNode("@userinfo").text=Split(Node.selectSingleNode("@userinfo").text,"|")(IArray)
					end if
					Node.selectSingleNode("@content").text=Nslove.CutStr(Node.selectSingleNode("@content").text,IStrLen)
					Node.selectSingleNode("@title").text=Nslove.CutStr(Node.selectSingleNode("@title").text,ILength)
					Node.selectSingleNode("@addtime").text=Nslove.FormatDate(Node.selectSingleNode("@addtime").text,IDate)
					Node.selectSingleNode("@lasttime").text=Nslove.FormatDate(Node.selectSingleNode("@lasttime").text,IDate)
					Node.setAttribute "datanum",DataNum
					SetLinkNode Node,Node.selectSingleNode("@userid").text,"homepage",2
					SetLinkNode Node,Node.selectSingleNode("@lastuserid").text,"homepage1",2
					DataNum=(DataNum+1)+(IPage*IMaxNum)
				Next
				Set Node=nothing
				UpdateCache
			end if
		Else
			Set XMLSQL=Application(CacheName)
		end if
	End Sub
	
	Private Sub LoadCertify()''验证
		If Not CacheIsObject Then
			Call LoadSqlStr(""&SqlKeyName&"Certify","*")
			If Not (XMLSQL Is Nothing) and ErrCode=0 Then
				UpdateCache
			end if
		Else
			Set XMLSQL=Application(CacheName)
		end if
	End Sub
	
	Private Sub LoadWedding()''婚庆服务
		If Not CacheIsObject Then
			Call LoadSqlStr(""&SqlKeyName&"Wedding","*")
			If Not (XMLSQL Is Nothing) and ErrCode=0 Then
				For Each Node in XMLSQL.documentElement.SelectNodes("data")
					Node.selectSingleNode("@title").text=Nslove.CutStr(Node.selectSingleNode("@title").text,ILength)
					Node.selectSingleNode("@content").text=Nslove.CutStr(Node.selectSingleNode("@content").text,IStrLen)
					Node.selectSingleNode("@addtime").text=Nslove.FormatDate(Node.selectSingleNode("@addtime").text,IDate)
					Node.setAttribute "sortname",Nslove.ClassNode(Node.selectSingleNode("@sortid").text,31)
					SetLinkNode Node,Node.selectSingleNode("@parentid").text,"link1",31
				Next
				Set Node=nothing
				UpdateCache
			end if
		Else
			Set XMLSQL=Application(CacheName)
		end if
	End Sub
	
	Private Sub LoadStation()''分站列表
		If Not CacheIsObject Then
			Call LoadSqlStr(""&SqlKeyName&"Station","*")
			If Not (XMLSQL Is Nothing) and ErrCode=0 Then
				For Each Node in XMLSQL.documentElement.SelectNodes("data")
					Node.selectSingleNode("@title").text=Nslove.CutStr(Node.selectSingleNode("@title").text,ILength)
					Node.selectSingleNode("@addtime").text=Nslove.FormatDate(Node.selectSingleNode("@addtime").text,IDate)
					SetLinkNode Node,Node.selectSingleNode("@id").text,"link1",21
				Next
				Set Node=nothing
				UpdateCache
			end if
		Else
			Set XMLSQL=Application(CacheName)
		end if
	End Sub
	
	Private Sub LoadArticle()''文章
		If Not CacheIsObject Then
			Call LoadSqlStr(""&SqlKeyName&"Article","*")
			If Not (XMLSQL Is Nothing) and ErrCode=0 Then
				For Each Node in XMLSQL.documentElement.SelectNodes("data")
					Node.selectSingleNode("@content").text=Nslove.CutStr(Node.selectSingleNode("@content").text,IStrLen)
					Node.selectSingleNode("@excerpta").text=Nslove.CutStr(Node.selectSingleNode("@excerpta").text,IStrLen)
					Node.selectSingleNode("@title").text=Nslove.CutStr(Node.selectSingleNode("@title").text,ILength)
					Node.selectSingleNode("@addtime").text=Nslove.FormatDate(Node.selectSingleNode("@addtime").text,IDate)
					Node.setAttribute "sortname",Nslove.ClassNode(Node.selectSingleNode("@sortid").text,19)
					SetLinkNode Node,Node.selectSingleNode("@id").text,"link1",19
				Next
				Set Node=nothing
				UpdateCache
			end if
		Else
			Set XMLSQL=Application(CacheName)
		end if
	End Sub
	
	Private Sub LoadHelp()''帮助
		If Not CacheIsObject Then
			Call LoadSqlStr(""&SqlKeyName&"Article","*")
			If Not (XMLSQL Is Nothing) and ErrCode=0 Then
				For Each Node in XMLSQL.documentElement.SelectNodes("data")
					Node.selectSingleNode("@content").text=Nslove.CutStr(Node.selectSingleNode("@content").text,IStrLen)
					Node.selectSingleNode("@title").text=Nslove.CutStr(Node.selectSingleNode("@title").text,ILength)
					Node.selectSingleNode("@addtime").text=Nslove.FormatDate(Node.selectSingleNode("@addtime").text,IDate)
					Node.setAttribute "sortname",Nslove.ClassNode(Node.selectSingleNode("@sortid").text,20)
					SetLinkNode Node,Node.selectSingleNode("@id").text,"link1",20
				Next
				Set Node=nothing
				UpdateCache
			end if
		Else
			Set XMLSQL=Application(CacheName)
		end if
	End Sub
	
	Private Sub LoadGiftSort()''礼物
		If Not CacheIsObject Then
			Call LoadSqlStr(""&SqlKeyName&"GiftSort","*")
			If Not (XMLSQL Is Nothing) and ErrCode=0 Then
				UpdateCache
			end if
		Else
			Set XMLSQL=Application(CacheName)
		end if
	End Sub
	
	Private Sub LoadGiftBox()''礼物箱
		dim ToUserID
		ToUserID=Nslove.ChkNumeric(Request("userid"))
		If Not CacheIsObject Then
			if IRelation=1 then
				if IWhere<>"" then
					IWhere=IWhere&" and P.SortID=F.ID"
				Else
					IWhere="P.SortID=F.ID"
				end if
				Call LoadSqlStr(""&SqlKeyName&"GiftMy P,"&SqlKeyName&"GiftSort F","F.*,P.MaxNum")
			else
				Call LoadSqlStr(""&SqlKeyName&"GiftMy","*")
			end if
			XmlAttribute "/xml","touid",ToUserID
			If Not (XMLSQL Is Nothing) and ErrCode=0 Then
				UpdateCache
			end if
		Else
			Set XMLSQL=Application(CacheName)
		End if
	End Sub
	
	Private Sub LoadGiftList()''礼物
		If Not CacheIsObject Then
			if IRelation=1 then
				if IWhere<>"" then
					IWhere=IWhere&" and P.SortID=F.ID"
				Else
					IWhere="P.SortID=F.ID"
				end if
				Call LoadSqlStr(""&SqlKeyName&"Gift P,"&SqlKeyName&"GiftSort F","P.*,F.SortName,F.GiftNote,F.FilesName,F.FilesView")
			else
				Call LoadSqlStr(""&SqlKeyName&"Gift","*")
			end if
			If Not (XMLSQL Is Nothing) and ErrCode=0 Then
				For Each Node in XMLSQL.documentElement.SelectNodes("data")
					Node.selectSingleNode("@content").text=Nslove.CutStr(Node.selectSingleNode("@content").text,IStrLen)
					Node.selectSingleNode("@remark").text=Nslove.CutStr(Node.selectSingleNode("@remark").text,IStrLen)
					Node.selectSingleNode("@addtime").text=Nslove.FormatDate(Node.selectSingleNode("@addtime").text,IDate)
					SetLinkNode Node,Node.selectSingleNode("@fuserid").text,"homepage1",2
					SetLinkNode Node,Node.selectSingleNode("@userid").text,"homepage2",2
				Next
				Set Node=nothing
				UpdateCache
			end if
		Else
			Set XMLSQL=Application(CacheName)
		End if
	End Sub
	
	Private Sub LoadMyService()''我的服务
		If Not CacheIsObject Then
			Call LoadSqlStr(""&SqlKeyName&"UserService","*")
			If Not (XMLSQL Is Nothing) and ErrCode=0 Then
				For Each Node in XMLSQL.documentElement.SelectNodes("data")
					Node.selectSingleNode("@title").text=Nslove.CutStr(Node.selectSingleNode("@title").text,ILength)
					Node.selectSingleNode("@addtime").text=Nslove.FormatDate(Node.selectSingleNode("@addtime").text,IDate)
					Node.selectSingleNode("@overtime").text=DateDiff("d",Now(),Node.selectSingleNode("@overtime").text)
					SetLinkNode Node,Node.selectSingleNode("@userid").text,"homepage",2
				Next
				Set Node=nothing
				UpdateCache
			end if
		Else
			Set XMLSQL=Application(CacheName)
		End if
	End Sub
	
	Private Sub LoadService()''佳缘服务
		If Not CacheIsObject Then
			Call LoadSqlStr(""&SqlKeyName&"Service","*")
			If Not (XMLSQL Is Nothing) and ErrCode=0 Then
				UpdateCache
			end if
		Else
			Set XMLSQL=Application(CacheName)
		End if
	End Sub
	
	Private Sub LoadAgent()''商家
		dim UserInfo,AI
		If Not CacheIsObject Then
			Call LoadSqlStr(""&SqlKeyName&"Agent","*")
			If Not (XMLSQL Is Nothing) and ErrCode=0 Then
				For Each Node in XMLSQL.documentElement.SelectNodes("data")
					Node.selectSingleNode("@title").text=Nslove.CutStr(Node.selectSingleNode("@title").text,ILength)
					Node.selectSingleNode("@usernote").text=Nslove.CutStr(Node.selectSingleNode("@usernote").text,IStrLen)
					Node.selectSingleNode("@addtime").text=Nslove.FormatDate(Node.selectSingleNode("@addtime").text,IDate)
					UserInfo=Split(Node.selectSingleNode("@userinfo").text,"|")
					For AI=0 to Ubound(UserInfo)
						Node.setAttribute "userinfo"&AI,UserInfo(AI)
					Next
					Node.setAttribute "sortname",Nslove.ClassNode(Node.selectSingleNode("@sortid").text,31)
					'SetLinkNode Node,Node.selectSingleNode("@userid").text,"homepage",2
					SetLinkNode Node,Node.selectSingleNode("@id").text,"link1",31
				Next
				Set Node=nothing
				UpdateCache
			end if
		Else
			Set XMLSQL=Application(CacheName)
		End if
	End Sub
	
	
	Private Sub LoadComplain()''举报中心
		If Not CacheIsObject Then
			Call LoadSqlStr(""&SqlKeyName&"Complain","*")
			If Not (XMLSQL Is Nothing) and ErrCode=0 Then
				For Each Node in XMLSQL.documentElement.SelectNodes("data")
					Node.selectSingleNode("@title").text=Nslove.CutStr(Node.selectSingleNode("@title").text,ILength)
					Node.selectSingleNode("@addtime").text=Nslove.FormatDate(Node.selectSingleNode("@addtime").text,IDate)
					Node.setAttribute "sortname",Nslove.ClassNode(Node.selectSingleNode("@sortid").text,34)
					SetLinkNode Node,Node.selectSingleNode("@userid").text,"homepage",2
				Next
				Set Node=nothing
				UpdateCache
			end if
		Else
			Set XMLSQL=Application(CacheName)
		End if
	End Sub
	
	Private Sub LoadTagList()''标签列表
		dim Tagn,TagNum:TagNum=1
		If Not CacheIsObject Then
			Call LoadSqlStr(""&SqlKeyName&"Tags","*")
			If Not (XMLSQL Is Nothing) and ErrCode=0 Then
				For Each Node in XMLSQL.documentElement.SelectNodes("data")
					Tagn=TagNum
					if TagNum>35 then Tagn=TagNum mod 35
					Node.setAttribute "classify",Tagn
					TagNum=TagNum+1
				Next
				Set Node=nothing
				UpdateCache
			end if
		Else
			Set XMLSQL=Application(CacheName)
		End if
	End Sub
	
	Private Sub LoadMatch()''匹配
		If Not CacheIsObject Then
			Call LoadSqlStr(""&SqlKeyName&"UserMatch","*")
			If Not (XMLSQL Is Nothing) and ErrCode=0 Then
				Set Node=nothing
				UpdateCache
			end if
		Else
			Set XMLSQL=Application(CacheName)
		End if
	End Sub
	
	Private Sub LoadFriend()''我的好友
		dim IsOnline
		If Not CacheIsObject Then
			if IRelation=1 then
					if IWhere<>"" then
						IWhere=IWhere&" and P.FriendID=F.UserID"
					Else
						IWhere="P.FriendID=F.UserID"
					end if
					Call LoadSqlStr(""&SqlKeyName&"Friend P,"&SqlKeyName&"User F","P.*,F.UserFace,F.UserInfo,F.UserNote")
			else
					Call LoadSqlStr(""&SqlKeyName&"Friend","*")
			end if
			If Not (XMLSQL Is Nothing) and ErrCode=0 Then
				For Each Node in XMLSQL.documentElement.SelectNodes("data")
					IsOnline=0
					if IRelation=1 then
						Node.selectSingleNode("@userface").text=Nslove.ShowFace(Node.selectSingleNode("@userface").text)
						Node.selectSingleNode("@userinfo").text=Split(Node.selectSingleNode("@userinfo").text,"|")(IArray)
						Node.selectSingleNode("@usernote").text=Nslove.CutStr(Node.selectSingleNode("@usernote").text,IStrLen)
					end if
					SetLinkNode Node,Node.selectSingleNode("@friendid").text,"homepage",2
					if Nslove.IsOnline(Node.selectSingleNode("@friendid").text,0) then IsOnline=1
					Node.setAttribute "online",IsOnline
				Next
				Set Node=nothing
				UpdateCache
			end if
		Else
			Set XMLSQL=Application(CacheName)
		end if
	End Sub
	
	''处理通用链接节点
	Private Sub SetLinkNode(NodeObj,DataID,AtttiName,ChannelID)
		dim ViewInfo,TempUrl,ChannelUrl
		if DataID<>"" and Len(DataID)>0 then
			ChannelUrl=Nslove.ChannelData(ChannelID,"channelurl")
			ViewInfo=Nslove.ChannelData(ChannelID,"fileinfo")
			if Nslove.ChannelData(ChannelID,"ishtml")="1" then''是否静态文件加入静态目录
				ChannelUrl=ChannelUrl&Nslove.Ns_Setting(48)
			End if
			ViewInfo=ChannelUrl&ViewInfo
			if Len(ViewInfo)>0 then TempUrl=Nslove.ExReplace(ViewInfo,"Tag.DataID",DataID)
			NodeObj.attributes.setNamedItem(XMLSQL.createNode(2,AtttiName,"")).text=TempUrl
		End if
		NodeObj.attributes.setNamedItem(XMLSQL.createNode(2,"target","")).text=ITarget
	End Sub
	
	''URL字符串连
	Private Function ChkURLRewrite(StrPath,StrFile)
		ChkURLRewrite=StrPath&StrFile
	End Function

	Private Function FormatHref()
		dim TempHref
		'Nslove.ChannelID=IChannelID
		'if Nslove.IsHtml=1 then''不是静态
		'	TempHref=Nslove.ChannelUrl&Nslove.ViewInfo
		'Else
			TempHref=JoinChar(IStrUrl)
		'end if
		FormatHref=TempHref
	End Function
	
	Private Sub LoadShowPage()
		dim PageList,FirstPage,LastPage,PrevPage,NextPage
		if IPageCount="" then IPageCount=0
		Set XMLSQL=XMLDoc
		XmlAttribute "//data","pagecount",IPageCount
		XmlAttribute "//data","total",ITotal
		XmlAttribute "//data","maxpage",IMaxNum
		XmlAttribute "//data","page",IPage
		XmlAttribute "//data","url",IStrUrl
		if ITotal=0 then
			XmlAttribute "//data","action","nodata"''动作方式
			Exit Sub
		end if
		if IPage<IPageCount-1 then
			FirstPage=IPage-2
			LastPage=IPage+2
		Else
			FirstPage=IPageCount-4
			if FirstPage<=0 then FirstPage=1
			LastPage=IPageCount
		end if
		if IPage-2<=0 then
			FirstPage=1
			LastPage=5
		end if
		if IPage-5>=1 then
			PrevPage=IPage-5
		Else
			PrevPage=1
		end if
		if IPage+5<=IPageCount then
			NextPage=IPage+5
		Else
			NextPage=IPageCount
		end if
		'Response.write p
		'response.end
		XmlAttribute "//data","prevpage",PrevPage
		XmlAttribute "//data","nextpage",NextPage
		'FirstPage=P*5+1:LastPage=P*5+5
		For I=FirstPage to LastPage
			Set Node=XMLSQL.createNode(1,"pagelist","")
			Node.attributes.setNamedItem(XMLSQL.createNode(2,"p","")).text=i
			Node.attributes.setNamedItem(XMLSQL.createNode(2,"s","")).text=1
			XMLSQL.documentElement.appendChild(Node)
			Set Node=Nothing
			If I=IPageCount then exit for
		Next
	End Sub

	Private Function CheckFileName(ByVal strFile)
		If Not IsNull(strFile) And strFile<>"" Then
			strFile = Replace(strFile, Chr(0), "")
			strFile = Replace(strFile, vbCrLf, "")
			CheckFileName = strFile
		Else
			CheckFileName = ""
		End If
	End Function
	

	Private Function JoinChar(StrUrl)
		if StrUrl="" then
			JoinChar=""
			exit function
		end if
		if InStr(StrUrl,"?")<len(StrUrl) then 
			if InStr(StrUrl,"?")>=1 then
				if InStr(StrUrl,"&")<len(StrUrl) then 
					JoinChar=StrUrl & "&"
				else
					JoinChar=StrUrl
				end if
			else
				JoinChar=StrUrl & "?"
			end if
		else
			JoinChar=StrUrl
		end if
	End Function
	
	Private Function XmlAttribute(XPath,NodeName,AttValue)
		XMLSQL.selectSingleNode(XPath).setAttribute NodeName,AttValue
	End Function
End Class
%>