﻿<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output omit-xml-declaration="yes"  indent="yes" version="6.0"/>
<!--
	Copyright (C) 2004,2009 Nslove.Net. All rights reserved.
	Written by Nslove.Net Nslove
	Web: http://www.Nslove.Com/
	Email: Info@Nslove.Com
	-->
<xsl:template match="/">
	<xsl:choose>
		<xsl:when test="xml/@action='1'"><xsl:call-template name="match_1"/></xsl:when>
		<xsl:when test="xml/@action='2'"><xsl:call-template name="match_2"/></xsl:when>
		<xsl:when test="xml/@action='3'"><xsl:call-template name="match_3"/></xsl:when>
		<xsl:when test="xml/@action='4'"><xsl:call-template name="match_4"/></xsl:when>
		<xsl:when test="xml/@action='5'"><xsl:call-template name="match_5"/></xsl:when>
		<xsl:when test="xml/@action='6'"><xsl:call-template name="match_6"/></xsl:when>
		<xsl:when test="xml/@action='7'"><xsl:call-template name="match_7"/></xsl:when>
		<xsl:when test="xml/@action='8'"><xsl:call-template name="match_8"/></xsl:when>
		<xsl:when test="xml/@action='9'"><xsl:call-template name="match_9"/></xsl:when>
		<xsl:otherwise><xsl:call-template name="other"/></xsl:otherwise>
	</xsl:choose>
</xsl:template>
<xsl:template name="match_1">
<xsl:for-each select="//data">
<ul>
<li id="fontls"><span>分站名称：</span><xsl:value-of select="@title"/></li>
<li><span>创建时间：</span><xsl:value-of select="@addtime"/></li>
<li><span>有效时间：</span><font id="fontgn"><xsl:value-of select="@overtime"/> (从现在到此时间您是它的负责人)</font></li>
<li><span>分站状态：</span><xsl:choose><xsl:when test="@checked='0'">审核中</xsl:when><xsl:otherwise><font id="fontgn">已审核</font></xsl:otherwise></xsl:choose> ｜ <a href="?action=apply&amp;id={@id}"><font id="fontbl">修改</font></a> ｜ <a href="?action=upload&amp;id={@id}"><font id="fontbl">Logo设置</font></a> ｜ <a href="user.asp?action=user&amp;id={@id}"><font id="fontor">添加会员</font></a> ｜ <a href="?action=user&amp;id={@id}"><font id="fontbl">分站会员</font></a> ｜ <a onclick="creatstation('{@id}','5');"><font id="fontbl">重新生成</font></a></li>
</ul>
</xsl:for-each>
</xsl:template>
<xsl:template name="match_2">
<xsl:for-each select="//data">
<ul><li id="name"><a href="{@homepage}"><xsl:value-of select="@username"/></a></li><li id="info"><a href="{@homepage}"><xsl:value-of select="@userinfo"/></a></li><li id="login"><xsl:choose><xsl:when test="@usertop='0'">否</xsl:when><xsl:otherwise><font id="fontrd">是</font></xsl:otherwise></xsl:choose></li><li id="lognum"><xsl:value-of select="@userlogins"/></li><li id="tool"><a href="user.asp?action=upload&amp;userid={@userid}"><font id="fontgn">相册</font></a>｜<a href="user.asp?action=certify&amp;userid={@userid}"><font id="fontbl">认证</font></a>｜<a onclick="ctrlfile('0','{@userid}','','设置明星榜');"><font id="fontzs">明星</font></a>｜<a onclick="creatuser('{@userid}','1');"><font id="fontrd">生成</font></a></li></ul>
</xsl:for-each>
</xsl:template>
<xsl:template name="match_3">
<xsl:for-each select="//data">
<ul><li id="img"><img src="{@userface}"/></li><li><b>会员昵称：</b><a href="{@homepage}"><xsl:value-of select="@username"/></a></li><li><b>上传相册：</b><b id="fontls"><xsl:value-of select="@useravatar"/></b> 张</li><li><b>帐户余额：</b><b id="fontls"><xsl:value-of select="@userwealth"/></b> 金币</li><li><b>基本资料：</b><a href="{@homepage}"><xsl:value-of select="@userinfo"/></a></li><li id="note"><b>内心独白：</b><xsl:value-of select="@usernote"/></li>
</ul>
</xsl:for-each>
</xsl:template>
<xsl:template name="match_4">
<xsl:for-each select="//data">
<div class="userbox"><ul><li id="img"><img src="{@userface}"/></li><li id="name"><span><a href="{@homepage}"><xsl:value-of select="@username"/></a></span>上次登录：<xsl:value-of select="@lastlogin"/></li><li id="info"><xsl:value-of select="@userinfo"/></li><li id="note"><xsl:value-of select="@usernote"/></li></ul></div>
</xsl:for-each>
</xsl:template>
<xsl:template name="match_5">
<xsl:for-each select="//data">
<ul><li id="sort">合作类别：<xsl:value-of select="@sortname"/></li><li>联系人：<xsl:value-of select="@linkname"/>　联系电话：<xsl:value-of select="@telphone"/></li><li>所在地区：<xsl:value-of select="@address"/></li><li id="note">留言：<xsl:value-of select="@content"/></li><li id="tool"><a href="?action=seradd&amp;id={@id}">修改</a> | <a onclick="ctrlfile('6','{@id}','','删除合作');">删除</a></li></ul>
</xsl:for-each>
</xsl:template>
<xsl:template name="match_6">
<xsl:for-each select="//data">
<h1><span><xsl:value-of select="@title"/></span>总访问人数：<xsl:value-of select="@views"/>　预约指数：<xsl:value-of select="@signup"/>　入驻时间：<xsl:value-of select="@addtime"/></h1>
<ul><li id="img"><xsl:choose><xsl:when test="@filesview=''"><img src="/images/nophoto.gif"/></xsl:when><xsl:otherwise><img src="{@filesview}"/></xsl:otherwise></xsl:choose></li>
<li id="">行业类别：<xsl:value-of select="@sortname"/>　<a href="profile.asp"><font id="fontbl">[修改]</font></a></li>
<li id="">帐户金额：<xsl:value-of select="@usermoney"/> 元</li>
<li id="">商家地址：<xsl:value-of select="@address"/></li>
<li id="">　联系人：<xsl:value-of select="@contact"/></li>
<li id="">上次登录：<xsl:value-of select="@lastlogin"/>　<font id="fontls">IP：<xsl:value-of select="@lastloginip"/></font></li>
</ul>
</xsl:for-each>
</xsl:template>
<xsl:template name="match_7">
<xsl:for-each select="//data">
<ul><li id="img"><xsl:choose><xsl:when test="@filesview=''"><img src="/images/nophoto.gif"/></xsl:when><xsl:otherwise><img src="{@filesview}"/></xsl:otherwise></xsl:choose></li>
<li id="tit"><a href="{@link1}" target="{@target}"><xsl:value-of select="@title"/></a></li>
<li><em>总访问数：<xsl:value-of select="@views"/></em><em>预约人数：<xsl:value-of select="@signup"/></em><em>入住时间：<xsl:value-of select="@addtime"/></em><em><i>认证方式：</i><img src="/images/business/lm_{@pdtype}.jpg"/></em></li>
<li id="note"><xsl:value-of select="@usernote"/></li>
<li id="tool"><span><a href="{@link1}" target="{@target}">商铺首页</a></span><span><a href="{@link1}#pho">商家展示</a></span><span><a href="{@link1}#ser">服务报价</a></span><span><a href="order.asp?id={@id}">免费预约</a></span></li>
</ul>
</xsl:for-each>
</xsl:template>
<xsl:template name="match_8">
<xsl:for-each select="//data">
<h1><span><xsl:value-of select="@title"/></span>总访问数：<i id="views"><xsl:value-of select="@views"/></i>　预约人数：<xsl:value-of select="@signup"/>　咨询留言：<i id="remark"><xsl:value-of select="@remark"/></i>　入住时间：<xsl:value-of select="@addtime"/></h1>
<ul><li id="img"><xsl:choose><xsl:when test="@filesview=''"><img src="/images/nophoto.gif"/></xsl:when><xsl:otherwise><img src="{@filesview}"/></xsl:otherwise></xsl:choose></li>
<li>商家分类：<xsl:value-of select="@sortname"/>　所在城市：<xsl:value-of select="@zonetxt"/></li>
<li>公司地址：<xsl:value-of select="@address"/></li>
<li>联系电话：<xsl:value-of select="@userinfo0"/> , <xsl:value-of select="@userinfo1"/>　<font id="fontld">来电请说明是婚嫁频道会员</font></li>
<li>传真号码：<xsl:value-of select="@userinfo2"/></li>
<li>QQ/MSN：<xsl:value-of select="@userinfo3"/> , <xsl:value-of select="@userinfo4"/>　<font id="fontld">验证时请说明是婚嫁频道会员</font></li>
<li>联 系 人：<xsl:value-of select="@contact"/></li>
</ul>
</xsl:for-each>
</xsl:template>
<xsl:template name="match_9">
<xsl:for-each select="//data">
<ul><li id="name"><a href="{@homepage}"><xsl:value-of select="@username"/></a></li><li id="info"><a href="{@homepage}"><xsl:value-of select="@userinfo"/></a></li><li id="count">(<a href="?action=msg&amp;userid={@userid}&amp;t=1"><xsl:value-of select="@nmsg"/></a> / <a href="?action=msg&amp;userid={@userid}"><xsl:value-of select="@amsg"/></a>)</li><li id="count">(<a onclick="ctrlfile('6','{@userid}','','审核接受');"><xsl:value-of select="@nfriend"/></a> / <xsl:value-of select="@afriend"/>)</li><li id="count">(<a onclick="ctrlfile('7','{@userid}','','审核拼客');"><xsl:value-of select="@npk"/></a> / <xsl:value-of select="@apk"/>)</li><li id="count">(<a onclick="ctrlfile('8','{@userid}','','审核约会');"><xsl:value-of select="@nparty"/></a> / <xsl:value-of select="@aparty"/>)</li><li id="count">(<a href="?action=gift&amp;userid={@userid}&amp;t=1"><xsl:value-of select="@ngift"/></a> / <a href="?action=gift&amp;userid={@userid}"><xsl:value-of select="@agift"/></a>)</li></ul>
</xsl:for-each>
</xsl:template>
<xsl:template name="other">
</xsl:template>
</xsl:stylesheet>