﻿<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output omit-xml-declaration="yes"  indent="yes" version="6.0"/>
<!--
	Copyright (C) 2004,2009 Nslove.Net. All rights reserved.
	Written by Nslove.Net Nslove
	Web: http://www.Nslove.Com/
	Email: Info@Nslove.Com
	-->
<xsl:template match="/">
	<xsl:choose>
		<xsl:when test="xml/@action='1'"><xsl:call-template name="match_1"/></xsl:when>
		<xsl:when test="xml/@action='2'"><xsl:call-template name="match_2"/></xsl:when>
		<xsl:when test="xml/@action='3'"><xsl:call-template name="match_3"/></xsl:when>
		<xsl:when test="xml/@action='4'"><xsl:call-template name="match_4"/></xsl:when>
		<xsl:when test="xml/@action='5'"><xsl:call-template name="match_5"/></xsl:when>
		<xsl:when test="xml/@action='6'"><xsl:call-template name="match_6"/></xsl:when>
		<xsl:when test="xml/@action='7'"><xsl:call-template name="match_7"/></xsl:when>
		<xsl:when test="xml/@action='8'"><xsl:call-template name="match_8"/></xsl:when>
		<xsl:when test="xml/@action='9'"><xsl:call-template name="match_9"/></xsl:when>
		<xsl:when test="xml/@action='10'"><xsl:call-template name="match_10"/></xsl:when>
		<xsl:when test="xml/@action='11'"><xsl:call-template name="match_11"/></xsl:when>
		<xsl:when test="xml/@action='12'"><xsl:call-template name="match_12"/></xsl:when>
		<xsl:otherwise><xsl:call-template name="other"/></xsl:otherwise>
	</xsl:choose>
</xsl:template>
<xsl:template name="match_1">
<xsl:for-each select="//data">
<li id="dot1"><a href="{@link1}" target="{@target}"><xsl:value-of select="@title"/></a></li>
</xsl:for-each>
</xsl:template>
<xsl:template name="match_2">
<xsl:for-each select="//data">
<li class="ntop3 ntp_{position()}"><a href="{@link1}" target="{@target}"><xsl:value-of select="@title"/></a></li>
</xsl:for-each>
</xsl:template>
<xsl:template name="match_3">
<xsl:for-each select="//data">
<li class="ntop4 ntp_{position()}"><a href="{@link1}" target="{@target}"><xsl:value-of select="@title"/></a></li>
</xsl:for-each>
</xsl:template>
<xsl:template name="match_4">
<xsl:for-each select="//data">
<li class="ntop5 ntp_{position()}"><a href="{@link1}" target="{@target}"><xsl:value-of select="@title"/></a></li>
</xsl:for-each>
</xsl:template>
<xsl:template name="match_5">
<xsl:for-each select="//data">
<li class="ntop6 ntp_{position()}"><a href="{@link1}" target="{@target}"><xsl:value-of select="@title"/></a></li>
</xsl:for-each>
</xsl:template>
<xsl:template name="match_6">
<xsl:for-each select="//data">
<li id="img"><span><a href="{@link1}" target="{@target}"><img src="{@filesview}"/></a><br /><a href="{@link1}" target="{@target}"><xsl:value-of select="@title"/></a></span></li>
</xsl:for-each>
</xsl:template>
<xsl:template name="match_7">
<xsl:for-each select="//data">
<li id="dot1"><a href="{@link1}" target="{@target}">[<xsl:value-of select="@sortname"/>] - <xsl:value-of select="@title"/></a></li>
</xsl:for-each>
</xsl:template>
<xsl:template name="match_8">
<xsl:for-each select="//data">
<li id="txt"><a href="{@link1}" target="{@target}"><xsl:value-of select="@title"/></a></li>
<li id="note"><xsl:value-of select="@content"/></li>
</xsl:for-each>
</xsl:template>
<xsl:template name="match_9">
<xsl:for-each select="//data">
<li id="img"><em><a href="{@link1}" target="{@target}"><img src="{@filesview}"/></a></em><a href="{@link1}" target="{@target}"><xsl:value-of select="@title"/></a><br /><xsl:value-of select="@content"/></li>
</xsl:for-each>
</xsl:template>
<xsl:template name="match_10">
<xsl:for-each select="//data">
<li><span><a href="{@link1}" target="{@target}"><xsl:value-of select="@title"/></a></span><xsl:value-of select="@addtime"/></li>
</xsl:for-each>
</xsl:template>
<xsl:template name="match_11">
<xsl:for-each select="//data">
<li id="pic_{position()-1}"><div><a href="{@link1}" target="{@target}" class="pic_title"><xsl:value-of select="@title"/></a></div><div class="pic_info"><xsl:value-of select="@excerpta"/></div></li>
</xsl:for-each>
</xsl:template>
<xsl:template name="match_12">
<xsl:for-each select="//data">
<dl><dt><a href="{@link1}" target="{@target}"><xsl:value-of select="@title"/></a></dt>
<dd id="note"><xsl:value-of select="@content"/></dd>
<dd><a href="{@link1}" target="{@target}"><xsl:value-of select="@link1"/></a> - <xsl:value-of select="@addtime"/>　评论(<b id="fontrd"><xsl:value-of select="@remark"/></b>)　阅读(<b id="fontrd"><xsl:value-of select="@views"/></b>)</dd>
</dl>
</xsl:for-each>
</xsl:template>
<xsl:template name="other">
</xsl:template>
</xsl:stylesheet>