﻿<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output omit-xml-declaration="yes"/>
<!--
	Copyright (C) 2004,2009 Nslove.Net. All rights reserved.
	Written by Nslove.Net Nslove
	Web: http://www.Nslove.Com/
	Email: Info@Nslove.Com
	-->
<xsl:template match="/">
	<xsl:choose>
		<xsl:when test="xml/@action='1'"><xsl:call-template name="match_1"/></xsl:when>
		<xsl:when test="xml/@action='2'"><xsl:call-template name="match_2"/></xsl:when>
		<xsl:when test="xml/@action='3'"><xsl:call-template name="match_3"/></xsl:when>
		<xsl:when test="xml/@action='4'"><xsl:call-template name="match_4"/></xsl:when>
		<xsl:otherwise><xsl:call-template name="other"/></xsl:otherwise>
	</xsl:choose>
</xsl:template>
<xsl:template name="match_1">
<xsl:for-each select="//data">
<ul>
<xsl:if test="@id">
<li id="img"><img src="{@filesview}" onclick="G('image_{@id}').checked=true;localurl('?action=avatar&amp;userid={@userid}&amp;id={@id}')" /></li>
<li id="txtc"><input type="radio" name="isface" id="image_{@id}" value="{@id}" onclick="localurl('?action=avatar&amp;userid={@userid}&amp;id={@id}')" /> 设为形象照</li>
</xsl:if>
</ul>
</xsl:for-each>
</xsl:template>
<xsl:template name="match_2">
<xsl:for-each select="//data">
<ul>
<xsl:if test="@id"><li id="txtc"><xsl:choose><xsl:when test="@checked='0'"><font id="fontld">照片在审核中</font></xsl:when><xsl:otherwise><xsl:value-of select="@title"/></xsl:otherwise></xsl:choose></li>
<li id="img"><a href="/upload/{@filesname}" target="_blank"><img src="{@filesview}"/></a></li>
<li id="txtc"><xsl:if test="@checked='1'"><label for="image_{@id}"><input type="radio" name="isface" id="image_{@id}" value="{@id}" onclick="ctrlfile('2','{@userid}','{@id}','设置形象')" /> 设为形象照</label></xsl:if>&#160;<a onclick="ctrlfile('0','{@userid}','{@id}','删除照片');">删除</a></li>
</xsl:if>
</ul>
</xsl:for-each>
</xsl:template>
<xsl:template name="match_3">
<xsl:for-each select="//data">
<li id="img"><a href="{@homepage}" target="{@target}"><img src="{@filesview}"/></a></li>
</xsl:for-each>
</xsl:template>
<xsl:template name="match_4">
<xsl:for-each select="//data">
<li id="img"><a onclick="show_img('{@filesname}');"><img id="img_{position()}" src="{@filesview}"/></a></li>
</xsl:for-each>
</xsl:template>
<xsl:template name="other">
</xsl:template>
</xsl:stylesheet>