﻿<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output omit-xml-declaration="yes"  indent="yes" version="6.0"/>
<!--
	Copyright (C) 2004,2009 Nslove.Net. All rights reserved.
	Written by Nslove.Net Nslove
	Web: http://www.Nslove.Com/
	Email: Info@Nslove.Com
	-->
<xsl:template match="/">
	<xsl:choose>
		<xsl:when test="xml/@action='1'"><xsl:call-template name="match_1"/></xsl:when>
		<xsl:when test="xml/@action='2'"><xsl:call-template name="match_2"/></xsl:when>
		<xsl:when test="xml/@action='3'"><xsl:call-template name="match_3"/></xsl:when>
		<xsl:otherwise><xsl:call-template name="other"/></xsl:otherwise>
	</xsl:choose>
</xsl:template>
<xsl:template name="match_1">
<xsl:for-each select="//data">
	<xsl:choose>
	<xsl:when test="position()&lt;=1"><xsl:value-of select="@title"/>（<a onclick="del('{@id}');">删除</a>）</xsl:when>
	<xsl:otherwise>、<xsl:value-of select="@title"/>（<a onclick="del({@id});">删除</a>）</xsl:otherwise>
	</xsl:choose>
</xsl:for-each>
</xsl:template>
<xsl:template name="match_2">
<xsl:for-each select="//data">
<xsl:choose><xsl:when test="position()&lt;=1"><xsl:value-of select="@title"/></xsl:when><xsl:otherwise>、<xsl:value-of select="@title"/></xsl:otherwise></xsl:choose>
</xsl:for-each>
</xsl:template>
<xsl:template name="match_3">
<xsl:for-each select="//data">
<xsl:sort order="ascending" select="@parentid"/>
<xsl:choose><xsl:when test="@parentid='94' or @parentid='95' or @parentid='96' or @parentid='97'"><em><img src="/images/certify/yz_{@parentid}.gif" title="已通过{@title}认证" alt="已通过{@title}认证" /></em></xsl:when><xsl:otherwise><em><xsl:value-of select="@title"/></em></xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:template>
<xsl:template name="other">
暂无证件
</xsl:template>
</xsl:stylesheet>