﻿<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output omit-xml-declaration="yes"  indent="yes" version="6.0"/>
<!--
	Copyright (C) 2004,2009 Nslove.Net. All rights reserved.
	Written by Nslove.Net Nslove
	Web: http://www.Nslove.Com/
	Email: Info@Nslove.Com
	-->
<xsl:template match="/">
	<xsl:choose>
		<xsl:when test="xml/@action='1'"><xsl:call-template name="match_1"/></xsl:when>
		<xsl:when test="xml/@action='2'"><xsl:call-template name="match_2"/></xsl:when>
		<xsl:when test="xml/@action='3'"><xsl:call-template name="match_3"/></xsl:when>
		<xsl:when test="xml/@action='4'"><xsl:call-template name="match_4"/></xsl:when>
		<xsl:otherwise><xsl:call-template name="other"/></xsl:otherwise>
	</xsl:choose>
</xsl:template>
<xsl:template name="match_1">
<xsl:for-each select="//data">
<xsl:sort order="descending" select="@online"/>
<li id="li_{@userid}"><span id="sp_{@userid}" class="sex_{@usersex}_{@online}"><a href="?userid={@userid}"><xsl:value-of select="@username"/></a></span><em onclick="delchat('{@userid}');" title='屏蔽'>&#160;</em></li>
</xsl:for-each>
</xsl:template>
<xsl:template name="match_2">
<xsl:for-each select="//data">
<xsl:if test="@userid=/xml/@fuserid">
<dl><dt id="fontbl"><span><xsl:value-of select="@username"/></span><xsl:value-of select="@addtime"/></dt><dd><xsl:value-of select="@message"/></dd></dl>
</xsl:if>
</xsl:for-each>
</xsl:template>
<xsl:template name="match_3">
<xsl:for-each select="//data">
<xsl:sort order="descending" select="@online"/>
<xsl:choose><xsl:when test="@userid=/xml/@fuserid">
<li id="li_{@userid}" class="sname"><span id="sp_{@userid}" class="sex_{@usersex}_{@online}"><a href="?userid={@userid}"><xsl:value-of select="@username"/></a></span><em onclick="delchat('{@userid}');" title='屏蔽'>&#160;</em></li></xsl:when>
<xsl:otherwise><li id="li_{@userid}"><span id="sp_{@userid}" class="sex_{@usersex}_{@online}"><a href="?userid={@userid}"><xsl:value-of select="@username"/></a></span><em onclick="delchat('{@userid}');" title='屏蔽'>&#160;</em></li></xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:template>
<xsl:template name="match_4"><xsl:for-each select="//data"><h1 id="t3"><font id="fontrd"><xsl:value-of select="@username"/></font>(<xsl:value-of select="@addtime"/>)：</h1><ul><li id="txt1"><xsl:value-of select="@message"/></li><li id="tool"><em><a href="/chat/?userid={@userid}" target="_blank">打开聊天窗口</a></em></li></ul>|</xsl:for-each>
</xsl:template>
<xsl:template name="other">
</xsl:template>
</xsl:stylesheet>