﻿<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output omit-xml-declaration="yes"  indent="yes" version="6.0"/>
<!--
	Copyright (C) 2004,2009 Nslove.Net. All rights reserved.
	Written by Nslove.Net Nslove
	Web: http://www.Nslove.Com/
	Email: Info@Nslove.Com
	-->
<xsl:template match="/">
	<xsl:choose>
		<xsl:when test="xml/@action='1'"><xsl:call-template name="match_1"/></xsl:when>
		<xsl:when test="xml/@action='2'"><xsl:call-template name="match_2"/></xsl:when>
		<xsl:when test="xml/@action='3'"><xsl:call-template name="match_3"/></xsl:when>
		<xsl:when test="xml/@action='4'"><xsl:call-template name="match_4"/></xsl:when>
		<xsl:when test="xml/@action='5'"><xsl:call-template name="match_5"/></xsl:when>
		<xsl:when test="xml/@action='6'"><xsl:call-template name="match_6"/></xsl:when>
		<xsl:when test="xml/@action='7'"><xsl:call-template name="match_7"/></xsl:when>
		<xsl:when test="xml/@action='8'"><xsl:call-template name="match_8"/></xsl:when>
		<xsl:when test="xml/@action='9'"><xsl:call-template name="match_9"/></xsl:when>
		<xsl:when test="xml/@action='10'"><xsl:call-template name="match_10"/></xsl:when>
		<xsl:when test="xml/@action='11'"><xsl:call-template name="match_11"/></xsl:when>
		<xsl:when test="xml/@action='12'"><xsl:call-template name="match_12"/></xsl:when>
		<xsl:otherwise><xsl:call-template name="other"/></xsl:otherwise>
	</xsl:choose>
</xsl:template>
<xsl:template name="match_1">
<xsl:for-each select="//data">
<em><input type="radio" name="sortid" id="sortid" value="{@classid}"/> <xsl:value-of select="@classname"/></em>
</xsl:for-each>
</xsl:template>
<xsl:template name="match_2">
<xsl:for-each select="//data">
<option value="{@classid}"><xsl:value-of select="@classname"/></option>
</xsl:for-each>
</xsl:template>
<xsl:template name="match_3">
<xsl:for-each select="//data">
<xsl:sort select="isorder" />
<xsl:if test="@isorder!='0'">
<xsl:choose><xsl:when test="@isorder>='12'">
<xsl:if test="@isorder='12'"><ul id="tn">&#160;</ul></xsl:if>
<ul class="dounav"><li id="chl_{@isorder}" title="{@channelstas}"><a href="{@channelurl}" alt="{@channelstas}"><xsl:value-of select="@channelname"/></a></li></ul>
</xsl:when><xsl:otherwise><ul><li id="chl_{@isorder}" title="{@channelstas}"><a href="{@channelurl}" alt="{@channelstas}"><xsl:value-of select="@channelname"/></a></li></ul>
</xsl:otherwise></xsl:choose>
</xsl:if>
</xsl:for-each>
</xsl:template>
<xsl:template name="match_4">
<xsl:for-each select="//data">
<dd id="ty_{@classid}"><a href="?action=adorn&amp;sortid={@classid}"><xsl:value-of select="@classname"/></a></dd>
</xsl:for-each>
</xsl:template>
<xsl:template name="match_5">
<xsl:for-each select="//data">
<xsl:if test="//xml/@selectid=@sortid">
<xsl:choose><xsl:when test="@classid='77' or @classid='81'"><label for="la{@classid}"><input name="sortid" type="radio" value="{@classid}" id="la{@classid}" onclick="show('{@classid}');" /><xsl:value-of select="@classname"/></label></xsl:when>
<xsl:otherwise><label for="la{@classid}"><input name="sortid" type="radio" value="{@classid}" id="la{@classid}" onclick="hidden();" /><xsl:value-of select="@classname"/></label></xsl:otherwise></xsl:choose>
</xsl:if>
</xsl:for-each>
</xsl:template>
<xsl:template name="match_6">
<xsl:for-each select="//data">
<xsl:if test="@sortid='1'">
<option value="{@classid}"><xsl:value-of select="@classname"/></option>
</xsl:if>
</xsl:for-each>
</xsl:template>
<xsl:template name="match_7">
<xsl:for-each select="//data">
<li id="dot"><a href="search.asp?sortid={@classid}"><xsl:value-of select="@classname"/></a> (<font id="fontls"><xsl:value-of select="@iscount"/></font>)</li>
</xsl:for-each>
</xsl:template>
<xsl:template name="match_8">
<xsl:for-each select="//data">
<xsl:sort select="isorder" />
<xsl:if test="@isorder>'0' and @isorder &lt;= '8'">
<li title="{@channelstas}"><a href="{@channelurl}" alt="{@channelstas}"><xsl:value-of select="@channelname"/></a></li>
</xsl:if>
</xsl:for-each>
</xsl:template>
<xsl:template name="match_9">
<xsl:for-each select="//data">
<xsl:if test="@sortid='0'">
<li><a href="search.asp?sortid={@classid}"><xsl:value-of select="@classname"/></a></li>
</xsl:if>
</xsl:for-each>
</xsl:template>
<xsl:template name="match_10">
<xsl:for-each select="//data">
<li id="dot"><a href="../search.asp?sortid={@classid}"><xsl:value-of select="@classname"/></a> (<font id="fontls"><xsl:value-of select="@iscount"/></font>)</li>
</xsl:for-each>
</xsl:template>
<xsl:template name="match_11">
<xsl:for-each select="//data">
<xsl:if test="@sortid='0'">
<li><a href="../search.asp?sortid={@classid}"><xsl:value-of select="@classname"/></a></li>
</xsl:if>
</xsl:for-each>
</xsl:template>
<xsl:template name="match_12">var cArray = Array();<xsl:for-each select="//data">cArray[<xsl:value-of select = "@classid" />]='<xsl:value-of select="@classname"/>';</xsl:for-each>
</xsl:template>
<xsl:template name="other">
</xsl:template>
</xsl:stylesheet>