﻿<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output omit-xml-declaration="yes"  indent="yes" version="6.0"/>
<!--
	Copyright (C) 2004,2009 Nslove.Net. All rights reserved.
	Written by Nslove.Net Nslove
	Web: http://www.Nslove.Com/
	Email: Info@Nslove.Com
	-->
<xsl:template match="/">
	<xsl:choose>
		<xsl:when test="xml/@action='1'"><xsl:call-template name="match_1"/></xsl:when>
		<xsl:when test="xml/@action='2'"><xsl:call-template name="match_2"/></xsl:when>
		<xsl:when test="xml/@action='3'"><xsl:call-template name="match_3"/></xsl:when>
		<xsl:when test="xml/@action='4'"><xsl:call-template name="match_4"/></xsl:when>
		<xsl:otherwise><xsl:call-template name="other"/></xsl:otherwise>
	</xsl:choose>
</xsl:template>
<xsl:template name="match_1">
<xsl:for-each select="//data">
<ul>
<li id="tit"><span><input type="checkbox" name="id" value="{@id}"/> <a href="{@link1}" target="{@target}"><xsl:value-of select="@title"/></a></span></li>
<li id="img"><a href="{@link1}" target="{@target}"><xsl:choose><xsl:when test="@filesview=''"><img src="/images/nophoto.gif"/></xsl:when><xsl:otherwise><img src="{@filesview}"/></xsl:otherwise></xsl:choose></a></li>
<li id="date"><b>正方观点：</b><xsl:value-of select="@support"/> 人</li><li id="zone"><b>反方观点：</b><xsl:value-of select="@opposes"/> 人</li><li id="note"><b>话题简介：</b><xsl:value-of select="@content"/></li>
</ul>
</xsl:for-each>
</xsl:template>
<xsl:template name="match_2">
<xsl:for-each select="//data">
<div class="list_div">
<dl>
<dt><a href="{@link1}" target="{@target}"><xsl:value-of select="@title"/></a></dt>
<dd>发起时间：<xsl:value-of select="@addtime"/>　已有<font id="fontrd"><xsl:value-of select="@remark"/></font>个观点　人气：<xsl:value-of select="@views"/></dd>
<dd id="tit">话题描叙：</dd>
<dd id="note"><xsl:value-of select="@content"/></dd>
<dd id="dot1"><span>正方</span><xsl:value-of select="@affirma"/></dd>
<dd id="dot2"><span>反方</span><xsl:value-of select="@negative"/></dd>
</dl><ul><li><span>发起人：<xsl:value-of select="@username"/></span></li><li><span>正方：<xsl:value-of select="@support"/></span></li><li><span>反方：<xsl:value-of select="@opposes"/></span></li><li><span id="txtc"><a href="{@link1}" target="{@target}">立即参与辩论</a></span></li></ul></div>
</xsl:for-each>
</xsl:template>
<xsl:template name="match_3">
<xsl:for-each select="//data"><ul>
<li class="ntop2 ntp_{position()}"><a href="{@link1}" target="{@target}"><xsl:value-of select="@title"/></a></li></ul>
</xsl:for-each>
</xsl:template>
<xsl:template name="match_4">
<xsl:for-each select="//data">
<li id="img"><img src="{@filesview}"/></li>
<li id="tt"><a href="{@link1}" target="{@target}"><xsl:value-of select="@title"/></a></li>
<li id="note"><xsl:value-of select="@content"/><a href="{@link1}" target="{@target}">查看全文</a></li>
</xsl:for-each>
</xsl:template>
<xsl:template name="other">
</xsl:template>
</xsl:stylesheet>