﻿<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output omit-xml-declaration="yes"  indent="yes" version="6.0"/>
<!--
	Copyright (C) 2004,2009 Nslove.Net. All rights reserved.
	Written by Nslove.Net Nslove
	Web: http://www.Nslove.Com/
	Email: Info@Nslove.Com
	-->
<xsl:template match="/">
	<xsl:choose>
		<xsl:when test="xml/@action='1'"><xsl:call-template name="match_1"/></xsl:when>
		<xsl:when test="xml/@action='2'"><xsl:call-template name="match_2"/></xsl:when>
		<xsl:when test="xml/@action='3'"><xsl:call-template name="match_3"/></xsl:when>
		<xsl:when test="xml/@action='4'"><xsl:call-template name="match_4"/></xsl:when>
		<xsl:when test="xml/@action='5'"><xsl:call-template name="match_5"/></xsl:when>
		<xsl:when test="xml/@action='6'"><xsl:call-template name="match_6"/></xsl:when>
		<xsl:when test="xml/@action='7'"><xsl:call-template name="match_7"/></xsl:when>
		<xsl:when test="xml/@action='8'"><xsl:call-template name="match_8"/></xsl:when>
		<xsl:when test="xml/@action='9'"><xsl:call-template name="match_9"/></xsl:when>
		<xsl:when test="xml/@action='10'"><xsl:call-template name="match_10"/></xsl:when>
		<xsl:otherwise><xsl:call-template name="other"/></xsl:otherwise>
	</xsl:choose>
</xsl:template>
<xsl:template name="match_1">
<xsl:for-each select="//data">
<ul>
<li class="frm30"><input type="checkbox" name="id" value="{@id}"/></li>
<li class="frm180"><xsl:choose><xsl:when test="@checked='1'"><a href="{@link1}" target="{@target}"><xsl:value-of select="@title"/></a></xsl:when><xsl:otherwise><xsl:value-of select="@title"/></xsl:otherwise></xsl:choose></li>
<li class="frm55" id="txtc"><a href="?action=blog&amp;sortid={@sortid}" target="{@target}"><xsl:value-of select="@sortname"/></a></li>
<li class="frm70" id="txtc"><xsl:value-of select="@remark"/>/<xsl:value-of select="@views"/></li>
<li class="frm90" id="txtc"><xsl:value-of select="@addtime"/></li>
<li class="frm70"><xsl:choose><xsl:when test="@checked='1'"><a href="?action=add&amp;id={@id}">编辑</a></xsl:when><xsl:otherwise><font id="fontor">文章审核中</font></xsl:otherwise></xsl:choose></li>
</ul>
</xsl:for-each>
</xsl:template>
<xsl:template name="match_2">
<xsl:for-each select="//data">博客标题：<xsl:value-of select="@title"/>&#xa;
博客内容：<xsl:value-of select="@content"/>&#xa;
发表日期：<xsl:value-of select="@addtime"/>&#xa;&#xa;
</xsl:for-each>
</xsl:template>
<xsl:template name="match_3">
<xsl:for-each select="//data">
<ul><li id="tt"><a href="{@link1}" target="{@target}"><xsl:value-of select="@title"/></a></li><li id="name"><a href="{@homepage}" target="{@target}"><xsl:value-of select="@username"/></a></li></ul>
</xsl:for-each>
</xsl:template>
<xsl:template name="match_4">
<xsl:for-each select="//data">
<li id="dot"><span><a href="{@link1}" target="{@target}"><xsl:value-of select="@title"/></a></span><em><a href="{@homepage}" target="{@target}"><xsl:value-of select="@username"/></a></em></li>
</xsl:for-each>
</xsl:template>
<xsl:template name="match_5">
<xsl:for-each select="//data">
<li id="img"><img src="{@filesview}"/><br /><a href="{@link1}" target="{@target}"><xsl:value-of select="@title"/></a></li><li id="note"><a href="{@link1}" target="{@target}"><xsl:value-of select="@content"/></a></li>
</xsl:for-each>
</xsl:template>
<xsl:template name="match_6">
<xsl:for-each select="//data">
<ul id="inbox1">
<li id="img"><span id="img"><img src="{@userface}"/></span><span id="txt"><a href="{@homepage}" target="{@target}"><xsl:value-of select="@username"/></a></span><span id="txt"><a href="{@homepage}" target="{@target}"><xsl:value-of select="@userinfo"/></a></span></li>
<li id="tt"><em><a href="{@link1}" target="{@target}"><xsl:value-of select="@title"/></a></em>浏览：<xsl:value-of select="@views"/> 评论：<xsl:value-of select="@remark"/> 发表时间：<xsl:value-of select="@addtime"/></li>
<li id="note"><a href="{@link1}" target="{@target}"><xsl:value-of select="@content"/></a></li>
<li id="tool"><em class="btngray"><a onclick="friend('{@userid}','1');">加为好友</a></em><em class="btngray"><a href="/users/usermsg.asp?action=send&amp;userid={@userid}" target="_blank">给我写信</a></em><em class="btngray"><a href="{@link1}" target="{@target}">阅读全文</a></em><em class="btngray"><a onclick="sayhello('{@userid}');">问候一声</a></em></li>
</ul>
</xsl:for-each>
</xsl:template>
<xsl:template name="match_7">
<xsl:for-each select="//data">
<li id="dot"><a href="{@link1}" target="{@target}"><xsl:value-of select="@title"/></a></li>
</xsl:for-each>
</xsl:template>
<xsl:template name="match_8">
<xsl:for-each select="//data">
<ul><li class="frm320"><xsl:value-of select="@title"/></li><li class="frm50"><img src="{@myheart}"/></li><li class="frm110"><xsl:value-of select="@addtime"/></li></ul>
</xsl:for-each>
</xsl:template>
<xsl:template name="match_9">
<xsl:for-each select="//data">
<ul><li id="dot"><a href="{@link1}" target="{@target}"><xsl:value-of select="@title"/></a></li><li id="mon"><xsl:value-of select="@addtime"/></li></ul>
</xsl:for-each>
</xsl:template>
<xsl:template name="match_10">
<xsl:for-each select="//data">
<li id="dot"><span><xsl:value-of select="@title"/></span><em><a href="{@homepage}" target="{@target}"><xsl:value-of select="@username"/></a></em></li>
</xsl:for-each>
</xsl:template>
<xsl:template name="other"><div class="nodata">数据库暂无记录。</div></xsl:template>
</xsl:stylesheet>