﻿<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output omit-xml-declaration="yes"  indent="yes" version="6.0"/>
<!--
	Copyright (C) 2004,2009 Nslove.Net. All rights reserved.
	Written by Nslove.Net Nslove
	Web: http://www.Nslove.Com/
	Email: Info@Nslove.Com
	-->
<xsl:template match="/">
	<xsl:choose>
		<xsl:when test="xml/@action='1'"><xsl:call-template name="match_1"/></xsl:when>
		<xsl:when test="xml/@action='2'"><xsl:call-template name="match_2"/></xsl:when>
		<xsl:when test="xml/@action='3'"><xsl:call-template name="match_3"/></xsl:when>
		<xsl:when test="xml/@action='4'"><xsl:call-template name="match_4"/></xsl:when>
		<xsl:when test="xml/@action='5'"><xsl:call-template name="match_5"/></xsl:when>
		<xsl:when test="xml/@action='6'"><xsl:call-template name="match_6"/></xsl:when>
		<xsl:otherwise><xsl:call-template name="other"/></xsl:otherwise>
	</xsl:choose>
</xsl:template>
<xsl:template name="match_1">
<xsl:for-each select="//data">
<ul>
<li id="img"><div class="giftdiv"><xsl:choose><xsl:when test="@filesname!=''"><a onclick="giftShow('{@id}');"><img src="{@filesview}"/></a></xsl:when><xsl:otherwise><a onclick="giftBuy('{@id}');"><img src="{@filesview}"/></a></xsl:otherwise></xsl:choose><span id="viewDesc_{@id}" onmouseover="viewDesc('{@id}');return false;">查看礼物说明</span><em id="giftDesc_{@id}" onmouseout="hideDesc('{@id}')"><i><xsl:value-of select="@giftnote"/></i></em></div></li>
<li><a onclick="giftBuy('{@id}');"><xsl:value-of select="@sortname"/></a></li>
<xsl:choose><xsl:when test="@prices!='0'">
<li id="tt">原价：<xsl:value-of select="@prices"/> 个金币</li>
<li id="tt"><font id="fontld">ADV：<xsl:value-of select="@premium"/> 折　VIP：<xsl:value-of select="@vipprice"/> 折</font></li>
</xsl:when><xsl:otherwise><li id="tt1"><font id="fontrd">免费礼物</font></li>
</xsl:otherwise></xsl:choose>
<li><a onclick="giftBuy('{@id}');"><img src="/images/songliwu.jpg"/></a></li>
</ul>
</xsl:for-each>
</xsl:template>
<xsl:template name="match_2">
<xsl:for-each select="//data">
<ul>
<li id="img"><xsl:choose><xsl:when test="@filesname!=''"><a onclick="giftShow('{@id}');"><img src="{@filesview}"/></a></xsl:when><xsl:otherwise><a href="?action=send&amp;id={@id}&amp;userid={//xml/@touid}"><img src="{@filesview}"/></a></xsl:otherwise></xsl:choose></li>
<li id="tt"><span><a href="?action=send&amp;id={@id}&amp;userid={//xml/@touid}"><xsl:value-of select="@sortname"/></a></span>还可使用 <font id="fontls"><xsl:value-of select="@maxnum"/></font> 次</li>
<li id="note"><font id="fontbl">礼物说明：</font><xsl:value-of select="@giftnote"/></li>
<li id="tool"><a href="?action=send&amp;id={@id}&amp;userid={//xml/@touid}"><img src="/images/btn_02.gif"/></a></li>
</ul>
</xsl:for-each>
</xsl:template>
<xsl:template name="match_3">
<xsl:for-each select="//data">
<ul>
<li id="img"><xsl:choose><xsl:when test="@filesname!=''"><a onclick="giftShow('{@id}');"><img src="{@filesview}"/></a></xsl:when><xsl:otherwise><img src="{@filesview}"/></xsl:otherwise></xsl:choose></li>
<li id="tt"><span>发送者：<a href="{@homepage1}"><xsl:value-of select="@fusername"/></a></span><xsl:value-of select="@addtime"/></li>
<li id="note"><font id="fontls"><xsl:value-of select="@sortname"/>：</font><xsl:value-of select="@content"/></li>
<li id="tool"><xsl:if test="@remark='isNull'"><a onclick="remark('{@id}');"><img src="/images/btn_01.gif"/></a>　</xsl:if><a href="?action=mygift&amp;userid={@fuserid}"><img src="/images/btn_02.gif"/></a></li>
</ul>
</xsl:for-each>
</xsl:template>
<xsl:template name="match_4">
<xsl:for-each select="//data">
<ul>
<li id="img"><xsl:choose><xsl:when test="@filesname!=''"><a onclick="giftShow('{@id}');"><img src="{@filesview}"/></a></xsl:when><xsl:otherwise><img src="{@filesview}"/></xsl:otherwise></xsl:choose></li>
<li id="tt"><span>接收者：<a href="{@homepage2}"><xsl:value-of select="@username"/></a></span><xsl:value-of select="@addtime"/></li>
<li id="note"><xsl:choose><xsl:when test="@remark='isNull'"><font id="fontls"><xsl:value-of select="@sortname"/>：</font><xsl:value-of select="@content"/></xsl:when><xsl:otherwise><font id="fontls">签收情况：</font><xsl:value-of select="@remark"/></xsl:otherwise></xsl:choose></li>
<li id="tool"><a href="?action=mygift&amp;userid={@userid}"><img src="/images/btn_02.gif"/></a></li>
</ul>
</xsl:for-each>
</xsl:template>
<xsl:template name="match_5">
<dd><xsl:for-each select="//data"><i><img src="{@filesview}" title="{@sortname}" onmousemove="pop_show(event,'show_gift','{@sortname}','{@giftnote}');" onmouseout="G('show_gift').style.display='none';"/></i></xsl:for-each></dd>
</xsl:template>
<xsl:template name="match_6">
<xsl:for-each select="//data">
<li id="box{@classid}"><a href="?action=type&amp;sortid={@classid}"><xsl:value-of select="@classname"/></a></li>
</xsl:for-each>
</xsl:template>
<xsl:template name="other">
</xsl:template>
</xsl:stylesheet>