﻿<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output omit-xml-declaration="yes"  indent="yes" version="6.0"/>
<!--
	Copyright (C) 2004,2009 Nslove.Net. All rights reserved.
	Written by Nslove.Net Nslove
	Web: http://www.Nslove.Com/
	Email: Info@Nslove.Com
	-->
<xsl:template match="/">
	<xsl:choose>
		<xsl:when test="xml/@action='1'"><xsl:call-template name="match_1"/></xsl:when>
		<xsl:when test="xml/@action='2'"><xsl:call-template name="match_2"/></xsl:when>
		<xsl:when test="xml/@action='3'"><xsl:call-template name="match_3"/></xsl:when>
		<xsl:when test="xml/@action='4'"><xsl:call-template name="match_4"/></xsl:when>
		<xsl:when test="xml/@action='5'"><xsl:call-template name="match_5"/></xsl:when>
		<xsl:when test="xml/@action='6'"><xsl:call-template name="match_6"/></xsl:when>
		<xsl:otherwise><xsl:call-template name="other"/></xsl:otherwise>
	</xsl:choose>
</xsl:template>
<xsl:template name="match_1">
<xsl:for-each select="//data">
<ul>
<li id="img"><xsl:choose><xsl:when test="@filesname!=''"><img src="{@filesview}"/></xsl:when><xsl:otherwise><img src="{@filesview}"/></xsl:otherwise></xsl:choose></li>
<li id="name"><span>赠送者：<a href="{@homepage1}"><xsl:value-of select="@fusername"/></a></span>时间：<xsl:value-of select="@addtime"/></li>
<li id="note"><xsl:value-of select="@content"/></li>
</ul>
</xsl:for-each>
</xsl:template>
<xsl:template name="match_2">
<xsl:for-each select="//data">
<ul><li id="tit"><span><a href="{@link1}" target="{@target}"><xsl:value-of select="@title"/></a></span>发表于：<xsl:value-of select="@addtime"/></li>
<li id="note"><xsl:value-of select="@content"/></li></ul>
</xsl:for-each>
</xsl:template>
<xsl:template name="match_3">
<xsl:for-each select="//data">
<ul><li id="tit"><span><a href="{@link1}" target="{@target}"><xsl:value-of select="@title"/></a></span>求助于：<xsl:value-of select="@addtime"/></li>
<li id="note"><xsl:value-of select="@content"/></li>
<li id="att">评论：<font id="fontls"><xsl:value-of select="@remark"/></font></li><li id="att">人气：<font id="fontor"><xsl:value-of select="@views"/></font></li><li id="att">悬赏：<font id="fontor"><xsl:value-of select="@moneys"/></font></li><li id="stas"><img src="/images/ask/{@isstas}.gif"/></li>
</ul>
</xsl:for-each>
</xsl:template>
<xsl:template name="match_4">
<xsl:for-each select="//data">
<ul><li id="tit">约会主题：<a href="{@link1}" target="{@target}"><xsl:value-of select="@title"/></a></li>
<li id="txt">约会时间：<xsl:value-of select="@startime"/></li>
<li id="txt">约会对象：<xsl:value-of select="@partners"/></li>
<li id="note"><xsl:value-of select="@content"/></li>
</ul>
</xsl:for-each>
</xsl:template>
<xsl:template name="match_5">
<xsl:for-each select="//data">
<ul><li id="img"><a href="{@homepage}" target="{@target}"><img src="{@userface}"/></a></li>
<li id="name"><a href="{@homepage}" target="{@target}"><xsl:value-of select="@friendname"/></a></li>
<li id="info"><xsl:value-of select="@userinfo"/></li></ul>
</xsl:for-each>
</xsl:template>
<xsl:template name="match_6">
<xsl:for-each select="//data">
<span id="span_{position()-1}"><table width="105" height="110"><tr><td valign="middle" align="center"><a href="/home/avatar.asp?userid={@userid}&amp;showid={position()-1}" target="{@target}"><img src="{@filesview}" onload="DrawImage(this,81,100)"/></a></td></tr></table></span>
</xsl:for-each>
</xsl:template>
<xsl:template name="other">
</xsl:template>
</xsl:stylesheet>