﻿<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output omit-xml-declaration="yes"  indent="yes" version="6.0"/>
<!--
	Copyright (C) 2004,2009 Nslove.Net. All rights reserved.
	Written by Nslove.Net Nslove
	Web: http://www.Nslove.Com/
	Email: Info@Nslove.Com
	-->
<xsl:template match="/">
	<xsl:choose>
		<xsl:when test="xml/@action='1'"><xsl:call-template name="match_1"/></xsl:when>
		<xsl:when test="xml/@action='2'"><xsl:call-template name="match_2"/></xsl:when>
		<xsl:when test="xml/@action='3'"><xsl:call-template name="match_3"/></xsl:when>
		<xsl:when test="xml/@action='4'"><xsl:call-template name="match_4"/></xsl:when>
		<xsl:when test="xml/@action='5'"><xsl:call-template name="match_5"/></xsl:when>
		<xsl:when test="xml/@action='6'"><xsl:call-template name="match_6"/></xsl:when>
		<xsl:when test="xml/@action='7'"><xsl:call-template name="match_7"/></xsl:when>
		<xsl:when test="xml/@action='8'"><xsl:call-template name="match_8"/></xsl:when>
		<xsl:when test="xml/@action='9'"><xsl:call-template name="match_9"/></xsl:when>
		<xsl:otherwise><xsl:call-template name="other"/></xsl:otherwise>
	</xsl:choose>
</xsl:template>
<xsl:template name="match_1">
<xsl:for-each select="//data">
<ul>
<li id="tit"><span><input type="checkbox" name="id" value="{@id}"/> <font id="fontls">[<xsl:value-of select="@cityname"/>]</font> <a href="{@link1}" target="{@target}"><xsl:value-of select="@title"/></a></span>已有 <font id="fontls"><b><xsl:value-of select="@signup"/></b></font> 人报名</li>
<li id="img"><a href="{@link1}" target="{@target}"><xsl:choose><xsl:when test="@filesview=''"><img src="/images/nophoto.gif"/></xsl:when><xsl:otherwise><img src="{@filesview}"/></xsl:otherwise></xsl:choose></a></li>
<li id="date"><b>举行日期：</b><xsl:value-of select="@startime"/></li><li id="zone"><b>活动地点：</b><xsl:value-of select="@address"/></li><li id="note"><b>活动简介：</b><xsl:value-of select="@innote"/></li>
</ul>
</xsl:for-each>
</xsl:template>
<xsl:template name="match_2">
<xsl:for-each select="//data">
<div class="list_div">
<h1><span>[<xsl:value-of select="@cityname"/>] <b><a href="{@link1}" target="{@target}"><xsl:value-of select="@title"/></a></b></span><xsl:choose><xsl:when test="@overtime='0'">活动已结束</xsl:when><xsl:otherwise>报名还有 <font id="fonthz"><xsl:value-of select="@overtime"/></font> 天</xsl:otherwise></xsl:choose></h1>
<ul><li id="img"><xsl:choose><xsl:when test="@filesview=''"><img src="/images/nophoto.gif"/></xsl:when><xsl:otherwise><a href="{@link1}" target="{@target}"><img src="{@filesview}"/></a></xsl:otherwise></xsl:choose></li>
<li><b>举行日期：</b><xsl:value-of select="@startime"/></li>
<li><b>活动地点：</b><xsl:value-of select="@address"/></li>
<li><b>邀请人数：</b><xsl:choose><xsl:when test="@injoin='0'">不限人数</xsl:when><xsl:otherwise><xsl:value-of select="@injoin"/> 人</xsl:otherwise></xsl:choose></li>
<li id="note"><b>活动简介：</b><xsl:value-of select="@innote"/></li></ul>
<h2><i><xsl:choose><xsl:when test="@mmoney='0' and @fmoney='0'">免费报名</xsl:when><xsl:when test="@mmoney='0'">男会员：免费，女会员：<xsl:value-of select="@fmoney"/> 个金币</xsl:when><xsl:when test="@fmoney='0'">男会员：<xsl:value-of select="@mmoney"/> 个金币，女会员：免费</xsl:when><xsl:otherwise>男会员：<xsl:value-of select="@mmoney"/> 个金币，女会员：<xsl:value-of select="@fmoney"/> 个金币</xsl:otherwise></xsl:choose></i><span><em><a class="btngray" href="{@link1}" target="{@target}">我要报名</a></em></span>已有 <b id="fonthz"><xsl:value-of select="@signup"/></b> 人报名</h2>
</div>
</xsl:for-each>
</xsl:template>
<xsl:template name="match_3">
<xsl:for-each select="//data">
<div class="list_div">
<h1><span>[<xsl:value-of select="@cityname"/>] <b><a href="{@link1}" target="{@target}"><xsl:value-of select="@title"/></a></b></span><a href="{@link1}" target="{@target}">查看详情>></a></h1>
<ul><li id="img"><xsl:choose><xsl:when test="@filesview=''"><img src="/images/nophoto.gif"/></xsl:when><xsl:otherwise><a href="{@link1}" target="{@target}"><img src="{@filesview}"/></a></xsl:otherwise></xsl:choose></li>
<li><b>举行日期：</b><xsl:value-of select="@startime"/></li>
<li><b>活动地点：</b><xsl:value-of select="@address"/></li>
<li><b>邀请人数：</b><xsl:choose><xsl:when test="@injoin='0'">不限人数</xsl:when><xsl:otherwise><xsl:value-of select="@injoin"/> 人</xsl:otherwise></xsl:choose></li>
<li id="note"><b>活动简介：</b><xsl:value-of select="@innote"/></li></ul>
<h2><span></span>已有 <b id="fonthz"><xsl:value-of select="@signup"/></b> 人报名</h2>
</div>
</xsl:for-each>
</xsl:template>
<xsl:template name="match_4">
<xsl:for-each select="//data">
<ul id="klatch">
<li id="qntt"><b><a href="{@link1}" target="{@target}"><xsl:value-of select="@title"/></a></b></li>
<li id="ltxt"><span><img src="{@filesview}"/></span>时间：<xsl:value-of select="@startime"/><br />地点：<xsl:value-of select="@cityname"/><br />人数：<xsl:choose><xsl:when test="@injoin='0'">不限</xsl:when><xsl:otherwise><xsl:value-of select="@injoin"/> 人</xsl:otherwise></xsl:choose>　　　<a href="{@link1}" target="{@target}">详细>></a></li>
</ul>
</xsl:for-each>
</xsl:template>
<xsl:template name="match_5">
<xsl:for-each select="//data">
<li id="dot1"><a href="{@link1}" target="{@target}"><xsl:value-of select="@title"/></a></li>
</xsl:for-each>
</xsl:template>
<xsl:template name="match_6">
<xsl:for-each select="//data">
<ul>
<li id="img"><xsl:choose><xsl:when test="@filesview=''"><img src="/images/nophoto.gif"/></xsl:when><xsl:otherwise><a href="{@link1}" target="{@target}"><img src="{@filesview}"/></a></xsl:otherwise></xsl:choose></li>
<li><a href="{@link1}" target="{@target}"><font id="fontls"><xsl:value-of select="@title"/></font></a></li>
<li><b>举行日期：</b><font id="fontgn"><xsl:value-of select="@startime"/></font></li>
<li><b>活动地点：</b><xsl:value-of select="@address"/></li>
<li><b>邀请人数：</b><xsl:choose><xsl:when test="@injoin='0'">不限人数</xsl:when><xsl:otherwise><xsl:value-of select="@injoin"/> 人</xsl:otherwise></xsl:choose></li>
<li id="tool"><em><b>活动状态：</b><xsl:choose><xsl:when test="@isover='1'"><font id="fontrd">已结束</font></xsl:when><xsl:when test="@checked='0'">审核中</xsl:when><xsl:otherwise><font id="fontrd">已审核</font></xsl:otherwise></xsl:choose></em><a href="?action=addkl&amp;id={@id}">修改信息</a> | <a href="?action=upload&amp;id={@id}">上传照片</a> | <a href="?action=notice&amp;id={@id}">活动公告</a> | <a href="?action=join&amp;id={@id}">报名管理</a> | <a onclick="ctrlfile('7','{@id}','','结束活动');">结束活动</a></li>
</ul>
</xsl:for-each>
</xsl:template>
<xsl:template name="match_7">
<xsl:for-each select="//data">
<ul>
<li id="tit"><a href="{@link1}" target="{@target}"><xsl:value-of select="@title"/></a></li>
<li id="img"><span><img src="{@filesview}"/></span></li>
<li id="note">活动地点：<xsl:value-of select="@address"/><br />举行时间：<xsl:value-of select="@startime"/></li>
<li id="lnk"><a href="{@link1}" target="{@target}">查看详细>></a></li>
</ul>
</xsl:for-each>
</xsl:template>
<xsl:template name="match_8">
<xsl:for-each select="//data">
<li><span id="img"><a href="{@link1}" target="{@target}"><img src="{@filesview}" alt="{@title}" /></a></span><span id="lnk"><a href="{@link1}" target="{@target}">马上报名</a></span></li>
</xsl:for-each>
</xsl:template>
<xsl:template name="match_9">
<xsl:for-each select="//data">
<ul>
<li id="img"><xsl:choose><xsl:when test="@filesview=''"><img src="/images/nophoto.gif"/></xsl:when><xsl:otherwise><a href="{@link1}" target="{@target}"><img src="{@filesview}"/></a></xsl:otherwise></xsl:choose><br />活动状态：<xsl:choose><xsl:when test="@isover='1'"><font id="fontrd">已结束</font></xsl:when><xsl:when test="@checked='0'">审核中</xsl:when><xsl:otherwise><font id="fontrd">已审核</font></xsl:otherwise></xsl:choose></li>
<li><a href="{@link1}" target="{@target}"><font id="fontls"><xsl:value-of select="@title"/></font></a></li>
<li><b>举行日期：</b><font id="fontgn"><xsl:value-of select="@startime"/></font></li>
<li><b>活动地点：</b><xsl:value-of select="@address"/></li>
<li><b>邀请人数：</b><xsl:choose><xsl:when test="@injoin='0'">不限人数</xsl:when><xsl:otherwise><xsl:value-of select="@injoin"/> 人</xsl:otherwise></xsl:choose></li>
<li id="tool"><b>操作管理：</b><a href="?action=add&amp;id={@id}">修改活动</a> | <a href="?action=upload&amp;id={@id}">上传照片</a> | <a href="?action=notice&amp;id={@id}">活动公告</a> | <a href="?action=join&amp;id={@id}">报名管理</a> | <a onclick="ctrlfile('7','{@id}','','结束活动');">结束</a></li>
</ul>
</xsl:for-each>
</xsl:template>
<xsl:template name="other">
</xsl:template>
</xsl:stylesheet>