﻿<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output omit-xml-declaration="yes"/>
<!--
	Copyright (C) 2004,2009 Nslove.Net. All rights reserved.
	Written by Nslove.Net Nslove
	Web: http://www.Nslove.Com/
	Email: Info@Nslove.Com
	-->
<xsl:template match="/">
	<xsl:choose>
		<xsl:when test="xml/@action='1'"><xsl:call-template name="match_1"/></xsl:when>
		<xsl:when test="xml/@action='2'"><xsl:call-template name="match_2"/></xsl:when>
		<xsl:when test="xml/@action='3'"><xsl:call-template name="match_3"/></xsl:when>
		<xsl:when test="xml/@action='4'"><xsl:call-template name="match_4"/></xsl:when>
		<xsl:when test="xml/@action='5'"><xsl:call-template name="match_5"/></xsl:when>
		<xsl:when test="xml/@action='6'"><xsl:call-template name="match_6"/></xsl:when>
		<xsl:otherwise><xsl:call-template name="other"/></xsl:otherwise>
	</xsl:choose>
</xsl:template>
<xsl:template name="match_1">
<xsl:for-each select="//data">
<li id="img"><a href="/link.asp?id={@id}" target="{@target}" title="{@content}"><img src="{@logourl}" alt="{@content}" /></a></li>
</xsl:for-each>
</xsl:template>
<xsl:template name="match_2">
<xsl:for-each select="//data">
<li id="txt"><a href="/link.asp?id={@id}" target="{@target}" title="{@content}"><xsl:value-of select="@title"/></a></li>
</xsl:for-each>
</xsl:template>
<xsl:template name="match_3">
<xsl:for-each select="//data"><ul>
<li id="img"><a href="/link.asp?id={@id}" target="{@target}" title="{@content}"><img src="{@logourl}" alt="{@content}" /></a></li>
<li><a href="/link.asp?id={@id}" target="{@target}" title="{@content}"><xsl:value-of select="@title"/></a></li><li id="time"><xsl:value-of select="@addtime"/></li></ul>
</xsl:for-each>
</xsl:template>
<xsl:template name="match_4">
<xsl:for-each select="//data">
<ul><li id="txt"><a href="/link.asp?id={@id}" target="{@target}"><xsl:value-of select="@title"/></a></li><li id="note"><xsl:value-of select="@content"/></li><li id="hits"><xsl:value-of select="@views"/></li></ul>
</xsl:for-each>
</xsl:template>
<xsl:template name="match_5">
<xsl:for-each select="//data">
<ul><li id="img"><xsl:choose><xsl:when test="@logourl=''"><img src="/images/nophoto.gif"/></xsl:when><xsl:otherwise><a href="/link.asp?id={@id}" target="{@target}"><img src="{@logourl}"/></a></xsl:otherwise></xsl:choose></li><li id="note"><xsl:value-of select="@content"/></li><li id="hits"><xsl:value-of select="@views"/></li></ul>
</xsl:for-each>
</xsl:template>
<xsl:template name="match_6">
<xsl:for-each select="//data">
<ul><li id="tit"><span><input type="checkbox" name="id" value="{@id}"/> <a href="/link.asp?id={@id}" target="{@target}"><xsl:value-of select="@title"/></a></span>时间：<xsl:value-of select="@addtime"/></li><li id="img"><xsl:choose><xsl:when test="@logourl=''"><img src="/images/nophoto.gif"/></xsl:when><xsl:otherwise><a href="/link.asp?id={@id}" target="{@target}"><img src="{@logourl}"/></a></xsl:otherwise></xsl:choose></li><li id="note"><font id="fontls">简介：</font><xsl:value-of select="@content"/></li></ul>
</xsl:for-each>
</xsl:template>
<xsl:template name="other">
</xsl:template>
</xsl:stylesheet>