﻿<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output omit-xml-declaration="yes"  indent="yes" version="6.0"/>
<!--
	Copyright (C) 2004,2009 Nslove.Net. All rights reserved.
	Written by Nslove.Net Nslove
	Web: http://www.Nslove.Com/
	Email: Info@Nslove.Com
	-->
<xsl:template match="/">
	<xsl:choose>
		<xsl:when test="xml/@action='1'"><xsl:call-template name="match_1"/></xsl:when>
		<xsl:when test="xml/@action='2'"><xsl:call-template name="match_2"/></xsl:when>
		<xsl:when test="xml/@action='3'"><xsl:call-template name="match_3"/></xsl:when>
		<xsl:when test="xml/@action='4'"><xsl:call-template name="match_4"/></xsl:when>
		<xsl:otherwise><xsl:call-template name="other"/></xsl:otherwise>
	</xsl:choose>
</xsl:template>
<xsl:template name="match_1">
<xsl:for-each select="//data">
<ul>
<li id="img"><a href="{@homepage}" target="{@target}"><img src="{@userface}"/></a></li>
<li id="user"><a href="{@homepage}" target="{@target}"><xsl:value-of select="@username"/></a></li>
<li id="faith"><img src="/images/star/{@userfaith}.gif"/></li>
<li id="zone">征友地区：<xsl:value-of select="@findzone"/></li>
<li id="info"><xsl:value-of select="@userinfo"/></li>
<li id="note"><a href="{@homepage}" target="{@target}"><xsl:value-of select="@usernote"/></a></li>
<li id="tool"><em class="button"><a href="{@homepage}" target="{@target}">查看详细</a></em><em><a class="btn_mark sendmsg" href="usermsg.asp?action=send&amp;userid={@userid}" target="{@target}">发消息</a></em></li>
</ul>
</xsl:for-each>
</xsl:template>
<xsl:template name="match_2">
<xsl:for-each select="//data">
<ul id="show">
<li id="img1"><a href="{@homepage}" target="{@target}"><img src="{@userface}"/></a></li>
<li id="user1"><a href="{@homepage}" target="{@target}"><xsl:value-of select="@username"/></a>　<xsl:value-of select="@zonetxt"/></li>
</ul>
</xsl:for-each>
</xsl:template>
<xsl:template name="match_3">
<xsl:for-each select="//data">
<ul id="show">
<li id="img"><a href="{@homepage}" target="{@target}"><img src="{@userface}"/></a></li>
<li id="user"><xsl:value-of select="@userinfo"/></li>
<li id="time"><xsl:value-of select="@addtime"/>浏览</li>
<li id="time"><i><input type="checkbox" name="id" value="{@id}"/></i>删除</li>
</ul>
</xsl:for-each>
</xsl:template>
<xsl:template name="match_4">
<xsl:for-each select="//data">
<ul id="show">
<li id="img"><a href="{@homepage}" target="{@target}"><img src="{@userface}"/></a></li>
<li id="user"><xsl:value-of select="@userinfo"/></li>
<li id="time"><xsl:value-of select="@addtime"/>收藏</li>
<li id="time"><i><input type="checkbox" name="id" value="{@id}"/></i>删除</li>
</ul>
</xsl:for-each>
</xsl:template>
<xsl:template name="other">
</xsl:template>
</xsl:stylesheet>