﻿<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output omit-xml-declaration="yes"  indent="yes" version="6.0"/>
<!--
	Copyright (C) 2004,2009 Nslove.Net. All rights reserved.
	Written by Nslove.Net Nslove
	Web: http://www.Nslove.Com/
	Email: Info@Nslove.Com
	-->
<xsl:template match="/">
	<xsl:choose>
		<xsl:when test="xml/@action='1'"><xsl:call-template name="match_1"/></xsl:when>
		<xsl:when test="xml/@action='2'"><xsl:call-template name="match_2"/></xsl:when>
		<xsl:when test="xml/@action='3'"><xsl:call-template name="match_3"/></xsl:when>
		<xsl:when test="xml/@action='4'"><xsl:call-template name="match_4"/></xsl:when>
		<xsl:when test="xml/@action='5'"><xsl:call-template name="match_5"/></xsl:when>
		<xsl:when test="xml/@action='6'"><xsl:call-template name="match_6"/></xsl:when>
		<xsl:otherwise><xsl:call-template name="other"/></xsl:otherwise>
	</xsl:choose>
</xsl:template>
<xsl:template name="match_1">
<xsl:for-each select="//data">
<ul>
<li class="frm30"><input type="checkbox" name="id" value="{@id}"/></li>
<li class="frm220"><xsl:value-of select="@title"/></li>
<li class="frm180" id="fontrd"><xsl:value-of select="@paycode"/></li>
<li class="frm70">&#160;</li>
<li class="frm70">&#160;</li>
<li class="frm90" id="txtc"><b id="fontls"><xsl:value-of select="@moneys"/></b> 元</li>
<li class="frm130"><xsl:value-of select="@addtime"/></li>
<li class="frm90" id="txtc"><xsl:value-of select="@buynums"/> 件</li>
<li class="frm70" id="txtc"><xsl:choose><xsl:when test="@sortid='1'"><font id="fontbl">货到付款</font></xsl:when><xsl:when test="@ispay='0'"><a onclick="ctrlfile('4','0','{@id}','在线支付');"><font id="fontrd">在线支付</font></a></xsl:when><xsl:otherwise><font id="fontgn">已支付</font></xsl:otherwise></xsl:choose></li>
</ul>
</xsl:for-each>
</xsl:template>
<xsl:template name="match_2">
<xsl:for-each select="//data">
<ul>
<li class="frm30"><input type="checkbox" name="id" value="{@id}"/></li>
<li class="frm220"><xsl:value-of select="@title"/></li>
<li class="frm70"><xsl:choose><xsl:when test="@moneys='0'"><font id="fontls">免费赠送</font></xsl:when><xsl:otherwise><xsl:value-of select="@moneys"/></xsl:otherwise></xsl:choose></li>
<li class="frm110"><xsl:value-of select="@addtime"/></li>
<li class="frm70"><xsl:choose><xsl:when test="@ispay='0'"><a onclick="ctrlfile('2','0','{@id}','现在支付');"><font id="fontrd">现在支付</font></a></xsl:when><xsl:when test="@checked='0'"><font id="fontbl">等待审核</font></xsl:when><xsl:when test="@overtime&lt;'0'"><a onclick="ctrlfile('2','0','{@id}','再次购买');"><font id="fontrd">已到期</font></a></xsl:when><xsl:otherwise><font id="fontgn">正常使用</font></xsl:otherwise></xsl:choose></li>
</ul>
</xsl:for-each>
</xsl:template>
<xsl:template name="match_3">
<xsl:for-each select="//data">
<ul>
<li class="frm70" id="txtc"><xsl:value-of select="@id"/></li>
<li class="frm220"><xsl:value-of select="@title"/></li>
<li class="frm100" id="txtc"><xsl:value-of select="@paynum"/></li>
<li class="frm110"><xsl:value-of select="@addtime"/></li>
</ul>
</xsl:for-each>
</xsl:template>
<xsl:template name="match_4">
<xsl:for-each select="//data">
<ul>
<li class="frm70" id="txtc"><xsl:value-of select="@id"/></li>
<li class="frm130" id="txtc"><xsl:value-of select="@username"/></li>
<li class="frm220"><xsl:value-of select="@title"/>　<a onclick="ctrlfile('4','0','{@id}','不再显示');"><font id="fontbl">[不显示]</font></a></li>
<li class="frm100" id="txtc"><xsl:value-of select="@paynum"/></li>
<li class="frm100"><xsl:value-of select="@addtime"/></li>
<li class="frm50"><xsl:choose><xsl:when test="@flag='1'"><font id="fontrd">已提成</font></xsl:when><xsl:otherwise><font id="fontbl">未提成</font></xsl:otherwise></xsl:choose></li>
</ul>
</xsl:for-each>
</xsl:template>
<xsl:template name="match_5">
<xsl:for-each select="//data">
<ul>
<li><span>提现银行：</span><xsl:value-of select="@bankname"/></li>
<li><span>银行帐号：</span><xsl:value-of select="@cardcode"/></li>
<li><span>提现金额：</span><b id="fontls"><xsl:value-of select="@moneys"/></b> 元</li>
<li><span>提现时间：</span><xsl:value-of select="@addtime"/></li>
<li><span>提现状态：</span><xsl:choose><xsl:when test="@flag='1'"><font id="fontbl">已汇款</font></xsl:when><xsl:otherwise><font id="fontrd">未处理</font></xsl:otherwise></xsl:choose></li>
</ul>
</xsl:for-each>
</xsl:template>
<xsl:template name="match_6">
　　　　卡　号　　　　　　　密　码　　　　　　金额
<xsl:for-each select="//data">
<xsl:value-of select="@cardcode"/>　<xsl:value-of select="@password"/>　<xsl:value-of select="@moneys"/>&#xa;</xsl:for-each>
</xsl:template>
<xsl:template name="other">
</xsl:template>
</xsl:stylesheet>