﻿<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output omit-xml-declaration="yes"  indent="yes" version="6.0"/>
<!--
	Copyright (C) 2004,2009 Nslove.Net. All rights reserved.
	Written by Nslove.Net Nslove
	Web: http://www.Nslove.Com/
	Email: Info@Nslove.Com
	-->
<xsl:template match="/">
	<xsl:choose>
		<xsl:when test="xml/@action='1'"><xsl:call-template name="match_1"/></xsl:when>
		<xsl:when test="xml/@action='2'"><xsl:call-template name="match_2"/></xsl:when>
		<xsl:when test="xml/@action='3'"><xsl:call-template name="match_3"/></xsl:when>
		<xsl:when test="xml/@action='4'"><xsl:call-template name="match_4"/></xsl:when>
		<xsl:when test="xml/@action='5'"><xsl:call-template name="match_5"/></xsl:when>
		<xsl:when test="xml/@action='6'"><xsl:call-template name="match_6"/></xsl:when>
		<xsl:when test="xml/@action='7'"><xsl:call-template name="match_7"/></xsl:when>
		<xsl:when test="xml/@action='8'"><xsl:call-template name="match_8"/></xsl:when>
		<xsl:otherwise><xsl:call-template name="other"/></xsl:otherwise>
	</xsl:choose>
</xsl:template>
<xsl:template name="match_1">
<xsl:for-each select="//data">
<dd><input type="radio" name="oid" value="{@id}"/> <xsl:value-of select="@title"/></dd>
</xsl:for-each>
</xsl:template>
<xsl:template name="match_2">
<xsl:for-each select="//data"><em><img src="{@myheart}" height="18"/></em><xsl:value-of select="@title"/></xsl:for-each>
</xsl:template>
<xsl:template name="match_3">
<xsl:for-each select="//data"><em><img src="{@myheart}"/></em><em id="tit"><font id="fontor">签名：</font><xsl:value-of select="@title"/></em></xsl:for-each>
</xsl:template>
<xsl:template name="match_4">
<xsl:for-each select="//data">
<ul><li id="sort"><xsl:value-of select="@sortname"/></li><li id="tit"><xsl:value-of select="@title"/></li><li id="chk"><xsl:choose><xsl:when test="@checked='1'"><font id="fontbl">已处理</font></xsl:when><xsl:when test="@checked='2'"><font id="fontrd">无证据</font></xsl:when><xsl:otherwise><font id="fontrd">未处理</font></xsl:otherwise></xsl:choose></li><li id="time"><xsl:value-of select="@addtime"/></li></ul>
</xsl:for-each>
</xsl:template>
<xsl:template name="match_5">
<xsl:for-each select="//data">
<ul>
<li><span>开户银行：</span><xsl:value-of select="@bankname"/></li>
<li><span>银行卡号：</span><xsl:value-of select="@cardcode"/></li>
<li><span>开户姓名：</span><xsl:value-of select="@cardname"/></li>
<li><span>帐号状态：</span><xsl:choose><xsl:when test="@checked='1'"><font id="fontgn">已审核</font></xsl:when><xsl:otherwise><font id="fontrd">未审核</font>　<a onclick="ctrlfile('3','0','{@id}','删除帐户');"><font id="fontor">删除帐户</font></a></xsl:otherwise></xsl:choose>　<a href="?action=binding&amp;id={@id}"><font id="fontbl">修改帐户</font></a></li></ul>
</xsl:for-each>
</xsl:template>
<xsl:template name="match_6">
<xsl:for-each select="//data">
<ul><li id="dot1"><a onclick="innHtml('{@title}','{@content}');"><xsl:value-of select="@title"/></a></li></ul>
</xsl:for-each>
</xsl:template>
<xsl:template name="match_7">
<xsl:for-each select="//data">
<ul><li><input type="radio" name="id" value="{@id}"/> <xsl:value-of select="@title"/></li></ul>
</xsl:for-each>
</xsl:template>
<xsl:template name="match_8">
<xsl:for-each select="//data">
<ul><li><xsl:value-of select="@content"/></li></ul>
</xsl:for-each>
</xsl:template>
<xsl:template name="other">
</xsl:template>
</xsl:stylesheet>