﻿<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output omit-xml-declaration="yes"  indent="yes" version="6.0"/>
<!--
	Copyright (C) 2004,2009 Nslove.Net. All rights reserved.
	Written by Nslove.Net Nslove
	Web: http://www.Nslove.Com/
	Email: Info@Nslove.Com
	-->
<xsl:template match="/">
	<xsl:choose>
		<xsl:when test="xml/@action='1'"><xsl:call-template name="match_1"/></xsl:when>
		<xsl:when test="xml/@action='2'"><xsl:call-template name="match_2"/></xsl:when>
		<xsl:when test="xml/@action='3'"><xsl:call-template name="match_3"/></xsl:when>
		<xsl:when test="xml/@action='4'"><xsl:call-template name="match_4"/></xsl:when>
		<xsl:otherwise><xsl:call-template name="other"/></xsl:otherwise>
	</xsl:choose>
</xsl:template>
<xsl:template name="match_1">
<xsl:for-each select="//data">
<ul>
<li id="tit"><span><input type="checkbox" name="id" value="{@id}"/> [<font id="fontls"><xsl:value-of select="@address"/></font>] <a href="{@link1}" target="{@target}"><font id="fontls"><xsl:value-of select="@title"/></font></a></span>已有 <font id="fontls"><b><xsl:value-of select="@signup"/></b></font> 人报名</li>
<li id="img"><a href="{@homepage}" target="{@target}"><img src="{@userface}"/></a></li>
<li id="zone"><b>发 起 人：</b><a href="{@homepage}" target="{@target}"><font id="fontls"><xsl:value-of select="@username"/></font></a></li><li id="zone"><b>约会时间：</b><xsl:value-of select="@startime"/></li><li id="zone"><b>费用预算：</b><xsl:value-of select="@expense"/></li><li id="zone"><b>约会对象：</b><xsl:value-of select="@partners"/></li><li id="note"><b>约会简介：</b><xsl:value-of select="@content"/></li>
</ul>
</xsl:for-each>
</xsl:template>
<xsl:template name="match_2">
<xsl:for-each select="//data">
<ul>
<li class="frm30"><input type="checkbox" name="id" value="{@id}"/></li>
<li class="frm180"><a href="{@link1}" target="{@target}"><xsl:value-of select="@title"/></a></li>
<li class="frm70" id="txtc"><xsl:value-of select="@sortname"/></li>
<li class="frm55" id="txtc"><xsl:value-of select="@signup"/></li>
<li class="frm90" id="txtc"><xsl:value-of select="@startime"/></li>
<li class="frm70"><xsl:choose><xsl:when test="@checked='1'"><a href="?action=add&amp;id={@id}">编辑</a> <a href="?action=join&amp;id={@id}">管理</a></xsl:when><xsl:otherwise><font id="fontor">约会审核中</font></xsl:otherwise></xsl:choose></li>
</ul>
</xsl:for-each>
</xsl:template>
<xsl:template name="match_3">
<xsl:for-each select="//data">
<li>时间：<xsl:value-of select="@startime"/></li>
<li>地点：<xsl:value-of select="@address"/></li>
<li>对象：<xsl:value-of select="@partners"/></li>
<li><a href="{@link1}" target="{@target}">[查看详情]</a></li>
<li><a href="{@link1}" target="{@target}">[等你赴约联系我]</a></li>
</xsl:for-each>
</xsl:template>
<xsl:template name="match_4">
<xsl:for-each select="//data">
<div class="left_div">
<p><img src="{@userface}"/></p>
<ul><li id="tt"><span>约会主题：</span><a href="{@link1}" target="{@target}"><b><xsl:value-of select="@title"/></b></a></li><li><span>发起人：</span><a href="{@homepage}" target="{@target}"><xsl:value-of select="@username"/></a></li><li><span>约会时间：</span><xsl:value-of select="@startime"/></li><li><span>约会城市：</span><xsl:value-of select="@address"/></li><li><span>预算费用：</span><xsl:value-of select="@expense"/></li><li><span>约会对象：</span><xsl:value-of select="@partners"/></li></ul>
<dl><dd id="ttp">报名还有 <b><xsl:value-of select="@overtime"/></b> 天</dd><dd>有<a><xsl:value-of select="@signup"/></a>人响应TA</dd><dd>有<a><xsl:value-of select="@views"/></a>人关注TA</dd><dd><a href="{@link1}" target="{@target}"><img src="/images/btn_03.gif"/></a></dd></dl>
</div>
</xsl:for-each>
</xsl:template>
<xsl:template name="other">
</xsl:template>
</xsl:stylesheet>