﻿<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output omit-xml-declaration="yes"  indent="yes" version="6.0"/>
<!--
	Copyright (C) 2004,2009 Nslove.Net. All rights reserved.
	Written by Nslove.Net Nslove
	Web: http://www.Nslove.Com/
	Email: Info@Nslove.Com
	-->
<xsl:template match="/">
	<xsl:choose>
		<xsl:when test="xml/@action='1'"><xsl:call-template name="match_1"/></xsl:when>
		<xsl:when test="xml/@action='2'"><xsl:call-template name="match_2"/></xsl:when>
		<xsl:when test="xml/@action='3'"><xsl:call-template name="match_3"/></xsl:when>
		<xsl:when test="xml/@action='4'"><xsl:call-template name="match_4"/></xsl:when>
		<xsl:when test="xml/@action='5'"><xsl:call-template name="match_5"/></xsl:when>
		<xsl:when test="xml/@action='6'"><xsl:call-template name="match_6"/></xsl:when>
		<xsl:otherwise><xsl:call-template name="other"/></xsl:otherwise>
	</xsl:choose>
</xsl:template>
<xsl:template name="match_1">
<xsl:for-each select="//data">
<ul>
<li id="tit"><span><input type="checkbox" name="id" value="{@id}"/> <font id="fontls">[<xsl:value-of select="@address"/>]</font> <a href="{@link1}" target="{@target}"><xsl:value-of select="@title"/></a></span>已有 <font id="fontls"><b><xsl:value-of select="@signup"/></b></font> 人报名</li>
<li id="img"><a href="{@link1}" target="{@target}"><xsl:choose><xsl:when test="@filesview=''"><img src="/images/nophoto.gif"/></xsl:when><xsl:otherwise><img src="{@filesview}"/></xsl:otherwise></xsl:choose></a></li>
<li id="date"><b>结束日期：</b><xsl:value-of select="@addtime"/></li><li id="zone"><b>拼客类型：</b><xsl:value-of select="@sortname"/></li><li id="note"><b>拼客简介：</b><xsl:value-of select="@content"/></li>
</ul>
</xsl:for-each>
</xsl:template>
<xsl:template name="match_2">
<xsl:for-each select="//data">
<ul>
<li class="frm30"><input type="checkbox" name="id" value="{@id}"/></li>
<li class="frm180"><a href="{@link1}" target="{@target}"><xsl:value-of select="@title"/></a></li>
<li class="frm70" id="txtc"><xsl:value-of select="@sortname"/></li>
<li class="frm55" id="txtc"><a href="?action=join&amp;id={@id}">管理</a></li>
<li class="frm90" id="txtc"><xsl:value-of select="@addtime"/></li>
<li class="frm70"><xsl:choose><xsl:when test="@checked='1'"><a href="?action=add&amp;id={@id}">编辑</a> <a href="?action=upload&amp;id={@id}">上传</a></xsl:when><xsl:otherwise><font id="fontor">拼客审核中</font></xsl:otherwise></xsl:choose></li>
</ul>
</xsl:for-each>
</xsl:template>
<xsl:template name="match_3">
<xsl:for-each select="//data">
<li id="dot1"><a href="{@link1}" target="{@target}"><xsl:value-of select="@title"/></a></li>
</xsl:for-each>
</xsl:template>
<xsl:template name="match_4">
<xsl:for-each select="//data"><li><span><img src="{@filesview}"/></span><xsl:value-of select="@title"/></li>
</xsl:for-each>
</xsl:template>
<xsl:template name="match_5">
<xsl:for-each select="//data">
<ul><li id="img"><xsl:choose><xsl:when test="@isphoto='0'"><img src="/images/nophoto.gif"/></xsl:when><xsl:otherwise><img src="{@filesview}"/></xsl:otherwise></xsl:choose></li><li id="txt"><em>[<a href="search.asp?sortid={@sortid}" target="{@target}"><xsl:value-of select="@sortname"/></a>]</em><a href="{@link1}" target="{@target}"><xsl:value-of select="@title"/></a></li><li id="note"><xsl:value-of select="@content"/></li><li id="bot">发起人：<a href="{@homepage}" target="{@target}"><xsl:value-of select="@username"/></a>　时间：<xsl:value-of select="@addtime"/>　人气：<b id="fontls"><xsl:value-of select="@views"/></b>　已报名：<b id="fontls"><xsl:value-of select="@signup"/></b> 人</li></ul>
</xsl:for-each>
</xsl:template>
<xsl:template name="match_6">
<xsl:for-each select="//data">
<li class="ntop3 ntp_{position()}"><a href="{@link1}" target="{@target}"><xsl:value-of select="@title"/></a></li>
</xsl:for-each>
</xsl:template>
<xsl:template name="other">
</xsl:template>
</xsl:stylesheet>