﻿<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output omit-xml-declaration="yes"  indent="yes" version="6.0"/>
<!--
	Copyright (C) 2004,2009 Nslove.Net. All rights reserved.
	Written by Nslove.Net Nslove
	Web: http://www.Nslove.Com/
	Email: Info@Nslove.Com
	-->
<xsl:template match="/">
	<xsl:choose>
		<xsl:when test="xml/@action='1'"><xsl:call-template name="match_1"/></xsl:when>
		<xsl:when test="xml/@action='2'"><xsl:call-template name="match_2"/></xsl:when>
		<xsl:when test="xml/@action='3'"><xsl:call-template name="match_3"/></xsl:when>
		<xsl:when test="xml/@action='4'"><xsl:call-template name="match_4"/></xsl:when>
		<xsl:when test="xml/@action='5'"><xsl:call-template name="match_5"/></xsl:when>
		<xsl:when test="xml/@action='6'"><xsl:call-template name="match_6"/></xsl:when>
		<xsl:when test="xml/@action='7'"><xsl:call-template name="match_7"/></xsl:when>
		<xsl:when test="xml/@action='8'"><xsl:call-template name="match_8"/></xsl:when>
		<xsl:when test="xml/@action='9'"><xsl:call-template name="match_9"/></xsl:when>
		<xsl:otherwise><xsl:call-template name="other"/></xsl:otherwise>
	</xsl:choose>
</xsl:template>
<xsl:template name="match_1">
<xsl:for-each select="//data">
<ul><li id="img"><a href="{@homepage}" target="{@target}"><img src="{@userface}"/></a></li>
<li id="info"><b>昵称：</b><a href="{@homepage}" target="{@target}"><xsl:value-of select="@username"/></a>，<xsl:value-of select="@userinfo"/></li><li id="time">发表于：<xsl:value-of select="@addtime"/></li><li id="note"><xsl:value-of select="@content"/></li>
</ul>
</xsl:for-each>
</xsl:template>
<xsl:template name="match_2">
<xsl:for-each select="//data">
<ul><li id="info2"><em><a href="{@homepage}" target="{@target}"><xsl:value-of select="@username"/></a>，<xsl:value-of select="@userinfo"/></em><xsl:value-of select="@addtime"/></li>
<li id="note2"><xsl:value-of select="@content"/></li>
</ul>
</xsl:for-each>
</xsl:template>
<xsl:template name="match_3">
<xsl:for-each select="//data">
<ul>
<li id="img"><em><a href="{@homepage}" target="{@target}"><img src="{@userface}"/></a></em><a href="{@homepage}" target="{@target}"><xsl:value-of select="@username"/></a></li>
<li id="note"><xsl:value-of select="@content"/></li>
</ul>
</xsl:for-each>
</xsl:template>
<xsl:template name="match_4">
<xsl:for-each select="//data">
<ul>
<li id="img1"><em><a href="{@homepage}" target="{@target}"><img src="{@userface}"/></a></em>ID：<a href="{@homepage}" target="{@target}"><xsl:value-of select="@userid"/></a></li>
<li id="info1"><em><a href="{@homepage}" target="{@target}"><xsl:value-of select="@username"/></a>，<xsl:value-of select="@userinfo"/></em><xsl:value-of select="@addtime"/></li>
<li id="note3"><xsl:value-of select="@content"/></li>
</ul>
</xsl:for-each>
</xsl:template>
<xsl:template name="match_5">
<xsl:for-each select="//data">
<li id="dot1"><xsl:value-of select="@content"/></li>
</xsl:for-each>
</xsl:template>
<xsl:template name="match_6">
<xsl:for-each select="//data">
<ul>
<li id="img"><em><a href="{@homepage}" target="{@target}"><img src="{@userface}"/></a><br />ID：<a href="{@homepage}" target="{@target}"><xsl:value-of select="@userid"/></a></em></li>
<li id="info"><em><xsl:value-of select="@username"/> 问：<xsl:value-of select="@title"/></em><a onclick="reply('{@id}','reply',5,'回复咨询');">回复</a> | <a onclick="ctrlfile('2','{@id}','','删除咨询');">删除</a>　<xsl:value-of select="@addtime"/></li>
<li id="note"><em><xsl:value-of select="@content"/></em>
<xsl:if test="@reply='1'"><span>回复：<xsl:value-of select="@reptime"/><br /><font id="fontld"><xsl:value-of select="@comment"/></font></span></xsl:if></li>
</ul>
</xsl:for-each>
</xsl:template>
<xsl:template name="match_7">
<xsl:for-each select="//data">
<ul><li id="img"><a href="{@homepage}" target="{@target}"><img src="{@userface}"/></a></li>
<li id="tit"><a href="{@homepage}" target="{@target}"><xsl:value-of select="@username"/></a>问：<xsl:value-of select="@title"/> [<xsl:value-of select="@addtime"/>]</li><li id="con"><xsl:value-of select="@content"/></li>
<xsl:if test="@reply='1'">
<li id="rpl">回复：<xsl:value-of select="@reptime"/><br /><font id="fontld"><xsl:value-of select="@comment"/></font></li>
</xsl:if>
</ul>
</xsl:for-each>
</xsl:template>
<xsl:template name="match_8">
<xsl:for-each select="//data">
<ul>
<li id="info"><em>解答者：<a href="{@homepage}" target="{@target}"><xsl:value-of select="@username"/>,<xsl:value-of select="@userinfo"/></a></em><a onclick="ctrlask('2','{@parentid}','{@id}','删除答案');">删除</a> | <a onclick="ctrlask('3','{@parentid}','{@id}','审核答案');">审核</a> | <a onclick="ctrlask('4','{@parentid}','{@id}','最佳答案');">最佳</a>　时间：<xsl:value-of select="@addtime"/></li>
<li id="note"><xsl:choose><xsl:when test="@isbest='1'"><em id="isbest"><xsl:value-of select="@content"/></em></xsl:when><xsl:otherwise><em><xsl:value-of select="@content"/></em></xsl:otherwise></xsl:choose></li></ul>
</xsl:for-each>
</xsl:template>
<xsl:template name="match_9">
<xsl:for-each select="//data">
<ul><li id="info"><em><input type="checkbox" name="id" value="{@id}"/> <a href="{@homepage}" target="{@target}"><xsl:value-of select="@username"/></a>，<xsl:value-of select="@userinfo"/></em><xsl:value-of select="@addtime"/></li>
<li id="note"><em><xsl:value-of select="@content"/></em></li>
</ul>
</xsl:for-each>
</xsl:template>
<xsl:template name="other">
</xsl:template>
</xsl:stylesheet>