﻿<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output omit-xml-declaration="yes"  indent="yes" version="6.0"/>
<!--
	Copyright (C) 2004,2009 Nslove.Net. All rights reserved.
	Written by Nslove.Net Nslove
	Web: http://www.Nslove.Com/
	Email: Info@Nslove.Com
	-->
<xsl:template match="/">
	<xsl:choose>
		<xsl:when test="xml/@action='1'"><xsl:call-template name="match_1"/></xsl:when>
		<xsl:when test="xml/@action='2'"><xsl:call-template name="match_2"/></xsl:when>
		<xsl:when test="xml/@action='3'"><xsl:call-template name="match_3"/></xsl:when>
		<xsl:when test="xml/@action='4'"><xsl:call-template name="match_4"/></xsl:when>
		<xsl:when test="xml/@action='5'"><xsl:call-template name="match_5"/></xsl:when>
		<xsl:when test="xml/@action='6'"><xsl:call-template name="match_6"/></xsl:when>
		<xsl:otherwise><xsl:call-template name="other"/></xsl:otherwise>
	</xsl:choose>
</xsl:template>
<xsl:template name="match_1">
<xsl:for-each select="//data">
<li id="dot1"><span id="tts"><xsl:value-of select="@title"/></span>
<xsl:choose><xsl:when test="@ispay='0'"><font id="fontor">未支付</font></xsl:when><xsl:when test="@checked='0'"><font id="fontbl">等待审核</font></xsl:when><xsl:when test="@overtime&lt;'0'"><font id="fontls">已到期</font></xsl:when><xsl:otherwise><font id="fontgn">正常使用</font></xsl:otherwise></xsl:choose></li>
</xsl:for-each>
</xsl:template>
<xsl:template name="match_2">
<xsl:for-each select="//data">
<div class="orders">
<ul><li><b id="tc2"><xsl:value-of select="@title"/>：</b>平均 <b id="fontls"><xsl:value-of select="@equally"/></b> 金币/天</li><li>原价<b id="fontls"><strike><xsl:value-of select="@costs"/></strike></b>金币，优惠价<b id="fontls"><xsl:value-of select="@prices"/></b>金币，现在购买，<b id="fontls">赠送</b></li><li><xsl:value-of select="@stars"/>天明星榜（价值<b id="fontls"><xsl:value-of select="@stvalue"/></b>金币）<xsl:if test="@prvalue!='0'"> + <xsl:value-of select="@priority"/>天排名提前（价值<b id="fontls"><xsl:value-of select="@prvalue"/></b>金币）</xsl:if></li></ul><ul id="torder"><a onclick="diamond('{@id}');"><img src="/images/service/buy1.gif"/></a></ul></div>
</xsl:for-each>
</xsl:template>
<xsl:template name="match_3">
<xsl:for-each select="//data">
<li><span><label for="id_{@id}"><input type="radio" id="id_{@id}" name="id" value="{@id}"/> <b id="tc1"><xsl:value-of select="@title"/></b></label></span><em>优惠价 <b id="fontls"><xsl:value-of select="@prices"/></b> 个</em><em>平均 <b id="fontls"><xsl:value-of select="@equally"/></b> 个/天</em>（原价 <strike><xsl:value-of select="@costs"/></strike> 个）</li>
</xsl:for-each>
</xsl:template>
<xsl:template name="match_4">
<xsl:for-each select="//data">
<div class="orders">
<ul><li id="tsize"><b id="tc2"><xsl:value-of select="@title"/>：</b><xsl:choose><xsl:when test="@numbers='0'">平均 <b id="fontls"><xsl:value-of select="@equally"/></b> 金币/天</xsl:when><xsl:otherwise>（<b id="fontls"><xsl:value-of select="@prices"/></b>金币，<b id="fontls"><xsl:value-of select="@numbers"/></b>次，有效期<b id="fontls"><xsl:value-of select="@specs"/></b>天）</xsl:otherwise></xsl:choose></li><li>原价<b id="fontls"><strike><xsl:value-of select="@costs"/></strike></b>金币，优惠价<b id="fontls"><xsl:value-of select="@prices"/></b>金币<xsl:choose><xsl:when test="@numbers='0'">，即可让所有心仪异性免费看您的来信</xsl:when><xsl:otherwise>（合每次仅需 <b id="fontls"><xsl:value-of select="@equally"/></b> 金币）可为对方贴邮票 <b id="fontls"><xsl:value-of select="@numbers"/></b> 次 您在发信时可以选择使用该服务或不使用，自由您掌控。<br /><font id="fontrd">注：本服务自购买之日起有效期为<xsl:value-of select="@specs"/>天，您须在<xsl:value-of select="@specs"/>天内将发信次数全部用完，过期未用次数将作废。</font></xsl:otherwise></xsl:choose></li></ul><ul id="torder"><a onclick="send('{@id}');"><img src="/images/monthly/buy1.jpg"/></a></ul></div>
</xsl:for-each>
</xsl:template>
<xsl:template name="match_5">
<xsl:for-each select="//data">
<div class="orders">
<ul><li><b id="tc3"><xsl:value-of select="@title"/>：</b>平均 <b id="fontls"><xsl:value-of select="@equally"/></b> 金币/天</li><li>原价<b id="fontls"><strike><xsl:value-of select="@costs"/></strike></b>金币，优惠价<b id="fontls"><xsl:value-of select="@prices"/></b>金币</li><li><xsl:if test="@prvalue!='0'">现在购买，另外 <font id="fontls">赠送<xsl:value-of select="@priority"/></font> 天排名提前（价值<b id="fontls"><xsl:value-of select="@prvalue"/></b>金币）</xsl:if></li></ul><ul id="torder"><a onclick="read('{@id}');"><img src="/images/monthly/buy2.gif"/></a></ul></div>
</xsl:for-each>
</xsl:template>
<xsl:template name="match_6">
<xsl:for-each select="//data">
<div class="golder">
<ul><li id="tit"><xsl:value-of select="@title"/>：</li><li id="pc">原价：<strike><xsl:value-of select="@costs"/></strike> 个</li><li>特惠价： <b id="fontls"><xsl:value-of select="@prices"/></b> 个</li></ul><ul id="torder"><a onclick="gold('{@id}');"><img src="/images/service/buy2.jpg"/></a></ul></div>
</xsl:for-each>
</xsl:template>
<xsl:template name="other"><font id="fontbl">暂无申请记录</font></xsl:template>
</xsl:stylesheet>