﻿<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output omit-xml-declaration="yes"/>
<!--
	Copyright (C) 2004,2009 Nslove.Net. All rights reserved.
	Written by Nslove.Net Nslove
	Web: http://www.Nslove.Com/
	Email: Info@Nslove.Com
	-->
<xsl:template match="/">
	<xsl:choose>
		<xsl:when test="//data/@action='1'"><xsl:call-template name="showpage_1"/></xsl:when>
		<xsl:when test="//data/@action='2'"><xsl:call-template name="showpage_2"/></xsl:when>
		<xsl:otherwise><xsl:call-template name="nopage"/></xsl:otherwise>
	</xsl:choose>
</xsl:template>
<xsl:template name="showpage_1">
<div class="showpage">
	<span>页次：<xsl:value-of select="//data/@page"/>&#160;/&#160;<xsl:value-of select="//data/@pagecount"/>&#160;页&#160;<xsl:value-of select="//data/@maxpage"/>&#160;条/每页&#160;&#160;共：<xsl:value-of select="//data/@total"/>&#160;条</span>
<ul>
	<li id="img"><a href="{//data/@url}page=1"><img src="/images/page/first.gif" border="0" title="首页"/></a></li>
	<li id="img"><a href="{//data/@url}page={//data/@prevpage}"><img src="/images/page/prev.gif" border="0" title="上五页"/></a></li>
	<xsl:for-each select="//pagelist">
	<xsl:choose>
		<xsl:when test="@p=//data/@page"><li id="cur"><a href="{//data/@url}page={@p}"><xsl:value-of select="@p"/></a></li></xsl:when>
		<xsl:otherwise><li><a href="{//data/@url}page={@p}"><xsl:value-of select="@p"/></a></li></xsl:otherwise>
	</xsl:choose>
	</xsl:for-each>
<li id="img"><a href="{//data/@url}page={//data/@nextpage}"><img src="/images/page/next.gif" border="0" title="下五页"/></a></li>
<li id="img"><a href="{//data/@url}page={//data/@pagecount}"><img src="/images/page/last.gif" border="0" title="尾页"/></a></li>
</ul>
</div>
</xsl:template>
<xsl:template name="showpage_2">
<div class="showpage">
<ul>
	<li id="img"><a href="{//data/@url}page=1"><img src="/images/page/first.gif" border="0" title="首页"/></a></li>
	<li id="img"><a href="{//data/@url}page={//data/@prevpage}"><img src="/images/page/prev.gif" border="0" title="上五页"/></a></li>
	<xsl:for-each select="//pagelist">
	<xsl:choose>
		<xsl:when test="@p=//data/@page"><li id="cur"><a href="{//data/@url}page={@p}"><xsl:value-of select="@p"/></a></li></xsl:when>
		<xsl:otherwise><li><a href="{//data/@url}page={@p}"><xsl:value-of select="@p"/></a></li></xsl:otherwise>
	</xsl:choose>
	</xsl:for-each>
<li id="img"><a href="{//data/@url}page={//data/@nextpage}"><img src="/images/page/next.gif" border="0" title="下五页"/></a></li>
<li id="img"><a href="{//data/@url}page={//data/@pagecount}"><img src="/images/page/last.gif" border="0" title="尾页"/></a></li>
</ul>
</div>
</xsl:template>
<xsl:template name="nopage">
<div class="showpage"> </div>
</xsl:template>
</xsl:stylesheet>