﻿<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output omit-xml-declaration="yes"  indent="yes" version="6.0"/>
<!--
	Copyright (C) 2004,2009 Nslove.Net. All rights reserved.
	Written by Nslove.Net Nslove
	Web: http://www.Nslove.Com/
	Email: Info@Nslove.Com
	-->
<xsl:template match="/">
	<xsl:choose>
		<xsl:when test="xml/@action='1'"><xsl:call-template name="match_1"/></xsl:when>
		<xsl:when test="xml/@action='2'"><xsl:call-template name="match_2"/></xsl:when>
		<xsl:when test="xml/@action='3'"><xsl:call-template name="match_3"/></xsl:when>
		<xsl:when test="xml/@action='4'"><xsl:call-template name="match_4"/></xsl:when>
		<xsl:when test="xml/@action='5'"><xsl:call-template name="match_5"/></xsl:when>
		<xsl:when test="xml/@action='6'"><xsl:call-template name="match_6"/></xsl:when>
		<xsl:when test="xml/@action='7'"><xsl:call-template name="match_7"/></xsl:when>
		<xsl:otherwise><xsl:call-template name="other"/></xsl:otherwise>
	</xsl:choose>
</xsl:template>
<xsl:template name="match_1">
<xsl:for-each select="//data">
<ul>
<li class="frm30"><input type="checkbox" name="id" value="{@id}"/></li>
<li class="frm180"><a href="{@link1}" target="{@target}"><xsl:value-of select="@title"/></a></li>
<li class="frm70" id="txtc"><xsl:value-of select="@sortname"/></li>
<li class="frm55" id="txtc"><xsl:value-of select="@views"/></li>
<li class="frm90" id="txtc"><xsl:value-of select="@addtime"/></li>
<li class="frm70"><xsl:choose><xsl:when test="@checked='1'"><a href="?action=add&amp;id={@id}">编辑</a> <a href="?action=upload">上传</a></xsl:when><xsl:otherwise><font id="fontor">审核中</font></xsl:otherwise></xsl:choose></li>
</ul>
</xsl:for-each>
</xsl:template>
<xsl:template name="match_2">
<xsl:for-each select="//data">
<ul id="ttp"><li id="img"><a href="{@link1}" target="{@target}"><img src="{@filesview}"/></a></li><li id="txt"><xsl:value-of select="@title"/></li></ul>
</xsl:for-each>
</xsl:template>
<xsl:template name="match_3">
<xsl:for-each select="//data">
<li id="dot1"><a href="{@link1}" target="{@target}"><xsl:value-of select="@title"/></a></li>
</xsl:for-each>
</xsl:template>
<xsl:template name="match_4">
<xsl:for-each select="//data">
<ul><li id="img"><a href="{@link1}" target="{@target}"><img src="{@filesview}"/></a></li><li id="txt"><xsl:value-of select="@content"/></li></ul>
</xsl:for-each>
</xsl:template>
<xsl:template name="match_5">
<xsl:for-each select="//data">
<ul><li id="img"><a href="{@link1}" target="{@target}"><img src="{@filesview}"/></a></li><li id="tit"><a href="{@link1}" target="{@target}" class="ft_{@sortid}"><xsl:value-of select="@title"/></a></li><li id="name"><xsl:value-of select="@username"/> &amp; <xsl:value-of select="@fusername"/></li><li id="txt"><em><xsl:value-of select="@content"/></em></li></ul>
</xsl:for-each>
</xsl:template>
<xsl:template name="match_6">
<xsl:for-each select="//data">
<li id="img1"><a href="{@link1}" target="{@target}"><img src="{@filesview}"/></a></li>
</xsl:for-each>
</xsl:template>
<xsl:template name="match_7">
<xsl:for-each select="//data">
<dt><em><xsl:value-of select="@title"/></em><xsl:value-of select="@addtime"/></dt><dd><xsl:value-of select="@content"/></dd>
</xsl:for-each>
</xsl:template>
<xsl:template name="other">
</xsl:template>
</xsl:stylesheet>