﻿<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output omit-xml-declaration="yes"  indent="yes" version="6.0"/>
<!--
	Copyright (C) 2004,2009 Nslove.Net. All rights reserved.
	Written by Nslove.Net Nslove
	Web: http://www.Nslove.Com/
	Email: Info@Nslove.Com
	-->
<xsl:template match="/">
	<xsl:choose>
		<xsl:when test="xml/@action='1'"><xsl:call-template name="match_1"/></xsl:when>
		<xsl:when test="xml/@action='2'"><xsl:call-template name="match_2"/></xsl:when>
		<xsl:when test="xml/@action='3'"><xsl:call-template name="match_3"/></xsl:when>
		<xsl:when test="xml/@action='4'"><xsl:call-template name="match_4"/></xsl:when>
		<xsl:when test="xml/@action='5'"><xsl:call-template name="match_5"/></xsl:when>
		<xsl:when test="xml/@action='6'"><xsl:call-template name="match_6"/></xsl:when>
		<xsl:when test="xml/@action='7'"><xsl:call-template name="match_7"/></xsl:when>
		<xsl:otherwise><xsl:call-template name="other"/></xsl:otherwise>
	</xsl:choose>
</xsl:template>
<xsl:template name="match_1">
<xsl:for-each select="//data">
<li id="dot1"><a href="read.asp?rootid={@rootid}&amp;id={@id}" target="{@target}"><xsl:value-of select="@title"/></a> | <a href="{@homepage}" target="{@target}"><xsl:value-of select="@username"/></a></li>
</xsl:for-each>
</xsl:template>
<xsl:template name="match_2">
<xsl:for-each select="//data">
<li id="dot1"><a href="/group/read.asp?rootid={@rootid}&amp;id={@id}" target="{@target}"><xsl:value-of select="@title"/></a></li>
</xsl:for-each>
</xsl:template>
<xsl:template name="match_3">
<xsl:for-each select="//data">
<dt><xsl:value-of select="@title"/></dt>
<dd><xsl:value-of select="@content"/><a href="read.asp?rootid={@rootid}&amp;id={@id}" target="{@target}">[详情]</a></dd>
</xsl:for-each>
</xsl:template>
<xsl:template name="match_4">
<xsl:for-each select="//data"><ul>
<li id="tit"><a href="read.asp?rootid={@rootid}&amp;id={@id}" target="{@target}"><xsl:value-of select="@title"/></a> | <a href="{@homepage}" target="{@target}"><xsl:value-of select="@username"/></a></li><li id="mark">回复 <font id="fontls"><xsl:value-of select="@remark"/></font> / 阅读 <font id="fontls"><xsl:value-of select="@views"/></font></li>
</ul>
</xsl:for-each>
</xsl:template>
<xsl:template name="match_5">
<xsl:for-each select="//data">
<li id="tit"><a href="/group/read.asp?rootid={@rootid}&amp;id={@id}" target="{@target}"><xsl:value-of select="@title"/></a></li><li id="time"><xsl:value-of select="@addtime"/></li>
</xsl:for-each>
</xsl:template>
<xsl:template name="match_6">
<xsl:for-each select="//data"><ul><li id="dot{@istop}"><a href="/group/read.asp?rootid={@rootid}&amp;id={@id}" target="{@target}"><xsl:value-of select="@title"/></a><xsl:if test="@ishot='1'">　<img src="/images/group/jh.gif"/></xsl:if></li><li id="txt"><a href="/group/topic.asp?rootid={@rootid}&amp;boardid={@boardid}"><xsl:value-of select="@boardname"/></a></li><li id="name"><a href="{@homepage}" target="{@target}"><xsl:value-of select="@username"/></a></li><li id="txt"><b><xsl:value-of select="@remark"/></b> / <xsl:value-of select="@views"/></li><li id="last"><xsl:value-of select="@lasttime"/>｜<a href="{@homepage1}" target="{@target}"><xsl:value-of select="@lastname"/></a></li></ul>
</xsl:for-each>
</xsl:template>
<xsl:template name="match_7">
<xsl:for-each select="//data">
<ul><xsl:if test="@parentid='0'"><li id="tit"><span><i></i><xsl:if test="@istop='1'"><i id="istop"></i></xsl:if><xsl:if test="@ishot='1'"><i id="ishot"></i></xsl:if>标题：<xsl:value-of select="@title"/></span><font id="fontgy">阅读 <b id="fontrd"><xsl:value-of select="@views"/></b> 次　回贴 <b id="fontrd"><xsl:value-of select="@remark"/></b> 条</font></li></xsl:if>
<li id="info"><a href="{@homepage}" target="{@target}"><img src="{@userface}"/><br /><xsl:value-of select="@username"/></a></li>
<li id="note"><div class="notebox"><dl><dt id="time"><em>发表时间：<xsl:value-of select="@addtime"/></em><a href="/complain/index.asp?userid={@userid}">举报</a>　<xsl:choose><xsl:when test="@datanum='0'"><font id="fontrd">[ 楼主 ]</font></xsl:when><xsl:otherwise><font id="fontgy">[ <b id="fontrd"><xsl:value-of select="@datanum"/></b> 楼 ]</font></xsl:otherwise></xsl:choose>　<b><a href="#top">TOP</a></b></dt><dd><xsl:value-of select="@content"/></dd><xsl:if test="@parentid='0'"><dd id="fav"><em id="fav"><a onclick="bookmarkit();return false;">收藏</a></em><em id="cpy"><a onclick="recommend();">分享</a></em></dd></xsl:if><dd id="tool"><em id="edit"><a href="/users/group.asp?action=post&amp;rootid={@rootid}&amp;parentid={@parentid}&amp;id={@id}" target="_blank">编辑</a></em><em id="dele"><a onclick="actctrl('11','{@rootid}','{@id}');">删除</a></em><xsl:if test="@parentid='0'"><em id="stop"><a onclick="actctrl('12','{@rootid}','{@id}');">置顶</a></em><em id="shot"><a onclick="actctrl('13','{@rootid}','{@id}');">精华</a></em></xsl:if></dd></dl></div></li>
</ul>
</xsl:for-each>
</xsl:template>
<xsl:template name="other">
</xsl:template>
</xsl:stylesheet>