﻿<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output omit-xml-declaration="yes"  indent="yes" version="6.0"/>
<!--
	Copyright (C) 2004,2009 Nslove.Net. All rights reserved.
	Written by Nslove.Net Nslove
	Web: http://www.Nslove.Com/
	Email: Info@Nslove.Com
	-->
<xsl:template match="/">
	<xsl:choose>
		<xsl:when test="xml/@action='1'"><xsl:call-template name="match_1"/></xsl:when>
		<xsl:when test="xml/@action='2'"><xsl:call-template name="match_2"/></xsl:when>
		<xsl:when test="xml/@action='3'"><xsl:call-template name="match_3"/></xsl:when>
		<xsl:when test="xml/@action='4'"><xsl:call-template name="match_4"/></xsl:when>
		<xsl:when test="xml/@action='5'"><xsl:call-template name="match_5"/></xsl:when>
		<xsl:otherwise><xsl:call-template name="other"/></xsl:otherwise>
	</xsl:choose>
</xsl:template>
<xsl:template name="match_1">
<xsl:for-each select="//data">
<ul>
<li id="tit"><span><input type="checkbox" name="id" value="{@id}"/> <font id="fontls">[<xsl:value-of select="@address"/>]</font> <a href="{@link1}" target="{@target}"><xsl:value-of select="@title"/></a></span>已有 <font id="fontls"><b><xsl:value-of select="@signup"/></b></font> 人报名</li>
<li id="img"><a href="{@link1}" target="{@target}"><xsl:choose><xsl:when test="@filesview=''"><img src="/images/nophoto.gif"/></xsl:when><xsl:otherwise><img src="{@filesview}"/></xsl:otherwise></xsl:choose></a></li>
<li id="date"><b>结束日期：</b><xsl:value-of select="@addtime"/></li><li id="zone"><b>试客类型：</b><xsl:value-of select="@sortname"/></li><li id="note"><b>试客简介：</b><xsl:value-of select="@content"/></li>
</ul>
</xsl:for-each>
</xsl:template>
<xsl:template name="match_2">
<xsl:for-each select="//data">
<xsl:choose>
<xsl:when test="position()='1'">
<li id="tit"><a href="{@link1}" target="{@target}"><xsl:value-of select="@title"/></a></li>
<li id="note"><xsl:value-of select="@content"/></li>
</xsl:when><xsl:otherwise>
<li id="dot1">[推荐]<a href="{@link1}" target="{@target}"><xsl:value-of select="@title"/></a></li></xsl:otherwise></xsl:choose>
</xsl:for-each>
</xsl:template>
<xsl:template name="match_3">
<xsl:for-each select="//data">
<li id="dot1"><a href="{@link1}" target="{@target}"><xsl:value-of select="@title"/></a></li>
</xsl:for-each>
</xsl:template>
<xsl:template name="match_4">
<xsl:for-each select="//data">
<ul><li id="img"><xsl:choose><xsl:when test="@isphoto='0'"><img src="/images/nophoto.gif"/></xsl:when><xsl:otherwise><img src="{@filesview}"/></xsl:otherwise></xsl:choose></li><li id="txt"><a href="{@link1}" target="{@target}"><xsl:value-of select="@title"/></a></li><li id="note"><xsl:value-of select="@content"/></li><li id="bot">时间：<font id="fontbl"><xsl:value-of select="@addtime"/></font>　截止：<font id="fontrd"><xsl:value-of select="@overtime"/></font>　人气：<b id="fontls"><xsl:value-of select="@views"/></b>　已报名：<b id="fontls"><xsl:value-of select="@signup"/></b> 人</li></ul>
</xsl:for-each>
</xsl:template>
<xsl:template name="match_5">
<xsl:for-each select="//data">
<ul>
<li id="img"><xsl:choose><xsl:when test="@filesview=''"><img src="/images/nophoto.gif"/></xsl:when><xsl:otherwise><a href="{@link1}" target="{@target}"><img src="{@filesview}"/></a></xsl:otherwise></xsl:choose></li>
<li><a href="{@link1}" target="{@target}"><font id="fontls"><xsl:value-of select="@title"/></font></a></li>
<li><b>结束日期：</b><font id="fontbl"><xsl:value-of select="@overtime"/></font></li>
<li><b>产品数量：</b><xsl:value-of select="@maxnum"/></li>
<li><b>报名人数：</b><font id="fontls"><xsl:value-of select="@signup"/></font> 人</li>
<li id="tool"><em><b>试客状态：</b><xsl:choose><xsl:when test="@isover='1'"><font id="fontrd">已结束</font></xsl:when><xsl:when test="@checked='0'">审核中</xsl:when><xsl:otherwise><font id="fontgn">已审核</font></xsl:otherwise></xsl:choose></em><a href="?action=addty&amp;id={@id}">修改信息</a> | <a href="?action=upload&amp;id={@id}">上传照片</a> | <a href="?action=join&amp;id={@id}">报名管理</a> | <a onclick="ctrlfile('2','{@id}','','结束试客');">结束试客</a></li>
</ul>
</xsl:for-each>
</xsl:template>
<xsl:template name="other">
</xsl:template>
</xsl:stylesheet>